/*
 * Decompiled with CFR 0.152.
 */
package controllers.equipment;

import fr.aquasys.daeau.materiel.domain.Input.EquipmentInput$;
import fr.aquasys.daeau.materiel.domain.Input.EquipmentTypeInput;
import fr.aquasys.daeau.materiel.domain.Input.EquipmentTypeInput$;
import fr.aquasys.daeau.materiel.domain.Input.EquipmentWithMaterielsInput;
import fr.aquasys.daeau.materiel.domain.Input.EquipmentWithMaterielsInput$;
import fr.aquasys.daeau.materiel.domain.model.MaterielType$;
import fr.aquasys.daeau.materiel.domain.model.equipment.Equipment;
import fr.aquasys.daeau.materiel.domain.model.equipment.Equipment$;
import fr.aquasys.daeau.materiel.domain.output.EquipmentTypeOutput;
import fr.aquasys.daeau.materiel.domain.output.EquipmentTypeOutput$;
import fr.aquasys.daeau.materiel.domain.output.EquipmentWithMaterielsOutput;
import fr.aquasys.daeau.materiel.domain.output.EquipmentWithMaterielsOutput$;
import fr.aquasys.daeau.materiel.itf.AuthorizationMaterielDao;
import fr.aquasys.daeau.materiel.itf.equipment.EquipmentTypeDao;
import fr.aquasys.daeau.materiel.itf.equipment.MaterielEquipmentDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import utils.CommonReadUtil$;
import utils.MaterielUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\f\u0019\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"\u0002(\u0001\t\u0003y\u0005\"\u00021\u0001\t\u0003\t\u0007bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\n\u00033\u0001!\u0019!C\u0001\u00037A\u0001\"a\t\u0001A\u0003%\u0011Q\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0011\"!\u0010\u0001\u0005\u0004%\t!a\u0010\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u0003Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a+\u0001\t\u0003\tiKA\nFcVL\u0007/\\3oi\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u001a5\u0005IQ-];ja6,g\u000e\u001e\u0006\u00027\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"AJ\u0018\u000e\u0003\u001dR!\u0001K\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0003U-\n\u0001B]1cE&$X.\u001d\u0006\u0003Y5\nq!Y9vCNL8OC\u0001/\u0003\t1'/\u0003\u00021O\t9Aj\\4Vi&d\u0017\u0001F7bi\u0016\u0014\u0018.\u001a7FcVL\u0007/\\3oi\u0012\u000bw\u000e\u0005\u00024w5\tAG\u0003\u0002\u001ak)\u0011agN\u0001\u0004SR4'B\u0001\u001d:\u0003!i\u0017\r^3sS\u0016d'B\u0001\u001e,\u0003\u0015!\u0017-Z1v\u0013\taDG\u0001\u000bNCR,'/[3m\u000bF,\u0018\u000e]7f]R$\u0015m\\\u0001\u0011KF,\u0018\u000e]7f]R$\u0016\u0010]3EC>\u0004\"aM \n\u0005\u0001#$\u0001E#rk&\u0004X.\u001a8u)f\u0004X\rR1p\u0003\u001d)8/\u001a:EC>\u0004\"aQ$\u000e\u0003\u0011S!AN#\u000b\u0005\u0019K\u0014\u0001B;tKJL!\u0001\u0013#\u0003\u000fU\u001bXM\u001d#b_\u0006A\u0012-\u001e;i_JL'0\u0019;j_:l\u0015\r^3sS\u0016dG)Y8\u0011\u0005-cU\"A\u001b\n\u00055+$\u0001G!vi\"|'/\u001b>bi&|g.T1uKJLW\r\u001c#b_\u00061A(\u001b8jiz\"b\u0001\u0015*T)V3\u0006CA)\u0001\u001b\u0005A\u0002\"\u0002\u0013\u0007\u0001\u0004)\u0003\"B\u0019\u0007\u0001\u0004\u0011\u0004\"B\u001f\u0007\u0001\u0004q\u0004\"B!\u0007\u0001\u0004\u0011\u0005\"B%\u0007\u0001\u0004Q\u0005F\u0001\u0004Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0004j]*,7\r\u001e\u0006\u0002;\u0006)!.\u0019<bq&\u0011qL\u0017\u0002\u0007\u0013:TWm\u0019;\u0002\r\u001d,G/\u00117m)\u001d\u0011Wn_A\u0004\u0003\u0017\u0001\"a\u00196\u000f\u0005\u0011D\u0007CA3!\u001b\u00051'BA4\u001d\u0003\u0019a$o\\8u}%\u0011\u0011\u000eI\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jA!)an\u0002a\u0001_\u00069Q.Z:tC\u001e,\u0007C\u00019z\u001b\u0005\t(B\u0001:t\u0003\u0011Q7o\u001c8\u000b\u0005Q,\u0018\u0001\u00027jENT!A^<\u0002\u0007\u0005\u0004\u0018NC\u0001y\u0003\u0011\u0001H.Y=\n\u0005i\f(a\u0002&t-\u0006dW/\u001a\u0005\u0006y\u001e\u0001\r!`\u0001\bQ\u0016\fG-\u001a:t!\u0015\u0019gPYA\u0001\u0013\tyHNA\u0002NCB\u00042aHA\u0002\u0013\r\t)\u0001\t\u0002\u0004\u0003:L\bBBA\u0005\u000f\u0001\u0007!-\u0001\u0004n_\u0012,H.\u001a\u0005\u0006\r\u001e\u0001\rAY\u0001\u0004O\u0016$H#\u00032\u0002\u0012\u0005M\u0011QCA\f\u0011\u0015q\u0007\u00021\u0001p\u0011\u0015a\b\u00021\u0001~\u0011\u0019\tI\u0001\u0003a\u0001E\")a\t\u0003a\u0001E\u0006\u00012/\u001a:jC2tU/\u001c2feJ+\u0017\rZ\u000b\u0003\u0003;\u0001B\u0001]A\u0010E&\u0019\u0011\u0011E9\u0003\u000bI+\u0017\rZ:\u0002#M,'/[1m\u001dVl'-\u001a:SK\u0006$\u0007%A\thKR\u0014\u0015pU3sS\u0006dg*^7cKJ$\u0012BYA\u0015\u0003W\ti#a\f\t\u000b9\\\u0001\u0019A8\t\u000bq\\\u0001\u0019A?\t\r\u0005%1\u00021\u0001c\u0011\u001515\u00021\u0001c\u0003\u0019\u0019'/Z1uKRI!-!\u000e\u00028\u0005e\u00121\b\u0005\u0006]2\u0001\ra\u001c\u0005\u0006y2\u0001\r! \u0005\u0007\u0003\u0013a\u0001\u0019\u00012\t\u000b\u0019c\u0001\u0019\u00012\u0002\u001b\u0011,\b\u000f\\5dCR,'+Z1e+\t\t\t\u0005E\u0003q\u0003?\t\u0019\u0005\u0005\u0005 \u0003\u000b\u0012\u0017\u0011JA(\u0013\r\t9\u0005\t\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007}\tY%C\u0002\u0002N\u0001\u00121!\u00138u!\u0015y\u0012\u0011KA%\u0013\r\t\u0019\u0006\t\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001d\u0011,\b\u000f\\5dCR,'+Z1eA\u0005IA-\u001e9mS\u000e\fG/\u001a\u000b\nE\u0006m\u0013QLA0\u0003CBQA\\\bA\u0002=DQ\u0001`\bA\u0002uDa!!\u0003\u0010\u0001\u0004\u0011\u0007\"\u0002$\u0010\u0001\u0004\u0011\u0017A\u00023fY\u0016$X\rF\u0005c\u0003O\nI'a\u001b\u0002n!)a\u000e\u0005a\u0001_\")A\u0010\u0005a\u0001{\"1\u0011\u0011\u0002\tA\u0002\tDQA\u0012\tA\u0002\t\fa!\u001e9eCR,G#\u00032\u0002t\u0005U\u0014qOA=\u0011\u0015q\u0017\u00031\u0001p\u0011\u0015a\u0018\u00031\u0001~\u0011\u0019\tI!\u0005a\u0001E\")a)\u0005a\u0001E\u0006Aq-\u001a;UsB,7\u000fF\u0005c\u0003\u007f\n\t)a!\u0002\u0006\")aN\u0005a\u0001_\")AP\u0005a\u0001{\"1\u0011\u0011\u0002\nA\u0002\tDQA\u0012\nA\u0002\t\fqaZ3u)f\u0004X\rF\u0005c\u0003\u0017\u000bi)a$\u0002\u0012\")an\u0005a\u0001_\")Ap\u0005a\u0001{\"1\u0011\u0011B\nA\u0002\tDQAR\nA\u0002\t\f!\u0002Z3mKR,G+\u001f9f)%\u0011\u0017qSAM\u00037\u000bi\nC\u0003o)\u0001\u0007q\u000eC\u0003})\u0001\u0007Q\u0010\u0003\u0004\u0002\nQ\u0001\rA\u0019\u0005\u0006\rR\u0001\rAY\u0001\u000bkB$\u0017\r^3UsB,G#\u00032\u0002$\u0006\u0015\u0016qUAU\u0011\u0015qW\u00031\u0001p\u0011\u0015aX\u00031\u0001~\u0011\u0019\tI!\u0006a\u0001E\")a)\u0006a\u0001E\u0006Q1M]3bi\u0016$\u0016\u0010]3\u0015\u0013\t\fy+!-\u00024\u0006U\u0006\"\u00028\u0017\u0001\u0004y\u0007\"\u0002?\u0017\u0001\u0004i\bBBA\u0005-\u0001\u0007!\rC\u0003G-\u0001\u0007!\r")
public class EquipmentController {
    private final LogUtil logUtil;
    private final MaterielEquipmentDao materielEquipmentDao;
    private final EquipmentTypeDao equipmentTypeDao;
    private final UserDao userDao;
    private final AuthorizationMaterielDao authorizationMaterielDao;
    private final Reads<String> serialNumberRead;
    private final Reads<Tuple3<String, Object, Option<Object>>> duplicateRead;

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.userReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate entry for get all equipments : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)userLogin -> {
            Option option = $this.userDao.get(userLogin);
            if (option instanceof Some) {
                Some some;
                String string;
                Some some2 = (Some)option;
                User user = (User)some2.value();
                Option option2 = user.isAdmin();
                if (option2 instanceof Some && "1".equals(string = (String)(some = (Some)option2).value())) {
                    $this.logUtil.info(new StringBuilder(47).append("Get all equipments for admin user with login : ").append((String)userLogin).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)$this.materielEquipmentDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Equipment$.MODULE$.equipmentOutputWrites())).toString();
                }
                $this.logUtil.info(new StringBuilder(66).append("Get all equipments for user with login : ").append((String)userLogin).append(" with contributor code : ").append(user.contributorCode()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.materielEquipmentDao.getAllAuthorize(BoxesRunTime.unboxToDouble((Object)user.contributorCode().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0)), userLogin), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Equipment$.MODULE$.equipmentOutputWrites())).toString();
            }
            $this.logUtil.info(new StringBuilder(72).append("Error on get all equipments after return error on get user with login : ").append((String)userLogin).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Equipment$.MODULE$.equipmentOutputWrites())).toString();
        });
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EquipmentInput$.MODULE$.userEquipmentIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(48).append("Error validate entry for get single equipment : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String userLogin = (String)tuple2._1();
            int id = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)userLogin, (Object)BoxesRunTime.boxToInteger((int)id));
            String userLogin2 = (String)tuple22._1();
            int id2 = tuple22._2$mcI$sp();
            Option option = $this.materielEquipmentDao.getWithMateriels(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                EquipmentWithMaterielsOutput materiels = (EquipmentWithMaterielsOutput)some.value();
                if ($this.authorizationMaterielDao.checkEquipment(id2, materiels.equipment().administrator(), userLogin2)) {
                    return Json$.MODULE$.toJson((Object)materiels, (Writes)EquipmentWithMaterielsOutput$.MODULE$.equipmentWithMaterielsOutputWrites()).toString();
                }
                $this.logUtil.error(new StringBuilder(50).append("User ").append(userLogin2).append(" not authorize to access equipment with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(31).append("Can't find equipment with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<String> serialNumberRead() {
        return this.serialNumberRead;
    }

    public String getBySerialNumber(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.serialNumberRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(48).append("Error validate entry for get single equipment : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Option option = $this.materielEquipmentDao.getBySerialNumber(validateRead);
            if (option instanceof Some) {
                Some some = (Some)option;
                Equipment materiel = (Equipment)some.value();
                return Json$.MODULE$.toJson((Object)materiel, (Writes)Equipment$.MODULE$.equipmentOutputWrites()).toString();
            }
            $this.logUtil.error(new StringBuilder(36).append("Can't find equipment with noserie : ").append((String)validateRead).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EquipmentWithMaterielsInput$.MODULE$.equipmentWithMaterielsInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Error validate entry to create equipment : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)equipmentInput -> {
            block5: {
                Some date;
                Some login;
                Tuple2 tuple2;
                EquipmentWithMaterielsInput e;
                String user;
                block6: {
                    Tuple2 tuple22 = equipmentInput;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    String user2 = (String)tuple22._1();
                    EquipmentWithMaterielsInput e2 = (EquipmentWithMaterielsInput)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)user2, (Object)e2);
                    user = (String)tuple23._1();
                    e = (EquipmentWithMaterielsInput)tuple23._2();
                    if (!e.equipment().serialNumber().isEmpty() && $this.authorizationMaterielDao.isSerialNumberExist((String)e.equipment().serialNumber().get())) break block5;
                    if (e.equipment().reference().isEmpty()) break block6;
                    Object object = e.equipment().reference().get();
                    String string = "";
                    if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)e.equipment().reference().get(), 7, $this.authorizationMaterielDao.checkReference$default$3())) break block5;
                }
                if ((tuple2 = $this.materielEquipmentDao.create(e, (Option)(login = new Some((Object)user)), (Option)(date = new Some((Object)DateTime.now())))) == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                int result = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
                int id2 = sp2._1$mcI$sp();
                int result2 = sp2._2$mcI$sp();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple3<String, Object, Option<Object>>> duplicateRead() {
        return this.duplicateRead;
    }

    public String duplicate(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.duplicateRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Error validate entry to create equipment : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)equipmentInput -> {
            Tuple3 tuple3 = equipmentInput;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String user = (String)tuple3._1();
            int id = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Option nbEquipment = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)user, (Object)BoxesRunTime.boxToInteger((int)id), (Object)nbEquipment);
            String user2 = (String)tuple32._1();
            int id2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option nbEquipment2 = (Option)tuple32._3();
            Option option = $this.materielEquipmentDao.getWithMateriels(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                EquipmentWithMaterielsOutput equipmentWithMateriel = (EquipmentWithMaterielsOutput)some.value();
                Some date = new Some((Object)DateTime.now());
                Some login = new Some((Object)user2);
                Tuple2 tuple2 = $this.materielEquipmentDao.duplicateEquipment(equipmentWithMateriel, BoxesRunTime.unboxToInt((Object)nbEquipment2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)), (Option)login, (Option)date);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq id3 = (Seq)tuple2._1();
                int result = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)id3, (Object)BoxesRunTime.boxToInteger((int)result));
                Seq id4 = (Seq)tuple22._1();
                int result2 = tuple22._2$mcI$sp();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)id4, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
            }
            $this.logUtil.error(new StringBuilder(46).append("Can't find the equipment with id ").append(id2).append(" to duplicate").toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EquipmentInput$.MODULE$.equipmentIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate entry for delete equipment : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> EquipmentController.$anonfun$delete$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EquipmentWithMaterielsInput$.MODULE$.equipmentWithMaterielsAndIdInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Error validate entry for update equipment: ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)equipmentInput -> {
            block6: {
                Option option;
                int id;
                EquipmentWithMaterielsInput e;
                String user;
                block7: {
                    Tuple3 tuple3 = equipmentInput;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String user2 = (String)tuple3._1();
                    EquipmentWithMaterielsInput e2 = (EquipmentWithMaterielsInput)tuple3._2();
                    int id2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                    Tuple3 tuple32 = new Tuple3((Object)user2, (Object)e2, (Object)BoxesRunTime.boxToInteger((int)id2));
                    user = (String)tuple32._1();
                    e = (EquipmentWithMaterielsInput)tuple32._2();
                    id = BoxesRunTime.unboxToInt((Object)tuple32._3());
                    if (!e.equipment().serialNumber().isEmpty() && $this.authorizationMaterielDao.isEquipmentSerialNumberExist((String)e.equipment().serialNumber().get(), id)) break block6;
                    if (e.equipment().reference().isEmpty()) break block7;
                    Object object = e.equipment().reference().get();
                    String string = "";
                    if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)e.equipment().reference().get(), 7, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)id)))) break block6;
                }
                if ((option = $this.materielEquipmentDao.getWithMateriels(id)) instanceof Some) {
                    Some some = (Some)option;
                    EquipmentWithMaterielsOutput equipment = (EquipmentWithMaterielsOutput)some.value();
                    Some date = new Some((Object)DateTime.now());
                    Some login = new Some((Object)user);
                    int result = $this.materielEquipmentDao.update(equipment, e, id, (Option)login, (Option)date);
                    $this.logUtil.info(new StringBuilder(19).append("Update equipment : ").append(Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()).toString()).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (None$.MODULE$.equals(option)) {
                    return MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Equipment not found", 404);
                }
                throw new MatchError((Object)option);
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getTypes(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.equipmentTypeDao.getEquipmentTypesWithAssociatedTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)EquipmentTypeOutput$.MODULE$.format())).toString();
    }

    public String getType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielTypeRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> EquipmentController.$anonfun$getType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String deleteType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielidUserRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)user);
            int id2 = tuple22._1$mcI$sp();
            String user2 = (String)tuple22._2();
            if ($this.materielEquipmentDao.getEquipmentsWithType(id2).isEmpty()) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.equipmentTypeDao.deleteEquipmentType(id2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.info("Wanted to delete a used equipment type. Closing type.", $this.logUtil.info$default$2());
            if ($this.equipmentTypeDao.closeType(id2, user2) > 0) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)206), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Unable to close type", MaterielUtils$.MODULE$.getJsonError$default$3());
        });
    }

    public String updateType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EquipmentTypeInput$.MODULE$.updateRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String user = (String)tuple3._1();
            int idType = BoxesRunTime.unboxToInt((Object)tuple3._2());
            EquipmentTypeInput equipmentType = (EquipmentTypeInput)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)user, (Object)BoxesRunTime.boxToInteger((int)idType), (Object)equipmentType);
            String user2 = (String)tuple32._1();
            int idType2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            EquipmentTypeInput equipmentType2 = (EquipmentTypeInput)tuple32._3();
            Option option = $this.equipmentTypeDao.getEquipmentType(idType2);
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.equipmentTypeDao.updateWithAssociatedType(idType2, equipmentType2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(34).append("Can't find equipment type with id ").append(idType2).toString(), 404);
            }
            throw new MatchError((Object)option);
        });
    }

    public String createType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EquipmentTypeInput$.MODULE$.createRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            EquipmentTypeInput materielType = (EquipmentTypeInput)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            EquipmentTypeInput materielType2 = (EquipmentTypeInput)tuple22._2();
            Tuple2 tuple23 = $this.equipmentTypeDao.createWithAssociatedType(materielType2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$delete$2(EquipmentController $this, int id) {
        Option option = $this.materielEquipmentDao.get(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            Equipment equipment = (Equipment)some.value();
            int result = $this.materielEquipmentDao.delete(equipment.equipmentId());
            $this.logUtil.info(new StringBuilder(19).append("Delete equipment : ").append(id).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        $this.logUtil.error(new StringBuilder(38).append("Error can't found equipment with id : ").append(id).toString(), $this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getType$2(EquipmentController $this, int id) {
        Option option = $this.equipmentTypeDao.getEquipmentTypeWithAssociatedTypes(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            EquipmentTypeOutput result = (EquipmentTypeOutput)some.value();
            return Json$.MODULE$.toJson((Object)result, (Writes)EquipmentTypeOutput$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(34).append("Can't find equipment type with id ").append(id).toString(), 404);
        }
        throw new MatchError((Object)option);
    }

    @Inject
    public EquipmentController(LogUtil logUtil, MaterielEquipmentDao materielEquipmentDao, EquipmentTypeDao equipmentTypeDao, UserDao userDao, AuthorizationMaterielDao authorizationMaterielDao) {
        this.logUtil = logUtil;
        this.materielEquipmentDao = materielEquipmentDao;
        this.equipmentTypeDao = equipmentTypeDao;
        this.userDao = userDao;
        this.authorizationMaterielDao = authorizationMaterielDao;
        this.serialNumberRead = JsPath$.MODULE$.$bslash("noserie").read((Reads)Reads$.MODULE$.StringReads());
        this.duplicateRead = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("nbEquipment").readNullable((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

