/*
 * Decompiled with CFR 0.152.
 */
package controllers.powerSupply;

import fr.aquasys.daeau.materiel.domain.Input.PowerSupplyInput;
import fr.aquasys.daeau.materiel.domain.Input.PowerSupplyInput$;
import fr.aquasys.daeau.materiel.domain.model.MaterielType$;
import fr.aquasys.daeau.materiel.domain.model.powerSupply.PowerSupply;
import fr.aquasys.daeau.materiel.domain.model.powerSupply.PowerSupply$;
import fr.aquasys.daeau.materiel.domain.model.powerSupply.PowerSupplyType;
import fr.aquasys.daeau.materiel.domain.model.powerSupply.PowerSupplyType$;
import fr.aquasys.daeau.materiel.domain.output.PowerSupplyOutput;
import fr.aquasys.daeau.materiel.domain.output.PowerSupplyOutput$;
import fr.aquasys.daeau.materiel.itf.AuthorizationMaterielDao;
import fr.aquasys.daeau.materiel.itf.powerSupply.MaterielPowerSupplyDao;
import fr.aquasys.daeau.materiel.itf.powerSupply.PowerSupplyTypeDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.MaterielUtils$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import utils.CommonReadUtil$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\t\u0013\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0002.\u0001\t\u0003Y\u0006bBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0005U\u0001vn^3s'V\u0004\b\u000f\\=D_:$(o\u001c7mKJT!a\u0005\u000b\u0002\u0017A|w/\u001a:TkB\u0004H.\u001f\u0006\u0002+\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0003I\u0015\n\u0001B]1cE&$X.\u001d\u0006\u0003M\u001d\nq!Y9vCNL8OC\u0001)\u0003\t1'/\u0003\u0002+C\t9Aj\\4Vi&d\u0017A\u00049po\u0016\u00148+\u001e9qYf$\u0015m\u001c\t\u0003[Uj\u0011A\f\u0006\u0003'=R!\u0001M\u0019\u0002\u0007%$hM\u0003\u00023g\u0005AQ.\u0019;fe&,GN\u0003\u00025K\u0005)A-Y3bk&\u0011aG\f\u0002\u0017\u001b\u0006$XM]5fYB{w/\u001a:TkB\u0004H.\u001f#b_\u0006\u0011\u0002o\\<feN+\b\u000f\u001d7z)f\u0004X\rR1p!\ti\u0013(\u0003\u0002;]\t\u0011\u0002k\\<feN+\b\u000f\u001d7z)f\u0004X\rR1p\u0003\u001d)8/\u001a:EC>\u0004\"!P!\u000e\u0003yR!\u0001M \u000b\u0005\u0001\u001b\u0014\u0001B;tKJL!A\u0011 \u0003\u000fU\u001bXM\u001d#b_\u0006A\u0012-\u001e;i_JL'0\u0019;j_:l\u0015\r^3sS\u0016dG)Y8\u0011\u0005\u00153U\"A\u0018\n\u0005\u001d{#\u0001G!vi\"|'/\u001b>bi&|g.T1uKJLW\r\u001c#b_\u00061A(\u001b8jiz\"bA\u0013'N\u001d>\u0003\u0006CA&\u0001\u001b\u0005\u0011\u0002\"\u0002\u0010\u0007\u0001\u0004y\u0002\"B\u0016\u0007\u0001\u0004a\u0003\"B\u001c\u0007\u0001\u0004A\u0004\"B\u001e\u0007\u0001\u0004a\u0004\"B\"\u0007\u0001\u0004!\u0005F\u0001\u0004S!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0004j]*,7\r\u001e\u0006\u0002/\u0006)!.\u0019<bq&\u0011\u0011\f\u0016\u0002\u0007\u0013:TWm\u0019;\u0002'\u001d,G/\u00117m!><XM]*vaBd\u0017.Z:\u0015\u000bq;W/`@\u0011\u0005u#gB\u00010c!\ty&$D\u0001a\u0015\t\tg#\u0001\u0004=e>|GOP\u0005\u0003Gj\ta\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111M\u0007\u0005\u0006Q\u001e\u0001\r![\u0001\b[\u0016\u001c8/Y4f!\tQ7/D\u0001l\u0015\taW.\u0001\u0003kg>t'B\u00018p\u0003\u0011a\u0017NY:\u000b\u0005A\f\u0018aA1qS*\t!/\u0001\u0003qY\u0006L\u0018B\u0001;l\u0005\u001dQ5OV1mk\u0016DQA^\u0004A\u0002]\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003^qrS\u0018BA=g\u0005\ri\u0015\r\u001d\t\u00033mL!\u0001 \u000e\u0003\u0007\u0005s\u0017\u0010C\u0003\u007f\u000f\u0001\u0007A,\u0001\u0004n_\u0012,H.\u001a\u0005\u0006\u0001\u001e\u0001\r\u0001X\u0001\u000fO\u0016$\bk\\<feN+\b\u000f\u001d7z)%a\u0016QAA\u0004\u0003\u0013\tY\u0001C\u0003i\u0011\u0001\u0007\u0011\u000eC\u0003w\u0011\u0001\u0007q\u000fC\u0003\u007f\u0011\u0001\u0007A\fC\u0003A\u0011\u0001\u0007A,\u0001\u0005hKR$\u0016\u0010]3t)%a\u0016\u0011CA\n\u0003+\t9\u0002C\u0003i\u0013\u0001\u0007\u0011\u000eC\u0003w\u0013\u0001\u0007q\u000fC\u0003\u007f\u0013\u0001\u0007A\fC\u0003A\u0013\u0001\u0007A,A\u0004hKR$\u0016\u0010]3\u0015\u0013q\u000bi\"a\b\u0002\"\u0005\r\u0002\"\u00025\u000b\u0001\u0004I\u0007\"\u0002<\u000b\u0001\u00049\b\"\u0002@\u000b\u0001\u0004a\u0006\"\u0002!\u000b\u0001\u0004a\u0016A\u00033fY\u0016$X\rV=qKRIA,!\u000b\u0002,\u00055\u0012q\u0006\u0005\u0006Q.\u0001\r!\u001b\u0005\u0006m.\u0001\ra\u001e\u0005\u0006}.\u0001\r\u0001\u0018\u0005\u0006\u0001.\u0001\r\u0001X\u0001\u000bkB$\u0017\r^3UsB,G#\u0003/\u00026\u0005]\u0012\u0011HA\u001e\u0011\u0015AG\u00021\u0001j\u0011\u00151H\u00021\u0001x\u0011\u0015qH\u00021\u0001]\u0011\u0015\u0001E\u00021\u0001]\u0003)\u0019'/Z1uKRK\b/\u001a\u000b\n9\u0006\u0005\u00131IA#\u0003\u000fBQ\u0001[\u0007A\u0002%DQA^\u0007A\u0002]DQA`\u0007A\u0002qCQ\u0001Q\u0007A\u0002q\u000b\u0011c\u0019:fCR,\u0007k\\<feN+\b\u000f\u001d7z)%a\u0016QJA(\u0003#\n\u0019\u0006C\u0003i\u001d\u0001\u0007\u0011\u000eC\u0003w\u001d\u0001\u0007q\u000fC\u0003\u007f\u001d\u0001\u0007A\fC\u0003A\u001d\u0001\u0007A,A\tva\u0012\fG/\u001a)po\u0016\u00148+\u001e9qYf$\u0012\u0002XA-\u00037\ni&a\u0018\t\u000b!|\u0001\u0019A5\t\u000bY|\u0001\u0019A<\t\u000by|\u0001\u0019\u0001/\t\u000b\u0001{\u0001\u0019\u0001/\u0002#\u0011,G.\u001a;f!><XM]*vaBd\u0017\u0010F\u0005]\u0003K\n9'!\u001b\u0002l!)\u0001\u000e\u0005a\u0001S\")a\u000f\u0005a\u0001o\")a\u0010\u0005a\u00019\")\u0001\t\u0005a\u00019\u0002")
public class PowerSupplyController {
    private final LogUtil logUtil;
    private final MaterielPowerSupplyDao powerSupplyDao;
    private final PowerSupplyTypeDao powerSupplyTypeDao;
    private final UserDao userDao;
    private final AuthorizationMaterielDao authorizationMaterielDao;

    public String getAllPowerSupplies(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.getMateriel()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Error validate entry for get all powerSupplies : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            Option withEquipment = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)withEquipment);
            String login2 = (String)tuple22._1();
            Option withEquipment2 = (Option)tuple22._2();
            Option option = $this.userDao.get(login2);
            if (option instanceof Some) {
                Some some;
                String string;
                Some some2 = (Some)option;
                User user = (User)some2.value();
                Option option2 = user.isAdmin();
                if (option2 instanceof Some && "1".equals(string = (String)(some = (Some)option2).value())) {
                    $this.logUtil.info(new StringBuilder(49).append("Get all powerSupplies for admin user with login: ").append(login2).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)$this.powerSupplyDao.getAllPowerSupplies(BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PowerSupplyOutput$.MODULE$.powerSupplyFormat())).toString();
                }
                $this.logUtil.info(new StringBuilder(67).append("Get all powerSupplies for user with login: ").append(login2).append(" with contributor code: ").append(user.contributorCode()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.powerSupplyDao.getAllPowerSupplies(BoxesRunTime.unboxToDouble((Object)user.contributorCode().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0)), login2, BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PowerSupplyOutput$.MODULE$.powerSupplyFormat())).toString();
            }
            $this.logUtil.info(new StringBuilder(48).append("Error on get all powerSupplies, cant find user: ").append(login2).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PowerSupplyOutput$.MODULE$.powerSupplyFormat())).toString();
        });
    }

    public String getPowerSupply(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PowerSupply$.MODULE$.powerSupplyUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(60).append("Error validate entry for get single power supply materiel : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String userLogin = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)userLogin);
            int id2 = tuple22._1$mcI$sp();
            String userLogin2 = (String)tuple22._2();
            Option option = $this.powerSupplyDao.getPowerSupply(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                PowerSupplyOutput powerSupply = (PowerSupplyOutput)some.value();
                if ($this.authorizationMaterielDao.checkMateriel(id2, powerSupply.administrator(), userLogin2, "mat_batteries_situations", "idbatterie", "idalimentation")) {
                    return Json$.MODULE$.toJson((Object)powerSupply, (Writes)PowerSupplyOutput$.MODULE$.powerSupplyFormat()).toString();
                }
                $this.logUtil.error(new StringBuilder(53).append("User ").append(userLogin2).append(" not authorize to access power supply with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(34).append("Can't find power supply with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getTypes(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.withEquipmentTypeRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)withEquipmentType -> {
            if (BoxesRunTime.unboxToBoolean((Object)withEquipmentType.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                return Json$.MODULE$.toJson((Object)$this.powerSupplyTypeDao.getAllPowerSupplyTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PowerSupplyType$.MODULE$.format())).toString();
            }
            return Json$.MODULE$.toJson((Object)$this.powerSupplyTypeDao.getPowerSupplyTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PowerSupplyType$.MODULE$.format())).toString();
        });
    }

    public String getType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielTypeRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> PowerSupplyController.$anonfun$getType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String deleteType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielidUserRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)user);
            int id2 = tuple22._1$mcI$sp();
            String user2 = (String)tuple22._2();
            if ($this.powerSupplyDao.getPowerSuppliesWithTypes(id2).isEmpty()) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.powerSupplyTypeDao.deletePowerSupplyType(id2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.info("Wanted to delete a used power supply type. Closing type.", $this.logUtil.info$default$2());
            if ($this.powerSupplyTypeDao.closeType(id2, user2) > 0) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)206), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Unable to close type", utils.MaterielUtils$.MODULE$.getJsonError$default$3());
        });
    }

    public String updateType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PowerSupplyType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            PowerSupplyType materielType = (PowerSupplyType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            PowerSupplyType materielType2 = (PowerSupplyType)tuple22._2();
            Option option = materielType2.materielType();
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                Option option2 = $this.powerSupplyTypeDao.getPowerSupplyType(id);
                if (option2 instanceof Some) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.powerSupplyTypeDao.updatePowerSupplyType(materielType2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(36).append("Can't find powerSupply type with id ").append(id).toString(), 404);
                }
                throw new MatchError((Object)option2);
            }
            if (None$.MODULE$.equals(option)) {
                return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Can't read type id", 500);
            }
            throw new MatchError((Object)option);
        });
    }

    public String createType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PowerSupplyType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            PowerSupplyType materielType = (PowerSupplyType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            PowerSupplyType materielType2 = (PowerSupplyType)tuple22._2();
            Tuple2 tuple23 = $this.powerSupplyTypeDao.createPowerSupplyType(materielType2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String createPowerSupply(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PowerSupplyInput$.MODULE$.powerSupplyInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate entry for create powersupply : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)powerSupplyParam -> {
            block6: {
                Option x$18;
                Option x$17;
                Option x$16;
                Option x$15;
                Option x$14;
                Option x$13;
                Option x$12;
                Option x$11;
                Option x$10;
                Option x$9;
                Option x$8;
                Option x$7;
                Option x$6;
                Option x$5;
                Option x$4;
                PowerSupplyInput ps;
                String login;
                block5: {
                    Tuple2 tuple2 = powerSupplyParam;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String login2 = (String)tuple2._1();
                    PowerSupplyInput ps2 = (PowerSupplyInput)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)login2, (Object)ps2);
                    login = (String)tuple22._1();
                    ps = (PowerSupplyInput)tuple22._2();
                    if (ps.reference().isEmpty()) break block5;
                    Object object = ps.reference().get();
                    String string = "";
                    if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)ps.reference().get(), 2, $this.authorizationMaterielDao.checkReference$default$3())) break block6;
                }
                Some x$1 = new Some((Object)login);
                Some x$2 = new Some((Object)DateTime.now());
                Option x$3 = ps.copy$default$1();
                PowerSupplyInput powerSupplyInput = ps.copy(x$3, x$4 = ps.copy$default$2(), x$5 = ps.copy$default$3(), x$6 = ps.copy$default$4(), x$7 = ps.copy$default$5(), x$8 = ps.copy$default$6(), x$9 = ps.copy$default$7(), x$10 = ps.copy$default$8(), x$11 = ps.copy$default$9(), x$12 = ps.copy$default$10(), x$13 = ps.copy$default$11(), (Option)x$2, (Option)x$1, x$14 = ps.copy$default$14(), x$15 = ps.copy$default$15(), x$16 = ps.copy$default$16(), x$17 = ps.copy$default$17(), x$18 = ps.copy$default$18());
                Tuple2 tuple2 = $this.powerSupplyDao.createPowerSupply(powerSupplyInput);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                int result = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
                int id2 = sp2._1$mcI$sp();
                int result2 = sp2._2$mcI$sp();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updatePowerSupply(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PowerSupply$.MODULE$.powerSupplyInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate entry for update powersupply : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)powerSupplyParam -> {
            Option option;
            block5: {
                block7: {
                    PowerSupplyInput ps;
                    String login;
                    int idP;
                    block6: {
                        Tuple3 tuple3 = powerSupplyParam;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int idP2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        String login2 = (String)tuple3._2();
                        PowerSupplyInput ps2 = (PowerSupplyInput)tuple3._3();
                        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idP2), (Object)login2, (Object)ps2);
                        idP = BoxesRunTime.unboxToInt((Object)tuple32._1());
                        login = (String)tuple32._2();
                        ps = (PowerSupplyInput)tuple32._3();
                        option = $this.powerSupplyDao.getPowerSupply(idP);
                        if (!(option instanceof Some)) break block5;
                        if ($this.authorizationMaterielDao.isEquipment(MaterielUtils$.MODULE$.powerSupplyTypeLabel(), idP) || ps.reference().isEmpty()) break block6;
                        Object object = ps.reference().get();
                        String string = "";
                        if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)ps.reference().get(), 2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)idP)))) break block7;
                    }
                    Some x$1 = new Some((Object)login);
                    Some x$2 = new Some((Object)DateTime.now());
                    Option x$3 = ps.copy$default$1();
                    Option x$4 = ps.copy$default$2();
                    Option x$5 = ps.copy$default$3();
                    Option x$6 = ps.copy$default$4();
                    Option x$7 = ps.copy$default$5();
                    Option x$8 = ps.copy$default$6();
                    Option x$9 = ps.copy$default$7();
                    Option x$10 = ps.copy$default$8();
                    Option x$11 = ps.copy$default$9();
                    Option x$12 = ps.copy$default$10();
                    Option x$13 = ps.copy$default$11();
                    Option x$14 = ps.copy$default$14();
                    Option x$15 = ps.copy$default$15();
                    Option x$16 = ps.copy$default$16();
                    Option x$17 = ps.copy$default$17();
                    Option x$18 = ps.copy$default$18();
                    PowerSupplyInput powerSupplyP = ps.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option)x$2, (Option)x$1, x$14, x$15, x$16, x$17, x$18);
                    PowerSupply powerSupply = PowerSupply$.MODULE$.toPowerSupply(idP, powerSupplyP);
                    int result = $this.powerSupplyDao.updatePowerSupply(powerSupply);
                    $this.logUtil.info(new StringBuilder(22).append("Update power supply : ").append(Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()).toString()).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Power Supply not found", 404);
            }
            throw new MatchError((Object)option);
        });
    }

    public String deletePowerSupply(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PowerSupply$.MODULE$.powerSupplyRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate entry for delete powersupply : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> PowerSupplyController.$anonfun$deletePowerSupply$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public static final /* synthetic */ String $anonfun$getType$2(PowerSupplyController $this, int id) {
        Option option = $this.powerSupplyTypeDao.getPowerSupplyType(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            PowerSupplyType result = (PowerSupplyType)some.value();
            return Json$.MODULE$.toJson((Object)result, (Writes)PowerSupplyType$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(36).append("Can't find powerSupply type with id ").append(id).toString(), 404);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$deletePowerSupply$2(PowerSupplyController $this, int id) {
        int result = $this.powerSupplyDao.deletePowerSupply(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public PowerSupplyController(LogUtil logUtil, MaterielPowerSupplyDao powerSupplyDao, PowerSupplyTypeDao powerSupplyTypeDao, UserDao userDao, AuthorizationMaterielDao authorizationMaterielDao) {
        this.logUtil = logUtil;
        this.powerSupplyDao = powerSupplyDao;
        this.powerSupplyTypeDao = powerSupplyTypeDao;
        this.userDao = userDao;
        this.authorizationMaterielDao = authorizationMaterielDao;
    }
}

