/*
 * Decompiled with CFR 0.152.
 */
package controllers.sensor;

import fr.aquasys.daeau.materiel.domain.Input.SensorInput;
import fr.aquasys.daeau.materiel.domain.Input.SensorInput$;
import fr.aquasys.daeau.materiel.domain.model.MaterielType$;
import fr.aquasys.daeau.materiel.domain.model.sensor.Sensor;
import fr.aquasys.daeau.materiel.domain.model.sensor.Sensor$;
import fr.aquasys.daeau.materiel.domain.model.sensor.SensorType;
import fr.aquasys.daeau.materiel.domain.model.sensor.SensorType$;
import fr.aquasys.daeau.materiel.domain.output.SensorOutput;
import fr.aquasys.daeau.materiel.domain.output.SensorOutput$;
import fr.aquasys.daeau.materiel.itf.AuthorizationMaterielDao;
import fr.aquasys.daeau.materiel.itf.sensor.MaterielSensorDao;
import fr.aquasys.daeau.materiel.itf.sensor.SensorTypeDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.MaterielUtils$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import utils.CommonReadUtil$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\t\u0013\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0002.\u0001\t\u0003Y\u0006bBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0005A\u0019VM\\:pe\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u0014)\u000511/\u001a8t_JT\u0011!F\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005\u0001JS\"A\u0011\u000b\u0005\t\u001a\u0013\u0001B;uS2T!\u0001J\u0013\u0002\u0011I\f'MY5u[FT!AJ\u0014\u0002\u000f\u0005\fX/Y:zg*\t\u0001&\u0001\u0002ge&\u0011!&\t\u0002\b\u0019><W\u000b^5m\u0003Ei\u0017\r^3sS\u0016d7+\u001a8t_J$\u0015m\u001c\t\u0003[Uj\u0011A\f\u0006\u0003'=R!\u0001M\u0019\u0002\u0007%$hM\u0003\u00023g\u0005AQ.\u0019;fe&,GN\u0003\u00025K\u0005)A-Y3bk&\u0011aG\f\u0002\u0012\u001b\u0006$XM]5fYN+gn]8s\t\u0006|\u0017!D:f]N|'\u000fV=qK\u0012\u000bw\u000e\u0005\u0002.s%\u0011!H\f\u0002\u000e'\u0016t7o\u001c:UsB,G)Y8\u0002\u000fU\u001cXM\u001d#b_B\u0011Q(Q\u0007\u0002})\u0011\u0001g\u0010\u0006\u0003\u0001N\nA!^:fe&\u0011!I\u0010\u0002\b+N,'\u000fR1p\u0003a\tW\u000f\u001e5pe&T\u0018\r^5p]6\u000bG/\u001a:jK2$\u0015m\u001c\t\u0003\u000b\u001ak\u0011aL\u0005\u0003\u000f>\u0012\u0001$Q;uQ>\u0014\u0018N_1uS>tW*\u0019;fe&,G\u000eR1p\u0003\u0019a\u0014N\\5u}Q1!\nT'O\u001fB\u0003\"a\u0013\u0001\u000e\u0003IAQA\b\u0004A\u0002}AQa\u000b\u0004A\u00021BQa\u000e\u0004A\u0002aBQa\u000f\u0004A\u0002qBQa\u0011\u0004A\u0002\u0011C#A\u0002*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016AB5oU\u0016\u001cGOC\u0001X\u0003\u0015Q\u0017M^1y\u0013\tIFK\u0001\u0004J]*,7\r^\u0001\u000bO\u0016$8+\u001a8t_J\u001cH#\u0002/hkv|\bCA/e\u001d\tq&\r\u0005\u0002`55\t\u0001M\u0003\u0002b-\u00051AH]8pizJ!a\u0019\u000e\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GjAQ\u0001[\u0004A\u0002%\fq!\\3tg\u0006<W\r\u0005\u0002kg6\t1N\u0003\u0002m[\u0006!!n]8o\u0015\tqw.\u0001\u0003mS\n\u001c(B\u00019r\u0003\r\t\u0007/\u001b\u0006\u0002e\u0006!\u0001\u000f\\1z\u0013\t!8NA\u0004KgZ\u000bG.^3\t\u000bY<\u0001\u0019A<\u0002\u000f!,\u0017\rZ3sgB!Q\f\u001f/{\u0013\tIhMA\u0002NCB\u0004\"!G>\n\u0005qT\"aA!os\")ap\u0002a\u00019\u00061Qn\u001c3vY\u0016DQ\u0001Q\u0004A\u0002q\u000b\u0011bZ3u'\u0016t7o\u001c:\u0015\u0013q\u000b)!a\u0002\u0002\n\u0005-\u0001\"\u00025\t\u0001\u0004I\u0007\"\u0002<\t\u0001\u00049\b\"\u0002@\t\u0001\u0004a\u0006\"\u0002!\t\u0001\u0004a\u0016\u0001C4fiRK\b/Z:\u0015\u0013q\u000b\t\"a\u0005\u0002\u0016\u0005]\u0001\"\u00025\n\u0001\u0004I\u0007\"\u0002<\n\u0001\u00049\b\"\u0002@\n\u0001\u0004a\u0006\"\u0002!\n\u0001\u0004a\u0016aB4fiRK\b/\u001a\u000b\n9\u0006u\u0011qDA\u0011\u0003GAQ\u0001\u001b\u0006A\u0002%DQA\u001e\u0006A\u0002]DQA \u0006A\u0002qCQ\u0001\u0011\u0006A\u0002q\u000b!\u0002Z3mKR,G+\u001f9f)%a\u0016\u0011FA\u0016\u0003[\ty\u0003C\u0003i\u0017\u0001\u0007\u0011\u000eC\u0003w\u0017\u0001\u0007q\u000fC\u0003\u007f\u0017\u0001\u0007A\fC\u0003A\u0017\u0001\u0007A,\u0001\u0006va\u0012\fG/\u001a+za\u0016$\u0012\u0002XA\u001b\u0003o\tI$a\u000f\t\u000b!d\u0001\u0019A5\t\u000bYd\u0001\u0019A<\t\u000byd\u0001\u0019\u0001/\t\u000b\u0001c\u0001\u0019\u0001/\u0002\u0015\r\u0014X-\u0019;f)f\u0004X\rF\u0005]\u0003\u0003\n\u0019%!\u0012\u0002H!)\u0001.\u0004a\u0001S\")a/\u0004a\u0001o\")a0\u0004a\u00019\")\u0001)\u0004a\u00019\u0006a1M]3bi\u0016\u001cVM\\:peRIA,!\u0014\u0002P\u0005E\u00131\u000b\u0005\u0006Q:\u0001\r!\u001b\u0005\u0006m:\u0001\ra\u001e\u0005\u0006}:\u0001\r\u0001\u0018\u0005\u0006\u0001:\u0001\r\u0001X\u0001\rkB$\u0017\r^3TK:\u001cxN\u001d\u000b\n9\u0006e\u00131LA/\u0003?BQ\u0001[\bA\u0002%DQA^\bA\u0002]DQA`\bA\u0002qCQ\u0001Q\bA\u0002q\u000bA\u0002Z3mKR,7+\u001a8t_J$\u0012\u0002XA3\u0003O\nI'a\u001b\t\u000b!\u0004\u0002\u0019A5\t\u000bY\u0004\u0002\u0019A<\t\u000by\u0004\u0002\u0019\u0001/\t\u000b\u0001\u0003\u0002\u0019\u0001/")
public class SensorController {
    private final LogUtil logUtil;
    private final MaterielSensorDao materielSensorDao;
    private final SensorTypeDao sensorTypeDao;
    private final UserDao userDao;
    private final AuthorizationMaterielDao authorizationMaterielDao;

    public String getSensors(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.getMateriel()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Error validate entry for get all sensors : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            Option withEquipment = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)withEquipment);
            String login2 = (String)tuple22._1();
            Option withEquipment2 = (Option)tuple22._2();
            Option option = $this.userDao.get(login2);
            if (option instanceof Some) {
                Some some;
                String string;
                Some some2 = (Some)option;
                User user = (User)some2.value();
                Option option2 = user.isAdmin();
                if (option2 instanceof Some && "1".equals(string = (String)(some = (Some)option2).value())) {
                    $this.logUtil.info(new StringBuilder(43).append("Get all sensors for admin user with login: ").append(login2).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)$this.materielSensorDao.getAllSensors(BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SensorOutput$.MODULE$.sensorFormat())).toString();
                }
                $this.logUtil.info(new StringBuilder(61).append("Get all sensors for user with login: ").append(login2).append(" with contributor code: ").append(user.contributorCode()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.materielSensorDao.getAllSensors(BoxesRunTime.unboxToDouble((Object)user.contributorCode().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0)), login2, BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SensorOutput$.MODULE$.sensorFormat())).toString();
            }
            $this.logUtil.info(new StringBuilder(42).append("Error on get all sensors, cant find user: ").append(login2).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SensorOutput$.MODULE$.sensorFormat())).toString();
        });
    }

    public String getSensor(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Sensor$.MODULE$.sensorUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validate entry for get single sensor : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String userLogin = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)userLogin);
            int id2 = tuple22._1$mcI$sp();
            String userLogin2 = (String)tuple22._2();
            Option option = $this.materielSensorDao.getSensor(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                SensorOutput sensor = (SensorOutput)some.value();
                if ($this.authorizationMaterielDao.checkMateriel(id2, sensor.administrator(), userLogin2, "mat_capteurs_situations", "idcapteur", "idcapteur")) {
                    return Json$.MODULE$.toJson((Object)sensor, (Writes)SensorOutput$.MODULE$.sensorFormat()).toString();
                }
                $this.logUtil.error(new StringBuilder(47).append("User ").append(userLogin2).append(" not authorize to access sensor with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(28).append("Can't find sensor with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getTypes(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.withEquipmentTypeRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)withEquipmentType -> {
            if (BoxesRunTime.unboxToBoolean((Object)withEquipmentType.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                return Json$.MODULE$.toJson((Object)$this.sensorTypeDao.getAllSensorTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SensorType$.MODULE$.format())).toString();
            }
            return Json$.MODULE$.toJson((Object)$this.sensorTypeDao.getSensorTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SensorType$.MODULE$.format())).toString();
        });
    }

    public String getType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielTypeRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> SensorController.$anonfun$getType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String deleteType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielidUserRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)user);
            int id2 = tuple22._1$mcI$sp();
            String user2 = (String)tuple22._2();
            if ($this.materielSensorDao.getSensorsWithType(id2).isEmpty()) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.sensorTypeDao.deleteSensorType(id2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.info("Wanted to delete a used sensor type. Closing type.", $this.logUtil.info$default$2());
            if ($this.sensorTypeDao.closeType(id2, user2) > 0) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)206), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Unable to close type", utils.MaterielUtils$.MODULE$.getJsonError$default$3());
        });
    }

    public String updateType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SensorType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            SensorType materielType = (SensorType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            SensorType materielType2 = (SensorType)tuple22._2();
            Option option = materielType2.materielType();
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                Option option2 = $this.sensorTypeDao.getSensorType(id);
                if (option2 instanceof Some) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.sensorTypeDao.updateSensorType(materielType2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(31).append("Can't find sensor type with id ").append(id).toString(), 404);
                }
                throw new MatchError((Object)option2);
            }
            if (None$.MODULE$.equals(option)) {
                return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Can't read type id", 500);
            }
            throw new MatchError((Object)option);
        });
    }

    public String createType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SensorType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            SensorType materielType = (SensorType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            SensorType materielType2 = (SensorType)tuple22._2();
            Tuple2 tuple23 = $this.sensorTypeDao.createSensorType(materielType2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String createSensor(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SensorInput$.MODULE$.sensorInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate entry for create sensor : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)sensorParam -> {
            block6: {
                String login;
                block5: {
                    Tuple2 tuple2 = sensorParam;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String login2 = (String)tuple2._1();
                    SensorInput sensor = (SensorInput)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)login2, (Object)sensor);
                    login = (String)tuple22._1();
                    SensorInput sensor2 = (SensorInput)tuple22._2();
                    if (sensor2.reference().isEmpty()) break block5;
                    Object object = sensor2.reference().get();
                    String string = "";
                    if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)sensor2.reference().get(), 3, $this.authorizationMaterielDao.checkReference$default$3())) break block6;
                }
                Some x$1 = new Some((Object)login);
                Some x$2 = new Some((Object)DateTime.now());
                Option x$3 = ((SensorInput)sensorParam._2()).copy$default$1();
                Option x$4 = ((SensorInput)sensorParam._2()).copy$default$2();
                Option x$5 = ((SensorInput)sensorParam._2()).copy$default$3();
                Option x$6 = ((SensorInput)sensorParam._2()).copy$default$4();
                Option x$7 = ((SensorInput)sensorParam._2()).copy$default$5();
                Option x$8 = ((SensorInput)sensorParam._2()).copy$default$6();
                Option x$9 = ((SensorInput)sensorParam._2()).copy$default$7();
                Option x$10 = ((SensorInput)sensorParam._2()).copy$default$8();
                Option x$11 = ((SensorInput)sensorParam._2()).copy$default$9();
                Option x$12 = ((SensorInput)sensorParam._2()).copy$default$10();
                Option x$13 = ((SensorInput)sensorParam._2()).copy$default$11();
                Option x$14 = ((SensorInput)sensorParam._2()).copy$default$12();
                Option x$15 = ((SensorInput)sensorParam._2()).copy$default$15();
                Option x$16 = ((SensorInput)sensorParam._2()).copy$default$16();
                Option x$17 = ((SensorInput)sensorParam._2()).copy$default$17();
                Option x$18 = ((SensorInput)sensorParam._2()).copy$default$18();
                Option x$19 = ((SensorInput)sensorParam._2()).copy$default$19();
                Option x$20 = ((SensorInput)sensorParam._2()).copy$default$20();
                Option x$21 = ((SensorInput)sensorParam._2()).copy$default$21();
                Option x$22 = ((SensorInput)sensorParam._2()).copy$default$22();
                Option x$23 = ((SensorInput)sensorParam._2()).copy$default$23();
                Option x$24 = ((SensorInput)sensorParam._2()).copy$default$24();
                Option x$25 = ((SensorInput)sensorParam._2()).copy$default$25();
                Option x$26 = ((SensorInput)sensorParam._2()).copy$default$26();
                SensorInput sensorInput = ((SensorInput)sensorParam._2()).copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option)x$2, (Option)x$1, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
                Tuple2 tuple2 = $this.materielSensorDao.createSensor(sensorInput);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                int result = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
                int id2 = sp2._1$mcI$sp();
                int result2 = sp2._2$mcI$sp();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateSensor(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Sensor$.MODULE$.sensorInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate entry for update sensor : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)sensorParam -> {
            Option option;
            block5: {
                block7: {
                    SensorInput s;
                    String login;
                    int idP;
                    block6: {
                        Tuple3 tuple3 = sensorParam;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int idP2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        String login2 = (String)tuple3._2();
                        SensorInput s2 = (SensorInput)tuple3._3();
                        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idP2), (Object)login2, (Object)s2);
                        idP = BoxesRunTime.unboxToInt((Object)tuple32._1());
                        login = (String)tuple32._2();
                        s = (SensorInput)tuple32._3();
                        option = $this.materielSensorDao.getSensor(idP);
                        if (!(option instanceof Some)) break block5;
                        if ($this.authorizationMaterielDao.isEquipment(MaterielUtils$.MODULE$.sensorTypeLabel(), idP) || s.reference().isEmpty()) break block6;
                        Object object = s.reference().get();
                        String string = "";
                        if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)s.reference().get(), 3, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)idP)))) break block7;
                    }
                    Some x$1 = new Some((Object)login);
                    Some x$2 = new Some((Object)DateTime.now());
                    Option x$3 = s.copy$default$1();
                    Option x$4 = s.copy$default$2();
                    Option x$5 = s.copy$default$3();
                    Option x$6 = s.copy$default$4();
                    Option x$7 = s.copy$default$5();
                    Option x$8 = s.copy$default$6();
                    Option x$9 = s.copy$default$7();
                    Option x$10 = s.copy$default$8();
                    Option x$11 = s.copy$default$9();
                    Option x$12 = s.copy$default$10();
                    Option x$13 = s.copy$default$11();
                    Option x$14 = s.copy$default$12();
                    Option x$15 = s.copy$default$15();
                    Option x$16 = s.copy$default$16();
                    Option x$17 = s.copy$default$17();
                    Option x$18 = s.copy$default$18();
                    Option x$19 = s.copy$default$19();
                    Option x$20 = s.copy$default$20();
                    Option x$21 = s.copy$default$21();
                    Option x$22 = s.copy$default$22();
                    Option x$23 = s.copy$default$23();
                    Option x$24 = s.copy$default$24();
                    Option x$25 = s.copy$default$25();
                    Option x$26 = s.copy$default$26();
                    SensorInput sensorP = s.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option)x$2, (Option)x$1, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
                    Sensor sensor = Sensor$.MODULE$.toSensor(idP, sensorP);
                    int result = $this.materielSensorDao.updateSensor(sensor);
                    $this.logUtil.info(new StringBuilder(16).append("Update sensor : ").append(Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()).toString()).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Sensor not found", 404);
            }
            throw new MatchError((Object)option);
        });
    }

    public String deleteSensor(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Sensor$.MODULE$.sensorRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate entry for delete sensor : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> SensorController.$anonfun$deleteSensor$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public static final /* synthetic */ String $anonfun$getType$2(SensorController $this, int id) {
        Option option = $this.sensorTypeDao.getSensorType(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            SensorType result = (SensorType)some.value();
            return Json$.MODULE$.toJson((Object)result, (Writes)SensorType$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(31).append("Can't find sensor type with id ").append(id).toString(), 404);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$deleteSensor$2(SensorController $this, int id) {
        int result = $this.materielSensorDao.deleteSensor(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public SensorController(LogUtil logUtil, MaterielSensorDao materielSensorDao, SensorTypeDao sensorTypeDao, UserDao userDao, AuthorizationMaterielDao authorizationMaterielDao) {
        this.logUtil = logUtil;
        this.materielSensorDao = materielSensorDao;
        this.sensorTypeDao = sensorTypeDao;
        this.userDao = userDao;
        this.authorizationMaterielDao = authorizationMaterielDao;
    }
}

