/*
 * Decompiled with CFR 0.152.
 */
package controllers.sim;

import fr.aquasys.daeau.materiel.domain.Input.SimInput;
import fr.aquasys.daeau.materiel.domain.Input.SimInput$;
import fr.aquasys.daeau.materiel.domain.model.MaterielType$;
import fr.aquasys.daeau.materiel.domain.model.sim.Sim;
import fr.aquasys.daeau.materiel.domain.model.sim.Sim$;
import fr.aquasys.daeau.materiel.domain.model.sim.SimType;
import fr.aquasys.daeau.materiel.domain.model.sim.SimType$;
import fr.aquasys.daeau.materiel.domain.model.sim.SimWithSubscription;
import fr.aquasys.daeau.materiel.domain.model.sim.SimWithSubscription$;
import fr.aquasys.daeau.materiel.domain.output.SimOutput;
import fr.aquasys.daeau.materiel.domain.output.SimOutput$;
import fr.aquasys.daeau.materiel.itf.AuthorizationMaterielDao;
import fr.aquasys.daeau.materiel.itf.sim.MaterielSimDao;
import fr.aquasys.daeau.materiel.itf.sim.SimTypeDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import utils.CommonReadUtil$;
import utils.MaterielUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!A!\u0002\u0013)\u0005\"B%\u0001\t\u0003Q\u0005\"B.\u0001\t\u0003a\u0006bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\n\u0001\t\u0003\tI\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\u0012QbU5n\u0007>tGO]8mY\u0016\u0014(B\u0001\u000b\u0016\u0003\r\u0019\u0018.\u001c\u0006\u0002-\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"!\t\u0016\u000e\u0003\tR!a\t\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003K\u0019\n\u0001B]1cE&$X.\u001d\u0006\u0003O!\nq!Y9vCNL8OC\u0001*\u0003\t1'/\u0003\u0002,E\t9Aj\\4Vi&d\u0017AD7bi\u0016\u0014\u0018.\u001a7TS6$\u0015m\u001c\t\u0003]Yj\u0011a\f\u0006\u0003)AR!!\r\u001a\u0002\u0007%$hM\u0003\u00024i\u0005AQ.\u0019;fe&,GN\u0003\u00026M\u0005)A-Y3bk&\u0011qg\f\u0002\u000f\u001b\u0006$XM]5fYNKW\u000eR1p\u0003)\u0019\u0018.\u001c+za\u0016$\u0015m\u001c\t\u0003]iJ!aO\u0018\u0003\u0015MKW\u000eV=qK\u0012\u000bw.A\u0004vg\u0016\u0014H)Y8\u0011\u0005y\u0012U\"A \u000b\u0005E\u0002%BA!5\u0003\u0011)8/\u001a:\n\u0005\r{$aB+tKJ$\u0015m\\\u0001\u0019CV$\bn\u001c:ju\u0006$\u0018n\u001c8NCR,'/[3m\t\u0006|\u0007C\u0001$H\u001b\u0005\u0001\u0014B\u0001%1\u0005a\tU\u000f\u001e5pe&T\u0018\r^5p]6\u000bG/\u001a:jK2$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\r-kej\u0014)R!\ta\u0005!D\u0001\u0014\u0011\u0015yb\u00011\u0001!\u0011\u0015ac\u00011\u0001.\u0011\u0015Ad\u00011\u0001:\u0011\u0015ad\u00011\u0001>\u0011\u0015!e\u00011\u0001FQ\t11\u000b\u0005\u0002U36\tQK\u0003\u0002W/\u00061\u0011N\u001c6fGRT\u0011\u0001W\u0001\u0006U\u00064\u0018\r_\u0005\u00035V\u0013a!\u00138kK\u000e$\u0018AC4fi\u0006cGnU5ngR1Q\f\u001b<\u007f\u0003\u0003\u0001\"AX3\u000f\u0005}\u001b\u0007C\u00011\u001c\u001b\u0005\t'B\u00012\u0018\u0003\u0019a$o\\8u}%\u0011AmG\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e7!)\u0011n\u0002a\u0001U\u00069Q.Z:tC\u001e,\u0007CA6u\u001b\u0005a'BA7o\u0003\u0011Q7o\u001c8\u000b\u0005=\u0004\u0018\u0001\u00027jENT!!\u001d:\u0002\u0007\u0005\u0004\u0018NC\u0001t\u0003\u0011\u0001H.Y=\n\u0005Ud'a\u0002&t-\u0006dW/\u001a\u0005\u0006o\u001e\u0001\r\u0001_\u0001\bQ\u0016\fG-\u001a:t!\u0011q\u00160X>\n\u0005i<'aA'baB\u0011!\u0004`\u0005\u0003{n\u00111!\u00118z\u0011\u0015yx\u00011\u0001^\u0003\u0019iw\u000eZ;mK\")\u0011i\u0002a\u0001;\u00061q-\u001a;TS6$\u0012\"XA\u0004\u0003\u0013\tY!!\u0004\t\u000b%D\u0001\u0019\u00016\t\u000b]D\u0001\u0019\u0001=\t\u000b}D\u0001\u0019A/\t\u000b\u0005C\u0001\u0019A/\u0002-\u001d,GoU5n/&$\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:$\u0012\"XA\n\u0003+\t9\"!\u0007\t\u000b%L\u0001\u0019\u00016\t\u000b]L\u0001\u0019\u0001=\t\u000b}L\u0001\u0019A/\t\u000b\u0005K\u0001\u0019A/\u0002\u0011\u001d,G\u000fV=qKN$\u0012\"XA\u0010\u0003C\t\u0019#!\n\t\u000b%T\u0001\u0019\u00016\t\u000b]T\u0001\u0019\u0001=\t\u000b}T\u0001\u0019A/\t\u000b\u0005S\u0001\u0019A/\u0002\u000f\u001d,G\u000fV=qKRIQ,a\u000b\u0002.\u0005=\u0012\u0011\u0007\u0005\u0006S.\u0001\rA\u001b\u0005\u0006o.\u0001\r\u0001\u001f\u0005\u0006\u007f.\u0001\r!\u0018\u0005\u0006\u0003.\u0001\r!X\u0001\u000bI\u0016dW\r^3UsB,G#C/\u00028\u0005e\u00121HA\u001f\u0011\u0015IG\u00021\u0001k\u0011\u00159H\u00021\u0001y\u0011\u0015yH\u00021\u0001^\u0011\u0015\tE\u00021\u0001^\u0003))\b\u000fZ1uKRK\b/\u001a\u000b\n;\u0006\r\u0013QIA$\u0003\u0013BQ![\u0007A\u0002)DQa^\u0007A\u0002aDQa`\u0007A\u0002uCQ!Q\u0007A\u0002u\u000b!b\u0019:fCR,G+\u001f9f)%i\u0016qJA)\u0003'\n)\u0006C\u0003j\u001d\u0001\u0007!\u000eC\u0003x\u001d\u0001\u0007\u0001\u0010C\u0003\u0000\u001d\u0001\u0007Q\fC\u0003B\u001d\u0001\u0007Q,A\u0005de\u0016\fG/Z*j[RIQ,a\u0017\u0002^\u0005}\u0013\u0011\r\u0005\u0006S>\u0001\rA\u001b\u0005\u0006o>\u0001\r\u0001\u001f\u0005\u0006\u007f>\u0001\r!\u0018\u0005\u0006\u0003>\u0001\r!X\u0001\nkB$\u0017\r^3TS6$\u0012\"XA4\u0003S\nY'!\u001c\t\u000b%\u0004\u0002\u0019\u00016\t\u000b]\u0004\u0002\u0019\u0001=\t\u000b}\u0004\u0002\u0019A/\t\u000b\u0005\u0003\u0002\u0019A/\u0002\u0013\u0011,G.\u001a;f'&lG#C/\u0002t\u0005U\u0014qOA=\u0011\u0015I\u0017\u00031\u0001k\u0011\u00159\u0018\u00031\u0001y\u0011\u0015y\u0018\u00031\u0001^\u0011\u0015\t\u0015\u00031\u0001^\u0001")
public class SimController {
    private final LogUtil logUtil;
    private final MaterielSimDao materielSimDao;
    private final SimTypeDao simTypeDao;
    private final UserDao userDao;
    private final AuthorizationMaterielDao authorizationMaterielDao;

    public String getAllSims(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.getMateriel()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate entry for get all sims : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            Option withEquipment = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)withEquipment);
            String login2 = (String)tuple22._1();
            Option withEquipment2 = (Option)tuple22._2();
            Option option = $this.userDao.get(login2);
            if (option instanceof Some) {
                Some some;
                String string;
                Some some2 = (Some)option;
                User user = (User)some2.value();
                Option option2 = user.isAdmin();
                if (option2 instanceof Some && "1".equals(string = (String)(some = (Some)option2).value())) {
                    $this.logUtil.info(new StringBuilder(40).append("Get all sims for admin user with login: ").append(login2).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)$this.materielSimDao.getAllSims(BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SimOutput$.MODULE$.simFormat())).toString();
                }
                $this.logUtil.info(new StringBuilder(58).append("Get all sims for user with login: ").append(login2).append(" with contributor code: ").append(user.contributorCode()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.materielSimDao.getAllSims(BoxesRunTime.unboxToDouble((Object)user.contributorCode().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0)), login2, BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SimOutput$.MODULE$.simFormat())).toString();
            }
            $this.logUtil.info(new StringBuilder(39).append("Error on get all sims, cant find user: ").append(login2).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SimOutput$.MODULE$.simFormat())).toString();
        });
    }

    public String getSim(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Sim$.MODULE$.simUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(42).append("Error validate entry for get single sim : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String userLogin = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)userLogin);
            int id2 = tuple22._1$mcI$sp();
            String userLogin2 = (String)tuple22._2();
            Option option = $this.materielSimDao.getSim(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                SimOutput sim = (SimOutput)some.value();
                if ($this.authorizationMaterielDao.checkMateriel(id2, sim.administrator(), userLogin2, "mat_sim_situations", "idsim", "idsim")) {
                    return Json$.MODULE$.toJson((Object)sim, (Writes)SimOutput$.MODULE$.simFormat()).toString();
                }
                $this.logUtil.error(new StringBuilder(44).append("User ").append(userLogin2).append(" not authorize to access sim with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(25).append("Can't find sim with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getSimWithSubscription(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idAndUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(42).append("Error validate entry for get single sim : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String userLogin = (String)tuple2._1();
            int id = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)userLogin, (Object)BoxesRunTime.boxToInteger((int)id));
            String userLogin2 = (String)tuple22._1();
            int id2 = tuple22._2$mcI$sp();
            Option option = $this.materielSimDao.getSimWithSubscription(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                SimWithSubscription sim = (SimWithSubscription)some.value();
                if ($this.authorizationMaterielDao.checkMateriel(id2, sim.administrator(), userLogin2, "mat_sim_situations", "idsim", "idsim")) {
                    return Json$.MODULE$.toJson((Object)sim, (Writes)SimWithSubscription$.MODULE$.simFormat()).toString();
                }
                $this.logUtil.error(new StringBuilder(44).append("User ").append(userLogin2).append(" not authorize to access sim with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(25).append("Can't find sim with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getTypes(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.withEquipmentTypeRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)withEquipmentType -> {
            if (BoxesRunTime.unboxToBoolean((Object)withEquipmentType.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                return Json$.MODULE$.toJson((Object)$this.simTypeDao.getAllSimTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SimType$.MODULE$.format())).toString();
            }
            return Json$.MODULE$.toJson((Object)$this.simTypeDao.getSimTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SimType$.MODULE$.format())).toString();
        });
    }

    public String getType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielTypeRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> SimController.$anonfun$getType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String deleteType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielidUserRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)user);
            int id2 = tuple22._1$mcI$sp();
            String user2 = (String)tuple22._2();
            if ($this.materielSimDao.getSimsWithType(id2).isEmpty()) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.simTypeDao.deleteSimType(id2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.info("Wanted to delete a used sim type. Closing type.", $this.logUtil.info$default$2());
            if ($this.simTypeDao.closeType(id2, user2) > 0) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)206), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Unable to close type", MaterielUtils$.MODULE$.getJsonError$default$3());
        });
    }

    public String updateType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SimType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            SimType materielType = (SimType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            SimType materielType2 = (SimType)tuple22._2();
            Option option = materielType2.materielType();
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                Option option2 = $this.simTypeDao.getSimType(id);
                if (option2 instanceof Some) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.simTypeDao.updateSimType(materielType2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    return MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(28).append("Can't find sim type with id ").append(id).toString(), 404);
                }
                throw new MatchError((Object)option2);
            }
            if (None$.MODULE$.equals(option)) {
                return MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Can't read type id", 500);
            }
            throw new MatchError((Object)option);
        });
    }

    public String createType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SimType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            SimType materielType = (SimType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            SimType materielType2 = (SimType)tuple22._2();
            Tuple2 tuple23 = $this.simTypeDao.createSimType(materielType2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String createSim(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SimInput$.MODULE$.simInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate entry for create sim : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)simParam -> {
            Tuple2 tuple2 = simParam;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            SimInput sim = (SimInput)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)sim);
            String login2 = (String)tuple22._1();
            SimInput sim2 = (SimInput)tuple22._2();
            Some x$1 = new Some((Object)login2);
            Some x$2 = new Some((Object)DateTime.now());
            Option x$3 = sim2.copy$default$1();
            Option x$4 = sim2.copy$default$2();
            Option x$5 = sim2.copy$default$3();
            Option x$6 = sim2.copy$default$4();
            Option x$7 = sim2.copy$default$5();
            Option x$8 = sim2.copy$default$6();
            Option x$9 = sim2.copy$default$7();
            Option x$10 = sim2.copy$default$8();
            Option x$11 = sim2.copy$default$9();
            Option x$12 = sim2.copy$default$12();
            Option x$13 = sim2.copy$default$13();
            Option x$14 = sim2.copy$default$14();
            Option x$15 = sim2.copy$default$15();
            Option x$16 = sim2.copy$default$16();
            SimInput simInput = sim2.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$2, (Option)x$1, x$12, x$13, x$14, x$15, x$16);
            Tuple2 tuple23 = $this.materielSimDao.createSim(simInput);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateSim(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Sim$.MODULE$.simInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate entry for update sim : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)simParam -> {
            Tuple3 tuple3 = simParam;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int idP = BoxesRunTime.unboxToInt((Object)tuple3._1());
            String login = (String)tuple3._2();
            SimInput s = (SimInput)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idP), (Object)login, (Object)s);
            int idP2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            String login2 = (String)tuple32._2();
            SimInput s2 = (SimInput)tuple32._3();
            Option option = $this.materielSimDao.getSim(idP2);
            if (option instanceof Some) {
                Some x$1 = new Some((Object)login2);
                Some x$2 = new Some((Object)DateTime.now());
                Option x$3 = s2.copy$default$1();
                Option x$4 = s2.copy$default$2();
                Option x$5 = s2.copy$default$3();
                Option x$6 = s2.copy$default$4();
                Option x$7 = s2.copy$default$5();
                Option x$8 = s2.copy$default$6();
                Option x$9 = s2.copy$default$7();
                Option x$10 = s2.copy$default$8();
                Option x$11 = s2.copy$default$9();
                Option x$12 = s2.copy$default$12();
                Option x$13 = s2.copy$default$13();
                Option x$14 = s2.copy$default$14();
                Option x$15 = s2.copy$default$15();
                Option x$16 = s2.copy$default$16();
                SimInput simP = s2.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$2, (Option)x$1, x$12, x$13, x$14, x$15, x$16);
                Sim sim = Sim$.MODULE$.toSim(idP2, simP);
                int result = $this.materielSimDao.updateSim(sim);
                $this.logUtil.info(new StringBuilder(13).append("Update sim : ").append(Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()).toString()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Sim not found", 404);
            }
            throw new MatchError((Object)option);
        });
    }

    public String deleteSim(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Sim$.MODULE$.simRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate entry for delete sim : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> SimController.$anonfun$deleteSim$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public static final /* synthetic */ String $anonfun$getType$2(SimController $this, int id) {
        Option option = $this.simTypeDao.getSimType(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            SimType result = (SimType)some.value();
            return Json$.MODULE$.toJson((Object)result, (Writes)SimType$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(28).append("Can't find sim type with id ").append(id).toString(), 404);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$deleteSim$2(SimController $this, int id) {
        int result = $this.materielSimDao.deleteSim(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public SimController(LogUtil logUtil, MaterielSimDao materielSimDao, SimTypeDao simTypeDao, UserDao userDao, AuthorizationMaterielDao authorizationMaterielDao) {
        this.logUtil = logUtil;
        this.materielSimDao = materielSimDao;
        this.simTypeDao = simTypeDao;
        this.userDao = userDao;
        this.authorizationMaterielDao = authorizationMaterielDao;
    }
}

