/*
 * Decompiled with CFR 0.152.
 */
package controllers.sim;

import fr.aquasys.daeau.materiel.domain.output.FileOutput;
import fr.aquasys.daeau.materiel.domain.output.FileOutput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.File;
import java.io.Serializable;
import java.text.Normalizer;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import utils.FolderUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\t\u0012\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006YA\b\u0005\u0006U\u0001!\ta\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019\u0011\u0006\u0001)A\u0005w!91\u000b\u0001b\u0001\n\u0003!\u0006BB+\u0001A\u0003%q\tC\u0004W\u0001\t\u0007I\u0011\u0001+\t\r]\u0003\u0001\u0015!\u0003H\u0011\u001dA\u0006A1A\u0005\u0002QCa!\u0017\u0001!\u0002\u00139\u0005b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007K\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0019\u0004A\u0011A4\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\t\u00112+[7GS2,7oQ8oiJ|G\u000e\\3s\u0015\t\u00112#A\u0002tS6T\u0011\u0001F\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005}AS\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001B;uS2T!a\t\u0013\u0002\u0011I\f'MY5u[FT!!\n\u0014\u0002\u000f\u0005\fX/Y:zg*\tq%\u0001\u0002ge&\u0011\u0011\u0006\t\u0002\b\u0019><W\u000b^5m\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0006\u0002._A\u0011a\u0006A\u0007\u0002#!)QD\u0001a\u0002=!\u0012!!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\na!\u001b8kK\u000e$(\"\u0001\u001c\u0002\u000b)\fg/\u0019=\n\u0005a\u001a$AB%oU\u0016\u001cG/\u0001\u0005gS2,'+Z1e+\u0005Y\u0004c\u0001\u001fF\u000f6\tQH\u0003\u0002?\u007f\u0005!!n]8o\u0015\t\u0001\u0015)\u0001\u0003mS\n\u001c(B\u0001\"D\u0003\r\t\u0007/\u001b\u0006\u0002\t\u0006!\u0001\u000f\\1z\u0013\t1UHA\u0003SK\u0006$7\u000f\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015fi\u0011a\u0013\u0006\u0003\u0019V\ta\u0001\u0010:p_Rt\u0014B\u0001(\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059K\u0012!\u00034jY\u0016\u0014V-\u00193!\u00031!\u0017N]3di>\u0014\u00180\u00128w+\u00059\u0015!\u00043je\u0016\u001cGo\u001c:z\u000b:4\b%A\u0006eSJ4\u0015\u000e\\3t\u000b:4\u0018\u0001\u00043je\u001aKG.Z:F]Z\u0004\u0013\u0001C;sY\u001aKG.Z:\u0002\u0013U\u0014HNR5mKN\u0004\u0013aD1mY><X\t\u001f;f]NLwN\\:\u0016\u0003q\u00032!\u00182H\u001d\tq\u0006M\u0004\u0002K?&\t!$\u0003\u0002b3\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\r\u0019V-\u001d\u0006\u0003Cf\t\u0001#\u00197m_^,\u0005\u0010^3og&|gn\u001d\u0011\u0002\u0017\u001d,GoU5n\r&dWm\u001d\u000b\u0006\u000f\"lWo\u001e\u0005\u0006S6\u0001\rA[\u0001\b[\u0016\u001c8/Y4f!\ta4.\u0003\u0002m{\t9!j\u001d,bYV,\u0007\"\u00028\u000e\u0001\u0004y\u0017a\u00025fC\u0012,'o\u001d\t\u0005\u0011B<%/\u0003\u0002r#\n\u0019Q*\u00199\u0011\u0005a\u0019\u0018B\u0001;\u001a\u0005\r\te.\u001f\u0005\u0006m6\u0001\raR\u0001\u0007[>$W\u000f\\3\t\u000bal\u0001\u0019A$\u0002\tU\u001cXM]\u0001\u000bO\u0016$x*\u001e;qkR\u001cH#B>\u0002\u0012\u0005\u001d\u0002cA/cyB\u0019Q0!\u0004\u000e\u0003yT1a`A\u0001\u0003\u0019yW\u000f\u001e9vi*!\u00111AA\u0003\u0003\u0019!w.\\1j]*!\u0011qAA\u0005\u0003!i\u0017\r^3sS\u0016d'bAA\u0006I\u0005)A-Y3bk&\u0019\u0011q\u0002@\u0003\u0015\u0019KG.Z(viB,H\u000fC\u0004\u0002\u00149\u0001\r!!\u0006\u0002\t1L7\u000f\u001e\t\u0005;\n\f9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0005%|'BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00121\u0004\u0002\u0005\r&dW\r\u0003\u0004\u0002*9\u0001\raR\u0001\u0004kJd\u0017aB4fi:\u000bW.\u001a\u000b\u0004\u000f\u0006=\u0002BBA\u0019\u001f\u0001\u0007q)\u0001\u0005oC6,g)\u001b7f\u0001")
public class SimFilesController {
    private final LogUtil logUtil;
    private final Reads<String> fileRead;
    private final String directoryEnv;
    private final String dirFilesEnv;
    private final String urlFiles;
    private final Seq<String> allowExtensions;

    public Reads<String> fileRead() {
        return this.fileRead;
    }

    public String directoryEnv() {
        return this.directoryEnv;
    }

    public String dirFilesEnv() {
        return this.dirFilesEnv;
    }

    public String urlFiles() {
        return this.urlFiles;
    }

    public Seq<String> allowExtensions() {
        return this.allowExtensions;
    }

    public String getSimFiles(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.fileRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get files :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> {
            String string = System.getenv(this.dirFilesEnv());
            String string2 = System.getenv(this.urlFiles());
            File directory = new File(new StringBuilder(13).append(string).append("MATERIEL/SIM/").toString());
            Seq<File> listFiles = FolderUtil$.MODULE$.getListOfFilesWithExtensions(directory, this.allowExtensions());
            Seq<File> seq = FolderUtil$.MODULE$.getListOfFilesWithExpression(listFiles, (String)code);
            Seq<FileOutput> resultOutput = this.getOutputs(seq, string2);
            return Json$.MODULE$.toJson(resultOutput, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
        });
    }

    public Seq<FileOutput> getOutputs(Seq<File> list, String url) {
        return (Seq)list.map((Function1 & Serializable)file -> {
            $this.logUtil.info(new StringBuilder(7).append("File : ").append(file.getAbsolutePath()).toString(), $this.logUtil.info$default$2());
            String normalizerName = Normalizer.normalize(file.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            String name = this.getName(normalizerName);
            String string = System.getenv(this.directoryEnv());
            String listPathEnv = file.getAbsolutePath().substring(string.length(), file.getAbsolutePath().length());
            listPathEnv = listPathEnv.replaceAll("\\\\", "/");
            if (!listPathEnv.isEmpty()) {
                return new FileOutput(new StringBuilder(0).append(url).append(listPathEnv).toString(), name, file.length(), file.lastModified());
            }
            return new FileOutput(new StringBuilder(0).append(url).append(file.getName()).toString(), name, file.length(), file.lastModified());
        });
    }

    public String getName(String nameFile) {
        String[] splitName = nameFile.split(".");
        if (splitName.length > 1) {
            String[] splitNameUnderscore = splitName[0].split("_");
            String[] splitNameSpace = splitName[0].split(" ");
            if (splitNameUnderscore.length > 1) {
                return splitNameUnderscore[1];
            }
            if (splitNameSpace.length > 1) {
                return splitNameSpace[1];
            }
            return nameFile;
        }
        return nameFile;
    }

    @Inject
    public SimFilesController(LogUtil logUtil) {
        this.logUtil = logUtil;
        this.fileRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
        this.directoryEnv = "UPLOAD_DIRECTORY";
        this.dirFilesEnv = "DOCUMENTS_DIRECTORY";
        this.urlFiles = "URL_UTILS";
        this.allowExtensions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".doc", ".DOC", ".docx", ".DOCX", ".xls", ".XLS", ".xlsx", ".XLSX", ".pdf", ".PDF"}));
    }
}

