/*
 * Decompiled with CFR 0.152.
 */
package controllers.subscription;

import fr.aquasys.daeau.materiel.domain.Input.SubscriptionInput;
import fr.aquasys.daeau.materiel.domain.Input.SubscriptionInput$;
import fr.aquasys.daeau.materiel.domain.model.subscription.Subscription;
import fr.aquasys.daeau.materiel.domain.model.subscription.Subscription$;
import fr.aquasys.daeau.materiel.domain.model.subscription.SubscriptionType$;
import fr.aquasys.daeau.materiel.itf.AuthorizationMaterielDao;
import fr.aquasys.daeau.materiel.itf.subscription.SubscriptionDao;
import fr.aquasys.daeau.materiel.itf.subscription.SubscriptionTypeDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import utils.MaterielUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!A!\u0002\u0013)\u0005\"B%\u0001\t\u0003Q\u0005\"B.\u0001\t\u0003a\u0006bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\n\u0001\t\u0003\tI\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\u0012acU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cuN\u001c;s_2dWM\u001d\u0006\u0003)U\tAb];cg\u000e\u0014\u0018\u000e\u001d;j_:T\u0011AF\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001B;uS2T!!\n\u0014\u0002\u0011I\f'MY5u[FT!a\n\u0015\u0002\u000f\u0005\fX/Y:zg*\t\u0011&\u0001\u0002ge&\u00111F\t\u0002\b\u0019><W\u000b^5m\u0003=\u0019XOY:de&\u0004H/[8o\t\u0006|\u0007C\u0001\u00187\u001b\u0005y#B\u0001\u000b1\u0015\t\t$'A\u0002ji\u001aT!a\r\u001b\u0002\u00115\fG/\u001a:jK2T!!\u000e\u0014\u0002\u000b\u0011\fW-Y;\n\u0005]z#aD*vEN\u001c'/\u001b9uS>tG)Y8\u0002'M,(m]2sSB$\u0018n\u001c8UsB,G)Y8\u0011\u00059R\u0014BA\u001e0\u0005M\u0019VOY:de&\u0004H/[8o)f\u0004X\rR1p\u0003\u001d)8/\u001a:EC>\u0004\"A\u0010\"\u000e\u0003}R!!\r!\u000b\u0005\u0005#\u0014\u0001B;tKJL!aQ \u0003\u000fU\u001bXM\u001d#b_\u0006A\u0012-\u001e;i_JL'0\u0019;j_:l\u0015\r^3sS\u0016dG)Y8\u0011\u0005\u0019;U\"\u0001\u0019\n\u0005!\u0003$\u0001G!vi\"|'/\u001b>bi&|g.T1uKJLW\r\u001c#b_\u00061A(\u001b8jiz\"baS'O\u001fB\u000b\u0006C\u0001'\u0001\u001b\u0005\u0019\u0002\"B\u0010\u0007\u0001\u0004\u0001\u0003\"\u0002\u0017\u0007\u0001\u0004i\u0003\"\u0002\u001d\u0007\u0001\u0004I\u0004\"\u0002\u001f\u0007\u0001\u0004i\u0004\"\u0002#\u0007\u0001\u0004)\u0005F\u0001\u0004T!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0004j]*,7\r\u001e\u0006\u00021\u0006)!.\u0019<bq&\u0011!,\u0016\u0002\u0007\u0013:TWm\u0019;\u0002%\u001d,G/\u00117m'V\u00147o\u0019:jaRLwN\u001c\u000b\u0007;\"4h0!\u0001\u0011\u0005y+gBA0d!\t\u00017$D\u0001b\u0015\t\u0011w#\u0001\u0004=e>|GOP\u0005\u0003In\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011Am\u0007\u0005\u0006S\u001e\u0001\rA[\u0001\b[\u0016\u001c8/Y4f!\tYG/D\u0001m\u0015\tig.\u0001\u0003kg>t'BA8q\u0003\u0011a\u0017NY:\u000b\u0005E\u0014\u0018aA1qS*\t1/\u0001\u0003qY\u0006L\u0018BA;m\u0005\u001dQ5OV1mk\u0016DQa^\u0004A\u0002a\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003_sv[\u0018B\u0001>h\u0005\ri\u0015\r\u001d\t\u00035qL!!`\u000e\u0003\u0007\u0005s\u0017\u0010C\u0003\u0000\u000f\u0001\u0007Q,\u0001\u0004n_\u0012,H.\u001a\u0005\u0006\u0003\u001e\u0001\r!X\u0001\u0010O\u0016$8+\u001e2tGJL\u0007\u000f^5p]RIQ,a\u0002\u0002\n\u0005-\u0011Q\u0002\u0005\u0006S\"\u0001\rA\u001b\u0005\u0006o\"\u0001\r\u0001\u001f\u0005\u0006\u007f\"\u0001\r!\u0018\u0005\u0006\u0003\"\u0001\r!X\u0001\u0013GJ,\u0017\r^3Tk\n\u001c8M]5qi&|g\u000eF\u0005^\u0003'\t)\"a\u0006\u0002\u001a!)\u0011.\u0003a\u0001U\")q/\u0003a\u0001q\")q0\u0003a\u0001;\")\u0011)\u0003a\u0001;\u0006\u0011R\u000f\u001d3bi\u0016\u001cVOY:de&\u0004H/[8o)%i\u0016qDA\u0011\u0003G\t)\u0003C\u0003j\u0015\u0001\u0007!\u000eC\u0003x\u0015\u0001\u0007\u0001\u0010C\u0003\u0000\u0015\u0001\u0007Q\fC\u0003B\u0015\u0001\u0007Q,\u0001\neK2,G/Z*vEN\u001c'/\u001b9uS>tG#C/\u0002,\u00055\u0012qFA\u0019\u0011\u0015I7\u00021\u0001k\u0011\u001598\u00021\u0001y\u0011\u0015y8\u00021\u0001^\u0011\u0015\t5\u00021\u0001^\u0003)9W\r^!mYRK\b/\u001a\u000b\n;\u0006]\u0012\u0011HA\u001e\u0003{AQ!\u001b\u0007A\u0002)DQa\u001e\u0007A\u0002aDQa \u0007A\u0002uCQ!\u0011\u0007A\u0002u\u000b1cZ3u'V\u00147o\u0019:jaRLwN\u001c+za\u0016$\u0012\"XA\"\u0003\u000b\n9%!\u0013\t\u000b%l\u0001\u0019\u00016\t\u000b]l\u0001\u0019\u0001=\t\u000b}l\u0001\u0019A/\t\u000b\u0005k\u0001\u0019A/\u0002-\r\u0014X-\u0019;f'V\u00147o\u0019:jaRLwN\u001c+za\u0016$\u0012\"XA(\u0003#\n\u0019&!\u0016\t\u000b%t\u0001\u0019\u00016\t\u000b]t\u0001\u0019\u0001=\t\u000b}t\u0001\u0019A/\t\u000b\u0005s\u0001\u0019A/\u0002-U\u0004H-\u0019;f'V\u00147o\u0019:jaRLwN\u001c+za\u0016$\u0012\"XA.\u0003;\ny&!\u0019\t\u000b%|\u0001\u0019\u00016\t\u000b]|\u0001\u0019\u0001=\t\u000b}|\u0001\u0019A/\t\u000b\u0005{\u0001\u0019A/\u0002-\u0011,G.\u001a;f'V\u00147o\u0019:jaRLwN\u001c+za\u0016$\u0012\"XA4\u0003S\nY'!\u001c\t\u000b%\u0004\u0002\u0019\u00016\t\u000b]\u0004\u0002\u0019\u0001=\t\u000b}\u0004\u0002\u0019A/\t\u000b\u0005\u0003\u0002\u0019A/\u0002-\u001d,G/\u00117m'&lG*Y:u'&$X/\u0019;j_:$\u0012\"XA:\u0003k\n9(!\u001f\t\u000b%\f\u0002\u0019\u00016\t\u000b]\f\u0002\u0019\u0001=\t\u000b}\f\u0002\u0019A/\t\u000b\u0005\u000b\u0002\u0019A/")
public class SubscriptionController {
    private final LogUtil logUtil;
    private final SubscriptionDao subscriptionDao;
    private final SubscriptionTypeDao subscriptionTypeDao;
    private final UserDao userDao;
    private final AuthorizationMaterielDao authorizationMaterielDao;

    public String getAllSubscription(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.userReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Error validate entry for get all subscriptions : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)userLogin -> {
            Option option = $this.userDao.get(userLogin);
            if (option instanceof Some) {
                Some some;
                String string;
                Some some2 = (Some)option;
                User user = (User)some2.value();
                Option option2 = user.isAdmin();
                if (option2 instanceof Some && "1".equals(string = (String)(some = (Some)option2).value())) {
                    $this.logUtil.info(new StringBuilder(50).append("Get all subscriptions for admin user with login : ").append((String)userLogin).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)$this.subscriptionDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Subscription$.MODULE$.subscriptionFormat())).toString();
                }
                $this.logUtil.info(new StringBuilder(69).append("Get all subscriptions for user with login : ").append((String)userLogin).append(" with contributor code : ").append(user.contributorCode()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.subscriptionDao.getAll(BoxesRunTime.unboxToDouble((Object)user.contributorCode().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0)), userLogin), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Subscription$.MODULE$.subscriptionFormat())).toString();
            }
            $this.logUtil.info(new StringBuilder(75).append("Error on get all subscriptions after return error on get user with login : ").append((String)userLogin).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Subscription$.MODULE$.subscriptionFormat())).toString();
        });
    }

    public String getSubscription(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idAndUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error("Error validate entry for get single subscription : $error", $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String userLogin = (String)tuple2._1();
            int id = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)userLogin, (Object)BoxesRunTime.boxToInteger((int)id));
            String userLogin2 = (String)tuple22._1();
            int id2 = tuple22._2$mcI$sp();
            Option option = $this.subscriptionDao.get(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                Subscription subscription = (Subscription)some.value();
                if ($this.authorizationMaterielDao.checkMateriel(id2, subscription.managerCode(), userLogin2, "mat_abonnements_situations", "idabonnement", "idabonnement")) {
                    return Json$.MODULE$.toJson((Object)subscription, (Writes)Subscription$.MODULE$.subscriptionFormat()).toString();
                }
                $this.logUtil.error(new StringBuilder(53).append("User ").append(userLogin2).append(" not authorize to access subscription with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error("Can't find subscription with id : $id", $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String createSubscription(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SubscriptionInput$.MODULE$.subscriptionInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate entry for create subscription : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)subscriptionParam -> {
            Tuple2 tuple2 = subscriptionParam;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            SubscriptionInput subscription = (SubscriptionInput)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)subscription);
            String login2 = (String)tuple22._1();
            SubscriptionInput subscription2 = (SubscriptionInput)tuple22._2();
            Some x$1 = new Some((Object)login2);
            Some x$2 = new Some((Object)DateTime.now());
            Option x$3 = subscription2.copy$default$1();
            Option x$4 = subscription2.copy$default$2();
            Option x$5 = subscription2.copy$default$3();
            Option x$6 = subscription2.copy$default$4();
            Option x$7 = subscription2.copy$default$5();
            Option x$8 = subscription2.copy$default$6();
            Option x$9 = subscription2.copy$default$7();
            Option x$10 = subscription2.copy$default$8();
            Option x$11 = subscription2.copy$default$9();
            Option x$12 = subscription2.copy$default$10();
            Option x$13 = subscription2.copy$default$11();
            Option x$14 = subscription2.copy$default$14();
            SubscriptionInput subscriptionInput = subscription2.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option)x$2, (Option)x$1, x$14);
            Tuple2 tuple23 = $this.subscriptionDao.create(subscriptionInput);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateSubscription(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Subscription$.MODULE$.subscriptionInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate entry for update subscription : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)subscriptionParam -> {
            Tuple3 tuple3 = subscriptionParam;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int idP = BoxesRunTime.unboxToInt((Object)tuple3._1());
            String login = (String)tuple3._2();
            SubscriptionInput a = (SubscriptionInput)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idP), (Object)login, (Object)a);
            int idP2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            String login2 = (String)tuple32._2();
            SubscriptionInput a2 = (SubscriptionInput)tuple32._3();
            Option option = $this.subscriptionDao.get(idP2);
            if (option instanceof Some) {
                Some x$1 = new Some((Object)login2);
                Some x$2 = new Some((Object)DateTime.now());
                Option x$3 = a2.copy$default$1();
                Option x$4 = a2.copy$default$2();
                Option x$5 = a2.copy$default$3();
                Option x$6 = a2.copy$default$4();
                Option x$7 = a2.copy$default$5();
                Option x$8 = a2.copy$default$6();
                Option x$9 = a2.copy$default$7();
                Option x$10 = a2.copy$default$8();
                Option x$11 = a2.copy$default$9();
                Option x$12 = a2.copy$default$10();
                Option x$13 = a2.copy$default$11();
                Option x$14 = a2.copy$default$14();
                SubscriptionInput subscriptionP = a2.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option)x$2, (Option)x$1, x$14);
                Subscription subscription = Subscription$.MODULE$.toSubscription(idP2, subscriptionP);
                int result = $this.subscriptionDao.update(subscription);
                $this.logUtil.info(new StringBuilder(22).append("Update subscription : ").append(Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()).toString()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return MaterielUtils$.MODULE$.getJsonError($this.logUtil, "subscription not found", 404);
            }
            throw new MatchError((Object)option);
        });
    }

    public String deleteSubscription(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Subscription$.MODULE$.subscriptionRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate entry for delete subscription : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> SubscriptionController.$anonfun$deleteSubscription$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String getAllType(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.subscriptionTypeDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SubscriptionType$.MODULE$.format())).toString();
    }

    public String getSubscriptionType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Error validate entry for get subscription type : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> SubscriptionController.$anonfun$getSubscriptionType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String createSubscriptionType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)SubscriptionType$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(52).append("Error validate entry for create subscription type : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)subscriptionType -> {
            Tuple2 res = $this.subscriptionTypeDao.create(subscriptionType, user);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res._1$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res._2$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateSubscriptionType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)SubscriptionType$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(52).append("Error validate entry for update subscription type : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)subscriptionType -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.subscriptionTypeDao.update(subscriptionType, user)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String deleteSubscriptionType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(52).append("Error validate entry for delete subscription type : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> SubscriptionController.$anonfun$deleteSubscriptionType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String getAllSimLastSituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.subscriptionDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Subscription$.MODULE$.subscriptionFormat())).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteSubscription$2(SubscriptionController $this, int id) {
        int result = $this.subscriptionDao.delete(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getSubscriptionType$2(SubscriptionController $this, int id) {
        return Json$.MODULE$.toJson((Object)$this.subscriptionTypeDao.get(id), Writes$.MODULE$.OptionWrites((Writes)SubscriptionType$.MODULE$.format())).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteSubscriptionType$2(SubscriptionController $this, int id) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.subscriptionTypeDao.delete(id)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public SubscriptionController(LogUtil logUtil, SubscriptionDao subscriptionDao, SubscriptionTypeDao subscriptionTypeDao, UserDao userDao, AuthorizationMaterielDao authorizationMaterielDao) {
        this.logUtil = logUtil;
        this.subscriptionDao = subscriptionDao;
        this.subscriptionTypeDao = subscriptionTypeDao;
        this.userDao = userDao;
        this.authorizationMaterielDao = authorizationMaterielDao;
    }
}

