/*
 * Decompiled with CFR 0.152.
 */
package controllers.telecom;

import fr.aquasys.daeau.materiel.domain.Input.TelecomInput;
import fr.aquasys.daeau.materiel.domain.Input.TelecomInput$;
import fr.aquasys.daeau.materiel.domain.model.MaterielType$;
import fr.aquasys.daeau.materiel.domain.model.telecom.Telecom;
import fr.aquasys.daeau.materiel.domain.model.telecom.Telecom$;
import fr.aquasys.daeau.materiel.domain.model.telecom.TelecomType;
import fr.aquasys.daeau.materiel.domain.model.telecom.TelecomType$;
import fr.aquasys.daeau.materiel.domain.output.TelecomOutput;
import fr.aquasys.daeau.materiel.domain.output.TelecomOutput$;
import fr.aquasys.daeau.materiel.itf.AuthorizationMaterielDao;
import fr.aquasys.daeau.materiel.itf.telecom.TelecomDao;
import fr.aquasys.daeau.materiel.itf.telecom.TelecomTypeDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.MaterielUtils$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import utils.CommonReadUtil$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\t\u0013\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0002.\u0001\t\u0003Y\u0006bBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0005E!V\r\\3d_6\u001cuN\u001c;s_2dWM\u001d\u0006\u0003'Q\tq\u0001^3mK\u000e|WNC\u0001\u0016\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011\u0001%K\u0007\u0002C)\u0011!eI\u0001\u0005kRLGN\u0003\u0002%K\u0005A!/\u00192cSRl\u0017O\u0003\u0002'O\u00059\u0011-];bgf\u001c(\"\u0001\u0015\u0002\u0005\u0019\u0014\u0018B\u0001\u0016\"\u0005\u001daunZ+uS2\f!\u0002^3mK\u000e|W\u000eR1p!\tiS'D\u0001/\u0015\t\u0019rF\u0003\u00021c\u0005\u0019\u0011\u000e\u001e4\u000b\u0005I\u001a\u0014\u0001C7bi\u0016\u0014\u0018.\u001a7\u000b\u0005Q*\u0013!\u00023bK\u0006,\u0018B\u0001\u001c/\u0005)!V\r\\3d_6$\u0015m\\\u0001\u000fi\u0016dWmY8n)f\u0004X\rR1p!\ti\u0013(\u0003\u0002;]\tqA+\u001a7fG>lG+\u001f9f\t\u0006|\u0017aB;tKJ$\u0015m\u001c\t\u0003{\u0005k\u0011A\u0010\u0006\u0003a}R!\u0001Q\u001a\u0002\tU\u001cXM]\u0005\u0003\u0005z\u0012q!V:fe\u0012\u000bw.\u0001\rbkRDwN]5{CRLwN\\'bi\u0016\u0014\u0018.\u001a7EC>\u0004\"!\u0012$\u000e\u0003=J!aR\u0018\u00031\u0005+H\u000f[8sSj\fG/[8o\u001b\u0006$XM]5fY\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0007\u00152kej\u0014)\u0011\u0005-\u0003Q\"\u0001\n\t\u000by1\u0001\u0019A\u0010\t\u000b-2\u0001\u0019\u0001\u0017\t\u000b]2\u0001\u0019\u0001\u001d\t\u000bm2\u0001\u0019\u0001\u001f\t\u000b\r3\u0001\u0019\u0001#)\u0005\u0019\u0011\u0006CA*Y\u001b\u0005!&BA+W\u0003\u0019IgN[3di*\tq+A\u0003kCZ\f\u00070\u0003\u0002Z)\n1\u0011J\u001c6fGR\faaZ3u\u00032dG#\u0002/hkv|\bCA/e\u001d\tq&\r\u0005\u0002`55\t\u0001M\u0003\u0002b-\u00051AH]8pizJ!a\u0019\u000e\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GjAQ\u0001[\u0004A\u0002%\fq!\\3tg\u0006<W\r\u0005\u0002kg6\t1N\u0003\u0002m[\u0006!!n]8o\u0015\tqw.\u0001\u0003mS\n\u001c(B\u00019r\u0003\r\t\u0007/\u001b\u0006\u0002e\u0006!\u0001\u000f\\1z\u0013\t!8NA\u0004KgZ\u000bG.^3\t\u000bY<\u0001\u0019A<\u0002\u000f!,\u0017\rZ3sgB!Q\f\u001f/{\u0013\tIhMA\u0002NCB\u0004\"!G>\n\u0005qT\"aA!os\")ap\u0002a\u00019\u00061Qn\u001c3vY\u0016DQ\u0001Q\u0004A\u0002q\u000b1aZ3u)%a\u0016QAA\u0004\u0003\u0013\tY\u0001C\u0003i\u0011\u0001\u0007\u0011\u000eC\u0003w\u0011\u0001\u0007q\u000fC\u0003\u007f\u0011\u0001\u0007A\fC\u0003A\u0011\u0001\u0007A,\u0001\u0005hKR$\u0016\u0010]3t)%a\u0016\u0011CA\n\u0003+\t9\u0002C\u0003i\u0013\u0001\u0007\u0011\u000eC\u0003w\u0013\u0001\u0007q\u000fC\u0003\u007f\u0013\u0001\u0007A\fC\u0003A\u0013\u0001\u0007A,A\u0004hKR$\u0016\u0010]3\u0015\u0013q\u000bi\"a\b\u0002\"\u0005\r\u0002\"\u00025\u000b\u0001\u0004I\u0007\"\u0002<\u000b\u0001\u00049\b\"\u0002@\u000b\u0001\u0004a\u0006\"\u0002!\u000b\u0001\u0004a\u0016A\u00033fY\u0016$X\rV=qKRIA,!\u000b\u0002,\u00055\u0012q\u0006\u0005\u0006Q.\u0001\r!\u001b\u0005\u0006m.\u0001\ra\u001e\u0005\u0006}.\u0001\r\u0001\u0018\u0005\u0006\u0001.\u0001\r\u0001X\u0001\u000bkB$\u0017\r^3UsB,G#\u0003/\u00026\u0005]\u0012\u0011HA\u001e\u0011\u0015AG\u00021\u0001j\u0011\u00151H\u00021\u0001x\u0011\u0015qH\u00021\u0001]\u0011\u0015\u0001E\u00021\u0001]\u0003)\u0019'/Z1uKRK\b/\u001a\u000b\n9\u0006\u0005\u00131IA#\u0003\u000fBQ\u0001[\u0007A\u0002%DQA^\u0007A\u0002]DQA`\u0007A\u0002qCQ\u0001Q\u0007A\u0002q\u000bQb\u0019:fCR,G+\u001a7fG>lG#\u0003/\u0002N\u0005=\u0013\u0011KA*\u0011\u0015Ag\u00021\u0001j\u0011\u00151h\u00021\u0001x\u0011\u0015qh\u00021\u0001]\u0011\u0015\u0001e\u00021\u0001]\u00035)\b\u000fZ1uKR+G.Z2p[RIA,!\u0017\u0002\\\u0005u\u0013q\f\u0005\u0006Q>\u0001\r!\u001b\u0005\u0006m>\u0001\ra\u001e\u0005\u0006}>\u0001\r\u0001\u0018\u0005\u0006\u0001>\u0001\r\u0001X\u0001\u000eI\u0016dW\r^3UK2,7m\\7\u0015\u0013q\u000b)'a\u001a\u0002j\u0005-\u0004\"\u00025\u0011\u0001\u0004I\u0007\"\u0002<\u0011\u0001\u00049\b\"\u0002@\u0011\u0001\u0004a\u0006\"\u0002!\u0011\u0001\u0004a\u0006")
public class TelecomController {
    private final LogUtil logUtil;
    private final TelecomDao telecomDao;
    private final TelecomTypeDao telecomTypeDao;
    private final UserDao userDao;
    private final AuthorizationMaterielDao authorizationMaterielDao;

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.getMateriel()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate entry for get all telecoms : ").append(error.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            Option withEquipment = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)withEquipment);
            String login2 = (String)tuple22._1();
            Option withEquipment2 = (Option)tuple22._2();
            Option option = $this.userDao.get(login2);
            if (option instanceof Some) {
                Some some;
                String string;
                Some some2 = (Some)option;
                User user = (User)some2.value();
                Option option2 = user.isAdmin();
                if (option2 instanceof Some && "1".equals(string = (String)(some = (Some)option2).value())) {
                    $this.logUtil.info(new StringBuilder(44).append("Get all telecoms for admin user with login: ").append(login2).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)$this.telecomDao.getAll(BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)TelecomOutput$.MODULE$.telecomFormat())).toString();
                }
                $this.logUtil.info(new StringBuilder(62).append("Get all telecoms for user with login: ").append(login2).append(" with contributor code: ").append(user.contributorCode()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.telecomDao.getAll(BoxesRunTime.unboxToDouble((Object)user.contributorCode().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0)), login2, BoxesRunTime.unboxToBoolean((Object)withEquipment2.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)TelecomOutput$.MODULE$.telecomFormat())).toString();
            }
            $this.logUtil.info(new StringBuilder(43).append("Error on get all telecoms, cant find user: ").append(login2).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)TelecomOutput$.MODULE$.telecomFormat())).toString();
        });
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Telecom$.MODULE$.telecomUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate entry for get single telecom : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            Tuple2 tuple2 = validateRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String userLogin = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)userLogin);
            int id2 = tuple22._1$mcI$sp();
            String userLogin2 = (String)tuple22._2();
            Option option = $this.telecomDao.get(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                TelecomOutput telecom = (TelecomOutput)some.value();
                if ($this.authorizationMaterielDao.checkMateriel(id2, telecom.administrator(), userLogin2, "mat_telecom_situations", "idtelecom", "idtelecom")) {
                    return Json$.MODULE$.toJson((Object)telecom, (Writes)TelecomOutput$.MODULE$.telecomFormat()).toString();
                }
                $this.logUtil.error(new StringBuilder(48).append("User ").append(userLogin2).append(" not authorize to access telecom with id : ").append(id2).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(29).append("Can't find telecom with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getTypes(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.withEquipmentTypeRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)withEquipmentType -> {
            if (BoxesRunTime.unboxToBoolean((Object)withEquipmentType.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                return Json$.MODULE$.toJson((Object)$this.telecomTypeDao.getAllTelecomTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)TelecomType$.MODULE$.format())).toString();
            }
            return Json$.MODULE$.toJson((Object)$this.telecomTypeDao.getTelecomTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)TelecomType$.MODULE$.format())).toString();
        });
    }

    public String getType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielTypeRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> TelecomController.$anonfun$getType$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String deleteType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(MaterielType$.MODULE$.materielidUserRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)user);
            int id2 = tuple22._1$mcI$sp();
            String user2 = (String)tuple22._2();
            if ($this.telecomDao.getTelecomsWithType(id2).isEmpty()) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.telecomTypeDao.deleteTelecomType(id2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.info("Wanted to delete a used telecom type. Closing type.", $this.logUtil.info$default$2());
            if ($this.telecomTypeDao.closeType(id2, user2) > 0) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)206), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Unable to close type", utils.MaterielUtils$.MODULE$.getJsonError$default$3());
        });
    }

    public String updateType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(TelecomType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            TelecomType materielType = (TelecomType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            TelecomType materielType2 = (TelecomType)tuple22._2();
            Option option = materielType2.materielType();
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                Option option2 = $this.telecomTypeDao.getTelecomType(id);
                if (option2 instanceof Some) {
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.telecomTypeDao.updateTelecomType(materielType2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(32).append("Can't find telecom type with id ").append(id).toString(), 404);
                }
                throw new MatchError((Object)option2);
            }
            if (None$.MODULE$.equals(option)) {
                return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Can't read type id", 500);
            }
            throw new MatchError((Object)option);
        });
    }

    public String createType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(TelecomType$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), utils.MaterielUtils$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            TelecomType materielType = (TelecomType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)materielType);
            String user2 = (String)tuple22._1();
            TelecomType materielType2 = (TelecomType)tuple22._2();
            Tuple2 tuple23 = $this.telecomTypeDao.createTelecomType(materielType2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int id = tuple23._1$mcI$sp();
            int result = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
            int id2 = sp2._1$mcI$sp();
            int result2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String createTelecom(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(TelecomInput$.MODULE$.telecomInputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), 400), (Function1 & Serializable)telecomParam -> {
            block6: {
                Option x$24;
                Option x$23;
                Option x$22;
                Option x$21;
                Option x$20;
                Option x$19;
                Option x$18;
                Option x$17;
                Option x$16;
                Option x$15;
                Option x$14;
                Option x$13;
                Option x$12;
                Option x$11;
                Option x$10;
                Option x$9;
                Option x$8;
                Option x$7;
                Option x$6;
                Option x$5;
                Option x$4;
                TelecomInput telecom;
                String login;
                block5: {
                    Tuple2 tuple2 = telecomParam;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String login2 = (String)tuple2._1();
                    TelecomInput telecom2 = (TelecomInput)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)login2, (Object)telecom2);
                    login = (String)tuple22._1();
                    telecom = (TelecomInput)tuple22._2();
                    if (telecom.reference().isEmpty()) break block5;
                    Object object = telecom.reference().get();
                    String string = "";
                    if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)telecom.reference().get(), 6, $this.authorizationMaterielDao.checkReference$default$3())) break block6;
                }
                Some x$1 = new Some((Object)login);
                Some x$2 = new Some((Object)DateTime.now());
                Option x$3 = telecom.copy$default$1();
                TelecomInput telecomInput = telecom.copy(x$3, x$4 = telecom.copy$default$2(), x$5 = telecom.copy$default$3(), x$6 = telecom.copy$default$4(), x$7 = telecom.copy$default$5(), x$8 = telecom.copy$default$6(), x$9 = telecom.copy$default$7(), (Option)x$2, (Option)x$1, x$10 = telecom.copy$default$10(), x$11 = telecom.copy$default$11(), x$12 = telecom.copy$default$12(), x$13 = telecom.copy$default$13(), x$14 = telecom.copy$default$14(), x$15 = telecom.copy$default$15(), x$16 = telecom.copy$default$16(), x$17 = telecom.copy$default$17(), x$18 = telecom.copy$default$18(), x$19 = telecom.copy$default$19(), x$20 = telecom.copy$default$20(), x$21 = telecom.copy$default$21(), x$22 = telecom.copy$default$22(), x$23 = telecom.copy$default$23(), x$24 = telecom.copy$default$24());
                Tuple2 tuple2 = $this.telecomDao.createTelecom(telecomInput);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                int result = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
                int id2 = sp2._1$mcI$sp();
                int result2 = sp2._2$mcI$sp();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateTelecom(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Telecom$.MODULE$.telecomInputRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), 400), (Function1 & Serializable)telecomParam -> {
            Option option;
            block5: {
                block7: {
                    TelecomInput t;
                    String login;
                    int idP;
                    block6: {
                        Tuple3 tuple3 = telecomParam;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int idP2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        String login2 = (String)tuple3._2();
                        TelecomInput t2 = (TelecomInput)tuple3._3();
                        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idP2), (Object)login2, (Object)t2);
                        idP = BoxesRunTime.unboxToInt((Object)tuple32._1());
                        login = (String)tuple32._2();
                        t = (TelecomInput)tuple32._3();
                        option = $this.telecomDao.get(idP);
                        if (!(option instanceof Some)) break block5;
                        if ($this.authorizationMaterielDao.isEquipment(MaterielUtils$.MODULE$.telecomTypeLabel(), idP) || t.reference().isEmpty()) break block6;
                        Object object = t.reference().get();
                        String string = "";
                        if ((object == null ? string != null : !object.equals(string)) && $this.authorizationMaterielDao.checkReference((String)t.reference().get(), 6, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)idP)))) break block7;
                    }
                    Some x$1 = new Some((Object)login);
                    Some x$2 = new Some((Object)DateTime.now());
                    Option x$3 = t.copy$default$1();
                    Option x$4 = t.copy$default$2();
                    Option x$5 = t.copy$default$3();
                    Option x$6 = t.copy$default$4();
                    Option x$7 = t.copy$default$5();
                    Option x$8 = t.copy$default$6();
                    Option x$9 = t.copy$default$7();
                    Option x$10 = t.copy$default$10();
                    Option x$11 = t.copy$default$11();
                    Option x$12 = t.copy$default$12();
                    Option x$13 = t.copy$default$13();
                    Option x$14 = t.copy$default$14();
                    Option x$15 = t.copy$default$15();
                    Option x$16 = t.copy$default$16();
                    Option x$17 = t.copy$default$17();
                    Option x$18 = t.copy$default$18();
                    Option x$19 = t.copy$default$19();
                    Option x$20 = t.copy$default$20();
                    Option x$21 = t.copy$default$21();
                    Option x$22 = t.copy$default$22();
                    Option x$23 = t.copy$default$23();
                    Option x$24 = t.copy$default$24();
                    TelecomInput telecomP = t.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option)x$2, (Option)x$1, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
                    Telecom telecom = Telecom$.MODULE$.toTelecom(idP, telecomP);
                    int result = $this.telecomDao.updateTelecom(telecom);
                    $this.logUtil.info(new StringBuilder(17).append("Update telecom : ").append(Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()).toString()).toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, "Telecom not found", 404);
            }
            throw new MatchError((Object)option);
        });
    }

    public String deleteTelecom(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Telecom$.MODULE$.telecomRead()).fold((Function1 & Serializable)error -> utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, error.toString(), 400), (Function1 & Serializable)id -> TelecomController.$anonfun$deleteTelecom$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public static final /* synthetic */ String $anonfun$getType$2(TelecomController $this, int id) {
        Option option = $this.telecomTypeDao.getTelecomType(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            TelecomType result = (TelecomType)some.value();
            return Json$.MODULE$.toJson((Object)result, (Writes)TelecomType$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return utils.MaterielUtils$.MODULE$.getJsonError($this.logUtil, new StringBuilder(32).append("Can't find telecom type with id ").append(id).toString(), 404);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$deleteTelecom$2(TelecomController $this, int id) {
        int result = $this.telecomDao.deleteTelecom(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public TelecomController(LogUtil logUtil, TelecomDao telecomDao, TelecomTypeDao telecomTypeDao, UserDao userDao, AuthorizationMaterielDao authorizationMaterielDao) {
        this.logUtil = logUtil;
        this.telecomDao = telecomDao;
        this.telecomTypeDao = telecomTypeDao;
        this.userDao = userDao;
        this.authorizationMaterielDao = authorizationMaterielDao;
    }
}

