/*
 * Decompiled with CFR 0.152.
 */
package controllers.telecom;

import fr.aquasys.daeau.materiel.domain.output.PictureOutput;
import fr.aquasys.daeau.materiel.domain.output.PictureOutput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.File;
import java.io.Serializable;
import java.text.Normalizer;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import utils.FolderUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\t\u0012\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006YA\b\u0005\u0006U\u0001!\ta\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019\u0011\u0006\u0001)A\u0005w!91\u000b\u0001b\u0001\n\u0003!\u0006BB+\u0001A\u0003%q\tC\u0004W\u0001\t\u0007I\u0011\u0001+\t\r]\u0003\u0001\u0015!\u0003H\u0011\u001dA\u0006A1A\u0005\u0002QCa!\u0017\u0001!\u0002\u00139\u0005b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007K\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0019\u0004A\u0011A4\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\tIB+\u001a7fG>l\u0007+[2ukJ,7oQ8oiJ|G\u000e\\3s\u0015\t\u00112#A\u0004uK2,7m\\7\u000b\u0003Q\t1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00069An\\4Vi&d\u0007CA\u0010)\u001b\u0005\u0001#BA\u0011#\u0003\u0011)H/\u001b7\u000b\u0005\r\"\u0013\u0001\u0003:bE\nLG/\\9\u000b\u0005\u00152\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002O\u0005\u0011aM]\u0005\u0003S\u0001\u0012q\u0001T8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002YQ\u0011Qf\f\t\u0003]\u0001i\u0011!\u0005\u0005\u0006;\t\u0001\u001dA\b\u0015\u0003\u0005E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\r%t'.Z2u\u0015\u00051\u0014!\u00026bm\u0006D\u0018B\u0001\u001d4\u0005\u0019IeN[3di\u0006Y\u0001/[2ukJ,'+Z1e+\u0005Y\u0004c\u0001\u001fF\u000f6\tQH\u0003\u0002?\u007f\u0005!!n]8o\u0015\t\u0001\u0015)\u0001\u0003mS\n\u001c(B\u0001\"D\u0003\r\t\u0007/\u001b\u0006\u0002\t\u0006!\u0001\u000f\\1z\u0013\t1UHA\u0003SK\u0006$7\u000f\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015fi\u0011a\u0013\u0006\u0003\u0019V\ta\u0001\u0010:p_Rt\u0014B\u0001(\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059K\u0012\u0001\u00049jGR,(/\u001a*fC\u0012\u0004\u0013\u0001\u00043je\u0016\u001cGo\u001c:z\u000b:4X#A$\u0002\u001b\u0011L'/Z2u_JLXI\u001c<!\u00039!\u0017N\u001d)jGR,(/Z:F]Z\fq\u0002Z5s!&\u001cG/\u001e:fg\u0016sg\u000fI\u0001\fkJd\u0007+[2ukJ,7/\u0001\u0007ve2\u0004\u0016n\u0019;ve\u0016\u001c\b%A\bbY2|w/\u0012=uK:\u001c\u0018n\u001c8t+\u0005a\u0006cA/c\u000f:\u0011a\f\u0019\b\u0003\u0015~K\u0011AG\u0005\u0003Cf\tq\u0001]1dW\u0006<W-\u0003\u0002dI\n\u00191+Z9\u000b\u0005\u0005L\u0012\u0001E1mY><X\t\u001f;f]NLwN\\:!\u0003I9W\r\u001e+fY\u0016\u001cw.\u001c)jGR,(/Z:\u0015\u000b\u001dCW.^<\t\u000b%l\u0001\u0019\u00016\u0002\u000f5,7o]1hKB\u0011Ah[\u0005\u0003Yv\u0012qAS:WC2,X\rC\u0003o\u001b\u0001\u0007q.A\u0004iK\u0006$WM]:\u0011\t!\u0003xI]\u0005\u0003cF\u00131!T1q!\tA2/\u0003\u0002u3\t\u0019\u0011I\\=\t\u000bYl\u0001\u0019A$\u0002\r5|G-\u001e7f\u0011\u0015AX\u00021\u0001H\u0003\u0011)8/\u001a:\u0002\u0015\u001d,GoT;uaV$8\u000fF\u0003|\u0003#\t9\u0003E\u0002^Er\u00042!`A\u0007\u001b\u0005q(bA@\u0002\u0002\u00051q.\u001e;qkRTA!a\u0001\u0002\u0006\u00051Am\\7bS:TA!a\u0002\u0002\n\u0005AQ.\u0019;fe&,GNC\u0002\u0002\f\u0011\nQ\u0001Z1fCVL1!a\u0004\u007f\u00055\u0001\u0016n\u0019;ve\u0016|U\u000f\u001e9vi\"9\u00111\u0003\bA\u0002\u0005U\u0011\u0001\u00027jgR\u0004B!\u00182\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011AA5p\u0015\t\t\t#\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u00037\u0011AAR5mK\"1\u0011\u0011\u0006\bA\u0002\u001d\u000b1!\u001e:m\u0003\u001d9W\r\u001e(b[\u0016$2aRA\u0018\u0011\u0019\t\td\u0004a\u0001\u000f\u0006Aa.Y7f\r&dW\r")
public class TelecomPicturesController {
    private final LogUtil logUtil;
    private final Reads<String> pictureRead;
    private final String directoryEnv;
    private final String dirPicturesEnv;
    private final String urlPictures;
    private final Seq<String> allowExtensions;

    public Reads<String> pictureRead() {
        return this.pictureRead;
    }

    public String directoryEnv() {
        return this.directoryEnv;
    }

    public String dirPicturesEnv() {
        return this.dirPicturesEnv;
    }

    public String urlPictures() {
        return this.urlPictures;
    }

    public Seq<String> allowExtensions() {
        return this.allowExtensions;
    }

    public String getTelecomPictures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pictureRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to get pictures :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> {
            String string = System.getenv(this.dirPicturesEnv());
            String string2 = System.getenv(this.urlPictures());
            File directory = new File(new StringBuilder(17).append(string).append("MATERIEL/TELECOM/").toString());
            Seq<File> listFiles = FolderUtil$.MODULE$.getListOfFilesWithExtensions(directory, this.allowExtensions());
            Seq<File> seq = FolderUtil$.MODULE$.getListOfFilesWithExpression(listFiles, (String)code);
            Seq<PictureOutput> resultOutput = this.getOutputs(seq, string2);
            return Json$.MODULE$.toJson(resultOutput, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), PictureOutput$.MODULE$.pictureOutputWrites())).toString();
        });
    }

    public Seq<PictureOutput> getOutputs(Seq<File> list, String url) {
        return (Seq)list.map((Function1 & Serializable)file -> {
            $this.logUtil.info(new StringBuilder(7).append("File : ").append(file.getAbsolutePath()).toString(), $this.logUtil.info$default$2());
            String normalizerName = Normalizer.normalize(file.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            String name = this.getName(normalizerName);
            String string = System.getenv(this.directoryEnv());
            String listPathEnv = file.getAbsolutePath().substring(string.length(), file.getAbsolutePath().length());
            listPathEnv = listPathEnv.replaceAll("\\\\", "/");
            if (!listPathEnv.isEmpty()) {
                return new PictureOutput(new StringBuilder(0).append(url).append(listPathEnv).toString(), name, file.length(), file.lastModified());
            }
            return new PictureOutput(new StringBuilder(0).append(url).append(file.getName()).toString(), name, file.length(), file.lastModified());
        });
    }

    public String getName(String nameFile) {
        String[] splitName = nameFile.split(".");
        if (splitName.length > 1) {
            String[] splitNameUnderscore = splitName[0].split("_");
            String[] splitNameSpace = splitName[0].split(" ");
            if (splitNameUnderscore.length > 1) {
                return splitNameUnderscore[1];
            }
            if (splitNameSpace.length > 1) {
                return splitNameSpace[1];
            }
            return nameFile;
        }
        return nameFile;
    }

    @Inject
    public TelecomPicturesController(LogUtil logUtil) {
        this.logUtil = logUtil;
        this.pictureRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
        this.directoryEnv = "UPLOAD_DIRECTORY";
        this.dirPicturesEnv = "PICTURES_DIRECTORY";
        this.urlPictures = "URL_UTILS";
        this.allowExtensions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".jpg", ".JPG", ".jpeg", ".JPEG", ".png", ".PNG", ".gif", ".GIF", ".img", ".IMG", ".jpe", ".JPE", ".bmp", ".BMP", ".tif", ".TIF"}));
    }
}

