/*
 * Decompiled with CFR 0.152.
 */
package chronicMeasures;

import chronicMeasures.PluvioChartMeasure;
import chronicMeasures.PluvioMeasuresInput$;
import dao.itf.ChronicPluvioDao;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.piezometry.model.measure.DataTypeStatistics$;
import fr.aquasys.daeau.pluviometry.itf.PluvioChronicDao;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.PluviometerDataType;
import fr.aquasys.daeau.pluviometry.model.chronic.PluvioChronicMeasure;
import fr.aquasys.daeau.pluviometry.model.chronic.PluvioChronicMeasure$;
import fr.aquasys.daeau.pluviometry.model.chronic.PluvioChronicMeasureInput;
import fr.aquasys.daeau.pluviometry.model.chronic.PluvioChronicMeasureInput$;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.DateTimeFormatUtil$;
import fr.aquasys.utils.PluviometryUtils$;
import fr.aquasys.utils.StationTypeUtil$;
import fr.aquasys.utils.StringUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\n\u0015\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ya\b\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!Aa\u0007\u0001B\u0001B\u0003-q\u0007\u0003\u0005?\u0001\t\u0005\t\u0015a\u0003@\u0011!\u0011\u0005A!A!\u0002\u0017\u0019\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b1B&\t\u00119\u0003!\u0011!Q\u0001\f=CQA\u0016\u0001\u0005\u0002]CQa\u001b\u0001\u0005\u00021Dq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!I\u00111\f\u0001C\u0002\u0013\u0005\u0011Q\f\u0005\t\u0003;\u0003\u0001\u0015!\u0003\u0002`!9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006\"CAV\u0001\t\u0007I\u0011AAW\u0011!\tY\f\u0001Q\u0001\n\u0005=\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0002\u0019\u0007\"\u0014xN\\5d\u001b\u0016\f7/\u001e:f\u0007>tGO]8mY\u0016\u0014(\"A\u000b\u0002\u001f\rD'o\u001c8jG6+\u0017m];sKN\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fq\u0001\\8h+RLG\u000e\u0005\u0002!S5\t\u0011E\u0003\u0002#G\u0005!Q\u000f^5m\u0015\t!S%\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\t1s%A\u0004bcV\f7/_:\u000b\u0003!\n!A\u001a:\n\u0005)\n#a\u0002'pOV#\u0018\u000e\\\u0001\u0011a2,h/[8DQJ|g.[2EC>\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0007%$hM\u0003\u00022e\u0005Y\u0001\u000f\\;wS>lW\r\u001e:z\u0015\t\u0019T%A\u0003eC\u0016\fW/\u0003\u00026]\t\u0001\u0002\u000b\\;wS>\u001c\u0005N]8oS\u000e$\u0015m\\\u0001\u0014gR\fG/[8o)\"\u0014Xm\u001d5pY\u0012$\u0015m\u001c\t\u0003qqj\u0011!\u000f\u0006\u0003_iR!a\u000f\u001a\u0002\u000fM$\u0018\r^5p]&\u0011Q(\u000f\u0002\u0014'R\fG/[8o)\"\u0014Xm\u001d5pY\u0012$\u0015m\\\u0001\u000fa2,h/[8nKR,'\u000fR1p!\ti\u0003)\u0003\u0002B]\tq\u0001\u000b\\;wS>lW\r^3s\t\u0006|\u0017\u0001E2ie>t\u0017n\u0019)mkZLw\u000eR1p!\t!\u0005*D\u0001F\u0015\tycIC\u0001H\u0003\r!\u0017m\\\u0005\u0003\u0013\u0016\u0013\u0001c\u00115s_:L7\r\u00157vm&|G)Y8\u0002\u0017\u0011\u000bG/\u0019+za\u0016$\u0015m\u001c\t\u0003q1K!!T\u001d\u0003\u0017\u0011\u000bG/\u0019+za\u0016$\u0015m\\\u0001\u0013'&,\u0017-\u001e)be\u0006lW\r^3sg\u0012\u000bw\u000e\u0005\u0002Q)6\t\u0011K\u0003\u00020%*\u00111KM\u0001\u000fC\u0012l\u0017N\\5tiJ\fG/[8o\u0013\t)\u0016K\u0001\nTS\u0016\fW\u000fU1sC6,G/\u001a:t\t\u0006|\u0017A\u0002\u001fj]&$h\bF\u0001Y)!I6\fX/_?\u0002\f\u0007C\u0001.\u0001\u001b\u0005!\u0002\"\u0002\u0010\t\u0001\by\u0002\"B\u0016\t\u0001\ba\u0003\"\u0002\u001c\t\u0001\b9\u0004\"\u0002 \t\u0001\by\u0004\"\u0002\"\t\u0001\b\u0019\u0005\"\u0002&\t\u0001\bY\u0005\"\u0002(\t\u0001\by\u0005F\u0001\u0005d!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0004j]*,7\r\u001e\u0006\u0002Q\u0006)!.\u0019<bq&\u0011!.\u001a\u0002\u0007\u0013:TWm\u0019;\u0002\u0017\u001d,G/T3bgV\u0014Xm\u001d\u000b\t[b\fi!!\b\u0002\"A\u0011a.\u001e\b\u0003_N\u0004\"\u0001\u001d\u000e\u000e\u0003ET!A\u001d\f\u0002\rq\u0012xn\u001c;?\u0013\t!($\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;\u001b\u0011\u0015I\u0018\u00021\u0001{\u0003\u001diWm]:bO\u0016\u00042a_A\u0005\u001b\u0005a(BA?\u007f\u0003\u0011Q7o\u001c8\u000b\u0007}\f\t!\u0001\u0003mS\n\u001c(\u0002BA\u0002\u0003\u000b\t1!\u00199j\u0015\t\t9!\u0001\u0003qY\u0006L\u0018bAA\u0006y\n9!j\u001d,bYV,\u0007bBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\bQ\u0016\fG-\u001a:t!\u0019q\u00171C7\u0002\u0018%\u0019\u0011QC<\u0003\u00075\u000b\u0007\u000fE\u0002\u001a\u00033I1!a\u0007\u001b\u0005\r\te.\u001f\u0005\u0007\u0003?I\u0001\u0019A7\u0002\r5|G-\u001e7f\u0011\u0019\t\u0019#\u0003a\u0001[\u0006!Qo]3s\u00039!xn\u00115beRlU-Y:ve\u0016$B!!\u000b\u00020A\u0019!,a\u000b\n\u0007\u00055BC\u0001\nQYV4\u0018n\\\"iCJ$X*Z1tkJ,\u0007bBA\u0019\u0015\u0001\u0007\u00111G\u0001\b[\u0016\f7/\u001e:f!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tqa\u00195s_:L7MC\u0002\u0002>A\nQ!\\8eK2LA!!\u0011\u00028\t!\u0002\u000b\\;wS>\u001c\u0005N]8oS\u000elU-Y:ve\u0016\f\u0001cZ3u\u001b\u0016\f7/\u001e:fgN#\u0018\r^:\u0015\u00135\f9%!\u0013\u0002L\u00055\u0003\"B=\f\u0001\u0004Q\bbBA\b\u0017\u0001\u0007\u0011\u0011\u0003\u0005\u0007\u0003?Y\u0001\u0019A7\t\r\u0005\r2\u00021\u0001n\u0003=9W\r\u001e'bgRlU-Y:ve\u0016\u001cH#C7\u0002T\u0005U\u0013qKA-\u0011\u0015IH\u00021\u0001{\u0011\u001d\ty\u0001\u0004a\u0001\u0003#Aa!a\b\r\u0001\u0004i\u0007BBA\u0012\u0019\u0001\u0007Q.\u0001\bjIN\fe\u000e\u001a#bi\u0016\u0014V-\u00193\u0016\u0005\u0005}\u0003#B>\u0002b\u0005\u0015\u0014bAA2y\n)!+Z1egB9\u0011$a\u001a\u0002l\u0005\r\u0015bAA55\t1A+\u001e9mKJ\u0002b!!\u001c\u0002x\u0005ud\u0002BA8\u0003gr1\u0001]A9\u0013\u0005Y\u0012bAA;5\u00059\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u00121aU3r\u0015\r\t)H\u0007\t\u00043\u0005}\u0014bAAA5\t\u0019\u0011J\u001c;\u0011\u000be\t))!#\n\u0007\u0005\u001d%D\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\u000bI*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0011!\u0018.\\3\u000b\t\u0005M\u0015QS\u0001\u0005U>$\u0017M\u0003\u0002\u0002\u0018\u0006\u0019qN]4\n\t\u0005m\u0015Q\u0012\u0002\t\t\u0006$X\rV5nK\u0006y\u0011\u000eZ:B]\u0012$\u0015\r^3SK\u0006$\u0007%\u0001\rhKR\u001c\u0016\u000e^;bi&|g\u000eT1ti6+\u0017m];sKN$\u0012\"\\AR\u0003K\u000b9+!+\t\u000be|\u0001\u0019\u0001>\t\u000f\u0005=q\u00021\u0001\u0002\u0012!1\u0011qD\bA\u00025Da!a\t\u0010\u0001\u0004i\u0017aC;qI\u0006$XMU3bIN,\"!a,\u0011\u000bm\f\t'!-\u0011\re\t9'\\AZ!\u0019\ti'a\u001e\u00026B!\u0011QGA\\\u0013\u0011\tI,a\u000e\u00033AcWO^5p\u0007\"\u0014xN\\5d\u001b\u0016\f7/\u001e:f\u0013:\u0004X\u000f^\u0001\rkB$\u0017\r^3SK\u0006$7\u000fI\u0001\u0014C\u0012$wJ]+qI\u0006$X-T3bgV\u0014Xm\u001d\u000b\n[\u0006\u0005\u00171YAc\u0003\u000fDQ!\u001f\nA\u0002iDq!a\u0004\u0013\u0001\u0004\t\t\u0002\u0003\u0004\u0002 I\u0001\r!\u001c\u0005\u0007\u0003G\u0011\u0002\u0019A7")
public class ChronicMeasureController {
    private final LogUtil logUtil;
    private final PluvioChronicDao pluvioChronicDao;
    private final PluviometerDao pluviometerDao;
    private final ChronicPluvioDao chronicPluvioDao;
    private final DataTypeDao DataTypeDao;
    private final SieauParametersDao SieauParametersDao;
    private final Reads<Tuple2<Seq<Object>, Option<DateTime>>> idsAndDateRead;
    private final Reads<Tuple2<String, Seq<PluvioChronicMeasureInput>>> updateReads;

    public String getMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(PluvioMeasuresInput$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(44).append("Error while reading pluvio measures input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            int x$1 = input.stationId();
            int x$2 = input.dataType();
            Option<DateTime> x$3 = input.startDate();
            Option<DateTime> x$4 = input.endDate();
            Option<Object> x$5 = input.validOnly();
            Option<String> x$6 = input.groupFunc();
            Option<String> x$7 = input.enveloppe();
            Option<DateTime> x$8 = input.chartStartDate();
            Option<Object> x$9 = input.codepoint();
            Option<Object> x$10 = input.distinctByCodePoint();
            String x$11 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
            Seq x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
            Option x$22 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
            Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
            Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq measures = PluviometryUtils$.MODULE$.getPluvioMeasures(new MeasuresParams(x$11, x$1, x$12, x$2, x$13, x$3, x$4, x$5, x$14, x$15, x$6, x$16, x$7, x$17, x$18, x$19, x$8, x$9, x$10, x$20, x$21, x$22, x$23, x$24, x$25, x$26), $this.pluvioChronicDao, $this.SieauParametersDao, $this.DataTypeDao);
            if (input.chartMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)measures.map((Function1 & Serializable)m -> StringUtil$.MODULE$.stringify(this.toChartMeasure((PluvioChronicMeasure)m).toLight()))).mkString(",")).append("]").toString();
            }
            return new StringBuilder(2).append("[").append(((IterableOnceOps)measures.map((Function1 & Serializable)m -> StringUtil$.MODULE$.stringify(m.toLight()))).mkString(",")).append("]").toString();
        });
    }

    private PluvioChartMeasure toChartMeasure(PluvioChronicMeasure measure) {
        return new PluvioChartMeasure(measure.date(), (Option<Object>)measure.value(), measure.codepoint(), (Option<Object>)measure.status(), (Option<Object>)measure.qualification(), (Option<Object>)measure.initialPoint());
    }

    public String getMeasuresStats(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(32).append("Error while reading pluvio id : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)id -> ChronicMeasureController.$anonfun$getMeasuresStats$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String getLastMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)CommonReadUtil$.MODULE$.idsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(29).append("Can't read pluvio ids list : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)ids -> {
            Seq dataTypesId = (Seq)$this.pluviometerDao.getPluviometryDataTypes().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ChronicMeasureController.$anonfun$getLastMeasures$3(x$1)));
            return Json$.MODULE$.toJson((Object)$this.pluvioChronicDao.getLastMeasure(ids, dataTypesId), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluvioChronicMeasure$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple2<Seq<Object>, Option<DateTime>>> idsAndDateRead() {
        return this.idsAndDateRead;
    }

    public String getSituationLastMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idsAndDateRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(29).append("Can't read pluvio ids list : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            Seq<PluvioChronicMeasure> result = $this.chronicPluvioDao.getLastMeasure((Seq<Object>)((Seq)read._1()), (Option<DateTime>)((Option)read._2()));
            return Json$.MODULE$.toJson(result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluvioChronicMeasure$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple2<String, Seq<PluvioChronicMeasureInput>>> updateReads() {
        return this.updateReads;
    }

    public String addOrUpdateMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.updateReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to get Hydrological measure :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            Seq hydroChronicMeasures = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)hydroChronicMeasures);
            String user2 = (String)tuple22._1();
            Seq hydroChronicMeasures2 = (Seq)tuple22._2();
            Tuple2 tuple23 = $this.pluvioChronicDao.updateMeasures(hydroChronicMeasures2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int insert = tuple23._1$mcI$sp();
            int update = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(insert, update);
            int insert2 = sp2._1$mcI$sp();
            int update2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)update2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)insert2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getMeasuresStats$2(ChronicMeasureController $this, int id) {
        return Json$.MODULE$.toJson((Object)$this.pluvioChronicDao.getMeasuresStats(id), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)DataTypeStatistics$.MODULE$.format())).toString();
    }

    public static final /* synthetic */ int $anonfun$getLastMeasures$3(PluviometerDataType x$1) {
        return (int)x$1.id();
    }

    @Inject
    public ChronicMeasureController(LogUtil logUtil, PluvioChronicDao pluvioChronicDao, StationThresholdDao stationThresholdDao, PluviometerDao pluviometerDao, ChronicPluvioDao chronicPluvioDao, DataTypeDao DataTypeDao2, SieauParametersDao SieauParametersDao2) {
        this.logUtil = logUtil;
        this.pluvioChronicDao = pluvioChronicDao;
        this.pluviometerDao = pluviometerDao;
        this.chronicPluvioDao = chronicPluvioDao;
        this.DataTypeDao = DataTypeDao2;
        this.SieauParametersDao = SieauParametersDao2;
        this.idsAndDateRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("date").readNullable((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.updateReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("measures").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)PluvioChronicMeasureInput$.MODULE$.format()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

