/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import dao.rpc.MailDao;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.campaign.domain.input.CampaignInput$;
import fr.aquasys.daeau.pluviometry.domain.input.PluviometryEventInput;
import fr.aquasys.daeau.pluviometry.domain.input.PluviometryEventInput$;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.itf.PluviometryEventDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer;
import fr.aquasys.daeau.pluviometry.model.PluviometryEvent;
import fr.aquasys.daeau.pluviometry.model.PluviometryEvent$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.EventUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\b\u0011\u0001MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ya\u0007\u0005\tO\u0001\u0011\t\u0011)A\u0006Q!A!\u0007\u0001B\u0001B\u0003-1\u0007\u0003\u00057\u0001\t\u0005\t\u0015a\u00038\u0011!q\u0004A!A!\u0002\u0017y\u0004\"B$\u0001\t\u0003A\u0005\"\u0002.\u0001\t\u0003Y\u0006bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011Q\n\u0001\u0005\u0002\u0005=#aD#wK:$8i\u001c8ue>dG.\u001a:\u000b\u0003E\t1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00069An\\4Vi&d\u0007C\u0001\u000f&\u001b\u0005i\"B\u0001\u0010 \u0003\u0011)H/\u001b7\u000b\u0005\u0001\n\u0013\u0001\u0003:bE\nLG/\\9\u000b\u0005\t\u001a\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002I\u0005\u0011aM]\u0005\u0003Mu\u0011q\u0001T8h+RLG.A\nqYV4\u0018n\\7fiJLXI^3oi\u0012\u000bw\u000e\u0005\u0002*a5\t!F\u0003\u0002,Y\u0005\u0019\u0011\u000e\u001e4\u000b\u00055r\u0013a\u00039mkZLw.\\3uefT!aL\u0011\u0002\u000b\u0011\fW-Y;\n\u0005ER#a\u0005)mkZLw.\\3uef,e/\u001a8u\t\u0006|\u0017A\u00049mkZLw.\\3uKJ$\u0015m\u001c\t\u0003SQJ!!\u000e\u0016\u0003\u001dAcWO^5p[\u0016$XM\u001d#b_\u0006\u00112/[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p!\tAD(D\u0001:\u0015\tY#H\u0003\u0002<]\u0005q\u0011\rZ7j]&\u001cHO]1uS>t\u0017BA\u001f:\u0005I\u0019\u0016.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0002\u000f5\f\u0017\u000e\u001c#b_B\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0004eB\u001c'\"\u0001#\u0002\u0007\u0011\fw.\u0003\u0002G\u0003\n9Q*Y5m\t\u0006|\u0017A\u0002\u001fj]&$h\bF\u0001J)\u0019QE*\u0014(P!B\u00111\nA\u0007\u0002!!)!D\u0002a\u00027!)qE\u0002a\u0002Q!)!G\u0002a\u0002g!)aG\u0002a\u0002o!)aH\u0002a\u0002\u007f!\u0012aA\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000ba!\u001b8kK\u000e$(\"A,\u0002\u000b)\fg/\u0019=\n\u0005e#&AB%oU\u0016\u001cG/A\u0002hKR$R\u0001X4v{~\u0004\"!\u00183\u000f\u0005y\u0013\u0007CA0\u0017\u001b\u0005\u0001'BA1\u0013\u0003\u0019a$o\\8u}%\u00111MF\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002d-!)\u0001n\u0002a\u0001S\u0006)a/\u00197vKB\u0011!n]\u0007\u0002W*\u0011A.\\\u0001\u0005UN|gN\u0003\u0002o_\u0006!A.\u001b2t\u0015\t\u0001\u0018/A\u0002ba&T\u0011A]\u0001\u0005a2\f\u00170\u0003\u0002uW\n9!j\u001d,bYV,\u0007\"\u0002<\b\u0001\u00049\u0018a\u00025fC\u0012,'o\u001d\t\u0005;bd&0\u0003\u0002zM\n\u0019Q*\u00199\u0011\u0005UY\u0018B\u0001?\u0017\u0005\r\te.\u001f\u0005\u0006}\u001e\u0001\r\u0001X\u0001\u0007[>$W\u000f\\3\t\r\u0005\u0005q\u00011\u0001]\u0003\u0011)8/\u001a:\u0002'\u001d,G/\u0012<f]R\u001c()_\"b[B\f\u0017n\u001a8\u0015\u0013q\u000b9!a\u0003\u0002\u000e\u0005=\u0001BBA\u0005\u0011\u0001\u0007\u0011.A\u0004nKN\u001c\u0018mZ3\t\u000bYD\u0001\u0019A<\t\u000byD\u0001\u0019\u0001/\t\r\u0005\u0005\u0001\u00021\u0001]\u0003=9W\r^!mY\nK8\u000b^1uS>tG#\u0003/\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0011\u0015A\u0017\u00021\u0001j\u0011\u00151\u0018\u00021\u0001x\u0011\u0015q\u0018\u00021\u0001]\u0011\u0019\t\t!\u0003a\u00019\u00061q-\u001a;BY2$\u0012\u0002XA\u0011\u0003G\t)#a\n\t\u000b!T\u0001\u0019A5\t\u000bYT\u0001\u0019A<\t\u000byT\u0001\u0019\u0001/\t\r\u0005\u0005!\u00021\u0001]\u0003\u0019Ign]3siRIA,!\f\u00020\u0005E\u00121\u0007\u0005\u0006Q.\u0001\r!\u001b\u0005\u0006m.\u0001\ra\u001e\u0005\u0006}.\u0001\r\u0001\u0018\u0005\u0007\u0003\u0003Y\u0001\u0019\u0001/\u0002\rU\u0004H-\u0019;f)%a\u0016\u0011HA\u001e\u0003{\ty\u0004C\u0003i\u0019\u0001\u0007\u0011\u000eC\u0003w\u0019\u0001\u0007q\u000fC\u0003\u007f\u0019\u0001\u0007A\f\u0003\u0004\u0002\u00021\u0001\r\u0001X\u0001\u0007I\u0016dW\r^3\u0015\u0013q\u000b)%a\u0012\u0002J\u0005-\u0003\"\u00025\u000e\u0001\u0004I\u0007\"\u0002<\u000e\u0001\u00049\b\"\u0002@\u000e\u0001\u0004a\u0006BBA\u0001\u001b\u0001\u0007A,\u0001\u0006tK:$')_'bS2$\u0012\u0002XA)\u0003'\n)&a\u0016\t\u000b!t\u0001\u0019A5\t\u000bYt\u0001\u0019A<\t\u000byt\u0001\u0019\u0001/\t\r\u0005\u0005a\u00021\u0001]\u0001")
public class EventController {
    private final LogUtil logUtil;
    private final PluviometryEventDao pluviometryEventDao;
    private final PluviometerDao pluviometerDao;
    private final SieauParametersDao sieauParametersDao;
    private final MailDao mailDao;

    public String get(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(PluviometryEventInput$.MODULE$.eventIdAndStationIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int eventId = tuple2._1$mcI$sp();
            int stationId = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(eventId, stationId);
            int eventId2 = sp2._1$mcI$sp();
            int stationId2 = sp2._2$mcI$sp();
            Option option = $this.pluviometryEventDao.get(stationId2, eventId2);
            if (option instanceof Some) {
                Some some = (Some)option;
                PluviometryEvent event = (PluviometryEvent)some.value();
                return Json$.MODULE$.toJson((Object)event, (Writes)PluviometryEvent$.MODULE$.format()).toString();
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getEventsByCampaign(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to get campaign event :\n").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)id), (Object)user);
            double id2 = tuple22._1$mcD$sp();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.toJson((Object)$this.pluviometryEventDao.getCampaignEvent(id2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometryEvent$.MODULE$.format())).toString();
        });
    }

    public String getAllByStation(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate((Reads)CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to get all event by station :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> EventController.$anonfun$getAllByStation$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String getAll(JsValue value, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.pluviometryEventDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometryEvent$.MODULE$.format())).toString();
    }

    public String insert(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(PluviometryEventInput$.MODULE$.eventRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to add Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PluviometryEventInput event = (PluviometryEventInput)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)event, (Object)user);
            PluviometryEventInput event2 = (PluviometryEventInput)tuple22._1();
            String user2 = (String)tuple22._2();
            int id = $this.pluviometryEventDao.insert(event2, user2);
            $this.logUtil.info(new StringBuilder(34).append("Insert new event for piezometer : ").append(event2.code()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eventId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String update(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(PluviometryEventInput$.MODULE$.eventAndIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to update Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            PluviometryEventInput event = (PluviometryEventInput)tuple3._1();
            int id = BoxesRunTime.unboxToInt((Object)tuple3._2());
            String user = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)event, (Object)BoxesRunTime.boxToInteger((int)id), (Object)user);
            PluviometryEventInput event2 = (PluviometryEventInput)tuple32._1();
            int id2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            String user2 = (String)tuple32._3();
            Option option = $this.pluviometryEventDao.get(event2.code(), id2);
            if (option instanceof Some) {
                $this.pluviometryEventDao.update(event2, id2, user2);
                $this.logUtil.info(new StringBuilder(30).append("Update event ").append(id2).append(" for pluviometer ").append(event2.code()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.error(new StringBuilder(33).append("Event ").append(id2).append(" not found for pluviometer ").append(event2.code()).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String delete(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(PluviometryEventInput$.MODULE$.eventIdAndStationIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to delete Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int eventId = tuple2._1$mcI$sp();
            int stationId = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(eventId, stationId);
            int eventId2 = sp2._1$mcI$sp();
            int stationId2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.pluviometryEventDao.delete(eventId2, stationId2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String sendByMail(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(EventUtil$.MODULE$.eventIdAndStationIdAndEmailRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to send Event by mail :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int eventId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int stationId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Seq emails = (Seq)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)eventId), (Object)BoxesRunTime.boxToInteger((int)stationId), (Object)emails);
            int eventId2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int stationId2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Seq emails2 = (Seq)tuple32._3();
            Option option = $this.pluviometryEventDao.get(stationId2, eventId2);
            if (option instanceof Some) {
                Some some = (Some)option;
                PluviometryEvent event = (PluviometryEvent)some.value();
                Option option2 = $this.pluviometerDao.get(stationId2);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Pluviometer piezo = (Pluviometer)some2.value();
                    Seq parameters = $this.sieauParametersDao.getAll($this.sieauParametersDao.getAll$default$1(), $this.sieauParametersDao.getAll$default$2());
                    emails2.foreach((Function1 & Serializable)email -> {
                        this.mailDao.sendMail(email, event, piezo, (Seq<SieauParameters>)parameters);
                        return BoxedUnit.UNIT;
                    });
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                $this.logUtil.debug(new StringBuilder(24).append("Error pluvio: ").append(stationId2).append(" not found").toString(), $this.logUtil.debug$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.debug(new StringBuilder(36).append("Error event: ").append(eventId2).append(" not found for pluvio: ").append(stationId2).toString(), $this.logUtil.debug$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getAllByStation$2(EventController $this, int id) {
        return Json$.MODULE$.toJson((Object)$this.pluviometryEventDao.getAllByStation(id), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometryEvent$.MODULE$.format())).toString();
    }

    @Inject
    public EventController(LogUtil logUtil, PluviometryEventDao pluviometryEventDao, PluviometerDao pluviometerDao, SieauParametersDao sieauParametersDao, MailDao mailDao) {
        this.logUtil = logUtil;
        this.pluviometryEventDao = pluviometryEventDao;
        this.pluviometerDao = pluviometerDao;
        this.sieauParametersDao = sieauParametersDao;
        this.mailDao = mailDao;
    }
}

