/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.PluviometerController$;
import fr.aquasys.constants.StationTypeConstants$;
import fr.aquasys.daeau.pluviometry.domain.PluviometerLinks;
import fr.aquasys.daeau.pluviometry.domain.PluviometerLinks$;
import fr.aquasys.daeau.pluviometry.domain.PluviometerListSpecific$;
import fr.aquasys.daeau.pluviometry.domain.PluviometerWithLinks;
import fr.aquasys.daeau.pluviometry.domain.PluviometerWithLinks$;
import fr.aquasys.daeau.pluviometry.domain.output.PluviometerWithCampaignsAndEventsOutput$;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer$;
import fr.aquasys.daeau.pluviometry.model.PluviometerDataType$;
import fr.aquasys.daeau.pluviometry.model.PluviometerGeo$;
import fr.aquasys.daeau.station.domain.input.GetAllQueryParams;
import fr.aquasys.daeau.station.domain.input.GetAllQueryParams$;
import fr.aquasys.daeau.station.links.contributor.StationContributorDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink$;
import fr.aquasys.daeau.station.links.network.StationNetwork$;
import fr.aquasys.daeau.station.links.network.StationNetworkDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.api.application.constants.StatisticEventTypeConstants$;
import fr.aquasys.rabbitmq.api.application.constants.StatisticModuleConstants$;
import fr.aquasys.rabbitmq.api.application.utils.SwaggerUtil;
import fr.aquasys.rabbitmq.api.application.utils.SwaggerUtil$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.rabbitmq.util.StatUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u0012%\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ya\f\u0005\tw\u0001\u0011\t\u0011)A\u0006y!Aa\t\u0001B\u0001B\u0003-q\t\u0003\u0005R\u0001\t\u0005\t\u0015a\u0003S\u0011!A\u0006A!A!\u0002\u0017I\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b1B1\t\u000b\u0011\u0004A\u0011A3\t\u000fa\u0004!\u0019!C\u0001s\"9\u0011\u0011\f\u0001!\u0002\u0013Q\b\"CA.\u0001\t\u0007I\u0011AA/\u0011!\t)\b\u0001Q\u0001\n\u0005}\u0003\"CA<\u0001\t\u0007I\u0011AA=\u0011!\t)\n\u0001Q\u0001\n\u0005m\u0004\"CAL\u0001\t\u0007I\u0011AAM\u0011!\tY\u000b\u0001Q\u0001\n\u0005m\u0005\"CAW\u0001\t\u0007I\u0011AAX\u0011!\t)\f\u0001Q\u0001\n\u0005E\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!I!\u0011\u0004\u0001C\u0002\u0013\u0005!1\u0004\u0005\t\u0005_\u0001\u0001\u0015!\u0003\u0003\u001e!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011%\u0011)\u0006\u0001b\u0001\n\u0003\u00119\u0006\u0003\u0005\u0003f\u0001\u0001\u000b\u0011\u0002B-\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqAa\u001d\u0001\t\u0003\u0011)\bC\u0004\u0003\u0000\u0001!\tA!!\t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\n)\u0002\u000b\\;wS>lW\r^3s\u0007>tGO]8mY\u0016\u0014(\"A\u0013\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\t\u0001\u0014(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'B\u0001\u001b6\u0003!\u0011\u0018M\u00192ji6\f(B\u0001\u001c8\u0003\u001d\t\u0017/^1tsNT\u0011\u0001O\u0001\u0003MJL!AO\u0019\u0003\u000f1{w-\u0016;jY\u0006q\u0001\u000f\\;wS>lW\r^3s\t\u0006|\u0007CA\u001fE\u001b\u0005q$BA A\u0003\rIGO\u001a\u0006\u0003\u0003\n\u000b1\u0002\u001d7vm&|W.\u001a;ss*\u00111)N\u0001\u0006I\u0006,\u0017-^\u0005\u0003\u000bz\u0012a\u0002\u00157vm&|W.\u001a;fe\u0012\u000bw.A\tti\u0006$\u0018n\u001c8OKR<xN]6EC>\u0004\"\u0001S(\u000e\u0003%S!AS&\u0002\u000f9,Go^8sW*\u0011A*T\u0001\u0006Y&t7n\u001d\u0006\u0003\u001d\n\u000bqa\u001d;bi&|g.\u0003\u0002Q\u0013\n\t2\u000b^1uS>tg*\u001a;x_J\\G)Y8\u0002+M$\u0018\r^5p]\u000e{g\u000e\u001e:jEV$xN\u001d#b_B\u00111KV\u0007\u0002)*\u0011QkS\u0001\fG>tGO]5ckR|'/\u0003\u0002X)\n)2\u000b^1uS>t7i\u001c8ue&\u0014W\u000f^8s\t\u0006|\u0017AD;tKJ\u001cF/\u0019;j_:$\u0015m\u001c\t\u00035zk\u0011a\u0017\u0006\u0003\u007fqS!!\u0018\"\u0002\tU\u001cXM]\u0005\u0003?n\u0013a\"V:feN#\u0018\r^5p]\u0012\u000bw.\u0001\u0005ti\u0006$X\u000b^5m!\t\u0001$-\u0003\u0002dc\tA1\u000b^1u+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002MR9q-\u001b6lY6t\u0007C\u00015\u0001\u001b\u0005!\u0003\"\u0002\u0018\b\u0001\by\u0003\"B\u001e\b\u0001\ba\u0004\"\u0002$\b\u0001\b9\u0005\"B)\b\u0001\b\u0011\u0006\"\u0002-\b\u0001\bI\u0006\"\u00021\b\u0001\b\t\u0007FA\u0004q!\t\th/D\u0001s\u0015\t\u0019H/\u0001\u0004j]*,7\r\u001e\u0006\u0002k\u0006)!.\u0019<bq&\u0011qO\u001d\u0002\u0007\u0013:TWm\u0019;\u00025AdWO^5p[\u0016$XM\u001d)be\u0006l7/V:feJ+\u0017\rZ:\u0016\u0003i\u0004Ra_A\u0014\u0003[q1\u0001`A\u0011\u001d\ri\u00181\u0004\b\u0004}\u0006UabA@\u0002\u00129!\u0011\u0011AA\b\u001d\u0011\t\u0019!!\u0004\u000f\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003'\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u00027o%\u0011A'N\u0005\u0004\u0003'\u0019\u0014aA1qS&!\u0011qCA\r\u0003-\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8\u000b\u0007\u0005M1'\u0003\u0003\u0002\u001e\u0005}\u0011!B;uS2\u001c(\u0002BA\f\u00033IA!a\t\u0002&\u0005Y1k^1hO\u0016\u0014X\u000b^5m\u0015\u0011\ti\"a\b\n\t\u0005%\u00121\u0006\u0002\r'^\fwmZ3s%\u0016\fGm\u001d\u0006\u0005\u0003G\t)\u0003E\u0005*\u0003_\t\u0019$a\u0011\u00024%\u0019\u0011\u0011\u0007\u0016\u0003\rQ+\b\u000f\\34!\u0011\t)$!\u0010\u000f\t\u0005]\u0012\u0011\b\t\u0004\u0003\u000bQ\u0013bAA\u001eU\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000f+!\u0015I\u0013QIA%\u0013\r\t9E\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005)\u0011N\u001c9vi*\u0019\u00111K'\u0002\r\u0011|W.Y5o\u0013\u0011\t9&!\u0014\u0003#\u001d+G/\u00117m#V,'/\u001f)be\u0006l7/A\u000eqYV4\u0018n\\7fi\u0016\u0014\b+\u0019:b[N,6/\u001a:SK\u0006$7\u000fI\u0001\u0017a2,h/[8nKR,'\u000fU1sC6\u001c(+Z1egV\u0011\u0011q\f\t\u0007\u0003C\n\t(a\u0011\u000e\u0005\u0005\r$\u0002BA3\u0003O\nAA[:p]*!\u0011\u0011NA6\u0003\u0011a\u0017NY:\u000b\t\u0005M\u0011Q\u000e\u0006\u0003\u0003_\nA\u0001\u001d7bs&!\u00111OA2\u0005\u0015\u0011V-\u00193t\u0003]\u0001H.\u001e<j_6,G/\u001a:QCJ\fWn\u001d*fC\u0012\u001c\b%A\nqYV4\u0018n\\7fi\u0016\u0014\u0018\nZ:SK\u0006$7/\u0006\u0002\u0002|A1\u0011\u0011MA9\u0003{\u0002b!a \u0002\n\u0006=e\u0002BAA\u0003\u000bsA!!\u0002\u0002\u0004&\t1&C\u0002\u0002\b*\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00065%aA*fc*\u0019\u0011q\u0011\u0016\u0011\u0007%\n\t*C\u0002\u0002\u0014*\u00121!\u00138u\u0003Q\u0001H.\u001e<j_6,G/\u001a:JIN\u0014V-\u00193tA\u00059\u0002\u000f\\;wS>lW\r^3s\u0013\u0012\u001cXk]3s%\u0016\fGm]\u000b\u0003\u00037\u0003b!!\u0019\u0002r\u0005u\u0005cC\u0015\u0002 \u0006M\u0012QPAR\u0003gI1!!)+\u0005\u0019!V\u000f\u001d7fiA)\u0011&!\u0012\u0002&B\u0019\u0011&a*\n\u0007\u0005%&FA\u0004C_>dW-\u00198\u00021AdWO^5p[\u0016$XM]%egV\u001bXM\u001d*fC\u0012\u001c\b%\u0001\nqYV4\u0018n\\7fi\u0016\u0014\u0018\nZ*uCR\u001cXCAAY!\u0015Y\u0018qEAZ!%I\u0013qFAH\u0003g\t\u0019$A\nqYV4\u0018n\\7fi\u0016\u0014\u0018\nZ*uCR\u001c\b%\u0001\u0004hKR\fE\u000e\u001c\u000b\u000b\u0003g\tY,!2\u0002V\u0006e\u0007bBA_%\u0001\u0007\u0011qX\u0001\b[\u0016\u001c8/Y4f!\u0011\t\t'!1\n\t\u0005\r\u00171\r\u0002\b\u0015N4\u0016\r\\;f\u0011\u001d\t9M\u0005a\u0001\u0003\u0013\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0005\u00026\u0005-\u00171GAh\u0013\u0011\ti-!\u0011\u0003\u00075\u000b\u0007\u000fE\u0002*\u0003#L1!a5+\u0005\r\te.\u001f\u0005\b\u0003/\u0014\u0002\u0019AA\u001a\u0003\u0019iw\u000eZ;mK\"1QL\u0005a\u0001\u0003g\tadZ3u\u00032d\u0007\u000b\\;wS>lW\r^3s/&$\bnR3p\u001fV$\b/\u001e;\u0015\u0015\u0005M\u0012q\\Aq\u0003G\f)\u000fC\u0004\u0002>N\u0001\r!a0\t\u000f\u0005\u001d7\u00031\u0001\u0002J\"9\u0011q[\nA\u0002\u0005M\u0002BB/\u0014\u0001\u0004\t\u0019$A\nhKR\u0004F.\u001e<j_6,G/\u001a:Cs&#7\u000f\u0006\u0006\u00024\u0005-\u0018Q^Ax\u0003cDq!!0\u0015\u0001\u0004\ty\fC\u0004\u0002HR\u0001\r!!3\t\u000f\u0005]G\u00031\u0001\u00024!1Q\f\u0006a\u0001\u0003g\tqeZ3u\u00032d\u0007\u000b\\;wS>lW\r^3s/&$\bnQ1na\u0006LwM\\:B]\u0012,e/\u001a8ugRQ\u00111GA|\u0003w\fi0a@\t\u000f\u0005eX\u00031\u0001\u0002@\u0006)a/\u00197vK\"9\u0011qY\u000bA\u0002\u0005%\u0007bBAl+\u0001\u0007\u00111\u0007\u0005\u0007;V\u0001\r!a\r\u0002\u0007\u001d,G\u000f\u0006\u0006\u00024\t\u0015!q\u0001B\u0005\u0005\u0017Aq!!?\u0017\u0001\u0004\ty\fC\u0004\u0002HZ\u0001\r!!3\t\u000f\u0005]g\u00031\u0001\u00024!1QL\u0006a\u0001\u0003g\ta!\u001e9eCR,GCCA\u001a\u0005#\u0011\u0019B!\u0006\u0003\u0018!9\u0011\u0011`\fA\u0002\u0005}\u0006bBAd/\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003/<\u0002\u0019AA\u001a\u0011\u0019iv\u00031\u0001\u00024\u0005IA.\u001b8lgJ+\u0017\rZ\u000b\u0003\u0005;\u0001b!!\u0019\u0002r\t}\u0001cB\u0015\u0003\"\u0005M\"QE\u0005\u0004\u0005GQ#A\u0002+va2,'\u0007\u0005\u0003\u0003(\t-RB\u0001B\u0015\u0015\r\t\u0019\u0006Q\u0005\u0005\u0005[\u0011IC\u0001\tQYV4\u0018n\\7fi\u0016\u0014H*\u001b8lg\u0006QA.\u001b8lgJ+\u0017\r\u001a\u0011\u0002-U\u0004H-\u0019;f!2,h/[8nKR,'\u000fT5oWN$\"\"a\r\u00036\t]\"\u0011\bB\u001e\u0011\u001d\tiL\u0007a\u0001\u0003\u007fCq!a2\u001b\u0001\u0004\tI\rC\u0004\u0002Xj\u0001\r!a\r\t\ruS\u0002\u0019AA\u001a\u0003\u0019\u0019'/Z1uKRQ\u00111\u0007B!\u0005\u0007\u0012)Ea\u0012\t\u000f\u0005e8\u00041\u0001\u0002@\"9\u0011qY\u000eA\u0002\u0005%\u0007bBAl7\u0001\u0007\u00111\u0007\u0005\u0007;n\u0001\r!a\r\u0002\r\u0011,G.\u001a;f))\t\u0019D!\u0014\u0003P\tE#1\u000b\u0005\b\u0003sd\u0002\u0019AA`\u0011\u001d\t9\r\ba\u0001\u0003\u0013Dq!a6\u001d\u0001\u0004\t\u0019\u0004\u0003\u0004^9\u0001\u0007\u00111G\u0001\u0018a2,h/[8nKR,'oQ8oi\u0006\u001cGOU3bIN,\"A!\u0017\u0011\r\u0005\u0005\u0014\u0011\u000fB.!%I\u0013qFA\u001a\u0005;\u0012\u0019\u0007E\u0002*\u0005?J1A!\u0019+\u0005\u0019!u.\u001e2mKB)\u0011&!\u0012\u0003^\u0005A\u0002\u000f\\;wS>lW\r^3s\u0007>tG/Y2u%\u0016\fGm\u001d\u0011\u0002\u001bU\u0004H-\u0019;f\u0007>tG/Y2u))\t\u0019Da\u001b\u0003n\t=$\u0011\u000f\u0005\b\u0003{{\u0002\u0019AA`\u0011\u001d\t9m\ba\u0001\u0003\u0013Dq!a6 \u0001\u0004\t\u0019\u0004\u0003\u0004^?\u0001\u0007\u00111G\u0001\u0018O\u0016$\b\u000b\\;wS>lW\r\u001e:z\t\u0006$\u0018\rV=qKN$\"\"a\r\u0003x\te$1\u0010B?\u0011\u001d\ti\f\ta\u0001\u0003\u007fCq!a2!\u0001\u0004\tI\rC\u0004\u0002X\u0002\u0002\r!a\r\t\ru\u0003\u0003\u0019AA\u001a\u0003=9W\r\u001e(fi^|'o\u001b'j].\u001cHCCA\u001a\u0005\u0007\u0013)Ia\"\u0003\n\"9\u0011QX\u0011A\u0002\u0005}\u0006bBAdC\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003/\f\u0003\u0019AA\u001a\u0011\u0019i\u0016\u00051\u0001\u00024\u00051r-\u001a;BY2\u001cuN\u001c;sS\n,Ho\u001c:MS:\\7\u000f\u0006\u0006\u00024\t=%\u0011\u0013BJ\u0005+Cq!!0#\u0001\u0004\ty\fC\u0004\u0002H\n\u0002\r!!3\t\u000f\u0005]'\u00051\u0001\u00024!1QL\ta\u0001\u0003g\u0001")
public class PluviometerController {
    private final LogUtil logUtil;
    private final PluviometerDao pluviometerDao;
    private final StationNetworkDao stationNetworkDao;
    private final StationContributorDao stationContributorDao;
    private final UserStationDao userStationDao;
    private final StatUtil statUtil;
    private final SwaggerUtil.SwaggerReads<Tuple3<String, Option<GetAllQueryParams>, String>> pluviometerParamsUserReads;
    private final Reads<Option<GetAllQueryParams>> pluviometerParamsReads;
    private final Reads<Seq<Object>> pluviometerIdsReads;
    private final Reads<Tuple4<String, Seq<Object>, Option<Object>, String>> pluviometerIdsUserReads;
    private final SwaggerUtil.SwaggerReads<Tuple3<Object, String, String>> pluviometerIdStats;
    private final Reads<Tuple2<String, PluviometerLinks>> linksRead;
    private final Reads<Tuple3<String, Object, Option<Object>>> pluviometerContactReads;

    public SwaggerUtil.SwaggerReads<Tuple3<String, Option<GetAllQueryParams>, String>> pluviometerParamsUserReads() {
        return this.pluviometerParamsUserReads;
    }

    public Reads<Option<GetAllQueryParams>> pluviometerParamsReads() {
        return this.pluviometerParamsReads;
    }

    public Reads<Seq<Object>> pluviometerIdsReads() {
        return this.pluviometerIdsReads;
    }

    public Reads<Tuple4<String, Seq<Object>, Option<Object>, String>> pluviometerIdsUserReads() {
        return this.pluviometerIdsUserReads;
    }

    public SwaggerUtil.SwaggerReads<Tuple3<Object, String, String>> pluviometerIdStats() {
        return this.pluviometerIdStats;
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pluviometerParamsUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate Json to get all pluviometers :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Seq seq;
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String validateUser = (String)tuple3._1();
            Option queryParams = (Option)tuple3._2();
            String module = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)validateUser, (Object)queryParams, (Object)module);
            String validateUser2 = (String)tuple32._1();
            Option queryParams2 = (Option)tuple32._2();
            String module2 = (String)tuple32._3();
            Seq allowStations = $this.userStationDao.getAvailableStation(validateUser2, StationTypeConstants$.MODULE$.TYPE_STATION_PLUVIO(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    seq = $this.pluviometerDao.getAll(queryParams2, (Option)None$.MODULE$);
                } else {
                    Some allowStationsIds = new Some(allowStations.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))));
                    seq = $this.pluviometerDao.getAll(queryParams2, (Option)allowStationsIds);
                }
            }
            Seq result = seq;
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerListSpecific$.MODULE$.pluvioFormat())).toString();
        });
    }

    public String getAllPluviometerWithGeoOutput(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.pluviometerDao.getAllWithGeoOutput(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerGeo$.MODULE$.hydrologicalStationCodeFormat())).toString();
    }

    public String getPluviometerByIds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pluviometerIdsUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate Json to get all pluviometers :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple4 tuple4 = params;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            String user = (String)tuple4._1();
            Seq pluviometerIds = (Seq)tuple4._2();
            Option withLinks = (Option)tuple4._3();
            String module = (String)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)user, (Object)pluviometerIds, (Object)withLinks, (Object)module);
            String user2 = (String)tuple42._1();
            Seq pluviometerIds2 = (Seq)tuple42._2();
            Option withLinks2 = (Option)tuple42._3();
            String module2 = (String)tuple42._4();
            if (pluviometerIds2.nonEmpty()) {
                Seq allowStations = $this.userStationDao.getAvailableStation(user2, StationTypeConstants$.MODULE$.TYPE_STATION_PLUVIO(), module2);
                String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
                String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return "[]";
                }
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    if (withLinks2.isDefined() && BoxesRunTime.unboxToBoolean((Object)withLinks2.get())) {
                        return Json$.MODULE$.toJson((Object)$this.pluviometerDao.getAllWithLinks((Option)new Some((Object)pluviometerIds2)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerWithLinks$.MODULE$.format())).toString();
                    }
                    return Json$.MODULE$.toJson((Object)$this.pluviometerDao.getAll((Option)new Some((Object)pluviometerIds2)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Pluviometer$.MODULE$.pluviometerWrites())).toString();
                }
                Seq allowStationsIds = (Seq)allowStations.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
                Some filteredPluviometerIds = new Some(pluviometerIds2.filter((Function1)(JFunction1.mcZI.sp & Serializable)id -> allowStationsIds.contains((Object)BoxesRunTime.boxToInteger((int)id))));
                if (withLinks2.isDefined() && BoxesRunTime.unboxToBoolean((Object)withLinks2.get())) {
                    return Json$.MODULE$.toJson((Object)$this.pluviometerDao.getAllWithLinks((Option)filteredPluviometerIds), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerWithLinks$.MODULE$.format())).toString();
                }
                return Json$.MODULE$.toJson((Object)$this.pluviometerDao.getAll((Option)filteredPluviometerIds), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Pluviometer$.MODULE$.pluviometerWrites())).toString();
            }
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Pluviometer$.MODULE$.pluviometerWrites())).toString();
        });
    }

    public String getAllPluviometerWithCampaignsAndEvents(JsValue value, Map<String, Object> headers, String module, String user) {
        Seq allowStations = this.userStationDao.getAvailableStation(user, StationTypeConstants$.MODULE$.TYPE_STATION_PLUVIO(), module);
        String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
        String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerWithCampaignsAndEventsOutput$.MODULE$.format())).toString();
        }
        String string4 = StationTypeConstants$.MODULE$.ALL();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return Json$.MODULE$.toJson((Object)this.pluviometerDao.getAllPluviometerWithCampaignsAndEvents(this.pluviometerDao.getAllPluviometerWithCampaignsAndEvents$default$1()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerWithCampaignsAndEventsOutput$.MODULE$.format())).toString();
        }
        Some ids = new Some(allowStations.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5)))));
        return Json$.MODULE$.toJson((Object)this.pluviometerDao.getAllPluviometerWithCampaignsAndEvents((Option)ids), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerWithCampaignsAndEventsOutput$.MODULE$.format())).toString();
    }

    public String get(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(this.pluviometerIdStats()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(33).append("Error validate pluviometer code ,").append(error).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)id -> {
            Option option = $this.pluviometerDao.getWithLinks(BoxesRunTime.unboxToInt((Object)id._1()));
            if (option instanceof Some) {
                Some some = (Some)option;
                PluviometerWithLinks pluviometer = (PluviometerWithLinks)some.value();
                String code = (String)pluviometer.code().getOrElse((Function0 & Serializable)() -> "");
                String name = pluviometer.name().isDefined() ? new StringBuilder(3).append(" - ").append(pluviometer.name().get()).toString() : "";
                $this.statUtil.createStat((String)id._2(), StatisticEventTypeConstants$.MODULE$.STATION(), StatisticModuleConstants$.MODULE$.PLUVIOMETRY(), (String)id._3(), (Option)new Some((Object)new StringBuilder(0).append(code).append(name).toString()));
                return Json$.MODULE$.toJson((Object)pluviometer, (Writes)PluviometerWithLinks$.MODULE$.format()).toString();
            }
            $this.logUtil.error(new StringBuilder(33).append("Pluviometer not found for code : ").append(id._1()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String update(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate((Reads)PluviometerWithLinks$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(29).append("Error validate pluviometer : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)pluviometer -> {
            Option option = $this.pluviometerDao.get(BoxesRunTime.unboxToInt((Object)pluviometer.id().get()));
            if (option instanceof Some) {
                $this.logUtil.info(new StringBuilder(45).append("Pluviometry : update pluviometer with code : ").append(pluviometer.id()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.pluviometerDao.update(pluviometer, user)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(33).append("Pluviometer not found for code : ").append(pluviometer.id()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple2<String, PluviometerLinks>> linksRead() {
        return this.linksRead;
    }

    public String updatePluviometerLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.linksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(52).append("Can't validate pluviometer object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            PluviometerLinks links = (PluviometerLinks)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)links);
            String user2 = (String)tuple22._1();
            PluviometerLinks links2 = (PluviometerLinks)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.pluviometerDao.updateLinks(links2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String create(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate((Reads)PluviometerWithLinks$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(29).append("Error validate pluviometer : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)pluviometer -> {
            Tuple2 tuple2 = $this.pluviometerDao.create(pluviometer, user);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int resultInsert = tuple2._1$mcI$sp();
            double id = tuple2._2$mcD$sp();
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(resultInsert, id);
            int resultInsert2 = sp2._1$mcI$sp();
            double id2 = sp2._2$mcD$sp();
            $this.userStationDao.addUserRightsCreation(Option$.MODULE$.apply((Object)user), (int)id2, StationTypeConstants$.MODULE$.TYPE_STATION_PLUVIO());
            $this.logUtil.debug(new StringBuilder(45).append("Pluviometry : insert pluviometer with code : ").append(id2).toString(), $this.logUtil.debug$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)resultInsert2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id2), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
        });
    }

    public String delete(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate((Reads)CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(34).append("Error validate pluviometer code : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> PluviometerController.$anonfun$delete$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public Reads<Tuple3<String, Object, Option<Object>>> pluviometerContactReads() {
        return this.pluviometerContactReads;
    }

    public String updateContact(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pluviometerContactReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to get pluviometer id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String user = (String)tuple3._1();
            double id = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            Option contactCode = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)user, (Object)BoxesRunTime.boxToDouble((double)id), (Object)contactCode);
            String user2 = (String)tuple32._1();
            double id2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            Option contactCode2 = (Option)tuple32._3();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.pluviometerDao.updateContact(user2, id2, contactCode2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getPluviometryDataTypes(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.pluviometerDao.getPluviometryDataTypes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometerDataType$.MODULE$.format())).toString();
    }

    public String getNetworkLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.stationNetworkDao.getAll("PLUVIOMETRY"), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationNetwork$.MODULE$.format())).toString();
    }

    public String getAllContributorLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.stationContributorDao.getAll("PLUVIOMETRY"), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationContributorLink$.MODULE$.qualitometereContributorLinkFormat())).toString();
    }

    public static final /* synthetic */ String $anonfun$delete$2(PluviometerController $this, int id) {
        Option option = $this.pluviometerDao.get(id);
        if (option instanceof Some) {
            $this.logUtil.info(new StringBuilder(45).append("Pluviometry : delete pluviometer with code : ").append(id).toString(), $this.logUtil.info$default$2());
            int resultDelete = $this.pluviometerDao.delete(id);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)resultDelete), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        $this.logUtil.error(new StringBuilder(33).append("Pluviometer not found for code : ").append(id).toString(), $this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public PluviometerController(LogUtil logUtil, PluviometerDao pluviometerDao, StationNetworkDao stationNetworkDao, StationContributorDao stationContributorDao, UserStationDao userStationDao, StatUtil statUtil) {
        this.logUtil = logUtil;
        this.pluviometerDao = pluviometerDao;
        this.stationNetworkDao = stationNetworkDao;
        this.stationContributorDao = stationContributorDao;
        this.userStationDao = userStationDao;
        this.statUtil = statUtil;
        SwaggerUtil.SwaggerPath qual$1 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("user"));
        String x$1 = qual$1.read$default$1();
        JsValue x$2 = qual$1.read$default$2();
        Option x$3 = qual$1.read$default$3();
        SwaggerUtil.SwaggerPath qual$2 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("queryParams"));
        String x$4 = qual$2.readNullable$default$1();
        JsValue x$5 = qual$2.readNullable$default$2();
        Option x$6 = qual$2.readNullable$default$3();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PluviometerController.class.getClassLoader());
        SwaggerUtil.SwaggerPath qual$3 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("module"));
        String x$7 = qual$3.read$default$1();
        JsValue x$8 = qual$3.read$default$2();
        Option x$9 = qual$3.read$default$3();
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PluviometerController.class.getClassLoader());
        public final class Controllers_PluviometerController$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("fr.aquasys.daeau.station.domain.input.GetAllQueryParams").asType().toTypeConstructor();
            }

            public Controllers_PluviometerController$$typecreator2$1(PluviometerController $outer) {
            }
        }
        public final class Controllers_PluviometerController$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("fr.aquasys.daeau.station.domain.input.GetAllQueryParams").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Controllers_PluviometerController$$typecreator4$1(PluviometerController $outer) {
            }
        }
        this.pluviometerParamsUserReads = SwaggerUtil$.MODULE$.SwaggerReads2Ops(SwaggerUtil$.MODULE$.SwaggerReads1Ops(qual$1.read(x$1, x$2, x$3, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType())).and(qual$2.readNullable(x$4, x$5, x$6, (Reads)GetAllQueryParams$.MODULE$.format(), SwaggerUtil.SwaggerType$.MODULE$.caseClassType(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Controllers_PluviometerController$$typecreator2$1(null)))))).and(qual$3.read(x$7, x$8, x$9, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType()).withHttpBodyType(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Controllers_PluviometerController$$typecreator4$1(null))));
        this.pluviometerParamsReads = JsPath$.MODULE$.$bslash("queryParams").readNullable((Reads)GetAllQueryParams$.MODULE$.format());
        this.pluviometerIdsReads = JsPath$.MODULE$.$bslash("pluviometerIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()));
        this.pluviometerIdsUserReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("pluviometerIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("withLinks").readNullable((Reads)Reads$.MODULE$.BooleanReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        SwaggerUtil.SwaggerPath qual$4 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("id"));
        String x$10 = "id de la station";
        JsNumber x$11 = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(4));
        Option x$12 = qual$4.read$default$3();
        SwaggerUtil.SwaggerPath qual$5 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("user"));
        String x$13 = qual$5.read$default$1();
        JsValue x$14 = qual$5.read$default$2();
        Option x$15 = qual$5.read$default$3();
        SwaggerUtil.SwaggerPath qual$6 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("platform"));
        String x$16 = qual$6.read$default$1();
        JsValue x$17 = qual$6.read$default$2();
        Option x$18 = qual$6.read$default$3();
        this.pluviometerIdStats = SwaggerUtil$.MODULE$.SwaggerReads2Ops(SwaggerUtil$.MODULE$.SwaggerReads1Ops(qual$4.read("id de la station", (JsValue)x$11, x$12, (Reads)Reads$.MODULE$.IntReads(), SwaggerUtil.SwaggerType$.MODULE$.intType())).and(qual$5.read(x$13, x$14, x$15, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType()))).and(qual$6.read(x$16, x$17, x$18, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType()));
        this.linksRead = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("links").read((Reads)PluviometerLinks$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.pluviometerContactReads = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.DoubleReads())).and((Object)JsPath$.MODULE$.$bslash("contactCode").readNullable((Reads)Reads$.MODULE$.DoubleReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

