/*
 * Decompiled with CFR 0.152.
 */
package situation;

import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateTimeFormatUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import model.KeyFigure$;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import situation.PluvioMeasuresSituation;
import situation.PluvioMeasuresSituation$;
import situation.PluvioSituation;
import situation.PluvioSituation$;
import situation.PluvioSituationDays;
import situation.PluvioSituationDays$;
import situation.SituationDao;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\t\u0012\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006Y\u0001\b\u0005\tQ\u0001\u0011\t\u0011)A\u0006S!A1\u0007\u0001B\u0001B\u0003-A\u0007\u0003\u00059\u0001\t\u0005\t\u0015a\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dA\bA1A\u0005\u0002eDq!!\f\u0001A\u0003%!\u0010C\u0004\u00020\u0001!\t!!\r\t\u0013\u0005u\u0002A1A\u0005\u0002\u0005}\u0002\u0002CA&\u0001\u0001\u0006I!!\u0011\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!I\u0011\u0011\f\u0001C\u0002\u0013\u0005\u00111\f\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002^!9\u0011q\r\u0001\u0005\u0002\u0005%$aE*jiV\fG/[8o\u0007>tGO]8mY\u0016\u0014(\"\u0001\n\u0002\u0013MLG/^1uS>t7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\nA!\u001e;jY*\u0011\u0011EI\u0001\te\u0006\u0014'-\u001b;nc*\u00111\u0005J\u0001\bCF,\u0018m]=t\u0015\u0005)\u0013A\u00014s\u0013\t9cDA\u0004M_\u001e,F/\u001b7\u0002\u001dAdWO^5p[\u0016$XM\u001d#b_B\u0011!&M\u0007\u0002W)\u0011A&L\u0001\u0004SR4'B\u0001\u00180\u0003-\u0001H.\u001e<j_6,GO]=\u000b\u0005A\u0012\u0013!\u00023bK\u0006,\u0018B\u0001\u001a,\u00059\u0001F.\u001e<j_6,G/\u001a:EC>\fAb]5uk\u0006$\u0018n\u001c8EC>\u0004\"!\u000e\u001c\u000e\u0003EI!aN\t\u0003\u0019MKG/^1uS>tG)Y8\u0002'M$\u0018\r^5p]RC'/Z:i_2$G)Y8\u0011\u0005irT\"A\u001e\u000b\u00051b$BA\u001f0\u0003\u001d\u0019H/\u0019;j_:L!aP\u001e\u0003'M#\u0018\r^5p]RC'/Z:i_2$G)Y8\u0002\rqJg.\u001b;?)\u0005\u0011E#B\"E\u000b\u001a;\u0005CA\u001b\u0001\u0011\u0015YR\u0001q\u0001\u001d\u0011\u0015AS\u0001q\u0001*\u0011\u0015\u0019T\u0001q\u00015\u0011\u0015AT\u0001q\u0001:Q\t)\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u00061\u0011N\u001c6fGRT\u0011AT\u0001\u0006U\u00064\u0018\r_\u0005\u0003!.\u0013a!\u00138kK\u000e$\u0018!D4fi.+\u0017PR5hkJ,7\u000fF\u0003T=2$h\u000f\u0005\u0002U7:\u0011Q+\u0017\t\u0003-^i\u0011a\u0016\u0006\u00031N\ta\u0001\u0010:p_Rt\u0014B\u0001.\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i;\u0002\"B0\u0007\u0001\u0004\u0001\u0017!\u0002<bYV,\u0007CA1k\u001b\u0005\u0011'BA2e\u0003\u0011Q7o\u001c8\u000b\u0005\u00154\u0017\u0001\u00027jENT!a\u001a5\u0002\u0007\u0005\u0004\u0018NC\u0001j\u0003\u0011\u0001H.Y=\n\u0005-\u0014'a\u0002&t-\u0006dW/\u001a\u0005\u0006[\u001a\u0001\rA\\\u0001\bQ\u0016\fG-\u001a:t!\u0011!vnU9\n\u0005Al&aA'baB\u0011aC]\u0005\u0003g^\u00111!\u00118z\u0011\u0015)h\u00011\u0001T\u0003\u0019iw\u000eZ;mK\")qO\u0002a\u0001'\u0006!Qo]3s\u00035\u0019\u0018\u000e^;bi&|gNU3bIV\t!\u0010E\u0002bwvL!\u0001 2\u0003\u000bI+\u0017\rZ:\u0011\u0013Yq\u0018\u0011A*\u0002\u0016\u0005\u001d\u0012BA@\u0018\u0005\u0019!V\u000f\u001d7fiA!\u00111AA\t\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001\u0002;j[\u0016TA!a\u0003\u0002\u000e\u0005!!n\u001c3b\u0015\t\ty!A\u0002pe\u001eLA!a\u0005\u0002\u0006\tAA)\u0019;f)&lW\r\u0005\u0004\u0002\u0018\u0005\u0005\u0012q\u0005\b\u0005\u00033\tiBD\u0002W\u00037I\u0011\u0001G\u0005\u0004\u0003?9\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003G\t)CA\u0002TKFT1!a\b\u0018!\r1\u0012\u0011F\u0005\u0004\u0003W9\"aA%oi\u0006q1/\u001b;vCRLwN\u001c*fC\u0012\u0004\u0013AE4fiBcWO^5p'&$X/\u0019;j_:$\u0012bUA\u001a\u0003o\tI$a\u000f\t\r\u0005U\u0012\u00021\u0001a\u0003\u001diWm]:bO\u0016DQ!\\\u0005A\u00029DQ!^\u0005A\u0002MCQa^\u0005A\u0002M\u000b1\u0002\\8oO&#7OU3bIV\u0011\u0011\u0011\t\t\u0005Cn\f\u0019\u0005\u0005\u0004\u0002\u0018\u0005\u0005\u0012Q\t\t\u0004-\u0005\u001d\u0013bAA%/\t!Aj\u001c8h\u00031awN\\4JIN\u0014V-\u00193!\u0003a9W\r\u001e)mkZLw.\\3uKJ\u001c8+\u001b;vCRLwN\u001c\u000b\n'\u0006E\u00131KA+\u0003/Ba!!\u000e\r\u0001\u0004\u0001\u0007\"B7\r\u0001\u0004q\u0007\"B;\r\u0001\u0004\u0019\u0006\"B<\r\u0001\u0004\u0019\u0016!E:jiV\fG/[8o\t\u0006L8OU3bIV\u0011\u0011Q\f\t\u0005Cn\fy\u0006\u0005\u0007\u0017\u0003C\n\t!a\nT\u0003+\t9#C\u0002\u0002d]\u0011a\u0001V;qY\u0016,\u0014AE:jiV\fG/[8o\t\u0006L8OU3bI\u0002\nQcZ3u!2,h/[8ECf\u001c\u0016\u000e^;bi&|g\u000eF\u0005T\u0003W\ni'a\u001c\u0002r!1\u0011QG\bA\u0002\u0001DQ!\\\bA\u00029DQ!^\bA\u0002MCQa^\bA\u0002M\u0003")
public class SituationController {
    private final LogUtil logUtil;
    private final SituationDao situationDao;
    private final StationThresholdDao stationThresholdDao;
    private final Reads<Tuple4<DateTime, String, Seq<Object>, Object>> situationRead;
    private final Reads<Seq<Object>> longIdsRead;
    private final Reads<Tuple5<DateTime, Object, String, Seq<Object>, Object>> situationDaysRead;

    public String getKeyFigures(JsValue value, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.situationDao.getKeyFigures(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), KeyFigure$.MODULE$.normaleOutputWrites())).toString();
    }

    public Reads<Tuple4<DateTime, String, Seq<Object>, Object>> situationRead() {
        return this.situationRead;
    }

    public String getPluvioSituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.situationRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(30).append("Can't read pluvio situation : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)params -> {
            Tuple4 tuple4 = params;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            DateTime date = (DateTime)tuple4._1();
            Seq pluviometersIds = (Seq)tuple4._3();
            int dataType = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple3 tuple3 = new Tuple3((Object)date, (Object)pluviometersIds, (Object)BoxesRunTime.boxToInteger((int)dataType));
            DateTime date2 = (DateTime)tuple3._1();
            Seq pluviometersIds2 = (Seq)tuple3._2();
            int dataType2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Seq thresholds = $this.stationThresholdDao.getAllStationThresholds("pluviometry");
            Seq<PluvioSituation> results = $this.situationDao.getPluvioSituation((Seq<Object>)pluviometersIds2, date2, (Seq<StationThreshold>)thresholds, dataType2);
            return Json$.MODULE$.toJson(results, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), PluvioSituation$.MODULE$.situationFormat())).toString();
        });
    }

    public Reads<Seq<Object>> longIdsRead() {
        return this.longIdsRead;
    }

    public String getPluviometersSituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.longIdsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(29).append("Can't read pluvio ids list : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)pluviometerIds -> {
            Seq<PluvioMeasuresSituation> results = $this.situationDao.getPluviometerMeasuresSituation((Seq<Object>)pluviometerIds);
            return Json$.MODULE$.toJson(results, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), PluvioMeasuresSituation$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple5<DateTime, Object, String, Seq<Object>, Object>> situationDaysRead() {
        return this.situationDaysRead;
    }

    public String getPluvioDaySituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.situationDaysRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(35).append("Can't read pluvio days situation : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)params -> {
            Tuple5 tuple5 = params;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            DateTime date = (DateTime)tuple5._1();
            int nbDays = BoxesRunTime.unboxToInt((Object)tuple5._2());
            Seq pluviometersIds = (Seq)tuple5._4();
            int dataType = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple4 tuple4 = new Tuple4((Object)date, (Object)BoxesRunTime.boxToInteger((int)nbDays), (Object)pluviometersIds, (Object)BoxesRunTime.boxToInteger((int)dataType));
            DateTime date2 = (DateTime)tuple4._1();
            int nbDays2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            Seq pluviometersIds2 = (Seq)tuple4._3();
            int dataType2 = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Seq<PluvioSituationDays> result = $this.situationDao.getPluvioDaySituation((Seq<Object>)pluviometersIds2, dataType2, date2, nbDays2);
            return Json$.MODULE$.toJson(result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), PluvioSituationDays$.MODULE$.format())).toString();
        });
    }

    @Inject
    public SituationController(LogUtil logUtil, PluviometerDao pluviometerDao, SituationDao situationDao, StationThresholdDao stationThresholdDao) {
        this.logUtil = logUtil;
        this.situationDao = situationDao;
        this.stationThresholdDao = stationThresholdDao;
        this.situationRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("date").read((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("pluvioIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("dataType").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.longIdsRead = JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.LongReads()));
        this.situationDaysRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("date").read((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("nbDays").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("pluvioIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("dataType").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

