/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.sys.package$;

public final class UserUtil$ {
    public static final UserUtil$ MODULE$ = new UserUtil$();
    private static final int DefaultIterations = 500000;
    private static final SecureRandom random = new SecureRandom();

    public int DefaultIterations() {
        return DefaultIterations;
    }

    public SecureRandom random() {
        return random;
    }

    public byte[] pbkdf2(String password, byte[] salt, int iterations) {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, iterations, 512);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        return keyFactory.generateSecret(keySpec).getEncoded();
    }

    public String hashPassword(String password, byte[] salt) {
        byte[] salt2 = new byte[16];
        this.random().nextBytes(salt2);
        byte[] hash = this.pbkdf2(password, salt2, this.DefaultIterations());
        String salt64 = Base64.getEncoder().encodeToString(salt2);
        String hash64 = Base64.getEncoder().encodeToString(hash);
        return new StringBuilder(2).append(this.DefaultIterations()).append(":").append(hash64).append(":").append(salt64).toString();
    }

    public boolean checkPassword(String password, String passwordHash) {
        Object object;
        String[] stringArray = passwordHash.split(":");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) == 0) {
            String it = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String hash64 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            String salt64 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
            if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(it), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1)))))) {
                byte[] hash = Base64.getDecoder().decode(hash64);
                byte[] salt = Base64.getDecoder().decode(salt64);
                byte[] calculatedHash = this.pbkdf2(password, salt, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(it)));
                return Predef$.MODULE$.wrapByteArray(calculatedHash).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(hash));
            }
        }
        throw package$.MODULE$.error("Bad password hash");
    }

    private UserUtil$() {
    }
}

