/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jca;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAllocationException;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Category;
import tyrex.resource.PoolLimits;
import tyrex.resource.PoolMetrics;
import tyrex.resource.Resource;
import tyrex.resource.jca.ConnectorLoader;
import tyrex.resource.jca.PoolEntry;
import tyrex.services.Clock;
import tyrex.services.DaemonMaster;
import tyrex.tm.TyrexTransactionManager;
import tyrex.tm.impl.ThreadContext;
import tyrex.util.LoggerPrintWriter;
import tyrex.util.Primes;

final class ConnectionPool
extends PoolMetrics
implements Resource,
ConnectionManager,
Set,
ConnectionEventListener,
Runnable {
    public static final int TABLE_SIZE = 131;
    private final String _name;
    private final PoolEntry[] _pool;
    private final PoolLimits _limits;
    private final TyrexTransactionManager _txManager;
    private final ConnectorLoader _loader;
    private final Category _category;
    private final PrintWriter _logWriter;
    private final XAResource _xaResource;
    private final Object _factory;
    private long _nextExpiration;
    private boolean _destroyed;

    ConnectionPool(String string, PoolLimits poolLimits, ConnectorLoader connectorLoader, TyrexTransactionManager tyrexTransactionManager, Category category) throws ResourceException {
        ManagedConnection managedConnection = null;
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        if (connectorLoader == null) {
            throw new IllegalArgumentException("Argument loader is null");
        }
        if (tyrexTransactionManager == null) {
            throw new IllegalArgumentException("Argument txManager is null");
        }
        if (category == null) {
            throw new IllegalArgumentException("Argument category is null");
        }
        this._name = string;
        this._loader = connectorLoader;
        this._category = category;
        this._txManager = tyrexTransactionManager;
        if (poolLimits == null) {
            this._limits = new PoolLimits();
            this._logWriter = null;
        } else {
            this._limits = poolLimits;
            if (this._limits.getTrace()) {
                this._logWriter = new LoggerPrintWriter(this._category, null);
                this._loader.setLogWriter(this._logWriter);
            } else {
                this._logWriter = null;
            }
        }
        int n = this._limits.getMaximum();
        this._pool = n > 0 ? new PoolEntry[Primes.nextPrime(n)] : new PoolEntry[131];
        managedConnection = this._loader.createManagedConnection(null, null);
        this._xaResource = this._loader._xaSupported ? managedConnection.getXAResource() : null;
        this.allocate(managedConnection, false);
        ManagedConnectionMetaData managedConnectionMetaData = managedConnection.getMetaData();
        if (managedConnectionMetaData != null && managedConnectionMetaData.getMaxConnections() > 0 && managedConnectionMetaData.getMaxConnections() < n) {
            n = managedConnectionMetaData.getMaxConnections();
            this._limits.setMaximum(n);
        }
        int n2 = this._limits.getInitial();
        if (n > 0 && n2 > n) {
            n2 = n;
        }
        int n3 = n2 - 1;
        while (n3-- > 0) {
            managedConnection = this._loader.createManagedConnection(null, null);
            this.allocate(managedConnection, false);
        }
        this._factory = this._loader.createConnectionFactory(this);
        StringBuffer stringBuffer = new StringBuffer();
        if (managedConnectionMetaData.getEISProductName() != null) {
            stringBuffer.append(managedConnectionMetaData.getEISProductName());
            if (managedConnectionMetaData.getEISProductVersion() != null) {
                stringBuffer.append("  ").append(managedConnectionMetaData.getEISProductVersion());
            }
        } else {
            stringBuffer.append(this._loader.toString());
        }
        if (this._logWriter != null) {
            this._logWriter.println("Created connection pool for manager " + string + " with initial size " + n2 + " and maximum limit " + n);
            this._logWriter.println(stringBuffer.toString());
        }
        if (0 != this._limits.getMaxRetain()) {
            DaemonMaster.addDaemon(this, "Connection Pool " + string);
        }
    }

    public PoolMetrics getPoolMetrics() {
        return this;
    }

    public PoolLimits getPoolLimits() {
        return this._limits;
    }

    public Object getClientFactory() {
        return this._factory;
    }

    public Class getClientFactoryClass() {
        return this._factory.getClass();
    }

    public String toString() {
        return this._name;
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        long l = Clock.clock();
        DaemonMaster.removeDaemon(this);
        int n = this._pool.length;
        while (n-- > 0) {
            PoolEntry poolEntry = this._pool[n];
            while (poolEntry != null) {
                if (poolEntry._available) {
                    this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
                    this.recordDiscard();
                }
                try {
                    poolEntry._managed.removeConnectionEventListener((ConnectionEventListener)this);
                    poolEntry._managed.destroy();
                }
                catch (Exception exception) {
                    this._category.error((Object)("Error attempting to destory connection " + poolEntry._managed + " by connection pool " + this), (Throwable)exception);
                }
                poolEntry._available = false;
                poolEntry = poolEntry._nextEntry;
            }
            this._pool[n] = null;
        }
        this._total = 0;
        this._available = 0;
    }

    public synchronized void run() {
        try {
            while (true) {
                long l;
                if ((l = this._nextExpiration) == 0L) {
                    this.wait();
                    continue;
                }
                long l2 = Clock.clock();
                if (l2 > l) {
                    this.expire();
                    continue;
                }
                this.wait(l - l2);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this._destroyed) {
            throw new ResourceException("Connection pool has been destroyed");
        }
        if (managedConnectionFactory != this._loader.getConfigFactory()) {
            this._category.error((Object)"Connector error: called allocateConnection with the wrong factory");
            throw new ResourceAllocationException("Connector error: called allocateConnection with the wrong factory");
        }
        PoolEntry poolEntry = this.allocate(connectionRequestInfo);
        if (poolEntry._xaResource != null) {
            try {
                this._txManager.enlistResource(poolEntry._xaResource);
            }
            catch (Exception exception) {
                this.release(poolEntry._managed, false);
                throw new ResourceAllocationException("Error occured using connection " + poolEntry._managed + ": " + exception);
            }
        }
        try {
            Object object = this._loader.getConnection(poolEntry._managed, ThreadContext.getThreadContext().getSubject(), connectionRequestInfo);
            return object;
        }
        catch (Exception exception) {
            this.release(poolEntry._managed, false);
            if (this._category.isDebugEnabled()) {
                this._category.debug((Object)("Error occured using connection " + poolEntry._managed), (Throwable)exception);
            }
            throw new ResourceAllocationException("Error occured using connection " + poolEntry._managed + ": " + exception);
        }
    }

    private synchronized PoolEntry allocate(ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        int n;
        long l = this._limits.getTimeout() * 1000;
        while (true) {
            PoolEntry poolEntry;
            ManagedConnection managedConnection;
            if (this._available > 0) {
                managedConnection = this._loader.matchManagedConnections(this, ThreadContext.getThreadContext().getSubject(), connectionRequestInfo);
                if (managedConnection != null) {
                    poolEntry = this.reserve(managedConnection);
                    if (poolEntry == null) {
                        this.release(managedConnection, false);
                        this._category.error((Object)"Connector error: matchManagedConnetions returned an unavailable connection");
                        continue;
                    }
                    return poolEntry;
                }
            }
            if ((n = this._limits.getMaximum()) == 0 || this._total < n || this._available > 0 && this.discardNext()) {
                managedConnection = this._loader.createManagedConnection(ThreadContext.getThreadContext().getSubject(), connectionRequestInfo);
                poolEntry = this.allocate(managedConnection, true);
                if (poolEntry == null) {
                    throw new ResourceException("Connector error: createManagedConnetion returned an existing connection");
                }
                return poolEntry;
            }
            if (l <= 0L) {
                throw new ResourceAllocationException("Cannot allocate new connection for " + this._name + ": reached limit of " + n + " connections");
            }
            long l2 = Clock.clock();
            try {
                this.wait(l);
                l -= Clock.clock() - l2;
            }
            catch (InterruptedException interruptedException) {
                l = 0L;
            }
            if (l <= 0L) break;
        }
        throw new ResourceAllocationException("Cannot allocate new connection for " + this._name + ": reached limit of " + n + " connections");
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            Object object = connectionEvent.getConnectionHandle();
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            if (managedConnection != null) {
                if (!this.release(managedConnection, true)) {
                    this._category.error((Object)"Connector error: connectionClosed called with invalid connection");
                }
            } else {
                this._category.error((Object)"Connector error: connectionClosed called without reference to connection");
            }
        }
        catch (ClassCastException classCastException) {
            this._category.error((Object)"Connector error: connectionClosed called without reference to connection");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            if (managedConnection != null) {
                if (!this.release(managedConnection, false)) {
                    this._category.error((Object)"Connector error: connectionClosed called with invalid connection");
                }
            } else {
                this._category.error((Object)"Connector error: connectionErrorOccurred called without reference to connection");
            }
        }
        catch (ClassCastException classCastException) {
            this._category.error((Object)"Connector error: connectionErrorOccurred called without reference to connection");
        }
    }

    public void localTransactionCommitted(ConnectionEvent connectionEvent) {
    }

    public void localTransactionRolledback(ConnectionEvent connectionEvent) {
    }

    public void localTransactionStarted(ConnectionEvent connectionEvent) {
    }

    private boolean append(ManagedConnection managedConnection) {
        try {
            return this.allocate(managedConnection, false) != null;
        }
        catch (ResourceException resourceException) {
            return false;
        }
    }

    private synchronized PoolEntry allocate(ManagedConnection managedConnection, boolean bl) throws ResourceException {
        int n;
        XAResource xAResource = null;
        LocalTransaction localTransaction = null;
        if (managedConnection == null) {
            throw new IllegalArgumentException("Argument managed is null");
        }
        if (this._loader._xaSupported) {
            xAResource = managedConnection.getXAResource();
        } else if (this._loader._localSupported) {
            localTransaction = managedConnection.getLocalTransaction();
        }
        int n2 = managedConnection.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n3];
        if (poolEntry == null) {
            this._pool[n3] = poolEntry = new PoolEntry(managedConnection, n2, xAResource, localTransaction);
        } else {
            if (poolEntry._hashCode == n2 && poolEntry._managed.equals(managedConnection)) {
                this._category.error((Object)("Connector error: Allocated connection " + managedConnection + " already in pool"));
                return null;
            }
            PoolEntry poolEntry2 = poolEntry._nextEntry;
            while (poolEntry2 != null) {
                if (poolEntry2._hashCode == n2 && poolEntry2._managed.equals(managedConnection)) {
                    this._category.error((Object)("Connector error: Allocated connection " + managedConnection + " already in pool"));
                    return null;
                }
                poolEntry = poolEntry2;
                poolEntry2 = poolEntry._nextEntry;
            }
            poolEntry._nextEntry = poolEntry2 = new PoolEntry(managedConnection, n2, xAResource, localTransaction);
            poolEntry = poolEntry2;
        }
        poolEntry._managed.addConnectionEventListener((ConnectionEventListener)this);
        this.recordCreated();
        if (!bl) {
            poolEntry._available = true;
            ++this._available;
        }
        if ((n = this._limits.getMaxRetain()) > 0) {
            long l = poolEntry._timeStamp + (long)(n * 1000);
            if (this._nextExpiration == 0L || this._nextExpiration > l) {
                this._nextExpiration = l;
                this.notifyAll();
            }
        }
        if (this._logWriter != null) {
            this._logWriter.println("Allocated new connection " + poolEntry._managed);
        }
        return poolEntry;
    }

    private synchronized PoolEntry reserve(ManagedConnection managedConnection) {
        if (managedConnection == null) {
            return null;
        }
        int n = managedConnection.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        while (poolEntry != null && poolEntry._hashCode != n && !poolEntry._managed.equals(managedConnection)) {
            poolEntry = poolEntry._nextEntry;
        }
        if (poolEntry != null && poolEntry._available) {
            poolEntry._available = false;
            --this._available;
            long l = Clock.clock();
            this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
            poolEntry._timeStamp = l;
            if (this._logWriter != null) {
                this._logWriter.println("Reusing connection " + poolEntry._managed);
            }
            return poolEntry;
        }
        return null;
    }

    private synchronized boolean release(ManagedConnection managedConnection, boolean bl) {
        if (managedConnection == null) {
            return false;
        }
        int n = managedConnection.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        if (poolEntry != null) {
            if (n == poolEntry._hashCode && poolEntry._managed.equals(managedConnection)) {
                if (poolEntry._available) {
                    this._category.error((Object)("Connector error: Released connection " + managedConnection + " not in pool"));
                    return false;
                }
            } else {
                poolEntry = poolEntry._nextEntry;
                while (poolEntry != null && n != poolEntry._hashCode && !poolEntry._managed.equals(managedConnection)) {
                    poolEntry = poolEntry._nextEntry;
                }
                if (poolEntry == null || poolEntry._available) {
                    this._category.error((Object)("Connector error: Released connection " + managedConnection + " not in pool"));
                    return false;
                }
            }
        } else {
            this._category.error((Object)("Connector error: Released connection " + managedConnection + " not in pool"));
            return false;
        }
        try {
            long l = Clock.clock();
            this.recordUsedDuration((int)(l - poolEntry._timeStamp));
            poolEntry._timeStamp = l;
            poolEntry._available = true;
            if (poolEntry._xaResource != null) {
                this._txManager.delistResource(poolEntry._xaResource, bl ? 0x4000000 : 0x20000000);
            }
            if (bl) {
                ++this._available;
                poolEntry._managed.cleanup();
                int n3 = this._limits.getMaxRetain();
                if (n3 > 0) {
                    long l2 = poolEntry._timeStamp + (long)(n3 * 1000);
                    if (this._nextExpiration == 0L || this._nextExpiration > l2) {
                        this._nextExpiration = l2;
                    }
                }
                this.notifyAll();
            } else {
                this.discard(managedConnection, false);
            }
        }
        catch (Exception exception) {
            this._category.error((Object)("Error attempting to release connection " + poolEntry._managed + " by connection pool " + this), (Throwable)exception);
            this.discard(poolEntry._managed, false);
        }
        if (this._logWriter != null) {
            this._logWriter.println("Released connection " + managedConnection);
        }
        return true;
    }

    private synchronized boolean discardNext() {
        PoolEntry poolEntry = null;
        int n = this._pool.length;
        while (n-- > 0) {
            poolEntry = this._pool[n];
            if (poolEntry != null) {
                if (poolEntry._available) {
                    this._pool[n] = poolEntry._nextEntry;
                    break;
                }
                PoolEntry poolEntry2 = poolEntry._nextEntry;
                while (poolEntry2 != null) {
                    if (poolEntry2._available) {
                        poolEntry._nextEntry = poolEntry2._nextEntry;
                        poolEntry = poolEntry2;
                        break;
                    }
                    poolEntry = poolEntry2;
                    poolEntry2 = poolEntry2._nextEntry;
                }
                if (poolEntry2 != null) break;
            }
            poolEntry = null;
        }
        if (poolEntry == null) {
            return false;
        }
        try {
            long l = Clock.clock();
            this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
            this.recordDiscard();
            poolEntry._managed.removeConnectionEventListener((ConnectionEventListener)this);
            poolEntry._managed.destroy();
        }
        catch (Exception exception) {
            this._category.error((Object)("Error attempting to destory connection " + poolEntry._managed + " by connection pool " + this), (Throwable)exception);
        }
        this.notifyAll();
        if (this._logWriter != null) {
            this._logWriter.println("Discarded connection " + poolEntry._managed);
        }
        return true;
    }

    private synchronized boolean discard(ManagedConnection managedConnection, boolean bl) {
        if (managedConnection == null) {
            return false;
        }
        int n = managedConnection.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        if (poolEntry == null) {
            return false;
        }
        if (n == poolEntry._hashCode && poolEntry._managed.equals(managedConnection)) {
            this._pool[n2] = poolEntry._nextEntry;
            if (!poolEntry._available) {
                return false;
            }
        } else {
            PoolEntry poolEntry2 = poolEntry._nextEntry;
            while (poolEntry2 != null) {
                if (n == poolEntry2._hashCode && poolEntry2._managed.equals(managedConnection)) {
                    if (!poolEntry2._available) {
                        return false;
                    }
                    poolEntry._nextEntry = poolEntry2._nextEntry;
                    poolEntry = poolEntry2;
                    break;
                }
                poolEntry = poolEntry2;
                poolEntry2 = poolEntry._nextEntry;
            }
            if (poolEntry2 == null) {
                return false;
            }
        }
        try {
            long l = Clock.clock();
            this.recordUnusedDuration((int)(l - poolEntry._timeStamp));
            if (bl) {
                this.recordDiscard();
            } else {
                this.recordError();
            }
            poolEntry._managed.removeConnectionEventListener((ConnectionEventListener)this);
            poolEntry._managed.destroy();
        }
        catch (Exception exception) {
            this._category.error((Object)("Error attempting to destory connection " + poolEntry._managed + " by connection pool " + this), (Throwable)exception);
        }
        this.notifyAll();
        return true;
    }

    protected synchronized long expire() {
        int n = this._limits.getMaxRetain();
        if (n == 0) {
            return 0L;
        }
        n *= 1000;
        long l = Clock.clock();
        if (l >= this._nextExpiration) {
            long l2 = l - (long)n;
            long l3 = 0L;
            int n2 = this._pool.length;
            while (n2-- > 0) {
                PoolEntry poolEntry = null;
                PoolEntry poolEntry2 = this._pool[n2];
                while (poolEntry2 != null) {
                    if (poolEntry2._available) {
                        if (poolEntry2._timeStamp <= l2) {
                            if (poolEntry == null) {
                                this._pool[n2] = poolEntry2._nextEntry;
                            } else {
                                poolEntry._nextEntry = poolEntry2._nextEntry;
                            }
                            this.recordUnusedDuration((int)(l - poolEntry2._timeStamp));
                            this.recordDiscard();
                            try {
                                poolEntry2._managed.removeConnectionEventListener((ConnectionEventListener)this);
                                poolEntry2._managed.destroy();
                            }
                            catch (Exception exception) {
                                this._category.error((Object)("Error attempting to destory connection " + poolEntry2._managed + " by connection pool " + this), (Throwable)exception);
                            }
                            poolEntry2 = poolEntry2._nextEntry;
                            continue;
                        }
                        if (l3 == 0L || l3 > poolEntry2._timeStamp) {
                            l3 = poolEntry2._timeStamp;
                        }
                        poolEntry = poolEntry2;
                        poolEntry2 = poolEntry2._nextEntry;
                        continue;
                    }
                    poolEntry = poolEntry2;
                    poolEntry2 = poolEntry2._nextEntry;
                }
            }
            if (l3 != 0L) {
                l3 += (long)n;
            }
            this._nextExpiration = l3;
        }
        return this._nextExpiration;
    }

    public synchronized boolean add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument object is null");
        }
        if (this._destroyed) {
            return false;
        }
        if (object instanceof ManagedConnection) {
            return this.append((ManagedConnection)object);
        }
        throw new ClassCastException("Object not of type ManagedConnection");
    }

    public synchronized boolean addAll(Collection collection) {
        boolean bl = false;
        if (collection == null) {
            throw new IllegalArgumentException("Argument collection is null");
        }
        if (this._destroyed) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ManagedConnection) {
                if (!this.append((ManagedConnection)e)) continue;
                bl = true;
                continue;
            }
            throw new ClassCastException("Object not of type ManagedConnection");
        }
        return bl;
    }

    public synchronized void clear() {
        if (this._destroyed) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.discard((ManagedConnection)e, true);
        }
    }

    public synchronized boolean contains(Object object) {
        if (object == null || this._destroyed) {
            return false;
        }
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._pool.length;
        PoolEntry poolEntry = this._pool[n2];
        while (poolEntry != null) {
            if (poolEntry._hashCode == n && poolEntry._managed.equals(object)) {
                return poolEntry._available;
            }
            poolEntry = poolEntry._nextEntry;
        }
        return false;
    }

    public synchronized boolean containsAll(Collection collection) {
        if (collection == null || this._destroyed) {
            throw new IllegalArgumentException("Argument collection is null");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        if (((Set)object).size() != this._available) {
            return false;
        }
        return this.containsAll((Collection)((Set)object));
    }

    public synchronized int hashCode() {
        PoolEntry[] poolEntryArray = this._pool;
        int n = 0;
        int n2 = 0;
        while (n2 < poolEntryArray.length) {
            PoolEntry poolEntry = poolEntryArray[n2];
            while (poolEntry != null) {
                if (poolEntry._available) {
                    n += poolEntry._hashCode;
                }
                poolEntry = poolEntry._nextEntry;
            }
            ++n2;
        }
        return n;
    }

    public boolean isEmpty() {
        return this._available == 0;
    }

    public Iterator iterator() {
        return new PoolIterator();
    }

    public synchronized boolean remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument object is null");
        }
        if (this._destroyed) {
            return false;
        }
        if (object instanceof ManagedConnection) {
            return this.discard((ManagedConnection)object, true);
        }
        throw new ClassCastException("Object not of type ManagedConnection");
    }

    public synchronized boolean removeAll(Collection collection) {
        boolean bl = false;
        if (collection == null) {
            throw new IllegalArgumentException("Argument collection is null");
        }
        if (this._destroyed) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ManagedConnection) {
                if (!this.discard((ManagedConnection)e, true)) continue;
                bl = true;
                continue;
            }
            throw new ClassCastException("Object not of type ManagedConnection");
        }
        return bl;
    }

    public synchronized boolean retainAll(Collection collection) {
        boolean bl = false;
        if (collection == null) {
            throw new IllegalArgumentException("Argument collection is null");
        }
        if (this._destroyed) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e) || !this.discard((ManagedConnection)e, true)) continue;
            bl = true;
        }
        return bl;
    }

    public int size() {
        return this._available;
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this._available];
        int n = 0;
        PoolEntry[] poolEntryArray = this._pool;
        int n2 = 0;
        while (n2 < poolEntryArray.length) {
            PoolEntry poolEntry = poolEntryArray[n2];
            while (poolEntry != null) {
                if (poolEntry._available) {
                    objectArray[n++] = poolEntry._managed;
                }
                poolEntry = poolEntry._nextEntry;
            }
            ++n2;
        }
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Argument array is null");
        }
        if (objectArray.length < this._available) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._available);
        }
        int n = 0;
        PoolEntry[] poolEntryArray = this._pool;
        int n2 = 0;
        while (n2 < poolEntryArray.length) {
            PoolEntry poolEntry = poolEntryArray[n2];
            while (poolEntry != null) {
                if (poolEntry._available) {
                    objectArray[n++] = poolEntry._managed;
                }
                poolEntry = poolEntry._nextEntry;
            }
            ++n2;
        }
        return objectArray;
    }

    private class PoolIterator
    implements Iterator {
        private PoolEntry _entry;
        private int _index;

        private PoolIterator() {
            this._index = ConnectionPool.this._pool.length;
        }

        public boolean hasNext() {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                PoolEntry poolEntry = this._entry;
                while (poolEntry != null) {
                    if (poolEntry._available) {
                        this._entry = poolEntry;
                        boolean bl = true;
                        return bl;
                    }
                    poolEntry = poolEntry._nextEntry;
                }
                PoolEntry[] poolEntryArray = ConnectionPool.this._pool;
                int n = this._index;
                while (poolEntry == null && n > 0) {
                    poolEntry = poolEntryArray[--n];
                    while (poolEntry != null) {
                        if (poolEntry._available) {
                            this._entry = poolEntry;
                            this._index = n;
                            boolean bl = true;
                            return bl;
                        }
                        poolEntry = poolEntry._nextEntry;
                    }
                }
                this._entry = null;
                this._index = -1;
                boolean bl = false;
                return bl;
            }
        }

        public Object next() {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements in collection");
                }
                PoolEntry poolEntry = this._entry;
                this._entry = poolEntry._nextEntry;
                ManagedConnection managedConnection = poolEntry._managed;
                return managedConnection;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("This set is immutable");
        }
    }
}

