/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pdi.jwt.exceptions.JwtExpirationException;
import pdi.jwt.exceptions.JwtNotBeforeException;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class JwtTime$ {
    public static final JwtTime$ MODULE$ = new JwtTime$();

    public long now(Clock clock) {
        return clock.instant().toEpochMilli();
    }

    public long nowSeconds(Clock clock) {
        return this.now(clock) / 1000L;
    }

    public String format(long time) {
        return Instant.ofEpochMilli(time).toString();
    }

    public boolean nowIsBetween(Option<Object> start, Option<Object> end, Clock clock) {
        boolean bl;
        try {
            this.validateNowIsBetween(start, end, clock);
            bl = true;
        }
        catch (JwtNotBeforeException jwtNotBeforeException) {
            bl = false;
        }
        catch (JwtExpirationException jwtExpirationException) {
            bl = false;
        }
        return bl;
    }

    public boolean nowIsBetweenSeconds(Option<Object> start, Option<Object> end, Clock clock) {
        return this.nowIsBetween((Option<Object>)start.map((Function1)(JFunction1.mcJJ.sp & Serializable)x$1 -> x$1 * 1000L), (Option<Object>)end.map((Function1)(JFunction1.mcJJ.sp & Serializable)x$2 -> x$2 * 1000L), clock);
    }

    public void validateNowIsBetween(Option<Object> start, Option<Object> end, Clock clock) {
        long timeNow = this.now(clock);
        if (!start.isEmpty() && BoxesRunTime.unboxToLong((Object)start.get()) > timeNow) {
            throw new JwtNotBeforeException(BoxesRunTime.unboxToLong((Object)start.get()));
        }
        if (!end.isEmpty() && timeNow >= BoxesRunTime.unboxToLong((Object)end.get())) {
            throw new JwtExpirationException(BoxesRunTime.unboxToLong((Object)end.get()));
        }
    }

    public void validateNowIsBetweenSeconds(Option<Object> start, Option<Object> end, Clock clock) {
        this.validateNowIsBetween((Option<Object>)start.map((Function1)(JFunction1.mcJJ.sp & Serializable)x$3 -> x$3 * 1000L), (Option<Object>)end.map((Function1)(JFunction1.mcJJ.sp & Serializable)x$4 -> x$4 * 1000L), clock);
    }

    private JwtTime$() {
    }
}

