/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constants.StationTypeConstants$;
import fr.aquasys.daeau.distribution_unit.itf.DistributionUnitDao;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.installation.itf.InstallationDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.production_unit.domain.input.ProductionUnitInput$;
import fr.aquasys.daeau.production_unit.domain.output.ProductionUnitOutput;
import fr.aquasys.daeau.production_unit.domain.output.ProductionUnitOutput$;
import fr.aquasys.daeau.production_unit.itf.ProductionUnitDao;
import fr.aquasys.daeau.production_unit.model.ProductionUnit$;
import fr.aquasys.daeau.production_unit.model.ProductionUnitLink;
import fr.aquasys.daeau.production_unit.model.ProductionUnitLink$;
import fr.aquasys.daeau.production_unit.model.linkType.PULinkWithData$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.station.domain.input.GenericStation$;
import fr.aquasys.daeau.station.links.stationlink.StationLink;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed$;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\u0011\"\u0001\u0011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011)\u0004!\u0011!Q\u0001\n-D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Q\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!I\u0011q\t\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002L!I\u0011Q\u0011\u0001C\u0002\u0013\u0005\u0011q\u0011\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\n\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0007\u0004A\u0011AAc\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002d\u0002!\t!!:\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqA!\u000e\u0001\t\u0003\u00119\u0004C\u0004\u0003V\u0001!\tAa\u0016\t\u0013\t\u0005\u0004A1A\u0005\u0002\t\r\u0004\u0002\u0003BA\u0001\u0001\u0006IA!\u001a\t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\nA\u0002K]8ek\u000e$\u0018n\u001c8V]&$8i\u001c8ue>dG.\u001a:\u000b\u0003\t\n1bY8oiJ|G\u000e\\3sg\u000e\u00011c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u001b\u000e\u00035R!AL\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00021c\u0005A!/\u00192cSRl\u0017O\u0003\u00023g\u00059\u0011-];bgf\u001c(\"\u0001\u001b\u0002\u0005\u0019\u0014\u0018B\u0001\u001c.\u0005!\u0001&o\u001c3vG\u0016\u0014\u0018!\u00059s_\u0012,8\r^5p]Vs\u0017\u000e\u001e#b_B\u0011\u0011\bQ\u0007\u0002u)\u00111\bP\u0001\u0004SR4'BA\u001f?\u0003=\u0001(o\u001c3vGRLwN\\0v]&$(BA 2\u0003\u0015!\u0017-Z1v\u0013\t\t%HA\tQe>$Wo\u0019;j_:,f.\u001b;EC>\fa\u0002\u001d7vm&|W.\u001a;fe\u0012\u000bw\u000e\u0005\u0002E\u00116\tQI\u0003\u0002<\r*\u0011qIP\u0001\fa2,h/[8nKR\u0014\u00180\u0003\u0002J\u000b\nq\u0001\u000b\\;wS>lW\r^3s\t\u0006|\u0017aD5ogR\fG\u000e\\1uS>tG)Y8\u0011\u00051\u0003V\"A'\u000b\u0005mr%BA(?\u00031Ign\u001d;bY2\fG/[8o\u0013\t\tVJA\bJ]N$\u0018\r\u001c7bi&|g\u000eR1p\u0003M!\u0017n\u001d;sS\n,H/[8o+:LG\u000fR1p!\t!\u0006,D\u0001V\u0015\tYdK\u0003\u0002X}\u0005\tB-[:ue&\u0014W\u000f^5p]~+h.\u001b;\n\u0005e+&a\u0005#jgR\u0014\u0018NY;uS>tWK\\5u\t\u0006|\u0017A\u00065zIJ|Gn\\4jG\u0006d7\u000b^1uS>tG)Y8\u0011\u0005q\u0003W\"A/\u000b\u0005mr&BA0?\u0003)A\u0017\u0010\u001a:p[\u0016$(/_\u0005\u0003Cv\u0013a\u0003S=ee>dwnZ5dC2\u001cF/\u0019;j_:$\u0015m\\\u0001\u0010a&,'p\\7fi\u0016\u0014H)Y3bkB\u0011A\r[\u0007\u0002K*\u00111H\u001a\u0006\u0003Oz\n!\u0002]5fu>lW\r\u001e:z\u0013\tIWMA\bQS\u0016Tx.\\3uKJ$\u0015-Z1v\u0003=\tX/\u00197ji>lW\r^3s\t\u0006|\u0007C\u00017q\u001b\u0005i'BA\u001eo\u0015\tyg(A\u0004rk\u0006d\u0017\u000e^=\n\u0005El'aD)vC2LGo\\7fi\u0016\u0014H)Y8\u0002\u001dU\u001cXM]*uCRLwN\u001c#b_B\u0011A\u000f_\u0007\u0002k*\u00111H\u001e\u0006\u0003oz\nA!^:fe&\u0011\u00110\u001e\u0002\u000f+N,'o\u0015;bi&|g\u000eR1p\u00039\u0019H/\u0019;j_:d\u0015N\\6EC>\u00042\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003-\u0019H/\u0019;j_:d\u0017N\\6\u000b\t\u0005\u0005\u00111A\u0001\u0006Y&t7n\u001d\u0006\u0004\u0003\u000bq\u0014aB:uCRLwN\\\u0005\u0004\u0003\u0013i(AD*uCRLwN\u001c'j].$\u0015m\\\u0001\bY><W\u000b^5m!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n_\u0005!Q\u000f^5m\u0013\u0011\t9\"!\u0005\u0003\u000f1{w-\u0016;jY\u00061A(\u001b8jiz\"b#!\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\tY#!\f\u00020\u0005E\u00121\u0007\t\u0004\u0003?\u0001Q\"A\u0011\t\u000b]Z\u0001\u0019\u0001\u001d\t\u000b\t[\u0001\u0019A\"\t\u000b)[\u0001\u0019A&\t\u000bI[\u0001\u0019A*\t\u000bi[\u0001\u0019A.\t\u000b\t\\\u0001\u0019A2\t\u000b)\\\u0001\u0019A6\t\u000bI\\\u0001\u0019A:\t\u000bi\\\u0001\u0019A>\t\u000f\u0005-1\u00021\u0001\u0002\u000e!\u001a1\"a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u00051\u0011N\u001c6fGRT!!!\u0011\u0002\u000b)\fg/\u0019=\n\t\u0005\u0015\u00131\b\u0002\u0007\u0013:TWm\u0019;\u0002!%$Wk]3s\u001b>$W\u000f\\3SK\u0006$WCAA&!\u0019\ti%!\u0018\u0002b5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0003kg>t'\u0002BA+\u0003/\nA\u0001\\5cg*\u0019a&!\u0017\u000b\u0005\u0005m\u0013\u0001\u00029mCfLA!a\u0018\u0002P\t)!+Z1egBIa%a\u0019\u0002h\u00055\u0014QN\u0005\u0004\u0003K:#A\u0002+va2,7\u0007E\u0002'\u0003SJ1!a\u001b(\u0005\rIe\u000e\u001e\t\u0005\u0003_\niH\u0004\u0003\u0002r\u0005e\u0004cAA:O5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u001a\u0013A\u0002\u001fs_>$h(C\u0002\u0002|\u001d\na\u0001\u0015:fI\u00164\u0017\u0002BA@\u0003\u0003\u0013aa\u0015;sS:<'bAA>O\u0005\t\u0012\u000eZ+tKJlu\u000eZ;mKJ+\u0017\r\u001a\u0011\u0002\u001dU\u001cXM]'pIVdWMU3bIV\u0011\u0011\u0011\u0012\t\u0007\u0003\u001b\ni&a#\u0011\u000f\u0019\ni)!\u001c\u0002n%\u0019\u0011qR\u0014\u0003\rQ+\b\u000f\\33\u0003=)8/\u001a:N_\u0012,H.\u001a*fC\u0012\u0004\u0013AE4fiB\u0013x\u000eZ;di&|g.\u00168jiN$\"\"!\u001c\u0002\u0018\u0006\u0005\u0016\u0011WA[\u0011\u001d\tI\n\u0005a\u0001\u00037\u000bq!\\3tg\u0006<W\r\u0005\u0003\u0002N\u0005u\u0015\u0002BAP\u0003\u001f\u0012qAS:WC2,X\rC\u0004\u0002$B\u0001\r!!*\u0002\u000f!,\u0017\rZ3sgBA\u0011qNAT\u0003[\nY+\u0003\u0003\u0002*\u0006\u0005%aA'baB\u0019a%!,\n\u0007\u0005=vEA\u0002B]fDq!a-\u0011\u0001\u0004\ti'\u0001\u0004n_\u0012,H.\u001a\u0005\u0007oB\u0001\r!!\u001c\u0002\u0017\u001d,G/\u00117m\u0007>$Wm\u001d\u000b\u000b\u0003[\nY,!0\u0002@\u0006\u0005\u0007bBAM#\u0001\u0007\u00111\u0014\u0005\b\u0003G\u000b\u0002\u0019AAS\u0011\u001d\t\u0019,\u0005a\u0001\u0003[Baa^\tA\u0002\u00055\u0014aF4fiB\u0013x\u000eZ;di&|g.\u00168ji^KG\u000f[%e))\ti'a2\u0002J\u0006-\u0017Q\u001a\u0005\b\u00033\u0013\u0002\u0019AAN\u0011\u001d\t\u0019K\u0005a\u0001\u0003KCq!a-\u0013\u0001\u0004\ti\u0007\u0003\u0004x%\u0001\u0007\u0011QN\u0001\u0012O\u0016$\bK]8ek\u000e$\u0018n\u001c8V]&$H\u0003BA7\u0003'Dq!!6\u0014\u0001\u0004\t9'\u0001\u0002jI\u0006!2M]3bi\u0016\u0004&o\u001c3vGRLwN\\+oSR$\"\"!\u001c\u0002\\\u0006u\u0017q\\Aq\u0011\u001d\tI\n\u0006a\u0001\u00037Cq!a)\u0015\u0001\u0004\t)\u000bC\u0004\u00024R\u0001\r!!\u001c\t\r]$\u0002\u0019AA7\u0003Q)\b\u000fZ1uKB\u0013x\u000eZ;di&|g.\u00168jiRQ\u0011QNAt\u0003S\fY/!<\t\u000f\u0005eU\u00031\u0001\u0002\u001c\"9\u00111U\u000bA\u0002\u0005\u0015\u0006bBAZ+\u0001\u0007\u0011Q\u000e\u0005\u0007oV\u0001\r!!\u001c\u0002)\u0011,G.\u001a;f!J|G-^2uS>tWK\\5u))\ti'a=\u0002v\u0006]\u0018\u0011 \u0005\b\u000333\u0002\u0019AAN\u0011\u001d\t\u0019K\u0006a\u0001\u0003KCq!a-\u0017\u0001\u0004\ti\u0007\u0003\u0004x-\u0001\u0007\u0011QN\u0001 O\u0016$\bK]8ek\u000e$\u0018n\u001c8V]&$\u0018i]:pG&\fG/\u001a3TSR,GCCA7\u0003\u007f\u0014\tAa\u0001\u0003\u0006!9\u0011\u0011T\fA\u0002\u0005m\u0005bBAR/\u0001\u0007\u0011Q\u0015\u0005\b\u0003g;\u0002\u0019AA7\u0011\u00199x\u00031\u0001\u0002n\u0005\u0011r-\u001a;QS\u0016Tx.\\3uKJ\u001cu\u000eZ3t)\u0019\u0011YA!\b\u0003\"A1!Q\u0002B\f\u0003[rAAa\u0004\u0003\u00149!\u00111\u000fB\t\u0013\u0005A\u0013b\u0001B\u000bO\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\r\u00057\u00111aU3r\u0015\r\u0011)b\n\u0005\b\u0005?A\u0002\u0019\u0001B\u0006\u0003E\tG\u000e\\8x'R\fG/[8o\u0007>$Wm\u001d\u0005\b\u0005GA\u0002\u0019AA7\u000311\u0018\r\\5eCR,Wk]3s\u0003Q9W\r^)vC2LGo\\7fi\u0016\u00148i\u001c3fgR1!1\u0002B\u0015\u0005WAqAa\b\u001a\u0001\u0004\u0011Y\u0001C\u0004\u0003$e\u0001\r!!\u001c\u0002\u001b\u0015l\u0007\u000f^=Gk:\u001cG/[8o)\u0019\u0011YA!\r\u00034!9!q\u0004\u000eA\u0002\t-\u0001b\u0002B\u00125\u0001\u0007\u0011QN\u0001\u0014O\u0016$\u0018\t\u001c7po2Kgn[*uCRLwN\u001c\u000b\u000b\u0005s\u0011\tE!\u0012\u0003J\t-\u0003C\u0002B\u0007\u0005/\u0011Y\u0004E\u0002}\u0005{I1Aa\u0010~\u0005-\u0019F/\u0019;j_:d\u0015N\\6\t\u000f\t\r3\u00041\u0001\u0003:\u0005\u0019B.[:u\u001f\u001ad\u0015N\\6fIN#\u0018\r^5p]\"9!qI\u000eA\u0002\t-\u0011AD1mY><8+\u001b;f\u0007>$Wm\u001d\u0005\b\u0005GY\u0002\u0019AA7\u0011\u001d\u0011ie\u0007a\u0001\u0005\u001f\nacZ3u'R\fG/[8o\u0007>$WMR;oGRLwN\u001c\t\nM\tE#1BA7\u0005\u0017I1Aa\u0015(\u0005%1UO\\2uS>t''\u0001\thKR\u0004&o\u001c3V]&$H*\u001b8lgRQ\u0011Q\u000eB-\u00057\u0012iFa\u0018\t\u000f\u0005eE\u00041\u0001\u0002\u001c\"9\u00111\u0015\u000fA\u0002\u0005\u0015\u0006bBAZ9\u0001\u0007\u0011Q\u000e\u0005\u0007or\u0001\r!!\u001c\u0002+\u0005\u001c8o\\2jCRLwN\\+qI\u0006$XMU3bIV\u0011!Q\r\t\u0007\u0003\u001b\niFa\u001a\u0011\u0017\u0019\u0012I'a\u001a\u0002n\t5$QN\u0005\u0004\u0005W:#A\u0002+va2,G\u0007E\u0003'\u0005_\u0012\u0019(C\u0002\u0003r\u001d\u0012aa\u00149uS>t\u0007C\u0002B\u0007\u0005/\u0011)\b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011Y\bP\u0001\u0006[>$W\r\\\u0005\u0005\u0005\u007f\u0012IH\u0001\nQe>$Wo\u0019;j_:,f.\u001b;MS:\\\u0017AF1tg>\u001c\u0017.\u0019;j_:,\u0006\u000fZ1uKJ+\u0017\r\u001a\u0011\u0002'U\u0004H-\u0019;f!J|G-\u00168ji2Kgn[:\u0015\u0015\u00055$q\u0011BE\u0005\u0017\u0013i\tC\u0004\u0002\u001a~\u0001\r!a'\t\u000f\u0005\rv\u00041\u0001\u0002&\"9\u00111W\u0010A\u0002\u00055\u0004BB< \u0001\u0004\ti\u0007K\u0002\u0001\u0005#\u0003B!!\u000f\u0003\u0014&!!QSA\u001e\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class ProductionUnitController
implements Producer {
    private final ProductionUnitDao productionUnitDao;
    private final PiezometerDaeau piezometerDaeau;
    private final QualitometerDao qualitometerDao;
    private final UserStationDao userStationDao;
    private final StationLinkDao stationLinkDao;
    private final LogUtil logUtil;
    private final Reads<Tuple3<Object, String, String>> idUserModuleRead;
    private final Reads<Tuple2<String, String>> userModuleRead;
    private final Reads<Tuple4<Object, String, Option<Seq<ProductionUnitLink>>, Option<Seq<ProductionUnitLink>>>> associationUpdateRead;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        ProductionUnitController productionUnitController = this;
        synchronized (productionUnitController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Reads<Tuple3<Object, String, String>> idUserModuleRead() {
        return this.idUserModuleRead;
    }

    public Reads<Tuple2<String, String>> userModuleRead() {
        return this.userModuleRead;
    }

    public String getProductionUnits(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userModuleRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to get all production units :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            String module = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)module);
            String validateUser2 = (String)tuple22._1();
            String module2 = (String)tuple22._2();
            Seq allowStations = $this.userStationDao.getAvailableStation(validateUser2, StationTypeConstants$.MODULE$.TYPE_STATION_PRODUCTION(), module2);
            int n = allowStations.length();
            switch (n) {
                case 0: {
                    $this.logUtil.info(new StringBuilder(74).append("User ").append(validateUser2).append(" isn't allow to access production units with allowStation length to 0").toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ProductionUnitOutput$.MODULE$.productionUnitOutputOutputWrites())).toString();
                }
            }
            Option option = allowStations.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equals(StationTypeConstants$.MODULE$.FORBIDEN())));
            if (option instanceof Some) {
                $this.logUtil.info(new StringBuilder(46).append("User ").append(validateUser2).append(" isn't allow to access to production unit").toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ProductionUnitOutput$.MODULE$.productionUnitOutputOutputWrites())).toString();
            }
            Option option2 = allowStations.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equals(StationTypeConstants$.MODULE$.ALL())));
            if (option2 instanceof Some) {
                $this.logUtil.info(new StringBuilder(47).append("User ").append(validateUser2).append(" is allow to access to all production unit").toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)$this.productionUnitDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)ProductionUnit$.MODULE$.productionUnitFormat())).toString();
            }
            Seq ids = (Seq)allowStations.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))));
            $this.logUtil.info(new StringBuilder(68).append("User ").append(validateUser2).append(" is allow to access to specific production units with length : ").append(ids.length()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)$this.productionUnitDao.getAll((Option)new Some((Object)ids)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)ProductionUnit$.MODULE$.productionUnitFormat())).toString();
        });
    }

    public String getAllCodes(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.productionUnitDao.getAllCodes(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericStation$.MODULE$.genericStationFormat())).toString();
    }

    public String getProductionUnitWithId(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idUserModuleRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(30).append("Can't get distribution unit :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            int productionUnitId = BoxesRunTime.unboxToInt((Object)read._1());
            String validateUser = (String)read._2();
            String module = (String)read._3();
            Seq allowStations = $this.userStationDao.getAvailableStation(validateUser, StationTypeConstants$.MODULE$.TYPE_STATION_PRODUCTION(), module);
            int n = allowStations.length();
            switch (n) {
                case 0: {
                    $this.logUtil.info(new StringBuilder(85).append("User ").append(validateUser).append(" isn't allow to access to production unit with id ").append(productionUnitId).append(" with allowStation length to 0").toString(), $this.logUtil.info$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)403), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
            }
            Option option = allowStations.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equals(StationTypeConstants$.MODULE$.FORBIDEN())));
            if (option instanceof Some) {
                $this.logUtil.info(new StringBuilder(55).append("User ").append(validateUser).append(" isn't allow to access to production unit with id ").append(productionUnitId).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)403), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            Option option2 = allowStations.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equals(StationTypeConstants$.MODULE$.ALL())));
            if (option2 instanceof Some) {
                $this.logUtil.info(new StringBuilder(69).append("User ").append(validateUser).append(" is allow to access to all production unit with all access right").toString(), $this.logUtil.info$default$2());
                return this.getProductionUnit(productionUnitId);
            }
            boolean bl = allowStations.contains((Object)Integer.toString(productionUnitId));
            if (bl) {
                $this.logUtil.info(new StringBuilder(61).append("User ").append(validateUser).append(" is allow to access to specific production unit with id ").append(productionUnitId).toString(), $this.logUtil.info$default$2());
                return this.getProductionUnit(productionUnitId);
            }
            if (!bl) {
                $this.logUtil.info(new StringBuilder(88).append("User ").append(validateUser).append(" is not allow to access to specific production unit with id ").append(productionUnitId).append(" on allowStations table").toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)403), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        });
    }

    public String getProductionUnit(int id) {
        Option option = this.productionUnitDao.get(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            ProductionUnitOutput distributionUnit = (ProductionUnitOutput)some.value();
            return Json$.MODULE$.toJson((Object)distributionUnit, ProductionUnitOutput$.MODULE$.productionUnitOutputOutputWrites()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)option);
    }

    public String createProductionUnit(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)ProductionUnitInput$.MODULE$.productionUnitInputFormat()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(55).append("Can't validate productionUnit object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)productionUnitInput -> {
            Tuple2 tuple2 = $this.productionUnitDao.insert(productionUnitInput);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int result = tuple2._1$mcI$sp();
            int id = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(result, id);
            int result2 = sp2._1$mcI$sp();
            int id2 = sp2._2$mcI$sp();
            $this.userStationDao.addUserRightsCreation(Option$.MODULE$.apply((Object)user), id2, StationTypeConstants$.MODULE$.TYPE_STATION_PRODUCTION());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateProductionUnit(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)ProductionUnitInput$.MODULE$.productionUnitInputFormat()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(55).append("Can't validate productionUnit object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)productionUnitInput -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.productionUnitDao.update(productionUnitInput, (double)BoxesRunTime.unboxToInt((Object)productionUnitInput.id().get()))), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String deleteProductionUnit(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ProductionUnit$.MODULE$.idRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get id from json input.", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> ProductionUnitController.$anonfun$deleteProductionUnit$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String getProductionUnitAssociatedSite(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(28).append("Can't get production unit :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> ProductionUnitController.$anonfun$getProductionUnitAssociatedSite$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public Seq<String> getPiezometerCodes(Seq<String> allowStationCodes, String validateUser) {
        return (Seq)((IterableOps)allowStationCodes.map((Function1 & Serializable)o -> $this.piezometerDaeau.find(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(o))))).map((Function1 & Serializable)x$4 -> (String)((Piezometer)x$4.get()).name().get());
    }

    public Seq<String> getQualitometerCodes(Seq<String> allowStationCodes, String validateUser) {
        return (Seq)((IterableOps)allowStationCodes.map((Function1 & Serializable)o -> $this.qualitometerDao.get(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(o))))).map((Function1 & Serializable)x$5 -> (String)((Qualitometer)x$5.get()).name().get());
    }

    public Seq<String> emptyFunction(Seq<String> allowStationCodes, String validateUser) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<StationLink> getAllowLinkStation(Seq<StationLink> listOfLinkedStation, Seq<String> allowSiteCodes, String validateUser, Function2<Seq<String>, String, Seq<String>> getStationCodeFunction) {
        int n = allowSiteCodes.length();
        switch (n) {
            case 0: {
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        Option option = allowSiteCodes.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equals(StationTypeConstants$.MODULE$.FORBIDEN())));
        if (option instanceof Some) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        Option option2 = allowSiteCodes.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equals(StationTypeConstants$.MODULE$.ALL())));
        if (option2 instanceof Some) {
            return listOfLinkedStation;
        }
        Seq listOfCodes = (Seq)getStationCodeFunction.apply(allowSiteCodes, (Object)validateUser);
        return (Seq)listOfLinkedStation.filter((Function1 & Serializable)linkStation -> BoxesRunTime.boxToBoolean((boolean)listOfCodes.contains((Object)linkStation.stationLinkedCode())));
    }

    public String getProdUnitLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(31).append("Can't get production unit id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> ProductionUnitController.$anonfun$getProdUnitLinks$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public Reads<Tuple4<Object, String, Option<Seq<ProductionUnitLink>>, Option<Seq<ProductionUnitLink>>>> associationUpdateRead() {
        return this.associationUpdateRead;
    }

    public String updateProdUnitLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.associationUpdateRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(31).append("Can't get production unit id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple4 tuple4 = params;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            int id = BoxesRunTime.unboxToInt((Object)tuple4._1());
            String user = (String)tuple4._2();
            Option addedLinks = (Option)tuple4._3();
            Option deletedLinks = (Option)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)id), (Object)user, (Object)addedLinks, (Object)deletedLinks);
            int id2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
            String user2 = (String)tuple42._2();
            Option addedLinks2 = (Option)tuple42._3();
            Option deletedLinks2 = (Option)tuple42._4();
            return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)$this.productionUnitDao.updateProdUnitLinks(id2, user2, addedLinks2, deletedLinks2)), (Writes)Writes$.MODULE$.IntWrites()).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$deleteProductionUnit$2(ProductionUnitController $this, int id) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.productionUnitDao.delete(id)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getProductionUnitAssociatedSite$2(ProductionUnitController $this, int id) {
        Option option = $this.productionUnitDao.get(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            ProductionUnitOutput productionUnit = (ProductionUnitOutput)some.value();
            Seq seqOfLinkStation = $this.stationLinkDao.get((String)productionUnit.code().getOrElse((Function0 & Serializable)() -> ""), 5L);
            return Json$.MODULE$.toJson((Object)seqOfLinkStation, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationLinkDetailed$.MODULE$.format())).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$getProdUnitLinks$2(ProductionUnitController $this, int id) {
        return Json$.MODULE$.toJson((Object)$this.productionUnitDao.getProdUnitLinks(id), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PULinkWithData$.MODULE$.format())).toString();
    }

    @Inject
    public ProductionUnitController(ProductionUnitDao productionUnitDao, PluviometerDao pluviometerDao, InstallationDao installationDao, DistributionUnitDao distributionUnitDao, HydrologicalStationDao hydrologicalStationDao, PiezometerDaeau piezometerDaeau, QualitometerDao qualitometerDao, UserStationDao userStationDao, StationLinkDao stationLinkDao, LogUtil logUtil) {
        this.productionUnitDao = productionUnitDao;
        this.piezometerDaeau = piezometerDaeau;
        this.qualitometerDao = qualitometerDao;
        this.userStationDao = userStationDao;
        this.stationLinkDao = stationLinkDao;
        this.logUtil = logUtil;
        Producer.$init$((Producer)this);
        this.idUserModuleRead = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.userModuleRead = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.associationUpdateRead = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("addedLinks").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)ProductionUnitLink$.MODULE$.productionUnitFormat()))).and((Object)JsPath$.MODULE$.$bslash("deletedLinks").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)ProductionUnitLink$.MODULE$.productionUnitFormat()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

