/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import dao.itf.ProductionUnitEventDao;
import dao.rpc.dao.HydrometricDao;
import dao.rpc.dao.InstallationRPCDao;
import dao.rpc.dao.MailDao;
import dao.rpc.dao.PiezometerEventDao;
import dao.rpc.dao.QualitometerEventDao;
import domain.input.ProductionUnitEventInput;
import domain.input.ProductionUnitEventInput$;
import domain.output.ProductionUnitEventOutput;
import domain.output.ProductionUnitEventOutput$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.daeau.installation.itf.InstallationDao;
import fr.aquasys.daeau.installation.model.Installation;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.production_unit.domain.ProductionUnitEvent;
import fr.aquasys.daeau.production_unit.domain.ProductionUnitEvent$;
import fr.aquasys.daeau.production_unit.domain.output.ProductionUnitOutput;
import fr.aquasys.daeau.production_unit.itf.ProductionUnitDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.EventUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\f\u0019\u0001mA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!:\u0001\t\u0003\t9\u000fC\u0004\u0002r\u0002!\t!a=\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"9!\u0011\u0002\u0001\u0005\u0002\t-!!\b)s_\u0012,8\r^5p]Vs\u0017\u000e^#wK:$8i\u001c8ue>dG.\u001a:\u000b\u0003e\t1bY8oiJ|G\u000e\\3sg\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u0005A!/\u00192cSRl\u0017O\u0003\u0002*U\u00059\u0011-];bgf\u001c(\"A\u0016\u0002\u0005\u0019\u0014\u0018BA\u0017%\u0005!\u0001&o\u001c3vG\u0016\u0014\u0018A\u00069s_\u0012,8\r^5p]Vs\u0017\u000e^#wK:$H)Y8\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014aA5uM*\tA'A\u0002eC>L!AN\u0019\u0003-A\u0013x\u000eZ;di&|g.\u00168ji\u00163XM\u001c;EC>\f\u0011\u0003\u001d:pIV\u001cG/[8o+:LG\u000fR1p!\tIt(D\u0001;\u0015\t\u00114H\u0003\u0002={\u0005y\u0001O]8ek\u000e$\u0018n\u001c8`k:LGO\u0003\u0002?Q\u0005)A-Y3bk&\u0011\u0001I\u000f\u0002\u0012!J|G-^2uS>tWK\\5u\t\u0006|\u0017AD:uCRLwN\u001c'j].$\u0015m\u001c\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1b\u001d;bi&|g\u000e\\5oW*\u0011q\tS\u0001\u0006Y&t7n\u001d\u0006\u0003\u0013v\nqa\u001d;bi&|g.\u0003\u0002L\t\nq1\u000b^1uS>tG*\u001b8l\t\u0006|\u0017A\u00059jKj|W.\u001a;fe\u00163XM\u001c;EC>\u0004\"A\u0014*\u000e\u0003=S!\u0001\u000e)\u000b\u0005E\u001b\u0014a\u0001:qG&\u00111k\u0014\u0002\u0013!&,'p\\7fi\u0016\u0014XI^3oi\u0012\u000bw.\u0001\u000brk\u0006d\u0017\u000e^8nKR,'/\u0012<f]R$\u0015m\u001c\t\u0003\u001dZK!aV(\u0003)E+\u0018\r\\5u_6,G/\u001a:Fm\u0016tG\u000fR1p\u0003=\tX/\u00197ji>lW\r^3s\t\u0006|\u0007C\u0001._\u001b\u0005Y&B\u0001\u001a]\u0015\tiV(A\u0004rk\u0006d\u0017\u000e^=\n\u0005}[&aD)vC2LGo\\7fi\u0016\u0014H)Y8\u0002\u001d!LHM]8nKR\u0014\u0018n\u0019#b_B\u0011aJY\u0005\u0003G>\u0013a\u0002S=ee>lW\r\u001e:jG\u0012\u000bw.A\bis\u0012\u0014xn\u0015;bi&|g\u000eR1p!\t1'.D\u0001h\u0015\t\u0011\u0004N\u0003\u0002j{\u0005Q\u0001.\u001f3s_6,GO]=\n\u0005-<'A\u0006%zIJ|Gn\\4jG\u0006d7\u000b^1uS>tG)Y8\u0002%%t7\u000f^1mY\u0006$\u0018n\u001c8S!\u000e#\u0015m\u001c\t\u0003\u001d:L!a\\(\u0003%%s7\u000f^1mY\u0006$\u0018n\u001c8S!\u000e#\u0015m\\\u0001\u0010S:\u001cH/\u00197mCRLwN\u001c#b_B\u0011!O^\u0007\u0002g*\u0011!\u0007\u001e\u0006\u0003kv\nA\"\u001b8ti\u0006dG.\u0019;j_:L!a^:\u0003\u001f%s7\u000f^1mY\u0006$\u0018n\u001c8EC>\fq\u0002]5fu>lW\r^3s\t\u0006,\u0017-\u001e\t\u0003uzl\u0011a\u001f\u0006\u0003eqT!!`\u001f\u0002\u0015ALWM_8nKR\u0014\u00180\u0003\u0002\u0000w\ny\u0001+[3{_6,G/\u001a:EC\u0016\fW/A\u0004m_\u001e,F/\u001b7\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003'\u0003\u0011)H/\u001b7\n\t\u00055\u0011q\u0001\u0002\b\u0019><W\u000b^5m\u0003I\u0019\u0018.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\t\u0005M\u00111D\u0007\u0003\u0003+Q1AMA\f\u0015\r\tI\"P\u0001\u000fC\u0012l\u0017N\\5tiJ\fG/[8o\u0013\u0011\ti\"!\u0006\u0003%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\\\u0001\b[\u0006LG\u000eR1p!\rq\u00151E\u0005\u0004\u0003Ky%aB'bS2$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015=\u0005-\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u0003cAA\u0017\u00015\t\u0001\u0004C\u0003/\u001f\u0001\u0007q\u0006C\u00038\u001f\u0001\u0007\u0001\bC\u0003B\u001f\u0001\u0007!\tC\u0003M\u001f\u0001\u0007Q\nC\u0003U\u001f\u0001\u0007Q\u000bC\u0003Y\u001f\u0001\u0007\u0011\fC\u0003a\u001f\u0001\u0007\u0011\rC\u0003e\u001f\u0001\u0007Q\rC\u0003m\u001f\u0001\u0007Q\u000eC\u0003q\u001f\u0001\u0007\u0011\u000fC\u0003y\u001f\u0001\u0007\u0011\u0010C\u0004\u0002\u0002=\u0001\r!a\u0001\t\u000f\u0005=q\u00021\u0001\u0002\u0012!9\u0011qD\bA\u0002\u0005\u0005\u0002fA\b\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013AB5oU\u0016\u001cGO\u0003\u0002\u0002X\u0005)!.\u0019<bq&!\u00111LA)\u0005\u0019IeN[3di\u00069r-\u001a;Qe>$Wo\u0019;j_:,f.\u001b;Fm\u0016tGo\u001d\u000b\u000b\u0003C\n9(!%\u0002\"\u0006\u0015\u0006\u0003BA2\u0003crA!!\u001a\u0002nA\u0019\u0011q\r\u0010\u000e\u0005\u0005%$bAA65\u00051AH]8pizJ1!a\u001c\u001f\u0003\u0019\u0001&/\u001a3fM&!\u00111OA;\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u000e\u0010\t\u000f\u0005e\u0004\u00031\u0001\u0002|\u00059Q.Z:tC\u001e,\u0007\u0003BA?\u0003\u001bk!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0005UN|gN\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001\u00027jENT1!JAE\u0015\t\tY)\u0001\u0003qY\u0006L\u0018\u0002BAH\u0003\u007f\u0012qAS:WC2,X\rC\u0004\u0002\u0014B\u0001\r!!&\u0002\u000f!,\u0017\rZ3sgBA\u00111MAL\u0003C\nY*\u0003\u0003\u0002\u001a\u0006U$aA'baB\u0019Q$!(\n\u0007\u0005}eDA\u0002B]fDq!a)\u0011\u0001\u0004\t\t'\u0001\u0004n_\u0012,H.\u001a\u0005\b\u0003O\u0003\u0002\u0019AA1\u0003\u0011)8/\u001a:\u0002=\u001d,G/\u0012<f]R\u001chI]8n\u0003N\u001cxnY5bi\u0016$7\u000b^1uS>tG\u0003BAW\u0003\u001f\u0004b!a,\u0002:\u0006}f\u0002BAY\u0003ksA!a\u001a\u00024&\tq$C\u0002\u00028z\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0006u&aA*fc*\u0019\u0011q\u0017\u0010\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u00061q.\u001e;qkRT!!!3\u0002\r\u0011|W.Y5o\u0013\u0011\ti-a1\u00033A\u0013x\u000eZ;di&|g.\u00168ji\u00163XM\u001c;PkR\u0004X\u000f\u001e\u0005\b\u0003#\f\u0002\u0019AAj\u0003\u0011a\u0017N\\6\u0011\u0007\r\u000b).C\u0002\u0002X\u0012\u00131c\u0015;bi&|g\u000eT5oW\u0012+G/Y5mK\u0012\f\u0011$\u001b8tKJ$\bK]8ek\u000e$\u0018n\u001c8V]&$XI^3oiRQ\u0011\u0011MAo\u0003?\f\t/a9\t\u000f\u0005e$\u00031\u0001\u0002|!9\u00111\u0013\nA\u0002\u0005U\u0005bBAR%\u0001\u0007\u0011\u0011\r\u0005\b\u0003O\u0013\u0002\u0019AA1\u0003e)\b\u000fZ1uKB\u0013x\u000eZ;di&|g.\u00168ji\u00163XM\u001c;\u0015\u0015\u0005\u0005\u0014\u0011^Av\u0003[\fy\u000fC\u0004\u0002zM\u0001\r!a\u001f\t\u000f\u0005M5\u00031\u0001\u0002\u0016\"9\u00111U\nA\u0002\u0005\u0005\u0004bBAT'\u0001\u0007\u0011\u0011M\u0001\u0017O\u0016$\bK]8ek\u000e$\u0018n\u001c8V]&$XI^3oiRQ\u0011\u0011MA{\u0003o\fI0a?\t\u000f\u0005eD\u00031\u0001\u0002|!9\u00111\u0013\u000bA\u0002\u0005U\u0005bBAR)\u0001\u0007\u0011\u0011\r\u0005\b\u0003O#\u0002\u0019AA1\u0003e!W\r\\3uKB\u0013x\u000eZ;di&|g.\u00168ji\u00163XM\u001c;\u0015\u0015\u0005\u0005$\u0011\u0001B\u0002\u0005\u000b\u00119\u0001C\u0004\u0002zU\u0001\r!a\u001f\t\u000f\u0005MU\u00031\u0001\u0002\u0016\"9\u00111U\u000bA\u0002\u0005\u0005\u0004bBAT+\u0001\u0007\u0011\u0011M\u0001\u000bg\u0016tGMQ=NC&dGCCA1\u0005\u001b\u0011\tBa\u0005\u0003\u0016!9!q\u0002\fA\u0002\u0005m\u0014!\u0002<bYV,\u0007bBAJ-\u0001\u0007\u0011Q\u0013\u0005\b\u0003G3\u0002\u0019AA1\u0011\u001d\t9K\u0006a\u0001\u0003CB3\u0001\u0001B\r!\u0011\tyEa\u0007\n\t\tu\u0011\u0011\u000b\u0002\n'&tw\r\\3u_:\u0004")
public class ProductionUnitEventController
implements Producer {
    private final ProductionUnitEventDao productionUnitEventDao;
    private final ProductionUnitDao productionUnitDao;
    private final StationLinkDao stationLinkDao;
    private final PiezometerEventDao piezometerEventDao;
    private final QualitometerEventDao qualitometerEventDao;
    private final QualitometerDao qualitometerDao;
    private final HydrometricDao hydrometricDao;
    private final HydrologicalStationDao hydroStationDao;
    private final InstallationRPCDao installationRPCDao;
    private final InstallationDao installationDao;
    private final PiezometerDaeau piezometerDaeau;
    private final LogUtil logUtil;
    private final SieauParametersDao sieauParametersDao;
    private final MailDao mailDao;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        ProductionUnitEventController productionUnitEventController = this;
        synchronized (productionUnitEventController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public String getProductionUnitEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ProductionUnitEvent$.MODULE$.idUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(34).append("Can't get production Unit events:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String login = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)login);
            int id2 = tuple22._1$mcI$sp();
            String login2 = (String)tuple22._2();
            Option option = $this.productionUnitDao.get(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                ProductionUnitOutput productionUnit = (ProductionUnitOutput)some.value();
                Seq productionUnitEvents = (Seq)$this.productionUnitEventDao.getEventsByProductionUnit(id2).map((Function1 & Serializable)e -> ProductionUnitEventOutput$.MODULE$.toEventOutput((ProductionUnitEvent)e));
                Seq linkedStationEvents = (Seq)$this.stationLinkDao.get((String)productionUnit.code().getOrElse((Function0 & Serializable)() -> ""), 5L).flatMap((Function1 & Serializable)linkedStation -> this.getEventsFromAssociatedStation((StationLinkDetailed)linkedStation));
                return Json$.MODULE$.toJson(productionUnitEvents.$plus$plus((IterableOnce)linkedStationEvents), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ProductionUnitEventOutput$.MODULE$.eventWrites())).toString();
            }
            return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't find production Unit", ErrorUtil$.MODULE$.getJsonError$default$3());
        });
    }

    public Seq<ProductionUnitEventOutput> getEventsFromAssociatedStation(StationLinkDetailed link) {
        long l = link.stationLinkedType();
        if (1L == l) {
            int piezoId = ((Piezometer)this.piezometerDaeau.find(link.stationLinkedCode()).get()).id();
            return (Seq)this.piezometerEventDao.getEvents(piezoId).map((Function1 & Serializable)e -> ProductionUnitEventOutput$.MODULE$.toEventOutput((ProductionUnitEventOutput)e, "piezometry", (Option<StationLinkDetailed>)new Some((Object)link), piezoId));
        }
        if (3L == l) {
            int qualitoId = (int)((Qualitometer)this.qualitometerDao.get(link.stationLinkedCode()).get()).id();
            return (Seq)this.qualitometerEventDao.getEvents(qualitoId).map((Function1 & Serializable)e -> ProductionUnitEventOutput$.MODULE$.toEventOutput((ProductionUnitEventOutput)e, "quality", (Option<StationLinkDetailed>)new Some((Object)link), qualitoId));
        }
        if (4L == l) {
            int hydroId = (int)((HydroStation)this.hydroStationDao.get(link.stationLinkedCode()).get()).id();
            return (Seq)this.hydrometricDao.getEvents(hydroId).map((Function1 & Serializable)e -> ProductionUnitEventOutput$.MODULE$.toEventOutput((ProductionUnitEventOutput)e, "hydrometry", (Option<StationLinkDetailed>)new Some((Object)link), hydroId));
        }
        if (7L == l) {
            int instId = ((Installation)this.installationDao.get(link.stationLinkedCode()).get()).id();
            return (Seq)this.installationRPCDao.getEvents(instId).map((Function1 & Serializable)e -> ProductionUnitEventOutput$.MODULE$.toEventOutput((ProductionUnitEventOutput)e, "installation", (Option<StationLinkDetailed>)new Some((Object)link), instId));
        }
        return (Seq)Nil$.MODULE$;
    }

    public String insertProductionUnitEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ProductionUnitEventInput$.MODULE$.productionUnitEventCreateReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate event input", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)event -> {
            Tuple2<Object, Object> tuple2 = $this.productionUnitEventDao.insert((ProductionUnitEventInput)event);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int result = tuple2._1$mcI$sp();
            int id = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(result, id);
            int result2 = sp2._1$mcI$sp();
            int id2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateProductionUnitEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ProductionUnitEvent$.MODULE$.productionUnitEventUpdateReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProductionUnitEvent event = (ProductionUnitEvent)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)event, (Object)user);
            ProductionUnitEvent event2 = (ProductionUnitEvent)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.productionUnitEventDao.update(event2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getProductionUnitEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ProductionUnitEvent$.MODULE$.productionUnitEventReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get production Unit id or event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int productionUnitId = tuple2._1$mcI$sp();
            int eventId = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(productionUnitId, eventId);
            int productionUnitId2 = sp2._1$mcI$sp();
            int eventId2 = sp2._2$mcI$sp();
            return Json$.MODULE$.toJson($this.productionUnitEventDao.find(productionUnitId2, eventId2), Writes$.MODULE$.OptionWrites((Writes)ProductionUnitEvent$.MODULE$.installationEventWrites())).toString();
        });
    }

    public String deleteProductionUnitEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ProductionUnitEvent$.MODULE$.productionUnitEventReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get production Unit id or event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int productionUnitId = tuple2._1$mcI$sp();
            int eventId = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(productionUnitId, eventId);
            int productionUnitId2 = sp2._1$mcI$sp();
            int eventId2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.productionUnitEventDao.delete(productionUnitId2, eventId2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String sendByMail(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(EventUtil$.MODULE$.eventIdAndStationIdAndEmailRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to send Event by mail :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int eventId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int stationId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Seq emails = (Seq)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)eventId), (Object)BoxesRunTime.boxToInteger((int)stationId), (Object)emails);
            int eventId2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int stationId2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Seq emails2 = (Seq)tuple32._3();
            Option<ProductionUnitEvent> option = $this.productionUnitEventDao.find(stationId2, eventId2);
            if (option instanceof Some) {
                Some some = (Some)option;
                ProductionUnitEvent event = (ProductionUnitEvent)some.value();
                Option option2 = $this.productionUnitDao.get(stationId2);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    ProductionUnitOutput piezo = (ProductionUnitOutput)some2.value();
                    Seq parameters = $this.sieauParametersDao.getAll($this.sieauParametersDao.getAll$default$1(), $this.sieauParametersDao.getAll$default$2());
                    emails2.foreach((Function1 & Serializable)email -> {
                        this.mailDao.sendMail(email, event, piezo, (Seq<SieauParameters>)parameters);
                        return BoxedUnit.UNIT;
                    });
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                $this.logUtil.debug(new StringBuilder(33).append("Error production unit: ").append(stationId2).append(" not found").toString(), $this.logUtil.debug$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.debug(new StringBuilder(45).append("Error event: ").append(eventId2).append(" not found for production unit: ").append(stationId2).toString(), $this.logUtil.debug$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    @Inject
    public ProductionUnitEventController(ProductionUnitEventDao productionUnitEventDao, ProductionUnitDao productionUnitDao, StationLinkDao stationLinkDao, PiezometerEventDao piezometerEventDao, QualitometerEventDao qualitometerEventDao, QualitometerDao qualitometerDao, HydrometricDao hydrometricDao, HydrologicalStationDao hydroStationDao, InstallationRPCDao installationRPCDao, InstallationDao installationDao, PiezometerDaeau piezometerDaeau, LogUtil logUtil, SieauParametersDao sieauParametersDao, MailDao mailDao) {
        this.productionUnitEventDao = productionUnitEventDao;
        this.productionUnitDao = productionUnitDao;
        this.stationLinkDao = stationLinkDao;
        this.piezometerEventDao = piezometerEventDao;
        this.qualitometerEventDao = qualitometerEventDao;
        this.qualitometerDao = qualitometerDao;
        this.hydrometricDao = hydrometricDao;
        this.hydroStationDao = hydroStationDao;
        this.installationRPCDao = installationRPCDao;
        this.installationDao = installationDao;
        this.piezometerDaeau = piezometerDaeau;
        this.logUtil = logUtil;
        this.sieauParametersDao = sieauParametersDao;
        this.mailDao = mailDao;
        Producer.$init$((Producer)this);
    }
}

