/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.util.Random;
import play.core.Paths;
import play.mvc.Http;

public abstract class Call {
    private static Random rand = new Random();

    public abstract String url();

    public abstract String method();

    public abstract String fragment();

    public Call unique() {
        return new play.api.mvc.Call(this.method(), this.uniquify(this.url()), this.fragment());
    }

    protected final String uniquify(String string) {
        return string + (string.indexOf(63) == -1 ? "?" : "&") + rand.nextLong();
    }

    public Call withFragment(String string) {
        return new play.api.mvc.Call(this.method(), this.url(), string);
    }

    protected String appendFragment() {
        if (this.fragment() != null && !this.fragment().trim().isEmpty()) {
            return "#" + this.fragment();
        }
        return "";
    }

    public String absoluteURL(Http.Request request) {
        return this.absoluteURL(request.secure(), request.host());
    }

    public String absoluteURL(Http.Request request, boolean bl) {
        return this.absoluteURL(bl, request.host());
    }

    public String absoluteURL(boolean bl, String string) {
        return "http" + (bl ? "s" : "") + "://" + string + this.url() + this.appendFragment();
    }

    public String webSocketURL(Http.Request request) {
        return this.webSocketURL(request.secure(), request.host());
    }

    public String webSocketURL(Http.Request request, boolean bl) {
        return this.webSocketURL(bl, request.host());
    }

    public String webSocketURL(boolean bl, String string) {
        return "ws" + (bl ? "s" : "") + "://" + string + this.url();
    }

    public String relativeTo(Http.RequestHeader requestHeader) {
        return this.relativeTo(requestHeader.path());
    }

    public String relativeTo(String string) {
        return Paths.relative(string, this.url()) + this.appendFragment();
    }

    public String canonical() {
        return Paths.canonical(this.url()) + this.appendFragment();
    }

    public String path() {
        return this.url() + this.appendFragment();
    }

    public String toString() {
        return this.path();
    }
}

