/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.daeau.quality.domain.input.SearchIndicesInput;
import fr.aquasys.daeau.quality.domain.input.SearchIndicesInput$;
import fr.aquasys.daeau.quality.domain.output.SearchIndicesOutput$;
import fr.aquasys.daeau.quality.itf.IndicesDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Indice;
import fr.aquasys.daeau.quality.model.Indice$;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\b\u0010\u0001IA\u0001\"\n\u0001\u0003\u0002\u0003\u0006YA\n\u0005\t]\u0001\u0011\t\u0011)A\u0006_!AQ\u0007\u0001B\u0001B\u0003-a\u0007\u0003\u0005=\u0001\t\u0005\t\u0015a\u0003>\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\"!E%oI&\u001cWm]\"p]R\u0014x\u000e\u001c7fe*\t\u0001#A\u0006d_:$(o\u001c7mKJ\u001c8\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001bG5\t1D\u0003\u0002\u001d;\u0005\u0019\u0011\r]5\u000b\u0005yy\u0012\u0001\u0003:bE\nLG/\\9\u000b\u0005\u0001\n\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002E\u0005\u0011aM]\u0005\u0003Im\u0011\u0001\u0002\u0015:pIV\u001cWM]\u0001\u000bcV\fG.\u001b;z\t\u0006|\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u001d\tX/\u00197jifT!aK\u0010\u0002\u000b\u0011\fW-Y;\n\u00055B#AC)vC2LG/\u001f#b_\u00069An\\4Vi&d\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u001e\u0003\u0011)H/\u001b7\n\u0005Q\n$a\u0002'pOV#\u0018\u000e\\\u0001\u000bgR\fG/[8o\t\u0006|\u0007CA\u001c;\u001b\u0005A$BA\u001d)\u0003\rIGOZ\u0005\u0003wa\u0012q\"U;bY&$x.\\3uKJ$\u0015m\\\u0001\u000bS:$\u0017nY3t\t\u0006|\u0007CA\u001c?\u0013\ty\u0004H\u0001\u0006J]\u0012L7-Z:EC>\fa\u0001P5oSRtD#\u0001\"\u0015\u000b\r+ei\u0012%\u0011\u0005\u0011\u0003Q\"A\b\t\u000b\u0015*\u00019\u0001\u0014\t\u000b9*\u00019A\u0018\t\u000bU*\u00019\u0001\u001c\t\u000bq*\u00019A\u001f)\u0005\u0015Q\u0005CA&Q\u001b\u0005a%BA'O\u0003\u0019IgN[3di*\tq*A\u0004kC.\f'\u000f^1\n\u0005Ec%AB%oU\u0016\u001cG/\u0001\frk\u0006d\u0017\u000e^=J]\u0012L7-Z:SKN,\u0017M]2i)\u0015!v\f\u001c;w!\t)FL\u0004\u0002W5B\u0011q+F\u0007\u00021*\u0011\u0011,E\u0001\u0007yI|w\u000e\u001e \n\u0005m+\u0012A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW\u000b\t\u000b\u00014\u0001\u0019A1\u0002\u000f5,7o]1hKB\u0011!M[\u0007\u0002G*\u0011A-Z\u0001\u0005UN|gN\u0003\u0002gO\u0006!A.\u001b2t\u0015\ta\u0002NC\u0001j\u0003\u0011\u0001H.Y=\n\u0005-\u001c'a\u0002&t-\u0006dW/\u001a\u0005\u0006[\u001a\u0001\rA\\\u0001\bQ\u0016\fG-\u001a:t!\u0011)v\u000eV9\n\u0005At&aA'baB\u0011AC]\u0005\u0003gV\u00111!\u00118z\u0011\u0015)h\u00011\u0001U\u0003\u0019iw\u000eZ;mK\")qO\u0002a\u0001)\u0006!Qo]3s\u0003)9W\r^%oI&\u001cWm\u001d\u000b\u0006)j\\H0 \u0005\u0006A\u001e\u0001\r!\u0019\u0005\u0006[\u001e\u0001\rA\u001c\u0005\u0006k\u001e\u0001\r\u0001\u0016\u0005\u0006o\u001e\u0001\r\u0001V\u0001\u000ekB$\u0017\r^3J]\u0012L7-Z:\u0015\u0013Q\u000b\t!a\u0001\u0002\u0006\u0005\u001d\u0001\"\u00021\t\u0001\u0004\t\u0007\"B7\t\u0001\u0004q\u0007\"B;\t\u0001\u0004!\u0006\"B<\t\u0001\u0004!\u0016!D2sK\u0006$X-\u00138eS\u000e,7\u000fF\u0005U\u0003\u001b\ty!!\u0005\u0002\u0014!)\u0001-\u0003a\u0001C\")Q.\u0003a\u0001]\")Q/\u0003a\u0001)\")q/\u0003a\u0001)\u0006iA-\u001a7fi\u0016Le\u000eZ5dKN$\u0012\u0002VA\r\u00037\ti\"a\b\t\u000b\u0001T\u0001\u0019A1\t\u000b5T\u0001\u0019\u00018\t\u000bUT\u0001\u0019\u0001+\t\u000b]T\u0001\u0019\u0001+\u0002\u001d\u001d,G\u000fT1ti&sG-[2fgRIA+!\n\u0002(\u0005%\u00121\u0006\u0005\u0006A.\u0001\r!\u0019\u0005\u0006[.\u0001\rA\u001c\u0005\u0006k.\u0001\r\u0001\u0016\u0005\u0006o.\u0001\r\u0001V\u0001\u0013O\u0016$H*Y:u3\u0016\f'/\u00138eS\u000e,7\u000fF\u0005U\u0003c\t\u0019$!\u000e\u00028!)\u0001\r\u0004a\u0001C\")Q\u000e\u0004a\u0001]\")Q\u000f\u0004a\u0001)\")q\u000f\u0004a\u0001)\u0006aq-\u001a;BY2Le\u000eZ5dKRIA+!\u0010\u0002@\u0005\u0005\u00131\t\u0005\u0006A6\u0001\r!\u0019\u0005\u0006[6\u0001\rA\u001c\u0005\u0006k6\u0001\r\u0001\u0016\u0005\u0006o6\u0001\r\u0001\u0016\u0015\u0004\u0001\u0005\u001d\u0003cA&\u0002J%\u0019\u00111\n'\u0003\u0013MKgn\u001a7fi>t\u0007")
public class IndicesController
implements Producer {
    private final QualityDao qualityDao;
    private final LogUtil logUtil;
    private final QualitometerDao stationDao;
    private final IndicesDao indicesDao;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        IndicesController indicesController = this;
        synchronized (indicesController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public String qualityIndicesResearch(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)SearchIndicesInput$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get search parameters :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)criterias -> {
            if (criterias.qualitometer().isDefined()) {
                Seq qualitometers = (Seq)$this.stationDao.getAll(criterias.user()).filter((Function1 & Serializable)q -> BoxesRunTime.boxToBoolean((boolean)IndicesController.$anonfun$qualityIndicesResearch$3(criterias, q)));
                return Json$.MODULE$.toJson((Object)$this.indicesDao.searchIndices(criterias, qualitometers), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SearchIndicesOutput$.MODULE$.writes())).toString();
            }
            Seq qualitometers = (Seq)$this.stationDao.getAll(criterias.user()).filter((Function1 & Serializable)q -> BoxesRunTime.boxToBoolean((boolean)IndicesController.$anonfun$qualityIndicesResearch$4(criterias, q)));
            return Json$.MODULE$.toJson((Object)$this.indicesDao.searchIndices(criterias, qualitometers), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SearchIndicesOutput$.MODULE$.writes())).toString();
        });
    }

    public String getIndices(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Indice$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(37).append("Error validate Json to get indices :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int qualitometerId = tuple2._1$mcI$sp();
            double operationId = tuple2._2$mcD$sp();
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(qualitometerId, operationId);
            int qualitometerId2 = sp2._1$mcI$sp();
            double operationId2 = sp2._2$mcD$sp();
            return Json$.MODULE$.toJson((Object)$this.indicesDao.getOperationIndices((double)qualitometerId2, operationId2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Indice$.MODULE$.format())).toString();
        });
    }

    public String updateIndices(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Indice$.MODULE$.indicesReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(37).append("Error validate Json to get indices :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Indice indice = (Indice)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indice, (Object)user);
            Indice indice2 = (Indice)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.indicesDao.updateOperationIndice(indice2, user2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String createIndices(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Indice$.MODULE$.indicesReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(37).append("Error validate Json to get indices :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Indice indice = (Indice)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indice, (Object)user);
            Indice indice2 = (Indice)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.indicesDao.insertOperationIndice(indice2, user2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteIndices(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Indice$.MODULE$.indicesReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(37).append("Error validate Json to get indices :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Indice indice = (Indice)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indice, (Object)user);
            Indice indice2 = (Indice)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.indicesDao.deleteOperationIndice(indice2, user2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getLastIndices(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate Json to get last indice :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)criterias -> Json$.MODULE$.toJson((Object)$this.indicesDao.getLastIndices(criterias), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Indice$.MODULE$.format())).toString());
    }

    public String getLastYearIndices(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate Json to get last year indice :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)criterias -> Json$.MODULE$.toJson((Object)$this.indicesDao.getLastYearIndices(criterias), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Indice$.MODULE$.format())).toString());
    }

    public String getAllIndice(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllIndice(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString());
    }

    public static final /* synthetic */ boolean $anonfun$qualityIndicesResearch$3(SearchIndicesInput criterias$1, Qualitometer q) {
        return criterias$1.qualitometer().contains((Object)q.code());
    }

    public static final /* synthetic */ boolean $anonfun$qualityIndicesResearch$4(SearchIndicesInput criterias$1, Qualitometer q) {
        return criterias$1.stations().contains((Object)q.code());
    }

    @Inject
    public IndicesController(QualityDao qualityDao, LogUtil logUtil, QualitometerDao stationDao, IndicesDao indicesDao) {
        this.qualityDao = qualityDao;
        this.logUtil = logUtil;
        this.stationDao = stationDao;
        this.indicesDao = indicesDao;
        Producer.$init$((Producer)this);
    }
}

