/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import domain.QualitometerSituation;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.joda.time.base.AbstractDateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005y4A\u0001C\u0005\u0001\u0019!A1\u0003\u0001B\u0001B\u0003-A\u0003\u0003\u0005!\u0001\t\u0005\t\u0015a\u0003\"\u0011!I\u0003A!A!\u0002\u0017Q\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004bB\"\u0001\u0005\u0004%\u0019\u0001\u0012\u0005\u0007W\u0002\u0001\u000b\u0011B#\t\u000b1\u0004A\u0011A7\u00035E+\u0018\r\\5usNKG/^1uS>t7i\u001c8ue>dG.\u001a:\u000b\u0003)\t1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\u0006Q\u0011+^1mSRLH)Y8\u0011\u0005UqR\"\u0001\f\u000b\u0005]A\u0012aB9vC2LG/\u001f\u0006\u00033i\tQ\u0001Z1fCVT!a\u0007\u000f\u0002\u000f\u0005\fX/Y:zg*\tQ$\u0001\u0002ge&\u0011qD\u0006\u0002\u000b#V\fG.\u001b;z\t\u0006|\u0017AD+tKJ\u001cF/\u0019;j_:$\u0015m\u001c\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\n1!\u001b;g\u0015\t1\u0003$\u0001\u0003vg\u0016\u0014\u0018B\u0001\u0015$\u00059)6/\u001a:Ti\u0006$\u0018n\u001c8EC>\fq\u0001\\8h+RLG\u000e\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!Q\u000f^5m\u0015\ty#$\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0013\t\tDFA\u0004M_\u001e,F/\u001b7\u0002\rqJg.\u001b;?)\u0005!D\u0003B\u001b8qe\u0002\"A\u000e\u0001\u000e\u0003%AQa\u0005\u0003A\u0004QAQ\u0001\t\u0003A\u0004\u0005BQ!\u000b\u0003A\u0004)B#\u0001B\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014AB5oU\u0016\u001cGOC\u0001A\u0003\u001dQ\u0017m[1si\u0006L!AQ\u001f\u0003\r%s'.Z2u\u00035\u0019\u0018\u000e^;bi&|gNU3bIV\tQ\tE\u0002G\u001fFk\u0011a\u0012\u0006\u0003\u0011&\u000bAA[:p]*\u0011!jS\u0001\u0005Y&\u00147O\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00039\u000bA\u0001\u001d7bs&\u0011\u0001k\u0012\u0002\u0006%\u0016\fGm\u001d\t\u0006\u001dI#6mY\u0005\u0003'>\u0011a\u0001V;qY\u0016\u001c\u0004cA+^A:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033.\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0005q{\u0011a\u00029bG.\fw-Z\u0005\u0003=~\u00131aU3r\u0015\tav\u0002\u0005\u0002\u000fC&\u0011!m\u0004\u0002\u0007\t>,(\r\\3\u0011\u0005\u0011DgBA3g!\t9v\"\u0003\u0002h\u001f\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t9w\"\u0001\btSR,\u0018\r^5p]J+\u0017\r\u001a\u0011\u00021\u001d,G/U;bY&$x.\\3uKJ\u001c\u0016\u000e^;bi&|g\u000eF\u0003d]N\\X\u0010C\u0003p\u000f\u0001\u0007\u0001/A\u0004nKN\u001c\u0018mZ3\u0011\u0005\u0019\u000b\u0018B\u0001:H\u0005\u001dQ5OV1mk\u0016DQ\u0001^\u0004A\u0002U\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003em\u000eD\u0018BA<k\u0005\ri\u0015\r\u001d\t\u0003\u001deL!A_\b\u0003\u0007\u0005s\u0017\u0010C\u0003}\u000f\u0001\u00071-\u0001\u0004n_\u0012,H.\u001a\u0005\u0006M\u001d\u0001\ra\u0019")
public class QualitySituationController {
    private final QualityDao QualityDao;
    private final UserStationDao UserStationDao;
    private final LogUtil logUtil;
    private final Reads<Tuple3<Seq<Object>, String, String>> situationRead;

    public Reads<Tuple3<Seq<Object>, String, String>> situationRead() {
        return this.situationRead;
    }

    public String getQualitometerSituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.situationRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get qualitometer id", 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Seq ids = (Seq)tuple3._1();
            String user = (String)tuple3._2();
            String module = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)ids, (Object)user, (Object)module);
            Seq ids2 = (Seq)tuple32._1();
            String user2 = (String)tuple32._2();
            String module2 = (String)tuple32._3();
            Seq authorizedIds = CommonReadUtil$.MODULE$.getAllowedQualitometerIds(user2, ids2, module2, $this.UserStationDao);
            Seq operationsDates = $this.QualityDao.getSituation(authorizedIds);
            Map groupedQualitos = operationsDates.groupBy((Function1 & Serializable)couple -> BoxesRunTime.boxToDouble((double)couple._1$mcD$sp()));
            Seq finalData = (Seq)groupedQualitos.values().toSeq().map((Function1 & Serializable)list -> {
                double qualitoId = ((Tuple2)list.head())._1$mcD$sp();
                Seq yearCount = (Seq)((IterableOps)list.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)QualitySituationController.$anonfun$getQualitometerSituation$5(x$2)))).groupBy((Function1)(JFunction1.mcII.sp & Serializable)year -> year).toSeq().map((Function1 & Serializable)couple -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{couple._1$mcI$sp(), ((SeqOps)couple._2()).length()})));
                return new QualitometerSituation(qualitoId, (Seq<Seq<Object>>)yearCount);
            });
            return new StringBuilder(2).append("[").append(((IterableOnceOps)finalData.map((Function1 & Serializable)p -> p.toStringLight())).mkString(",")).append("]").toString();
        });
    }

    public static final /* synthetic */ int $anonfun$getQualitometerSituation$5(Tuple2 x$2) {
        return ((AbstractDateTime)x$2._2()).getYear();
    }

    @Inject
    public QualitySituationController(QualityDao QualityDao2, UserStationDao UserStationDao2, LogUtil logUtil) {
        this.QualityDao = QualityDao2;
        this.UserStationDao = UserStationDao2;
        this.logUtil = logUtil;
        this.situationRead = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.DoubleReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

