/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import dao.itf.SelectionDao;
import domain.SelectionWithRights;
import domain.SelectionWithRights$;
import domain.input.SelectionUpdateInput;
import domain.input.SelectionUpdateInput$;
import domain.output.SelectionParameterOutput;
import domain.output.SelectionParameterOutput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import model.Selection$;
import model.SelectionParameter$;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import utils.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0005\u000b\u00015A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006Y!\u0006\u0005\t;\u0001\u0011\t\u0011)A\u0006=!)!\u0006\u0001C\u0001W!9!\b\u0001b\u0001\n\u0003Y\u0004B\u0002/\u0001A\u0003%A\bC\u0003^\u0001\u0011\u0005a\fC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003w\u0001\u0011\u0005qOA\nTK2,7\r^5p]\u000e{g\u000e\u001e:pY2,'OC\u0001\f\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u0019M,G.Z2uS>tG)Y8\u0011\u0005YYR\"A\f\u000b\u0005aI\u0012aA5uM*\t!$A\u0002eC>L!\u0001H\f\u0003\u0019M+G.Z2uS>tG)Y8\u0002\u000f1|w-\u0016;jYB\u0011q\u0004K\u0007\u0002A)\u0011\u0011EI\u0001\u0005kRLGN\u0003\u0002$I\u0005A!/\u00192cSRl\u0017O\u0003\u0002&M\u00059\u0011-];bgf\u001c(\"A\u0014\u0002\u0005\u0019\u0014\u0018BA\u0015!\u0005\u001daunZ+uS2\fa\u0001P5oSRtD#\u0001\u0017\u0015\u00075z\u0003\u0007\u0005\u0002/\u00015\t!\u0002C\u0003\u0015\u0007\u0001\u000fQ\u0003C\u0003\u001e\u0007\u0001\u000fa\u0004\u000b\u0002\u0004eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0007S:TWm\u0019;\u000b\u0003]\nqA[1lCJ$\u0018-\u0003\u0002:i\t1\u0011J\u001c6fGR\fq\u0002^=qK\u0006sG-V:feJ+\u0017\rZ\u000b\u0002yA\u0019QH\u0012%\u000e\u0003yR!a\u0010!\u0002\t)\u001cxN\u001c\u0006\u0003\u0003\n\u000bA\u0001\\5cg*\u00111\tR\u0001\u0004CBL'\"A#\u0002\tAd\u0017-_\u0005\u0003\u000fz\u0012QAU3bIN\u0004BaD%L#&\u0011!\n\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007=ae*\u0003\u0002N!\t1q\n\u001d;j_:\u0004\"aD(\n\u0005A\u0003\"A\u0002#pk\ndW\r\u0005\u0002S3:\u00111k\u0016\t\u0003)Bi\u0011!\u0016\u0006\u0003-2\ta\u0001\u0010:p_Rt\u0014B\u0001-\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u0003\u0012\u0001\u0005;za\u0016\fe\u000eZ+tKJ\u0014V-\u00193!\u000359W\r^*fY\u0016\u001cG/[8ogR)\u0011k\u00183m]\")\u0001M\u0002a\u0001C\u00069Q.Z:tC\u001e,\u0007CA\u001fc\u0013\t\u0019gHA\u0004KgZ\u000bG.^3\t\u000b\u00154\u0001\u0019\u00014\u0002\u000f!,\u0017\rZ3sgB!!kZ)j\u0013\tA7LA\u0002NCB\u0004\"a\u00046\n\u0005-\u0004\"aA!os\")QN\u0002a\u0001#\u00061Qn\u001c3vY\u0016DQa\u001c\u0004A\u0002E\u000bA!^:fe\u0006)r-\u001a;TK2,7\r^5p]B\u000b'/Y7fi\u0016\u0014H#B)sgR,\b\"\u00021\b\u0001\u0004\t\u0007\"B3\b\u0001\u00041\u0007\"B7\b\u0001\u0004\t\u0006\"B8\b\u0001\u0004\t\u0016\u0001E;qI\u0006$XmU3mK\u000e$\u0018n\u001c8t)\u0015\t\u00060\u001f>|\u0011\u0015\u0001\u0007\u00021\u0001b\u0011\u0015)\u0007\u00021\u0001g\u0011\u0015i\u0007\u00021\u0001R\u0011\u0015y\u0007\u00021\u0001RQ\t\u0001Q\u0010\u0005\u00024}&\u0011q\u0010\u000e\u0002\n'&tw\r\\3u_:\u0004")
public class SelectionController {
    private final SelectionDao selectionDao;
    private final LogUtil logUtil;
    private final Reads<Tuple2<Option<Object>, String>> typeAndUserRead;

    public Reads<Tuple2<Option<Object>, String>> typeAndUserRead() {
        return this.typeAndUserRead;
    }

    public String getSelections(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.typeAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(32).append("Can't get selection with type :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option typeList = (Option)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)typeList, (Object)user);
            Option typeList2 = (Option)tuple22._1();
            String user2 = (String)tuple22._2();
            Option option = typeList2;
            if (option instanceof Some) {
                Some some = (Some)option;
                double list = BoxesRunTime.unboxToDouble((Object)some.value());
                Seq<SelectionWithRights> seq = $this.selectionDao.get(list, user2);
                return Json$.MODULE$.toJson(seq, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), SelectionWithRights$.MODULE$.writes())).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.toJson($this.selectionDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Selection$.MODULE$.writes())).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getSelectionParameter(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SelectionParameter$.MODULE$.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Can't get parameter in selection :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> {
            Seq<SelectionParameterOutput> seq = $this.selectionDao.getSelectionParameters((String)code);
            return Json$.MODULE$.toJson(seq, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), SelectionParameterOutput$.MODULE$.writes())).toString();
        });
    }

    public String updateSelections(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(SelectionUpdateInput$.MODULE$.inputReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate selection updates from json input", 400), (Function1 & Serializable)input -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.selectionDao.updateSelections((Seq<SelectionUpdateInput>)input)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    @Inject
    public SelectionController(SelectionDao selectionDao, LogUtil logUtil) {
        this.selectionDao = selectionDao;
        this.logUtil = logUtil;
        this.typeAndUserRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("type").readNullable((Reads)Reads$.MODULE$.DoubleReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

