/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.daeau.quality.domain.SearchTaxonsResult$;
import fr.aquasys.daeau.quality.domain.input.SearchTaxonsInput$;
import fr.aquasys.daeau.quality.itf.TaxonsDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StringUtil$;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function4;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005Y4Aa\u0002\u0005\u0001\u0017!Aa\u0004\u0001B\u0001B\u0003-q\u0004\u0003\u0005(\u0001\t\u0005\t\u0015a\u0003)\u0011!q\u0003A!A!\u0002\u0017y\u0003\"B\u001b\u0001\t\u00031\u0004\"\u0002$\u0001\t\u00039\u0005\"\u00027\u0001\t\u0003i'\u0001\u0005+bq>t7oQ8oiJ|G\u000e\\3s\u0015\u0005I\u0011aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u001d\u001b\u0005!\"BA\u000b\u0017\u0003\r\t\u0007/\u001b\u0006\u0003/a\t\u0001B]1cE&$X.\u001d\u0006\u00033i\tq!Y9vCNL8OC\u0001\u001c\u0003\t1'/\u0003\u0002\u001e)\tA\u0001K]8ek\u000e,'/\u0001\u0006rk\u0006d\u0017\u000e^=EC>\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u000fE,\u0018\r\\5us*\u0011A\u0005G\u0001\u0006I\u0006,\u0017-^\u0005\u0003M\u0005\u0012!\"U;bY&$\u0018\u0010R1p\u0003\u001dawnZ+uS2\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\f\u0002\tU$\u0018\u000e\\\u0005\u0003[)\u0012q\u0001T8h+RLG.A\u0005uCb|gn\u001d#b_B\u0011\u0001gM\u0007\u0002c)\u0011!'I\u0001\u0004SR4\u0017B\u0001\u001b2\u0005%!\u0016\r_8og\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0002oQ!\u0001HO\u001e=!\tI\u0004!D\u0001\t\u0011\u0015qB\u0001q\u0001 \u0011\u00159C\u0001q\u0001)\u0011\u0015qC\u0001q\u00010Q\t!a\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u00061\u0011N\u001c6fGRT\u0011aQ\u0001\bU\u0006\\\u0017M\u001d;b\u0013\t)\u0005I\u0001\u0004J]*,7\r^\u0001\u0016cV\fG.\u001b;z)\u0006DxN\\:SKN,\u0017M]2i)\u0015A5\u000b\u00195k!\tI\u0005K\u0004\u0002K\u001dB\u00111JD\u0007\u0002\u0019*\u0011QJC\u0001\u0007yI|w\u000e\u001e \n\u0005=s\u0011A\u0002)sK\u0012,g-\u0003\u0002R%\n11\u000b\u001e:j]\u001eT!a\u0014\b\t\u000bQ+\u0001\u0019A+\u0002\u000f5,7o]1hKB\u0011aKX\u0007\u0002/*\u0011\u0001,W\u0001\u0005UN|gN\u0003\u0002[7\u0006!A.\u001b2t\u0015\t)BLC\u0001^\u0003\u0011\u0001H.Y=\n\u0005};&a\u0002&t-\u0006dW/\u001a\u0005\u0006C\u0016\u0001\rAY\u0001\bQ\u0016\fG-\u001a:t!\u0011I5\rS3\n\u0005\u0011\u0014&aA'baB\u0011QBZ\u0005\u0003O:\u00111!\u00118z\u0011\u0015IW\u00011\u0001I\u0003\u0019iw\u000eZ;mK\")1.\u0002a\u0001\u0011\u0006!Qo]3s\u0003-9W\r^!mYR\u000b\u0007p\u001c8\u0015\u000b!sw\u000e]9\t\u000bQ3\u0001\u0019A+\t\u000b\u00054\u0001\u0019\u00012\t\u000b%4\u0001\u0019\u0001%\t\u000b-4\u0001\u0019\u0001%)\u0005\u0001\u0019\bCA u\u0013\t)\bIA\u0005TS:<G.\u001a;p]\u0002")
public class TaxonsController
implements Producer {
    private final QualityDao qualityDao;
    private final LogUtil logUtil;
    private final TaxonsDao taxonsDao;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        TaxonsController taxonsController = this;
        synchronized (taxonsController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public String qualityTaxonsResearch(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)SearchTaxonsInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get search parameters :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)criterias -> {
            if (criterias.ultraLightMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.taxonsDao.searchTaxonsUltraLight(criterias).map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
            }
            if (criterias.lightMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.taxonsDao.searchTaxonsLight(criterias).map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
            }
            return Json$.MODULE$.toJson((Object)$this.taxonsDao.searchTaxons(criterias), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SearchTaxonsResult$.MODULE$.format())).toString();
        });
    }

    public String getAllTaxon(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllTaxon(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString());
    }

    @Inject
    public TaxonsController(QualityDao qualityDao, LogUtil logUtil, TaxonsDao taxonsDao) {
        this.qualityDao = qualityDao;
        this.logUtil = logUtil;
        this.taxonsDao = taxonsDao;
        Producer.$init$((Producer)this);
    }
}

