/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import domain.output.ParameterThresholdOutput$;
import fr.aquasys.daeau.quality.threshold.ParameterThreshold;
import fr.aquasys.daeau.quality.threshold.ParameterThreshold$;
import fr.aquasys.daeau.quality.threshold.Threshold;
import fr.aquasys.daeau.quality.threshold.Threshold$;
import fr.aquasys.daeau.quality.threshold.ThresholdDao;
import fr.aquasys.daeau.quality.threshold.ThresholdUpdateInput$;
import fr.aquasys.daeau.quality.threshold.ThresholdWithRights$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import utils.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005}4A!\u0003\u0006\u0001\u001b!AA\u0003\u0001B\u0001B\u0003-Q\u0003\u0003\u0005$\u0001\t\u0005\t\u0015a\u0003%\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015)\b\u0001\"\u0001w\u0005M!\u0006N]3tQ>dGmQ8oiJ|G\u000e\\3s\u0015\u0005Y\u0011aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fA\u0002\u001e5sKNDw\u000e\u001c3EC>\u0004\"AF\u0011\u000e\u0003]Q!\u0001G\r\u0002\u0013QD'/Z:i_2$'B\u0001\u000e\u001c\u0003\u001d\tX/\u00197jifT!\u0001H\u000f\u0002\u000b\u0011\fW-Y;\u000b\u0005yy\u0012aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002A\u0005\u0011aM]\u0005\u0003E]\u0011A\u0002\u00165sKNDw\u000e\u001c3EC>\fq\u0001\\8h+RLG\u000e\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!Q\u000f^5m\u0015\tIS$\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0013\tYcEA\u0004M_\u001e,F/\u001b7\u0002\rqJg.\u001b;?)\u0005qCcA\u00182eA\u0011\u0001\u0007A\u0007\u0002\u0015!)Ac\u0001a\u0002+!)1e\u0001a\u0002I!\u00121\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\na!\u001b8kK\u000e$(\"A\u001d\u0002\u000f)\f7.\u0019:uC&\u00111H\u000e\u0002\u0007\u0013:TWm\u0019;\u0002\u0019\u001d,G\u000f\u00165sKNDw\u000e\u001c3\u0015\u000byJukX1\u0011\u0005}2eB\u0001!E!\t\t\u0005#D\u0001C\u0015\t\u0019E\"\u0001\u0004=e>|GOP\u0005\u0003\u000bB\ta\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011Q\t\u0005\u0005\u0006\u0015\u0012\u0001\raS\u0001\b[\u0016\u001c8/Y4f!\taU+D\u0001N\u0015\tqu*\u0001\u0003kg>t'B\u0001)R\u0003\u0011a\u0017NY:\u000b\u0005I\u001b\u0016aA1qS*\tA+\u0001\u0003qY\u0006L\u0018B\u0001,N\u0005\u001dQ5OV1mk\u0016DQ\u0001\u0017\u0003A\u0002e\u000bq\u0001[3bI\u0016\u00148\u000f\u0005\u0003@5zb\u0016BA.I\u0005\ri\u0015\r\u001d\t\u0003\u001fuK!A\u0018\t\u0003\u0007\u0005s\u0017\u0010C\u0003a\t\u0001\u0007a(\u0001\u0004n_\u0012,H.\u001a\u0005\u0006E\u0012\u0001\rAP\u0001\u0005kN,'/A\u0002hKR$RAP3gO\"DQAS\u0003A\u0002-CQ\u0001W\u0003A\u0002eCQ\u0001Y\u0003A\u0002yBQAY\u0003A\u0002y\nQcZ3u!\u0006\u0014\u0018-\\3uKJ$\u0006N]3tQ>dG\rF\u0003?W2lg\u000eC\u0003K\r\u0001\u00071\nC\u0003Y\r\u0001\u0007\u0011\fC\u0003a\r\u0001\u0007a\bC\u0003c\r\u0001\u0007a(A\bva\u0012\fG/\u001a+ie\u0016\u001c\bn\u001c7e)\u0015q\u0014O]:u\u0011\u0015Qu\u00011\u0001L\u0011\u0015Av\u00011\u0001Z\u0011\u0015\u0001w\u00011\u0001?\u0011\u0015\u0011w\u00011\u0001?\u0003A)\b\u000fZ1uKRC'/Z:i_2$7\u000fF\u0003?obL(\u0010C\u0003K\u0011\u0001\u00071\nC\u0003Y\u0011\u0001\u0007\u0011\fC\u0003a\u0011\u0001\u0007a\bC\u0003c\u0011\u0001\u0007a\b\u000b\u0002\u0001yB\u0011Q'`\u0005\u0003}Z\u0012\u0011bU5oO2,Go\u001c8")
public class ThresholdController {
    private final ThresholdDao thresholdDao;
    private final LogUtil logUtil;

    public String getThreshold(JsValue message, Map<String, Object> headers, String module, String user2) {
        return (String)message.validate(CommonReadUtil$.MODULE$.userReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)user -> Json$.MODULE$.toJson((Object)$this.thresholdDao.getAll(user), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ThresholdWithRights$.MODULE$.writes())).toString());
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ParameterThreshold$.MODULE$.thresholdIdTypeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(30).append("Can't get quality threshold :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int code = tuple2._1$mcI$sp();
            String thresholdType = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)code), (Object)thresholdType);
            int code2 = tuple22._1$mcI$sp();
            String thresholdType2 = (String)tuple22._2();
            return Json$.MODULE$.toJson((Object)$this.thresholdDao.get(Predef$.MODULE$.int2Integer(code2), (Option)new Some((Object)thresholdType2)), Writes$.MODULE$.OptionWrites((Writes)Threshold$.MODULE$.writes())).toString();
        });
    }

    public String getParameterThreshold(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ParameterThreshold$.MODULE$.thresholdIdTypeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(30).append("Can't get quality threshold :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String thresholdType = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)thresholdType);
            int id2 = tuple22._1$mcI$sp();
            String thresholdType2 = (String)tuple22._2();
            Seq thresholdParameters = (Seq)$this.thresholdDao.findParameterThresholds(id2, (Option)new Some((Object)thresholdType2)).map((Function1 & Serializable)p -> ParameterThresholdOutput$.MODULE$.toParameterThresholdOutput((ParameterThreshold)p, ParameterThresholdOutput$.MODULE$.toParameterThresholdOutput$default$2()));
            return Json$.MODULE$.toJson((Object)thresholdParameters, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ParameterThresholdOutput$.MODULE$.format())).toString();
        });
    }

    public String updateThreshold(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Threshold$.MODULE$.thresholdRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Threshold threshold = (Threshold)jsSuccess.get();
            Option option = this.thresholdDao.get(Predef$.MODULE$.int2Integer(threshold.code()), this.thresholdDao.get$default$2());
            if (option instanceof Some) {
                int n = this.thresholdDao.updateThreshold(threshold);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String updateThresholds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ThresholdUpdateInput$.MODULE$.inputReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate threshold updates from json input", 400), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq input = (Seq)tuple2._1();
            String login = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)input, (Object)login);
            Seq input2 = (Seq)tuple22._1();
            String login2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.thresholdDao.updateThresholds(input2, login2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    @Inject
    public ThresholdController(ThresholdDao thresholdDao, LogUtil logUtil) {
        this.thresholdDao = thresholdDao;
        this.logUtil = logUtil;
    }
}

