/*
 * Decompiled with CFR 0.152.
 */
package controllers.analysis;

import controllers.analysis.input.ParameterInput$;
import controllers.analysis.output.IndicatorResultOutput$;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.quality.chronicAnalysis.Analysis;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityAnalysis;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityAnalysis$;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.DateTimeFormatUtil$;
import fr.aquasys.utils.StringUtil$;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006Y\u0001\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0006k!AQ\b\u0001B\u0001B\u0003-a\bC\u0003G\u0001\u0011\u0005q\tC\u0003X\u0001\u0011\u0005\u0001\fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u0013\u0005M\u0001A1A\u0005\u0002\u0005U\u0001\u0002CA\u0018\u0001\u0001\u0006I!a\u0006\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!I\u0011Q\b\u0001C\u0002\u0013\u0005\u0011q\b\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002B!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011%\ti\b\u0001b\u0001\n\u0003\ty\b\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAA\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\u0011!#\u00118bYf\u001c\u0018n]\"p]R\u0014x\u000e\u001c7fe*\u0011A$H\u0001\tC:\fG._:jg*\ta$A\u0006d_:$(o\u001c7mKJ\u001c8\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017AC9vC2LG/\u001f#b_B\u0011\u0011FM\u0007\u0002U)\u00111\u0006L\u0001\bcV\fG.\u001b;z\u0015\tic&A\u0003eC\u0016\fWO\u0003\u00020a\u00059\u0011-];bgf\u001c(\"A\u0019\u0002\u0005\u0019\u0014\u0018BA\u001a+\u0005)\tV/\u00197jif$\u0015m\\\u0001\bY><W\u000b^5m!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003vi&d'B\u0001\u001e/\u0003!\u0011\u0018M\u00192ji6\f\u0018B\u0001\u001f8\u0005\u001daunZ+uS2\fa\"V:feN#\u0018\r^5p]\u0012\u000bw\u000e\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006\u0019\u0011\u000e\u001e4\u000b\u0005\rc\u0013\u0001B;tKJL!!\u0012!\u0003\u001dU\u001bXM]*uCRLwN\u001c#b_\u00061A(\u001b8jiz\"\u0012\u0001\u0013\u000b\u0005\u0013.cU\n\u0005\u0002K\u00015\t1\u0004C\u0003(\t\u0001\u000f\u0001\u0006C\u00035\t\u0001\u000fQ\u0007C\u0003>\t\u0001\u000fa\b\u000b\u0002\u0005\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0007S:TWm\u0019;\u000b\u0003Q\u000bqA[1lCJ$\u0018-\u0003\u0002W#\n1\u0011J\u001c6fGR\fq\"];bY&$\u0018PU3tK\u0006\u00148\r\u001b\u000b\u00063\u0012\u0014(\u0010 \t\u00035\u0006t!aW0\u0011\u0005q\u001bS\"A/\u000b\u0005y{\u0012A\u0002\u001fs_>$h(\u0003\u0002aG\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u00017\u0005C\u0003f\u000b\u0001\u0007a-A\u0004nKN\u001c\u0018mZ3\u0011\u0005\u001d\u0004X\"\u00015\u000b\u0005%T\u0017\u0001\u00026t_:T!a\u001b7\u0002\t1L'm\u001d\u0006\u0003[:\f1!\u00199j\u0015\u0005y\u0017\u0001\u00029mCfL!!\u001d5\u0003\u000f)\u001bh+\u00197vK\")1/\u0002a\u0001i\u00069\u0001.Z1eKJ\u001c\b\u0003\u0002.v3^L!A^2\u0003\u00075\u000b\u0007\u000f\u0005\u0002#q&\u0011\u0011p\t\u0002\u0004\u0003:L\b\"B>\u0006\u0001\u0004I\u0016AB7pIVdW\rC\u0003D\u000b\u0001\u0007\u0011,A\u0010hKR\u001cF/\u0019;j_:\u001c()\u001f)be\u0006lW\r^3s\t\u0016$Xm\u0019;j_:$\u0002\"W@\u0002\u0002\u0005\r\u0011Q\u0001\u0005\u0006K\u001a\u0001\rA\u001a\u0005\u0006g\u001a\u0001\r\u0001\u001e\u0005\u0006w\u001a\u0001\r!\u0017\u0005\u0006\u0007\u001a\u0001\r!W\u0001\u001cO\u0016$\u0018+^1mSRL\u0018J\u001c3jG\u0006$xN]:SKN,H\u000e^:\u0015\u0013e\u000bY!!\u0004\u0002\u0010\u0005E\u0001\"B3\b\u0001\u00041\u0007\"B:\b\u0001\u0004!\b\"B>\b\u0001\u0004I\u0006\"B\"\b\u0001\u0004I\u0016\u0001D1oC2L8/[:SK\u0006$WCAA\f!\u00159\u0017\u0011DA\u000f\u0013\r\tY\u0002\u001b\u0002\u0006%\u0016\fGm\u001d\t\u0007E\u0005}\u00111E-\n\u0007\u0005\u00052E\u0001\u0004UkBdWM\r\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0016\u0002\u001f\rD'o\u001c8jG\u0006s\u0017\r\\=tSNLA!!\f\u0002(\ty\u0011+^1mSRL\u0018I\\1msNL7/A\u0007b]\u0006d\u0017p]5t%\u0016\fG\rI\u0001\u0007GJ,\u0017\r^3\u0015\u0013e\u000b)$a\u000e\u0002:\u0005m\u0002\"B3\u000b\u0001\u00041\u0007\"B:\u000b\u0001\u0004!\b\"B>\u000b\u0001\u0004I\u0006\"B\"\u000b\u0001\u0004I\u0016AD2sK\u0006$X\rT5tiJ+\u0017\rZ\u000b\u0003\u0003\u0003\u0002RaZA\r\u0003\u0007\u0002bAIA\u00103\u0006\u0015\u0003CBA$\u0003#\n\u0019C\u0004\u0003\u0002J\u00055cb\u0001/\u0002L%\tA%C\u0002\u0002P\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002T\u0005U#aA*fc*\u0019\u0011qJ\u0012\u0002\u001f\r\u0014X-\u0019;f\u0019&\u001cHOU3bI\u0002\n!b\u0019:fCR,G*[:u)%I\u0016QLA0\u0003C\n\u0019\u0007C\u0003f\u001b\u0001\u0007a\rC\u0003t\u001b\u0001\u0007A\u000fC\u0003|\u001b\u0001\u0007\u0011\fC\u0003D\u001b\u0001\u0007\u0011,\u0001\u0004va\u0012\fG/\u001a\u000b\n3\u0006%\u00141NA7\u0003_BQ!\u001a\bA\u0002\u0019DQa\u001d\bA\u0002QDQa\u001f\bA\u0002eCQa\u0011\bA\u0002e\u000ba\u0001Z3mKR,G#C-\u0002v\u0005]\u0014\u0011PA>\u0011\u0015)w\u00021\u0001g\u0011\u0015\u0019x\u00021\u0001u\u0011\u0015Yx\u00021\u0001Z\u0011\u0015\u0019u\u00021\u0001Z\u0003ea\u0017m\u001d;Pa\u0016\u0014\u0018\r^5p]\u0006s\u0017\r\\=tSN\u0014V-\u00193\u0016\u0005\u0005\u0005\u0005#B4\u0002\u001a\u0005\r\u0005c\u0002\u0012\u0002 \u0005\u0015\u00151\u0013\t\u0006E\u0005\u001d\u00151R\u0005\u0004\u0003\u0013\u001b#AB(qi&|g\u000e\u0005\u0004\u0002H\u0005E\u0013Q\u0012\t\u0004E\u0005=\u0015bAAIG\t1Ai\\;cY\u0016\u0004RAIAD\u0003+\u0003B!a&\u0002&6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0003uS6,'\u0002BAP\u0003C\u000bAA[8eC*\u0011\u00111U\u0001\u0004_J<\u0017\u0002BAT\u00033\u0013\u0001\u0002R1uKRKW.Z\u0001\u001bY\u0006\u001cHo\u00149fe\u0006$\u0018n\u001c8B]\u0006d\u0017p]5t%\u0016\fG\rI\u0001\u0019O\u0016$H*Y:u\u001fB,'/\u0019;j_:\fe.\u00197zg&\u001cH#C-\u00020\u0006E\u00161WA[\u0011\u0015)'\u00031\u0001g\u0011\u0015\u0019(\u00031\u0001u\u0011\u0015Y(\u00031\u0001Z\u0011\u0015\u0019%\u00031\u0001Z\u0003)9W\r^!mYf+\u0017M\u001d\u000b\n3\u0006m\u0016QXA`\u0003\u0003DQ!Z\nA\u0002\u0019DQa]\nA\u0002QDQa_\nA\u0002eCQaQ\nA\u0002e\u000bQbZ3u\u00032d7+\u001e9q_J$H#C-\u0002H\u0006%\u00171ZAg\u0011\u0015)G\u00031\u0001g\u0011\u0015\u0019H\u00031\u0001u\u0011\u0015YH\u00031\u0001Z\u0011\u0015\u0019E\u00031\u0001Z\u000399W\r^!mYB\u0013x\u000eZ;dKJ$\u0012\"WAj\u0003+\f9.!7\t\u000b\u0015,\u0002\u0019\u00014\t\u000bM,\u0002\u0019\u0001;\t\u000bm,\u0002\u0019A-\t\u000b\r+\u0002\u0019A-\u0002\u001f\u001d,G/\u00117m!\u0006\u0014\u0018-\\3uKJ$\u0012\"WAp\u0003C\f\u0019/!:\t\u000b\u00154\u0002\u0019\u00014\t\u000bM4\u0002\u0019\u0001;\t\u000bm4\u0002\u0019A-\t\u000b\r3\u0002\u0019A-\u0002\u001d\u001d,G/\u00117m\rJ\f7\r^5p]RI\u0011,a;\u0002n\u0006=\u0018\u0011\u001f\u0005\u0006K^\u0001\rA\u001a\u0005\u0006g^\u0001\r\u0001\u001e\u0005\u0006w^\u0001\r!\u0017\u0005\u0006\u0007^\u0001\r!W\u0001\u000bO\u0016$\u0018\t\u001c7V]&$H#C-\u0002x\u0006e\u00181`A\u007f\u0011\u0015)\u0007\u00041\u0001g\u0011\u0015\u0019\b\u00041\u0001u\u0011\u0015Y\b\u00041\u0001Z\u0011\u0015\u0019\u0005\u00041\u0001Z\u000319W\r^!mY6+G\u000f[8e)%I&1\u0001B\u0003\u0005\u000f\u0011I\u0001C\u0003f3\u0001\u0007a\rC\u0003t3\u0001\u0007A\u000fC\u0003|3\u0001\u0007\u0011\fC\u0003D3\u0001\u0007\u0011\f")
public class AnalysisController {
    private final QualityDao qualityDao;
    private final LogUtil logUtil;
    private final UserStationDao UserStationDao;
    private final Reads<Tuple2<QualityAnalysis, String>> analysisRead;
    private final Reads<Tuple2<String, Seq<QualityAnalysis>>> createListRead;
    private final Reads<Tuple2<Option<Seq<Object>>, Option<DateTime>>> lastOperationAnalysisRead;

    public String qualityResearch(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get search parameters :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)criterias -> {
            if (criterias.prettyMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.qualityDao.getPrettyAnalysisLight(criterias).map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
            }
            if (criterias.ultraLightMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.qualityDao.getAnalysisUltraLight(criterias).map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
            }
            if (criterias.lightMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.qualityDao.getAnalysisLight(criterias).map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
            }
            return Json$.MODULE$.toJson((Object)$this.qualityDao.getAnalysis(criterias), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualityAnalysis$.MODULE$.format())).toString();
        });
    }

    public String getStationsByParameterDetection(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ParameterInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(62).append("Error validate Json to get qualitometers by parameters code :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)input -> {
            Seq stations = $this.qualityDao.getStationsWithParameters(input.parameters(), input.startDate(), input.endDate());
            Seq allowed = CommonReadUtil$.MODULE$.getAllowedQualitometerIds(input.user(), stations, "WEB", $this.UserStationDao);
            return Json$.MODULE$.toJson((Object)allowed, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.DoubleWrites())).toString();
        });
    }

    public String getQualityIndicatorsResults(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(IndicatorResultOutput$.MODULE$.indicatorResultsInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(60).append("Error validate Json to get parameters and qualitometer id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int id = BoxesRunTime.unboxToInt((Object)tuple3._1());
            Option parameters = (Option)tuple3._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)parameters);
            int id2 = tuple2._1$mcI$sp();
            Option parameters2 = (Option)tuple2._2();
            return Json$.MODULE$.toJson((Object)$this.qualityDao.getStationLastAnalysis((double)id2, parameters2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualityAnalysis$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple2<QualityAnalysis, String>> analysisRead() {
        return this.analysisRead;
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.analysisRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading analysis input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QualityAnalysis analysis = (QualityAnalysis)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)user);
            QualityAnalysis analysis2 = (QualityAnalysis)tuple22._1();
            String user2 = (String)tuple22._2();
            Tuple2 tuple23 = $this.qualityDao.createAnalysis(analysis2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            long id = tuple23._1$mcJ$sp();
            int updated = tuple23._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(id, updated);
            long id2 = sp2._1$mcJ$sp();
            int updated2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)updated2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)id2), (Writes)Writes$.MODULE$.LongWrites()))})).toString();
        });
    }

    public Reads<Tuple2<String, Seq<QualityAnalysis>>> createListRead() {
        return this.createListRead;
    }

    public String createList(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.createListRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validate Json to craete list analysis:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            Seq analysis = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)analysis);
            String user2 = (String)tuple22._1();
            Seq analysis2 = (Seq)tuple22._2();
            int res = $this.qualityDao.createList(analysis2, user2);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.analysisRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading analysis input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QualityAnalysis analysis = (QualityAnalysis)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)user);
            QualityAnalysis analysis2 = (QualityAnalysis)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.qualityDao.updateAnalysis(analysis2, user2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.analysisRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading analysis input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QualityAnalysis analysis = (QualityAnalysis)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)user);
            QualityAnalysis analysis2 = (QualityAnalysis)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.qualityDao.deleteAnalysis((Analysis)analysis2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple2<Option<Seq<Object>>, Option<DateTime>>> lastOperationAnalysisRead() {
        return this.lastOperationAnalysisRead;
    }

    public String getLastOperationAnalysis(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.lastOperationAnalysisRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading analysis input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option ids = (Option)tuple2._1();
            Option date = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)ids, (Object)date);
            Option ids2 = (Option)tuple22._1();
            Option date2 = (Option)tuple22._2();
            return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.qualityDao.getLastOperationAnalysis(ids2, date2).map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
        });
    }

    public String getAllYear(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllYear(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())).toString());
    }

    public String getAllSupport(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllSupport(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.DoubleWrites())).toString());
    }

    public String getAllProducer(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllProducer(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.DoubleWrites())).toString());
    }

    public String getAllParameter(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllParameter(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString());
    }

    public String getAllFraction(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllFraction(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString());
    }

    public String getAllUnit(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllUnit(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString());
    }

    public String getAllMethod(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityFilter$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(37).append("Error while reading quality filter : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)qualityFilter -> Json$.MODULE$.toJson((Object)$this.qualityDao.getAllMethod(qualityFilter), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString());
    }

    @Inject
    public AnalysisController(QualityDao qualityDao, LogUtil logUtil, UserStationDao UserStationDao2) {
        this.qualityDao = qualityDao;
        this.logUtil = logUtil;
        this.UserStationDao = UserStationDao2;
        this.analysisRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("analysis").read((Reads)QualityAnalysis$.MODULE$.format()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.createListRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("analysis").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)QualityAnalysis$.MODULE$.format()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.lastOperationAnalysisRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.DoubleReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("date").readNullable((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

