/*
 * Decompiled with CFR 0.152.
 */
package controllers.calculate;

import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)a\u0001\u0001C\u0001+!)1\u0005\u0001C\u0001I\t)2)\u00197d_\u000e\u000b'OY8oSF,X\rS3ma\u0016\u0014(B\u0001\u0004\b\u0003%\u0019\u0017\r\\2vY\u0006$XMC\u0001\t\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001a\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005)AC\u0002\f\u001a7uy\u0012\u0005\u0005\u0002\r/%\u0011\u0001$\u0004\u0002\u0007\t>,(\r\\3\t\u000bi\u0011\u0001\u0019\u0001\f\u0002\u0005A$\u0006\"\u0002\u000f\u0003\u0001\u00041\u0012A\u00019I\u0011\u0015q\"\u00011\u0001\u0017\u0003\u0011\u0001H+Q\"\t\u000b\u0001\u0012\u0001\u0019\u0001\f\u0002\u0007A\u001c\u0015\rC\u0003#\u0005\u0001\u0007a#A\u0002q%N\u000babZ3u'\u0006tGM]3WC2,X\r\u0006\u0002\u0017K!)ae\u0001a\u0001-\u0005\u0011\u0011n\u001d")
public class CalcoCarboniqueHelper {
    public double calculate(double pT, double pH, double pTAC, double pCa, double pRS) {
        double T = pT;
        double H = pH;
        double TAC = pTAC;
        double Ca = pCa;
        double RS = pRS;
        String nature = "0";
        double T2 = 0.0;
        double T3 = 0.0;
        double pHs = 0.0;
        double IS = 0.0;
        double C = 0.0;
        double pK1 = 0.0;
        double pK2 = 0.0;
        double pKs = 0.0;
        double FI = 0.0;
        double rFI = 0.0;
        double EP1 = 0.0;
        double EP2 = 0.0;
        double EP4 = 0.0;
        double pK_1 = 0.0;
        double pK_2 = 0.0;
        double pK_s = 0.0;
        double logTAC = 0.0;
        double logCa = 0.0;
        double ionsH = 0.0;
        double K2 = 0.0;
        double p = 0.0;
        T2 = Math.pow(T /= (double)1000, 2.0);
        T3 = Math.pow(T, 3.0);
        pK1 = 6.583 - 12.3 * T + 163.5 * T2 - (double)646 * T3;
        pK2 = 10.627 - 15.04 * T + 135.3 * T2 - (double)328 * T3;
        pKs = 8.022 + (double)14 * T - (double)61 * T2 + (double)444 * T3;
        FI = RS * 2.5E-5;
        rFI = Math.sqrt(FI);
        EP1 = rFI / (1.0 + 1.4 * rFI);
        EP2 = EP1 * (double)2;
        EP4 = (double)4 * rFI / (1.0 + 3.9 * rFI);
        pK_1 = pK1 - EP1;
        pK_2 = pK2 - EP2;
        pK_s = pKs - EP4;
        C = pK_2 - pK_s + 9.195;
        logTAC = Math.log10(TAC * 5.6);
        logCa = Math.log10(Ca * 5.6);
        ionsH = Math.pow(10.0, -H);
        K2 = -pK_2;
        K2 = Math.pow(10.0, K2);
        p = Math.log10(1.0 + (double)2 * K2 / ionsH);
        pHs = C - (logTAC + logCa) + p;
        pHs = (double)Math.round(pHs * (double)1000) / (double)1000;
        IS = H - pHs;
        return IS;
    }

    public double getSandreValue(double is) {
        if (is < -0.3) {
            return 0.0;
        }
        if (is >= -0.3 && is < -0.2) {
            return 1.0;
        }
        if (is >= -0.2 && is <= 0.2) {
            return 2.0;
        }
        if (is > 0.2 && is <= 0.3) {
            return 3.0;
        }
        return 4.0;
    }
}

