/*
 * Decompiled with CFR 0.152.
 */
package controllers.calculate;

import fr.aquasys.daeau.quality.itf.HydrobioDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.HydrobioOperation;
import fr.aquasys.daeau.quality.model.QualitometerOperationList;
import fr.aquasys.daeau.quality.model.QualitometerOperationList$;
import fr.aquasys.daeau.referentials.taxon.itf.TaxonDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapFactoryDefaults;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u0005\u000b\u0001=A\u0001B\u0006\u0001\u0003\u0002\u0003\u0006Ya\u0006\u0005\tK\u0001\u0011\t\u0011)A\u0006M!A\u0011\u0006\u0001B\u0001B\u0003-!\u0006\u0003\u00054\u0001\t\u0005\t\u0015a\u00035\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u001dq\u0005A1A\u0005\u0002=Ca!\u001d\u0001!\u0002\u0013\u0001\u0006\"\u0002:\u0001\t\u0003\u0019(\u0001G\"bY\u000e,H.\u0019;f)\u0006DxN\\\"p]R\u0014x\u000e\u001c7fe*\u00111\u0002D\u0001\nG\u0006d7-\u001e7bi\u0016T\u0011!D\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g-A\brk\u0006d\u0017\u000e^8nKR,'\u000fR1p!\tA2%D\u0001\u001a\u0015\tQ2$A\u0002ji\u001aT!\u0001H\u000f\u0002\u000fE,\u0018\r\\5us*\u0011adH\u0001\u0006I\u0006,\u0017-\u001e\u0006\u0003A\u0005\nq!Y9vCNL8OC\u0001#\u0003\t1'/\u0003\u0002%3\ty\u0011+^1mSR|W.\u001a;fe\u0012\u000bw.A\u0006is\u0012\u0014xNY5p\t\u0006|\u0007C\u0001\r(\u0013\tA\u0013DA\u0006Is\u0012\u0014xNY5p\t\u0006|\u0017\u0001\u0003;bq>tG)Y8\u0011\u0005-\nT\"\u0001\u0017\u000b\u0005ii#B\u0001\u00180\u0003\u0015!\u0018\r_8o\u0015\t\u0001T$\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7/\u0003\u00023Y\tAA+\u0019=p]\u0012\u000bw.A\u0004m_\u001e,F/\u001b7\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014\u0001B;uS2T!!O\u0010\u0002\u0011I\f'MY5u[FL!a\u000f\u001c\u0003\u000f1{w-\u0016;jY\u00061A(\u001b8jiz\"\u0012A\u0010\u000b\u0006\u007f\u0005\u00135\t\u0012\t\u0003\u0001\u0002i\u0011A\u0003\u0005\u0006-\u0015\u0001\u001da\u0006\u0005\u0006K\u0015\u0001\u001dA\n\u0005\u0006S\u0015\u0001\u001dA\u000b\u0005\u0006g\u0015\u0001\u001d\u0001\u000e\u0015\u0003\u000b\u0019\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\r%t'.Z2u\u0015\u0005Y\u0015!\u00026bm\u0006D\u0018BA'I\u0005\u0019IeN[3di\u0006qq\u000e]3sCRLwN\\:SK\u0006$W#\u0001)\u0011\u0007ESF,D\u0001S\u0015\t\u0019F+\u0001\u0003kg>t'BA+W\u0003\u0011a\u0017NY:\u000b\u0005]C\u0016aA1qS*\t\u0011,\u0001\u0003qY\u0006L\u0018BA.S\u0005\u0015\u0011V-\u00193t!\u0011\tRl\u00182\n\u0005y\u0013\"A\u0002+va2,'\u0007\u0005\u0002\u0012A&\u0011\u0011M\u0005\u0002\u0004\u0013:$\bcA\tdK&\u0011AM\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0019twL\u0004\u0002hY:\u0011\u0001n[\u0007\u0002S*\u0011!ND\u0001\u0007yI|w\u000e\u001e \n\u0003MI!!\u001c\n\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA7\u0013\u0003=y\u0007/\u001a:bi&|gn\u001d*fC\u0012\u0004\u0013aD2bY\u000e,H.\u0019;f)\u0006DxN\\:\u0015\u0011Qd\u00181AA\n\u0003/\u0001\"!^=\u000f\u0005Y<\bC\u00015\u0013\u0013\tA(#\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=\u0013\u0011\u0015i\b\u00021\u0001\u007f\u0003\u001diWm]:bO\u0016\u0004\"!U@\n\u0007\u0005\u0005!KA\u0004KgZ\u000bG.^3\t\u000f\u0005\u0015\u0001\u00021\u0001\u0002\b\u00059\u0001.Z1eKJ\u001c\bCB;\u0002\nQ\fi!C\u0002\u0002\fm\u00141!T1q!\r\t\u0012qB\u0005\u0004\u0003#\u0011\"aA!os\"1\u0011Q\u0003\u0005A\u0002Q\fa!\\8ek2,\u0007BBA\r\u0011\u0001\u0007A/\u0001\u0003vg\u0016\u0014\b")
public class CalculateTaxonController {
    private final QualitometerDao qualitometerDao;
    private final HydrobioDao hydrobioDao;
    private final TaxonDao taxonDao;
    private final LogUtil logUtil;
    private final Reads<Tuple2<Object, Option<Seq<Object>>>> operationsRead;

    public Reads<Tuple2<Object, Option<Seq<Object>>>> operationsRead() {
        return this.operationsRead;
    }

    public String calculateTaxons(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.operationsRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(65).append("Error validate Json to calculate taxons for station operations :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int idStation = tuple2._1$mcI$sp();
            Option idOperations = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)idStation), (Object)idOperations);
            int idStation2 = tuple22._1$mcI$sp();
            Option idOperations2 = (Option)tuple22._2();
            Option option = $this.qualitometerDao.get(idStation2);
            if (option instanceof Some) {
                Seq seq;
                Seq taxons = $this.taxonDao.getCalculateTaxons();
                Seq filterParameters = (Seq)taxons.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)x$2.calculTaxonCode().getOrElse((Function0 & Serializable)() -> "")))));
                Map calculateTaxons = ((IterableOnceOps)filterParameters.map((Function1 & Serializable)param -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)param.code()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((String)param.calculTaxonCode().get()).split(";|,")))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Option option2 = idOperations2;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Seq opeIds = (Seq)some.value();
                    seq = $this.hydrobioDao.getOperations(idStation2, opeIds);
                } else {
                    seq = $this.hydrobioDao.getHydrobioOperations(idStation2, $this.hydrobioDao.getHydrobioOperations$default$2(), $this.hydrobioDao.getHydrobioOperations$default$3());
                }
                Seq operations = seq;
                Map map = calculateTaxons;
                Seq newList = (Seq)((IterableOps)operations.map((Function1 & Serializable)ope -> {
                    Seq hydrobioList = $this.hydrobioDao.getOperationList(idStation2, (int)ope.id());
                    return new Tuple2(ope, (Object)hydrobioList);
                })).flatMap((Function1 & Serializable)x$10 -> {
                    Tuple2 tuple2 = x$10;
                    if (tuple2 != null) {
                        HydrobioOperation ope = (HydrobioOperation)tuple2._1();
                        Seq hydrobioList = (Seq)tuple2._2();
                        return (Iterable)((IterableOps)((MapFactoryDefaults)map.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CalculateTaxonController.$anonfun$calculateTaxons$8(check$ifrefutable$1))).map((Function1 & Serializable)x$5 -> {
                            Tuple2 tuple2 = x$5;
                            if (tuple2 != null) {
                                Seq listCode = (Seq)tuple2._2();
                                Seq matchingItems = (Seq)listCode.flatMap((Function1 & Serializable)code -> hydrobioList.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CalculateTaxonController.$anonfun$calculateTaxons$11(code, x$3))));
                                return new Tuple2((Object)tuple2, (Object)matchingItems);
                            }
                            throw new MatchError((Object)tuple2);
                        })).withFilter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CalculateTaxonController.$anonfun$calculateTaxons$12(x$6))).map((Function1 & Serializable)x$8 -> {
                            Tuple2 tuple2 = x$8;
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                Seq matchingItems = (Seq)tuple2._2();
                                if (tuple22 != null) {
                                    double calculatedValueA = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)matchingItems.map((Function1 & Serializable)hl -> BoxesRunTime.boxToDouble((double)CalculateTaxonController.$anonfun$calculateTaxons$14(hl)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                    double calculatedValueB = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)matchingItems.map((Function1 & Serializable)hl -> BoxesRunTime.boxToDouble((double)CalculateTaxonController.$anonfun$calculateTaxons$16(hl)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                    double calculatedValueC = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)matchingItems.map((Function1 & Serializable)hl -> BoxesRunTime.boxToDouble((double)CalculateTaxonController.$anonfun$calculateTaxons$18(hl)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                    double calculatedValueC2 = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)matchingItems.map((Function1 & Serializable)hl -> BoxesRunTime.boxToDouble((double)CalculateTaxonController.$anonfun$calculateTaxons$20(hl)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                    return new Tuple5((Object)tuple2, (Object)BoxesRunTime.boxToDouble((double)calculatedValueA), (Object)BoxesRunTime.boxToDouble((double)calculatedValueB), (Object)BoxesRunTime.boxToDouble((double)calculatedValueC), (Object)BoxesRunTime.boxToDouble((double)calculatedValueC2));
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        })).map((Function1 & Serializable)x$9 -> {
                            Tuple5 tuple5 = x$9;
                            if (tuple5 != null) {
                                Tuple2 tuple2;
                                Tuple2 tuple22 = (Tuple2)tuple5._1();
                                double calculatedValueA = BoxesRunTime.unboxToDouble((Object)tuple5._2());
                                double calculatedValueB = BoxesRunTime.unboxToDouble((Object)tuple5._3());
                                double calculatedValueC = BoxesRunTime.unboxToDouble((Object)tuple5._4());
                                double calculatedValueC2 = BoxesRunTime.unboxToDouble((Object)tuple5._5());
                                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                                    String codeTaxon = (String)tuple2._1();
                                    double x$1 = idStation2;
                                    double x$2 = ope.id();
                                    double x$3 = 0.0;
                                    Some x$4 = new Some((Object)codeTaxon);
                                    Some x$5 = new Some((Object)BoxesRunTime.boxToDouble((double)calculatedValueA));
                                    Some x$6 = new Some((Object)BoxesRunTime.boxToDouble((double)calculatedValueB));
                                    Some x$7 = new Some((Object)BoxesRunTime.boxToDouble((double)calculatedValueC));
                                    Some x$8 = new Some((Object)BoxesRunTime.boxToDouble((double)calculatedValueC2));
                                    Option x$92 = QualitometerOperationList$.MODULE$.apply$default$4();
                                    Option x$10 = QualitometerOperationList$.MODULE$.apply$default$7();
                                    Option x$11 = QualitometerOperationList$.MODULE$.apply$default$9();
                                    Option x$12 = QualitometerOperationList$.MODULE$.apply$default$11();
                                    Option x$13 = QualitometerOperationList$.MODULE$.apply$default$12();
                                    Option x$14 = QualitometerOperationList$.MODULE$.apply$default$13();
                                    Option x$15 = QualitometerOperationList$.MODULE$.apply$default$14();
                                    Option x$16 = QualitometerOperationList$.MODULE$.apply$default$15();
                                    Option x$17 = QualitometerOperationList$.MODULE$.apply$default$16();
                                    Option x$18 = QualitometerOperationList$.MODULE$.apply$default$18();
                                    Option x$19 = QualitometerOperationList$.MODULE$.apply$default$19();
                                    Option x$20 = QualitometerOperationList$.MODULE$.apply$default$20();
                                    Option x$21 = QualitometerOperationList$.MODULE$.apply$default$21();
                                    Option x$22 = QualitometerOperationList$.MODULE$.apply$default$22();
                                    Option x$23 = QualitometerOperationList$.MODULE$.apply$default$23();
                                    Option x$24 = QualitometerOperationList$.MODULE$.apply$default$24();
                                    Option x$25 = QualitometerOperationList$.MODULE$.apply$default$25();
                                    Option x$26 = QualitometerOperationList$.MODULE$.apply$default$26();
                                    Option x$27 = QualitometerOperationList$.MODULE$.apply$default$27();
                                    Option x$28 = QualitometerOperationList$.MODULE$.apply$default$28();
                                    Option x$29 = QualitometerOperationList$.MODULE$.apply$default$29();
                                    Option x$30 = QualitometerOperationList$.MODULE$.apply$default$30();
                                    return new QualitometerOperationList(x$1, x$2, 0.0, x$92, (Option)x$4, (Option)x$5, x$10, (Option)x$6, x$11, (Option)x$7, x$12, x$13, x$14, x$15, x$16, x$17, (Option)x$8, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
                                }
                            }
                            throw new MatchError((Object)tuple5);
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
                Seq listToInsert = (Seq)newList.filter((Function1 & Serializable)hl -> BoxesRunTime.boxToBoolean((boolean)CalculateTaxonController.$anonfun$calculateTaxons$23(this, idStation2, hl)));
                int nbInsert = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)listToInsert.map((Function1 & Serializable)hl -> BoxesRunTime.boxToInteger((int)this.hydrobioDao.insertHydrobioList(hl.qualitometer(), hl.operation(), hl)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alreadyExist"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)(newList.length() - listToInsert.length())), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbInsert), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(34).append("Qualitometer doesn't exist for id ").append(idStation2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ boolean $anonfun$calculateTaxons$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$calculateTaxons$11(String code$1, QualitometerOperationList x$3) {
        return x$3.taxon().contains((Object)code$1);
    }

    public static final /* synthetic */ boolean $anonfun$calculateTaxons$12(Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Seq matchingItems = (Seq)tuple2._2();
            if (tuple22 != null) {
                return matchingItems.nonEmpty();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$calculateTaxons$14(QualitometerOperationList hl) {
        return BoxesRunTime.unboxToDouble((Object)hl.enumerationA().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ double $anonfun$calculateTaxons$16(QualitometerOperationList hl) {
        return BoxesRunTime.unboxToDouble((Object)hl.enumerationB().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ double $anonfun$calculateTaxons$18(QualitometerOperationList hl) {
        return BoxesRunTime.unboxToDouble((Object)hl.enumerationC().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ double $anonfun$calculateTaxons$20(QualitometerOperationList hl) {
        return BoxesRunTime.unboxToDouble((Object)hl.enumerationC2().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ boolean $anonfun$calculateTaxons$23(CalculateTaxonController $this, int idStation$1, QualitometerOperationList hl) {
        return !$this.hydrobioDao.isOperationListExist(idStation$1, (int)hl.operation(), (String)hl.taxon().get());
    }

    @Inject
    public CalculateTaxonController(QualitometerDao qualitometerDao, HydrobioDao hydrobioDao, TaxonDao taxonDao, LogUtil logUtil) {
        this.qualitometerDao = qualitometerDao;
        this.hydrobioDao = hydrobioDao;
        this.taxonDao = taxonDao;
        this.logUtil = logUtil;
        this.operationsRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("idOperations").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

