/*
 * Decompiled with CFR 0.152.
 */
package controllers.control;

import controllers.control.ControlAnalysisLight;
import controllers.control.ControlDao;
import controllers.control.PostControlParams;
import controllers.control.PostControlParams$;
import controllers.integrationOverview.ControlParameters$;
import controllers.integrationOverview.ControledAnalysis;
import controllers.integrationOverview.ControledAnalysis$;
import controllers.integrationOverview.ThresholdResult;
import dao.QualitySpecific.QualitySpecificDao;
import dao.rpc.IAEauDao;
import fr.aquasys.daeau.cms.domain.input.CmsInput;
import fr.aquasys.daeau.cms.domain.input.CmsInput$;
import fr.aquasys.daeau.job.itf.JobDao;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.quality.chronicAnalysis.Analysis;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.quality.threshold.ParameterThreshold;
import fr.aquasys.daeau.quality.threshold.ThresholdDao;
import fr.aquasys.daeau.quality.utils.QualityThresholdUtil$;
import fr.aquasys.rabbitmq.api.constant.CmsRouting$;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StringUtil$;
import fr.aquasys.utils.readJsonUtil.RPCResult;
import fr.aquasys.utils.readJsonUtil.RPCResult$;
import jakarta.inject.Inject;
import java.io.Serializable;
import model.ConformityResult;
import model.OutlierResult;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tue\u0001B\f\u0019\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006Y!\n\u0005\tc\u0001\u0011\t\u0011)A\u0006e!A!\b\u0001B\u0001B\u0003-1\b\u0003\u0005D\u0001\t\u0005\t\u0015a\u0003E\u0011!Q\u0005A!A!\u0002\u0017Y\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b1\u0002*\t\u0011a\u0003!\u0011!Q\u0001\feC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006Y!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0006M\"AA\u000e\u0001B\u0001B\u0003-Q\u000eC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0003S\u0004A\u0011BAv\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u0003J\u0001!IAa\u0013\t\u000f\t%\u0004\u0001\"\u0003\u0003l!9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BB\u0001\u0011%!Q\u0011\u0002\u0012\u0007>tGO]8m\u0007>tGO]8mY\u0016\u0014(BA\r\u001b\u0003\u001d\u0019wN\u001c;s_2T\u0011aG\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013\u0001B;uS2T!AK\u0016\u0002\u0011I\f'MY5u[FT!\u0001L\u0017\u0002\u000f\u0005\fX/Y:zg*\ta&\u0001\u0002ge&\u0011\u0001g\n\u0002\b\u0019><W\u000b^5m\u0003)\tX/\u00197jif$\u0015m\u001c\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nq!];bY&$\u0018P\u0003\u00028W\u0005)A-Y3bk&\u0011\u0011\b\u000e\u0002\u000b#V\fG.\u001b;z\t\u0006|\u0017AE9vC2LG/_*qK\u000eLg-[2EC>\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u001fE+\u0018\r\\5usN\u0003XmY5gS\u000eT\u0011\u0001Q\u0001\u0004I\u0006|\u0017B\u0001\">\u0005I\tV/\u00197jif\u001c\u0006/Z2jM&\u001cG)Y8\u0002\u0011%\fW)Y;EC>\u0004\"!\u0012%\u000e\u0003\u0019S!aR \u0002\u0007I\u00048-\u0003\u0002J\r\nA\u0011*Q#bk\u0012\u000bw.A\brk\u0006d\u0017\u000e^8nKR,'\u000fR1p!\tau*D\u0001N\u0015\tqE'A\u0002ji\u001aL!\u0001U'\u0003\u001fE+\u0018\r\\5u_6,G/\u001a:EC>\fA\u0002\u001e5sKNDw\u000e\u001c3EC>\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u001b\u0002\u0013QD'/Z:i_2$\u0017BA,U\u00051!\u0006N]3tQ>dG\rR1p\u0003\u0019QwN\u0019#b_B\u0011!LX\u0007\u00027*\u0011a\n\u0018\u0006\u0003;Z\n1A[8c\u0013\ty6L\u0001\u0004K_\n$\u0015m\\\u0001\u000bG>tGO]8m\t\u0006|\u0007C\u00012d\u001b\u0005A\u0012B\u00013\u0019\u0005)\u0019uN\u001c;s_2$\u0015m\\\u0001\u000b\u0015>\u0014Gj\\4Vi&d\u0007CA4k\u001b\u0005A'BA5,\u0003\u0015)H/\u001b7t\u0013\tY\u0007N\u0001\u0006K_\ndunZ+uS2\f!a^:\u0011\u000594X\"A8\u000b\u00051\u0004(BA9s\u0003\u0011a\u0017NY:\u000b\u0005M$\u0018aA1qS*\tQ/\u0001\u0003qY\u0006L\u0018BA<p\u0005!96k\u00117jK:$\u0018A\u0002\u001fj]&$h\bF\u0001{)EYH0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111\u0002\t\u0003E\u0002AQ\u0001J\u0006A\u0004\u0015BQ!M\u0006A\u0004IBQAO\u0006A\u0004mBQaQ\u0006A\u0004\u0011CQAS\u0006A\u0004-CQ!U\u0006A\u0004ICQ\u0001W\u0006A\u0004eCQ\u0001Y\u0006A\u0004\u0005DQ!Z\u0006A\u0004\u0019DQ\u0001\\\u0006A\u00045D3aCA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\ta!\u001b8kK\u000e$(BAA\r\u0003\u001dQ\u0017m[1si\u0006LA!!\b\u0002\u0014\t1\u0011J\u001c6fGR\faB[8c!>\u001cHoQ8oiJ|G\u000e\u0006\u0003\u0002$\u0005%\u0002cA\u0010\u0002&%\u0019\u0011q\u0005\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Wa\u0001\u0019AA\u0017\u0003!QwNY%oaV$\b\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0012&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003o\t\tD\u0001\u0005K_\nLe\u000e];u\u0003%i\u0017M\\1hK.{7\u000f\u0006\u0004\u0002>\u0005M\u00131\u0010\u000b\u0007\u0003G\ty$!\u0013\t\u000f\u0005\u0005S\u0002q\u0001\u0002D\u0005q!n\u001c2Fq\u0016\u001cW\u000f^5p]&#\u0007cA\u0010\u0002F%\u0019\u0011q\t\u0011\u0003\t1{gn\u001a\u0005\b\u0003\u0017j\u00019AA'\u0003\u0019\u0001\u0018M]1ngB\u0019!-a\u0014\n\u0007\u0005E\u0003DA\tQ_N$8i\u001c8ue>d\u0007+\u0019:b[NDq!!\u0016\u000e\u0001\u0004\t9&A\u0002l_N\u0004b!!\u0017\u0002j\u0005=d\u0002BA.\u0003KrA!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003Cb\u0012A\u0002\u001fs_>$h(C\u0001\"\u0013\r\t9\u0007I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY'!\u001c\u0003\u0007M+\u0017OC\u0002\u0002h\u0001\u0002B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003kR\u0012aE5oi\u0016<'/\u0019;j_:|e/\u001a:wS\u0016<\u0018\u0002BA=\u0003g\u0012\u0011cQ8oiJ|G.\u001a3B]\u0006d\u0017p]5t\u0011\u001d\ti(\u0004a\u0001\u0003\u007f\n1b\u001d;bi&|gnQ8eKB!\u0011\u0011QAE\u001d\u0011\t\u0019)!\"\u0011\u0007\u0005u\u0003%C\u0002\u0002\b\u0002\na\u0001\u0015:fI\u00164\u0017\u0002BAF\u0003\u001b\u0013aa\u0015;sS:<'bAADA\u0005!R.\u00198bO\u0016$Vm\u00195oS\u000e\fG.\u0012<f]R$b\"a%\u0002\u001e\u0006\u0005\u00161UAW\u0003_\u000b9\r\u0006\u0005\u0002$\u0005U\u0015qSAM\u0011\u001d\t\tE\u0004a\u0002\u0003\u0007Bq!a\u0013\u000f\u0001\b\ti\u0005C\u0004\u0002\u001c:\u0001\u001d!a \u0002\tU\u001cXM\u001d\u0005\b\u0003?s\u0001\u0019AA,\u0003\ry7n\u001d\u0005\b\u0003+r\u0001\u0019AA,\u0011\u001d\t)K\u0004a\u0001\u0003O\u000b\u0011b\u001d;bi&|g.\u00133\u0011\u0007}\tI+C\u0002\u0002,\u0002\u0012a\u0001R8vE2,\u0007bBA?\u001d\u0001\u0007\u0011q\u0010\u0005\b\u0003cs\u0001\u0019AAZ\u0003%\u0019H/\u0019:u\t\u0006$X\r\u0005\u0003\u00026\u0006\rWBAA\\\u0015\u0011\tI,a/\u0002\tQLW.\u001a\u0006\u0005\u0003{\u000by,\u0001\u0003k_\u0012\f'BAAa\u0003\ry'oZ\u0005\u0005\u0003\u000b\f9L\u0001\u0005ECR,G+[7f\u0011\u001d\tIM\u0004a\u0001\u0003g\u000bq!\u001a8e\t\u0006$X-\u0001\nnC:\fw-Z\"N'\u0006tG-R7bS2\u001cHCCAh\u0003/\f\t/a9\u0002fRA\u00111EAi\u0003'\f)\u000eC\u0004\u0002B=\u0001\u001d!a\u0011\t\u000f\u0005-s\u0002q\u0001\u0002N!9\u00111T\bA\u0004\u0005}\u0004bBAm\u001f\u0001\u0007\u00111\\\u0001\u0019OJ|W\u000f]3e\u0007>tGO]8mK\u0012\fe.\u00197zg&\u001c\b\u0003CAA\u0003;\f9+a\u0016\n\t\u0005}\u0017Q\u0012\u0002\u0004\u001b\u0006\u0004\bbBAY\u001f\u0001\u0007\u00111\u0017\u0005\b\u0003\u0013|\u0001\u0019AAZ\u0011\u001d\t9o\u0004a\u0001\u0003\u0007\n!\u0003\u001d:fm*{'-\u0012=fGV$\u0018n\u001c8JI\u0006Yq-\u001a8fe\u0006$XmQ'T))\ti/!>\u0002x\u0006e\u00181 \u000b\t\u0003G\ty/!=\u0002t\"9\u0011\u0011\t\tA\u0004\u0005\r\u0003bBA&!\u0001\u000f\u0011Q\n\u0005\b\u00037\u0003\u00029AA@\u0011\u001d\tI\u000e\u0005a\u0001\u00037Dq!!-\u0011\u0001\u0004\t\u0019\fC\u0004\u0002JB\u0001\r!a-\t\u000f\u0005\u001d\b\u00031\u0001\u0002D\u000591/\u001a8e\u00076\u001bF\u0003\u0002B\u0001\u0005\u001b\u0001BAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0004\u0005\u000fA\u0017\u0001\u0004:fC\u0012T5o\u001c8Vi&d\u0017\u0002\u0002B\u0006\u0005\u000b\u0011\u0011B\u0015)D%\u0016\u001cX\u000f\u001c;\t\u000f\t=\u0011\u00031\u0001\u0003\u0012\u0005A1-\\:J]B,H\u000f\u0005\u0003\u0003\u0014\t}QB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\u000b%t\u0007/\u001e;\u000b\t\u0005M\"1\u0004\u0006\u0004\u0005;1\u0014aA2ng&!!\u0011\u0005B\u000b\u0005!\u0019Un]%oaV$\u0018AE2p]R\u0014x\u000e\\!mY\u0006s\u0017\r\\=tSN$\"\"a \u0003(\t]\"1\tB$\u0011\u001d\u0011IC\u0005a\u0001\u0005W\tq!\\3tg\u0006<W\r\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r\u0011\t\u0004]\u0001\u0005UN|g.\u0003\u0003\u00036\t=\"a\u0002&t-\u0006dW/\u001a\u0005\b\u0005s\u0011\u0002\u0019\u0001B\u001e\u0003\u001dAW-\u00193feN\u0004\u0002\"!!\u0002^\u0006}$Q\b\t\u0004?\t}\u0012b\u0001B!A\t\u0019\u0011I\\=\t\u000f\t\u0015#\u00031\u0001\u0002\u0000\u00051Qn\u001c3vY\u0016Dq!a'\u0013\u0001\u0004\ty(A\u0007hKR\u001cuN\u001c4pe6LG/\u001f\u000b\u0007\u0005\u001b\u0012YF!\u0018\u0011\r\u0005e\u0013\u0011\u000eB(!\u0011\u0011\tFa\u0016\u000e\u0005\tM#B\u0001B+\u0003\u0015iw\u000eZ3m\u0013\u0011\u0011IFa\u0015\u0003!\r{gNZ8s[&$\u0018PU3tk2$\bbBAN'\u0001\u0007\u0011q\u0010\u0005\b\u0005?\u001a\u0002\u0019\u0001B1\u0003!\tg.\u00197zg&\u001c\bCBA-\u0003S\u0012\u0019\u0007E\u0002c\u0005KJ1Aa\u001a\u0019\u0005Q\u0019uN\u001c;s_2\fe.\u00197zg&\u001cH*[4ii\u0006Qq-\u001a;PkRd\u0017.\u001a:\u0015\r\t5$Q\u000fB<!\u0019\tI&!\u001b\u0003pA!!\u0011\u000bB9\u0013\u0011\u0011\u0019Ha\u0015\u0003\u001b=+H\u000f\\5feJ+7/\u001e7u\u0011\u001d\tY\n\u0006a\u0001\u0003\u007fBqA!\u001f\u0015\u0001\u0004\u0011\t'\u0001\tti\u0006$\u0018n\u001c8t\u0003:\fG._:jg\u0006!r-\u001a;PkRd\u0017.\u001a:Nk2$\u0018\u000eU1sC6$bA!\u0014\u0003\u0000\t\u0005\u0005bBAN+\u0001\u0007\u0011q\u0010\u0005\b\u0005?*\u0002\u0019\u0001B1\u0003U9W\r^\"p]R\u0014x\u000e\\3e)\"\u0014Xm\u001d5pY\u0012$\u0002Ba\"\u0003\u0010\nE%\u0011\u0014\t\u0007\u00033\nIG!#\u0011\t\u0005E$1R\u0005\u0005\u0005\u001b\u000b\u0019HA\bUQJ,7\u000f[8mIJ+7/\u001e7u\u0011\u001d\u0011yF\u0006a\u0001\u0005CBa!\u0016\fA\u0002\tM\u0005cA\u0010\u0003\u0016&\u0019!q\u0013\u0011\u0003\u0007%sG\u000fC\u0004\u0003\u001cZ\u0001\r!a \u0002\u0013\r|G-Z#se>\u0014\b")
public class ControlController {
    private final LogUtil logUtil;
    private final QualityDao qualityDao;
    private final QualitySpecificDao qualitySpecificDao;
    private final IAEauDao iaEauDao;
    private final QualitometerDao qualitometerDao;
    private final ThresholdDao thresholdDao;
    private final JobDao jobDao;
    private final ControlDao controlDao;
    private final JobLogUtil JobLogUtil;
    private final WSClient ws;

    public void jobPostControl(JobInput jobInput) {
        long jobExecutionId = jobInput.jobExecutionId();
        String user = (String)jobInput.user().getOrElse((Function0 & Serializable)() -> "unknown user");
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Start control", "", this.JobLogUtil.log$default$5());
        Option option = this.jobDao.getPreviousJobExecutionId(jobInput.jobId());
        if (option instanceof Some) {
            Some some = (Some)option;
            long prevJobExecId = BoxesRunTime.unboxToLong((Object)some.value());
            try {
                PostControlParams params = (PostControlParams)JobUtil$.MODULE$.getParameters(new JobParameters(jobInput), jobExecutionId, this.JobLogUtil, PostControlParams$.MODULE$.reads()).head();
                Some x$12 = new Some((Object)BoxesRunTime.boxToLong((long)prevJobExecId));
                Option x$2 = QualityFilter$.MODULE$.apply$default$1();
                Option x$3 = QualityFilter$.MODULE$.apply$default$2();
                Option x$4 = QualityFilter$.MODULE$.apply$default$3();
                Option x$5 = QualityFilter$.MODULE$.apply$default$4();
                Option x$6 = QualityFilter$.MODULE$.apply$default$5();
                Option x$7 = QualityFilter$.MODULE$.apply$default$6();
                Option x$8 = QualityFilter$.MODULE$.apply$default$7();
                Option x$9 = QualityFilter$.MODULE$.apply$default$8();
                Option x$10 = QualityFilter$.MODULE$.apply$default$9();
                Option x$11 = QualityFilter$.MODULE$.apply$default$10();
                Option x$122 = QualityFilter$.MODULE$.apply$default$11();
                Option x$13 = QualityFilter$.MODULE$.apply$default$12();
                Option x$14 = QualityFilter$.MODULE$.apply$default$13();
                Option x$15 = QualityFilter$.MODULE$.apply$default$14();
                Option x$16 = QualityFilter$.MODULE$.apply$default$15();
                Option x$17 = QualityFilter$.MODULE$.apply$default$16();
                Option x$18 = QualityFilter$.MODULE$.apply$default$17();
                Option x$19 = QualityFilter$.MODULE$.apply$default$18();
                Option x$20 = QualityFilter$.MODULE$.apply$default$19();
                Option x$21 = QualityFilter$.MODULE$.apply$default$20();
                Option x$22 = QualityFilter$.MODULE$.apply$default$21();
                Option x$23 = QualityFilter$.MODULE$.apply$default$22();
                Option x$24 = QualityFilter$.MODULE$.apply$default$23();
                Option x$25 = QualityFilter$.MODULE$.apply$default$24();
                Option x$26 = QualityFilter$.MODULE$.apply$default$25();
                Option x$27 = QualityFilter$.MODULE$.apply$default$26();
                Option x$28 = QualityFilter$.MODULE$.apply$default$27();
                Option x$29 = QualityFilter$.MODULE$.apply$default$28();
                Option x$30 = QualityFilter$.MODULE$.apply$default$30();
                Option x$31 = QualityFilter$.MODULE$.apply$default$31();
                Option x$32 = QualityFilter$.MODULE$.apply$default$32();
                Option x$33 = QualityFilter$.MODULE$.apply$default$33();
                Option x$34 = QualityFilter$.MODULE$.apply$default$34();
                Option x$35 = QualityFilter$.MODULE$.apply$default$35();
                Option x$36 = QualityFilter$.MODULE$.apply$default$36();
                Option x$37 = QualityFilter$.MODULE$.apply$default$37();
                Seq<ControlAnalysisLight> analysis = this.qualitySpecificDao.getControlAnalysisLight(new QualityFilter(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, (Option)x$12, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37));
                DateTime startDate = (DateTime)((ControlAnalysisLight)analysis.maxBy((Function1 & Serializable)a -> ((AbstractInstant)a.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now());
                DateTime endDate = (DateTime)((ControlAnalysisLight)analysis.maxBy((Function1 & Serializable)a -> ((AbstractInstant)a.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now());
                Seq<OutlierResult> analysisOutlier = params.outlier().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? this.getOutlier(user, analysis) : (Seq<OutlierResult>)Nil$.MODULE$;
                Seq<ConformityResult> analysisMultiParam = params.multiParam().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? this.getOutlierMultiParam(user, analysis) : (Seq<ConformityResult>)Nil$.MODULE$;
                Seq<ConformityResult> analysisConformity = BoxesRunTime.unboxToBoolean((Object)params.conformitySandre().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? this.getConformity(user, analysis) : (Seq<ConformityResult>)Nil$.MODULE$;
                Seq<ThresholdResult> analysisImprobability = params.improbabilityThreshold().isDefined() ? this.getControledThreshold(analysis, BoxesRunTime.unboxToInt((Object)params.improbabilityThreshold().get()), "ERR.IMPROBABILITY") : (Seq<ThresholdResult>)Nil$.MODULE$;
                Seq<ThresholdResult> analysisImpossibility = params.impossibilityThreshold().isDefined() ? this.getControledThreshold(analysis, BoxesRunTime.unboxToInt((Object)params.impossibilityThreshold().get()), "ERR.IMPOSSIBILITY") : (Seq<ThresholdResult>)Nil$.MODULE$;
                Seq controledAnalysis = (Seq)analysis.map((Function1 & Serializable)analyse -> {
                    Seq foundConformity = (Seq)analysisConformity.find((Function1 & Serializable)conform -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$10(analyse, conform))).map((Function1 & Serializable)c -> c.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq foundOutlier = (Seq)analysisOutlier.find((Function1 & Serializable)out -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$13(analyse, out))).map((Function1 & Serializable)o -> o.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq foundMultiParam = (Seq)analysisMultiParam.find((Function1 & Serializable)conform -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$18(analyse, conform))).map((Function1 & Serializable)c -> c.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq foundImprobability = (Seq)analysisImprobability.find((Function1 & Serializable)impro -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$21(analyse, impro))).map((Function1 & Serializable)o -> o.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq foundImpossibility = (Seq)analysisImpossibility.find((Function1 & Serializable)impro -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$24(analyse, impro))).map((Function1 & Serializable)o -> o.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq errors = (Seq)((IterableOps)((IterableOps)((IterableOps)foundConformity.$plus$plus((IterableOnce)foundOutlier)).$plus$plus((IterableOnce)foundMultiParam)).$plus$plus((IterableOnce)foundImprobability)).$plus$plus((IterableOnce)foundImpossibility);
                    return ControledAnalysis$.MODULE$.toControledAnalysis((ControlAnalysisLight)analyse, (Seq<String>)errors);
                });
                Map groupedControledAnalysis = controledAnalysis.groupBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.qualitometer()));
                groupedControledAnalysis.foreach((Function1 & Serializable)x0$1 -> {
                    ControlController.$anonfun$jobPostControl$28(this, jobExecutionId, params, startDate, endDate, user, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.manageCMSandEmails((Map<Object, Seq<ControledAnalysis>>)groupedControledAnalysis, startDate, endDate, prevJobExecId, jobExecutionId, params, user);
            }
            catch (Exception e) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "Job Failed", this.JobLogUtil.log$default$5());
                this.logUtil.printError((Throwable)e);
                throw e;
            }
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Can't find previous job", "", this.JobLogUtil.log$default$5());
        this.logUtil.error("Can't find previous job", this.logUtil.error$default$2());
    }

    private void manageKos(Seq<ControledAnalysis> kos, String stationCode, long jobExecutionId, PostControlParams params) {
        if (!params.noChangesKo().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && kos.nonEmpty()) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(10).append((Object)(params.autoDeleteKo().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? "Deleting" : "Updating")).append(" ").append(kos.length()).append(" analysis").toString(), stationCode, this.JobLogUtil.log$default$5());
            if (params.autoDeleteKo().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                int res = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)kos.map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)this.qualityDao.deleteAnalysis((Analysis)a)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(40).append(res).append(" unconform analysis deleted with success").toString(), stationCode, this.JobLogUtil.log$default$5());
                return;
            }
            if (params.qualificationKo().nonEmpty() || params.statusKo().nonEmpty()) {
                int res = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)kos.map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)this.controlDao.updateAnalysis(a, params.qualificationKo(), params.statusKo())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(40).append(res).append(" unconform analysis updated with success").toString(), stationCode, this.JobLogUtil.log$default$5());
                return;
            }
            return;
        }
    }

    private void manageTechnicalEvent(Seq<ControledAnalysis> oks, Seq<ControledAnalysis> kos, double stationId, String stationCode, DateTime startDate, DateTime endDate, long jobExecutionId, PostControlParams params, String user) {
        if (params.createThechnicalEvent().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && kos.nonEmpty()) {
            String comment = ((IterableOnceOps)new .colon.colon((Object)new Some((Object)new StringBuilder(55).append("Contr\u00f4le automatique des donn\u00e9es (ex\u00e9cution n\u00b0").append(jobExecutionId).append(") du ").append(DateUtil$.MODULE$.getDateWithHour(startDate)).append(" au ").append(DateUtil$.MODULE$.getDateWithHour(endDate)).toString()), (List)new .colon.colon(oks.nonEmpty() ? new Some((Object)new StringBuilder(19).append(oks.length()).append(" Analyses conformes").toString()) : None$.MODULE$, (List)new .colon.colon(kos.nonEmpty() ? new Some((Object)new StringBuilder(23).append(kos.length()).append(" Analyses non conformes").toString()) : None$.MODULE$, (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).mkString("\n");
            this.controlDao.createTechnicalEvent(stationId, comment, user, jobExecutionId);
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(35).append("Technical event created on station ").append(stationCode).toString(), stationCode, this.JobLogUtil.log$default$5());
            return;
        }
    }

    private void manageCMSandEmails(Map<Object, Seq<ControledAnalysis>> groupedControledAnalysis, DateTime startDate, DateTime endDate, long prevJobExecutionId, long jobExecutionId, PostControlParams params, String user) {
        boolean hasError = groupedControledAnalysis.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$manageCMSandEmails$1(x0$1)));
        if (params.createCMS().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && hasError) {
            if (params.alertDelayDays().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 != 0)) {
                Option<Object> cmsDelay = this.controlDao.getlastCMSDelay(prevJobExecutionId);
                if (cmsDelay.isEmpty() || BoxesRunTime.unboxToInt((Object)cmsDelay.get()) < BoxesRunTime.unboxToInt((Object)params.alertDelayDays().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1))) {
                    String msg = new StringBuilder(47).append("Alert not sent, last one is too close (< ").append(params.alertDelayDays().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)).append(" days)").toString();
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), msg, "", this.JobLogUtil.log$default$5());
                    return;
                }
                this.generateCMS(groupedControledAnalysis, startDate, endDate, prevJobExecutionId, jobExecutionId, params, user);
                return;
            }
            this.generateCMS(groupedControledAnalysis, startDate, endDate, prevJobExecutionId, jobExecutionId, params, user);
            return;
        }
    }

    private void generateCMS(Map<Object, Seq<ControledAnalysis>> groupedControledAnalysis, DateTime startDate, DateTime endDate, long prevJobExecutionId, long jobExecutionId, PostControlParams params, String user) {
        String title = new StringBuilder(73).append("Rapport de contr\u00f4le automatique des analyses (Traitement d'ex\u00e9cution n\u00b0 ").append(prevJobExecutionId).append(")").toString();
        int totalOk = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)groupedControledAnalysis.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ControlController.$anonfun$generateCMS$1(x0$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int totalKo = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)groupedControledAnalysis.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ControlController.$anonfun$generateCMS$3(x0$2)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int totalStations = groupedControledAnalysis.size();
        String resume = new StringBuilder(108).append(totalOk + totalKo).append(" analyses ont \u00e9t\u00e9 cont\u00f4l\u00e9, du ").append(DateUtil$.MODULE$.getDateWithHour(startDate)).append(" au ").append(DateUtil$.MODULE$.getDateWithHour(endDate)).append(", sur un total de ").append(totalStations).append(" stations (").append(totalOk).append(" Analyses conformes, ").append(totalKo).append(" Analyses non conformes)").toString();
        String content = ((IterableOnceOps)groupedControledAnalysis.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                double stationId = tuple2._1$mcD$sp();
                Seq controledAnalysis = (Seq)tuple2._2();
                Option station = $this.qualitometerDao.get((int)stationId);
                int nbOk = controledAnalysis.count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$generateCMS$6(x$8)));
                int nbKo = controledAnalysis.count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$generateCMS$7(x$9)));
                return new StringBuilder(68).append("[").append(((Qualitometer)station.get()).code()).append("] ").append(((Qualitometer)station.get()).name().getOrElse((Function0 & Serializable)() -> "")).append(" : <br/>").append(controledAnalysis.length()).append(" analyses -> ").append(nbOk).append(" Analyses conformes, ").append(nbKo).append(" Analyses non conformes").toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("<br/><br/>");
        DateTime now = new DateTime();
        CmsInput cms = new CmsInput(title, (Option)None$.MODULE$, BoxesRunTime.unboxToInt((Object)params.cmsCategory().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("CMS category is undefined.");
        })), (Option)new Some((Object)new StringBuilder(20).append(title).append("<br/><br/>").append(resume).append("<br/><br/>").append(content).toString()), (Option)new Some((Object)user), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some(params.cmsStatus().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("CMS statut is undefined.");
        })), (Option)new Some((Object)now), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)now), (Option)None$.MODULE$, (Option)new Some((Object)user), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)user), (Seq)Nil$.MODULE$, params.sendEmail(), params.emails().map((Function1 & Serializable)e -> Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(e), ';'))), CmsInput$.MODULE$.apply$default$25(), CmsInput$.MODULE$.apply$default$26(), CmsInput$.MODULE$.apply$default$27(), CmsInput$.MODULE$.apply$default$28(), CmsInput$.MODULE$.apply$default$29(), CmsInput$.MODULE$.apply$default$30());
        RPCResult res = this.sendCMS(cms);
        if (BoxesRunTime.unboxToInt((Object)res.insert().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) <= 0) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while creating CMS", "", this.JobLogUtil.log$default$5());
            return;
        }
        String cmsUrl = new StringBuilder(13).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> {
            throw new Exception("APPLICATION_URL is not in env");
        })).append("/#/contents/").append(params.cmsCategory().get()).append("/").append(res.id().get()).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.LINK(), new StringBuilder(14).append("CMS created : ").append(cmsUrl).toString(), "", this.JobLogUtil.log$default$5());
    }

    private RPCResult sendCMS(CmsInput cmsInput) {
        return (RPCResult)Await$.MODULE$.result((Awaitable)JobLogUtil$.MODULE$.sendRPC(CmsRouting$.MODULE$.CMS_CREATE(), Json$.MODULE$.toJson((Object)cmsInput, (Writes)CmsInput$.MODULE$.cmsInputRead()).toString(), (Reads)RPCResult$.MODULE$.rpcResultFormat(), ClassTag$.MODULE$.apply(RPCResult.class)), (Duration)Duration$.MODULE$.Inf());
    }

    public String controlAllAnalysis(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ControlParameters$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get controled analysis:\n").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Seq<ControlAnalysisLight> analysis = $this.qualitySpecificDao.getControlAnalysisLight(params.filters());
            Seq<OutlierResult> analysisOutlier = BoxesRunTime.unboxToBoolean((Object)params.outlier().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? this.getOutlier(params.user(), analysis) : (Seq<OutlierResult>)Nil$.MODULE$;
            Seq<ConformityResult> analysisConformity = BoxesRunTime.unboxToBoolean((Object)params.conformitySandre().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? this.getConformity(params.user(), analysis) : (Seq<ConformityResult>)Nil$.MODULE$;
            Seq<ConformityResult> analysisMultiParam = params.multiParam().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? this.getOutlierMultiParam(params.user(), analysis) : (Seq<ConformityResult>)Nil$.MODULE$;
            Seq<ThresholdResult> analysisImprobability = params.improbabilityThreshold().isDefined() ? this.getControledThreshold(analysis, BoxesRunTime.unboxToInt((Object)params.improbabilityThreshold().get()), "ERR.IMPROBABILITY") : (Seq<ThresholdResult>)Nil$.MODULE$;
            Seq<ThresholdResult> analysisImpossibility = params.impossibilityThreshold().isDefined() ? this.getControledThreshold(analysis, BoxesRunTime.unboxToInt((Object)params.impossibilityThreshold().get()), "ERR.IMPOSSIBILITY") : (Seq<ThresholdResult>)Nil$.MODULE$;
            Seq controledAnalysis = (Seq)analysis.map((Function1 & Serializable)analyse -> {
                Seq foundConformity = (Seq)analysisConformity.find((Function1 & Serializable)conform -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$controlAllAnalysis$6(analyse, conform))).map((Function1 & Serializable)c -> c.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                Seq foundOutlier = (Seq)analysisOutlier.find((Function1 & Serializable)out -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$controlAllAnalysis$9(analyse, out))).map((Function1 & Serializable)o -> o.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                Seq foundMultiParam = (Seq)analysisMultiParam.find((Function1 & Serializable)conform -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$controlAllAnalysis$14(analyse, conform))).map((Function1 & Serializable)c -> c.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                Seq foundImprobability = (Seq)analysisImprobability.find((Function1 & Serializable)impro -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$controlAllAnalysis$17(analyse, impro))).map((Function1 & Serializable)o -> o.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                Seq foundImpossibility = (Seq)analysisImpossibility.find((Function1 & Serializable)impro -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$controlAllAnalysis$20(analyse, impro))).map((Function1 & Serializable)o -> o.errors()).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                Seq errors = (Seq)((IterableOps)((IterableOps)((IterableOps)foundConformity.$plus$plus((IterableOnce)foundOutlier)).$plus$plus((IterableOnce)foundMultiParam)).$plus$plus((IterableOnce)foundImprobability)).$plus$plus((IterableOnce)foundImpossibility);
                return ControledAnalysis$.MODULE$.toControledAnalysis((ControlAnalysisLight)analyse, (Seq<String>)errors);
            });
            return new StringBuilder(2).append("[").append(((IterableOnceOps)controledAnalysis.map((Function1 & Serializable)a -> StringUtil$.MODULE$.stringify(a.toLight()))).mkString(",")).append("]").toString();
        });
    }

    private Seq<ConformityResult> getConformity(String user, Seq<ControlAnalysisLight> analysis) {
        if (analysis.nonEmpty()) {
            return this.iaEauDao.getConformityResult(user, analysis, this.logUtil, this.ws);
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<OutlierResult> getOutlier(String user, Seq<ControlAnalysisLight> stationsAnalysis) {
        .colon.colon filterRemarks = new .colon.colon((Object)"0", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"5", (List)new .colon.colon((Object)"7", (List)new .colon.colon((Object)"10", (List)Nil$.MODULE$))))));
        return (Seq)((IterableOps)stationsAnalysis.filter(arg_0 -> ControlController.$anonfun$getOutlier$1$adapted((Seq)filterRemarks, arg_0))).groupBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10.qualitometer())).values().toSeq().flatMap((Function1 & Serializable)analysis -> {
            Option x$37;
            Option x$36;
            Option x$35;
            Option x$34;
            Option x$33;
            Option x$32;
            Option x$31;
            Option x$30;
            Option x$29;
            Option x$28;
            Option x$27;
            Option x$26;
            Option x$25;
            Option x$24;
            Option x$23;
            Option x$22;
            Option x$21;
            Option x$20;
            Option x$19;
            Option x$18;
            Option x$17;
            Option x$16;
            Option x$15;
            Option x$14;
            Option x$13;
            Option x$12;
            Option x$11;
            Option x$10;
            Option x$9;
            Option x$8;
            Option x$7;
            Option x$6;
            Option x$5;
            Seq parameterCodes = (Seq)((SeqOps)((SeqOps)analysis.map((Function1 & Serializable)analyse -> (String)analyse.parameter().get())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
            DateTime date = (DateTime)((ControlAnalysisLight)analysis.minBy((Function1 & Serializable)a -> ((AbstractInstant)a.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now());
            double qualito = ((ControlAnalysisLight)analysis.head()).qualitometer();
            Some x$1 = new Some((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{(int)qualito})));
            Some x$2 = new Some((Object)date);
            Some x$3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Option x$4 = QualityFilter$.MODULE$.apply$default$2();
            Seq<ControlAnalysisLight> prevAnalysis = $this.qualitySpecificDao.getControlAnalysisLight(new QualityFilter((Option)x$1, x$4, x$5 = QualityFilter$.MODULE$.apply$default$3(), x$6 = QualityFilter$.MODULE$.apply$default$4(), x$7 = QualityFilter$.MODULE$.apply$default$5(), x$8 = QualityFilter$.MODULE$.apply$default$6(), x$9 = QualityFilter$.MODULE$.apply$default$7(), x$10 = QualityFilter$.MODULE$.apply$default$8(), x$11 = QualityFilter$.MODULE$.apply$default$9(), x$12 = QualityFilter$.MODULE$.apply$default$10(), x$13 = QualityFilter$.MODULE$.apply$default$11(), x$14 = QualityFilter$.MODULE$.apply$default$12(), x$15 = QualityFilter$.MODULE$.apply$default$13(), (Option)x$3, x$16 = QualityFilter$.MODULE$.apply$default$15(), x$17 = QualityFilter$.MODULE$.apply$default$16(), x$18 = QualityFilter$.MODULE$.apply$default$17(), x$19 = QualityFilter$.MODULE$.apply$default$18(), x$20 = QualityFilter$.MODULE$.apply$default$19(), x$21 = QualityFilter$.MODULE$.apply$default$20(), (Option)x$2, x$22 = QualityFilter$.MODULE$.apply$default$22(), x$23 = QualityFilter$.MODULE$.apply$default$23(), x$24 = QualityFilter$.MODULE$.apply$default$24(), x$25 = QualityFilter$.MODULE$.apply$default$25(), x$26 = QualityFilter$.MODULE$.apply$default$26(), x$27 = QualityFilter$.MODULE$.apply$default$27(), x$28 = QualityFilter$.MODULE$.apply$default$28(), x$29 = QualityFilter$.MODULE$.apply$default$29(), x$30 = QualityFilter$.MODULE$.apply$default$30(), x$31 = QualityFilter$.MODULE$.apply$default$31(), x$32 = QualityFilter$.MODULE$.apply$default$32(), x$33 = QualityFilter$.MODULE$.apply$default$33(), x$34 = QualityFilter$.MODULE$.apply$default$34(), x$35 = QualityFilter$.MODULE$.apply$default$35(), x$36 = QualityFilter$.MODULE$.apply$default$36(), x$37 = QualityFilter$.MODULE$.apply$default$37()));
            if (prevAnalysis.nonEmpty()) {
                return $this.iaEauDao.getOutlierResult(user, (Seq<ControlAnalysisLight>)analysis, prevAnalysis, (Seq<String>)parameterCodes, qualito, $this.logUtil, $this.ws);
            }
            return Nil$.MODULE$;
        });
    }

    private Seq<ConformityResult> getOutlierMultiParam(String user, Seq<ControlAnalysisLight> analysis) {
        if (analysis.nonEmpty()) {
            return this.iaEauDao.getOutlierMultiParamResult(user, analysis, this.logUtil, this.ws);
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<ThresholdResult> getControledThreshold(Seq<ControlAnalysisLight> analysis, int threshold, String codeError) {
        .colon.colon filterRemarks = new .colon.colon((Object)"0", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"7", (List)new .colon.colon((Object)"10", (List)Nil$.MODULE$))));
        Seq thresholds = this.thresholdDao.findParameterThresholds(threshold, (Option)new Some((Object)"0"));
        return (Seq)((IterableOps)analysis.filter(arg_0 -> ControlController.$anonfun$getControledThreshold$1$adapted((Seq)filterRemarks, arg_0))).map((Function1 & Serializable)a -> {
            Object object = a.remark().getOrElse((Function0 & Serializable)() -> "1");
            String string = "3";
            if (!(object != null ? !object.equals(string) : string != null)) {
                return new ThresholdResult(a.id(), (Seq<String>)new .colon.colon((Object)codeError, (List)Nil$.MODULE$));
            }
            Option option = QualityThresholdUtil$.MODULE$.getThreshold(thresholds, (Analysis)a);
            if (option instanceof Some) {
                Some some = (Some)option;
                ParameterThreshold th = (ParameterThreshold)some.value();
                int indice = QualityThresholdUtil$.MODULE$.calculateIndexThreshold((Analysis)a, th);
                if (indice > 0) {
                    return new ThresholdResult(a.id(), (Seq<String>)new .colon.colon((Object)codeError, (List)Nil$.MODULE$));
                }
                return new ThresholdResult(a.id(), (Seq<String>)((Seq)Nil$.MODULE$));
            }
            return new ThresholdResult(a.id(), (Seq<String>)((Seq)Nil$.MODULE$));
        });
    }

    public static final /* synthetic */ boolean $anonfun$jobPostControl$10(ControlAnalysisLight analyse$1, ConformityResult conform) {
        return conform.stationId() == analyse$1.qualitometer() && conform.numAnalyse() == (double)analyse$1.id() && conform.numSample() == analyse$1.sample();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$jobPostControl$13(ControlAnalysisLight analyse$1, OutlierResult out) {
        if (out.qualitometer() != analyse$1.qualitometer()) return false;
        String string = out.parameter();
        Object object = analyse$1.parameter().getOrElse((Function0 & Serializable)() -> "");
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        if (out.date().toDate().getTime() != ((AbstractInstant)analyse$1.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate().getTime()) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$jobPostControl$18(ControlAnalysisLight analyse$1, ConformityResult conform) {
        return conform.stationId() == analyse$1.qualitometer() && conform.numAnalyse() == (double)analyse$1.id() && conform.numSample() == analyse$1.sample();
    }

    public static final /* synthetic */ boolean $anonfun$jobPostControl$21(ControlAnalysisLight analyse$1, ThresholdResult impro) {
        return impro.id() == analyse$1.id();
    }

    public static final /* synthetic */ boolean $anonfun$jobPostControl$24(ControlAnalysisLight analyse$1, ThresholdResult impro) {
        return impro.id() == analyse$1.id();
    }

    public static final /* synthetic */ boolean $anonfun$jobPostControl$30(ControledAnalysis x$2) {
        return x$2.errors().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$jobPostControl$31(ControledAnalysis x$3) {
        return x$3.errors().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$jobPostControl$28(ControlController $this, long jobExecutionId$1, PostControlParams params$1, DateTime startDate$1, DateTime endDate$1, String user$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double stationId = tuple2._1$mcD$sp();
            Seq stationAnalysis = (Seq)tuple2._2();
            String stationCode = (String)$this.qualitometerDao.getBSSCode(stationId).getOrElse((Function0 & Serializable)() -> "");
            Seq controledOk = (Seq)stationAnalysis.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$30(x$2)));
            Seq controledKos = (Seq)stationAnalysis.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$jobPostControl$31(x$3)));
            if (controledKos.isEmpty()) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), "All analysis are conform", stationCode, $this.JobLogUtil.log$default$5());
            } else {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(19).append(controledKos.length()).append(" unconform analysis").toString(), stationCode, $this.JobLogUtil.log$default$5());
            }
            $this.manageKos((Seq<ControledAnalysis>)controledKos, stationCode, jobExecutionId$1, params$1);
            $this.manageTechnicalEvent((Seq<ControledAnalysis>)controledOk, (Seq<ControledAnalysis>)controledKos, stationId, stationCode, startDate$1, endDate$1, jobExecutionId$1, params$1, user$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$manageCMSandEmails$2(ControledAnalysis x$4) {
        return x$4.errors().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$manageCMSandEmails$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq controledAnalysis = (Seq)tuple2._2();
            return controledAnalysis.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$manageCMSandEmails$2(x$4)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateCMS$2(ControledAnalysis x$6) {
        return x$6.errors().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$generateCMS$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq controledAnalysis = (Seq)tuple2._2();
            return controledAnalysis.count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$generateCMS$2(x$6)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateCMS$4(ControledAnalysis x$7) {
        return x$7.errors().nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$generateCMS$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Seq controledAnalysis = (Seq)tuple2._2();
            return controledAnalysis.count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$generateCMS$4(x$7)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateCMS$6(ControledAnalysis x$8) {
        return x$8.errors().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateCMS$7(ControledAnalysis x$9) {
        return x$9.errors().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$controlAllAnalysis$6(ControlAnalysisLight analyse$2, ConformityResult conform) {
        return conform.stationId() == analyse$2.qualitometer() && conform.numAnalyse() == (double)analyse$2.id() && conform.numSample() == analyse$2.sample();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$controlAllAnalysis$9(ControlAnalysisLight analyse$2, OutlierResult out) {
        if (out.qualitometer() != analyse$2.qualitometer()) return false;
        String string = out.parameter();
        Object object = analyse$2.parameter().getOrElse((Function0 & Serializable)() -> "");
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        if (out.date().toDate().getTime() != ((AbstractInstant)analyse$2.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate().getTime()) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$controlAllAnalysis$14(ControlAnalysisLight analyse$2, ConformityResult conform) {
        return conform.stationId() == analyse$2.qualitometer() && conform.numAnalyse() == (double)analyse$2.id() && conform.numSample() == analyse$2.sample();
    }

    public static final /* synthetic */ boolean $anonfun$controlAllAnalysis$17(ControlAnalysisLight analyse$2, ThresholdResult impro) {
        return impro.id() == analyse$2.id();
    }

    public static final /* synthetic */ boolean $anonfun$controlAllAnalysis$20(ControlAnalysisLight analyse$2, ThresholdResult impro) {
        return impro.id() == analyse$2.id();
    }

    public static final /* synthetic */ boolean $anonfun$getOutlier$1(Seq filterRemarks$1, ControlAnalysisLight a) {
        return a.parameter().isDefined() && a.result().isDefined() && !filterRemarks$1.contains(a.remark().getOrElse((Function0 & Serializable)() -> "1"));
    }

    public static final /* synthetic */ boolean $anonfun$getControledThreshold$1(Seq filterRemarks$2, ControlAnalysisLight a) {
        return a.remark().isEmpty() || !filterRemarks$2.contains(a.remark().get());
    }

    @Inject
    public ControlController(LogUtil logUtil, QualityDao qualityDao, QualitySpecificDao qualitySpecificDao, IAEauDao iaEauDao, QualitometerDao qualitometerDao, ThresholdDao thresholdDao, JobDao jobDao, ControlDao controlDao, JobLogUtil JobLogUtil2, WSClient ws) {
        this.logUtil = logUtil;
        this.qualityDao = qualityDao;
        this.qualitySpecificDao = qualitySpecificDao;
        this.iaEauDao = iaEauDao;
        this.qualitometerDao = qualitometerDao;
        this.thresholdDao = thresholdDao;
        this.jobDao = jobDao;
        this.controlDao = controlDao;
        this.JobLogUtil = JobLogUtil2;
        this.ws = ws;
    }

    public static final /* synthetic */ Object $anonfun$getOutlier$1$adapted(Seq filterRemarks$1, ControlAnalysisLight a) {
        return BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$getOutlier$1(filterRemarks$1, a));
    }

    public static final /* synthetic */ Object $anonfun$getControledThreshold$1$adapted(Seq filterRemarks$2, ControlAnalysisLight a) {
        return BoxesRunTime.boxToBoolean((boolean)ControlController.$anonfun$getControledThreshold$1(filterRemarks$2, a));
    }
}

