/*
 * Decompiled with CFR 0.152.
 */
package controllers.integrationOverview;

import controllers.integrationOverview.AnalyseConformity;
import controllers.integrationOverview.AnalyseConformityInput;
import controllers.integrationOverview.AnalyseConformityInput$;
import controllers.integrationOverview.AnalyseConformityOutput$;
import controllers.integrationOverview.StationConformity;
import controllers.integrationOverview.new.IntegrationOverviewCriterias;
import controllers.integrationOverview.new.IntegrationOverviewCriterias$;
import dao.itf.IntegrationOverviewDao;
import dao.rpc.IAEauDao;
import domain.input.ConformityFilter;
import domain.input.ConformityFilter$;
import fr.aquasys.daeau.cms.domain.input.CmsInput;
import fr.aquasys.daeau.cms.domain.input.CmsInput$;
import fr.aquasys.daeau.cms.itf.CmsDao;
import fr.aquasys.daeau.job.itf.JobDao;
import fr.aquasys.daeau.job.model.Job;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.referentials.parameter.domain.ParameterLight;
import fr.aquasys.daeau.referentials.parameter.itf.ParameterDao;
import fr.aquasys.daeau.referentials.unit.itf.UnitDao;
import fr.aquasys.daeau.referentials.unit.model.UnitLight;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.StringUtil$;
import jakarta.inject.Inject;
import java.io.Serializable;
import model.AnalyseResult;
import model.AnalysisControl$;
import model.ConformityResult;
import model.JobOutlier;
import model.JobOutlier$;
import model.OutlierResult;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\tme\u0001\u0002\r\u001a\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006YA\n\u0005\te\u0001\u0011\t\u0011)A\u0006g!AQ\b\u0001B\u0001B\u0003-a\b\u0003\u0005F\u0001\t\u0005\t\u0015a\u0003G\u0011!a\u0005A!A!\u0002\u0017i\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u0011y\u0003!\u0011!Q\u0001\f}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ya\u001a\u0005\t]\u0002\u0011\t\u0011)A\u0006_\")!\u0010\u0001C\u0001w\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!#\u0001\t\u0003\tY\tC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u00111\u001e\u0001\u0005\u0002\u00055\bb\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqAa\u001a\u0001\t\u0003\u0011I\u0007C\u0004\u0003\u0010\u0002!\tA!%\u0003;%sG/Z4sCRLwN\\(wKJ4\u0018.Z<D_:$(o\u001c7mKJT!AG\u000e\u0002'%tG/Z4sCRLwN\\(wKJ4\u0018.Z<\u000b\u0003q\t1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fM\u00069An\\4Vi&d\u0007CA\u00141\u001b\u0005A#BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0005-b\u0013\u0001\u0003:bE\nLG/\\9\u000b\u00055r\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002_\u0005\u0011aM]\u0005\u0003c!\u0012q\u0001T8h+RLG.\u0001\u0004d[N$\u0015m\u001c\t\u0003imj\u0011!\u000e\u0006\u0003m]\n1!\u001b;g\u0015\tA\u0014(A\u0002d[NT!A\u000f\u0017\u0002\u000b\u0011\fW-Y;\n\u0005q*$AB\"ng\u0012\u000bw.\u0001\fj]R,wM]1uS>twJ^3sm&,w\u000fR1p!\ty4)D\u0001A\u0015\t1\u0014IC\u0001C\u0003\r!\u0017m\\\u0005\u0003\t\u0002\u0013a#\u00138uK\u001e\u0014\u0018\r^5p]>3XM\u001d<jK^$\u0015m\\\u0001\tS\u0006,\u0015-\u001e#b_B\u0011qIS\u0007\u0002\u0011*\u0011\u0011*Q\u0001\u0004eB\u001c\u0017BA&I\u0005!I\u0015)R1v\t\u0006|\u0017\u0001\u00049be\u0006lW\r^3s\t\u0006|\u0007C\u0001(U\u001b\u0005y%B\u0001\u001cQ\u0015\t\t&+A\u0005qCJ\fW.\u001a;fe*\u00111+O\u0001\re\u00164WM]3oi&\fGn]\u0005\u0003+>\u0013A\u0002U1sC6,G/\u001a:EC>\fq\"];bY&$x.\\3uKJ$\u0015m\u001c\t\u00031rk\u0011!\u0017\u0006\u0003miS!aW\u001d\u0002\u000fE,\u0018\r\\5us&\u0011Q,\u0017\u0002\u0010#V\fG.\u001b;p[\u0016$XM\u001d#b_\u00061!n\u001c2EC>\u0004\"\u0001\u00193\u000e\u0003\u0005T!A\u000e2\u000b\u0005\rL\u0014a\u00016pE&\u0011Q-\u0019\u0002\u0007\u0015>\u0014G)Y8\u0002\u000fUt\u0017\u000e\u001e#b_B\u0011\u0001\u000e\\\u0007\u0002S*\u0011aG\u001b\u0006\u0003WJ\u000bA!\u001e8ji&\u0011Q.\u001b\u0002\b+:LG\u000fR1p\u0003\t98\u000f\u0005\u0002qq6\t\u0011O\u0003\u0002oe*\u00111\u000f^\u0001\u0005Y&\u00147O\u0003\u0002vm\u0006\u0019\u0011\r]5\u000b\u0003]\fA\u0001\u001d7bs&\u0011\u00110\u001d\u0002\t/N\u001bE.[3oi\u00061A(\u001b8jiz\"\u0012\u0001 \u000b\u0013{~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty\u0001\u0005\u0002\u007f\u00015\t\u0011\u0004C\u0003&\u0015\u0001\u000fa\u0005C\u00033\u0015\u0001\u000f1\u0007C\u0003>\u0015\u0001\u000fa\bC\u0003F\u0015\u0001\u000fa\tC\u0003M\u0015\u0001\u000fQ\nC\u0003W\u0015\u0001\u000fq\u000bC\u0003_\u0015\u0001\u000fq\fC\u0003g\u0015\u0001\u000fq\rC\u0003o\u0015\u0001\u000fq\u000eK\u0002\u000b\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003;\tqA[1lCJ$\u0018-\u0003\u0003\u0002\"\u0005]!AB%oU\u0016\u001cG/A\u000fhKRLe\u000e^3he\u0006$\u0018n\u001c8Pm\u0016\u0014h/[3x%\u0016\u001cX\u000f\u001c;t))\t9#!\u0010\u0002N\u0005u\u0013\u0011\r\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017C5\u0011\u0011q\u0006\u0006\u0004\u0003ci\u0012A\u0002\u001fs_>$h(C\u0002\u00026\u0005\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001bC!9\u0011qH\u0006A\u0002\u0005\u0005\u0013aB7fgN\fw-\u001a\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t:\u0002\t)\u001cxN\\\u0005\u0005\u0003\u0017\n)EA\u0004KgZ\u000bG.^3\t\u000f\u0005=3\u00021\u0001\u0002R\u00059\u0001.Z1eKJ\u001c\b\u0003CA\u0015\u0003'\n9#a\u0016\n\t\u0005U\u00131\b\u0002\u0004\u001b\u0006\u0004\bc\u0001\u0011\u0002Z%\u0019\u00111L\u0011\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002`-\u0001\r!a\n\u0002\r5|G-\u001e7f\u0011\u001d\t\u0019g\u0003a\u0001\u0003O\tA!^:fe\u0006)r-\u001a;BY2\fe.\u00197zg&\u001c8i\u001c8ue>dGCCA\u0014\u0003S\nY'!\u001c\u0002p!9\u0011q\b\u0007A\u0002\u0005\u0005\u0003bBA(\u0019\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003?b\u0001\u0019AA\u0014\u0011\u001d\t\u0019\u0007\u0004a\u0001\u0003O\t\u0001$\u001e9eCR,\u0017I\\1msNL7oQ8oM>\u0014X.\u001b;z))\t9#!\u001e\u0002x\u0005e\u00141\u0010\u0005\b\u0003\u007fi\u0001\u0019AA!\u0011\u001d\ty%\u0004a\u0001\u0003#Bq!a\u0018\u000e\u0001\u0004\t9\u0003C\u0004\u0002d5\u0001\r!a\n\u00021\u001d,G/\u00117m\u0003:\fG._:jg\u000e{gNZ8s[&$\u0018\u0010\u0006\u0006\u0002(\u0005\u0005\u00151QAC\u0003\u000fCq!a\u0010\u000f\u0001\u0004\t\t\u0005C\u0004\u0002P9\u0001\r!!\u0015\t\u000f\u0005}c\u00021\u0001\u0002(!9\u00111\r\bA\u0002\u0005\u001d\u0012\u0001E8mI\u001e+GoQ8oM>\u0014X.\u001b;z)!\ti)a+\u0002.\u0006e\u0006CBAH\u00033\u000byJ\u0004\u0003\u0002\u0012\u0006Ue\u0002BA\u0017\u0003'K\u0011AI\u0005\u0004\u0003/\u000b\u0013a\u00029bG.\fw-Z\u0005\u0005\u00037\u000biJA\u0002TKFT1!a&\"!\u0011\t\t+a*\u000e\u0005\u0005\r&BAAS\u0003\u0015iw\u000eZ3m\u0013\u0011\tI+a)\u0003!\r{gNZ8s[&$\u0018PU3tk2$\bbBA2\u001f\u0001\u0007\u0011q\u0005\u0005\b\u0003_{\u0001\u0019AAY\u0003!\tg.\u00197zg&\u001c\bCBAH\u00033\u000b\u0019\fE\u0002\u007f\u0003kK1!a.\u001a\u0005E\te.\u00197zg\u0016\u001cuN\u001c4pe6LG/\u001f\u0005\b\u0003w{\u0001\u0019AA_\u0003A\u0019wN\u001c4pe6LG/_*b]\u0012\u0014X\rE\u0003!\u0003\u007f\u000b\u0019-C\u0002\u0002B\u0006\u0012aa\u00149uS>t\u0007c\u0001\u0011\u0002F&\u0019\u0011qY\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\u0001r\u000e\u001c3HKRlU\u000f\u001c;j!\u0006\u0014\u0018-\u001c\u000b\t\u0003\u001b\u000bi-a4\u0002R\"9\u00111\r\tA\u0002\u0005\u001d\u0002bBAX!\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003'\u0004\u0002\u0019AA_\u0003)iW\u000f\u001c;j!\u0006\u0014\u0018-\\\u0001\u000e_2$w)\u001a;PkRd\u0017.\u001a:\u0015\u0011\u0005e\u0017\u0011]Ar\u0003O\u0004b!a$\u0002\u001a\u0006m\u0007\u0003BAQ\u0003;LA!a8\u0002$\niq*\u001e;mS\u0016\u0014(+Z:vYRDq!a\u0019\u0012\u0001\u0004\t9\u0003C\u0004\u0002fF\u0001\r!!-\u0002!M$\u0018\r^5p]N\fe.\u00197zg&\u001c\bbBAu#\u0001\u0007\u0011QX\u0001\t_V$H.[3sg\u0006\tr.\u001e;mS\u0016\u0014\u0018+^1mSRL(j\u001c2\u0015\t\u0005=\u0018Q\u001f\t\u0004A\u0005E\u0018bAAzC\t!QK\\5u\u0011\u001d\t9P\u0005a\u0001\u0003s\f\u0001B[8c\u0013:\u0004X\u000f\u001e\t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*\u0019\u0011q \u0016\u0002\r\u0011|W.Y5o\u0013\u0011\u0011\u0019!!@\u0003\u0011){'-\u00138qkR\f\u0011bZ3u\u001d\u0016<8)\\:\u00155\t%!q\u0003B\u0011\u0005K\u0011IC!\f\u00032\tM\"Q\bB!\u0005\u000b\u0012IE!\u0014\u0011\t\t-!1C\u0007\u0003\u0005\u001bQAAa\u0004\u0003\u0012\u0005)\u0011N\u001c9vi*\u0019\u0011q`\u001c\n\t\tU!Q\u0002\u0002\t\u00076\u001c\u0018J\u001c9vi\"9!\u0011D\nA\u0002\tm\u0011!\u00038c'\u0006l\u0007\u000f\\3t!\r\u0001#QD\u0005\u0004\u0005?\t#aA%oi\"9!1E\nA\u0002\tm\u0011A\u00038c\u0003:\fG._:jg\"9!qE\nA\u0002\u0005e\u0017aC1mY>+H\u000f\\5feNDqAa\u000b\u0014\u0001\u0004\ti)A\nbY2\u001cuN\u001c4pe6LG/_#se>\u00148\u000fC\u0004\u00030M\u0001\r!!-\u0002\u0017\u0005dG.\u00118bYf\u001c\u0018n\u001d\u0005\b\u0003G\u001a\u0002\u0019AA\u0014\u0011\u001d\u0011)d\u0005a\u0001\u0005o\taB[8c\u000bb,7-\u001e;j_:LE\rE\u0002!\u0005sI1Aa\u000f\"\u0005\u0011auN\\4\t\u000f\t}2\u00031\u0001\u0002(\u0005A!n\u001c2USRdW\rC\u0004\u0003DM\u0001\rAa\u0007\u0002\u0017\rl7oQ1uK\u001e|'/\u001f\u0005\b\u0005\u000f\u001a\u0002\u0019\u0001B\u000e\u0003%\u0019Wn]*uCR,8\u000fC\u0004\u0003LM\u0001\rAa\u000e\u0002%QD\u0017n\u001d&pE\u0016CXmY;uS>t\u0017\n\u001a\u0005\b\u0005\u001f\u001a\u0002\u0019AA\u0014\u0003\r)(\u000f\\\u0001\u0016O\u0016$8i\u001c8g_Jl\u0017\u000e^=B]\u0006d\u0017p]5t)\u0019\u0011)Fa\u0016\u0003ZA)\u0001%a0\u00024\"9!q\u0006\u000bA\u0002\u0005E\u0006b\u0002B.)\u0001\u0007\u0011qT\u0001\u0011G>tgm\u001c:nSRL(+Z:vYR\f!cZ3u\u001fV$H.[3s\u0003:\fG._:jgR1!Q\u000bB1\u0005GBqAa\f\u0016\u0001\u0004\t\t\fC\u0004\u0003fU\u0001\r!a7\u0002\u000f=,H\u000f\\5fe\u0006\u0001\u0012M\\1msNL7\u000fV8TiJLgn\u001a\u000b\t\u0003O\u0011YGa\u001c\u0003\u0000!9!Q\u000e\fA\u0002\u0005M\u0016aA1oC\"9!\u0011\u000f\fA\u0002\tM\u0014A\u00039be\u0006lW\r^3sgBA\u0011\u0011FA*\u0003O\u0011)\b\u0005\u0003\u0003x\tmTB\u0001B=\u0015\r\ty\u0010U\u0005\u0005\u0005{\u0012IH\u0001\bQCJ\fW.\u001a;fe2Kw\r\u001b;\t\u000f\t\u0005e\u00031\u0001\u0003\u0004\u0006)QO\\5ugBA\u0011\u0011FA*\u0003O\u0011)\t\u0005\u0003\u0003\b\n-UB\u0001BE\u0015\r\t)K[\u0005\u0005\u0005\u001b\u0013IIA\u0005V]&$H*[4ii\u0006iq-\u001a;FeJ|'\u000fT1cK2$b!a\n\u0003\u0014\n]\u0005b\u0002BK/\u0001\u0007!1D\u0001\n]\n|U\u000f\u001e7jKJDqA!'\u0018\u0001\u0004\u0011Y\"\u0001\u0007oE\u000e{gNZ8s[&$\u0018\u0010")
public class IntegrationOverviewController {
    private final LogUtil logUtil;
    private final CmsDao cmsDao;
    private final IntegrationOverviewDao integrationOverviewDao;
    private final IAEauDao iaEauDao;
    private final ParameterDao parameterDao;
    private final QualitometerDao qualitometerDao;
    private final JobDao jobDao;
    private final UnitDao unitDao;
    private final WSClient ws;

    public String getIntegrationOverviewResults(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(IntegrationOverviewCriterias$.MODULE$.reads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(16).append("Bad criterias : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)criterias -> {
            String overview = ((IterableOnceOps)$this.integrationOverviewDao.getOperationsOverview((IntegrationOverviewCriterias)criterias).map((Function1 & Serializable)q -> StringUtil$.MODULE$.stringify(q.toLight()))).mkString(",");
            String stats = ((IterableOnceOps)$this.integrationOverviewDao.getOperationsOverviewStats((IntegrationOverviewCriterias)criterias).map((Function1 & Serializable)q -> StringUtil$.MODULE$.stringify(q.toLight()))).mkString(",");
            return new StringBuilder(31).append("{ \"overview\": [").append(overview).append("], \"stats\": [").append(stats).append("] }").toString();
        });
    }

    public String getAllAnalysisControl(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.integrationOverviewDao.getAllAnalysisControl(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), AnalysisControl$.MODULE$.analysisControlWrites())).toString();
    }

    public String updateAnalysisConformity(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(AnalyseConformityInput$.MODULE$.inputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(51).append("Error validate Json to update analysis conformity:\n").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)analysis -> Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.integrationOverviewDao.updateAnalysis((scala.collection.immutable.Seq<AnalyseConformityInput>)analysis)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String getAllAnalysisConformity(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ConformityFilter$.MODULE$.operationsRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate Json to get conformity filter:\n").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            ConformityFilter filter = (ConformityFilter)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)filter);
            String user2 = (String)tuple22._1();
            ConformityFilter filter2 = (ConformityFilter)tuple22._2();
            scala.collection.immutable.Seq<AnalyseConformity> stationsAnalysis = $this.integrationOverviewDao.getAnalysis(filter2);
            scala.collection.immutable.Seq<OutlierResult> outlier = this.oldGetOutlier(user2, stationsAnalysis, filter2.outliers());
            scala.collection.immutable.Seq<ConformityResult> conformity = this.oldGetConformity(user2, stationsAnalysis, filter2.conformitySandre());
            scala.collection.immutable.Seq<ConformityResult> multiParam = this.oldGetMultiParam(user2, stationsAnalysis, filter2.multiParam());
            scala.collection.immutable.Seq analyseReturnFormat = (scala.collection.immutable.Seq)stationsAnalysis.map((Function1 & Serializable)analyse -> {
                Option foundConformity = conformity.find((Function1 & Serializable)conform -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$getAllAnalysisConformity$4(analyse, conform))).map((Function1 & Serializable)c -> c.errors());
                Option foundOutlier = outlier.find((Function1 & Serializable)out -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$getAllAnalysisConformity$6(analyse, out))).map((Function1 & Serializable)o -> o.errors());
                Option foundMultiParam = multiParam.find((Function1 & Serializable)conform -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$getAllAnalysisConformity$10(analyse, conform))).map((Function1 & Serializable)c -> c.errors());
                scala.collection.immutable.Seq errors = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)foundConformity.getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)foundOutlier.getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$))).$plus$plus((IterableOnce)foundMultiParam.getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$));
                return AnalyseConformityOutput$.MODULE$.toOutput((AnalyseConformity)analyse, (scala.collection.immutable.Seq<String>)errors);
            });
            return Json$.MODULE$.toJson((Object)analyseReturnFormat, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), AnalyseConformityOutput$.MODULE$.analysisConformityFormat())).toString();
        });
    }

    public scala.collection.immutable.Seq<ConformityResult> oldGetConformity(String user, scala.collection.immutable.Seq<AnalyseConformity> analysis, Option<Object> conformitySandre) {
        if (BoxesRunTime.unboxToBoolean((Object)conformitySandre.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) && analysis.nonEmpty()) {
            return this.iaEauDao.oldGetConformityResult(user, analysis, this.logUtil, this.ws);
        }
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<ConformityResult> oldGetMultiParam(String user, scala.collection.immutable.Seq<AnalyseConformity> analysis, Option<Object> multiParam) {
        if (BoxesRunTime.unboxToBoolean((Object)multiParam.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) && analysis.nonEmpty()) {
            return this.iaEauDao.oldGetMultiParamResult(user, analysis, this.logUtil, this.ws);
        }
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<OutlierResult> oldGetOutlier(String user, scala.collection.immutable.Seq<AnalyseConformity> stationsAnalysis, Option<Object> outliers) {
        if (BoxesRunTime.unboxToBoolean((Object)outliers.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            return (scala.collection.immutable.Seq)stationsAnalysis.groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.stationId())).values().toSeq().flatMap((Function1 & Serializable)stationAna -> {
                scala.collection.immutable.Seq analysis = (scala.collection.immutable.Seq)stationAna.filter((Function1 & Serializable)stationAnalyse -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$oldGetOutlier$4(stationAnalyse)));
                if (analysis.nonEmpty()) {
                    scala.collection.immutable.Seq parameterCodes = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)((IterableOps)stationsAnalysis.filter((Function1 & Serializable)analyse -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$oldGetOutlier$5(analyse)))).map((Function1 & Serializable)analyse -> (String)analyse.parameter().get())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
                    DateTime date = (DateTime)((AnalyseConformity)analysis.minBy((Function1 & Serializable)a -> ((AbstractInstant)a.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now());
                    scala.collection.immutable.Seq<AnalyseResult> prevAnalysis = $this.integrationOverviewDao.getPreviousAnalysis(((AnalyseConformity)analysis.head()).stationId(), date);
                    if (prevAnalysis.nonEmpty()) {
                        return $this.iaEauDao.oldGetOutlierResult(user, (scala.collection.immutable.Seq<AnalyseConformity>)analysis, prevAnalysis, (scala.collection.immutable.Seq<String>)parameterCodes, ((AnalyseConformity)analysis.head()).stationId(), $this.logUtil, $this.ws);
                    }
                    return Nil$.MODULE$;
                }
                return Nil$.MODULE$;
            });
        }
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    public void outlierQualityJob(JobInput jobInput) {
        long jobExecution = jobInput.jobExecutionId();
        String user = (String)jobInput.user().getOrElse((Function0 & Serializable)() -> "unknown user");
        try {
            ((IterableOnceOps)jobInput.parameters().getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)param -> {
                IntegrationOverviewController.$anonfun$outlierQualityJob$3(this, jobExecution, jobInput, user, param);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            JobLogUtil$.MODULE$.log(jobExecution, JobState$.MODULE$.ERROR(), e.getMessage(), "Job Failed");
            this.logUtil.printError((Throwable)e);
            throw e;
        }
    }

    public CmsInput getNewCms(int nbSamples, int nbAnalysis, scala.collection.immutable.Seq<OutlierResult> allOutliers, scala.collection.immutable.Seq<ConformityResult> allConformityErrors, scala.collection.immutable.Seq<AnalyseConformity> allAnalysis, String user, long jobExecutionId, String jobTitle, int cmsCategory, int cmsStatus, long thisJobExecutionId, String url) {
        DateTime date = DateTime.now();
        String title = new StringBuilder(68).append("Donn\u00e9es non conformes ou aberrantes sur l'ex\u00e9cution ").append(jobExecutionId).append(" du traitement ").append(jobTitle).append("\n").toString();
        Map errorLabelMap = AlgoUtil$.MODULE$.makeMapCode(this.integrationOverviewDao.getAllAnalysisControl(), (Function1 & Serializable)a -> a.code());
        Map parameters = AlgoUtil$.MODULE$.makeMapCode(this.parameterDao.getAllLight(), (Function1 & Serializable)p -> p.code());
        Map units = AlgoUtil$.MODULE$.makeMapCode(this.unitDao.getAllLight(), (Function1 & Serializable)p -> p.code());
        Map groupOutliers = allOutliers.groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)IntegrationOverviewController.$anonfun$getNewCms$4(x$6)));
        Map groupConformity = allConformityErrors.groupBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)IntegrationOverviewController.$anonfun$getNewCms$5(x$7)));
        Set allIds = (Set)groupOutliers.keySet().$plus$plus((IterableOnce)groupConformity.keySet());
        Map qualitos = this.qualitometerDao.getAll((Option)new Some((Object)((IterableOnceOps)allIds.map((Function1)(JFunction1.mcDI.sp & Serializable)x$8 -> x$8)).toSeq())).groupBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)IntegrationOverviewController.$anonfun$getNewCms$7(x$9)));
        String errorsString = ((IterableOnceOps)((IterableOps)allIds.flatMap((Function1 & Serializable)id -> IntegrationOverviewController.$anonfun$getNewCms$8(qualitos, BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int qualitoId = tuple2._1$mcI$sp();
                Qualitometer qualito = (Qualitometer)tuple2._2();
                scala.collection.immutable.Seq outliers = (scala.collection.immutable.Seq)groupOutliers.getOrElse((Object)BoxesRunTime.boxToInteger((int)qualitoId), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
                scala.collection.immutable.Seq conformity = (scala.collection.immutable.Seq)groupConformity.getOrElse((Object)BoxesRunTime.boxToInteger((int)qualitoId), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
                ((IterableOnceOps)outliers.flatMap((Function1 & Serializable)x$10 -> x$10.errors())).foreach((Function1 & Serializable)err -> {
                    JobLogUtil$.MODULE$.log(thisJobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(19).append("Donn\u00e9e aberrante : ").append(err).toString(), qualito.code());
                    return BoxedUnit.UNIT;
                });
                ((IterableOnceOps)conformity.flatMap((Function1 & Serializable)x$11 -> x$11.errors())).foreach((Function1 & Serializable)err -> {
                    JobLogUtil$.MODULE$.log(thisJobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(23).append("Erreur de conformit\u00e9 : ").append(err).toString(), qualito.code());
                    return BoxedUnit.UNIT;
                });
                String errorLabel = this.getErrorLabel(outliers.length(), conformity.length());
                return new StringBuilder(7).append(qualito.code()).append(" - ").append(qualito.name().getOrElse((Function0 & Serializable)() -> "")).append("\n").append(errorLabel).append("\n").append(((IterableOnceOps)conformity.map((Function1 & Serializable)c -> {
                    String anaLabel = (String)this.getConformityAnalysis(allAnalysis, (ConformityResult)c).map((Function1 & Serializable)ana -> new StringBuilder(17).append("Sur l'analyse du ").append(this.analysisToString((AnalyseConformity)ana, (Map<String, ParameterLight>)parameters, (Map<String, UnitLight>)units)).toString()).getOrElse((Function0 & Serializable)() -> "{Analyse introuvable}");
                    JobLogUtil$.MODULE$.log(thisJobExecutionId, JobState$.MODULE$.ERROR(), anaLabel, qualito.code());
                    return new StringBuilder(1).append(anaLabel).append("\n").append(((IterableOnceOps)c.errors().map((Function1 & Serializable)e -> {
                        String err = new StringBuilder(24).append("Erreur de conformit\u00e9 ").append((String)e).append(" : ").append(errorLabelMap.get(e).flatMap((Function1 & Serializable)x$12 -> x$12.label()).getOrElse((Function0 & Serializable)() -> "Erreur inconnue")).toString();
                        JobLogUtil$.MODULE$.log(thisJobExecutionId, JobState$.MODULE$.ERROR(), err, qualito.code());
                        return err;
                    })).mkString("\n")).toString();
                })).mkString("\n")).append("\n").append(((IterableOnceOps)outliers.map((Function1 & Serializable)o -> {
                    String anaLabel = (String)this.getOutlierAnalysis(allAnalysis, (OutlierResult)o).map((Function1 & Serializable)ana -> new StringBuilder(17).append("Sur l'analyse du ").append(this.analysisToString((AnalyseConformity)ana, (Map<String, ParameterLight>)parameters, (Map<String, UnitLight>)units)).toString()).getOrElse((Function0 & Serializable)() -> "{Analyse introuvable}");
                    JobLogUtil$.MODULE$.log(thisJobExecutionId, JobState$.MODULE$.ERROR(), anaLabel, qualito.code());
                    return new StringBuilder(1).append(anaLabel).append("\n").append(o.errors().map((Function1 & Serializable)e -> {
                        String err = new StringBuilder(19).append("Donn\u00e9e aberrante : ").append((String)e).toString();
                        JobLogUtil$.MODULE$.log(thisJobExecutionId, JobState$.MODULE$.ERROR(), err, qualito.code());
                        return err;
                    })).toString();
                })).mkString("\n")).append("\n").toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n\n");
        String resume = new StringBuilder(1).append(this.getErrorLabel(allOutliers.length(), allConformityErrors.length())).append("\n").toString();
        String resume2 = new StringBuilder(42).append("sur un total de ").append(nbSamples).append(" op\u00e9rations et ").append(nbAnalysis).append(" analyses\n\n").toString();
        return new CmsInput(title, (Option)None$.MODULE$, cmsCategory, (Option)new Some((Object)new StringBuilder(0).append(title).append(resume).append(resume2).append(errorsString).toString()), (Option)new Some((Object)user), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)url), (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)cmsStatus)), (Option)new Some((Object)date), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)date), (Option)None$.MODULE$, (Option)new Some((Object)user), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)user), (scala.collection.immutable.Seq)Nil$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, CmsInput$.MODULE$.apply$default$25(), CmsInput$.MODULE$.apply$default$26(), CmsInput$.MODULE$.apply$default$27(), CmsInput$.MODULE$.apply$default$28(), CmsInput$.MODULE$.apply$default$29(), CmsInput$.MODULE$.apply$default$30());
    }

    public Option<AnalyseConformity> getConformityAnalysis(scala.collection.immutable.Seq<AnalyseConformity> allAnalysis, ConformityResult conformityResult) {
        return allAnalysis.find((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$getConformityAnalysis$1(conformityResult, a)));
    }

    public Option<AnalyseConformity> getOutlierAnalysis(scala.collection.immutable.Seq<AnalyseConformity> allAnalysis, OutlierResult outlier) {
        return allAnalysis.find((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$getOutlierAnalysis$1(outlier, a)));
    }

    public String analysisToString(AnalyseConformity ana, Map<String, ParameterLight> parameters, Map<String, UnitLight> units) {
        return new StringBuilder(8).append(ana.analyseDate().orElse((Function0 & Serializable)() -> ana.sampleDate()).map((Function1 & Serializable)d -> DateUtil$.MODULE$.getDate(d)).getOrElse((Function0 & Serializable)() -> "{No date}")).append(" - [").append(ana.parameter().getOrElse((Function0 & Serializable)() -> "No parameter")).append("] ").append(ana.parameter().flatMap((Function1 & Serializable)p -> parameters.get(p)).map((Function1 & Serializable)p -> (String)p.shortLabel().getOrElse((Function0 & Serializable)() -> p.name())).getOrElse((Function0 & Serializable)() -> "")).append(" ").append(ana.result().getOrElse((Function0 & Serializable)() -> "{No result}")).append(" ").append(ana.unit().flatMap((Function1 & Serializable)u -> units.get(u)).flatMap((Function1 & Serializable)u -> u.symbol().orElse((Function0 & Serializable)() -> u.name())).getOrElse((Function0 & Serializable)() -> "{No unit}")).toString();
    }

    public String getErrorLabel(int nbOutlier, int nbConformity) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(nbOutlier, nbConformity);
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            int n2 = sp2._2$mcI$sp();
            if (0 == n && 1 == n2) {
                return "1 donn\u00e9e non conforme a \u00e9t\u00e9 d\u00e9tect\u00e9e";
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            int nb = sp2._2$mcI$sp();
            if (0 == n) {
                return new StringBuilder(40).append(nb).append(" donn\u00e9es non conformes ont \u00e9t\u00e9 d\u00e9tect\u00e9es").toString();
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            int n3 = sp2._2$mcI$sp();
            if (1 == n && 0 == n3) {
                return "1 donn\u00e9e aberrante a \u00e9t\u00e9 d\u00e9tect\u00e9e";
            }
        }
        if (sp2 != null) {
            int nb = sp2._1$mcI$sp();
            int n = sp2._2$mcI$sp();
            if (0 == n) {
                return new StringBuilder(37).append(nb).append(" donn\u00e9es aberrantes ont \u00e9t\u00e9 d\u00e9tect\u00e9es").toString();
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            int n4 = sp2._2$mcI$sp();
            if (1 == n && 1 == n4) {
                return "1 donn\u00e9e aberrante et 1 donn\u00e9e non conforme ont \u00e9t\u00e9 d\u00e9tect\u00e9es";
            }
        }
        if (sp2 != null) {
            int nb = sp2._1$mcI$sp();
            int n = sp2._2$mcI$sp();
            if (1 == n) {
                return new StringBuilder(62).append(nb).append(" donn\u00e9es aberrantes et 1 donn\u00e9e non conforme ont \u00e9t\u00e9 d\u00e9tect\u00e9es").toString();
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            int nb = sp2._2$mcI$sp();
            if (1 == n) {
                return new StringBuilder(62).append("1 donn\u00e9e aberrante et ").append(nb).append(" donn\u00e9es non conformes ont \u00e9t\u00e9 d\u00e9tect\u00e9es").toString();
            }
        }
        if (sp2 != null) {
            int nbO = sp2._1$mcI$sp();
            int nbC = sp2._2$mcI$sp();
            return new StringBuilder(63).append(nbO).append(" donn\u00e9es aberrantes et ").append(nbC).append(" donn\u00e9es non conformes ont \u00e9t\u00e9 d\u00e9tect\u00e9es").toString();
        }
        throw new MatchError((Object)sp2);
    }

    public static final /* synthetic */ boolean $anonfun$getAllAnalysisConformity$4(AnalyseConformity analyse$1, ConformityResult conform) {
        return conform.stationId() == analyse$1.stationId() && conform.numAnalyse() == (double)analyse$1.numAnalyse() && conform.numSample() == analyse$1.numSample();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getAllAnalysisConformity$6(AnalyseConformity analyse$1, OutlierResult out) {
        if (out.qualitometer() != analyse$1.stationId()) return false;
        String string = out.parameter();
        Object object = analyse$1.parameter().getOrElse((Function0 & Serializable)() -> "");
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        if (out.date().toDate().getTime() != ((AbstractInstant)analyse$1.sampleDate().getOrElse((Function0 & Serializable)() -> DateTime.now())).toDate().getTime()) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getAllAnalysisConformity$10(AnalyseConformity analyse$1, ConformityResult conform) {
        return conform.stationId() == analyse$1.stationId() && conform.numAnalyse() == (double)analyse$1.numAnalyse() && conform.numSample() == analyse$1.numSample();
    }

    public static final /* synthetic */ boolean $anonfun$oldGetOutlier$4(AnalyseConformity stationAnalyse) {
        return stationAnalyse.parameter().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$oldGetOutlier$5(AnalyseConformity analyse) {
        return analyse.parameter().isDefined();
    }

    public static final /* synthetic */ void $anonfun$outlierQualityJob$4(IntegrationOverviewController $this, long jobExecution$1, Seq error) {
        JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Can't read parameter: ").append(error).toString(), "");
        $this.logUtil.error(new StringBuilder(22).append("Can't read parameter: ").append(error).toString(), $this.logUtil.error$default$2());
    }

    public static final /* synthetic */ int $anonfun$outlierQualityJob$10(AnalyseConformity x$3) {
        return (int)x$3.numSample();
    }

    public static final /* synthetic */ boolean $anonfun$outlierQualityJob$11(OutlierResult o) {
        return o.errors().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$outlierQualityJob$12(ConformityResult x$5) {
        return x$5.errors().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$outlierQualityJob$5(IntegrationOverviewController $this, JobInput jobInput$1, long jobExecution$1, String user$2, JobOutlier parameter) {
        long jobExecutionIdToSearch = BoxesRunTime.unboxToLong((Object)$this.jobDao.getPreviousJobExecutionId(jobInput$1.jobId()).getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No previous job found on chain");
        }));
        String previousJob = (String)((Job)$this.jobDao.findByExecution(jobExecutionIdToSearch).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(40).append("Can't find associated job for execution ").append(jobExecutionIdToSearch).toString());
        })).name().getOrElse((Function0 & Serializable)() -> "");
        JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.INFO(), new StringBuilder(41).append("Start error search for execution ").append(jobExecutionIdToSearch).append(" of job ").append(previousJob).toString(), "");
        scala.collection.immutable.Seq<StationConformity> stations = $this.integrationOverviewDao.getStationsByJobExecutionId(jobExecutionIdToSearch);
        JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.INFO(), new StringBuilder(40).append(stations.length()).append(" stations found with this jobExecutionId").toString(), "");
        Tuple3 tuple3 = (Tuple3)stations.foldLeft((Object)new Tuple3((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                StationConformity station = (StationConformity)tuple2._2();
                if (tuple3 != null) {
                    Option<Object> x$13;
                    Option<Object> x$12;
                    Option<Object> x$11;
                    Option<Object> x$10;
                    Option<scala.collection.immutable.Seq<Object>> x$9;
                    Option<Object> x$8;
                    Option<DateTime> x$7;
                    Option<DateTime> x$6;
                    Option<DateTime> x$5;
                    Option<DateTime> x$4;
                    scala.collection.immutable.Seq analysis = (scala.collection.immutable.Seq)tuple3._1();
                    int nbOperations = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    int nbAnalysis = BoxesRunTime.unboxToInt((Object)tuple3._3());
                    Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionIdToSearch));
                    Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)((int)station.id())));
                    Option<Object> x$32 = ConformityFilter$.MODULE$.$lessinit$greater$default$1();
                    scala.collection.immutable.Seq<AnalyseConformity> ana = $this.integrationOverviewDao.getAnalysis(new ConformityFilter(x$32, x$4 = ConformityFilter$.MODULE$.$lessinit$greater$default$2(), x$5 = ConformityFilter$.MODULE$.$lessinit$greater$default$3(), x$6 = ConformityFilter$.MODULE$.$lessinit$greater$default$4(), x$7 = ConformityFilter$.MODULE$.$lessinit$greater$default$5(), (Option<Object>)x$1, x$8 = ConformityFilter$.MODULE$.$lessinit$greater$default$7(), x$9 = ConformityFilter$.MODULE$.$lessinit$greater$default$8(), x$10 = ConformityFilter$.MODULE$.$lessinit$greater$default$9(), x$11 = ConformityFilter$.MODULE$.$lessinit$greater$default$10(), x$12 = ConformityFilter$.MODULE$.$lessinit$greater$default$11(), x$13 = ConformityFilter$.MODULE$.$lessinit$greater$default$12(), (Option<Object>)x$2));
                    if (ana.isEmpty()) {
                        JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.WARNING(), "No analysis found for station", station.code());
                    }
                    int operations = ((SeqOps)((SeqOps)ana.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)IntegrationOverviewController.$anonfun$outlierQualityJob$10(x$3)))).distinct()).length();
                    return new Tuple3(analysis.$plus$plus(ana), (Object)BoxesRunTime.boxToInteger((int)(nbOperations + operations)), (Object)BoxesRunTime.boxToInteger((int)(nbAnalysis + ana.length())));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        scala.collection.immutable.Seq stationsAnalysis = (scala.collection.immutable.Seq)tuple3._1();
        int nbOperations = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int nbAnalysis = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)stationsAnalysis, (Object)BoxesRunTime.boxToInteger((int)nbOperations), (Object)BoxesRunTime.boxToInteger((int)nbAnalysis));
        scala.collection.immutable.Seq stationsAnalysis2 = (scala.collection.immutable.Seq)tuple32._1();
        int nbOperations2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int nbAnalysis2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        scala.collection.immutable.Seq outlier = (scala.collection.immutable.Seq)$this.oldGetOutlier(user$2, (scala.collection.immutable.Seq<AnalyseConformity>)stationsAnalysis2, parameter.outliers()).filter((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$outlierQualityJob$11(o)));
        scala.collection.immutable.Seq conformity = (scala.collection.immutable.Seq)$this.oldGetConformity(user$2, (scala.collection.immutable.Seq<AnalyseConformity>)stationsAnalysis2, parameter.conformitySandre()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)IntegrationOverviewController.$anonfun$outlierQualityJob$12(x$5)));
        int nbOutlier = outlier.length();
        int nbConformity = conformity.length();
        String integrationOverviewUrl = new StringBuilder(46).append((String)package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> {
            throw new Exception("APPLICATION_URL is not in env");
        })).append("/#/quality/integrationOverview?jobExecutionId=").append(jobExecutionIdToSearch).toString();
        if (nbOutlier != 0 || nbConformity != 0) {
            JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.WARNING(), new StringBuilder(16).append(nbOutlier + nbConformity).append(" errors detected").toString(), "");
            CmsInput cms = $this.getNewCms(nbOperations2, nbAnalysis2, (scala.collection.immutable.Seq<OutlierResult>)outlier, (scala.collection.immutable.Seq<ConformityResult>)conformity, (scala.collection.immutable.Seq<AnalyseConformity>)stationsAnalysis2, user$2, jobExecutionIdToSearch, previousJob, BoxesRunTime.unboxToInt((Object)parameter.cmsCategory().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), BoxesRunTime.unboxToInt((Object)parameter.cmsStatus().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), jobExecution$1, integrationOverviewUrl);
            Tuple2 tuple2 = $this.cmsDao.createWithDocument(cms, (scala.collection.immutable.Seq)Nil$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int cmsId = tuple2._2$mcI$sp();
            int cmsId2 = cmsId;
            String cmsUrl = new StringBuilder(13).append((String)package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> {
                throw new Exception("APPLICATION_URL is not in env");
            })).append("/#/contents/").append(parameter.cmsCategory().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)).append("/").append(cmsId2).toString();
            JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.LINK(), new StringBuilder(14).append("CMS created : ").append(cmsUrl).toString(), "");
        } else {
            JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.SUCCESS(), "No error was detected", "");
        }
        JobLogUtil$.MODULE$.log(jobExecution$1, JobState$.MODULE$.LINK(), new StringBuilder(31).append("Link to integration overview : ").append(integrationOverviewUrl).toString(), "");
    }

    public static final /* synthetic */ void $anonfun$outlierQualityJob$3(IntegrationOverviewController $this, long jobExecution$1, JobInput jobInput$1, String user$2, String param) {
        Json$.MODULE$.parse(param).validate(JobOutlier$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            IntegrationOverviewController.$anonfun$outlierQualityJob$4($this, jobExecution$1, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)parameter -> {
            IntegrationOverviewController.$anonfun$outlierQualityJob$5($this, jobInput$1, jobExecution$1, user$2, parameter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$getNewCms$4(OutlierResult x$6) {
        return (int)x$6.qualitometer();
    }

    public static final /* synthetic */ int $anonfun$getNewCms$5(ConformityResult x$7) {
        return (int)x$7.stationId();
    }

    public static final /* synthetic */ int $anonfun$getNewCms$7(Qualitometer x$9) {
        return (int)x$9.id();
    }

    public static final /* synthetic */ Option $anonfun$getNewCms$8(Map qualitos$1, int id) {
        return qualitos$1.get((Object)BoxesRunTime.boxToInteger((int)id)).map((Function1 & Serializable)list -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), list.head()));
    }

    public static final /* synthetic */ boolean $anonfun$getConformityAnalysis$1(ConformityResult conformityResult$1, AnalyseConformity a) {
        return (int)a.stationId() == (int)conformityResult$1.stationId() && (int)a.numSample() == (int)conformityResult$1.numSample() && (int)a.numAnalyse() == (int)conformityResult$1.numAnalyse();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getOutlierAnalysis$1(OutlierResult outlier$2, AnalyseConformity a) {
        if ((int)a.stationId() != (int)outlier$2.qualitometer()) return false;
        String string = DateUtil$.MODULE$.getDate((DateTime)a.analyseDate().orElse((Function0 & Serializable)() -> a.sampleDate()).get());
        String string2 = DateUtil$.MODULE$.getDate(outlier$2.date());
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Object object = a.parameter().getOrElse((Function0 & Serializable)() -> "NA");
        String string3 = outlier$2.parameter();
        if (object == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!object.equals(string3)) return false;
            return true;
        }
    }

    @Inject
    public IntegrationOverviewController(LogUtil logUtil, CmsDao cmsDao, IntegrationOverviewDao integrationOverviewDao, IAEauDao iaEauDao, ParameterDao parameterDao, QualitometerDao qualitometerDao, JobDao jobDao, UnitDao unitDao, WSClient ws) {
        this.logUtil = logUtil;
        this.cmsDao = cmsDao;
        this.integrationOverviewDao = integrationOverviewDao;
        this.iaEauDao = iaEauDao;
        this.parameterDao = parameterDao;
        this.qualitometerDao = qualitometerDao;
        this.jobDao = jobDao;
        this.unitDao = unitDao;
        this.ws = ws;
    }
}

