/*
 * Decompiled with CFR 0.152.
 */
package contact.controller;

import fr.aquasys.daeau.referentials.contact.Contact;
import fr.aquasys.daeau.referentials.contact.Contact$;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.referentials.contact.input.ContactInput$;
import fr.aquasys.daeau.referentials.contact.input.ContactTableInput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.SieauFilteredTableLine$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\t\u0013\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ya\b\u0005\tY\u0001\u0011\t\u0011)A\u0006[!)Q\u0007\u0001C\u0001m!)Q\t\u0001C\u0001\r\"9A\u000e\u0001b\u0001\n\u0003i\u0007BB9\u0001A\u0003%a\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\u0015\u0001\t\u0003\t\u0019FA\tD_:$\u0018m\u0019;D_:$(o\u001c7mKJT!a\u0005\u000b\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0016\u0003\u001d\u0019wN\u001c;bGR\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\f!bY8oi\u0006\u001cG\u000fR1p!\t\u0001#&D\u0001\"\u0015\t)\"E\u0003\u0002$I\u0005a!/\u001a4fe\u0016tG/[1mg*\u0011QEJ\u0001\u0006I\u0006,\u0017-\u001e\u0006\u0003O!\nq!Y9vCNL8OC\u0001*\u0003\t1'/\u0003\u0002,C\tQ1i\u001c8uC\u000e$H)Y8\u0002\u000f1|w-\u0016;jYB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005kRLGN\u0003\u00023M\u0005A!/\u00192cSRl\u0017/\u0003\u00025_\t9Aj\\4Vi&d\u0017A\u0002\u001fj]&$h\bF\u00018)\rA$h\u000f\t\u0003s\u0001i\u0011A\u0005\u0005\u0006=\r\u0001\u001da\b\u0005\u0006Y\r\u0001\u001d!\f\u0015\u0003\u0007u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\r%t'.Z2u\u0015\u0005\u0011\u0015!\u00026bm\u0006D\u0018B\u0001#@\u0005\u0019IeN[3di\u0006\u0019q-\u001a;\u0015\u000b\u001d\u0013\u0006\r\u001b6\u0011\u0005!{eBA%N!\tQ%$D\u0001L\u0015\tae#\u0001\u0004=e>|GOP\u0005\u0003\u001dj\ta\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011aJ\u0007\u0005\u0006'\u0012\u0001\r\u0001V\u0001\b[\u0016\u001c8/Y4f!\t)f,D\u0001W\u0015\t9\u0006,\u0001\u0003kg>t'BA-[\u0003\u0011a\u0017NY:\u000b\u0005mc\u0016aA1qS*\tQ,\u0001\u0003qY\u0006L\u0018BA0W\u0005\u001dQ5OV1mk\u0016DQ!\u0019\u0003A\u0002\t\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003IG\u001e+\u0017B\u00013R\u0005\ri\u0015\r\u001d\t\u00033\u0019L!a\u001a\u000e\u0003\u0007\u0005s\u0017\u0010C\u0003j\t\u0001\u0007q)\u0001\u0004n_\u0012,H.\u001a\u0005\u0006W\u0012\u0001\raR\u0001\u0005kN,'/A\bjI\u0016tG/\u001b4jC:$(+Z1e+\u0005q\u0007cA+p\u000f&\u0011\u0001O\u0016\u0002\u0006%\u0016\fGm]\u0001\u0011S\u0012,g\u000e^5gS\u0006tGOU3bI\u0002\nqbZ3u\u0005fLE-\u001a8uS\u001aLWM\u001d\u000b\u0006\u000fR,ho\u001e\u0005\u0006'\u001e\u0001\r\u0001\u0016\u0005\u0006C\u001e\u0001\rA\u0019\u0005\u0006S\u001e\u0001\ra\u0012\u0005\u0006W\u001e\u0001\raR\u0001\u0007O\u0016$\u0018\t\u001c7\u0015\u000b\u001dS8\u0010`?\t\u000bMC\u0001\u0019\u0001+\t\u000b\u0005D\u0001\u0019\u00012\t\u000b%D\u0001\u0019A$\t\u000b-D\u0001\u0019A$\u0002\u0011\u001d,GoQ8v]R$\u0012bRA\u0001\u0003\u0007\t)!a\u0002\t\u000bMK\u0001\u0019\u0001+\t\u000b\u0005L\u0001\u0019\u00012\t\u000b%L\u0001\u0019A$\t\u000b-L\u0001\u0019A$\u0002\r\r\u0014X-\u0019;f)%9\u0015QBA\b\u0003#\t\u0019\u0002C\u0003T\u0015\u0001\u0007A\u000bC\u0003b\u0015\u0001\u0007!\rC\u0003j\u0015\u0001\u0007q\tC\u0003l\u0015\u0001\u0007q)\u0001\u0004va\u0012\fG/\u001a\u000b\n\u000f\u0006e\u00111DA\u000f\u0003?AQaU\u0006A\u0002QCQ!Y\u0006A\u0002\tDQ![\u0006A\u0002\u001dCQa[\u0006A\u0002\u001d\u000ba\u0001Z3mKR,G#C$\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0011\u0015\u0019F\u00021\u0001U\u0011\u0015\tG\u00021\u0001c\u0011\u0015IG\u00021\u0001H\u0011\u0015YG\u00021\u0001H\u000399W\r^\"pk:$H)\u001a7fi\u0016$\u0012bRA\u0019\u0003g\t)$a\u000e\t\u000bMk\u0001\u0019\u0001+\t\u000b\u0005l\u0001\u0019\u00012\t\u000b%l\u0001\u0019A$\t\u000b-l\u0001\u0019A$\u0002\u000bA,(oZ3\u0015\u0013\u001d\u000bi$a\u0010\u0002B\u0005\r\u0003\"B*\u000f\u0001\u0004!\u0006\"B1\u000f\u0001\u0004\u0011\u0007\"B5\u000f\u0001\u00049\u0005\"B6\u000f\u0001\u00049\u0015a\u0002:fa2\f7-\u001a\u000b\n\u000f\u0006%\u00131JA'\u0003\u001fBQaU\bA\u0002QCQ!Y\bA\u0002\tDQ![\bA\u0002\u001dCQa[\bA\u0002\u001d\u000b\u0001cZ3u\u0007>tG/Y2ugR\u000b'\r\\3\u0015\u0013\u001d\u000b)&a\u0016\u0002Z\u0005m\u0003\"B*\u0011\u0001\u0004!\u0006\"B1\u0011\u0001\u0004\u0011\u0007\"B5\u0011\u0001\u00049\u0005\"B6\u0011\u0001\u00049\u0005f\u0001\u0001\u0002`A\u0019a(!\u0019\n\u0007\u0005\rtHA\u0005TS:<G.\u001a;p]\u0002")
public class ContactController {
    private final ContactDao contactDao;
    private final LogUtil logUtil;
    private final Reads<String> identifiantRead;

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Contact$.MODULE$.idRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Option option = this.contactDao.get(BoxesRunTime.unboxToInt((Object)jsSuccess.get()));
            if (option instanceof Some) {
                Some some = (Some)option;
                Contact contact = (Contact)some.value();
                this.logUtil.info(new StringBuilder(15).append("Return contact ").append(contact.name()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)contact, (Writes)Contact$.MODULE$.format()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.info(new StringBuilder(18).append("Contact not found ").append(jsSuccess.get()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)204), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public Reads<String> identifiantRead() {
        return this.identifiantRead;
    }

    public String getByIdentifier(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.identifiantRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(29).append("Error to parse identifiant :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> Json$.MODULE$.toJson((Object)$this.contactDao.getByIdentifier(read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contact$.MODULE$.format())).toString());
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.contactDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contact$.MODULE$.format())).toString();
    }

    public String getCount(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.contactDao.getCount()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)ContactInput$.MODULE$.writeContact()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(29).append("Error to parse email input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int id;
            Tuple2 tuple2 = $this.contactDao.create(validate);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int result = tuple2._1$mcI$sp();
            int id2 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(result, id2);
            int result2 = sp2._1$mcI$sp();
            int n = id = sp2._2$mcI$sp();
            $this.logUtil.info(new StringBuilder(21).append("Add contact with id :").append(n).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate((Reads)Contact$.MODULE$.format());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Option option = this.contactDao.get(((Contact)jsSuccess.get()).id());
            if (option instanceof Some) {
                Contact contactToUpdate = (Contact)jsSuccess.get();
                int n = this.contactDao.update(contactToUpdate);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)new StringBuilder(18).append("Contact not found ").append(((Contact)jsSuccess.get()).id()).toString());
                this.logUtil.error(new StringBuilder(18).append("Contact not found ").append(((Contact)jsSuccess.get()).id()).toString(), this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        Predef$.MODULE$.println((Object)"Error in contact json");
        this.logUtil.error("Error in contact json", this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contact$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to get contact : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> ContactController.$anonfun$delete$2(this, BoxesRunTime.unboxToInt((Object)validate)));
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contact$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to get contact : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> ContactController.$anonfun$getCountDelete$2(this, BoxesRunTime.unboxToInt((Object)validate)));
    }

    public String purge(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"purge"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)this.contactDao.purge()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String replace(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contact$.MODULE$.replaceIdsRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(42).append("Error validate Json to replace contact : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int code = validate._1$mcI$sp();
            int newCode = validate._2$mcI$sp();
            int result = $this.contactDao.replace(code, newCode);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getContactsTable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)ContactTableInput$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(37).append("Can't parse contributor table input, ").append(error.toString()).toString(), 400), (Function1 & Serializable)input -> SieauFilteredTableLine$.MODULE$.generateJson($this.contactDao.getContactsTable(input), input.searchValue(), input.forceLoad(), input.previewSize()));
    }

    public static final /* synthetic */ String $anonfun$delete$2(ContactController $this, int validate) {
        int result = $this.contactDao.delete(validate);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getCountDelete$2(ContactController $this, int validate) {
        int result = $this.contactDao.getCountDelete(validate);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public ContactController(ContactDao contactDao, LogUtil logUtil) {
        this.contactDao = contactDao;
        this.logUtil = logUtil;
        this.identifiantRead = JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.StringReads());
    }
}

