/*
 * Decompiled with CFR 0.152.
 */
package contributor.controller;

import contributor.dao.ContributorDomainDao;
import contributor.dao.ContributorStatutDao;
import contributor.dao.ContributorTypeDao;
import contributor.model.ContributorDomain$;
import contributor.model.ContributorStatut$;
import contributor.model.ContributorType$;
import fr.aquasys.daeau.referentials.contributor.domain.ContributorInput;
import fr.aquasys.daeau.referentials.contributor.domain.ContributorInput$;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.contributor.model.Contributor;
import fr.aquasys.daeau.referentials.contributor.model.Contributor$;
import fr.aquasys.daeau.referentials.contributor.model.ContributorTableInput$;
import fr.aquasys.daeau.referentials.contributor.model.ContributorWithLinks;
import fr.aquasys.daeau.referentials.contributor.model.ContributorWithLinks$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.SieauFilteredTableLine$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import sandre.dao.ReferentialSandreCodeDao;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t\u001df\u0001B\u0013'\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ya\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0006\u0007\"A\u0011\n\u0001B\u0001B\u0003-!\n\u0003\u0005N\u0001\t\u0005\t\u0015a\u0003O\u0011!I\u0006A!A!\u0002\u0017Q\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b1\u00020\t\u0011\u0019\u0004!\u0011!Q\u0001\f\u001dDQA\u001c\u0001\u0005\u0002=Dq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a%\u0001\t\u0003\t)\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"I\u0011q\u0017\u0001C\u0002\u0013\u0005\u0011\u0011\u0018\u0005\t\u0003?\u0004\u0001\u0015!\u0003\u0002<\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\u001c\u0001!\tA!\b\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B \u0001\u0011\u0005!\u0011\t\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u00119\u0006\u0001C\u0001\u00053BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\tm\u0004\u0001\"\u0001\u0003~!9!q\u0011\u0001\u0005\u0002\t%\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0002\u0016\u0007>tGO]5ckR|'oQ8oiJ|G\u000e\\3s\u0015\t9\u0003&\u0001\u0006d_:$(o\u001c7mKJT\u0011!K\u0001\fG>tGO]5ckR|'o\u0001\u0001\u0014\u0005\u0001a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g-\u0001\bd_:$(/\u001b2vi>\u0014H)Y8\u0011\u0005Q\u0002U\"A\u001b\u000b\u0005Y:\u0014aA5uM*\u0011\u0011\u0006\u000f\u0006\u0003si\nAB]3gKJ,g\u000e^5bYNT!a\u000f\u001f\u0002\u000b\u0011\fW-Y;\u000b\u0005ur\u0014aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002\u007f\u0005\u0011aM]\u0005\u0003\u0003V\u0012qbQ8oiJL'-\u001e;peN$\u0015m\\\u0001\u0013G>tGO]5ckR|'\u000fV=qK\u0012\u000bw\u000e\u0005\u0002E\u000f6\tQI\u0003\u0002GQ\u0005\u0019A-Y8\n\u0005!+%AE\"p]R\u0014\u0018NY;u_J$\u0016\u0010]3EC>\fAcY8oiJL'-\u001e;peN#\u0018\r^;u\t\u0006|\u0007C\u0001#L\u0013\taUI\u0001\u000bD_:$(/\u001b2vi>\u00148\u000b^1ukR$\u0015m\\\u0001\u0003oN\u0004\"aT,\u000e\u0003AS!!T)\u000b\u0005I\u001b\u0016\u0001\u00027jENT!\u0001V+\u0002\u0007\u0005\u0004\u0018NC\u0001W\u0003\u0011\u0001H.Y=\n\u0005a\u0003&\u0001C,T\u00072LWM\u001c;\u0002)\r|g\u000e\u001e:jEV$xN\u001d#p[\u0006Lg\u000eR1p!\t!5,\u0003\u0002]\u000b\n!2i\u001c8ue&\u0014W\u000f^8s\t>l\u0017-\u001b8EC>\fq\u0001\\8h+RLG\u000e\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006!Q\u000f^5m\u0015\t\u0019G(\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0013\t)\u0007MA\u0004M_\u001e,F/\u001b7\u00021I,g-\u001a:f]RL\u0017\r\\*b]\u0012\u0014XmQ8eK\u0012\u000bw\u000e\u0005\u0002iY6\t\u0011N\u0003\u0002GU*\t1.\u0001\u0004tC:$'/Z\u0005\u0003[&\u0014\u0001DU3gKJ,g\u000e^5bYN\u000bg\u000e\u001a:f\u0007>$W\rR1p\u0003\u0019a\u0014N\\5u}Q\t\u0001\u000f\u0006\u0005rgR,ho\u001e=z!\t\u0011\b!D\u0001'\u0011\u0015\u0011\u0004\u0002q\u00014\u0011\u0015\u0011\u0005\u0002q\u0001D\u0011\u0015I\u0005\u0002q\u0001K\u0011\u0015i\u0005\u0002q\u0001O\u0011\u0015I\u0006\u0002q\u0001[\u0011\u0015i\u0006\u0002q\u0001_\u0011\u00151\u0007\u0002q\u0001hQ\tA1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fa!\u001b8kK\u000e$(BAA\u0001\u0003\u0015Q\u0017M^1y\u0013\r\t)! \u0002\u0007\u0013:TWm\u0019;\u0002\u0007\u001d,G\u000f\u0006\u0006\u0002\f\u0005\u0005\u0012\u0011GA!\u0003\u000b\u0002B!!\u0004\u0002\u001c9!\u0011qBA\f!\r\t\tBL\u0007\u0003\u0003'Q1!!\u0006+\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0004\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"a\b\u0003\rM#(/\u001b8h\u0015\r\tIB\f\u0005\b\u0003GI\u0001\u0019AA\u0013\u0003\u001diWm]:bO\u0016\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\t\u0016\u0001\u00026t_:LA!a\f\u0002*\t9!j\u001d,bYV,\u0007bBA\u001a\u0013\u0001\u0007\u0011QG\u0001\bQ\u0016\fG-\u001a:t!!\ti!a\u000e\u0002\f\u0005m\u0012\u0002BA\u001d\u0003?\u00111!T1q!\ri\u0013QH\u0005\u0004\u0003\u007fq#aA!os\"9\u00111I\u0005A\u0002\u0005-\u0011AB7pIVdW\rC\u0004\u0002H%\u0001\r!a\u0003\u0002\tU\u001cXM]\u0001\nO\u0016$x+\u001b;i\u0013\u0012$\"\"a\u0003\u0002N\u0005=\u0013\u0011KA*\u0011\u001d\t\u0019C\u0003a\u0001\u0003KAq!a\r\u000b\u0001\u0004\t)\u0004C\u0004\u0002D)\u0001\r!a\u0003\t\u000f\u0005\u001d#\u00021\u0001\u0002\f\u0005aq-\u001a;XSRD7+\u001b:fiRQ\u00111BA-\u00037\ni&a\u0018\t\u000f\u0005\r2\u00021\u0001\u0002&!9\u00111G\u0006A\u0002\u0005U\u0002bBA\"\u0017\u0001\u0007\u00111\u0002\u0005\b\u0003\u000fZ\u0001\u0019AA\u0006\u0003\u00199W\r^'bqRQ\u00111BA3\u0003O\nI'a\u001b\t\u000f\u0005\rB\u00021\u0001\u0002&!9\u00111\u0007\u0007A\u0002\u0005U\u0002bBA\"\u0019\u0001\u0007\u00111\u0002\u0005\b\u0003\u000fb\u0001\u0019AA\u0006\u0003\u0019\u0019'/Z1uKRQ\u00111BA9\u0003g\n)(a\u001e\t\u000f\u0005\rR\u00021\u0001\u0002&!9\u00111G\u0007A\u0002\u0005U\u0002bBA\"\u001b\u0001\u0007\u00111\u0002\u0005\b\u0003\u000fj\u0001\u0019AA\u0006\u0003]1\u0017N\u001c3Ti\u0006$\u0018n\u001c8D_:$(/\u001b2vi>\u00148\u000f\u0006\u0005\u0002\f\u0005u\u0014qPAB\u0011\u001d\t\u0019C\u0004a\u0001\u0003KAq!!!\u000f\u0001\u0004\tY!A\u0005mS:\\G+\u00192mK\"9\u0011Q\u0011\bA\u0002\u0005-\u0011AD2pI\u0016$UMZ5oSRLwN\\\u0001$M&tG-U;bY&$x.\\3uKJ\u001cF/\u0019;j_:\u001cuN\u001c;sS\n,Ho\u001c:t))\tY!a#\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\b\u0003Gy\u0001\u0019AA\u0013\u0011\u001d\t\u0019d\u0004a\u0001\u0003kAq!a\u0011\u0010\u0001\u0004\tY\u0001C\u0004\u0002H=\u0001\r!a\u0003\u0002C\u0019Lg\u000e\u001a)jKj|W.\u001a;feN#\u0018\r^5p]\u000e{g\u000e\u001e:jEV$xN]:\u0015\u0015\u0005-\u0011qSAM\u00037\u000bi\nC\u0004\u0002$A\u0001\r!!\n\t\u000f\u0005M\u0002\u00031\u0001\u00026!9\u00111\t\tA\u0002\u0005-\u0001bBA$!\u0001\u0007\u00111B\u0001#M&tG\r\u00157vm&|W.\u001a;feN#\u0018\r^5p]\u000e{g\u000e\u001e:jEV$xN]:\u0015\u0015\u0005-\u00111UAS\u0003O\u000bI\u000bC\u0004\u0002$E\u0001\r!!\n\t\u000f\u0005M\u0012\u00031\u0001\u00026!9\u00111I\tA\u0002\u0005-\u0001bBA$#\u0001\u0007\u00111B\u0001$M&tG\rS=ee>dwnZ5dC2\u001cF/\u0019;j_:\u001cuN\u001c;sS\n,Ho\u001c:t))\tY!a,\u00022\u0006M\u0016Q\u0017\u0005\b\u0003G\u0011\u0002\u0019AA\u0013\u0011\u001d\t\u0019D\u0005a\u0001\u0003kAq!a\u0011\u0013\u0001\u0004\tY\u0001C\u0004\u0002HI\u0001\r!a\u0003\u0002\u0011U\u001cXM\u001d*fC\u0012,\"!a/\u0011\r\u0005\u001d\u0012QXAa\u0013\u0011\ty,!\u000b\u0003\u000bI+\u0017\rZ:\u0011\u000f5\n\u0019-a\u0003\u0002H&\u0019\u0011Q\u0019\u0018\u0003\rQ+\b\u000f\\33!\u0015i\u0013\u0011ZAg\u0013\r\tYM\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005=\u0017\u0011\\A\u0006\u001d\u0011\t\t.!6\u000f\t\u0005E\u00111[\u0005\u0002_%\u0019\u0011q\u001b\u0018\u0002\u000fA\f7m[1hK&!\u00111\\Ao\u0005\r\u0019V-\u001d\u0006\u0004\u0003/t\u0013!C;tKJ\u0014V-\u00193!\u0003\u00199W\r^!mYRQ\u00111BAs\u0003O\fI/a;\t\u000f\u0005\rR\u00031\u0001\u0002&!9\u00111G\u000bA\u0002\u0005U\u0002bBA\"+\u0001\u0007\u00111\u0002\u0005\b\u0003\u000f*\u0002\u0019AA\u0006\u0003Q1\u0017N\u001c3UsB,7i\u001c8ue&\u0014W\u000f^8sgR1\u00111BAy\u0003gDq!a\t\u0017\u0001\u0004\t)\u0003C\u0004\u0002vZ\u0001\r!a\u0003\u0002\u000b\u0019LW\r\u001c3\u00023\u0019Lg\u000e\u001a)jKj|G+\u001f9f\u0007>tGO]5ckR|'o\u001d\u000b\u000b\u0003\u0017\tY0!@\u0002\u0000\n\u0005\u0001bBA\u0012/\u0001\u0007\u0011Q\u0005\u0005\b\u0003g9\u0002\u0019AA\u001b\u0011\u001d\t\u0019e\u0006a\u0001\u0003\u0017Aq!a\u0012\u0018\u0001\u0004\tY!\u0001\u000egS:$\u0007\u000b\\;wS>$\u0016\u0010]3D_:$(/\u001b2vi>\u00148\u000f\u0006\u0006\u0002\f\t\u001d!\u0011\u0002B\u0006\u0005\u001bAq!a\t\u0019\u0001\u0004\t)\u0003C\u0004\u00024a\u0001\r!!\u000e\t\u000f\u0005\r\u0003\u00041\u0001\u0002\f!9\u0011q\t\rA\u0002\u0005-\u0011AC4fiN#\u0018\r^;ugRQ\u00111\u0002B\n\u0005+\u00119B!\u0007\t\u000f\u0005\r\u0012\u00041\u0001\u0002&!9\u00111G\rA\u0002\u0005U\u0002bBA\"3\u0001\u0007\u00111\u0002\u0005\b\u0003\u000fJ\u0002\u0019AA\u0006\u0003)9W\r\u001e#p[\u0006Lgn\u001d\u000b\u000b\u0003\u0017\u0011yB!\t\u0003$\t\u0015\u0002bBA\u00125\u0001\u0007\u0011Q\u0005\u0005\b\u0003gQ\u0002\u0019AA\u001b\u0011\u001d\t\u0019E\u0007a\u0001\u0003\u0017Aq!a\u0012\u001b\u0001\u0004\tY!\u0001\u0005hKR\u001cu.\u001e8u))\tYAa\u000b\u0003.\t=\"\u0011\u0007\u0005\b\u0003GY\u0002\u0019AA\u0013\u0011\u001d\t\u0019d\u0007a\u0001\u0003kAq!a\u0011\u001c\u0001\u0004\tY\u0001C\u0004\u0002Hm\u0001\r!a\u0003\u0002\u0019\u001d,G\u000f\u0015:pIV\u001cWM]:\u0015\u0015\u0005-!q\u0007B\u001d\u0005w\u0011i\u0004C\u0004\u0002$q\u0001\r!!\n\t\u000f\u0005MB\u00041\u0001\u00026!9\u00111\t\u000fA\u0002\u0005-\u0001bBA$9\u0001\u0007\u00111B\u0001\u0010O\u0016$H*\u00192pe\u0006$xN]5fgRQ\u00111\u0002B\"\u0005\u000b\u00129E!\u0013\t\u000f\u0005\rR\u00041\u0001\u0002&!9\u00111G\u000fA\u0002\u0005U\u0002bBA\";\u0001\u0007\u00111\u0002\u0005\b\u0003\u000fj\u0002\u0019AA\u0006\u0003A9W\r\u001e#fi\u0016\u0014X.\u001b8bi>\u00148\u000f\u0006\u0006\u0002\f\t=#\u0011\u000bB*\u0005+Bq!a\t\u001f\u0001\u0004\t)\u0003C\u0004\u00024y\u0001\r!!\u000e\t\u000f\u0005\rc\u00041\u0001\u0002\f!9\u0011q\t\u0010A\u0002\u0005-\u0011AB;qI\u0006$X\r\u0006\u0006\u0002\f\tm#Q\fB0\u0005CBq!a\t \u0001\u0004\t)\u0003C\u0004\u00024}\u0001\r!!\u000e\t\u000f\u0005\rs\u00041\u0001\u0002\f!9\u0011qI\u0010A\u0002\u0005-\u0011A\u00023fY\u0016$X\r\u0006\u0006\u0002\f\t\u001d$\u0011\u000eB6\u0005[Bq!a\t!\u0001\u0004\t)\u0003C\u0004\u00024\u0001\u0002\r!!\u000e\t\u000f\u0005\r\u0003\u00051\u0001\u0002\f!9\u0011q\t\u0011A\u0002\u0005-\u0011AD4fi\u000e{WO\u001c;EK2,G/\u001a\u000b\u000b\u0003\u0017\u0011\u0019H!\u001e\u0003x\te\u0004bBA\u0012C\u0001\u0007\u0011Q\u0005\u0005\b\u0003g\t\u0003\u0019AA\u001b\u0011\u001d\t\u0019%\ta\u0001\u0003\u0017Aq!a\u0012\"\u0001\u0004\tY!A\u0003qkJ<W\r\u0006\u0006\u0002\f\t}$\u0011\u0011BB\u0005\u000bCq!a\t#\u0001\u0004\t)\u0003C\u0004\u00024\t\u0002\r!!\u000e\t\u000f\u0005\r#\u00051\u0001\u0002\f!9\u0011q\t\u0012A\u0002\u0005-\u0011a\u0002:fa2\f7-\u001a\u000b\u000b\u0003\u0017\u0011YI!$\u0003\u0010\nE\u0005bBA\u0012G\u0001\u0007\u0011Q\u0005\u0005\b\u0003g\u0019\u0003\u0019AA\u001b\u0011\u001d\t\u0019e\ta\u0001\u0003\u0017Aq!a\u0012$\u0001\u0004\tY!\u0001\u000bhKR\u001cuN\u001c;sS\n,Ho\u001c:t)\u0006\u0014G.\u001a\u000b\u000b\u0003\u0017\u00119J!'\u0003\u001c\nu\u0005bBA\u0012I\u0001\u0007\u0011Q\u0005\u0005\b\u0003g!\u0003\u0019AA\u001b\u0011\u001d\t\u0019\u0005\na\u0001\u0003\u0017Aq!a\u0012%\u0001\u0004\tY\u0001K\u0002\u0001\u0005C\u00032\u0001 BR\u0013\r\u0011)+ \u0002\n'&tw\r\\3u_:\u0004")
public class ContributorController {
    private final ContributorsDao contributorDao;
    private final ContributorTypeDao contributorTypeDao;
    private final ContributorStatutDao contributorStatutDao;
    private final ContributorDomainDao contributorDomainDao;
    private final LogUtil logUtil;
    private final Reads<Tuple2<String, Option<Seq<String>>>> userRead;

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Contributor$.MODULE$.codeRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Option option = this.contributorDao.get((String)jsSuccess.get());
            if (option instanceof Some) {
                Some some = (Some)option;
                Contributor contributor = (Contributor)some.value();
                this.logUtil.info(new StringBuilder(19).append("Return contributor ").append(contributor.name()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)contributor, (Writes)Contributor$.MODULE$.format()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.info(new StringBuilder(22).append("Contributor not found ").append(jsSuccess.get()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)204), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getWithId(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Contributor$.MODULE$.idRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Option option = this.contributorDao.getWithId(BoxesRunTime.unboxToInt((Object)jsSuccess.get()));
            if (option instanceof Some) {
                Some some = (Some)option;
                ContributorWithLinks contributor = (ContributorWithLinks)some.value();
                this.logUtil.info(new StringBuilder(19).append("Return contributor ").append(contributor.name()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)contributor, ContributorWithLinks$.MODULE$.writeContributorWithLinks()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.info(new StringBuilder(22).append("Contributor not found ").append(jsSuccess.get()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)204), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getWithSiret(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contributor$.MODULE$.siretRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(14).append("Bad request : ").append(error).toString(), 400), (Function1 & Serializable)siret -> Json$.MODULE$.toJson((Object)$this.contributorDao.getWithSiret(siret), Writes$.MODULE$.OptionWrites((Writes)Contributor$.MODULE$.format())).toString());
    }

    public String getMax(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Contributor$.MODULE$.idRead());
        if (jsResult instanceof JsSuccess) {
            int n = this.contributorDao.getMax();
            this.logUtil.info(new StringBuilder(27).append("Return maxcode contributor ").append(n).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites()).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate((Reads)ContributorInput$.MODULE$.readContributor());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Option option = this.contributorDao.insert((ContributorInput)jsSuccess.get(), ((ContributorInput)jsSuccess.get()).loginmaj());
            if (option instanceof Some) {
                Some some = (Some)option;
                long id = BoxesRunTime.unboxToLong((Object)some.value());
                this.logUtil.info(new StringBuilder(19).append("Create contributor ").append(id).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)id), (Writes)Writes$.MODULE$.LongWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.error("Error to insert contributor ", this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String findStationContributors(JsValue message, String linkTable, String codeDefinition) {
        JsResult jsResult = message.validate(Contributor$.MODULE$.idRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            int id = BoxesRunTime.unboxToInt((Object)jsSuccess.get());
            Seq constributors = this.contributorDao.findStationContributors(id, linkTable, codeDefinition);
            this.logUtil.info(new StringBuilder(31).append("Contributors for station ").append(id).append(" found").toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)constributors, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contributor$.MODULE$.format())).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.error(new StringBuilder(51).append("Error validate Json to get station constributors :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String findQualitometerStationContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return this.findStationContributors(message, "intervenants_liste_qualito", "codequalitometre");
    }

    public String findPiezometerStationContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return this.findStationContributors(message, "intervenants_liste_piezo", "codepiezometre");
    }

    public String findPluviometerStationContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return this.findStationContributors(message, "intervenants_liste_pluvio", "codepluviometre");
    }

    public String findHydrologicalStationContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return this.findStationContributors(message, "intervenants_liste_hydro", "codestation");
    }

    public Reads<Tuple2<String, Option<Seq<String>>>> userRead() {
        return this.userRead;
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(25).append("Can't get contributors :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)param -> {
            Option codes;
            Tuple2 tuple2 = param;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option codes2 = (Option)tuple2._2();
            Option option = codes = codes2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq allCode = (Seq)some.value();
                Seq contributors = (Seq)allCode.flatMap((Function1 & Serializable)code -> $this.contributorDao.getWithId(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(code))));
                return Json$.MODULE$.toJson((Object)contributors, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ContributorWithLinks$.MODULE$.writeContributorWithLinks())).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.toJson((Object)$this.contributorDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contributor$.MODULE$.format())).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String findTypeContributors(JsValue message, String field) {
        return Json$.MODULE$.toJson(this.contributorTypeDao.getAll(field), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ContributorType$.MODULE$.writes())).toString();
    }

    public String findPiezoTypeContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return this.findTypeContributors(message, "LIEN_PIEZO_INTERVENANTS.TYPEINTERVENANT");
    }

    public String findPluvioTypeContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return this.findTypeContributors(message, "LIEN_PLUVIO_INTERVENANTS.TYPEINTERVENANT");
    }

    public String getStatuts(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.contributorStatutDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ContributorStatut$.MODULE$.writes())).toString();
    }

    public String getDomains(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.contributorDomainDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ContributorDomain$.MODULE$.writes())).toString();
    }

    public String getCount(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.contributorDao.getCount()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public String getProducers(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.contributorDao.getProducers(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contributor$.MODULE$.format())).toString();
    }

    public String getLaboratories(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.contributorDao.getLaboratories(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contributor$.MODULE$.format())).toString();
    }

    public String getDeterminators(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.contributorDao.getDeterminators(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Contributor$.MODULE$.format())).toString();
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ContributorInput$.MODULE$.readUpdateContributor()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(34).append("Can't get contributor threshold :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)contributorValidate -> {
            int contributorIdUpdate = contributorValidate._1$mcI$sp();
            ContributorInput contributorToUpdate = (ContributorInput)contributorValidate._2();
            Option option = $this.contributorDao.getWithId(contributorIdUpdate);
            if (option instanceof Some) {
                int n = $this.contributorDao.update((long)contributorIdUpdate, contributorToUpdate, contributorToUpdate.loginmaj());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contributor$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(42).append("Error validate Json to get contributor : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> ContributorController.$anonfun$delete$2(this, BoxesRunTime.unboxToInt((Object)validate)));
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contributor$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(42).append("Error validate Json to get contributor : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> ContributorController.$anonfun$getCountDelete$2(this, BoxesRunTime.unboxToInt((Object)validate)));
    }

    public String purge(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"purge"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)this.contributorDao.purge()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String replace(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Contributor$.MODULE$.replaceIdsRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(46).append("Error validate Json to replace contributor : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int code = validate._1$mcI$sp();
            int newCode = validate._2$mcI$sp();
            int result = $this.contributorDao.replace(code, newCode);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getContributorsTable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)ContributorTableInput$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(37).append("Can't parse contributor table input, ").append(error.toString()).toString(), 400), (Function1 & Serializable)input -> SieauFilteredTableLine$.MODULE$.generateJson($this.contributorDao.getContributorsTable(input), input.searchValue(), input.forceLoad(), input.previewSize()));
    }

    public static final /* synthetic */ String $anonfun$delete$2(ContributorController $this, int validate) {
        int result = $this.contributorDao.delete(validate);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getCountDelete$2(ContributorController $this, int validate) {
        int result = $this.contributorDao.getCountDelete(validate);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public ContributorController(ContributorsDao contributorDao, ContributorTypeDao contributorTypeDao, ContributorStatutDao contributorStatutDao, WSClient ws, ContributorDomainDao contributorDomainDao, LogUtil logUtil, ReferentialSandreCodeDao referentialSandreCodeDao) {
        this.contributorDao = contributorDao;
        this.contributorTypeDao = contributorTypeDao;
        this.contributorStatutDao = contributorStatutDao;
        this.contributorDomainDao = contributorDomainDao;
        this.logUtil = logUtil;
        this.userRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("codes").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.StringReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

