/*
 * Decompiled with CFR 0.152.
 */
package country.controller;

import fr.aquasys.daeau.referentials.country.itf.CountryDao;
import fr.aquasys.daeau.referentials.country.model.Country;
import fr.aquasys.daeau.referentials.country.model.Country$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\u0007\u000e\u0001IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006YA\u0007\u0005\tS\u0001\u0011\t\u0011)A\u0006U!)!\u0007\u0001C\u0001g!9!\t\u0001b\u0001\n\u0003\u0019\u0005BB.\u0001A\u0003%A\tC\u0003]\u0001\u0011\u0005Q\fC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\t\t2i\\;oiJL8i\u001c8ue>dG.\u001a:\u000b\u00059y\u0011AC2p]R\u0014x\u000e\u001c7fe*\t\u0001#A\u0004d_VtGO]=\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u0015\r|WO\u001c;ss\u0012\u000bw\u000e\u0005\u0002\u001cO5\tAD\u0003\u0002\u001e=\u0005\u0019\u0011\u000e\u001e4\u000b\u0005Ay\"B\u0001\u0011\"\u00031\u0011XMZ3sK:$\u0018.\u00197t\u0015\t\u00113%A\u0003eC\u0016\fWO\u0003\u0002%K\u00059\u0011-];bgf\u001c(\"\u0001\u0014\u0002\u0005\u0019\u0014\u0018B\u0001\u0015\u001d\u0005)\u0019u.\u001e8uef$\u0015m\\\u0001\bY><W\u000b^5m!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003vi&d'BA\u0018$\u0003!\u0011\u0018M\u00192ji6\f\u0018BA\u0019-\u0005\u001daunZ+uS2\fa\u0001P5oSRtD#\u0001\u001b\u0015\u0007U:\u0004\b\u0005\u00027\u00015\tQ\u0002C\u0003\u001a\u0007\u0001\u000f!\u0004C\u0003*\u0007\u0001\u000f!\u0006\u000b\u0002\u0004uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0007S:TWm\u0019;\u000b\u0003}\nQA[1wCbL!!\u0011\u001f\u0003\r%s'.Z2u\u0003!\u0019w\u000eZ3SK\u0006$W#\u0001#\u0011\u0007\u0015s\u0005+D\u0001G\u0015\t9\u0005*\u0001\u0003kg>t'BA%K\u0003\u0011a\u0017NY:\u000b\u0005-c\u0015aA1qS*\tQ*\u0001\u0003qY\u0006L\u0018BA(G\u0005\u0015\u0011V-\u00193t!\t\t\u0006L\u0004\u0002S-B\u00111+F\u0007\u0002)*\u0011Q+E\u0001\u0007yI|w\u000e\u001e \n\u0005]+\u0012A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!aV\u000b\u0002\u0013\r|G-\u001a*fC\u0012\u0004\u0013AB4fi\u0006cG\u000eF\u0003Q=\u000e\\W\u000eC\u0003`\r\u0001\u0007\u0001-A\u0004nKN\u001c\u0018mZ3\u0011\u0005\u0015\u000b\u0017B\u00012G\u0005\u001dQ5OV1mk\u0016DQ\u0001\u001a\u0004A\u0002\u0015\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003RMBC\u0017BA4[\u0005\ri\u0015\r\u001d\t\u0003)%L!A[\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003m\r\u0001\u0007\u0001+\u0001\u0004n_\u0012,H.\u001a\u0005\u0006]\u001a\u0001\r\u0001U\u0001\u0005kN,'/A\u0005hKR\u0014\u0015pQ8eKR)\u0001+\u001d:ti\")ql\u0002a\u0001A\")Am\u0002a\u0001K\")An\u0002a\u0001!\")an\u0002a\u0001!\u0006Aq-\u001a;D_VtG\u000fF\u0003QobL(\u0010C\u0003`\u0011\u0001\u0007\u0001\rC\u0003e\u0011\u0001\u0007Q\rC\u0003m\u0011\u0001\u0007\u0001\u000bC\u0003o\u0011\u0001\u0007\u0001+\u0001\u0004de\u0016\fG/\u001a\u000b\u0007!vtx0!\u0001\t\u000b}K\u0001\u0019\u00011\t\u000b\u0011L\u0001\u0019A3\t\u000b1L\u0001\u0019\u0001)\t\u000b9L\u0001\u0019\u0001)\u0002\rU\u0004H-\u0019;f)%\u0001\u0016qAA\u0005\u0003\u0017\ti\u0001C\u0003`\u0015\u0001\u0007\u0001\rC\u0003e\u0015\u0001\u0007Q\rC\u0003m\u0015\u0001\u0007\u0001\u000bC\u0003o\u0015\u0001\u0007\u0001+\u0001\u0004eK2,G/\u001a\u000b\n!\u0006M\u0011QCA\f\u00033AQaX\u0006A\u0002\u0001DQ\u0001Z\u0006A\u0002\u0015DQ\u0001\\\u0006A\u0002ACQA\\\u0006A\u0002A\u0003")
public class CountryController {
    private final CountryDao countryDao;
    private final LogUtil logUtil;
    private final Reads<String> codeRead;

    public Reads<String> codeRead() {
        return this.codeRead;
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.countryDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Country$.MODULE$.format())).toString();
    }

    public String getByCode(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(20).append("Can't get country :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> Json$.MODULE$.toJson((Object)$this.countryDao.getByCode(code), Writes$.MODULE$.OptionWrites((Writes)Country$.MODULE$.format())).toString());
    }

    public String getCount(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.countryDao.getCount()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Country$.MODULE$.readCountry()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(23).append("Can't create country :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            Option option = $this.countryDao.getByCode((String)validate.countryCode().get());
            if (option instanceof Some) {
                Some some = (Some)option;
                Country code = (Country)some.value();
                $this.logUtil.error(new StringBuilder(30).append("City already exist for code : ").append(code).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                Tuple2 tuple2 = $this.countryDao.create(validate);
                $this.logUtil.info(new StringBuilder(12).append("Create city ").append(tuple2._1()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(tuple2._1(), (Writes)Writes$.MODULE$.StringWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Country$.MODULE$.readCountry()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(20).append("Can't get country :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            Option option = $this.countryDao.getByCode((String)validate.countryCode().get());
            if (option instanceof Some) {
                int n = $this.countryDao.update(validate);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get city : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int result = $this.countryDao.delete(validate);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    @Inject
    public CountryController(CountryDao countryDao, LogUtil logUtil) {
        this.countryDao = countryDao;
        this.logUtil = logUtil;
        this.codeRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
    }
}

