/*
 * Decompiled with CFR 0.152.
 */
package resource.controller;

import fr.aquasys.daeau.referentials.resource.domain.Resource;
import fr.aquasys.daeau.referentials.resource.domain.Resource$;
import fr.aquasys.daeau.referentials.resource.domain.ResourceInput;
import fr.aquasys.daeau.referentials.resource.domain.ResourceInput$;
import fr.aquasys.daeau.referentials.resource.itf.ResourceDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006Y\u0001\t\u0005\t_\u0001\u0011\t\u0011)A\u0006a!A\u0001\b\u0001B\u0001B\u0003-\u0011\b\u0003\u0005A\u0001\t\u0005\t\u0015a\u0003B\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u001f\u0001!\u0002\u0013A\u0006bB=\u0001\u0005\u0004%\tA\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B>\t\u0013\u0005\u0005\u0001A1A\u0005\u0002\u0005\r\u0001\u0002CA\u0004\u0001\u0001\u0006I!!\u0002\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0018\u0001\t\u0003\tyF\u0001\nSKN|WO]2f\u0007>tGO]8mY\u0016\u0014(B\u0001\u000b\u0016\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002-\u0005A!/Z:pkJ\u001cWm\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-A\u0006sKN|WO]2f\t\u0006|\u0007CA\u0011.\u001b\u0005\u0011#BA\u0012%\u0003\rIGO\u001a\u0006\u0003-\u0015R!AJ\u0014\u0002\u0019I,g-\u001a:f]RL\u0017\r\\:\u000b\u0005!J\u0013!\u00023bK\u0006,(B\u0001\u0016,\u0003\u001d\t\u0017/^1tsNT\u0011\u0001L\u0001\u0003MJL!A\f\u0012\u0003\u0017I+7o\\;sG\u0016$\u0015m\\\u0001\bY><W\u000b^5m!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0003vi&d'BA\u001b*\u0003!\u0011\u0018M\u00192ji6\f\u0018BA\u001c3\u0005\u001daunZ+uS2\fa\"^:feN#\u0018\r^5p]\u0012\u000bw\u000e\u0005\u0002;}5\t1H\u0003\u0002$y)\u0011QhJ\u0001\u0005kN,'/\u0003\u0002@w\tqQk]3s'R\fG/[8o\t\u0006|\u0017aB;tKJ$\u0015m\u001c\t\u0003u\tK!aQ\u001e\u0003\u000fU\u001bXM\u001d#b_\u00061A(\u001b8jiz\"\u0012A\u0012\u000b\u0006\u000f&S5\n\u0014\t\u0003\u0011\u0002i\u0011a\u0005\u0005\u0006?\u0015\u0001\u001d\u0001\t\u0005\u0006_\u0015\u0001\u001d\u0001\r\u0005\u0006q\u0015\u0001\u001d!\u000f\u0005\u0006\u0001\u0016\u0001\u001d!\u0011\u0015\u0003\u000b9\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\r%t'.Z2u\u0015\u0005\u0019\u0016!\u00026bm\u0006D\u0018BA+Q\u0005\u0019IeN[3di\u0006\u0019\"/Z:pkJ\u001cW-\u00169eCR,'+Z1egV\t\u0001\fE\u0002ZE\u0012l\u0011A\u0017\u0006\u00037r\u000bAA[:p]*\u0011QLX\u0001\u0005Y&\u00147O\u0003\u0002`A\u0006\u0019\u0011\r]5\u000b\u0003\u0005\fA\u0001\u001d7bs&\u00111M\u0017\u0002\u0006%\u0016\fGm\u001d\t\u00055\u0015<W.\u0003\u0002g7\t1A+\u001e9mKJ\u0002\"\u0001[6\u000e\u0003%T!A\u001b\u0013\u0002\r\u0011|W.Y5o\u0013\ta\u0017N\u0001\u0005SKN|WO]2f!\tqWO\u0004\u0002pgB\u0011\u0001oG\u0007\u0002c*\u0011!oF\u0001\u0007yI|w\u000e\u001e \n\u0005Q\\\u0012A\u0002)sK\u0012,g-\u0003\u0002wo\n11\u000b\u001e:j]\u001eT!\u0001^\u000e\u0002)I,7o\\;sG\u0016,\u0006\u000fZ1uKJ+\u0017\rZ:!\u0003I\u0011Xm]8ve\u000e,\u0017J\u001c9viJ+\u0017\rZ:\u0016\u0003m\u00042!\u00172}!\tAW0\u0003\u0002\u007fS\ni!+Z:pkJ\u001cW-\u00138qkR\f1C]3t_V\u00148-Z%oaV$(+Z1eg\u0002\nQB]3t_V\u00148-\u001a*fC\u0012\u001cXCAA\u0003!\rI&-\\\u0001\u000fe\u0016\u001cx.\u001e:dKJ+\u0017\rZ:!\u0003\u00199W\r^!mYRIQ.!\u0004\u0002\u0018\u0005\u001d\u00121\u0006\u0005\b\u0003\u001fa\u0001\u0019AA\t\u0003\u001diWm]:bO\u0016\u00042!WA\n\u0013\r\t)B\u0017\u0002\b\u0015N4\u0016\r\\;f\u0011\u001d\tI\u0002\u0004a\u0001\u00037\tq\u0001[3bI\u0016\u00148\u000f\u0005\u0004o\u0003;i\u0017\u0011E\u0005\u0004\u0003?9(aA'baB\u0019!$a\t\n\u0007\u0005\u00152DA\u0002B]fDa!!\u000b\r\u0001\u0004i\u0017AB7pIVdW\rC\u0003>\u0019\u0001\u0007Q.A\u0006hKR\u0014Vm]8ve\u000e,G#C7\u00022\u0005M\u0012QGA\u001c\u0011\u001d\ty!\u0004a\u0001\u0003#Aq!!\u0007\u000e\u0001\u0004\tY\u0002\u0003\u0004\u0002*5\u0001\r!\u001c\u0005\u0006{5\u0001\r!\\\u0001\u000fkB$\u0017\r^3SKN|WO]2f)%i\u0017QHA \u0003\u0003\n\u0019\u0005C\u0004\u0002\u00109\u0001\r!!\u0005\t\u000f\u0005ea\u00021\u0001\u0002\u001c!1\u0011\u0011\u0006\bA\u00025DQ!\u0010\bA\u00025\fa\"\u001b8tKJ$(+Z:pkJ\u001cW\rF\u0005n\u0003\u0013\nY%!\u0014\u0002P!9\u0011qB\bA\u0002\u0005E\u0001bBA\r\u001f\u0001\u0007\u00111\u0004\u0005\u0007\u0003Sy\u0001\u0019A7\t\u000buz\u0001\u0019A7\u0002\u001d\u001d,GoQ8v]R$U\r\\3uKRIQ.!\u0016\u0002X\u0005e\u00131\f\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0011\u001d\tI\u0002\u0005a\u0001\u00037Aa!!\u000b\u0011\u0001\u0004i\u0007\"B\u001f\u0011\u0001\u0004i\u0017A\u00043fY\u0016$XMU3t_V\u00148-\u001a\u000b\n[\u0006\u0005\u00141MA3\u0003OBq!a\u0004\u0012\u0001\u0004\t\t\u0002C\u0004\u0002\u001aE\u0001\r!a\u0007\t\r\u0005%\u0012\u00031\u0001n\u0011\u0015i\u0014\u00031\u0001nQ\r\u0001\u00111\u000e\t\u0004\u001f\u00065\u0014bAA8!\nI1+\u001b8hY\u0016$xN\u001c")
public class ResourceController {
    private final ResourceDao resourceDao;
    private final LogUtil logUtil;
    private final UserStationDao userStationDao;
    private final Reads<Tuple2<Resource, String>> resourceUpdateReads;
    private final Reads<ResourceInput> resourceInputReads;
    private final Reads<String> resourceReads;

    public Reads<Tuple2<Resource, String>> resourceUpdateReads() {
        return this.resourceUpdateReads;
    }

    public Reads<ResourceInput> resourceInputReads() {
        return this.resourceInputReads;
    }

    public Reads<String> resourceReads() {
        return this.resourceReads;
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.userModuleReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Error validate Json to get all resources :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validateUser = (String)tuple2._1();
            String module = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validateUser, (Object)module);
            String validateUser2 = (String)tuple22._1();
            String module2 = (String)tuple22._2();
            Seq result = $this.resourceDao.getAll((Option)new Some((Object)CommonReadUtil$.MODULE$.getAllowedResourceIds(validateUser2, module2, $this.userStationDao, $this.resourceDao)));
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Resource$.MODULE$.resourceWrites())).toString();
        });
    }

    public String getResource(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.resourceReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get Resource", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> {
            Option option = $this.resourceDao.getResource(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id)));
            if (option instanceof Some) {
                Some some = (Some)option;
                Resource resource = (Resource)some.value();
                return Json$.MODULE$.toJson((Object)resource, (Writes)Resource$.MODULE$.resourceWrites()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.info(new StringBuilder(19).append("Resource not found ").append((String)id).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String updateResource(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.resourceUpdateReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get resource update input", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource resource = (Resource)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)resource, (Object)user);
            Resource resource2 = (Resource)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.resourceDao.update(resource2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String insertResource(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.resourceInputReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(30).append("Can't validate resource input ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)resource -> {
            Tuple2 tuple2 = $this.resourceDao.insert(resource);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int result = tuple2._1$mcI$sp();
            long id = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(result, id);
            int result2 = sp2._1$mcI$sp();
            long id2 = sp2._2$mcJ$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)id2), (Writes)Writes$.MODULE$.LongWrites()))})).toString();
        });
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.resourceReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Error validate Json to get resource", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)validate -> {
            int result = $this.resourceDao.getCountDelete(validate);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteResource(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.resourceReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get resource id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)id -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.resourceDao.delete(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id)))), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    @Inject
    public ResourceController(ResourceDao resourceDao, LogUtil logUtil, UserStationDao userStationDao, UserDao userDao) {
        this.resourceDao = resourceDao;
        this.logUtil = logUtil;
        this.userStationDao = userStationDao;
        this.resourceUpdateReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("resource").read((Reads)Resource$.MODULE$.resourceWrites()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.resourceInputReads = JsPath$.MODULE$.$bslash("resource").read((Reads)ResourceInput$.MODULE$.resourceInputWrites());
        this.resourceReads = JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.StringReads());
    }
}

