/*
 * Decompiled with CFR 0.152.
 */
package taxon;

import city.model.CityFile;
import city.model.CityFile$;
import fr.aquasys.daeau.referentials.taxon.itf.TaxonDao;
import fr.aquasys.daeau.referentials.taxon.model.Taxon;
import fr.aquasys.daeau.referentials.taxon.model.Taxon$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StringUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.XML;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import sandre.dao.ReferentialSandreCodeDao;
import sandre.model.ReferentialSandreCode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import synchro.JobSynchroTaxon;
import taxon.model.AppelTaxonParent;
import taxon.model.NiveauTaxonomique;
import taxon.model.SandreTaxon$;
import taxon.model.TaxonFileInput;
import taxon.model.TaxonFileInput$;
import taxon.model.ThemeTaxonAppel;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001B\n\u0015\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ya\b\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!Aq\u0007\u0001B\u0001B\u0003-\u0001\b\u0003\u0005A\u0001\t\u0005\t\u0015a\u0003B\u0011!9\u0005A!A!\u0002\u0017A\u0005\"B*\u0001\t\u0003!\u0006\"\u00024\u0001\t\u00039\u0007bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002@\u0001!\t!!\u0011\t\u0013\u0005-\u0003A1A\u0005\u0002\u00055\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u0003\u0003A\u0011AAB\u0005=!\u0016\r_8o\u0007>tGO]8mY\u0016\u0014(\"A\u000b\u0002\u000bQ\f\u0007p\u001c8\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011\u0001%K\u0007\u0002C)\u0011!eI\u0001\u0005kRLGN\u0003\u0002%K\u0005A!/\u00192cSRl\u0017O\u0003\u0002'O\u00059\u0011-];bgf\u001c(\"\u0001\u0015\u0002\u0005\u0019\u0014\u0018B\u0001\u0016\"\u0005\u001daunZ+uS2\f\u0001\u0002^1y_:$\u0015m\u001c\t\u0003[Uj\u0011A\f\u0006\u0003_A\n1!\u001b;g\u0015\t)\u0012G\u0003\u00023g\u0005a!/\u001a4fe\u0016tG/[1mg*\u0011A'J\u0001\u0006I\u0006,\u0017-^\u0005\u0003m9\u0012\u0001\u0002V1y_:$\u0015m\\\u0001\u0019e\u00164WM]3oi&\fGnU1oIJ,7i\u001c3f\t\u0006|\u0007CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\r!\u0017m\u001c\u0006\u0002{\u000511/\u00198ee\u0016L!a\u0010\u001e\u00031I+g-\u001a:f]RL\u0017\r\\*b]\u0012\u0014XmQ8eK\u0012\u000bw.A\bK_\n\u001c\u0016P\\2ie>$\u0016\r_8o!\t\u0011U)D\u0001D\u0015\u0005!\u0015aB:z]\u000eD'o\\\u0005\u0003\r\u000e\u0013qBS8c'ft7\r\u001b:p)\u0006DxN\\\u0001\u0003oN\u0004\"!S)\u000e\u0003)S!aR&\u000b\u00051k\u0015\u0001\u00027jENT!AT(\u0002\u0007\u0005\u0004\u0018NC\u0001Q\u0003\u0011\u0001H.Y=\n\u0005IS%\u0001C,T\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\u0005)FC\u0002,Y3j[F\f\u0005\u0002X\u00015\tA\u0003C\u0003\u001f\r\u0001\u000fq\u0004C\u0003,\r\u0001\u000fA\u0006C\u00038\r\u0001\u000f\u0001\bC\u0003A\r\u0001\u000f\u0011\tC\u0003H\r\u0001\u000f\u0001\n\u000b\u0002\u0007=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u0007S:TWm\u0019;\u000b\u0003\r\fQA[1wCbL!!\u001a1\u0003\r%s'.Z2u\u0003\u00199W\r^!mYR9\u0001n]>\u0002\b\u0005-\u0001CA5q\u001d\tQg\u000e\u0005\u0002l55\tAN\u0003\u0002n-\u00051AH]8pizJ!a\u001c\u000e\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_jAQ\u0001^\u0004A\u0002U\fq!\\3tg\u0006<W\r\u0005\u0002ws6\tqO\u0003\u0002y\u0017\u0006!!n]8o\u0013\tQxOA\u0004KgZ\u000bG.^3\t\u000bq<\u0001\u0019A?\u0002\u000f!,\u0017\rZ3sgB)\u0011N 5\u0002\u0002%\u0011qP\u001d\u0002\u0004\u001b\u0006\u0004\bcA\r\u0002\u0004%\u0019\u0011Q\u0001\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\n\u001d\u0001\r\u0001[\u0001\u0007[>$W\u000f\\3\t\r\u00055q\u00011\u0001i\u0003\u0011)8/\u001a:\u0002\u0013U\u0004Hn\\1e\u0007N3F#\u00035\u0002\u0014\u0005U\u0011qCA\r\u0011\u0015!\b\u00021\u0001v\u0011\u0015a\b\u00021\u0001~\u0011\u0019\tI\u0001\u0003a\u0001Q\"1\u0011Q\u0002\u0005A\u0002!\f\u0011\"\u001e9m_\u0006$\u0007,\u0014'\u0015\u0013!\fy\"!\t\u0002$\u0005\u0015\u0002\"\u0002;\n\u0001\u0004)\b\"\u0002?\n\u0001\u0004i\bBBA\u0005\u0013\u0001\u0007\u0001\u000e\u0003\u0004\u0002\u000e%\u0001\r\u0001[\u0001\u0004O\u0016$H#\u00035\u0002,\u00055\u0012qFA\u0019\u0011\u0015!(\u00021\u0001v\u0011\u0015a(\u00021\u0001~\u0011\u0019\tIA\u0003a\u0001Q\"1\u0011Q\u0002\u0006A\u0002!\faa\u0019:fCR,G#\u00035\u00028\u0005e\u00121HA\u001f\u0011\u0015!8\u00021\u0001v\u0011\u0015a8\u00021\u0001~\u0011\u0019\tIa\u0003a\u0001Q\"1\u0011QB\u0006A\u0002!\fa!\u001e9eCR,G#\u00035\u0002D\u0005\u0015\u0013qIA%\u0011\u0015!H\u00021\u0001v\u0011\u0015aH\u00021\u0001~\u0011\u0019\tI\u0001\u0004a\u0001Q\"1\u0011Q\u0002\u0007A\u0002!\fqB]3qY\u0006\u001cWmQ8eKJ+\u0017\rZ\u000b\u0003\u0003\u001f\u0002RA^A)\u0003+J1!a\u0015x\u0005\u0015\u0011V-\u00193t!\u0015I\u0012q\u000b5i\u0013\r\tIF\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0002!I,\u0007\u000f\\1dK\u000e{G-\u001a*fC\u0012\u0004\u0013a\u0002:fa2\f7-\u001a\u000b\nQ\u0006\u0005\u00141MA3\u0003OBQ\u0001^\bA\u0002UDQ\u0001`\bA\u0002uDa!!\u0003\u0010\u0001\u0004A\u0007BBA\u0007\u001f\u0001\u0007\u0001.\u0001\bhKR\u001cu.\u001e8u\t\u0016dW\r^3\u0015\u0013!\fi'a\u001c\u0002r\u0005M\u0004\"\u0002;\u0011\u0001\u0004)\b\"\u0002?\u0011\u0001\u0004i\bBBA\u0005!\u0001\u0007\u0001\u000e\u0003\u0004\u0002\u000eA\u0001\r\u0001[\u0001\u0007I\u0016dW\r^3\u0015\u0013!\fI(a\u001f\u0002~\u0005}\u0004\"\u0002;\u0012\u0001\u0004)\b\"\u0002?\u0012\u0001\u0004i\bBBA\u0005#\u0001\u0007\u0001\u000e\u0003\u0004\u0002\u000eE\u0001\r\u0001[\u0001\u0006G>,h\u000e\u001e\u000b\nQ\u0006\u0015\u0015qQAE\u0003\u0017CQ\u0001\u001e\nA\u0002UDQ\u0001 \nA\u0002uDa!!\u0003\u0013\u0001\u0004A\u0007BBA\u0007%\u0001\u0007\u0001\u000e")
public class TaxonController {
    private final LogUtil logUtil;
    private final TaxonDao taxonDao;
    private final ReferentialSandreCodeDao referentialSandreCodeDao;
    private final JobSynchroTaxon JobSynchroTaxon;
    private final Reads<Tuple2<String, String>> replaceCodeRead;

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq res = this.taxonDao.getAllLight();
        return new StringBuilder(2).append("[").append(((IterableOnceOps)res.map((Function1 & Serializable)c -> StringUtil$.MODULE$.stringify((Seq)new .colon.colon((Object)new Some((Object)c.code()), (List)new .colon.colon((Object)c.latinName(), (List)new .colon.colon((Object)c.active(), (List)new .colon.colon((Object)c.status(), (List)new .colon.colon((Object)c.level(), (List)new .colon.colon((Object)c.theme(), (List)Nil$.MODULE$))))))))).mkString(",")).append("]").toString();
    }

    public String uploadCSV(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CityFile$.MODULE$.writes()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError("Can't validate import csv object", 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)file -> {
            int index = file.fileContent().indexOf("base64,") + 7;
            Source bufferedSource = Source$.MODULE$.fromBytes(Base64.decodeBase64((String)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(file.fileContent()), index)), "UTF-8");
            IntRef nbTaxonsInsert = IntRef.create((int)0);
            IntRef nbTaxonsUpdate = IntRef.create((int)0);
            DateTimeFormatter dateTimeFormat = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
            bufferedSource.getLines().drop(1).foreach((Function1 & Serializable)line -> {
                TaxonController.$anonfun$uploadCSV$3(this, dateTimeFormat, nbTaxonsUpdate, file, nbTaxonsInsert, line);
                return BoxedUnit.UNIT;
            });
            bufferedSource.close();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insertTaxons"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbTaxonsInsert.elem), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updateTaxons"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbTaxonsUpdate.elem), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String uploadXML(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CityFile$.MODULE$.writes()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError("Can't validate import xml object", 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)file -> {
            String string;
            int index = file.fileContent().indexOf("base64,") + 7;
            Source bufferedSource = Source$.MODULE$.fromBytes(Base64.decodeBase64((String)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(file.fileContent()), index)), "UTF-8");
            try {
                Seq seq;
                ObjectRef textXml = ObjectRef.create((Object)"");
                bufferedSource.getLines().foreach((Function1 & Serializable)line -> {
                    textXml.elem = new StringBuilder(0).append((String)textXml.elem).append(line).toString();
                    return BoxedUnit.UNIT;
                });
                String jsObject = XML.toJSONObject((String)((String)textXml.elem).replace(" schemeAgencyID=\"SANDRE\">", ">")).toString();
                JsValue samples = Json$.MODULE$.parse(jsObject);
                String RESULT_REFERENCIAL_UPPERCASE = "REFERENTIELS";
                String RESULT_REFERENCIAL = "Referentiel";
                String RESULT_TAXON = "AppelTaxon";
                Option option = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(samples), RESULT_REFERENCIAL_UPPERCASE)), RESULT_REFERENCIAL)), RESULT_TAXON).toOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JsValue call = (JsValue)some.value();
                    JsResult jsResult = call.validate(SandreTaxon$.MODULE$.read());
                    if (jsResult != null) {
                        Seq listOfTaxonsOutput;
                        JsResult jsResult2 = jsResult;
                        seq = listOfTaxonsOutput = (Seq)jsResult2.get();
                    } else {
                        seq = (Seq)Nil$.MODULE$;
                    }
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                Seq tabTaxons = seq;
                DateTimeFormatter dateTimeFormat = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
                Seq taxons = (Seq)tabTaxons.map((Function1 & Serializable)t -> {
                    None$ elementOf = t.AppelTaxonParent().isDefined() ? new Some((Object)((AppelTaxonParent)t.AppelTaxonParent().get()).CdAppelTaxon().getOrElse((Function0 & Serializable)() -> "").toString()) : None$.MODULE$;
                    None$ theme = t.ThemeTaxonAppel().isDefined() ? new Some((Object)BoxesRunTime.boxToDouble((double)((ThemeTaxonAppel)t.ThemeTaxonAppel().get()).CdThemeTaxon())) : None$.MODULE$;
                    None$ level = t.NiveauTaxonomique().isDefined() ? new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)((NiveauTaxonomique)t.NiveauTaxonomique().get()).AbTax().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))) : None$.MODULE$;
                    None$ creationDate = t.DateCreationAppelTaxon().isDefined() ? new Some((Object)DateTime.parse((String)((String)t.DateCreationAppelTaxon().get()), (DateTimeFormatter)dateTimeFormat)) : None$.MODULE$;
                    None$ updateDate = t.DateMajAppelTaxon().isDefined() ? new Some((Object)DateTime.parse((String)((String)t.DateMajAppelTaxon().get()), (DateTimeFormatter)dateTimeFormat)) : None$.MODULE$;
                    String x$1 = Integer.toString(t.CdAppelTaxon());
                    Option<String> x$2 = t.NomLatinAppelTaxon();
                    Option<String> x$3 = t.StAppelTaxon();
                    None$ x$4 = creationDate;
                    None$ x$5 = updateDate;
                    Option<String> x$6 = t.AuteurAppelTaxon();
                    Option<String> x$7 = t.RedacteurFicheAppelTaxon();
                    None$ x$8 = None$.MODULE$;
                    Option<String> x$9 = t.RefBiblioAppelTaxon();
                    Option<String> x$10 = t.ComAppelTaxon();
                    None$ x$11 = None$.MODULE$;
                    None$ x$12 = elementOf;
                    None$ x$13 = theme;
                    None$ x$14 = level;
                    None$ x$15 = None$.MODULE$;
                    None$ x$16 = None$.MODULE$;
                    None$ x$17 = None$.MODULE$;
                    None$ x$18 = None$.MODULE$;
                    None$ x$19 = None$.MODULE$;
                    None$ x$20 = None$.MODULE$;
                    None$ x$21 = None$.MODULE$;
                    None$ x$22 = None$.MODULE$;
                    None$ x$23 = None$.MODULE$;
                    None$ x$24 = None$.MODULE$;
                    None$ x$25 = None$.MODULE$;
                    None$ x$26 = None$.MODULE$;
                    None$ x$27 = None$.MODULE$;
                    None$ x$28 = None$.MODULE$;
                    None$ x$29 = None$.MODULE$;
                    None$ x$30 = None$.MODULE$;
                    None$ x$31 = None$.MODULE$;
                    None$ x$32 = None$.MODULE$;
                    None$ x$33 = None$.MODULE$;
                    None$ x$34 = None$.MODULE$;
                    None$ x$35 = None$.MODULE$;
                    None$ x$36 = None$.MODULE$;
                    None$ x$37 = None$.MODULE$;
                    None$ x$38 = None$.MODULE$;
                    None$ x$39 = None$.MODULE$;
                    Option x$40 = Taxon$.MODULE$.$lessinit$greater$default$40();
                    return new Taxon(x$1, x$2, x$3, (Option)x$4, (Option)x$5, x$6, x$7, (Option)x$8, x$9, x$10, (Option)x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, (Option)x$20, (Option)x$21, (Option)x$22, (Option)x$23, (Option)x$24, (Option)x$25, (Option)x$26, (Option)x$27, (Option)x$28, (Option)x$29, (Option)x$30, (Option)x$31, (Option)x$32, (Option)x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$39, (Option)x$37, (Option)x$38, x$40);
                });
                Tuple2<Object, Object> nbTaxons = $this.JobSynchroTaxon.synchro((Seq<Taxon>)taxons, file.insertOrUpdate());
                Option<ReferentialSandreCode> option2 = $this.referentialSandreCodeDao.get("TAXONS");
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    ReferentialSandreCode ref = (ReferentialSandreCode)some.value();
                    Some x$41 = new Some((Object)new DateTime());
                    Option<String> x$42 = file.user();
                    Some x$43 = new Some((Object)"2");
                    String x$44 = ref.copy$default$1();
                    Option<Object> x$45 = ref.copy$default$2();
                    Option<String> x$46 = ref.copy$default$5();
                    ReferentialSandreCode copyRef = ref.copy(x$44, x$45, (Option<String>)x$43, (Option<DateTime>)x$41, x$46, x$42);
                    BoxesRunTime.boxToInteger((int)$this.referentialSandreCodeDao.update(copyRef));
                } else if (None$.MODULE$.equals(option2)) {
                } else {
                    throw new MatchError(option2);
                }
                bufferedSource.close();
                string = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insertTaxons"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbTaxons._2$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updateTaxons"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbTaxons._1$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder(2).append(e.getMessage()).append(":\n");
                e.printStackTrace();
                string = ErrorUtil$.MODULE$.jsonError(stringBuilder.append(BoxedUnit.UNIT).toString(), 500, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            return string;
        });
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Taxon$.MODULE$.readCode()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get taxon :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> Json$.MODULE$.toJson((Object)$this.taxonDao.get(code), Writes$.MODULE$.OptionWrites((Writes)Taxon$.MODULE$.taxonFormat())).toString());
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)Taxon$.MODULE$.taxonFormat()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate taxon input", 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)taxon -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.taxonDao.insert(taxon)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)Taxon$.MODULE$.taxonFormat()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate taxon input", 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)taxon -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.taxonDao.update(taxon)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public Reads<Tuple2<String, String>> replaceCodeRead() {
        return this.replaceCodeRead;
    }

    public String replace(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.replaceCodeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to replace taxon : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            String code = (String)validate._1();
            String newCode = (String)validate._2();
            int result = $this.taxonDao.replace(code, newCode);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Taxon$.MODULE$.readCode()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(36).append("Error validate Json to get taxon : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)taxonCode -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.taxonDao.getCountDelete(taxonCode)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Taxon$.MODULE$.readCode()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(39).append("Error validate Json to delete taxon : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)taxonCode -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.taxonDao.delete(taxonCode)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String count(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.taxonDao.count()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public static final /* synthetic */ void $anonfun$uploadCSV$3(TaxonController $this, DateTimeFormatter dateTimeFormat$1, IntRef nbTaxonsUpdate$1, CityFile file$1, IntRef nbTaxonsInsert$1, String line) {
        block3: {
            String[] csvLine = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{line}), (Function1 & Serializable)s -> s.split(";", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class));
            try {
                None$ level = !csvLine[10].isEmpty() ? new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(csvLine[10])))) : None$.MODULE$;
                double theme = !csvLine[11].isEmpty() ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(csvLine[11])) : 0.0;
                String x$12 = csvLine[0];
                String x$2 = csvLine[1];
                Some x$3 = new Some((Object)csvLine[2]);
                Some x$4 = new Some((Object)DateTime.parse((String)csvLine[3], (DateTimeFormatter)dateTimeFormat$1));
                Some x$5 = new Some((Object)DateTime.parse((String)csvLine[4], (DateTimeFormatter)dateTimeFormat$1));
                Some x$6 = new Some((Object)csvLine[5]);
                Some x$7 = new Some((Object)csvLine[6]);
                Some x$8 = new Some((Object)csvLine[7]);
                Some x$9 = new Some((Object)csvLine[8]);
                Some x$10 = new Some((Object)csvLine[9]);
                None$ x$11 = level;
                double x$122 = theme;
                Some x$13 = new Some((Object)csvLine[12]);
                Some x$14 = new Some((Object)csvLine[13]);
                Some x$15 = new Some((Object)csvLine[14]);
                Some x$16 = new Some((Object)csvLine[15]);
                None$ x$17 = None$.MODULE$;
                None$ x$18 = None$.MODULE$;
                None$ x$19 = None$.MODULE$;
                TaxonFileInput taxon = new TaxonFileInput(x$12, x$2, (Option<String>)x$3, (Option<DateTime>)x$4, (Option<DateTime>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<String>)x$9, (Option<String>)x$10, (Option<Object>)x$11, x$122, (Option<String>)x$13, (Option<String>)x$14, (Option<String>)x$15, (Option<String>)x$16, (Option<String>)x$19, (Option<String>)x$17, (Option<String>)x$18);
                Option option = $this.taxonDao.get(csvLine[0]);
                if (option instanceof Some) {
                    $this.taxonDao.update(TaxonFileInput$.MODULE$.toTaxon(taxon));
                    ++nbTaxonsUpdate$1.elem;
                    break block3;
                }
                if (!file$1.insertOrUpdate()) break block3;
                $this.taxonDao.insert(TaxonFileInput$.MODULE$.toTaxon(taxon));
                ++nbTaxonsInsert$1.elem;
            }
            catch (Exception e) {
                LogUtil logUtil = $this.logUtil;
                StringBuilder stringBuilder = new StringBuilder(2).append(e.getMessage()).append(":\n");
                e.printStackTrace();
                logUtil.error(stringBuilder.append(BoxedUnit.UNIT).toString(), $this.logUtil.error$default$2());
            }
        }
    }

    @Inject
    public TaxonController(LogUtil logUtil, TaxonDao taxonDao, ReferentialSandreCodeDao referentialSandreCodeDao, JobSynchroTaxon JobSynchroTaxon2, WSClient ws) {
        this.logUtil = logUtil;
        this.taxonDao = taxonDao;
        this.referentialSandreCodeDao = referentialSandreCodeDao;
        this.JobSynchroTaxon = JobSynchroTaxon2;
        this.replaceCodeRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("replaceCode").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

