/*
 * Decompiled with CFR 0.152.
 */
package unit;

import fr.aquasys.daeau.referentials.unit.itf.UnitDao;
import fr.aquasys.daeau.referentials.unit.model.Unit;
import fr.aquasys.daeau.referentials.unit.model.Unit$;
import fr.aquasys.daeau.referentials.unit.model.UnitInput;
import fr.aquasys.daeau.referentials.unit.model.UnitInput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import sandre.dao.ReferentialSandreCodeDao;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\t\u0013\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006Y!\b\u0005\tY\u0001\u0011\t\u0011)A\u0006[!AQ\u0007\u0001B\u0001B\u0003-a\u0007\u0003\u0005?\u0001\t\u0005\t\u0015a\u0003@\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u001da\u0006A1A\u0005\u0002uCaa\u001f\u0001!\u0002\u0013q\u0006\"\u0002?\u0001\t\u0003i\bbBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0002\u000f+:LGoQ8oiJ|G\u000e\\3s\u0015\u0005\u0019\u0012\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fq!\u001e8ji\u0012\u000bw\u000e\u0005\u0002\u001fU5\tqD\u0003\u0002!C\u0005\u0019\u0011\u000e\u001e4\u000b\u0005M\u0011#BA\u0012%\u00031\u0011XMZ3sK:$\u0018.\u00197t\u0015\t)c%A\u0003eC\u0016\fWO\u0003\u0002(Q\u00059\u0011-];bgf\u001c(\"A\u0015\u0002\u0005\u0019\u0014\u0018BA\u0016 \u0005\u001d)f.\u001b;EC>\fq\u0001\\8h+RLG\u000e\u0005\u0002/g5\tqF\u0003\u00021c\u0005!Q\u000f^5m\u0015\t\u0011d%\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0013\t!tFA\u0004M_\u001e,F/\u001b7\u00021I,g-\u001a:f]RL\u0017\r\\*b]\u0012\u0014XmQ8eK\u0012\u000bw\u000e\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005\u0019A-Y8\u000b\u0003m\naa]1oIJ,\u0017BA\u001f9\u0005a\u0011VMZ3sK:$\u0018.\u00197TC:$'/Z\"pI\u0016$\u0015m\\\u0001\u0003oN\u0004\"\u0001\u0011%\u000e\u0003\u0005S!A\u0010\"\u000b\u0005\r#\u0015\u0001\u00027jENT!!\u0012$\u0002\u0007\u0005\u0004\u0018NC\u0001H\u0003\u0011\u0001H.Y=\n\u0005%\u000b%\u0001C,T\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\u0005aE#B'P!F\u0013\u0006C\u0001(\u0001\u001b\u0005\u0011\u0002\"\u0002\u000f\u0006\u0001\bi\u0002\"\u0002\u0017\u0006\u0001\bi\u0003\"B\u001b\u0006\u0001\b1\u0004\"\u0002 \u0006\u0001\by\u0004FA\u0003U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0004j]*,7\r\u001e\u0006\u00023\u0006)!.\u0019<bq&\u00111L\u0016\u0002\u0007\u0013:TWm\u0019;\u0002\u0015Ut\u0017\u000e^3SK\u0006$7/F\u0001_!\ry&\rZ\u0007\u0002A*\u0011\u0011MQ\u0001\u0005UN|g.\u0003\u0002dA\n)!+Z1egB\u0019q#Z4\n\u0005\u0019D\"AB(qi&|g\u000eE\u0002iaNt!!\u001b8\u000f\u0005)lW\"A6\u000b\u00051$\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\ty\u0007$A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0014(aA*fc*\u0011q\u000e\u0007\t\u0003ibt!!\u001e<\u0011\u0005)D\u0012BA<\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]D\u0012aC;oSR,'+Z1eg\u0002\n\u0001bZ3u+:LGo\u001d\u000b\tgz\f9!a\u0006\u0002\u001c!1q\u0010\u0003a\u0001\u0003\u0003\tq!\\3tg\u0006<W\rE\u0002`\u0003\u0007I1!!\u0002a\u0005\u001dQ5OV1mk\u0016Dq!!\u0003\t\u0001\u0004\tY!A\u0004iK\u0006$WM]:\u0011\rQ\fia]A\t\u0013\r\tyA\u001f\u0002\u0004\u001b\u0006\u0004\bcA\f\u0002\u0014%\u0019\u0011Q\u0003\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\u001a!\u0001\ra]\u0001\u0007[>$W\u000f\\3\t\r\u0005u\u0001\u00021\u0001t\u0003\u0011)8/\u001a:\u0002\u000f\u001d,G/\u00168jiRI1/a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u0005\u0007\u007f&\u0001\r!!\u0001\t\u000f\u0005%\u0011\u00021\u0001\u0002\f!1\u0011\u0011D\u0005A\u0002MDa!!\b\n\u0001\u0004\u0019\u0018\u0001C4fi\u000e{WO\u001c;\u0015\u0013M\fy#!\r\u00024\u0005U\u0002BB@\u000b\u0001\u0004\t\t\u0001C\u0004\u0002\n)\u0001\r!a\u0003\t\r\u0005e!\u00021\u0001t\u0011\u0019\tiB\u0003a\u0001g\u00061Q\u000f\u001d3bi\u0016$\u0012b]A\u001e\u0003{\ty$!\u0011\t\r}\\\u0001\u0019AA\u0001\u0011\u001d\tIa\u0003a\u0001\u0003\u0017Aa!!\u0007\f\u0001\u0004\u0019\bBBA\u000f\u0017\u0001\u00071/\u0001\u0004de\u0016\fG/\u001a\u000b\ng\u0006\u001d\u0013\u0011JA&\u0003\u001bBaa \u0007A\u0002\u0005\u0005\u0001bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\u0007\u00033a\u0001\u0019A:\t\r\u0005uA\u00021\u0001t\u0003\u0019!W\r\\3uKRI1/a\u0015\u0002V\u0005]\u0013\u0011\f\u0005\u0007\u007f6\u0001\r!!\u0001\t\u000f\u0005%Q\u00021\u0001\u0002\f!1\u0011\u0011D\u0007A\u0002MDa!!\b\u000e\u0001\u0004\u0019\u0018AD4fi\u000e{WO\u001c;EK2,G/\u001a\u000b\ng\u0006}\u0013\u0011MA2\u0003KBaa \bA\u0002\u0005\u0005\u0001bBA\u0005\u001d\u0001\u0007\u00111\u0002\u0005\u0007\u00033q\u0001\u0019A:\t\r\u0005ua\u00021\u0001t\u0003\u0015\u0001XO]4f)%\u0019\u00181NA7\u0003_\n\t\b\u0003\u0004\u0000\u001f\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u0013y\u0001\u0019AA\u0006\u0011\u0019\tIb\u0004a\u0001g\"1\u0011QD\bA\u0002M\fqA]3qY\u0006\u001cW\rF\u0005t\u0003o\nI(a\u001f\u0002~!1q\u0010\u0005a\u0001\u0003\u0003Aq!!\u0003\u0011\u0001\u0004\tY\u0001\u0003\u0004\u0002\u001aA\u0001\ra\u001d\u0005\u0007\u0003;\u0001\u0002\u0019A:)\u0007\u0001\t\t\tE\u0002V\u0003\u0007K1!!\"W\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class UnitController {
    private final UnitDao unitDao;
    private final LogUtil logUtil;
    private final Reads<Option<Seq<String>>> uniteReads;

    public Reads<Option<Seq<String>>> uniteReads() {
        return this.uniteReads;
    }

    public String getUnits(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.uniteReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get units :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)units -> {
            Option option = units;
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq unitsId = (Seq)some.value();
                return Json$.MODULE$.toJson(unitsId.flatMap((Function1 & Serializable)unit -> $this.unitDao.getUnit(unit)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Unit$.MODULE$.unitFormat())).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.toJson((Object)$this.unitDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Unit$.MODULE$.unitFormat())).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getUnit(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Unit$.MODULE$.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get units :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)unitCode -> {
            Option option = $this.unitDao.getUnit(unitCode);
            if (option instanceof Some) {
                Some some = (Some)option;
                Unit unit = (Unit)some.value();
                $this.logUtil.info(new StringBuilder(14).append("Return method ").append(unit.code()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)unit, (Writes)Unit$.MODULE$.unitFormat()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.info(new StringBuilder(17).append("Method not found ").append((String)unitCode).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)204), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getCount(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.unitDao.getCount()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UnitInput$.MODULE$.readUpdateUnit()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(17).append("Can't get unit :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)unitValidate -> {
            String unitIdUpdate = (String)unitValidate._1();
            UnitInput unitToUpdate = (UnitInput)unitValidate._2();
            Option option = $this.unitDao.getUnit(unitIdUpdate);
            if (option instanceof Some) {
                int n = $this.unitDao.update(UnitInput$.MODULE$.toUnit(unitToUpdate));
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(UnitInput$.MODULE$.readUnit());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            UnitInput unitInput = (UnitInput)jsSuccess.get();
            Unit unit = UnitInput$.MODULE$.toUnit(unitInput);
            Option option = this.unitDao.getUnit(unit.code());
            if (option instanceof Some) {
                this.logUtil.error(new StringBuilder(30).append("Unit already exist for code : ").append(unit.code()).toString(), this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                Tuple2 tuple2 = this.unitDao.create(unitInput);
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    int result = tuple2._2$mcI$sp();
                    String string2 = unit.code();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        this.logUtil.info(new StringBuilder(12).append("Create unit ").append(unit.code()).toString(), this.logUtil.info$default$2());
                        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Unit$.MODULE$.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get unit : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int result = $this.unitDao.delete(validate);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Unit$.MODULE$.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get unit : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int result = $this.unitDao.getCountDelete(validate);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String purge(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"purge"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)this.unitDao.purge()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String replace(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Unit$.MODULE$.replaceCodeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(39).append("Error validate Json to replace unit : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            String code = (String)validate._1();
            String newCode = (String)validate._2();
            int result = $this.unitDao.replace(code, newCode);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    @Inject
    public UnitController(UnitDao unitDao, LogUtil logUtil, ReferentialSandreCodeDao referentialSandreCodeDao, WSClient ws) {
        this.unitDao = unitDao;
        this.logUtil = logUtil;
        this.uniteReads = JsPath$.MODULE$.$bslash("units").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.StringReads()));
    }
}

