/*
 * Decompiled with CFR 0.152.
 */
package watermass;

import fr.aquasys.daeau.referentials.watermass.domain.WatermassInput;
import fr.aquasys.daeau.referentials.watermass.domain.WatermassInput$;
import fr.aquasys.daeau.referentials.watermass.itf.WatermassDao;
import fr.aquasys.daeau.referentials.watermass.model.Watermass;
import fr.aquasys.daeau.referentials.watermass.model.Watermass$;
import fr.aquasys.daeau.station.links.watermass.StationWatermassCoordinates$;
import fr.aquasys.daeau.station.links.watermass.StationWatermassDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import sandre.dao.ReferentialSandreCodeDao;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\t\u0013\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006Y!\b\u0005\tY\u0001\u0011\t\u0011)A\u0006[!A\u0001\b\u0001B\u0001B\u0003-\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015a\u0003C\u0011!Y\u0005A!A!\u0002\u0017a\u0005\"\u0002+\u0001\t\u0003)\u0006\"B4\u0001\t\u0003A\u0007bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003c\u0002A\u0011AA:\u0005M9\u0016\r^3s[\u0006\u001c8oQ8oiJ|G\u000e\\3s\u0015\u0005\u0019\u0012!C<bi\u0016\u0014X.Y:t\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u000319\u0018\r^3s[\u0006\u001c8\u000fR1p!\tq\"&D\u0001 \u0015\t\u0001\u0013%A\u0002ji\u001aT!a\u0005\u0012\u000b\u0005\r\"\u0013\u0001\u0004:fM\u0016\u0014XM\u001c;jC2\u001c(BA\u0013'\u0003\u0015!\u0017-Z1v\u0015\t9\u0003&A\u0004bcV\f7/_:\u000b\u0003%\n!A\u001a:\n\u0005-z\"\u0001D,bi\u0016\u0014X.Y:t\t\u0006|\u0017AA<t!\tqc'D\u00010\u0015\ta\u0003G\u0003\u00022e\u0005!A.\u001b2t\u0015\t\u0019D'A\u0002ba&T\u0011!N\u0001\u0005a2\f\u00170\u0003\u00028_\tAqkU\"mS\u0016tG/A\u0004m_\u001e,F/\u001b7\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001B;uS2T!A\u0010\u0014\u0002\u0011I\f'MY5u[FL!\u0001Q\u001e\u0003\u000f1{w-\u0016;jY\u0006\u00192\u000f^1uS>tw+\u0019;fe6\f7o\u001d#b_B\u00111)S\u0007\u0002\t*\u00111#\u0012\u0006\u0003\r\u001e\u000bQ\u0001\\5oWNT!\u0001\u0013\u0013\u0002\u000fM$\u0018\r^5p]&\u0011!\n\u0012\u0002\u0014'R\fG/[8o/\u0006$XM]7bgN$\u0015m\\\u0001\u0019e\u00164WM]3oi&\fGnU1oIJ,7i\u001c3f\t\u0006|\u0007CA'S\u001b\u0005q%BA(Q\u0003\r!\u0017m\u001c\u0006\u0002#\u000611/\u00198ee\u0016L!a\u0015(\u00031I+g-\u001a:f]RL\u0017\r\\*b]\u0012\u0014XmQ8eK\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0002-R1q+\u0017.\\9v\u0003\"\u0001\u0017\u0001\u000e\u0003IAQ\u0001\b\u0004A\u0004uAQ\u0001\f\u0004A\u00045BQ\u0001\u000f\u0004A\u0004eBQ!\u0011\u0004A\u0004\tCQa\u0013\u0004A\u00041C#AB0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017AB5oU\u0016\u001cGOC\u0001e\u0003\u0015Q\u0017M^1y\u0013\t1\u0017M\u0001\u0004J]*,7\r^\u0001\u0010O\u0016$\u0018\t\u001c7XCR,'/\\1tgR9\u0011\u000e\u001e?\u0002\n\u00055\u0001C\u00016r\u001d\tYw\u000e\u0005\u0002m15\tQN\u0003\u0002o)\u00051AH]8pizJ!\u0001\u001d\r\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003abAQ!^\u0004A\u0002Y\fq!\\3tg\u0006<W\r\u0005\u0002xu6\t\u0001P\u0003\u0002za\u0005!!n]8o\u0013\tY\bPA\u0004KgZ\u000bG.^3\t\u000bu<\u0001\u0019\u0001@\u0002\u000f!,\u0017\rZ3sgB)!n`5\u0002\u0004%\u0019\u0011\u0011A:\u0003\u00075\u000b\u0007\u000fE\u0002\u0018\u0003\u000bI1!a\u0002\u0019\u0005\r\te.\u001f\u0005\u0007\u0003\u00179\u0001\u0019A5\u0002\r5|G-\u001e7f\u0011\u0019\tya\u0002a\u0001S\u0006!Qo]3s\u000319W\r^,bi\u0016\u0014X.Y:t)%I\u0017QCA\f\u00033\tY\u0002C\u0003v\u0011\u0001\u0007a\u000fC\u0003~\u0011\u0001\u0007a\u0010\u0003\u0004\u0002\f!\u0001\r!\u001b\u0005\u0007\u0003\u001fA\u0001\u0019A5\u0002\u0017\u001d,Go\u0015;bi&|gn\u001d\u000b\nS\u0006\u0005\u00121EA\u0013\u0003OAQ!^\u0005A\u0002YDQ!`\u0005A\u0002yDa!a\u0003\n\u0001\u0004I\u0007BBA\b\u0013\u0001\u0007\u0011.\u0001\u0005hKR\u001cu.\u001e8u)%I\u0017QFA\u0018\u0003c\t\u0019\u0004C\u0003v\u0015\u0001\u0007a\u000fC\u0003~\u0015\u0001\u0007a\u0010\u0003\u0004\u0002\f)\u0001\r!\u001b\u0005\u0007\u0003\u001fQ\u0001\u0019A5\u0002\r\r\u0014X-\u0019;f)%I\u0017\u0011HA\u001e\u0003{\ty\u0004C\u0003v\u0017\u0001\u0007a\u000fC\u0003~\u0017\u0001\u0007a\u0010\u0003\u0004\u0002\f-\u0001\r!\u001b\u0005\u0007\u0003\u001fY\u0001\u0019A5\u0002\rU\u0004H-\u0019;f)%I\u0017QIA$\u0003\u0013\nY\u0005C\u0003v\u0019\u0001\u0007a\u000fC\u0003~\u0019\u0001\u0007a\u0010\u0003\u0004\u0002\f1\u0001\r!\u001b\u0005\u0007\u0003\u001fa\u0001\u0019A5\u0002\r\u0011,G.\u001a;f)%I\u0017\u0011KA*\u0003+\n9\u0006C\u0003v\u001b\u0001\u0007a\u000fC\u0003~\u001b\u0001\u0007a\u0010\u0003\u0004\u0002\f5\u0001\r!\u001b\u0005\u0007\u0003\u001fi\u0001\u0019A5\u0002\u001d\u001d,GoQ8v]R$U\r\\3uKRI\u0011.!\u0018\u0002`\u0005\u0005\u00141\r\u0005\u0006k:\u0001\rA\u001e\u0005\u0006{:\u0001\rA \u0005\u0007\u0003\u0017q\u0001\u0019A5\t\r\u0005=a\u00021\u0001j\u0003\u0015\u0001XO]4f)%I\u0017\u0011NA6\u0003[\ny\u0007C\u0003v\u001f\u0001\u0007a\u000fC\u0003~\u001f\u0001\u0007a\u0010\u0003\u0004\u0002\f=\u0001\r!\u001b\u0005\u0007\u0003\u001fy\u0001\u0019A5\u0002\u000fI,\u0007\u000f\\1dKRI\u0011.!\u001e\u0002x\u0005e\u00141\u0010\u0005\u0006kB\u0001\rA\u001e\u0005\u0006{B\u0001\rA \u0005\u0007\u0003\u0017\u0001\u0002\u0019A5\t\r\u0005=\u0001\u00031\u0001jQ\r\u0001\u0011q\u0010\t\u0004A\u0006\u0005\u0015bAABC\nI1+\u001b8hY\u0016$xN\u001c")
public class WatermassController {
    private final WatermassDao watermassDao;
    private final LogUtil logUtil;
    private final StationWatermassDao stationWatermassDao;

    public String getAllWatermass(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.watermassDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Watermass$.MODULE$.writes())).toString();
    }

    public String getWatermass(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(WatermassInput$.MODULE$.codeReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(18).append("Can't get units :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)watermassCode -> {
            Option option = $this.watermassDao.get(watermassCode);
            if (option instanceof Some) {
                Some some = (Some)option;
                Watermass watermass = (Watermass)some.value();
                $this.logUtil.info(new StringBuilder(14).append("Return method ").append(watermass.code()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)watermass, (Writes)Watermass$.MODULE$.writes()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.info(new StringBuilder(17).append("Method not found ").append((String)watermassCode).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)204), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getStations(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(WatermassInput$.MODULE$.codeReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String watermassCode = (String)jsSuccess.get();
            Seq qualitometerList = this.stationWatermassDao.getAllWithCode(StationTypeUtil$.MODULE$.QUALITY(), watermassCode);
            Seq piezometerList = this.stationWatermassDao.getAllWithCode(StationTypeUtil$.MODULE$.PIEZOMETRY(), watermassCode);
            Seq hydroList = this.stationWatermassDao.getAllWithCode(StationTypeUtil$.MODULE$.HYDROMETRY(), watermassCode);
            Seq result = (Seq)((IterableOps)qualitometerList.$plus$plus((IterableOnce)piezometerList)).$plus$plus((IterableOnce)hydroList);
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationWatermassCoordinates$.MODULE$.format())).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getCount(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.watermassDao.getCount()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(WatermassInput$.MODULE$.readWatermass());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            WatermassInput watermassInput = (WatermassInput)jsSuccess.get();
            Watermass watermass = WatermassInput$.MODULE$.toWatermass(watermassInput);
            Option option = this.watermassDao.get(watermass.code());
            if (option instanceof Some) {
                this.logUtil.error(new StringBuilder(35).append("Watermass already exist for code : ").append(watermass.code()).toString(), this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)409), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                Tuple2 tuple2 = this.watermassDao.create(watermassInput);
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    int result = tuple2._2$mcI$sp();
                    String string2 = watermass.code();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        this.logUtil.info(new StringBuilder(17).append("Create watermass ").append(watermass.code()).toString(), this.logUtil.info$default$2());
                        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watermass$.MODULE$.watermassUpdateRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(22).append("Can't get watermass :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)watermassValidate -> {
            Option option = $this.watermassDao.get((String)watermassValidate._1());
            if (option instanceof Some) {
                int n = $this.watermassDao.update((Watermass)watermassValidate._2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watermass$.MODULE$.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to get watermass : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int result = $this.watermassDao.delete(validate);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watermass$.MODULE$.codeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to get watermass : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            int result = $this.watermassDao.getCountDelete(validate);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String purge(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"purge"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)this.watermassDao.purge()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String replace(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watermass$.MODULE$.replaceCodeRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to replace watermass : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            String code = (String)validate._1();
            String newCode = (String)validate._2();
            int result = $this.watermassDao.replace(code, newCode);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    @Inject
    public WatermassController(WatermassDao watermassDao, WSClient ws, LogUtil logUtil, StationWatermassDao stationWatermassDao, ReferentialSandreCodeDao referentialSandreCodeDao) {
        this.watermassDao = watermassDao;
        this.logUtil = logUtil;
        this.stationWatermassDao = stationWatermassDao;
    }
}

