/*
 * Decompiled with CFR 0.152.
 */
package watershed.controller;

import com.google.inject.Inject;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.quality.domain.output.StationOutput$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.referentials.watershed.itf.WatershedDao;
import fr.aquasys.daeau.referentials.watershed.model.Watershed;
import fr.aquasys.daeau.referentials.watershed.model.Watershed$;
import fr.aquasys.daeau.referentials.watershed.model.WatershedInput;
import fr.aquasys.daeau.referentials.watershed.model.WatershedInput$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.json.XML;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import sandre.dao.ReferentialSandreCodeDao;
import sandre.model.ReferentialSandreCode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import watershed.itf.RefWatershedDao;
import watershed.model.SandreWatershed;
import watershed.model.SandreWatershed$;
import watershed.model.SearchCriterias;
import watershed.model.SearchCriterias$;
import watershed.model.WatershedFile;
import watershed.model.WatershedFile$;
import watershed.model.WatershedFileInput;
import watershed.model.WatershedFileInput$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\f\u0019\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006Y!\n\u0005\ti\u0001\u0011\t\u0011)A\u0006k!AQ\b\u0001B\u0001B\u0003-a\b\u0003\u0005G\u0001\t\u0005\t\u0015a\u0003H\u0011!q\u0005A!A!\u0002\u0017y\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u0011y\u0003!\u0011!Q\u0001\f}C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Y!\u001a\u0005\u0006a\u0002!\t!\u001d\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a-\u0001\t\u0003\t)\fC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011q\u001b\u0001\u0005\u0002\u0005e'aE,bi\u0016\u00148\u000f[3e\u0007>tGO]8mY\u0016\u0014(BA\r\u001b\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u00027\u0005Iq/\u0019;feNDW\rZ\u0002\u0001'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\ro\u0006$XM]:iK\u0012$\u0015m\u001c\t\u0003MIj\u0011a\n\u0006\u0003Q%\n1!\u001b;g\u0015\tY\"F\u0003\u0002,Y\u0005a!/\u001a4fe\u0016tG/[1mg*\u0011QFL\u0001\u0006I\u0006,\u0017-\u001e\u0006\u0003_A\nq!Y9vCNL8OC\u00012\u0003\t1'/\u0003\u00024O\taq+\u0019;feNDW\r\u001a#b_\u00069An\\4Vi&d\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011)H/\u001b7\u000b\u0005ir\u0013\u0001\u0003:bE\nLG/\\9\n\u0005q:$a\u0002'pOV#\u0018\u000e\\\u0001\u0019e\u00164WM]3oi&\fGnU1oIJ,7i\u001c3f\t\u0006|\u0007CA E\u001b\u0005\u0001%BA!C\u0003\r!\u0017m\u001c\u0006\u0002\u0007\u000611/\u00198ee\u0016L!!\u0012!\u00031I+g-\u001a:f]RL\u0017\r\\*b]\u0012\u0014XmQ8eK\u0012\u000bw.A\bqS\u0016Tx.\\3uKJ$\u0015-Z1v!\tAE*D\u0001J\u0015\tA#J\u0003\u0002LY\u0005Q\u0001/[3{_6,GO]=\n\u00055K%a\u0004)jKj|W.\u001a;fe\u0012\u000bW-Y;\u0002\u001fE,\u0018\r\\5u_6,G/\u001a:EC>\u0004\"\u0001\u0015+\u000e\u0003ES!\u0001\u000b*\u000b\u0005Mc\u0013aB9vC2LG/_\u0005\u0003+F\u0013q\"U;bY&$x.\\3uKJ$\u0015m\\\u0001\u0017Qf$'o\u001c7pO&\u001c\u0017\r\\*uCRLwN\u001c#b_B\u0011\u0001\fX\u0007\u00023*\u0011\u0001F\u0017\u0006\u000372\n!\u0002[=ee>lW\r\u001e:z\u0013\ti\u0016L\u0001\fIs\u0012\u0014x\u000e\\8hS\u000e\fGn\u0015;bi&|g\u000eR1p\u0003=\u0011XMZ,bi\u0016\u00148\u000f[3e\t\u0006|\u0007C\u00011c\u001b\u0005\t'B\u0001\u0015\u001b\u0013\t\u0019\u0017MA\bSK\u001a<\u0016\r^3sg\",G\rR1p\u0003\t98\u000f\u0005\u0002g]6\tqM\u0003\u0002eQ*\u0011\u0011N[\u0001\u0005Y&\u00147O\u0003\u0002lY\u0006\u0019\u0011\r]5\u000b\u00035\fA\u0001\u001d7bs&\u0011qn\u001a\u0002\t/N\u001bE.[3oi\u00061A(\u001b8jiz\"\u0012A\u001d\u000b\ngV4x\u000f_={wr\u0004\"\u0001\u001e\u0001\u000e\u0003aAQ\u0001J\u0005A\u0004\u0015BQ\u0001N\u0005A\u0004UBQ!P\u0005A\u0004yBQAR\u0005A\u0004\u001dCQAT\u0005A\u0004=CQAV\u0005A\u0004]CQAX\u0005A\u0004}CQ\u0001Z\u0005A\u0004\u0015D#!\u0003@\u0011\u0007}\fi!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0019IgN[3di*!\u0011qAA\u0005\u0003\u00199wn\\4mK*\u0011\u00111B\u0001\u0004G>l\u0017\u0002BA\b\u0003\u0003\u0011a!\u00138kK\u000e$\u0018aA4fiRQ\u0011QCA\u0016\u0003w\tY%a\u0014\u0011\t\u0005]\u0011Q\u0005\b\u0005\u00033\t\t\u0003E\u0002\u0002\u001c\u0001j!!!\b\u000b\u0007\u0005}A$\u0001\u0004=e>|GOP\u0005\u0004\u0003G\u0001\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005%\"AB*ue&twMC\u0002\u0002$\u0001Bq!!\f\u000b\u0001\u0004\ty#A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000ei\u0003\u0011Q7o\u001c8\n\t\u0005e\u00121\u0007\u0002\b\u0015N4\u0016\r\\;f\u0011\u001d\tiD\u0003a\u0001\u0003\u007f\tq\u0001[3bI\u0016\u00148\u000f\u0005\u0005\u0002\u0018\u0005\u0005\u0013QCA#\u0013\u0011\t\u0019%!\u000b\u0003\u00075\u000b\u0007\u000fE\u0002 \u0003\u000fJ1!!\u0013!\u0005\r\te.\u001f\u0005\b\u0003\u001bR\u0001\u0019AA\u000b\u0003\u0019iw\u000eZ;mK\"9\u0011\u0011\u000b\u0006A\u0002\u0005U\u0011\u0001B;tKJ\fAbZ3u\u00032d\u0007+\u001e2mS\u000e$\"\"!\u0006\u0002X\u0005e\u00131LA/\u0011\u001d\tic\u0003a\u0001\u0003_Aq!!\u0010\f\u0001\u0004\ty\u0004C\u0004\u0002N-\u0001\r!!\u0006\t\u000f\u0005E3\u00021\u0001\u0002\u0016\u00051q-\u001a;BY2$\"\"!\u0006\u0002d\u0005\u0015\u0014qMA5\u0011\u001d\ti\u0003\u0004a\u0001\u0003_Aq!!\u0010\r\u0001\u0004\ty\u0004C\u0004\u0002N1\u0001\r!!\u0006\t\u000f\u0005EC\u00021\u0001\u0002\u0016\u0005Aq-\u001a;D_VtG\u000f\u0006\u0006\u0002\u0016\u0005=\u0014\u0011OA:\u0003kBq!!\f\u000e\u0001\u0004\ty\u0003C\u0004\u0002>5\u0001\r!a\u0010\t\u000f\u00055S\u00021\u0001\u0002\u0016!9\u0011\u0011K\u0007A\u0002\u0005U\u0011aC4fiN#\u0018\r^5p]N$\"\"!\u0006\u0002|\u0005u\u0014qPAA\u0011\u001d\tiC\u0004a\u0001\u0003_Aq!!\u0010\u000f\u0001\u0004\ty\u0004C\u0004\u0002N9\u0001\r!!\u0006\t\u000f\u0005Ec\u00021\u0001\u0002\u0016\u000511M]3bi\u0016$\"\"!\u0006\u0002\b\u0006%\u00151RAG\u0011\u001d\tic\u0004a\u0001\u0003_Aq!!\u0010\u0010\u0001\u0004\ty\u0004C\u0004\u0002N=\u0001\r!!\u0006\t\u000f\u0005Es\u00021\u0001\u0002\u0016\u00051Q\u000f\u001d3bi\u0016$\"\"!\u0006\u0002\u0014\u0006U\u0015qSAM\u0011\u001d\ti\u0003\u0005a\u0001\u0003_Aq!!\u0010\u0011\u0001\u0004\ty\u0004C\u0004\u0002NA\u0001\r!!\u0006\t\u000f\u0005E\u0003\u00031\u0001\u0002\u0016\u00051A-\u001a7fi\u0016$\"\"!\u0006\u0002 \u0006\u0005\u00161UAS\u0011\u001d\ti#\u0005a\u0001\u0003_Aq!!\u0010\u0012\u0001\u0004\ty\u0004C\u0004\u0002NE\u0001\r!!\u0006\t\u000f\u0005E\u0013\u00031\u0001\u0002\u0016\u0005qq-\u001a;D_VtG\u000fR3mKR,GCCA\u000b\u0003W\u000bi+a,\u00022\"9\u0011Q\u0006\nA\u0002\u0005=\u0002bBA\u001f%\u0001\u0007\u0011q\b\u0005\b\u0003\u001b\u0012\u0002\u0019AA\u000b\u0011\u001d\t\tF\u0005a\u0001\u0003+\tQ\u0001];sO\u0016$\"\"!\u0006\u00028\u0006e\u00161XA_\u0011\u001d\tic\u0005a\u0001\u0003_Aq!!\u0010\u0014\u0001\u0004\ty\u0004C\u0004\u0002NM\u0001\r!!\u0006\t\u000f\u0005E3\u00031\u0001\u0002\u0016\u00059!/\u001a9mC\u000e,GCCA\u000b\u0003\u0007\f)-a2\u0002J\"9\u0011Q\u0006\u000bA\u0002\u0005=\u0002bBA\u001f)\u0001\u0007\u0011q\b\u0005\b\u0003\u001b\"\u0002\u0019AA\u000b\u0011\u001d\t\t\u0006\u0006a\u0001\u0003+\t\u0011\"\u001e9m_\u0006$7i\u0015,\u0015\u0015\u0005U\u0011qZAi\u0003'\f)\u000eC\u0004\u0002.U\u0001\r!a\f\t\u000f\u0005uR\u00031\u0001\u0002@!9\u0011QJ\u000bA\u0002\u0005U\u0001bBA)+\u0001\u0007\u0011QC\u0001\nkBdw.\u00193Y\u001b2#\"\"!\u0006\u0002\\\u0006u\u0017q\\Aq\u0011\u001d\tiC\u0006a\u0001\u0003_Aq!!\u0010\u0017\u0001\u0004\ty\u0004C\u0004\u0002NY\u0001\r!!\u0006\t\u000f\u0005Ec\u00031\u0001\u0002\u0016\u0001")
public class WatershedController {
    private final WatershedDao watershedDao;
    private final LogUtil logUtil;
    private final ReferentialSandreCodeDao referentialSandreCodeDao;
    private final PiezometerDaeau piezometerDaeau;
    private final QualitometerDao qualitometerDao;
    private final HydrologicalStationDao hydrologicalStationDao;
    private final RefWatershedDao refWatershedDao;

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Watershed$.MODULE$.idRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            double watershedId = BoxesRunTime.unboxToDouble((Object)jsSuccess.get());
            Option option = this.watershedDao.get(watershedId);
            if (option instanceof Some) {
                Some some = (Some)option;
                Watershed watershed = (Watershed)some.value();
                this.logUtil.info(new StringBuilder(17).append("Return watershed ").append(watershed.id()).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)watershed, Watershed$.MODULE$.writeWatershed()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.info(new StringBuilder(20).append("Watershed not found ").append(watershedId).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)204), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getAllPublic(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(SearchCriterias$.MODULE$.reads());
        boolean citySearch = ((SearchCriterias)jsResult.get()).criterias().exists((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)WatershedController.$anonfun$getAllPublic$1(str)));
        boolean stationearch = ((SearchCriterias)jsResult.get()).criterias().exists((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)WatershedController.$anonfun$getAllPublic$2(str)));
        boolean watershedSearch = ((SearchCriterias)jsResult.get()).criterias().exists((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)WatershedController.$anonfun$getAllPublic$3(str)));
        boolean departmentSearch = ((SearchCriterias)jsResult.get()).criterias().exists((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)WatershedController.$anonfun$getAllPublic$4(str)));
        boolean epciSearch = ((SearchCriterias)jsResult.get()).criterias().exists((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)WatershedController.$anonfun$getAllPublic$5(str)));
        return Json$.MODULE$.toJson(this.refWatershedDao.getAllPublic(((SearchCriterias)jsResult.get()).input(), citySearch, stationearch, watershedSearch, departmentSearch, epciSearch, ((SearchCriterias)jsResult.get()).geolocation()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), WatershedController.tuple2Writes$1((Writes)Writes$.MODULE$.StringWrites(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), WatershedController.tuple2Writes$1((Writes)Writes$.MODULE$.StringWrites(), Writes$.MODULE$.OptionWrites((Writes)Writes$.MODULE$.StringWrites())))))).toString();
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.watershedDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Watershed$.MODULE$.writeWatershed())).toString();
    }

    public String getCount(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)this.watershedDao.getCount()), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public String getStations(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Watershed$.MODULE$.idRead());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            double watershedId = BoxesRunTime.unboxToDouble((Object)jsSuccess.get());
            scala.collection.immutable.Seq qualitometers = this.qualitometerDao.getByWaterShed(watershedId);
            scala.collection.immutable.Seq qualitometerList = (scala.collection.immutable.Seq)qualitometers.map((Function1 & Serializable)q -> StationOutput$.MODULE$.toStationOutput(q));
            scala.collection.immutable.Seq piezometers = this.piezometerDaeau.getByWaterShed(watershedId);
            scala.collection.immutable.Seq piezometerList = (scala.collection.immutable.Seq)piezometers.map((Function1 & Serializable)p -> StationOutput$.MODULE$.toStationOutput(p));
            scala.collection.immutable.Seq hydrometers = this.hydrologicalStationDao.getByWaterShed(watershedId);
            scala.collection.immutable.Seq hydroList = (scala.collection.immutable.Seq)hydrometers.map((Function1 & Serializable)h -> StationOutput$.MODULE$.toStationOutput(h));
            scala.collection.immutable.Seq result = (scala.collection.immutable.Seq)((IterableOps)qualitometerList.$plus$plus((IterableOnce)piezometerList)).$plus$plus((IterableOnce)hydroList);
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), StationOutput$.MODULE$.stationOutputWrites())).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String create(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(WatershedInput$.MODULE$.readWatershed());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            WatershedInput watershedInput = (WatershedInput)jsSuccess.get();
            Watershed watershed = WatershedInput$.MODULE$.toWatershedInput(0.0, watershedInput);
            Option option = this.watershedDao.create(watershed);
            if (option instanceof Some) {
                Some some = (Some)option;
                long id = BoxesRunTime.unboxToLong((Object)some.value());
                this.logUtil.info(new StringBuilder(17).append("Create watershed ").append(id).toString(), this.logUtil.info$default$2());
                return Json$.MODULE$.toJson((Object)watershed.copy((double)((int)id), watershed.copy$default$2(), watershed.copy$default$3(), watershed.copy$default$4(), watershed.copy$default$5(), watershed.copy$default$6(), watershed.copy$default$7(), watershed.copy$default$8(), watershed.copy$default$9()), Watershed$.MODULE$.writeWatershed()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.error("Error to insert watershed ", this.logUtil.error$default$2());
                return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.info(new StringBuilder(14).append("Bad request : ").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(WatershedInput$.MODULE$.readUpdateWatershed()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(22).append("Can't get watershed :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)watershedValidate -> {
            double watershedIdUpdate = watershedValidate._1$mcD$sp();
            WatershedInput watershedToUpdate = (WatershedInput)watershedValidate._2();
            Option option = $this.watershedDao.get(watershedIdUpdate);
            if (option instanceof Some) {
                int n = $this.watershedDao.update(WatershedInput$.MODULE$.toWatershedInput(watershedIdUpdate, watershedToUpdate));
                return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watershed$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to get watershed : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> WatershedController.$anonfun$delete$2(this, BoxesRunTime.unboxToDouble((Object)validate)));
    }

    public String getCountDelete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watershed$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to get watershed : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> WatershedController.$anonfun$getCountDelete$2(this, BoxesRunTime.unboxToDouble((Object)validate)));
    }

    public String purge(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"purge"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)this.watershedDao.purge()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String replace(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Watershed$.MODULE$.replaceIdsRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to replace watershed : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            double code = validate._1$mcD$sp();
            double newCode = validate._2$mcD$sp();
            int result = $this.watershedDao.replace(code, newCode);
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String uploadCSV(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(WatershedFile$.MODULE$.writes()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError("Can't validate import watershed csv object", 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)watershedFile -> {
            int index = watershedFile.fileContent().indexOf("base64,") + 7;
            Source bufferedSource = Source$.MODULE$.fromBytes(Base64.decodeBase64((String)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(watershedFile.fileContent()), index)), "UTF-8");
            IntRef nbCitiesInsert = IntRef.create((int)0);
            IntRef nbCitiesUpdate = IntRef.create((int)0);
            bufferedSource.getLines().drop(1).foreach((Function1 & Serializable)line -> {
                WatershedController.$anonfun$uploadCSV$3(this, nbCitiesUpdate, watershedFile, nbCitiesInsert, line);
                return BoxedUnit.UNIT;
            });
            bufferedSource.close();
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insertWatersheds"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbCitiesInsert.elem), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updateWatersheds"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbCitiesUpdate.elem), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String uploadXML(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(WatershedFile$.MODULE$.writes()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError("Can't validate import watershed xml object", 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)watershedFile -> {
            String string;
            int index = watershedFile.fileContent().indexOf("base64,") + 7;
            Source bufferedSource = Source$.MODULE$.fromBytes(Base64.decodeBase64((String)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(watershedFile.fileContent()), index)), "UTF-8");
            try {
                scala.collection.immutable.Seq seq;
                ObjectRef textXml = ObjectRef.create((Object)"");
                bufferedSource.getLines().foreach((Function1 & Serializable)line -> {
                    textXml.elem = new StringBuilder(0).append((String)textXml.elem).append(line).toString();
                    return BoxedUnit.UNIT;
                });
                String jsObject = XML.toJSONObject((String)((String)textXml.elem).replace(" schemeAgencyID=\"SANDRE\">", ">")).toString();
                JsValue samples = Json$.MODULE$.parse(jsObject);
                String RESULT_REFERENCIAL_UPPERCASE = "REFERENTIELS";
                String RESULT_REFERENCIAL = "Referentiel";
                String RESULT_WATERSHED = "Element";
                Option option = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(samples), RESULT_REFERENCIAL_UPPERCASE)), RESULT_REFERENCIAL)), RESULT_WATERSHED).toOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JsValue call = (JsValue)some.value();
                    JsResult jsResult = call.validate(SandreWatershed$.MODULE$.read());
                    if (jsResult != null) {
                        scala.collection.immutable.Seq listOfWatershedsOutput;
                        JsResult jsResult2 = jsResult;
                        seq = listOfWatershedsOutput = (scala.collection.immutable.Seq)jsResult2.get();
                    } else {
                        seq = (scala.collection.immutable.Seq)Nil$.MODULE$;
                    }
                } else {
                    seq = (scala.collection.immutable.Seq)Nil$.MODULE$;
                }
                scala.collection.immutable.Seq tabWatersheds = seq;
                Tuple2<Object, Object> nbWatersheds = $this.refWatershedDao.synchro((scala.collection.immutable.Seq<SandreWatershed>)tabWatersheds, watershedFile.insertOrUpdate());
                Option<ReferentialSandreCode> option2 = $this.referentialSandreCodeDao.get("BASSINS_VERSANTS");
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    ReferentialSandreCode ref = (ReferentialSandreCode)some.value();
                    Some x$1 = new Some((Object)new DateTime());
                    Option<String> x$2 = watershedFile.user();
                    Some x$3 = new Some((Object)"2");
                    String x$4 = ref.copy$default$1();
                    Option<Object> x$5 = ref.copy$default$2();
                    Option<String> x$6 = ref.copy$default$5();
                    ReferentialSandreCode copyRef = ref.copy(x$4, x$5, (Option<String>)x$3, (Option<DateTime>)x$1, x$6, x$2);
                    BoxesRunTime.boxToInteger((int)$this.referentialSandreCodeDao.update(copyRef));
                } else if (None$.MODULE$.equals(option2)) {
                } else {
                    throw new MatchError(option2);
                }
                bufferedSource.close();
                string = Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insertWatersheds"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbWatersheds._2$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updateWatersheds"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)nbWatersheds._1$mcI$sp()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder(2).append(e.getMessage()).append(":\n");
                e.printStackTrace();
                string = ErrorUtil$.MODULE$.jsonError(stringBuilder.append(BoxedUnit.UNIT).toString(), 500, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            return string;
        });
    }

    private static final Writes tuple2Writes$1(Writes w1, Writes w2) {
        return new Writes<Tuple2<A, B>>(null, w1, w2){
            private final Writes w1$1;
            private final Writes w2$1;

            public <B> Writes<B> contramap(Function1<B, Tuple2<A, B>> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends Tuple2<A, B>> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<Tuple2<A, B>> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<Tuple2<A, B>> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public JsArray writes(Tuple2<A, B> tuple) {
                return JsArray$.MODULE$.apply((Seq)new .colon.colon((Object)this.w1$1.writes(tuple._1()), (List)new .colon.colon((Object)this.w2$1.writes(tuple._2()), (List)Nil$.MODULE$)));
            }
            {
                this.w1$1 = w1$1;
                this.w2$1 = w2$1;
                Writes.$init$((Writes)this);
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$getAllPublic$1(String str) {
        return "city".equals(str);
    }

    public static final /* synthetic */ boolean $anonfun$getAllPublic$2(String str) {
        return "station".equals(str);
    }

    public static final /* synthetic */ boolean $anonfun$getAllPublic$3(String str) {
        return "watershed".equals(str);
    }

    public static final /* synthetic */ boolean $anonfun$getAllPublic$4(String str) {
        return "department".equals(str);
    }

    public static final /* synthetic */ boolean $anonfun$getAllPublic$5(String str) {
        return "epci".equals(str);
    }

    public static final /* synthetic */ String $anonfun$delete$2(WatershedController $this, double validate) {
        int result = $this.watershedDao.delete(validate);
        return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getCountDelete$2(WatershedController $this, double validate) {
        int result = $this.watershedDao.getCountDelete(validate);
        return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ void $anonfun$uploadCSV$3(WatershedController $this, IntRef nbCitiesUpdate$1, WatershedFile watershedFile$1, IntRef nbCitiesInsert$1, String line) {
        double id;
        double d;
        String[] csvLine = (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{line}), (Function1 & Serializable)s -> s.split(";", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
        try {
            d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(csvLine[4].replaceAll("\"", "")));
        }
        catch (Exception e) {
            d = id = -1.0;
        }
        if (id != (double)-1) {
            try {
                WatershedFileInput watershed = new WatershedFileInput(id, csvLine[6].replaceAll("\"", ""), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                Option option = $this.watershedDao.get((double)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine[0])));
                if (option instanceof Some) {
                    $this.watershedDao.update(WatershedFileInput$.MODULE$.toWatershed(watershed));
                    ++nbCitiesUpdate$1.elem;
                } else if (watershedFile$1.insertOrUpdate()) {
                    $this.watershedDao.create(WatershedFileInput$.MODULE$.toWatershed(watershed));
                    ++nbCitiesInsert$1.elem;
                }
            }
            catch (Exception e) {
                LogUtil logUtil = $this.logUtil;
                StringBuilder stringBuilder = new StringBuilder(2).append(e.getMessage()).append(":\n");
                e.printStackTrace();
                logUtil.error(stringBuilder.append(BoxedUnit.UNIT).toString(), $this.logUtil.error$default$2());
            }
            return;
        }
    }

    @Inject
    public WatershedController(WatershedDao watershedDao, LogUtil logUtil, ReferentialSandreCodeDao referentialSandreCodeDao, PiezometerDaeau piezometerDaeau, QualitometerDao qualitometerDao, HydrologicalStationDao hydrologicalStationDao, RefWatershedDao refWatershedDao, WSClient ws) {
        this.watershedDao = watershedDao;
        this.logUtil = logUtil;
        this.referentialSandreCodeDao = referentialSandreCodeDao;
        this.piezometerDaeau = piezometerDaeau;
        this.qualitometerDao = qualitometerDao;
        this.hydrologicalStationDao = hydrologicalStationDao;
        this.refWatershedDao = refWatershedDao;
    }
}

