/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011]u!\u0002.\\\u0011\u0003\u0001g!\u00022\\\u0011\u0003\u0019\u0007\"\u00026\u0002\t\u0003YW\u0001\u00027\u0002\u00015D!\"!\u0006\u0002\u0005\u0004%\t!XA\f\u0011!\t)/\u0001Q\u0001\n\u0005eaABAz\u0003\u0001\t)\u0010\u0003\u0006\u0002x\u001a\u0011)\u0019!C\u0001\u0003sD!B!\u0004\u0007\u0005\u0003\u0005\u000b\u0011BA~\u0011\u0019Qg\u0001\"\u0001\u0003\u0010!I!Q\u0003\u0004C\u0002\u0013\u0005!q\u0003\u0005\t\u0005G1\u0001\u0015!\u0003\u0003\u001a!I!Q\u0005\u0004C\u0002\u0013\u0005!q\u0003\u0005\t\u0005O1\u0001\u0015!\u0003\u0003\u001a!9!\u0011\u0006\u0004\u0005\u000e\t-\u0002b\u0002B\u0019\u0003\u0011\u0005!1\u0007\u0004\u0007\u0003S\t!)a\u000b\t\u0015\u0005\u0015\u0003C!f\u0001\n\u0003\t9\u0005\u0003\u0006\u0002VA\u0011\t\u0012)A\u0005\u0003\u0013B!\"a\u0016\u0011\u0005+\u0007I\u0011AA-\u0011)\t\t\u0007\u0005B\tB\u0003%\u00111\f\u0005\u0007UB!\t!a\u0019\t\u0013\u0005%\u0004#!A\u0005\u0002\u0005-\u0004\"CA9!E\u0005I\u0011AA:\u0011%\tI\tEI\u0001\n\u0003\tY\tC\u0005\u0002\u0010B\t\t\u0011\"\u0011\u0002\u0012\"I\u00111\u0015\t\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003[\u0003\u0012\u0011!C\u0001\u0003_C\u0011\"!.\u0011\u0003\u0003%\t%a.\t\u0013\u0005\u0015\u0007#!A\u0005\u0002\u0005\u001d\u0007\"CAi!\u0005\u0005I\u0011IAj\u0011%\t9\u000eEA\u0001\n\u0003\nI\u000eC\u0005\u0002\\B\t\t\u0011\"\u0011\u0002^\"I\u0011q\u001c\t\u0002\u0002\u0013\u0005\u0013\u0011]\u0004\n\u0005\u007f\t\u0011\u0011!E\u0001\u0005\u00032\u0011\"!\u000b\u0002\u0003\u0003E\tAa\u0011\t\r)\u001cC\u0011\u0001B.\u0011%\tYnIA\u0001\n\u000b\ni\u000eC\u0005\u0003^\r\n\t\u0011\"!\u0003`!I!QM\u0012\u0002\u0002\u0013\u0005%q\r\u0005\n\u0005k\u001a\u0013\u0011!C\u0005\u0005oBqAa \u0002\t\u0003\u0011\t\tC\u0004\u0003 \u0006!\tA!)\u0007\u000b\t\\\u0006Aa)\t\u0015\u0005]3F!b\u0001\n\u0003\u0011Y\u000b\u0003\u0006\u0002b-\u0012\t\u0011)A\u0005\u00053CaA[\u0016\u0005\u0002\t5\u0006\"\u0003BZW\t\u0007I\u0011\u0001B[\u0011!\u0011Yl\u000bQ\u0001\n\t]\u0006\"\u0003B_W\t\u0007I\u0011\u0001B`\u0011!\u0011\tm\u000bQ\u0001\n\u0005%\u0007\u0002\u0003BbW\u0001\u0006IA!2\t\u0013\tE7F1A\u0005\u0002\tM\u0007\u0002\u0003BnW\u0001\u0006IA!6\t\u0013\tu7F1A\u0005\n\t}\u0007\u0002CB\u0006W\u0001\u0006IA!9\t\u0011\r51\u0006\"\u0001^\u0007\u001fAqAa ,\t\u0013\u0019)\u0002C\u0004\u0004\"-\"\taa\t\t\u000f\rm2\u0006\"\u0001\u0004>!911H\u0016\u0005\u0002\rE\u0004bBB?W\u0011%1q\u0010\u0005\b\u0007\u0013[C\u0011ABF\u0011\u001d\u0019Yd\u000bC\u0001\u0007cCqa!1,\t\u0003\u0019\u0019\rC\u0004\u0004H.\"\ta!3\t\u000f\re7\u0006\"\u0001\u0004\\\"I11]\u0016C\u0002\u0013%1Q\u001d\u0005\t\u0007g\\\u0003\u0015!\u0003\u0004h\"I1Q_\u0016C\u0002\u0013%1q\u001f\u0005\t\u0007w\\\u0003\u0015!\u0003\u0004z\"Q1Q`\u0016C\u0002\u0013\u0005Qla@\t\u0011\u0011\u00151\u0006)A\u0005\t\u0003Aq\u0001b\u0002,\t\u0013!I\u0001C\u0004\u0005\u001a-\"I\u0001b\u0007\t\u000f\u001152\u0006\"\u0003\u00050!9AQG\u0016\u0005\n\u0011]\u0002\"\u0003C\"W\t\u0007I\u0011\u0002C#\u0011!!If\u000bQ\u0001\n\u0011\u001d\u0003\"\u0003C.W\t\u0007I\u0011\u0001C/\u0011!!\tg\u000bQ\u0001\n\u0011}\u0003\"\u0003C2W\t\u0007I\u0011\u0002C3\u0011!!Ig\u000bQ\u0001\n\u0011\u001d\u0004b\u0002C6W\u0011%AQ\u000e\u0005\n\tgZ#\u0019!C\u0005\u0005\u007fC\u0001\u0002\"\u001e,A\u0003%\u0011\u0011\u001a\u0005\n\toZ#\u0019!C\u0005\u0005\u007fC\u0001\u0002\"\u001f,A\u0003%\u0011\u0011\u001a\u0005\b\twZC\u0011\u0002C?\u0011!!\ti\u000bC\u0001;\u0012\r\u0015!D*fe&\fG.\u001b>bi&|gN\u0003\u0002];\u0006i1/\u001a:jC2L'0\u0019;j_:T\u0011AX\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005\u0005\fQ\"A.\u0003\u001bM+'/[1mSj\fG/[8o'\t\tA\r\u0005\u0002fQ6\taMC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIgM\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0014qb\u00117bgN\u001cVM]5bY&TXM\u001d\t\u0006K:\u0004\u0018qB\u0005\u0003_\u001a\u0014a\u0001V;qY\u0016\u0014\u0004GA9\u007f!\r\u0011\u0018\u0010 \b\u0003g^\u0004\"\u0001\u001e4\u000e\u0003UT!A^0\u0002\rq\u0012xn\u001c;?\u0013\tAh-\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014Qa\u00117bgNT!\u0001\u001f4\u0011\u0005utH\u0002\u0001\u0003\u000b\u007f\u000e\t\t\u0011!A\u0003\u0002\u0005\u0005!aA0%cE!\u00111AA\u0005!\r)\u0017QA\u0005\u0004\u0003\u000f1'a\u0002(pi\"Lgn\u001a\t\u0004K\u0006-\u0011bAA\u0007M\n\u0019\u0011I\\=\u0011\u0007\u0005\f\t\"C\u0002\u0002\u0014m\u0013!bU3sS\u0006d\u0017N_3s\u0003m\u0019WO\u001d:f]R$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]V\u0011\u0011\u0011\u0004\t\u0007\u00037\t\t#!\n\u000e\u0005\u0005u!bAA\u0010M\u0006!Q\u000f^5m\u0013\u0011\t\u0019#!\b\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016\u00042!a\n\u0011\u001b\u0005\t!aC%oM>\u0014X.\u0019;j_:\u001cb\u0001\u00053\u0002.\u0005M\u0002cA3\u00020%\u0019\u0011\u0011\u00074\u0003\u000fA\u0013x\u000eZ;diB!\u0011QGA \u001d\u0011\t9$a\u000f\u000f\u0007Q\fI$C\u0001h\u0013\r\tiDZ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t%a\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005ub-A\u0004bI\u0012\u0014Xm]:\u0016\u0005\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=S,A\u0003bGR|'/\u0003\u0003\u0002T\u00055#aB!eIJ,7o]\u0001\tC\u0012$'/Z:tA\u000511/_:uK6,\"!a\u0017\u0011\t\u0005-\u0013QL\u0005\u0005\u0003?\niEA\u0006BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000e\t\u000b\u0007\u0003K\t)'a\u001a\t\u000f\u0005\u0015S\u00031\u0001\u0002J!9\u0011qK\u000bA\u0002\u0005m\u0013\u0001B2paf$b!!\n\u0002n\u0005=\u0004\"CA#-A\u0005\t\u0019AA%\u0011%\t9F\u0006I\u0001\u0002\u0004\tY&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U$\u0006BA%\u0003oZ#!!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00073\u0017AC1o]>$\u0018\r^5p]&!\u0011qQA?\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiI\u000b\u0003\u0002\\\u0005]\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0014B!\u0011QSAP\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015\u0001\u00027b]\u001eT!!!(\u0002\t)\fg/Y\u0005\u0005\u0003C\u000b9J\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00032!ZAU\u0013\r\tYK\u001a\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\t\t\fC\u0005\u00024n\t\t\u00111\u0001\u0002(\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!/\u0011\r\u0005m\u0016\u0011YA\u0005\u001b\t\tiLC\u0002\u0002@\u001a\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019-!0\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\fy\rE\u0002f\u0003\u0017L1!!4g\u0005\u001d\u0011un\u001c7fC:D\u0011\"a-\u001e\u0003\u0003\u0005\r!!\u0003\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003'\u000b)\u000eC\u0005\u00024z\t\t\u00111\u0001\u0002(\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002(\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0014\u00061Q-];bYN$B!!3\u0002d\"I\u00111W\u0011\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u001dGV\u0014(/\u001a8u)J\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8!Q\r)\u0011\u0011\u001e\t\u0005\u0003W\fy/\u0004\u0002\u0002n*\u0019\u00111Q/\n\t\u0005E\u0018Q\u001e\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018N\u0001\u0005TKR$\u0018N\\4t'\t1A-\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003w\u0004B!!@\u0003\n5\u0011\u0011q \u0006\u0005\u0003o\u0014\tA\u0003\u0003\u0003\u0004\t\u0015\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\t\u001d\u0011aA2p[&!!1BA\u0000\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004C\u0003\u0002B\t\u0005'\u00012!a\n\u0007\u0011\u001d\t90\u0003a\u0001\u0003w\f1bU3sS\u0006d\u0017N_3sgV\u0011!\u0011\u0004\t\be\nm!q\u0004B\u0010\u0013\r\u0011ib\u001f\u0002\u0004\u001b\u0006\u0004\bc\u0001:\u0003\"%\u0019\u0011\u0011U>\u0002\u0019M+'/[1mSj,'o\u001d\u0011\u0002+M+'/[1mSj\fG/[8o\u0005&tG-\u001b8hg\u000612+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b%A\u0006d_:4\u0017n\u001a+p\u001b\u0006\u0004H\u0003\u0002B\r\u0005[AqAa\f\u000f\u0001\u0004\tY0A\u0002dM\u001e\f1c]3sS\u0006d\u0017N_3e\u0003\u000e$xN\u001d)bi\"$BAa\b\u00036!9!qG\bA\u0002\te\u0012\u0001C1di>\u0014(+\u001a4\u0011\t\u0005-#1H\u0005\u0005\u0005{\tiE\u0001\u0005BGR|'OU3g\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007\u0005\u001d2eE\u0003$\u0005\u000b\u0012\t\u0006\u0005\u0006\u0003H\t5\u0013\u0011JA.\u0003Ki!A!\u0013\u000b\u0007\t-c-A\u0004sk:$\u0018.\\3\n\t\t=#\u0011\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002B*\u00053j!A!\u0016\u000b\t\t]\u00131T\u0001\u0003S>LA!!\u0011\u0003VQ\u0011!\u0011I\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003K\u0011\tGa\u0019\t\u000f\u0005\u0015c\u00051\u0001\u0002J!9\u0011q\u000b\u0014A\u0002\u0005m\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005S\u0012\t\bE\u0003f\u0005W\u0012y'C\u0002\u0003n\u0019\u0014aa\u00149uS>t\u0007CB3o\u0003\u0013\nY\u0006C\u0005\u0003t\u001d\n\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\te\u0004\u0003BAK\u0005wJAA! \u0002\u0018\n1qJ\u00196fGR\f\u0001d^5uQR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\u0011\u0011\u0019I!#\u0015\t\t\u0015%q\u0013\u000b\u0005\u0005\u000f\u0013i\tE\u0002~\u0005\u0013#qAa#*\u0005\u0004\t\tAA\u0001U\u0011\u001d\u0011y)\u000ba\u0001\u0005#\u000b\u0011A\u001a\t\u0006K\nM%qQ\u0005\u0004\u0005+3'!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\t9&\u000ba\u0001\u00053\u0003B!a\u0013\u0003\u001c&!!QTA'\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003y9W\r^\"veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g\u000e\u0006\u0002\u0002&M!1\u0006\u001aBS!\u0011\tYEa*\n\t\t%\u0016Q\n\u0002\n\u000bb$XM\\:j_:,\"A!'\u0015\t\t=&\u0011\u0017\t\u0003C.Bq!a\u0016/\u0001\u0004\u0011I*\u0001\u0005tKR$\u0018N\\4t+\t\u00119\fE\u0002\u0003:\u001aq!!\u0019\u0001\u0002\u0013M,G\u000f^5oON\u0004\u0013AF!mY><(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0016\u0005\u0005%\u0017aF!mY><(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8!\u0003\u0011yFn\\4\u0011\t\t\u001d'QZ\u0007\u0003\u0005\u0013T1Aa3^\u0003\u0015)g/\u001a8u\u0013\u0011\u0011yM!3\u0003)5\u000b'o[3s\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\rawnZ\u000b\u0003\u0005+\u0004BAa2\u0003X&!!\u0011\u001cBe\u00059aunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005iQ.\u00198jM\u0016\u001cHoQ1dQ\u0016,\"A!9\u0011\r\t\r(q\u001eBz\u001b\t\u0011)O\u0003\u0003\u0003h\n%\u0018AB1u_6L7M\u0003\u0003\u0003l\n5\u0018AC2p]\u000e,(O]3oi*!\u0011qDAN\u0013\u0011\u0011\tP!:\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\u0002B!>\u0003|\n}!Q`\u0007\u0003\u0005oTAA!?\u0002>\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005;\u00119\u0010E\u0003f\u0005W\u0012y\u0010\r\u0003\u0004\u0002\r\u001d\u0001CBAK\u0007\u0007\u0019)!C\u0002{\u0003/\u00032!`B\u0004\t-\u0019IaNA\u0001\u0002\u0003\u0015\t!!\u0001\u0003\u0007}##'\u0001\bnC:Lg-Z:u\u0007\u0006\u001c\u0007.\u001a\u0011\u00021M,'/[1mSj\fG/[8o\u0013:4wN]7bi&|g.\u0006\u0002\u0004\u0012A\u0019!\u0011\u0018\t)\u0007a\nI/\u0006\u0003\u0004\u0018\rmA\u0003BB\r\u0007;\u00012!`B\u000e\t\u001d\u0011Y)\u000fb\u0001\u0003\u0003AqAa$:\u0001\u0004\u0019y\u0002E\u0003f\u0005'\u001bI\"A\u0005tKJL\u0017\r\\5{KR!1QEB\u001c!\u0019\tYba\n\u0004,%!1\u0011FA\u000f\u0005\r!&/\u001f\t\u0006K\u000e52\u0011G\u0005\u0004\u0007_1'!B!se\u0006L\bcA3\u00044%\u00191Q\u00074\u0003\t\tKH/\u001a\u0005\u0007\u0007sQ\u0004\u0019\u00013\u0002\u0003=\f1\u0002Z3tKJL\u0017\r\\5{KV!1qHB#)!\u0019\tea\u0012\u0004L\r=\u0003CBA\u000e\u0007O\u0019\u0019\u0005E\u0002~\u0007\u000b\"qAa#<\u0005\u0004\t\t\u0001C\u0004\u0004Jm\u0002\raa\u000b\u0002\u000b\tLH/Z:\t\u000f\r53\b1\u0001\u0002(\u0006a1/\u001a:jC2L'0\u001a:JI\"91\u0011K\u001eA\u0002\rM\u0013!B2mCjT\b#B3\u0003l\rU\u0003\u0007BB,\u00077\u0002BA]=\u0004ZA\u0019Qpa\u0017\u0005\u0019\ru3qLA\u0001\u0002\u0003\u0015\taa\u001c\u0003\u0007}#C\u0007C\u0004\u0004Rm\u0002\ra!\u0019\u0011\u000b\u0015\u0014Yga\u00191\t\r\u00154\u0011\u000e\t\u0005ef\u001c9\u0007E\u0002~\u0007S\"Ab!\u0018\u0004`\u0005\u0005\t\u0011!B\u0001\u0007W\nB!a\u0001\u0004nA\u0019Qp!\u0012\u0012\t\u0005\r11\t\u000b\t\u0007g\u001a)ha\u001e\u0004zA)\u00111DB\u0014I\"91\u0011\n\u001fA\u0002\r-\u0002bBB'y\u0001\u0007\u0011q\u0015\u0005\b\u0007wb\u0004\u0019\u0001B\u0010\u0003!i\u0017M\\5gKN$\u0018\u0001\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0015\u0010^3BeJ\f\u0017\u0010F\u0004e\u0007\u0003\u001b\u0019ia\"\t\u000f\r%S\b1\u0001\u0004,!91QQ\u001fA\u0002\u0005=\u0011AC:fe&\fG.\u001b>fe\"911P\u001fA\u0002\t}\u0011!\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\bI\u000e55QTBP\u0011\u001d\u0019yI\u0010a\u0001\u0007#\u000b1AY;g!\u0011\u0019\u0019j!'\u000e\u0005\rU%\u0002BBL\u00037\u000b1A\\5p\u0013\u0011\u0019Yj!&\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0004Ny\u0002\r!a*\t\u000f\rmd\b1\u0001\u0003 !*aha)\u00040B)Qm!*\u0004*&\u00191q\u00154\u0003\rQD'o\\<t!\u0011\u0011\u0019fa+\n\t\r5&Q\u000b\u0002\u0019\u001d>$8+\u001a:jC2L'0\u00192mK\u0016C8-\u001a9uS>t7EABU+\u0011\u0019\u0019l!/\u0015\r\rU61XB_!\u0019\tYba\n\u00048B\u0019Qp!/\u0005\u000f\t-uH1\u0001\u0002\u0002!91\u0011J A\u0002\r-\u0002bBB)\u007f\u0001\u00071q\u0018\t\u0005ef\u001c9,A\tgS:$7+\u001a:jC2L'0\u001a:G_J$B!a\u0004\u0004F\"11\u0011\b!A\u0002\u0011\fQb]3sS\u0006d\u0017N_3s\r>\u0014H\u0003BA\b\u0007\u0017Dqa!\u0015B\u0001\u0004\u0019i\r\r\u0003\u0004P\u000eM\u0007\u0003\u0002:z\u0007#\u00042!`Bj\t1\u0019)na3\u0002\u0002\u0003\u0005)\u0011AA\u0001\u0005\ryF\u0005\u000f\u0015\u0006\u0003\u000e\r6qV\u0001\rg\u0016\u0014\u0018.\u00197ju\u0016\u0014xJ\u001a\u000b\u0005\u0007;\u001cy\u000e\u0005\u0004\u0002\u001c\r\u001d\u0012q\u0002\u0005\b\u0007C\u0014\u0005\u0019\u0001B\u0010\u00035\u0019XM]5bY&TXM\u001d$R\u001d\u0006\t2/\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0016\u0005\r\u001d\bC\u0002B{\u0007S\u001ci/\u0003\u0003\u0004l\n](aA*fcB\u0019\u0011ma<\n\u0007\rE8LA\tTKJL\u0017\r\\5{KJ$U\r^1jYN\f!c]3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7tA\u0005Y1/\u001a:jC2L'0\u001a:t+\t\u0019I\u0010E\u0004s\u00057\u0011y\"a\u0004\u0002\u0019M,'/[1mSj,'o\u001d\u0011\u0002\u0011\tLg\u000eZ5oON,\"\u0001\"\u0001\u0011\r\tU8\u0011\u001eC\u0002!\r\u0011IlA\u0001\nE&tG-\u001b8hg\u0002\nA$\u001a8tkJ,wJ\u001c7z\u00032dwn^3e'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\u0006\u0003\u0005\f\u0011E\u0001cA3\u0005\u000e%\u0019Aq\u00024\u0003\tUs\u0017\u000e\u001e\u0005\b\t'I\u0005\u0019\u0001C\u000b\u0003\u0011IG/\u001a:\u0011\r\u0005UBqCA\b\u0013\u0011\t\u0019-a\u0011\u0002?]\f'O\\+oKb\u0004Xm\u0019;fI:{g.Q6lCN+'/[1mSj,'\u000f\u0006\u0004\u0002J\u0012uA\u0011\u0006\u0005\b\u0007#R\u0005\u0019\u0001C\u0010a\u0011!\t\u0003\"\n\u0011\tILH1\u0005\t\u0004{\u0012\u0015B\u0001\u0004C\u0014\t;\t\t\u0011!A\u0003\u0002\u0005\u0005!\u0001B0%cABq\u0001b\u000bK\u0001\u0004\ty!A\u0002tKJ\f1c\u00195fG.<un\\4mKB\u0013x\u000e^8ck\u001a$B!!3\u00052!9A1G&A\u0002\t}\u0011!C2mCN\u001ch*Y7f\u0003\u0011\u0019xN\u001d;\u0015\t\u0011\u0005A\u0011\b\u0005\b\twa\u0005\u0019\u0001C\u001f\u0003\tIg\u000e\u0005\u0004\u00026\u0011}B1A\u0005\u0005\t\u0003\n\u0019E\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u00035\u0019XM]5bY&TXM]'baV\u0011Aq\t\t\t\t\u0013\"Y\u0005b\u0014\u0002\u00105\u0011!\u0011^\u0005\u0005\t\u001b\u0012IOA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004D\u0001\"\u0015\u0005VA!!/\u001fC*!\riHQ\u000b\u0003\f\t/r\u0015\u0011!A\u0001\u0006\u0003\t\tA\u0001\u0003`IE\n\u0014AD:fe&\fG.\u001b>fe6\u000b\u0007\u000fI\u0001\u0015g\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\u0011}\u0003c\u0002:\u0003\u001c\u0005\u001d\u0016qB\u0001\u0016g\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=!\u0003e\tX/[2l'\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\u0011\u001d\u0004#B3\u0004.\u0005=\u0011AG9vS\u000e\\7+\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif\u0004\u0013!E4fiN+'/[1mSj,'OQ=JIR!\u0011q\u0002C8\u0011\u001d!\th\u0015a\u0001\u0003O\u000b!!\u001b3\u0002C%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3\u0002E%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3!\u0003\u0001J7oV1s]&twm\u00148O_Z+'/\u001b4jG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0002C%\u001cx+\u0019:oS:<wJ\u001c(p-\u0016\u0014\u0018NZ5dCRLwN\\#oC\ndW\r\u001a\u0011\u00025%\u001cH)[:bY2|w/\u001a3KCZ\f7+\u001a:jC2L'0\u001a:\u0015\t\u0005%Gq\u0010\u0005\b\u0007\u000bC\u0006\u0019AA\b\u0003u\u0019\bn\\;mI^\u000b'O\\!c_V$(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014HCBAe\t\u000b#\u0019\nC\u0004\u0005\bf\u0003\r\u0001\"#\u0002\u001fM,'/[1mSj,Gm\u00117bgN\u0004D\u0001b#\u0005\u0010B!!/\u001fCG!\riHq\u0012\u0003\r\t##))!A\u0001\u0002\u000b\u0005\u0011\u0011\u0001\u0002\u0005?\u0012\n4\u0007C\u0004\u0004\u0006f\u0003\r!a\u0004)\u0007e\u000bI\u000f")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(119).append(new StringBuilder(35).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable)() -> "")).append(". ").toString()).append("The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0 & Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(62).append(new StringBuilder(106).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").toString()).append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0 & Serializable)() -> {
            Object object;
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                object = serializerWithStringManifest.fromBinary(bytes, manifest);
            } else {
                Object object2;
                String string = manifest;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object2 = serializer.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
                } else {
                    Object object3;
                    Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                    Option option = cache.get((Object)manifest);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Option cachedClassManifest = (Option)some.value();
                        object3 = serializer.fromBinary(bytes, cachedClassManifest);
                    } else if (None$.MODULE$.equals(option)) {
                        Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                        if (!(try_ instanceof Success)) {
                            if (try_ instanceof Failure) {
                                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                            }
                            throw new MatchError(try_);
                        }
                        Success success = (Success)try_;
                        Class classManifest = (Class)success.value();
                        Some classManifestOption = new Some((Object)classManifest);
                        this.updateCache$1(cache, manifest, (Option)classManifestOption);
                        Object object4 = serializer.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                        object3 = object4;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object2 = object3;
                }
                object = object2;
            }
            return object;
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(63).append(new StringBuilder(106).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").toString()).append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Object object2;
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object2 = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object2 = this.deserializeByteArray(bytes, serializer2, manifest);
            }
            object = object2;
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer serializer5;
            SeqOps seqOps;
            Seq seq = (Seq)this.bindings().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer5 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)seq.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((IterableOnceOps)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Serializer s = (Serializer)tuple2._2();
                        String string = s.getClass().getName();
                        return string;
                    })).mkString(", "));
                }
                serializer5 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer4 = serializer5;
            Serializer serializer6 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer6 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonAkkaSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                serializer3 = ser;
            } else {
                serializer3 = serializer6;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Serializer> serializerOf(String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var3_2 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this, fqn){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String fqn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : new Try<T>(A1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
            }
        });
    }

    private Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean warnUnexpectedNonAkkaSerializer(Class<?> clazz, Serializer ser) {
        boolean bl;
        if (clazz.getName().startsWith("akka.") && !ser.getClass().getName().startsWith("akka.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Akka. It's not recommended to replace serializers for messages provided by Akka.", ser.getClass().getName(), clazz.getName());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    Buffer buffer = buf.append(ca);
                    break;
                }
                default: {
                    buf.insert(n, ca);
                    Buffer buffer = BoxedUnit.UNIT;
                    break;
                }
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, (Map<String, Option<Class<?>>>)cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 != null && tuple2._2() instanceof JavaSerializer ? false : tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string;
        String string2;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string2 = className;
                if (alias != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string3 = string = alias;
        String string4 = "none";
        boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class clazz = (Class)tuple2._1();
        Serializer ser = (Serializer)tuple2._2();
        boolean bl = $this.warnUnexpectedNonAkkaSerializer(clazz, ser);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (Seq)vector.collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x1;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable)x$3 -> {
            String string;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = v;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string2).get());
            return tuple2;
        });
        Map result = (Map)fromConfig.$plus$plus((IterableOnce)this.serializerDetails().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer())));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable)x0$1 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        this.serializers = result;
        Map fromConfig2 = (Map)this.settings().SerializationBindings().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable)x$5 -> {
            String string;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string = className;
                    if (alias != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
            return tuple2;
        });
        Seq fromSettings = (Seq)this.serializerDetails().flatMap((Function1 & Serializable)detail -> (Seq)detail.useFor().map((Function1 & Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer())));
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((IterableOnce)fromSettings));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable)x0$2 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        result2.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$4, x1$1);
                    if (tuple22 == null) break block2;
                    map = (ConcurrentHashMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            ConcurrentHashMap concurrentHashMap = map;
            return concurrentHashMap;
        });
        this.serializerByIdentity = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus((IterableOnce)this.serializers().map((Function1 & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
            return tuple22;
        }));
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "address";
                    break;
                }
                case 1: {
                    string = "system";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)package$JavaConverters$.MODULE$.MapHasAsScala(cfg.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                return tuple22;
            });
        }

        public Settings(Config config) {
            Config config2;
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            if (config.getBoolean("akka.actor.enable-additional-serialization-bindings") || !config.getBoolean("akka.actor.allow-java-serialization") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled")) {
                Config bs = defaultBindings.withFallback((ConfigMergeable)config.getConfig("akka.actor.additional-serialization-bindings"));
                String additionalWhenJavaOffKey = "akka.actor.java-serialization-disabled-additional-serialization-bindings";
                config2 = !config.getBoolean("akka.actor.allow-java-serialization") ? bs.withFallback((ConfigMergeable)config.getConfig(additionalWhenJavaOffKey)) : bs;
            } else {
                config2 = defaultBindings;
            }
            Config bindings = config2;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

