/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.rabbitmq.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function4;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class JobLogUtil$
implements Producer {
    public static final JobLogUtil$ MODULE$ = new JobLogUtil$();
    private static final String START_DATA;
    private static final String END_DATA;
    private static final String START_CALL_WS;
    private static final String END_CALL_WS;
    private static final String VOLUME;
    private static final String VOLUME_ANALYSIS;
    private static final String VOLUME_SAMPLES;
    private static final String ERROR;
    private static final String INFO;
    private static final String WARNING;
    private static final DateTimeFormatter dateFormatter;
    private static LogUtil logsUtil;
    private static volatile boolean bitmap$0;

    static {
        Producer.$init$(MODULE$);
        START_DATA = "start_data";
        END_DATA = "end_data";
        START_CALL_WS = "start_call_ws";
        END_CALL_WS = "end_call_ws";
        VOLUME = "volume";
        VOLUME_ANALYSIS = "volume_analysis";
        VOLUME_SAMPLES = "volume_samples";
        ERROR = "error";
        INFO = "information";
        WARNING = "warning";
        dateFormatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss");
    }

    @Override
    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$(this, exchangeName, routingKey, queueName, message);
    }

    @Override
    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$(this, routingKey, message);
    }

    @Override
    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, exchangeName, routingKey, queueName, message, consumerFn);
    }

    @Override
    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$(this, routingKey, message, consumerFn);
    }

    @Override
    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, routingKey, message, timeout, rds, m);
    }

    @Override
    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$(this, routingKey, message, connection, channel, replyQueueName, rds, m);
    }

    @Override
    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$(this, routingKey, message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        JobLogUtil$ jobLogUtil$ = this;
        synchronized (jobLogUtil$) {
            if (!bitmap$0) {
                logsUtil = Producer.logsUtil$(this);
                bitmap$0 = true;
            }
        }
        return logsUtil;
    }

    @Override
    public LogUtil logsUtil() {
        if (!bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return logsUtil;
    }

    public String START_DATA() {
        return START_DATA;
    }

    public String END_DATA() {
        return END_DATA;
    }

    public String START_CALL_WS() {
        return START_CALL_WS;
    }

    public String END_CALL_WS() {
        return END_CALL_WS;
    }

    public String VOLUME() {
        return VOLUME;
    }

    public String VOLUME_ANALYSIS() {
        return VOLUME_ANALYSIS;
    }

    public String VOLUME_SAMPLES() {
        return VOLUME_SAMPLES;
    }

    public String ERROR() {
        return ERROR;
    }

    public String INFO() {
        return INFO;
    }

    public String WARNING() {
        return WARNING;
    }

    private DateTimeFormatter dateFormatter() {
        return dateFormatter;
    }

    public void log(long jobExecutionId, String comment, String value, String station) {
        this.sendTopic("job.log.created", Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)comment, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)value, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"station"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)station, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)new DateTime().getMillis()), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executionId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)jobExecutionId), (Writes)Writes$.MODULE$.LongWrites()))})).toString());
    }

    public void log(long jobExecutionId, String comment, DateTime value, String station) {
        this.log(jobExecutionId, comment, this.dateFormatter().print((ReadableInstant)value), station);
    }

    private JobLogUtil$() {
    }
}

