/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers;

import Alerting.dao.itf.CityAlertDao;
import Alerting.dao.rpc.MailDao;
import Alerting.domain.AlertClimaticParameter;
import Alerting.domain.AlertClimaticParameter$;
import Alerting.domain.AlertOutput;
import Alerting.domain.AlertOutput$;
import Alerting.model.EventCity;
import Alerting.utils.WSUtil$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.CityWithLinks;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.communication.MailUtils;
import fr.aquasys.utils.communication.SmsUtils;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import util.Aqua6boUtil;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000b\u0017\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ya\t\u0005\t]\u0001\u0011\t\u0011)A\u0006_!AQ\u0007\u0001B\u0001B\u0003-a\u0007\u0003\u0005?\u0001\t\u0005\t\u0015a\u0003@\u0011!Y\u0005A!A!\u0002\u0017a\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b1\u0002)\t\u0011i\u0003!\u0011!Q\u0001\fmC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006Y!\u0019\u0005\tU\u0002\u0011\t\u0011)A\u0006W\"A!\u000f\u0001B\u0001B\u0003-1\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002J\u0002!\t!a3\t\u000f\u00055\u0007\u0001\"\u0001\u0002L\ni\u0011\t\\3si\u000ec\u0017.\\1uS\u000eT!a\u0006\r\u0002\u0017\r|g\u000e\u001e:pY2,'o\u001d\u0006\u00023\u0005A\u0011\t\\3si&twm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0002xgB\u0011A\u0005L\u0007\u0002K)\u0011!E\n\u0006\u0003O!\nA\u0001\\5cg*\u0011\u0011FK\u0001\u0004CBL'\"A\u0016\u0002\tAd\u0017-_\u0005\u0003[\u0015\u0012\u0001bV*DY&,g\u000e^\u0001\fCF,\u0018M\u000e2p+RLG\u000e\u0005\u00021g5\t\u0011GC\u00013\u0003\u0011)H/\u001b7\n\u0005Q\n$aC!rk\u00064$m\\+uS2\fq!\\1jY\u0012\u000bw\u000e\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005\u0019!\u000f]2\u000b\u0005mB\u0012a\u00013b_&\u0011Q\b\u000f\u0002\b\u001b\u0006LG\u000eR1p\u0003%i\u0017-\u001b7Vi&d7\u000f\u0005\u0002A\u00136\t\u0011I\u0003\u0002C\u0007\u0006i1m\\7nk:L7-\u0019;j_:T!\u0001R#\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0019;\u0015aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002\u0011\u0006\u0011aM]\u0005\u0003\u0015\u0006\u0013\u0011\"T1jYV#\u0018\u000e\\:\u0002\u0011Ml7/\u0016;jYN\u0004\"\u0001Q'\n\u00059\u000b%\u0001C*ngV#\u0018\u000e\\:\u0002%MLW-Y;QCJ\fW.\u001a;feN$\u0015m\u001c\t\u0003#bk\u0011A\u0015\u0006\u0003'R\u000b1!\u001b;g\u0015\t)f+\u0001\bbI6Lg.[:ue\u0006$\u0018n\u001c8\u000b\u0005]+\u0015!\u00023bK\u0006,\u0018BA-S\u0005I\u0019\u0016.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0002\u0019\rLG/_!mKJ$H)Y8\u0011\u0005qsV\"A/\u000b\u0005MS\u0014BA0^\u00051\u0019\u0015\u000e^=BY\u0016\u0014H\u000fR1p\u00035\u0019\u0018M\u001c3sK\u000e{G-\u001a#b_B\u0011!\r[\u0007\u0002G*\u00111\b\u001a\u0006\u0003K\u001a\f!b]1oIJ,7i\u001c3f\u0015\t9g+\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7/\u0003\u0002jG\ni1+\u00198ee\u0016\u001cu\u000eZ3EC>\fqaY5us\u0012\u000bw\u000e\u0005\u0002ma6\tQN\u0003\u0002T]*\u0011qNZ\u0001\u0005G&$\u00180\u0003\u0002r[\n91)\u001b;z\t\u0006|\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003ibl\u0011!\u001e\u0006\u0003eYT!a^#\u0002\u0011I\f'MY5u[FL!!_;\u0003\u000f1{w-\u0016;jY\u00061A(\u001b8jiz\"\u0012\u0001 \u000b\u0015{~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0011\u0005y\u0004Q\"\u0001\f\t\u000b\tZ\u00019A\u0012\t\u000b9Z\u00019A\u0018\t\u000bUZ\u00019\u0001\u001c\t\u000byZ\u00019A \t\u000b-[\u00019\u0001'\t\u000b=[\u00019\u0001)\t\u000bi[\u00019A.\t\u000b\u0001\\\u00019A1\t\u000b)\\\u00019A6\t\u000bI\\\u00019A:)\u0007-\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\r%t'.Z2u\u0015\t\ty\"A\u0003kCZ\f\u00070\u0003\u0003\u0002$\u0005e!AB%oU\u0016\u001cG/A\u0004fq\u0016\u001cW\u000f^3\u0015\t\u0005%\u0012q\u0006\t\u0004;\u0005-\u0012bAA\u0017=\t!QK\\5u\u0011\u001d\t\t\u0004\u0004a\u0001\u0003g\t\u0001B[8c\u0013:\u0004X\u000f\u001e\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b<\u0002\r\u0011|W.Y5o\u0013\u0011\ti$a\u000e\u0003\u0011){'-\u00138qkR\fq\u0002\u001e5sK\u0006$X.\u001a8u\u00032,'\u000f\u001e\u000b\t\u0003\u0007\nI%a\u0019\u0002\u0004B\u0019Q$!\u0012\n\u0007\u0005\u001dcDA\u0002B]fDq!a\u0013\u000e\u0001\u0004\ti%A\u0005usB,\u0017\t\\3siB!\u0011qJA/\u001d\u0011\t\t&!\u0017\u0011\u0007\u0005Mc$\u0004\u0002\u0002V)\u0019\u0011q\u000b\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\tYFH\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0013\u0011\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mc\u0004C\u0004\u0002f5\u0001\r!a\u001a\u0002\u001f1L7\u000f^\"jif$v.\u00117feR\u0004b!!\u001b\u0002t\u0005ed\u0002BA6\u0003_rA!a\u0015\u0002n%\tq$C\u0002\u0002ry\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002v\u0005]$aA*fc*\u0019\u0011\u0011\u000f\u0010\u0011\t\u0005m\u0014qP\u0007\u0003\u0003{R1!!\u000f\u0019\u0013\u0011\t\t)! \u0003-\u0005cWM\u001d;DY&l\u0017\r^5d!\u0006\u0014\u0018-\\3uKJDq!!\"\u000e\u0001\u0004\t9)\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0007u\tI)C\u0002\u0002\fz\u0011A\u0001T8oO\u0006Y1M]3bi\u0016\fE.\u001a:u)!\tI#!%\u0002\u0016\u0006]\u0005bBAJ\u001d\u0001\u0007\u0011\u0011P\u0001\fG&$\u0018\u0010V8BY\u0016\u0014H\u000fC\u0004\u0002\u0006:\u0001\r!a\"\t\u000f\u0005-c\u00021\u0001\u0002N\u0005AQM\u001c3BY\u0016\u0014H\u000f\u0006\u0005\u0002*\u0005u\u0015qTAQ\u0011\u001d\t\u0019j\u0004a\u0001\u0003sBq!!\"\u0010\u0001\u0004\t9\tC\u0004\u0002L=\u0001\r!!\u0014\u0002\u0019M,g\u000eZ#oI\u0006cWM\u001d;\u0015\u0011\u0005%\u0012qUAU\u0003WCq!a%\u0011\u0001\u0004\tI\bC\u0004\u0002\u0006B\u0001\r!a\"\t\u000f\u0005-\u0003\u00031\u0001\u0002N\u0005q1/\u001a8e'R\f'\u000f^!mKJ$H\u0003CA\u0015\u0003c\u000b\u0019,!.\t\u000f\u0005M\u0015\u00031\u0001\u0002z!9\u0011QQ\tA\u0002\u0005\u001d\u0005bBA&#\u0001\u0007\u0011QJ\u0001\u000eg\u0016tG-T1jY\u0006cWM\u001d;\u0015\u0011\u0005%\u00121XAa\u0003\u000bDq!!0\u0013\u0001\u0004\ty,\u0001\u0004f[\u0006LGn\u001d\t\u0007\u0003S\n\u0019(!\u0014\t\u000f\u0005\r'\u00031\u0001\u0002N\u00059Q.Z:tC\u001e,\u0007bBAd%\u0001\u0007\u0011QJ\u0001\bgV\u0014'.Z2u\u000399W\r^#oIR+W\u000e\u001d7bi\u0016$\"!!\u0014\u0002!\u001d,Go\u0015;beR$V-\u001c9mCR,\u0007")
public class AlertClimatic {
    private final WSClient ws;
    private final Aqua6boUtil aqua6boUtil;
    private final MailUtils mailUtils;
    private final SmsUtils smsUtils;
    private final CityAlertDao cityAlertDao;
    private final SandreCodeDao sandreCodeDao;
    private final CityDao cityDao;
    private final LogUtil logUtil;

    public void execute(JobInput jobInput) {
        block3: {
            long jobExecutionId = jobInput.jobExecutionId();
            try {
                if (!jobInput.parameters().isDefined()) break block3;
                ObjectRef listCityToAlertApic = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
                ObjectRef listCityToAlertvigieCrue = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
                ((IterableOps)jobInput.parameters().get()).map((Function1 & Serializable)param -> Json$.MODULE$.parse(param).validate(AlertClimaticParameter$.MODULE$.format()).fold((Function1 & Serializable)error -> {
                    JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), new StringBuilder(22).append("Can't read parameter: ").append(error).toString(), "");
                    $this.logUtil.error(new StringBuilder(22).append("Can't read parameter: ").append(error).toString(), $this.logUtil.error$default$2());
                    return None$.MODULE$;
                }, (Function1 & Serializable)validate -> {
                    AlertClimatic.$anonfun$execute$3(listCityToAlertApic, listCityToAlertvigieCrue, validate);
                    return BoxedUnit.UNIT;
                }));
                Object object = ((Seq)listCityToAlertApic.elem).length() > 0 ? this.threatmentAlert("apic", (Seq<AlertClimaticParameter>)((Seq)listCityToAlertApic.elem), jobExecutionId) : BoxedUnit.UNIT;
                if (((Seq)listCityToAlertvigieCrue.elem).length() > 0) {
                    this.threatmentAlert("vigicrueflash", (Seq<AlertClimaticParameter>)((Seq)listCityToAlertvigieCrue.elem), jobExecutionId);
                }
            }
            catch (Exception e) {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), e.getMessage(), "Job Failed");
                this.logUtil.error(new StringBuilder(24).append("threw an exception :\n").append(e.getMessage()).append(" \n ").append(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()), (Function1 & Serializable)s -> s.toString(), ClassTag$.MODULE$.apply(String.class))).toString(), this.logUtil.error$default$2());
            }
        }
    }

    public Object threatmentAlert(String typeAlert, Seq<AlertClimaticParameter> listCityToAlert, long jobExecutionId) {
        String listCity = ((IterableOnceOps)listCityToAlert.map((Function1 & Serializable)c -> c.insee())).mkString(",").toString();
        String AQUA6BO_URL = System.getenv("AQUA6BO_URL");
        String url = new StringBuilder(21).append(AQUA6BO_URL).append("/data/climatic/alert/").append(typeAlert).append(this.aqua6boUtil.getParams((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insee"), (Object)listCity)}))))).toString();
        Option listAlertAqua6Bo = WSUtil$.MODULE$.getWithAuth(url, 4, Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), AlertOutput$.MODULE$.format()), this.ws);
        if (listAlertAqua6Bo.isDefined() && ((SeqOps)listAlertAqua6Bo.get()).length() > 0) {
            return listCityToAlert.map((Function1 & Serializable)cityToAlert -> {
                AlertClimatic.$anonfun$threatmentAlert$2(this, listAlertAqua6Bo, jobExecutionId, typeAlert, cityToAlert);
                return BoxedUnit.UNIT;
            });
        }
        listCityToAlert.map((Function1 & Serializable)cityToAlert -> {
            this.endAlert(cityToAlert, jobExecutionId, typeAlert);
            return BoxedUnit.UNIT;
        });
        JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.END_DATA(), " No alert", "");
        return BoxedUnit.UNIT;
    }

    public void createAlert(AlertClimaticParameter cityToAlert, long jobExecutionId, String typeAlert) {
        block10: {
            String string;
            None$ threshold;
            block11: {
                block9: {
                    None$ none$;
                    String string2 = typeAlert;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -1434154788: {
                            if (!"vigicrueflash".equals(string2)) break;
                            none$ = new Some(cityToAlert.vigiecrue().get());
                            break block9;
                        }
                        case 3000713: {
                            if (!"apic".equals(string2)) break;
                            none$ = new Some(cityToAlert.apic().get());
                            break block9;
                        }
                    }
                    none$ = threshold = None$.MODULE$;
                }
                if (!threshold.isDefined()) break block10;
                String string3 = typeAlert;
                switch (string3 == null ? 0 : string3.hashCode()) {
                    case -1434154788: {
                        if (!"vigicrueflash".equals(string3)) break;
                        string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.VIGIECRUE", BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get())).get()).name();
                        break block11;
                    }
                    case 3000713: {
                        if (!"apic".equals(string3)) break;
                        string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.APIC", BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get())).get()).name();
                        break block11;
                    }
                }
                string = "";
            }
            String nameSeuil = string;
            Option<EventCity> evtCity = this.cityAlertDao.getEvent(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(cityToAlert.insee())), typeAlert, BoxesRunTime.unboxToInt((Object)threshold.get()));
            if (!evtCity.isDefined()) {
                this.cityAlertDao.createEvent(cityToAlert.insee().toString(), BoxesRunTime.unboxToInt((Object)threshold.get()), jobExecutionId, typeAlert);
                this.sendStartAlert(cityToAlert, jobExecutionId, typeAlert);
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.INFO(), new StringBuilder(16).append(nameSeuil).append(": start of event").toString(), cityToAlert.insee().toString());
                return;
            }
            return;
        }
    }

    public void endAlert(AlertClimaticParameter cityToAlert, long jobExecutionId, String typeAlert) {
        block10: {
            String string;
            None$ threshold;
            block11: {
                block9: {
                    None$ none$;
                    String string2 = typeAlert;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -1434154788: {
                            if (!"vigicrueflash".equals(string2)) break;
                            none$ = new Some(cityToAlert.vigiecrue().get());
                            break block9;
                        }
                        case 3000713: {
                            if (!"apic".equals(string2)) break;
                            none$ = new Some(cityToAlert.apic().get());
                            break block9;
                        }
                    }
                    none$ = threshold = None$.MODULE$;
                }
                if (!threshold.isDefined()) break block10;
                String string3 = typeAlert;
                switch (string3 == null ? 0 : string3.hashCode()) {
                    case -1434154788: {
                        if (!"vigicrueflash".equals(string3)) break;
                        string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.VIGIECRUE", BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get())).get()).name();
                        break block11;
                    }
                    case 3000713: {
                        if (!"apic".equals(string3)) break;
                        string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.APIC", BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get())).get()).name();
                        break block11;
                    }
                }
                string = "";
            }
            String nameSeuil = string;
            Option<EventCity> evtCity = this.cityAlertDao.getEvent(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(cityToAlert.insee())), typeAlert, BoxesRunTime.unboxToInt((Object)threshold.get()));
            if (evtCity.isDefined()) {
                this.cityAlertDao.closeEvent(((EventCity)evtCity.get()).id());
                this.sendEndAlert(cityToAlert, jobExecutionId, typeAlert);
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.INFO(), new StringBuilder(14).append(nameSeuil).append(": end of event").toString(), cityToAlert.insee().toString());
                return;
            }
            return;
        }
    }

    private void sendEndAlert(AlertClimaticParameter cityToAlert, long jobExecutionId, String typeAlert) {
        String string;
        String nameCity;
        block4: {
            nameCity = (String)((CityWithLinks)this.cityDao.get(cityToAlert.insee().toString()).get()).name().getOrElse((Function0 & Serializable)() -> "");
            String string2 = typeAlert;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1434154788: {
                    if (!"vigicrueflash".equals(string2)) break;
                    string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.VIGIECRUE", BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get())).get()).name();
                    break block4;
                }
                case 3000713: {
                    if (!"apic".equals(string2)) break;
                    string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.APIC", BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get())).get()).name();
                    break block4;
                }
            }
            string = "";
        }
        String nameSeuil = string;
        cityToAlert.contacts().map((Function1 & Serializable)contact -> {
            AlertClimatic.$anonfun$sendEndAlert$2(this, cityToAlert, nameCity, typeAlert, nameSeuil, jobExecutionId, contact);
            return BoxedUnit.UNIT;
        });
    }

    private void sendStartAlert(AlertClimaticParameter cityToAlert, long jobExecutionId, String typeAlert) {
        String string;
        String nameCity;
        block4: {
            nameCity = (String)((CityWithLinks)this.cityDao.get(cityToAlert.insee().toString()).get()).name().getOrElse((Function0 & Serializable)() -> "");
            String string2 = typeAlert;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1434154788: {
                    if (!"vigicrueflash".equals(string2)) break;
                    string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.VIGIECRUE", BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get())).get()).name();
                    break block4;
                }
                case 3000713: {
                    if (!"apic".equals(string2)) break;
                    string = ((SandreCode)this.sandreCodeDao.findByCode("CLIMATIC.APIC", BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get())).get()).name();
                    break block4;
                }
            }
            string = "";
        }
        String nameSeuil = string;
        cityToAlert.contacts().map((Function1 & Serializable)contact -> {
            AlertClimatic.$anonfun$sendStartAlert$2(this, cityToAlert, nameCity, typeAlert, nameSeuil, jobExecutionId, contact);
            return BoxedUnit.UNIT;
        });
    }

    public void sendMailAlert(Seq<String> emails, String message, String subject) {
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
    }

    public String getEndTemplate() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//Dtd XHTML 1.0 transitional//EN\"\n        \"http://www.w3.org/tr/xhtml1/Dtd/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\n    <title>AQUASYS - Alerte</title>\n    <meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0,maximum-scale=1\">\n    <meta name=\"author\" content=\"AQUASYS\">\n    <meta name=\"owner\" content=\"AQUASYS\">\n    <link href=\"http://www.aquasys.fr/css/images/aquasys.gif\" rel=\"shortcut icon\" type=\"image/x-icon\"/>\n\n</head>\n<body style=\"background:#eeeeee;\">\n<table align=\"center\"\n       style=\"margin-top:0px; background:#eeeeee;\tcolor: #484848;\tfont-family: arial,verdana,helvetica,sans-serif;font-size: 12px;line-height: 1.5em;\">\n    <tr>\n        <td>\n            <table id=\"page\"\n                   style=\"width: 100%;max-width:1400px;background: #ffffff;margin-top: 5px;box-shadow: 1px 1px 8px #AAAAAA;margin-left:auto;margin-right:auto;\">\n                <tr>\n                    <td>\n                        <table id=\"tableContent\" style=\"width:100%;padding:0px;\">\n                            <tr>\n                                <td style=\"height: 140px;background: url(https://www.aquasys.fr/wp-content/uploads/2018/01/Visuel-inscription-beta-test-sans-texte.png);background-repeat:no-repeat;background-size: 100%;\">\n                                    <h1 style=\"color: #ffffff;padding:10px;font-size: 36px;font-weight: bold;\">SIEau</h1>\n                                    <h2 style=\"color: #ffffff;padding:10px;font-size: 24px;font-weight: bold;\">\n                                        Syt&egrave;me d'information sur l'Eau\n                                    </h2>\n                                </td>\n                            </tr>\n                        </table>\n                        <table style=\"width:100%\">\n                            <tr style=\"vertical-align:top;\">\n                                <td style=\"width:85%\">\n                                    <table id=\"tableContent\" style=\"width:100%;padding:10px;\">\n                                        <tr>\n                                            <td style=\"text-align:left;\">\n                                                <div style=\"background-color: green\">\n                                                    <h2 style=\"margin:30px; font-size: 12px; font-weight: bold; color:white\">\n                                                               Fin d'\u00e9v\u00e9nement climatique  \n                                                    </h2>\n                                                </div>\n                                                <p style=\"margin:0;\">Commune : [{city}] {cityName}</p>\n                                                <p style=\"margin:0;\">Source de l'avertissement {typeClimatic} </p>\n                                                <p style=\"margin:0;\">Niveau d'alerte: {thresholdTitle}</p>\n                                                <p style=\"margin:0;\">Date  : {dateClimatic}</p>\n                                            </td>\n                                        </tr>\n                                        <tr>\n                                            <td>\n                                                <br/>\n                                                <h2 style=\"color: #484848;font-size: 12px;text-align: left;font-style: italic;font-weight: normal;\">\n                                                    Cordialement,\n                                                </h2>\n                                                <h2 style=\"color: #484848;font-size: 12px;text-align: left;font-style: italic;font-weight: normal;\">\n                                                    L'&eacute;quipe AQUASYS\n                                                </h2>\n                                            </td>\n                                        </tr>\n                                        <tr style=\"width: 100%; text-align: center\">\n                                            <td>\n                                                <a href=\"{applicationUrlurl}\"> {applicationUrl}</a>\n                                            </td>\n                                        </tr>\n                                    </table>\n                                </td>\n                            </tr>\n                        </table>\n                    </td>\n                </tr>\n            </table>\n        </td>\n    </tr>\n</table>\n<table align=\"center\" id=\"footer\"\n       style=\"color: #484848;font-size: 10px;text-align: center;font-style: italic;font-weight: normal;\">\n    <tr>\n        <td>\n            <a href=\"http://www.aquasys.fr\" style=\"color: #484848;text-decoration:none;\" target=\"_new\">&copy;\n                Aquasys</a>\n            Si vous avez besoin d'aide, contactez notre &eacute;quipe: support@aquasys.fr<br>\n        </td>\n    </tr>\n</table>\n</td>\n</tr>\n</table>\n</body>\n</html>";
    }

    public String getStartTemplate() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//Dtd XHTML 1.0 transitional//EN\"\n        \"http://www.w3.org/tr/xhtml1/Dtd/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\n    <title>AQUASYS - Alerte</title>\n    <meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0,maximum-scale=1\">\n    <meta name=\"author\" content=\"AQUASYS\">\n    <meta name=\"owner\" content=\"AQUASYS\">\n    <link href=\"http://www.aquasys.fr/css/images/aquasys.gif\" rel=\"shortcut icon\" type=\"image/x-icon\"/>\n\n</head>\n<body style=\"background:#eeeeee;\">\n<table align=\"center\"\n       style=\"margin-top:0px; background:#eeeeee;\tcolor: #484848;\tfont-family: arial,verdana,helvetica,sans-serif;font-size: 12px;line-height: 1.5em;\">\n    <tr>\n        <td>\n            <table id=\"page\"\n                   style=\"width: 100%;max-width:1400px;background: #ffffff;margin-top: 5px;box-shadow: 1px 1px 8px #AAAAAA;margin-left:auto;margin-right:auto;\">\n                <tr>\n                    <td>\n                        <table id=\"tableContent\" style=\"width:100%;padding:0px;\">\n                            <tr>\n                                <td style=\"height: 140px;background: url(https://www.aquasys.fr/wp-content/uploads/2018/01/Visuel-inscription-beta-test-sans-texte.png);background-repeat:no-repeat;background-size: 100%;\">\n                                    <h1 style=\"color: #ffffff;padding:10px;font-size: 36px;font-weight: bold;\">SIEau</h1>\n                                    <h2 style=\"color: #ffffff;padding:10px;font-size: 24px;font-weight: bold;\">\n                                        Syt&egrave;me d'information sur l'Eau\n                                    </h2>\n                                </td>\n                            </tr>\n                        </table>\n                        <table style=\"width:100%\">\n                            <tr style=\"vertical-align:top;\">\n                                <td style=\"width:85%\">\n                                    <table id=\"tableContent\" style=\"width:100%;padding:10px;\">\n                                        <tr>\n                                            <td style=\"text-align:left;\">\n                                                <div style=\"background-color: red\">\n                                                    <h2 style=\"margin:30px; font-size: 12px; font-weight: bold; color:white\">\n                                                               D\u00e9but d'\u00e9v\u00e9nement climatique  \n                                                    </h2>\n                                                </div>\n                                                <p style=\"margin:0;\">Commune : [{city}] {cityName}</p>\n                                                <p style=\"margin:0;\">Source de l'avertissement {typeClimatic} </p>\n                                                <p style=\"margin:0;\">Niveau d'alerte: {thresholdTitle}</p>\n                                                <p style=\"margin:0;\">Date  : {dateClimatic}</p>\n                                            </td>\n                                        </tr>\n                                        <tr>\n                                            <td>\n                                                <br/>\n                                                <h2 style=\"color: #484848;font-size: 12px;text-align: left;font-style: italic;font-weight: normal;\">\n                                                    Cordialement,\n                                                </h2>\n                                                <h2 style=\"color: #484848;font-size: 12px;text-align: left;font-style: italic;font-weight: normal;\">\n                                                    L'&eacute;quipe AQUASYS\n                                                </h2>\n                                            </td>\n                                        </tr>\n                                        <tr style=\"width: 100%; text-align: center\">\n                                            <td>\n                                                <a href=\"{applicationUrl}\"> {applicationUrl}</a>\n                                            </td>\n                                        </tr>\n                                    </table>\n                                </td>\n                            </tr>\n                        </table>\n                    </td>\n                </tr>\n            </table>\n        </td>\n    </tr>\n</table>\n<table align=\"center\" id=\"footer\"\n       style=\"color: #484848;font-size: 10px;text-align: center;font-style: italic;font-weight: normal;\">\n    <tr>\n        <td>\n            <a href=\"http://www.aquasys.fr\" style=\"color: #484848;text-decoration:none;\" target=\"_new\">&copy;\n                Aquasys</a>\n            Si vous avez besoin d'aide, contactez notre &eacute;quipe: support@aquasys.fr<br>\n        </td>\n    </tr>\n</table>\n</td>\n</tr>\n</table>\n</body>\n</html>";
    }

    public static final /* synthetic */ void $anonfun$execute$3(ObjectRef listCityToAlertApic$1, ObjectRef listCityToAlertvigieCrue$1, AlertClimaticParameter validate) {
        if (validate.apic().isDefined()) {
            listCityToAlertApic$1.elem = (Seq)((Seq)listCityToAlertApic$1.elem).$plus$plus((IterableOnce)new Some((Object)validate));
        }
        if (validate.vigiecrue().isDefined()) {
            listCityToAlertvigieCrue$1.elem = (Seq)((Seq)listCityToAlertvigieCrue$1.elem).$plus$plus((IterableOnce)new Some((Object)validate));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$threatmentAlert$3(AlertClimaticParameter cityToAlert$1, AlertOutput a) {
        return a.insee().equalsIgnoreCase(cityToAlert$1.insee().toString());
    }

    public static final /* synthetic */ void $anonfun$threatmentAlert$2(AlertClimatic $this, Option listAlertAqua6Bo$1, long jobExecutionId$2, String typeAlert$1, AlertClimaticParameter cityToAlert) {
        boolean alertOuPas;
        block6: {
            boolean bl;
            Seq myCityAlertFilterAqua6Bo = (Seq)((IterableOps)listAlertAqua6Bo$1.get()).filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AlertClimatic.$anonfun$threatmentAlert$3(cityToAlert, a)));
            if (myCityAlertFilterAqua6Bo.isEmpty()) {
                $this.endAlert(cityToAlert, jobExecutionId$2, typeAlert$1);
                return;
            }
            String string = typeAlert$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1434154788: {
                    if (!"vigicrueflash".equals(string)) break;
                    bl = BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get()) > 0 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((AlertOutput)myCityAlertFilterAqua6Bo.head()).etat())) >= BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get()) : BoxesRunTime.unboxToInt((Object)cityToAlert.vigiecrue().get()) == StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((AlertOutput)myCityAlertFilterAqua6Bo.head()).etat()));
                    break block6;
                }
                case 3000713: {
                    if (!"apic".equals(string)) break;
                    bl = BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get()) > 0 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((AlertOutput)myCityAlertFilterAqua6Bo.head()).etat())) >= BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get()) : BoxesRunTime.unboxToInt((Object)cityToAlert.apic().get()) == StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((AlertOutput)myCityAlertFilterAqua6Bo.head()).etat()));
                    break block6;
                }
            }
            bl = alertOuPas = false;
        }
        if (alertOuPas) {
            $this.createAlert(cityToAlert, jobExecutionId$2, typeAlert$1);
            return;
        }
        $this.endAlert(cityToAlert, jobExecutionId$2, typeAlert$1);
    }

    public static final /* synthetic */ void $anonfun$sendEndAlert$2(AlertClimatic $this, AlertClimaticParameter cityToAlert$2, String nameCity$1, String typeAlert$2, String nameSeuil$1, long jobExecutionId$3, String contact) {
        if (BoxesRunTime.unboxToBoolean((Object)cityToAlert$2.email().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            String string;
            Seq<String> emails = $this.cityAlertDao.getEmail(contact);
            try {
                string = Source$.MODULE$.fromFile($this.getClass().getResource("/endAlertMailClimatic.HTML").toURI(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("");
            }
            catch (Throwable throwable) {
                string = $this.getStartTemplate();
            }
            String templateMail = string;
            String message = templateMail.replace("{city}", cityToAlert$2.insee().toString()).replace("{cityName}", nameCity$1).replace("{typeClimatic}", typeAlert$2).replace("{thresholdTitle}", nameSeuil$1).replace("{dateClimatic}", DateTime.now().toString("yyyy/MM/dd HH:mm:ss")).replace("{applicationUrl}", (CharSequence)package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> ""));
            String subject = new StringBuilder(30).append("[").append(cityToAlert$2.insee()).append("] ").append(typeAlert$2).append(" Fin d'\u00e9v\u00e9nement climatique").toString();
            try {
                $this.sendMailAlert(emails, message, subject);
            }
            catch (Throwable e) {
                JobLogUtil$.MODULE$.log(jobExecutionId$3, JobLogUtil$.MODULE$.ERROR(), "Error to Send mail:  ", cityToAlert$2.insee().toString());
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$3, JobLogUtil$.MODULE$.INFO(), new StringBuilder(47).append(typeAlert$2).append(", Email \"Fin d'\u00e9v\u00e9nement climatique\" sent to : ").append(emails).toString(), cityToAlert$2.insee().toString());
        }
        if (BoxesRunTime.unboxToBoolean((Object)cityToAlert$2.sms().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            Seq<String> phoneNumbers = $this.cityAlertDao.getTel(contact);
            String smsMessage = new StringBuilder(54).append("acycliQ by Aquasys : [").append(cityToAlert$2.insee()).append("] ").append(typeAlert$2).append(" - Fin d'\u00e9v\u00e9nement climatique ").toString();
            Seq<String> x$1 = phoneNumbers;
            String x$2 = smsMessage;
            Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$3));
            Option x$4 = $this.smsUtils.sendSms$default$3();
            Option x$5 = $this.smsUtils.sendSms$default$4();
            $this.smsUtils.sendSms(x$1, x$2, x$4, x$5, (Option)x$3);
            JobLogUtil$.MODULE$.log(jobExecutionId$3, JobLogUtil$.MODULE$.INFO(), new StringBuilder(27).append("SMS successfully sent to : ").append(phoneNumbers.mkString(", ")).toString(), cityToAlert$2.insee());
            JobLogUtil$.MODULE$.log(jobExecutionId$3, JobLogUtil$.MODULE$.INFO(), "SMS  \"Fin d'\u00e9v\u00e9nement climatique\" sent", cityToAlert$2.insee());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendStartAlert$2(AlertClimatic $this, AlertClimaticParameter cityToAlert$3, String nameCity$2, String typeAlert$3, String nameSeuil$2, long jobExecutionId$4, String contact) {
        if (BoxesRunTime.unboxToBoolean((Object)cityToAlert$3.email().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            String string;
            Seq<String> emails = $this.cityAlertDao.getEmail(contact);
            try {
                string = Source$.MODULE$.fromFile($this.getClass().getResource("/alertMailClimatic.html").toURI(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("");
            }
            catch (Throwable throwable) {
                string = $this.getStartTemplate();
            }
            String templateMail = string;
            String message = templateMail.replace("{city}", cityToAlert$3.insee().toString()).replace("{cityName}", nameCity$2).replace("{typeClimatic}", typeAlert$3).replace("{thresholdTitle}", nameSeuil$2).replace("{dateClimatic}", DateTime.now().toString("yyyy/MM/dd HH:mm:ss")).replace("{applicationUrl}", (CharSequence)package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> ""));
            String subject = new StringBuilder(33).append("[").append(cityToAlert$3.insee()).append("]  ").append(typeAlert$3).append(" D\u00e9but d'\u00e9v\u00e9nement climatique").toString();
            try {
                $this.sendMailAlert(emails, message, subject);
            }
            catch (Throwable e) {
                JobLogUtil$.MODULE$.log(jobExecutionId$4, JobLogUtil$.MODULE$.ERROR(), "Error to Send mail:  ", cityToAlert$3.insee());
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$4, JobLogUtil$.MODULE$.INFO(), new StringBuilder(49).append(typeAlert$3).append(", Email \"D\u00e9but d'\u00e9v\u00e9nement climatique\" sent to : ").append(emails).toString(), cityToAlert$3.insee());
        }
        if (BoxesRunTime.unboxToBoolean((Object)cityToAlert$3.sms().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            Seq<String> phoneNumbers = $this.cityAlertDao.getTel(contact);
            String smsMessage = new StringBuilder(59).append("acycliQ by Aquasys : [").append(cityToAlert$3.insee()).append(" : ").append(nameCity$2).append("] ").append(typeAlert$3).append(" - D\u00e9but d'\u00e9v\u00e9nement climatique ").toString();
            Seq<String> x$1 = phoneNumbers;
            String x$2 = smsMessage;
            Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$4));
            Option x$4 = $this.smsUtils.sendSms$default$3();
            Option x$5 = $this.smsUtils.sendSms$default$4();
            $this.smsUtils.sendSms(x$1, x$2, x$4, x$5, (Option)x$3);
            JobLogUtil$.MODULE$.log(jobExecutionId$4, JobLogUtil$.MODULE$.INFO(), new StringBuilder(27).append("SMS successfully sent to : ").append(phoneNumbers.mkString(", ")).toString(), cityToAlert$3.insee());
            JobLogUtil$.MODULE$.log(jobExecutionId$4, JobLogUtil$.MODULE$.INFO(), "SMS  \"d\u00e9but d'\u00e9v\u00e9nement climatique\" sent", cityToAlert$3.insee());
            return;
        }
    }

    @Inject
    public AlertClimatic(WSClient ws, Aqua6boUtil aqua6boUtil, MailDao mailDao, MailUtils mailUtils, SmsUtils smsUtils, SieauParametersDao sieauParametersDao, CityAlertDao cityAlertDao, SandreCodeDao sandreCodeDao, CityDao cityDao, LogUtil logUtil) {
        this.ws = ws;
        this.aqua6boUtil = aqua6boUtil;
        this.mailUtils = mailUtils;
        this.smsUtils = smsUtils;
        this.cityAlertDao = cityAlertDao;
        this.sandreCodeDao = sandreCodeDao;
        this.cityDao = cityDao;
        this.logUtil = logUtil;
    }
}

