/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers;

import Alerting.constants.AlertTypeContants$;
import Alerting.domain.AlertParameter;
import Alerting.domain.AlertParameter$;
import Alerting.model.Measure;
import Alerting.utils.AlertUtils;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicMeasure;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.CityWithLinks;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.model.DataType;
import fr.aquasys.daeau.station.model.MeasureDate;
import fr.aquasys.daeau.station.model.StationLight;
import fr.aquasys.daeau.station.model.StationLight$;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0006\r\u0001EA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006Y!\u0007\u0005\tK\u0001\u0011\t\u0011)A\u0006M!AA\u0006\u0001B\u0001B\u0003-Q\u0006\u0003\u00058\u0001\t\u0005\t\u0015a\u00039\u0011!\u0001\u0005A!A!\u0002\u0017\t\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b1B$\t\u0011=\u0003!\u0011!Q\u0001\fAC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006Y\u0001\u0017\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006c\u0002!\tA\u001d\u0002\u000b\u00032,'\u000f\u001e%zIJ|'BA\u0007\u000f\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u0003=\t\u0001\"\u00117feRLgnZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\tQ2%D\u0001\u001c\u0015\taR$\u0001\u0003vi&d'B\u0001\u0010 \u0003!\u0011\u0018M\u00192ji6\f(B\u0001\u0011\"\u0003\u001d\t\u0017/^1tsNT\u0011AI\u0001\u0003MJL!\u0001J\u000e\u0003\u000f1{w-\u0016;jY\u0006Q\u0011\r\\3siV#\u0018\u000e\\:\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%r\u0011!B;uS2\u001c\u0018BA\u0016)\u0005)\tE.\u001a:u+RLGn]\u0001\u0010Qf$'o\\\"ie>t\u0017n\u0019#b_B\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\bG\"\u0014xN\\5d\u0015\t\u00114'\u0001\u0006is\u0012\u0014x.\\3uefT!\u0001N\u0010\u0002\u000b\u0011\fW-Y;\n\u0005Yz#a\u0004%zIJ|7\t\u001b:p]&\u001cG)Y8\u0002'M$\u0018\r^5p]RC'/Z:i_2$G)Y8\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014aA5uM*\u0011QhM\u0001\bgR\fG/[8o\u0013\ty$HA\nTi\u0006$\u0018n\u001c8UQJ,7\u000f[8mI\u0012\u000bw.A\u0007is\u0012\u0014x.\\3uKJ$\u0015m\u001c\t\u0003\u0005\u0012k\u0011a\u0011\u0006\u0003wEJ!!R\"\u0003-!KHM]8m_\u001eL7-\u00197Ti\u0006$\u0018n\u001c8EC>\f!bY8oi\u0006\u001cG\u000fR1p!\tAU*D\u0001J\u0015\tQ5*A\u0004d_:$\u0018m\u0019;\u000b\u00051\u001b\u0014\u0001\u0004:fM\u0016\u0014XM\u001c;jC2\u001c\u0018B\u0001(J\u0005)\u0019uN\u001c;bGR$\u0015m\\\u0001\bG&$\u0018\u0010R1p!\t\tV+D\u0001S\u0015\tY4K\u0003\u0002U\u0017\u0006!1-\u001b;z\u0013\t1&KA\u0004DSRLH)Y8\u0002\u0017\u0011\fG/\u0019+za\u0016$\u0015m\u001c\t\u0003seK!A\u0017\u001e\u0003\u0017\u0011\u000bG/\u0019+za\u0016$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u#\u0012B\u00181bE\u000e$WMZ4\u0011\u0005}\u0003Q\"\u0001\u0007\t\u000baI\u00019A\r\t\u000b\u0015J\u00019\u0001\u0014\t\u000b1J\u00019A\u0017\t\u000b]J\u00019\u0001\u001d\t\u000b\u0001K\u00019A!\t\u000b\u0019K\u00019A$\t\u000b=K\u00019\u0001)\t\u000b]K\u00019\u0001-)\u0005%I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0019IgN[3di*\ta.A\u0003kCZ\f\u00070\u0003\u0002qW\n1\u0011J\u001c6fGR\fq!\u001a=fGV$X\r\u0006\u0002tmB\u00111\u0003^\u0005\u0003kR\u0011A!\u00168ji\")qO\u0003a\u0001q\u0006A!n\u001c2J]B,H\u000f\u0005\u0002zy6\t!P\u0003\u0002|;\u00051Am\\7bS:L!! >\u0003\u0011){'-\u00138qkRD#\u0001A@\u0011\u0007)\f\t!C\u0002\u0002\u0004-\u0014\u0011bU5oO2,Go\u001c8")
public class AlertHydro {
    private final LogUtil logUtil;
    private final AlertUtils alertUtils;
    private final HydroChronicDao hydroChronicDao;
    private final StationThresholdDao stationThresholdDao;
    private final HydrologicalStationDao hydrometerDao;
    private final ContactDao contactDao;
    private final CityDao cityDao;
    private final DataTypeDao dataTypeDao;

    public void execute(JobInput jobInput) {
        Seq emails = (Seq)jobInput.emailsAlert().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        Seq phoneNumbers = this.contactDao.getPhoneNumberByIds((Seq)jobInput.contactsIds().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Seq alertTypes = (Seq)jobInput.alertTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        long jobExecutionId = jobInput.jobExecutionId();
        this.alertUtils.logAlertWarningsPhoneNumbersEmails((Seq<String>)alertTypes, (Seq<String>)phoneNumbers, (Seq<String>)emails, jobExecutionId, "");
        Seq dataTypes = this.dataTypeDao.getDataTypesByProject("SIH");
        Seq params = (Seq)((IterableOps)jobInput.parameters().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)json -> (AlertParameter)Json$.MODULE$.parse(json).validate(AlertParameter$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString(), "");
            $this.logUtil.error(new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString(), $this.logUtil.error$default$2());
            throw new Exception(new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString());
        }, (Function1 & Serializable)v -> v));
        params.groupBy((Function1 & Serializable)p -> new StringBuilder(1).append(p.stationId()).append("_").append(p.typeId()).toString()).values().foreach((Function1 & Serializable)stationAlerts -> {
            AlertHydro.$anonfun$execute$9(this, dataTypes, jobExecutionId, jobInput, emails, phoneNumbers, alertTypes, stationAlerts);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$execute$12(Option typeId$1, DataType x$2) {
        return (int)x$2.id() == BoxesRunTime.unboxToInt((Object)typeId$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 4));
    }

    public static final /* synthetic */ boolean $anonfun$execute$19(AlertParameter a$1, Option typeId$1, StationThreshold t) {
        return t.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$4 -> (int)x$4).contains(a$1.thresholdId().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Threshold id is not defined");
        })) && t.dataType().contains((Object)typeId$1.getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Threshold typeId is not defined");
        }).toString());
    }

    public static final /* synthetic */ double $anonfun$execute$24(StationLight station$1, StationThreshold x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5.value().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(44).append("Threshold with no value found for station : ").append(station$1.code().get()).toString());
        }));
    }

    public static final /* synthetic */ boolean $anonfun$execute$29(Tuple2 x$6) {
        return x$6._2$mcZ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$execute$31(Tuple2 x$7) {
        return x$7._2$mcZ$sp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$execute$9(AlertHydro $this, Seq dataTypes$1, long jobExecutionId$1, JobInput jobInput$1, Seq emails$1, Seq phoneNumbers$1, Seq alertTypes$1, Seq stationAlerts) {
        try {
            AlertParameter firstAlert = (AlertParameter)stationAlerts.head();
            Option<Object> thresholdIdOpt = firstAlert.thresholdId();
            Option<Object> typeId = firstAlert.typeId();
            HydroStation hydro = (HydroStation)$this.hydrometerDao.get((double)((AlertParameter)stationAlerts.head()).stationId()).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(20).append("Station not found : ").append(((AlertParameter)stationAlerts.head()).stationId()).toString());
            });
            Option timeLimitMissingData = ((IterableOps)((SeqOps)stationAlerts.flatMap((Function1 & Serializable)x$1 -> x$1.timeLinitMissingData())).sorted((Ordering)Ordering.Int$.MODULE$)).headOption();
            Option dataTypeInfo = dataTypes$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlertHydro.$anonfun$execute$12(typeId, x$2)));
            int roundValue = BoxesRunTime.unboxToInt((Object)dataTypeInfo.flatMap((Function1 & Serializable)x$3 -> x$3.numberDecimal()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 3));
            None$ city = hydro.townCode().isDefined() ? $this.cityDao.get((String)hydro.townCode().get()) : None$.MODULE$;
            StationLight station = new StationLight(firstAlert.stationId(), "Hydro", hydro.code(), hydro.name(), hydro.townCode(), (Option)(city.isDefined() ? ((CityWithLinks)city.get()).name() : None$.MODULE$), StationLight$.MODULE$.$lessinit$greater$default$7(), StationLight$.MODULE$.$lessinit$greater$default$8(), StationLight$.MODULE$.$lessinit$greater$default$9());
            Option lastMeasure = $this.hydroChronicDao.getLastMeasure(station.id(), BoxesRunTime.unboxToInt((Object)typeId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 4)), (Option)new Some((Object)new DateTime()), $this.hydroChronicDao.getLastMeasure$default$4(), $this.hydroChronicDao.getLastMeasure$default$5(), $this.hydroChronicDao.getLastMeasure$default$6()).map((Function1 & Serializable)m -> {
                Some x$1 = new Some((Object)BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(roundValue, BoxesRunTime.unboxToDouble((Object)m.value().get()))));
                int x$2 = m.copy$default$1();
                int x$3 = m.copy$default$2();
                DateTime x$4 = m.copy$default$3();
                Option x$5 = m.copy$default$4();
                Option x$6 = m.copy$default$6();
                Option x$7 = m.copy$default$7();
                Option x$8 = m.copy$default$8();
                Option x$9 = m.copy$default$9();
                Option x$10 = m.copy$default$10();
                Option x$11 = m.copy$default$11();
                Option x$12 = m.copy$default$12();
                Option x$13 = m.copy$default$13();
                Option x$14 = m.copy$default$14();
                Option x$15 = m.copy$default$15();
                Option x$16 = m.copy$default$16();
                Option x$17 = m.copy$default$17();
                int x$18 = m.copy$default$18();
                return m.copy(x$2, x$3, x$4, x$5, (Option)x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
            });
            if (lastMeasure.isDefined() && (timeLimitMissingData.isEmpty() || ((HydroChronicMeasure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get()))))) {
                $this.alertUtils.closeEventNoMeasureIfExists(station, jobExecutionId$1, (Option<Object>)timeLimitMissingData);
            }
            if (lastMeasure.isDefined() && (timeLimitMissingData.isEmpty() || ((HydroChronicMeasure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get())))) && thresholdIdOpt.isDefined()) {
                Seq stationThresholds = $this.stationThresholdDao.get(Integer.toString(station.id()), StationTypeUtil$.MODULE$.HYDROMETRY());
                Seq jobThresholds = (Seq)((SeqOps)stationAlerts.map((Function1 & Serializable)a -> (StationThreshold)stationThresholds.find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)AlertHydro.$anonfun$execute$19(a, typeId, t))).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception(new StringBuilder(34).append("Threshold not found for station : ").append(station.code().get()).toString());
                }))).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)AlertHydro.$anonfun$execute$24(station, x$5)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                Seq last2Measures = (Seq)$this.alertUtils.getLast2Measures(station, BoxesRunTime.unboxToInt((Object)typeId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 4))).map((Function1 & Serializable)m -> {
                    double x$19 = MathUtil$.MODULE$.roundAt(roundValue, m.value());
                    DateTime x$20 = m.copy$default$1();
                    return m.copy(x$20, x$19);
                });
                Seq allPreviousAlerts = (Seq)((IterableOps)jobThresholds.map((Function1 & Serializable)threshold -> new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((boolean)$this.alertUtils.hasAlertEvent(station, jobInput$1.jobId(), new StringBuilder(10).append("THRESHOLD_").append((int)BoxesRunTime.unboxToDouble((Object)threshold.id().get())).toString()))))).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AlertHydro.$anonfun$execute$29(x$6)));
                Seq allNewAlerts = (Seq)((IterableOps)jobThresholds.map((Function1 & Serializable)threshold -> {
                    String string = $this.alertUtils.checkMeasure((StationThreshold)threshold, (Seq<Measure>)last2Measures);
                    String string2 = AlertTypeContants$.MODULE$.ALERT();
                    return new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0));
                })).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AlertHydro.$anonfun$execute$31(x$7)));
                Option<StationThreshold> previousAlertThreshold = $this.alertUtils.getMaxThresholdAlert((Seq<Tuple2<StationThreshold, Object>>)allPreviousAlerts);
                Option<StationThreshold> newAlertThreshold = $this.alertUtils.getMaxThresholdAlert((Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                if (allPreviousAlerts.isEmpty() && allNewAlerts.nonEmpty()) {
                    String alertThresholdName = (String)((StationThreshold)newAlertThreshold.get()).name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>");
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(21).append("New alert detected : ").append(alertThresholdName).toString(), (String)station.code().get());
                    $this.alertUtils.sendAlertFromJob(station, jobExecutionId$1, jobInput$1.jobId(), (StationThreshold)newAlertThreshold.get(), (Seq<String>)emails$1, (Seq<String>)phoneNumbers$1, (Seq<String>)alertTypes$1, new Measure(((HydroChronicMeasure)lastMeasure.get()).date(), BoxesRunTime.unboxToDouble((Object)((HydroChronicMeasure)lastMeasure.get()).value().get())), (Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                    return;
                }
                if (allPreviousAlerts.nonEmpty() && allNewAlerts.isEmpty()) {
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Situation is back to normal : no alerts detected", (String)station.code().get());
                    StationLight x$21 = station;
                    long x$22 = jobExecutionId$1;
                    long x$23 = jobInput$1.jobId();
                    StationThreshold x$24 = (StationThreshold)previousAlertThreshold.get();
                    Seq x$25 = emails$1;
                    Seq x$26 = phoneNumbers$1;
                    Seq x$27 = alertTypes$1;
                    Measure x$28 = new Measure(((HydroChronicMeasure)lastMeasure.get()).date(), BoxesRunTime.unboxToDouble((Object)((HydroChronicMeasure)lastMeasure.get()).value().get()));
                    $this.alertUtils.sendEndAlertFromJob(x$21, x$22, x$23, x$24, (Seq<String>)x$25, (Seq<String>)x$27, (Seq<String>)x$26, x$28);
                    return;
                }
                if (allPreviousAlerts.nonEmpty() && allNewAlerts.nonEmpty()) {
                    Option option = previousAlertThreshold.flatMap((Function1 & Serializable)x$8 -> x$8.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$9 -> (int)x$9));
                    Option option2 = newAlertThreshold.flatMap((Function1 & Serializable)x$10 -> x$10.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$11 -> (int)x$11));
                    if (option == null ? option2 != null : !option.equals(option2)) {
                        String alertThresholdName = (String)((StationThreshold)newAlertThreshold.get()).name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>");
                        JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("Change of alert situation : ").append(alertThresholdName).toString(), (String)station.code().get());
                        $this.alertUtils.sendChangeAlertFromJob(station, jobExecutionId$1, jobInput$1.jobId(), (StationThreshold)previousAlertThreshold.get(), (StationThreshold)newAlertThreshold.get(), (Seq<String>)emails$1, (Seq<String>)phoneNumbers$1, (Seq<String>)alertTypes$1, new Measure(((HydroChronicMeasure)lastMeasure.get()).date(), BoxesRunTime.unboxToDouble((Object)((HydroChronicMeasure)lastMeasure.get()).value().get())), (Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                        return;
                    }
                }
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Nothing has changed", (String)station.code().get());
                return;
            }
            if (lastMeasure.isDefined() && timeLimitMissingData.isDefined() && !((HydroChronicMeasure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get())))) {
                if (!$this.alertUtils.hasAlertEvent(station, jobInput$1.jobId(), new StringBuilder(16).append("MISSING_MEASURE_").append(timeLimitMissingData).toString())) {
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Sending alert for missing measures", (String)station.code().get());
                    StationLight x$29 = station;
                    long x$30 = jobExecutionId$1;
                    long x$31 = jobInput$1.jobId();
                    Seq x$32 = emails$1;
                    Seq x$33 = phoneNumbers$1;
                    Seq x$34 = alertTypes$1;
                    Option x$35 = lastMeasure.map((Function1 & Serializable)m -> new MeasureDate(m.date(), BoxesRunTime.unboxToDouble((Object)m.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
                    Option x$36 = timeLimitMissingData;
                    String x$37 = (String)dataTypeInfo.map((Function1 & Serializable)x$12 -> (String)x$12.name().getOrElse((Function0 & Serializable)() -> "Non d\u00e9fini")).get();
                    $this.alertUtils.sendAlertNoMeasureFromJob(x$29, (Option<MeasureDate>)x$35, x$30, x$31, (Seq<String>)x$32, (Seq<String>)x$33, (Seq<String>)x$34, (Option<Object>)x$36, x$37);
                    return;
                }
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Measures still missing", (String)station.code().get());
                return;
            }
            if (lastMeasure.isEmpty()) {
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), "Measures not found", (String)station.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Measures are up to date", (String)station.code().get());
            return;
        }
        catch (Throwable e) {
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), e.getMessage(), "Job Failed");
            $this.logUtil.printError(e);
            return;
        }
    }

    @Inject
    public AlertHydro(LogUtil logUtil, AlertUtils alertUtils, HydroChronicDao hydroChronicDao, StationThresholdDao stationThresholdDao, HydrologicalStationDao hydrometerDao, ContactDao contactDao, CityDao cityDao, DataTypeDao dataTypeDao) {
        this.logUtil = logUtil;
        this.alertUtils = alertUtils;
        this.hydroChronicDao = hydroChronicDao;
        this.stationThresholdDao = stationThresholdDao;
        this.hydrometerDao = hydrometerDao;
        this.contactDao = contactDao;
        this.cityDao = cityDao;
        this.dataTypeDao = dataTypeDao;
    }
}

