/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers;

import Alerting.constants.AlertTypeContants$;
import Alerting.domain.AlertParameter;
import Alerting.domain.AlertParameter$;
import Alerting.model.Measure;
import Alerting.utils.AlertUtils;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.measure.PiezometerChronicRawMeasure;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.CityWithLinks;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.model.DataType;
import fr.aquasys.daeau.station.model.MeasureDate;
import fr.aquasys.daeau.station.model.StationLight;
import fr.aquasys.daeau.station.model.StationLight$;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Singleton
@ScalaSignature(bytes="\u0006\u0005}4Aa\u0003\u0007\u0001#!A\u0001\u0004\u0001B\u0001B\u0003-\u0011\u0004\u0003\u0005&\u0001\t\u0005\t\u0015a\u0003'\u0011!a\u0003A!A!\u0002\u0017i\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b1\u0002\u001d\t\u0011}\u0002!\u0011!Q\u0001\f\u0001C\u0001b\u0011\u0001\u0003\u0002\u0003\u0006Y\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0006\u001b\"AA\u000b\u0001B\u0001B\u0003-Q\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003o\u0001\u0011\u0005qN\u0001\u0006BY\u0016\u0014H\u000fU5fu>T!!\u0004\b\u0002\u0017\r|g\u000e\u001e:pY2,'o\u001d\u0006\u0002\u001f\u0005A\u0011\t\\3si&twm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005i\u0019S\"A\u000e\u000b\u0005qi\u0012\u0001B;uS2T!AH\u0010\u0002\u0011I\f'MY5u[FT!\u0001I\u0011\u0002\u000f\u0005\fX/Y:zg*\t!%\u0001\u0002ge&\u0011Ae\u0007\u0002\b\u0019><W\u000b^5m\u0003)\tG.\u001a:u+RLGn\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S9\tQ!\u001e;jYNL!a\u000b\u0015\u0003\u0015\u0005cWM\u001d;Vi&d7/\u0001\u000bqS\u0016Tx.\\3uKJlU-Y:ve\u0016$\u0015m\u001c\t\u0003]Uj\u0011a\f\u0006\u0003aE\n1!\u001b;g\u0015\t\u00114'\u0001\u0006qS\u0016Tx.\\3uefT!\u0001N\u0010\u0002\u000b\u0011\fW-Y;\n\u0005Yz#\u0001\u0006)jKj|W.\u001a;fe6+\u0017m];sK\u0012\u000bw.A\nti\u0006$\u0018n\u001c8UQJ,7\u000f[8mI\u0012\u000bw\u000e\u0005\u0002:{5\t!H\u0003\u00021w)\u0011AhM\u0001\bgR\fG/[8o\u0013\tq$HA\nTi\u0006$\u0018n\u001c8UQJ,7\u000f[8mI\u0012\u000bw.A\bQS\u0016Tx.\\3uKJ$\u0015-Z1v!\tq\u0013)\u0003\u0002C_\ty\u0001+[3{_6,G/\u001a:EC\u0016\fW/\u0001\u0006d_:$\u0018m\u0019;E\u0003>\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u000f\r|g\u000e^1di*\u0011\u0011jM\u0001\re\u00164WM]3oi&\fGn]\u0005\u0003\u0017\u001a\u0013!bQ8oi\u0006\u001cG\u000fR1p\u0003\u001d\u0019\u0017\u000e^=EC>\u0004\"A\u0014*\u000e\u0003=S!\u0001\r)\u000b\u0005EC\u0015\u0001B2jifL!aU(\u0003\u000f\rKG/\u001f#b_\u0006YA-\u0019;b)f\u0004X\rR1p!\tId+\u0003\u0002Xu\tYA)\u0019;b)f\u0004X\rR1p\u0003\u0019a\u0014N\\5u}Q\t!\fF\u0005\\;z{\u0006-\u00192dIB\u0011A\fA\u0007\u0002\u0019!)\u0001$\u0003a\u00023!)Q%\u0003a\u0002M!)A&\u0003a\u0002[!)q'\u0003a\u0002q!)q(\u0003a\u0002\u0001\")1)\u0003a\u0002\t\")A*\u0003a\u0002\u001b\")A+\u0003a\u0002+\"\u0012\u0011B\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fa!\u001b8kK\u000e$(\"A6\u0002\u000b)\fg/\u0019=\n\u00055D'AB%oU\u0016\u001cG/A\u0004fq\u0016\u001cW\u000f^3\u0015\u0005A\u001c\bCA\nr\u0013\t\u0011HC\u0001\u0003V]&$\b\"\u0002;\u000b\u0001\u0004)\u0018\u0001\u00036pE&s\u0007/\u001e;\u0011\u0005YLX\"A<\u000b\u0005al\u0012A\u00023p[\u0006Lg.\u0003\u0002{o\nA!j\u001c2J]B,H\u000f\u000b\u0002\u0001yB\u0011q-`\u0005\u0003}\"\u0014\u0011bU5oO2,Go\u001c8")
public class AlertPiezo {
    private final LogUtil logUtil;
    private final AlertUtils alertUtils;
    private final PiezometerMeasureDao piezometerMeasureDao;
    private final StationThresholdDao stationThresholdDao;
    private final PiezometerDaeau PiezometerDaeau;
    private final ContactDao contactDAO;
    private final CityDao cityDao;
    private final DataTypeDao dataTypeDao;

    public void execute(JobInput jobInput) {
        Seq emails = (Seq)jobInput.emailsAlert().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        Seq phoneNumbers = this.contactDAO.getPhoneNumberByIds((Seq)jobInput.contactsIds().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Seq alertTypes = (Seq)jobInput.alertTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        long jobExecutionId = jobInput.jobExecutionId();
        this.alertUtils.logAlertWarningsPhoneNumbersEmails((Seq<String>)alertTypes, (Seq<String>)phoneNumbers, (Seq<String>)emails, jobExecutionId, "");
        Seq dataTypes = this.dataTypeDao.getDataTypesByProject("SIES");
        Seq params = (Seq)((IterableOps)jobInput.parameters().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)json -> (AlertParameter)Json$.MODULE$.parse(json).validate(AlertParameter$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString(), "");
            $this.logUtil.error(new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString(), $this.logUtil.error$default$2());
            throw new Exception(new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString());
        }, (Function1 & Serializable)v -> v));
        params.groupBy((Function1 & Serializable)p -> new StringBuilder(1).append(p.stationId()).append("_").append(p.typeId()).toString()).values().foreach((Function1 & Serializable)stationAlerts -> {
            AlertPiezo.$anonfun$execute$9(this, dataTypes, jobExecutionId, jobInput, emails, phoneNumbers, alertTypes, stationAlerts);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$execute$11(Option typeId$1, DataType x$2) {
        return (int)x$2.id() == BoxesRunTime.unboxToInt((Object)typeId$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
    }

    public static final /* synthetic */ boolean $anonfun$execute$19(AlertParameter a$1, Option typeId$1, StationThreshold t) {
        return t.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$4 -> (int)x$4).contains(a$1.thresholdId().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Threshold id is not defined");
        })) && t.dataType().contains((Object)typeId$1.getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Threshold typeId is not defined");
        }).toString());
    }

    public static final /* synthetic */ double $anonfun$execute$24(StationLight station$1, StationThreshold x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5.value().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(44).append("Threshold with no value found for station : ").append(station$1.code().get()).toString());
        }));
    }

    public static final /* synthetic */ boolean $anonfun$execute$29(Tuple2 x$6) {
        return x$6._2$mcZ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$execute$31(Tuple2 x$7) {
        return x$7._2$mcZ$sp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$execute$9(AlertPiezo $this, Seq dataTypes$1, long jobExecutionId$1, JobInput jobInput$1, Seq emails$1, Seq phoneNumbers$1, Seq alertTypes$1, Seq stationAlerts) {
        try {
            AlertParameter firstAlert = (AlertParameter)stationAlerts.head();
            Option<Object> thresholdIdOpt = firstAlert.thresholdId();
            Option<Object> typeId = firstAlert.typeId();
            Option timeLimitMissingData = ((IterableOps)((SeqOps)stationAlerts.flatMap((Function1 & Serializable)x$1 -> x$1.timeLinitMissingData())).sorted((Ordering)Ordering.Int$.MODULE$)).headOption();
            Option dataTypeInfo = dataTypes$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlertPiezo.$anonfun$execute$11(typeId, x$2)));
            int roundValue = BoxesRunTime.unboxToInt((Object)dataTypeInfo.flatMap((Function1 & Serializable)x$3 -> x$3.numberDecimal()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 3));
            Piezometer piezo = (Piezometer)$this.PiezometerDaeau.find(((AlertParameter)stationAlerts.head()).stationId()).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(20).append("Station not found : ").append(((AlertParameter)stationAlerts.head()).stationId()).toString());
            });
            None$ city = piezo.townCode().isDefined() ? $this.cityDao.get((String)piezo.townCode().get()) : None$.MODULE$;
            StationLight station = new StationLight(firstAlert.stationId(), "Piezo", (Option)new Some((Object)piezo.code()), piezo.name(), piezo.townCode(), (Option)(city.isDefined() ? ((CityWithLinks)city.get()).name() : None$.MODULE$), StationLight$.MODULE$.$lessinit$greater$default$7(), StationLight$.MODULE$.$lessinit$greater$default$8(), StationLight$.MODULE$.$lessinit$greater$default$9());
            Option lastMeasure = $this.piezometerMeasureDao.getLastMeasure(station.id(), BoxesRunTime.unboxToInt((Object)typeId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), (Option)new Some((Object)new DateTime()), $this.piezometerMeasureDao.getLastMeasure$default$4()).map((Function1 & Serializable)m -> {
                Some x$1 = new Some((Object)BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(roundValue, BoxesRunTime.unboxToDouble((Object)m.value().get()))));
                int x$2 = m.copy$default$1();
                int x$3 = m.copy$default$2();
                DateTime x$4 = m.copy$default$3();
                Option x$5 = m.copy$default$4();
                Option x$6 = m.copy$default$5();
                Option x$7 = m.copy$default$6();
                Option x$8 = m.copy$default$8();
                Option x$9 = m.copy$default$9();
                Option x$10 = m.copy$default$10();
                Option x$11 = m.copy$default$11();
                Option x$12 = m.copy$default$12();
                Option x$13 = m.copy$default$13();
                Option x$14 = m.copy$default$14();
                Option x$15 = m.copy$default$15();
                Option x$16 = m.copy$default$16();
                Option x$17 = m.copy$default$17();
                Option x$18 = m.copy$default$18();
                Option x$19 = m.copy$default$19();
                Option x$20 = m.copy$default$20();
                Option x$21 = m.copy$default$21();
                Option x$22 = m.copy$default$22();
                int x$23 = m.copy$default$23();
                return m.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option)x$1, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23);
            });
            if (lastMeasure.isDefined() && (timeLimitMissingData.isEmpty() || ((PiezometerChronicRawMeasure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get()))))) {
                $this.alertUtils.closeEventNoMeasureIfExists(station, jobExecutionId$1, (Option<Object>)timeLimitMissingData);
            }
            if (lastMeasure.isDefined() && (timeLimitMissingData.isEmpty() || ((PiezometerChronicRawMeasure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get())))) && thresholdIdOpt.isDefined()) {
                Seq stationThresholds = $this.stationThresholdDao.get((String)station.code().get(), StationTypeUtil$.MODULE$.PIEZOMETRY());
                Seq jobThresholds = (Seq)((SeqOps)stationAlerts.map((Function1 & Serializable)a -> (StationThreshold)stationThresholds.find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)AlertPiezo.$anonfun$execute$19(a, typeId, t))).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception(new StringBuilder(34).append("Threshold not found for station : ").append(station.code().get()).toString());
                }))).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)AlertPiezo.$anonfun$execute$24(station, x$5)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                Seq last2Measures = (Seq)$this.alertUtils.getLast2Measures(station, BoxesRunTime.unboxToInt((Object)typeId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 4))).map((Function1 & Serializable)m -> {
                    double x$24 = MathUtil$.MODULE$.roundAt(roundValue, m.value());
                    DateTime x$25 = m.copy$default$1();
                    return m.copy(x$25, x$24);
                });
                Seq allPreviousAlerts = (Seq)((IterableOps)jobThresholds.map((Function1 & Serializable)threshold -> new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((boolean)$this.alertUtils.hasAlertEvent(station, jobInput$1.jobId(), new StringBuilder(10).append("THRESHOLD_").append((int)BoxesRunTime.unboxToDouble((Object)threshold.id().get())).toString()))))).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AlertPiezo.$anonfun$execute$29(x$6)));
                Seq allNewAlerts = (Seq)((IterableOps)jobThresholds.map((Function1 & Serializable)threshold -> {
                    String string = $this.alertUtils.checkMeasure((StationThreshold)threshold, (Seq<Measure>)last2Measures);
                    String string2 = AlertTypeContants$.MODULE$.ALERT();
                    return new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0));
                })).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AlertPiezo.$anonfun$execute$31(x$7)));
                Option<StationThreshold> previousAlertThreshold = $this.alertUtils.getMaxThresholdAlert((Seq<Tuple2<StationThreshold, Object>>)allPreviousAlerts);
                Option<StationThreshold> newAlertThreshold = $this.alertUtils.getMaxThresholdAlert((Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                if (allPreviousAlerts.isEmpty() && allNewAlerts.nonEmpty()) {
                    String alertThresholdName = (String)((StationThreshold)newAlertThreshold.get()).name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>");
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(21).append("New alert detected : ").append(alertThresholdName).toString(), (String)station.code().get());
                    $this.alertUtils.sendAlertFromJob(station, jobExecutionId$1, jobInput$1.jobId(), (StationThreshold)newAlertThreshold.get(), (Seq<String>)emails$1, (Seq<String>)phoneNumbers$1, (Seq<String>)alertTypes$1, new Measure(((PiezometerChronicRawMeasure)lastMeasure.get()).date(), BoxesRunTime.unboxToDouble((Object)((PiezometerChronicRawMeasure)lastMeasure.get()).NGF().get())), (Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                    return;
                }
                if (allPreviousAlerts.nonEmpty() && allNewAlerts.isEmpty()) {
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Situation is back to normal : no alerts detected", (String)station.code().get());
                    StationLight x$26 = station;
                    long x$27 = jobExecutionId$1;
                    long x$28 = jobInput$1.jobId();
                    StationThreshold x$29 = (StationThreshold)previousAlertThreshold.get();
                    Seq x$30 = emails$1;
                    Seq x$31 = phoneNumbers$1;
                    Seq x$32 = alertTypes$1;
                    Measure x$33 = new Measure(((PiezometerChronicRawMeasure)lastMeasure.get()).date(), BoxesRunTime.unboxToDouble((Object)((PiezometerChronicRawMeasure)lastMeasure.get()).NGF().get()));
                    $this.alertUtils.sendEndAlertFromJob(x$26, x$27, x$28, x$29, (Seq<String>)x$30, (Seq<String>)x$32, (Seq<String>)x$31, x$33);
                    return;
                }
                if (allPreviousAlerts.nonEmpty() && allNewAlerts.nonEmpty()) {
                    Option option = previousAlertThreshold.flatMap((Function1 & Serializable)x$8 -> x$8.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$9 -> (int)x$9));
                    Option option2 = newAlertThreshold.flatMap((Function1 & Serializable)x$10 -> x$10.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$11 -> (int)x$11));
                    if (option == null ? option2 != null : !option.equals(option2)) {
                        String alertThresholdName = (String)((StationThreshold)newAlertThreshold.get()).name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>");
                        JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("Change of alert situation : ").append(alertThresholdName).toString(), (String)station.code().get());
                        $this.alertUtils.sendChangeAlertFromJob(station, jobExecutionId$1, jobInput$1.jobId(), (StationThreshold)previousAlertThreshold.get(), (StationThreshold)newAlertThreshold.get(), (Seq<String>)emails$1, (Seq<String>)phoneNumbers$1, (Seq<String>)alertTypes$1, new Measure(((PiezometerChronicRawMeasure)lastMeasure.get()).date(), BoxesRunTime.unboxToDouble((Object)((PiezometerChronicRawMeasure)lastMeasure.get()).NGF().get())), (Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                        return;
                    }
                }
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Nothing has changed", (String)station.code().get());
                return;
            }
            if (lastMeasure.isDefined() && timeLimitMissingData.isDefined() && !((PiezometerChronicRawMeasure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get())))) {
                if (!$this.alertUtils.hasAlertEvent(station, jobInput$1.jobId(), new StringBuilder(16).append("MISSING_MEASURE_").append(timeLimitMissingData).toString())) {
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Sending alert for missing measures", (String)station.code().get());
                    StationLight x$34 = station;
                    long x$35 = jobExecutionId$1;
                    long x$36 = jobInput$1.jobId();
                    Seq x$37 = emails$1;
                    Seq x$38 = phoneNumbers$1;
                    Seq x$39 = alertTypes$1;
                    Option x$40 = lastMeasure.map((Function1 & Serializable)m -> new MeasureDate(m.date(), BoxesRunTime.unboxToDouble((Object)m.NGF().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
                    Option x$41 = timeLimitMissingData;
                    String x$42 = (String)dataTypeInfo.map((Function1 & Serializable)x$12 -> (String)x$12.name().getOrElse((Function0 & Serializable)() -> "Non d\u00e9fini")).get();
                    $this.alertUtils.sendAlertNoMeasureFromJob(x$34, (Option<MeasureDate>)x$40, x$35, x$36, (Seq<String>)x$37, (Seq<String>)x$38, (Seq<String>)x$39, (Option<Object>)x$41, x$42);
                    return;
                }
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Measures still missing", (String)station.code().get());
                return;
            }
            if (lastMeasure.isEmpty()) {
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), "Measures not found", (String)station.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Measures are up to date", (String)station.code().get());
            return;
        }
        catch (Throwable e) {
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), e.getMessage(), "Job Failed");
            $this.logUtil.printError(e);
            return;
        }
    }

    @Inject
    public AlertPiezo(LogUtil logUtil, AlertUtils alertUtils, PiezometerMeasureDao piezometerMeasureDao, StationThresholdDao stationThresholdDao, PiezometerDaeau PiezometerDaeau2, ContactDao contactDAO, CityDao cityDao, DataTypeDao dataTypeDao) {
        this.logUtil = logUtil;
        this.alertUtils = alertUtils;
        this.piezometerMeasureDao = piezometerMeasureDao;
        this.stationThresholdDao = stationThresholdDao;
        this.PiezometerDaeau = PiezometerDaeau2;
        this.contactDAO = contactDAO;
        this.cityDao = cityDao;
        this.dataTypeDao = dataTypeDao;
    }
}

