/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers;

import Alerting.constants.AlertTypeContants$;
import Alerting.domain.AlertParameter;
import Alerting.domain.AlertParameter$;
import Alerting.domain.AlertPluvioOptions;
import Alerting.domain.AlertPluvioOptions$;
import Alerting.model.Measure;
import Alerting.utils.AlertUtils;
import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.pluviometry.itf.PluvioChronicDao;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.CityWithLinks;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.model.DataType;
import fr.aquasys.daeau.station.model.MeasureDate;
import fr.aquasys.daeau.station.model.StationLight;
import fr.aquasys.daeau.station.model.StationLight$;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import play.api.db.Database;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\b\u0011\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006Y!\b\u0005\tS\u0001\u0011\t\u0011)A\u0006U!A\u0001\u0007\u0001B\u0001B\u0003-\u0011\u0007\u0003\u0005<\u0001\t\u0005\t\u0015a\u0003=\u0011!\u0019\u0005A!A!\u0002\u0017!\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b1B'\t\u0011Q\u0003!\u0011!Q\u0001\fUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006Y!\u0017\u0005\tG\u0002\u0011\t\u0011)A\u0006I\")q\r\u0001C\u0001Q\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001\"CA3\u0001E\u0005I\u0011AA4\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007\u00131\"\u00117feR\u0004F.\u001e<j_*\u0011\u0011CE\u0001\fG>tGO]8mY\u0016\u00148OC\u0001\u0014\u0003!\tE.\u001a:uS:<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\nA!\u001e;jY*\u0011!eI\u0001\te\u0006\u0014'-\u001b;nc*\u0011A%J\u0001\bCF,\u0018m]=t\u0015\u00051\u0013A\u00014s\u0013\tAsDA\u0004M_\u001e,F/\u001b7\u0002\u0015\u0005dWM\u001d;Vi&d7\u000f\u0005\u0002,]5\tAF\u0003\u0002.%\u0005)Q\u000f^5mg&\u0011q\u0006\f\u0002\u000b\u00032,'\u000f^+uS2\u001c\u0018!\u00069mkZLw.\\3uKJlU-Y:ve\u0016$\u0015m\u001c\t\u0003eej\u0011a\r\u0006\u0003iU\n1!\u001b;g\u0015\t1t'A\u0006qYV4\u0018n\\7fiJL(B\u0001\u001d$\u0003\u0015!\u0017-Z1v\u0013\tQ4G\u0001\tQYV4\u0018n\\\"ie>t\u0017n\u0019#b_\u0006\u00192\u000f^1uS>tG\u000b\u001b:fg\"|G\u000e\u001a#b_B\u0011Q(Q\u0007\u0002})\u0011Ag\u0010\u0006\u0003\u0001^\nqa\u001d;bi&|g.\u0003\u0002C}\t\u00192\u000b^1uS>tG\u000b\u001b:fg\"|G\u000e\u001a#b_\u0006Q1m\u001c8uC\u000e$H)Q(\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015aB2p]R\f7\r\u001e\u0006\u0003\u0013^\nAB]3gKJ,g\u000e^5bYNL!a\u0013$\u0003\u0015\r{g\u000e^1di\u0012\u000bw.A\u0004dSRLH)Y8\u0011\u00059\u0013V\"A(\u000b\u0005Q\u0002&BA)I\u0003\u0011\u0019\u0017\u000e^=\n\u0005M{%aB\"jif$\u0015m\\\u0001\u000fa2,h/[8nKR,'\u000fR1p!\t\u0011d+\u0003\u0002Xg\tq\u0001\u000b\\;wS>lW\r^3s\t\u0006|\u0017\u0001\u00033bi\u0006\u0014\u0017m]3\u0011\u0005i\u000bW\"A.\u000b\u0005qk\u0016A\u00013c\u0015\tqv,A\u0002ba&T\u0011\u0001Y\u0001\u0005a2\f\u00170\u0003\u0002c7\nAA)\u0019;bE\u0006\u001cX-A\u0006eCR\fG+\u001f9f\t\u0006|\u0007CA\u001ff\u0013\t1gHA\u0006ECR\fG+\u001f9f\t\u0006|\u0017A\u0002\u001fj]&$h\bF\u0001j))QG.\u001c8paF\u00148\u000f\u001e\t\u0003W\u0002i\u0011\u0001\u0005\u0005\u00069)\u0001\u001d!\b\u0005\u0006S)\u0001\u001dA\u000b\u0005\u0006a)\u0001\u001d!\r\u0005\u0006w)\u0001\u001d\u0001\u0010\u0005\u0006\u0007*\u0001\u001d\u0001\u0012\u0005\u0006\u0019*\u0001\u001d!\u0014\u0005\u0006)*\u0001\u001d!\u0016\u0005\u00061*\u0001\u001d!\u0017\u0005\u0006G*\u0001\u001d\u0001\u001a\u0015\u0003\u0015Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\r%t'.Z2u\u0015\u0005Y\u0018!\u00026bm\u0006D\u0018BA?y\u0005\u0019IeN[3di\u00069Q\r_3dkR,G\u0003BA\u0001\u0003\u000f\u00012aFA\u0002\u0013\r\t)\u0001\u0007\u0002\u0005+:LG\u000fC\u0004\u0002\n-\u0001\r!a\u0003\u0002\u0011)|'-\u00138qkR\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#\t\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002\u0016\u0005=!\u0001\u0003&pE&s\u0007/\u001e;\u0002\u0015\u001d,GOR5mi\u0016\u00148/\u0006\u0003\u0002\u001c\u0005\rBCCA\u000f\u0003\u0013\ni%a\u0016\u0002\\Q!\u0011qDA\u001b!\u0011\t\t#a\t\r\u0001\u00119\u0011Q\u0005\u0007C\u0002\u0005\u001d\"!A!\u0012\t\u0005%\u0012q\u0006\t\u0004/\u0005-\u0012bAA\u00171\t9aj\u001c;iS:<\u0007cA\f\u00022%\u0019\u00111\u0007\r\u0003\u0007\u0005s\u0017\u0010C\u0004\u000281\u0001\u001d!!\u000f\u0002\u0007I$7\u000f\u0005\u0004\u0002<\u0005\u0015\u0013qD\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!!n]8o\u0015\r\t\u0019%X\u0001\u0005Y&\u00147/\u0003\u0003\u0002H\u0005u\"!\u0002*fC\u0012\u001c\bbBA&\u0019\u0001\u0007\u00111B\u0001\u000eU>\u0014\u0007+\u0019:b[\u0016$XM]:\t\u000f\u0005=C\u00021\u0001\u0002R\u0005q!n\u001c2Fq\u0016\u001cW\u000f^5p]&#\u0007cA\f\u0002T%\u0019\u0011Q\u000b\r\u0003\t1{gn\u001a\u0005\b\u00033b\u0001\u0019AA\u0010\u0003\u001d!WMZ1vYRD\u0011\"!\u0018\r!\u0003\u0005\r!a\u0018\u0002\u0017%\u001cx\n\u001d;j_:t\u0017\r\u001c\t\u0004/\u0005\u0005\u0014bAA21\t9!i\\8mK\u0006t\u0017\u0001F4fi\u001aKG\u000e^3sg\u0012\"WMZ1vYR$C'\u0006\u0003\u0002j\u0005}TCAA6U\u0011\ty&!\u001c,\u0005\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001f\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\n\u0019HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!!\n\u000e\u0005\u0004\t9#\u0001\u000bhKRd\u0015m\u001d;NK\u0006\u001cXO]3QYV4\u0018n\u001c\u000b\r\u0003\u000b\u000b9*a)\u00020\u0006M\u0016q\u001a\t\u0006/\u0005\u001d\u00151R\u0005\u0004\u0003\u0013C\"AB(qi&|g\u000e\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\tJE\u0001\u0006[>$W\r\\\u0005\u0005\u0003+\u000byIA\u0004NK\u0006\u001cXO]3\t\r\u0001s\u0001\u0019AAM!\u0011\tY*a(\u000e\u0005\u0005u%bAAI\u007f%!\u0011\u0011UAO\u00051\u0019F/\u0019;j_:d\u0015n\u001a5u\u0011\u001d\t)K\u0004a\u0001\u0003O\u000ba\u0001^=qK&#\u0007#B\f\u0002\b\u0006%\u0006cA\f\u0002,&\u0019\u0011Q\u0016\r\u0003\u0007%sG\u000fC\u0004\u00022:\u0001\r!!+\u0002\u0015I|WO\u001c3WC2,X\rC\u0004\u00026:\u0001\r!a.\u0002\u001f5|G-Z\"v[Vd\u0007\u000b\\;wS>\u0004RaFAD\u0003s\u0003B!a/\u0002J:!\u0011QXAc!\r\ty\fG\u0007\u0003\u0003\u0003T1!a1\u0015\u0003\u0019a$o\\8u}%\u0019\u0011q\u0019\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tY-!4\u0003\rM#(/\u001b8h\u0015\r\t9\r\u0007\u0005\b\u0003#t\u0001\u0019AAT\u0003Eq'\rS8veN\u001cU/\\;m!\u0016\u00148o\u001c\u0015\u0004\u0001\u0005U\u0007cA<\u0002X&\u0019\u0011\u0011\u001c=\u0003\u0013MKgn\u001a7fi>t\u0007")
public class AlertPluvio {
    private final LogUtil logUtil;
    private final AlertUtils alertUtils;
    private final PluvioChronicDao pluviometerMeasureDao;
    private final StationThresholdDao stationThresholdDao;
    private final ContactDao contactDAO;
    private final CityDao cityDao;
    private final PluviometerDao pluviometerDao;
    private final Database database;
    private final DataTypeDao dataTypeDao;

    public void execute(JobInput jobInput) {
        Seq emails = (Seq)jobInput.emailsAlert().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        Seq phoneNumbers = this.contactDAO.getPhoneNumberByIds((Seq)jobInput.contactsIds().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Seq alertTypes = (Seq)jobInput.alertTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        long jobExecutionId = jobInput.jobExecutionId();
        AlertPluvioOptions filters = this.getFilters(jobInput, jobExecutionId, (Object)new AlertPluvioOptions(AlertPluvioOptions$.MODULE$.$lessinit$greater$default$1(), AlertPluvioOptions$.MODULE$.$lessinit$greater$default$2()), true, (Reads)AlertPluvioOptions$.MODULE$.format());
        this.alertUtils.logAlertWarningsPhoneNumbersEmails((Seq<String>)alertTypes, (Seq<String>)phoneNumbers, (Seq<String>)emails, jobExecutionId, "");
        Seq dataTypes = this.dataTypeDao.getDataTypesByProject("SIP");
        Seq params = (Seq)((IterableOps)jobInput.parameters().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)json -> (AlertParameter)Json$.MODULE$.parse(json).validate(AlertParameter$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString(), "");
            $this.logUtil.error(new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString(), $this.logUtil.error$default$2());
            throw new Exception(new StringBuilder(31).append("Can't read table line n\u00b0 idx : ").append(error).toString());
        }, (Function1 & Serializable)v -> v));
        params.groupBy((Function1 & Serializable)p -> new StringBuilder(1).append(p.stationId()).append("_").append(p.typeId()).toString()).values().foreach((Function1 & Serializable)stationAlerts -> {
            AlertPluvio.$anonfun$execute$9(this, dataTypes, filters, jobExecutionId, jobInput, emails, phoneNumbers, alertTypes, stationAlerts);
            return BoxedUnit.UNIT;
        });
    }

    public <A> A getFilters(JobInput jobParameters, long jobExecutionId, A a, boolean isOptionnal, Reads<A> rds) {
        if (jobParameters.filters().isEmpty() || ((SeqOps)jobParameters.filters().get()).isEmpty()) {
            if (!isOptionnal) {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error validate Json : filters", "");
                throw new Exception("Filters are empty");
            }
            return a;
        }
        return (A)Json$.MODULE$.parse((String)((IterableOps)jobParameters.filters().get()).head()).validate(rds).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(31).append("Error validate Json : filters, ").append(error).toString(), "");
            throw new Exception("Unable to parse filters");
        }, (Function1 & Serializable)value -> value);
    }

    public <A> boolean getFilters$default$4() {
        return false;
    }

    public Option<Measure> getLastMeasurePluvio(StationLight station, Option<Object> typeId, int roundValue, Option<String> modeCumulPluvio, Option<Object> nbHoursCumulPerso) {
        Option lastMeasure = this.pluviometerMeasureDao.getLastMeasure(station.id(), BoxesRunTime.unboxToInt((Object)typeId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)), (Option)new Some((Object)new DateTime()), this.pluviometerMeasureDao.getLastMeasure$default$4()).map((Function1 & Serializable)m -> new Measure(m.date(), MathUtil$.MODULE$.roundAt(roundValue, BoxesRunTime.unboxToDouble((Object)m.value().get()))));
        if (typeId.contains((Object)BoxesRunTime.boxToInteger((int)1)) && lastMeasure.isDefined()) {
            return (Option)this.database.withConnection((Function1 & Serializable)c -> {
                Measure measure;
                block4: {
                    String string = (String)modeCumulPluvio.getOrElse((Function0 & Serializable)() -> {
                        throw new Exception("Le mode de cumul pluvio n'est pas d\u00e9fini");
                    });
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1139119256: {
                            if (!"SUM_DAY".equals(string)) break;
                            String dateRef = DateUtil$.MODULE$.getPostgreDate(((Measure)lastMeasure.get()).date().withTimeAtStartOfDay());
                            ParameterValue[] parameterValueArray = new ParameterValue[2];
                            ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
                            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                            ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)dateRef, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
                            double valueMeasure = BoxesRunTime.unboxToDouble((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select sum(valeurmesure) from chroniques_pluvio where codepluviometre = ", " and typeid = 1 and valeurmesure notnull and datemesure <= now() and datemesure >= #", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToDouble()).single(), c));
                            measure = new Measure(((Measure)lastMeasure.get()).date(), valueMeasure);
                            break block4;
                        }
                        case 534252805: {
                            if (!"SUM_PERSO".equals(string)) break;
                            String dateRef = DateUtil$.MODULE$.getPostgreDate(((Measure)lastMeasure.get()).date().minusHours(BoxesRunTime.unboxToInt((Object)nbHoursCumulPerso.getOrElse((Function0 & Serializable)() -> {
                                throw new Exception("");
                            }))));
                            ParameterValue[] parameterValueArray = new ParameterValue[2];
                            ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
                            Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
                            ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)dateRef, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
                            double valueMeasure = BoxesRunTime.unboxToDouble((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select sum(valeurmesure) from chroniques_pluvio where codepluviometre = ", " and typeid = 1 and valeurmesure notnull and datemesure <= now() and datemesure >= #", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToDouble()).single(), c));
                            measure = new Measure(((Measure)lastMeasure.get()).date(), valueMeasure);
                            break block4;
                        }
                    }
                    measure = new Measure(((Measure)lastMeasure.get()).date(), ((Measure)lastMeasure.get()).value());
                }
                return new Some((Object)measure);
            });
        }
        return lastMeasure;
    }

    public static final /* synthetic */ boolean $anonfun$execute$11(Option typeId$1, DataType x$2) {
        return (int)x$2.id() == BoxesRunTime.unboxToInt((Object)typeId$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
    }

    public static final /* synthetic */ boolean $anonfun$execute$19(AlertParameter a$1, Option typeId$1, StationThreshold t) {
        return t.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$4 -> (int)x$4).contains(a$1.thresholdId().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Threshold id is not defined");
        })) && t.dataType().contains((Object)typeId$1.getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Threshold typeId is not defined");
        }).toString());
    }

    public static final /* synthetic */ double $anonfun$execute$24(StationLight station$1, StationThreshold x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5.value().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(44).append("Threshold with no value found for station : ").append(station$1.code().get()).toString());
        }));
    }

    public static final /* synthetic */ boolean $anonfun$execute$29(Tuple2 x$6) {
        return x$6._2$mcZ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$execute$31(Tuple2 x$7) {
        return x$7._2$mcZ$sp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$execute$9(AlertPluvio $this, Seq dataTypes$1, AlertPluvioOptions filters$1, long jobExecutionId$1, JobInput jobInput$1, Seq emails$1, Seq phoneNumbers$1, Seq alertTypes$1, Seq stationAlerts) {
        try {
            AlertParameter firstAlert = (AlertParameter)stationAlerts.head();
            Option<Object> thresholdIdOpt = firstAlert.thresholdId();
            Option<Object> typeId = firstAlert.typeId();
            Option timeLimitMissingData = ((IterableOps)((SeqOps)stationAlerts.flatMap((Function1 & Serializable)x$1 -> x$1.timeLinitMissingData())).sorted((Ordering)Ordering.Int$.MODULE$)).headOption();
            Option dataTypeInfo = dataTypes$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlertPluvio.$anonfun$execute$11(typeId, x$2)));
            Pluviometer pluvio = (Pluviometer)$this.pluviometerDao.get(((AlertParameter)stationAlerts.head()).stationId()).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(20).append("Station not found : ").append(((AlertParameter)stationAlerts.head()).stationId()).toString());
            });
            int roundValue = BoxesRunTime.unboxToInt((Object)dataTypeInfo.flatMap((Function1 & Serializable)x$3 -> x$3.numberDecimal()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 3));
            None$ city = pluvio.townCode().isDefined() ? $this.cityDao.get((String)pluvio.townCode().get()) : None$.MODULE$;
            StationLight station = new StationLight(firstAlert.stationId(), "Pluvio", pluvio.code(), pluvio.name(), pluvio.townCode(), (Option)(city.isDefined() ? ((CityWithLinks)city.get()).name() : None$.MODULE$), StationLight$.MODULE$.$lessinit$greater$default$7(), StationLight$.MODULE$.$lessinit$greater$default$8(), StationLight$.MODULE$.$lessinit$greater$default$9());
            Option<Measure> lastMeasure = $this.getLastMeasurePluvio(station, typeId, roundValue, (Option<String>)filters$1.modeCumulPluvio().orElse((Function0 & Serializable)() -> new Some((Object)"SUM_PERSO")), (Option<Object>)filters$1.nbHoursCumulPerso().orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)24))));
            if (lastMeasure.isDefined() && (timeLimitMissingData.isEmpty() || ((Measure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get()))))) {
                $this.alertUtils.closeEventNoMeasureIfExists(station, jobExecutionId$1, (Option<Object>)timeLimitMissingData);
            }
            if (lastMeasure.isDefined() && (timeLimitMissingData.isEmpty() || ((Measure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get())))) && thresholdIdOpt.isDefined()) {
                Seq stationThresholds = $this.stationThresholdDao.get((String)station.code().get(), StationTypeUtil$.MODULE$.PLUVIOMETRY());
                Seq jobThresholds = (Seq)((SeqOps)stationAlerts.map((Function1 & Serializable)a -> (StationThreshold)stationThresholds.find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)AlertPluvio.$anonfun$execute$19(a, typeId, t))).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception(new StringBuilder(34).append("Threshold not found for station : ").append(station.code().get()).toString());
                }))).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)AlertPluvio.$anonfun$execute$24(station, x$5)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                Seq last2Measures = (Seq)$this.alertUtils.getLast2Measures(station, BoxesRunTime.unboxToInt((Object)typeId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 4))).map((Function1 & Serializable)m -> {
                    double x$1 = MathUtil$.MODULE$.roundAt(roundValue, m.value());
                    DateTime x$2 = m.copy$default$1();
                    return m.copy(x$2, x$1);
                });
                Seq allPreviousAlerts = (Seq)((IterableOps)jobThresholds.map((Function1 & Serializable)threshold -> new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((boolean)$this.alertUtils.hasAlertEvent(station, jobInput$1.jobId(), new StringBuilder(10).append("THRESHOLD_").append((int)BoxesRunTime.unboxToDouble((Object)threshold.id().get())).toString()))))).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AlertPluvio.$anonfun$execute$29(x$6)));
                Seq allNewAlerts = (Seq)((IterableOps)jobThresholds.map((Function1 & Serializable)threshold -> {
                    if (typeId.contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                        String string = $this.alertUtils.checkMeasure((StationThreshold)threshold, (Seq<Measure>)new .colon.colon((Object)((Measure)lastMeasure.get()), (List)new .colon.colon((Object)((Measure)lastMeasure.get()), (List)Nil$.MODULE$)));
                        String string2 = AlertTypeContants$.MODULE$.ALERT();
                        return new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0));
                    }
                    String string = $this.alertUtils.checkMeasure((StationThreshold)threshold, (Seq<Measure>)last2Measures);
                    String string3 = AlertTypeContants$.MODULE$.ALERT();
                    return new Tuple2(threshold, (Object)BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string3) : string3 != null) ? 1 : 0) != 0));
                })).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AlertPluvio.$anonfun$execute$31(x$7)));
                Option<StationThreshold> previousAlertThreshold = $this.alertUtils.getMaxThresholdAlert((Seq<Tuple2<StationThreshold, Object>>)allPreviousAlerts);
                Option<StationThreshold> newAlertThreshold = $this.alertUtils.getMaxThresholdAlert((Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                if (allPreviousAlerts.isEmpty() && allNewAlerts.nonEmpty()) {
                    String alertThresholdName = (String)((StationThreshold)newAlertThreshold.get()).name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>");
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(21).append("New alert detected : ").append(alertThresholdName).toString(), (String)station.code().get());
                    $this.alertUtils.sendAlertFromJob(station, jobExecutionId$1, jobInput$1.jobId(), (StationThreshold)newAlertThreshold.get(), (Seq<String>)emails$1, (Seq<String>)phoneNumbers$1, (Seq<String>)alertTypes$1, new Measure(((Measure)lastMeasure.get()).date(), ((Measure)lastMeasure.get()).value()), (Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                    return;
                }
                if (allPreviousAlerts.nonEmpty() && allNewAlerts.isEmpty()) {
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Situation is back to normal : no alerts detected", (String)station.code().get());
                    StationLight x$32 = station;
                    long x$4 = jobExecutionId$1;
                    long x$52 = jobInput$1.jobId();
                    StationThreshold x$62 = (StationThreshold)previousAlertThreshold.get();
                    Seq x$72 = emails$1;
                    Seq x$82 = phoneNumbers$1;
                    Seq x$9 = alertTypes$1;
                    Measure x$102 = new Measure(((Measure)lastMeasure.get()).date(), ((Measure)lastMeasure.get()).value());
                    $this.alertUtils.sendEndAlertFromJob(x$32, x$4, x$52, x$62, (Seq<String>)x$72, (Seq<String>)x$9, (Seq<String>)x$82, x$102);
                    return;
                }
                if (allPreviousAlerts.nonEmpty() && allNewAlerts.nonEmpty()) {
                    Option option = previousAlertThreshold.flatMap((Function1 & Serializable)x$8 -> x$8.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$9 -> (int)x$9));
                    Option option2 = newAlertThreshold.flatMap((Function1 & Serializable)x$10 -> x$10.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$11 -> (int)x$11));
                    if (option == null ? option2 != null : !option.equals(option2)) {
                        String alertThresholdName = (String)((StationThreshold)newAlertThreshold.get()).name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>");
                        JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("Change of alert situation : ").append(alertThresholdName).toString(), (String)station.code().get());
                        $this.alertUtils.sendChangeAlertFromJob(station, jobExecutionId$1, jobInput$1.jobId(), (StationThreshold)previousAlertThreshold.get(), (StationThreshold)newAlertThreshold.get(), (Seq<String>)emails$1, (Seq<String>)phoneNumbers$1, (Seq<String>)alertTypes$1, new Measure(((Measure)lastMeasure.get()).date(), ((Measure)lastMeasure.get()).value()), (Seq<Tuple2<StationThreshold, Object>>)allNewAlerts);
                        return;
                    }
                }
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Nothing has changed", (String)station.code().get());
                return;
            }
            if (lastMeasure.isDefined() && timeLimitMissingData.isDefined() && !((Measure)lastMeasure.get()).date().isAfter((ReadableInstant)DateTime.now().minusHours(BoxesRunTime.unboxToInt((Object)timeLimitMissingData.get())))) {
                if (!$this.alertUtils.hasAlertEvent(station, jobInput$1.jobId(), new StringBuilder(16).append("MISSING_MEASURE_").append(timeLimitMissingData).toString())) {
                    JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Sending alert for missing measures", (String)station.code().get());
                    StationLight x$11 = station;
                    long x$122 = jobExecutionId$1;
                    long x$13 = jobInput$1.jobId();
                    Seq x$14 = emails$1;
                    Seq x$15 = phoneNumbers$1;
                    Seq x$16 = alertTypes$1;
                    Option x$17 = lastMeasure.map((Function1 & Serializable)m -> new MeasureDate(m.date(), m.value()));
                    Option x$18 = timeLimitMissingData;
                    String x$19 = (String)dataTypeInfo.map((Function1 & Serializable)x$12 -> (String)x$12.name().getOrElse((Function0 & Serializable)() -> "Non d\u00e9fini")).get();
                    $this.alertUtils.sendAlertNoMeasureFromJob(x$11, (Option<MeasureDate>)x$17, x$122, x$13, (Seq<String>)x$14, (Seq<String>)x$15, (Seq<String>)x$16, (Option<Object>)x$18, x$19);
                    return;
                }
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Measures still missing", (String)station.code().get());
                return;
            }
            if (lastMeasure.isEmpty()) {
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), "Measures not found", (String)station.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "Measures are up to date", (String)station.code().get());
            return;
        }
        catch (Throwable e) {
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), e.getMessage(), "Job Failed");
            $this.logUtil.printError(e);
            return;
        }
    }

    @Inject
    public AlertPluvio(LogUtil logUtil, AlertUtils alertUtils, PluvioChronicDao pluviometerMeasureDao, StationThresholdDao stationThresholdDao, ContactDao contactDAO, CityDao cityDao, PluviometerDao pluviometerDao, Database database, DataTypeDao dataTypeDao) {
        this.logUtil = logUtil;
        this.alertUtils = alertUtils;
        this.pluviometerMeasureDao = pluviometerMeasureDao;
        this.stationThresholdDao = stationThresholdDao;
        this.contactDAO = contactDAO;
        this.cityDao = cityDao;
        this.pluviometerDao = pluviometerDao;
        this.database = database;
        this.dataTypeDao = dataTypeDao;
    }
}

