/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers.calcul.mapSituation;

import fr.aquasys.daeau.export.ExportedData;
import fr.aquasys.daeau.export.ExportedData$;
import fr.aquasys.daeau.export.exportRPC.ExportRPC;
import fr.aquasys.daeau.iaeau.constants.IndicatorConstants$;
import fr.aquasys.daeau.iaeau.model.mapsituation.MapSituationStat;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.model.mapSituation.MapSituation;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.station.mapSituation.MapSituationRPC;
import fr.aquasys.daeau.station.model.StationCode;
import fr.aquasys.daeau.station.model.StationCode$;
import fr.aquasys.daeau.station.rpc.StationLinksRPC;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.WSUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\n\u0014\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006Y\u0001\n\u0005\ta\u0001\u0011\t\u0011)A\u0006c!A!\b\u0001B\u0001B\u0003-1\b\u0003\u0005B\u0001\t\u0005\t\u0015a\u0003C\u0011!Q\u0005A!A!\u0002\u0017Y\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b1\u0002*\t\u0011q\u0003!\u0011!Q\u0001\fuCQ\u0001\u001b\u0001\u0005\u0002%Dq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u001c\u0001\u0001\u000b\u0011B@\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002CA\u001a\u0001\u0001\u0006I!!\t\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004\u0002CA9\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005M\u0004\u0001)A\u0005\u007f\"9\u0011Q\u000f\u0001\u0005\n\u0005]$AE'baNKG/^1uS>tW\t\u001f9peRT!\u0001F\u000b\u0002\u00195\f\u0007oU5uk\u0006$\u0018n\u001c8\u000b\u0005Y9\u0012AB2bY\u000e,HN\u0003\u0002\u00193\u0005Y1m\u001c8ue>dG.\u001a:t\u0015\u0005Q\u0012\u0001C!mKJ$\u0018N\\4\u0004\u0001M\u0011\u0001!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011QEL\u0007\u0002M)\u0011q\u0005K\u0001\u0005kRLGN\u0003\u0002*U\u0005A!/\u00192cSRl\u0017O\u0003\u0002,Y\u00059\u0011-];bgf\u001c(\"A\u0017\u0002\u0005\u0019\u0014\u0018BA\u0018'\u0005\u001daunZ+uS2\fq\"T1q'&$X/\u0019;j_:\u0014\u0006k\u0011\t\u0003eaj\u0011a\r\u0006\u0003)QR!!\u000e\u001c\u0002\u000fM$\u0018\r^5p]*\u0011qGK\u0001\u0006I\u0006,\u0017-^\u0005\u0003sM\u0012q\"T1q'&$X/\u0019;j_:\u0014\u0006kQ\u0001\u0010'R\fG/[8o\u0019&t7n\u001d*Q\u0007B\u0011AhP\u0007\u0002{)\u0011a\bN\u0001\u0004eB\u001c\u0017B\u0001!>\u0005=\u0019F/\u0019;j_:d\u0015N\\6t%B\u001b\u0015!C#ya>\u0014HO\u0015)D!\t\u0019\u0005*D\u0001E\u0015\t)e)A\u0005fqB|'\u000f\u001e*Q\u0007*\u0011qIN\u0001\u0007Kb\u0004xN\u001d;\n\u0005%#%!C#ya>\u0014HO\u0015)D\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d*\nQ!\u001e;jYNL!\u0001U'\u0003\u0015){'\rT8h+RLG.A\u0004DSRLH)Y8\u0011\u0005MSV\"\u0001+\u000b\u0005U3\u0016aA5uM*\u0011q\u000bW\u0001\u0005G&$\u0018P\u0003\u0002Zm\u0005a!/\u001a4fe\u0016tG/[1mg&\u00111\f\u0016\u0002\b\u0007&$\u0018\u0010R1p\u0003\t98\u000f\u0005\u0002_M6\tqL\u0003\u0002]A*\u0011\u0011MY\u0001\u0005Y&\u00147O\u0003\u0002dI\u0006\u0019\u0011\r]5\u000b\u0003\u0015\fA\u0001\u001d7bs&\u0011qm\u0018\u0002\t/N\u001bE.[3oi\u00061A(\u001b8jiz\"\u0012A\u001b\u000b\tW6tw\u000e]9sgB\u0011A\u000eA\u0007\u0002'!)1\u0005\u0003a\u0002I!)\u0001\u0007\u0003a\u0002c!)!\b\u0003a\u0002w!)\u0011\t\u0003a\u0002\u0005\")!\n\u0003a\u0002\u0017\")\u0011\u000b\u0003a\u0002%\")A\f\u0003a\u0002;\"\u0012\u0001\"\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\fa!\u001b8kK\u000e$(\"\u0001>\u0002\u000b)\fg/\u0019=\n\u0005q<(AB%oU\u0016\u001cG/\u0001\u0006J!N#&/\u00193NCB,\u0012a \t\t\u0003\u0003\ty!!\u0006\u0002\u00169!\u00111AA\u0006!\r\t)aH\u0007\u0003\u0003\u000fQ1!!\u0003\u001c\u0003\u0019a$o\\8u}%\u0019\u0011QB\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t\"a\u0005\u0003\u00075\u000b\u0007OC\u0002\u0002\u000e}\u0001B!!\u0001\u0002\u0018%!\u0011\u0011DA\n\u0005\u0019\u0019FO]5oO\u0006Y\u0011\nU*Ue\u0006$W*\u00199!\u0003\u001dAW-\u00193feN,\"!!\t\u0011\r\u0005\r\u0012QFA\u000b\u001d\u0011\t)#!\u000b\u000f\t\u0005\u0015\u0011qE\u0005\u0002A%\u0019\u00111F\u0010\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005\r\u0019V-\u001d\u0006\u0004\u0003Wy\u0012\u0001\u00035fC\u0012,'o\u001d\u0011\u0002\u00195\fg.Y4f\u000bb\u0004xN\u001d;\u0015\u0011\u0005e\u0012qHA\"\u0003/\u00022AHA\u001e\u0013\r\tid\b\u0002\u0005+:LG\u000fC\u0004\u0002B5\u0001\r!!\u0006\u0002\u0017M$\u0018\r^5p]RK\b/\u001a\u0005\u0007)5\u0001\r!!\u0012\u0011\t\u0005\u001d\u00131K\u0007\u0003\u0003\u0013R1\u0001FA&\u0015\u0011\ti%a\u0014\u0002\u000b5|G-\u001a7\u000b\u0007\u0005Ec'\u0001\u0006qS\u0016Tx.\\3uefLA!!\u0016\u0002J\taQ*\u00199TSR,\u0018\r^5p]\"9\u0011\u0011L\u0007A\u0002\u0005m\u0013A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u0004=\u0005u\u0013bAA0?\t!Aj\u001c8h\u000399W\r\u001e#fa\u0006\u0014H/\\3oiN$\"!!\u001a\u0011\r\u0005\r\u0012QFA4!\u0011\tI'!\u001c\u000e\u0005\u0005-$bAA'i%!\u0011qNA6\u0005-\u0019F/\u0019;j_:\u001cu\u000eZ3\u0002\u0015\r|W.\\3oi6\u000b\u0007/A\u0006d_6lWM\u001c;NCB\u0004\u0013AC4fi\u000e{W.\\3oiR!\u0011QCA=\u0011\u001d\tY(\u0005a\u0001\u0003+\t\u0011a\u0019")
public class MapSituationExport {
    private final MapSituationRPC MapSituationRPC;
    private final StationLinksRPC StationLinksRPC;
    private final ExportRPC ExportRPC;
    private final JobLogUtil JobLogUtil;
    private final CityDao CityDao;
    private final WSClient ws;
    private final Map<String, String> IPSTradMap;
    private final Seq<String> headers;
    private final Map<String, String> commentMap;

    private Map<String, String> IPSTradMap() {
        return this.IPSTradMap;
    }

    private Seq<String> headers() {
        return this.headers;
    }

    public void manageExport(String stationType, MapSituation mapSituation, long jobExecutionId) {
        if (mapSituation.exportCSV().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Exporting CSV : building data", "", this.JobLogUtil.log$default$5());
            Seq stats = this.MapSituationRPC.getMapSituationStats(mapSituation.id(), stationType);
            if (stats.isEmpty() || ((MapSituationStat)stats.head()).date().isEmpty()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Map situation has no data --> File not exported.", "", this.JobLogUtil.log$default$5());
                return;
            }
            DateTime date = (DateTime)((MapSituationStat)stats.head()).date().get();
            Seq results = this.MapSituationRPC.getMapSItuationResults(mapSituation, stationType, (Option)new Some((Object)date), (Option)None$.MODULE$);
            if (results.isEmpty()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Map situation has no results --> File not exported.", "", this.JobLogUtil.log$default$5());
                return;
            }
            Seq ids = (Seq)((SeqOps)results.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).distinct();
            Map watermassLinks = AlgoUtil$.MODULE$.makeMapId(this.StationLinksRPC.getWatermassLinksWithNames(ids, stationType), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.idStation()));
            Map aquiferLinks = AlgoUtil$.MODULE$.makeMapId(this.StationLinksRPC.getAquiferLinksWithNames(ids, stationType), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.idStation()));
            Map departments = AlgoUtil$.MODULE$.makeMapCode(this.getDepartments(), (Function1 & Serializable)x$4 -> x$4.code());
            Map levels = AlgoUtil$.MODULE$.makeMapId(this.StationLinksRPC.getLevelsMinMaxStats(ids, stationType, BoxesRunTime.unboxToInt((Object)mapSituation.typeId().get())), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.idStation()));
            Map cities = AlgoUtil$.MODULE$.makeMapCode(this.CityDao.getAllLight(), (Function1 & Serializable)x$6 -> x$6.code());
            Seq seq = (Seq)this.headers().map((Function1 & Serializable)h -> new Some(h));
            Seq data = (Seq)((IterableOps)((SeqOps)results.map((Function1 & Serializable)r -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{r.code(), r.townCode().flatMap((Function1 & Serializable)c -> cities.get(c).flatMap((Function1 & Serializable)x$7 -> x$7.name().map((Function1 & Serializable)n -> new StringBuilder(3).append((String)n).append(" [").append((String)c).append("]").toString()))), r.name(), new Some((Object)DateUtil$.MODULE$.getDate(r.indicatorDate())), mapSituation.indicatorType().contains((Object)BoxesRunTime.boxToInteger((int)IndicatorConstants$.MODULE$.IPS())) ? r.thresholdName().map((Function1 & Serializable)t -> (String)this.IPSTradMap().apply(t)) : r.thresholdName(), r.resultClass().map((Function1 & Serializable)x$8 -> MapSituationExport.$anonfun$manageExport$13(BoxesRunTime.unboxToInt((Object)x$8))), r.trendLabel().contains((Object)"up") ? new Some((Object)"1") : (r.trendLabel().contains((Object)"right") ? new Some((Object)"0") : (r.trendLabel().contains((Object)"down") ? new Some((Object)"-1") : None$.MODULE$)), r.thresholdValue().map((Function1 & Serializable)v -> MapSituationExport.$anonfun$manageExport$14(BoxesRunTime.unboxToDouble((Object)v))), r.comment().map((Function1 & Serializable)c -> this.getComment((String)c)), r.x().map((Function1 & Serializable)x$9 -> MapSituationExport.$anonfun$manageExport$16(BoxesRunTime.unboxToDouble((Object)x$9))), r.y().map((Function1 & Serializable)x$10 -> MapSituationExport.$anonfun$manageExport$17(BoxesRunTime.unboxToDouble((Object)x$10))), r.projection().map((Function1 & Serializable)x$11 -> MapSituationExport.$anonfun$manageExport$18(BoxesRunTime.unboxToInt((Object)x$11))), r.townCode(), r.townCode().flatMap((Function1 & Serializable)c -> cities.get(c).flatMap((Function1 & Serializable)x$12 -> x$12.name())), r.townCode().map((Function1 & Serializable)x$13 -> StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(x$13), 2)), r.townCode().flatMap((Function1 & Serializable)c -> departments.get((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(c), 2)).flatMap((Function1 & Serializable)x$14 -> x$14.name())), watermassLinks.get((Object)BoxesRunTime.boxToInteger((int)r.id())).flatMap((Function1 & Serializable)x$15 -> x$15.code_me()), watermassLinks.get((Object)BoxesRunTime.boxToInteger((int)r.id())).flatMap((Function1 & Serializable)x$16 -> x$16.name()), aquiferLinks.get((Object)BoxesRunTime.boxToInteger((int)r.id())).flatMap((Function1 & Serializable)x$17 -> x$17.name()), levels.get((Object)BoxesRunTime.boxToInteger((int)r.id())).map((Function1 & Serializable)x$18 -> Double.toString(x$18.minValue())), levels.get((Object)BoxesRunTime.boxToInteger((int)r.id())).map((Function1 & Serializable)l -> DateUtil$.MODULE$.getDate(l.minDate())), levels.get((Object)BoxesRunTime.boxToInteger((int)r.id())).map((Function1 & Serializable)x$19 -> Double.toString(x$19.maxValue())), levels.get((Object)BoxesRunTime.boxToInteger((int)r.id())).map((Function1 & Serializable)l -> DateUtil$.MODULE$.getDate(l.maxDate())), levels.get((Object)BoxesRunTime.boxToInteger((int)r.id())).map((Function1 & Serializable)x$20 -> Double.toString(x$20.filledPercent()))})))).$plus$colon((Object)seq)).map((Function1 & Serializable)x$21 -> (Seq)x$21.map((Function1 & Serializable)r -> new ExportedData(r, ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4())));
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Exporting CSV : writing file", "", this.JobLogUtil.log$default$5());
            this.ExportRPC.generateExcelOrCsvInFile(data, "csv", new StringBuilder(22).append("EXPORT/situation_").append(stationType).append("_").append(mapSituation.id()).append(".csv").toString());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(37).append("CSV exported : EXPORT/situation_").append(stationType).append("_").append(mapSituation.id()).append(".csv").toString(), "", this.JobLogUtil.log$default$5());
            return;
        }
    }

    private Seq<StationCode> getDepartments() {
        return (Seq)((Option)Await$.MODULE$.result((Awaitable)WSUtil$.MODULE$.simpleGet("https://aquadb.fr/administration/web/map/department", Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)StationCode$.MODULE$.format()), this.ws), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).minutes())).getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Error during aquadb department fetch");
        });
    }

    private Map<String, String> commentMap() {
        return this.commentMap;
    }

    private String getComment(String c) {
        if (c.startsWith("ind_")) {
            if (c.startsWith("ind_NotEnoughData")) {
                String variable = c.replace("ind_NotEnoughData", "");
                return new StringBuilder(41).append("Pas assez d'historique (").append(variable).append(" ann\u00e9es requises)").toString();
            }
            if (c.startsWith("ind_LastMeasureBefore")) {
                String variable = c.replace("ind_LastMeasureBefore", "");
                return new StringBuilder(47).append("La derni\u00e8re mesure est trop ancienne (avant J-").append(variable).append(")").toString();
            }
            if (c.startsWith("ind_NotEnoughYearsForStat")) {
                String variable = c.replace("ind_NotEnoughYearsForStat", "");
                return new StringBuilder(60).append("Pas assez d'historique pour calculer une des statistiques : ").append(variable).toString();
            }
            return (String)this.commentMap().apply((Object)c);
        }
        return "";
    }

    public static final /* synthetic */ String $anonfun$manageExport$13(int x$8) {
        return Integer.toString(x$8);
    }

    public static final /* synthetic */ String $anonfun$manageExport$14(double v) {
        return Double.toString(MathUtil$.MODULE$.roundAt2(v));
    }

    public static final /* synthetic */ String $anonfun$manageExport$16(double x$9) {
        return Double.toString(x$9);
    }

    public static final /* synthetic */ String $anonfun$manageExport$17(double x$10) {
        return Double.toString(x$10);
    }

    public static final /* synthetic */ String $anonfun$manageExport$18(int x$11) {
        return Integer.toString(x$11);
    }

    @Inject
    public MapSituationExport(LogUtil logUtil, MapSituationRPC MapSituationRPC2, StationLinksRPC StationLinksRPC2, ExportRPC ExportRPC2, JobLogUtil JobLogUtil2, CityDao CityDao2, WSClient ws) {
        this.MapSituationRPC = MapSituationRPC2;
        this.StationLinksRPC = StationLinksRPC2;
        this.ExportRPC = ExportRPC2;
        this.JobLogUtil = JobLogUtil2;
        this.CityDao = CityDao2;
        this.ws = ws;
        this.IPSTradMap = new .colon.colon((Object)new Tuple2((Object)"wet5y10", (Object)"5 - 10 ans humide"), (List)new .colon.colon((Object)new Tuple2((Object)"wet10y", (Object)"> 10 ans humide"), (List)new .colon.colon((Object)new Tuple2((Object)"wet25y5", (Object)"2.5 \u2013 5 ans humide"), (List)new .colon.colon((Object)new Tuple2((Object)"dry5y", (Object)"5 \u2013 10 ans sec"), (List)new .colon.colon((Object)new Tuple2((Object)"dry10y", (Object)"> 10 ans sec"), (List)new .colon.colon((Object)new Tuple2((Object)"dry25y5", (Object)"2.5 \u2013 5 ans sec"), (List)new .colon.colon((Object)new Tuple2((Object)"dry25yWet25y", (Object)"2.5 ans sec \u00e0 2.5 ans humide"), (List)Nil$.MODULE$))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.headers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Code", "Commune", "Nom", "Date", "Cat\u00e9gorie", "Classe", "Tendance", "Seuil", "Commentaire", "X", "Y", "Projection", "Code commune", "Nom de la commune", "Num\u00e9ro de d\u00e9partement", "D\u00e9partement", "Code Masse d'eau", "Masse d'eau", "Aquif\u00e8re", "Niveau Min", "Date Min", "Niveau Max", "Date Max", "Taux de remplissage"}));
        this.commentMap = new .colon.colon((Object)new Tuple2((Object)"ind_NoMeasures", (Object)"Aucune mesure"), (List)new .colon.colon((Object)new Tuple2((Object)"ind_NoThresholds", (Object)"Aucun seuil sur la station"), (List)new .colon.colon((Object)new Tuple2((Object)"ind_NoMeasureFoundBefore", (Object)"Aucune mesure trouv\u00e9e avant la date de calul"), (List)new .colon.colon((Object)new Tuple2((Object)"ind_UnexpectedErrorDuringCalculation", (Object)"Erreur innatendue durant le calcul"), (List)new .colon.colon((Object)new Tuple2((Object)"ind_UnableToCalculateRefValue", (Object)"Impossible de calculer la statistique de r\u00e9f\u00e9rence"), (List)Nil$.MODULE$))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

