/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers.calcul.mapSituation.piezo.ips;

import Alerting.controllers.calcul.mapSituation.piezo.ips.IPS_Params;
import Alerting.controllers.calcul.mapSituation.piezo.ips.IPS_Params$;
import Alerting.controllers.calcul.mapSituation.piezo.ips.SPIMember;
import Alerting.controllers.calcul.mapSituation.piezo.ips.SPIResult$;
import fr.aquasys.daeau.iaeau.constants.IndicatorConstants$;
import fr.aquasys.daeau.iaeau.dao.CalculatedMeasureDao;
import fr.aquasys.daeau.iaeau.dao.IAEauModelDao;
import fr.aquasys.daeau.iaeau.model.IAEauModel;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.domain.SPIMeasure;
import fr.aquasys.daeau.piezometry.itf.MapSituationDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.model.PiezometerCode;
import fr.aquasys.daeau.piezometry.model.mapSituation.MapSituation;
import fr.aquasys.daeau.station.links.landmark.StationChartLandmarks;
import fr.aquasys.daeau.station.links.landmark.StationLandmarkDao;
import fr.aquasys.daeau.station.mapSituation.ips.IPS_Result;
import fr.aquasys.daeau.station.mapSituation.ips.IPS_Result$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.db.Database;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u000b\u0016\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006YA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0006o!A\u0011\t\u0001B\u0001B\u0003-!\t\u0003\u0005I\u0001\t\u0005\t\u0015a\u0003J\u0011!\u0019\u0006A!A!\u0002\u0017!\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b1\u0002-\t\u0011m\u0003!\u0011!Q\u0001\fqC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006Y\u0001\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0006[\"A\u0001\u000f\u0001B\u0001B\u0003-\u0011\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u0011q\u001e\u0001\u0005\u0002\u0005E\b\"\u0003B\u0003\u0001\t\u0007I\u0011\u0002B\u0004\u0011!\u0011y\u0001\u0001Q\u0001\n\t%\u0001\"\u0003B\t\u0001\t\u0007I\u0011\u0002B\n\u0011!\u00119\u0002\u0001Q\u0001\n\tU\u0001b\u0002B\r\u0001\u0011%!1\u0004\u0002\u0014\u0013B\u001bv\fU5fu>\u001cuN\u001c;s_2dWM\u001d\u0006\u0003-]\t1!\u001b9t\u0015\tA\u0012$A\u0003qS\u0016TxN\u0003\u0002\u001b7\u0005aQ.\u00199TSR,\u0018\r^5p]*\u0011A$H\u0001\u0007G\u0006d7-\u001e7\u000b\u0005yy\u0012aC2p]R\u0014x\u000e\u001c7feNT\u0011\u0001I\u0001\t\u00032,'\u000f^5oO\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00069An\\4Vi&d\u0007CA\u00165\u001b\u0005a#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0005=\u0002\u0014\u0001\u0003:bE\nLG/\\9\u000b\u0005E\u0012\u0014aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002g\u0005\u0011aM]\u0005\u0003k1\u0012q\u0001T8h+RLG.A\bNCB\u001c\u0016\u000e^;bi&|g\u000eR1p!\tAt(D\u0001:\u0015\tQ4(A\u0002ji\u001aT!\u0001P\u001f\u0002\u0015ALWM_8nKR\u0014\u0018P\u0003\u0002?a\u0005)A-Y3bk&\u0011\u0001)\u000f\u0002\u0010\u001b\u0006\u00048+\u001b;vCRLwN\u001c#b_\u0006Q!j\u001c2M_\u001e,F/\u001b7\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015\u0003\u0014!B;uS2\u001c\u0018BA$E\u0005)QuN\u0019'pOV#\u0018\u000e\\\u0001\tI\u0006$\u0018MY1tKB\u0011!*U\u0007\u0002\u0017*\u0011A*T\u0001\u0003I\nT!AT(\u0002\u0007\u0005\u0004\u0018NC\u0001Q\u0003\u0011\u0001H.Y=\n\u0005I[%\u0001\u0003#bi\u0006\u0014\u0017m]3\u0002\u001fALWM_8nKR,'\u000fR1fCV\u0004\"\u0001O+\n\u0005YK$a\u0004)jKj|W.\u001a;fe\u0012\u000bW-Y;\u0002)ALWM_8nKR,'/T3bgV\u0014X\rR1p!\tA\u0014,\u0003\u0002[s\t!\u0002+[3{_6,G/\u001a:NK\u0006\u001cXO]3EC>\f!a^:\u0011\u0005u\u000bW\"\u00010\u000b\u0005m{&B\u00011N\u0003\u0011a\u0017NY:\n\u0005\tt&\u0001C,T\u00072LWM\u001c;\u0002)\r\u000bGnY;mCR,G-T3bgV\u0014X\rR1p!\t)'.D\u0001g\u0015\t9\u0007.A\u0002eC>T!![\u001f\u0002\u000b%\fW-Y;\n\u0005-4'\u0001F\"bY\u000e,H.\u0019;fI6+\u0017m];sK\u0012\u000bw.A\u0007J\u0003\u0016\u000bW/T8eK2$\u0015m\u001c\t\u0003K:L!a\u001c4\u0003\u001b%\u000bU)Y;N_\u0012,G\u000eR1p\u0003I\u0019F/\u0019;j_:d\u0015M\u001c3nCJ\\G)Y8\u0011\u0005ILX\"A:\u000b\u0005Q,\u0018\u0001\u00037b]\u0012l\u0017M]6\u000b\u0005Y<\u0018!\u00027j].\u001c(B\u0001=>\u0003\u001d\u0019H/\u0019;j_:L!A_:\u0003%M#\u0018\r^5p]2\u000bg\u000eZ7be.$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u$RC`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0002\u0000\u00015\tQ\u0003C\u0003*\u0017\u0001\u000f!\u0006C\u00037\u0017\u0001\u000fq\u0007C\u0003B\u0017\u0001\u000f!\tC\u0003I\u0017\u0001\u000f\u0011\nC\u0003T\u0017\u0001\u000fA\u000bC\u0003X\u0017\u0001\u000f\u0001\fC\u0003\\\u0017\u0001\u000fA\fC\u0003d\u0017\u0001\u000fA\rC\u0003m\u0017\u0001\u000fQ\u000eC\u0003q\u0017\u0001\u000f\u0011\u000fK\u0002\f\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003C\tQA[1wCbLA!!\n\u0002\u001c\t1\u0011J\u001c6fGR\fqbY1mGVd\u0017\r^3J!Nk\u0015\r\u001d\u000b\u0005\u0003W\ti\u0004\u0006\u0003\u0002.\u0005M\u0002c\u0001\u0013\u00020%\u0019\u0011\u0011G\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003ka\u00019AA\u001c\u00039QwNY#yK\u000e,H/[8o\u0013\u0012\u00042\u0001JA\u001d\u0013\r\tY$\n\u0002\u0005\u0019>tw\r\u0003\u0004\u001b\u0019\u0001\u0007\u0011q\b\t\u0005\u0003\u0003\nI%\u0004\u0002\u0002D)\u0019!$!\u0012\u000b\u0007\u0005\u001d3(A\u0003n_\u0012,G.\u0003\u0003\u0002L\u0005\r#\u0001D'baNKG/^1uS>t\u0017\u0001D4fi&\u00036\u000bU3sS>$G\u0003FA)\u0003s\n\u0019)a&\u0002\"\u0006\u0015\u0016QXAa\u0003\u0017\f)\u000e\u0006\u0003\u0002T\u0005]\u0004CBA+\u0003K\nYG\u0004\u0003\u0002X\u0005\u0005d\u0002BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u0013%\u0001\u0004=e>|GOP\u0005\u0002M%\u0019\u00111M\u0013\u0002\u000fA\f7m[1hK&!\u0011qMA5\u0005\r\u0019V-\u001d\u0006\u0004\u0003G*\u0003\u0003BA7\u0003gj!!a\u001c\u000b\u0007Y\t\tH\u0003\u0002\u001bo&!\u0011QOA8\u0005)I\u0005kU0SKN,H\u000e\u001e\u0005\b\u0003ki\u00019AA\u001c\u0011\u0019AR\u00021\u0001\u0002|A!\u0011QPA@\u001b\t\t)%\u0003\u0003\u0002\u0002\u0006\u0015#A\u0004)jKj|W.\u001a;fe\u000e{G-\u001a\u0005\b\u0003\u000bk\u0001\u0019AAD\u0003)\u0011XmY;se\u0016t7-\u001a\t\u0005\u0003\u0013\u000b\tJ\u0004\u0003\u0002\f\u00065\u0005cAA-K%\u0019\u0011qR\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019*!&\u0003\rM#(/\u001b8h\u0015\r\ty)\n\u0005\b\u00033k\u0001\u0019AAN\u0003\u0019\u0001\u0018M]1ngB\u0019q0!(\n\u0007\u0005}UC\u0001\u0006J!N{\u0006+\u0019:b[NDq!a)\u000e\u0001\u0004\t\u0019&A\u0004sKN,H\u000e^:\t\u000f\u0005\u001dV\u00021\u0001\u0002*\u0006)1\u000f^1siB!\u00111VA]\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016\u0001\u0002;j[\u0016TA!a-\u00026\u0006!!n\u001c3b\u0015\t\t9,A\u0002pe\u001eLA!a/\u0002.\nAA)\u0019;f)&lW\rC\u0004\u0002@6\u0001\r!!+\u0002\u0007\u0015tG\rC\u0004\u0002D6\u0001\r!!2\u0002\rQL\b/Z%e!\r!\u0013qY\u0005\u0004\u0003\u0013,#aA%oi\"9\u0011QZ\u0007A\u0002\u0005=\u0017aB7pI\u0016d\u0017\n\u001a\t\u0006I\u0005E\u0017QY\u0005\u0004\u0003',#AB(qi&|g\u000eC\u0004\u0002X6\u0001\r!!7\u0002#M$\u0018\r^5p]Nd\u0015M\u001c3nCJ\\7\u000f\u0005\u0004\u0002V\u0005\u0015\u00141\u001c\t\u0004e\u0006u\u0017bAApg\n)2\u000b^1uS>t7\t[1si2\u000bg\u000eZ7be.\u001c\bfA\u0007\u0002dB!\u0011Q]Av\u001b\t\t9OC\u0002\u0002j\u0016\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti/a:\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006Yq-\u001a;QS\u0016Tx.\u0013)T)9\t\u00190a>\u0002z\u0006u\u0018q B\u0001\u0005\u0007!B!a\u001b\u0002v\"9\u0011Q\u0007\bA\u0004\u0005]\u0002B\u0002\r\u000f\u0001\u0004\tY\bC\u0004\u0002|:\u0001\r!!+\u0002\u000f%\u00048\u000fR1uK\"9\u0011\u0011\u0014\bA\u0002\u0005m\u0005bBAb\u001d\u0001\u0007\u0011Q\u0019\u0005\b\u0003\u001bt\u0001\u0019AAh\u0011\u001d\t9N\u0004a\u0001\u00033\fqb\u0015)J)J,g\u000eZ'baBLgnZ\u000b\u0003\u0005\u0013\u0001\u0002\"!#\u0003\f\u0005\u001d\u0015QY\u0005\u0005\u0005\u001b\t)JA\u0002NCB\f\u0001c\u0015)J)J,g\u000eZ'baBLgn\u001a\u0011\u0002\u001bM\u0003\u0016j\u00117bgNd\u0015MY3m+\t\u0011)\u0002\u0005\u0005\u0002\n\n-\u0011qQAD\u00039\u0019\u0006+S\"mCN\u001cH*\u00192fY\u0002\n\u0001cZ3u'BKEK]3oIZ\u000bG.^3\u0015\t\u0005\u0015'Q\u0004\u0005\b\u0005?\u0019\u0002\u0019AAD\u0003!\u0019\b/\u001b+sK:$\u0007")
public class IPS_PiezoController {
    private final LogUtil logUtil;
    private final MapSituationDao MapSituationDao;
    private final JobLogUtil JobLogUtil;
    private final Database database;
    private final PiezometerDaeau piezometerDaeau;
    private final PiezometerMeasureDao piezometerMeasureDao;
    private final WSClient ws;
    private final CalculatedMeasureDao CalculatedMeasureDao;
    private final IAEauModelDao IAEauModelDao;
    private final StationLandmarkDao StationLandmarkDao;
    private final Map<String, Object> SPITrendMapping;
    private final Map<String, String> SPIClassLabel;

    public void calculateIPSMap(MapSituation mapSituation, long jobExecutionId) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)Json$.MODULE$.parse((String)mapSituation.params().getOrElse((Function0 & Serializable)() -> "")).validate(IPS_Params$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(20).append("Can't read params : ").append(error.toString()).toString(), "", $this.JobLogUtil.log$default$5());
            throw new Exception(new StringBuilder(20).append("Can't read params : ").append(error.toString()).toString());
        }, (Function1 & Serializable)params -> BoxesRunTime.boxToInteger((int)IPS_PiezoController.$anonfun$calculateIPSMap$4(this, jobExecutionId, mapSituation, params)))));
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logUtil.printError(e);
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(34).append("Error on IPS map calculation ").append(mapSituation.id()).append(" : ").append(mapSituation.name().getOrElse((Function0 & Serializable)() -> "")).append(", ").append(e.getMessage()).toString(), "", this.JobLogUtil.log$default$5());
            Some x$22 = new Some((Object)BoxesRunTime.boxToInteger((int)2));
            int x$23 = mapSituation.copy$default$1();
            Option x$24 = mapSituation.copy$default$2();
            Option x$25 = mapSituation.copy$default$3();
            Option x$26 = mapSituation.copy$default$4();
            Option x$27 = mapSituation.copy$default$5();
            Option x$28 = mapSituation.copy$default$6();
            Option x$29 = mapSituation.copy$default$8();
            Option x$30 = mapSituation.copy$default$9();
            Option x$31 = mapSituation.copy$default$10();
            Option x$32 = mapSituation.copy$default$11();
            Option x$33 = mapSituation.copy$default$12();
            Option x$34 = mapSituation.copy$default$13();
            Option x$35 = mapSituation.copy$default$14();
            Option x$36 = mapSituation.copy$default$15();
            Option x$37 = mapSituation.copy$default$16();
            Option x$38 = mapSituation.copy$default$17();
            Option x$39 = mapSituation.copy$default$18();
            Option x$40 = mapSituation.copy$default$19();
            Option x$41 = mapSituation.copy$default$20();
            Option x$42 = mapSituation.copy$default$21();
            this.MapSituationDao.update(StationTypeUtil$.MODULE$.PIEZOMETRY(), mapSituation.copy(x$23, x$24, x$25, x$26, x$27, x$28, (Option)x$22, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42), this.MapSituationDao.update$default$3());
            return;
        }
        throw new MatchError((Object)try_);
    }

    private Seq<IPS_Result> getIPSPeriod(PiezometerCode piezo, String recurrence, IPS_Params params, Seq<IPS_Result> results, DateTime start, DateTime end, int typeId, Option<Object> modelId, Seq<StationChartLandmarks> stationsLandmarks, long jobExecutionId) {
        while (true) {
            DateTime dateTime;
            block7: {
                if (start.getMillis() > end.getMillis()) {
                    return results;
                }
                String string = recurrence;
                switch (string == null ? 0 : string.hashCode()) {
                    case 99228: {
                        if (!"day".equals(string)) break;
                        dateTime = start.plusDays(1);
                        break block7;
                    }
                    case 3645428: {
                        if (!"week".equals(string)) break;
                        dateTime = start.plusWeeks(1);
                        break block7;
                    }
                    case 104080000: {
                        if (!"month".equals(string)) break;
                        dateTime = start.plusMonths(1);
                        break block7;
                    }
                }
                throw new MatchError((Object)string);
            }
            DateTime newStart = dateTime;
            Seq seq = (Seq)results.$colon$plus((Object)this.getPiezoIPS(piezo, start, params, typeId, modelId, stationsLandmarks, jobExecutionId));
            start = newStart;
            results = seq;
        }
    }

    public IPS_Result getPiezoIPS(PiezometerCode piezo, DateTime ipsDate, IPS_Params params, int typeId, Option<Object> modelId, Seq<StationChartLandmarks> stationsLandmarks, long jobExecutionId) {
        Throwable e;
        Throwable e2;
        Option x$23;
        int x$1 = (int)piezo.id();
        DateTime x$2 = ipsDate;
        Some x$3 = new Some((Object)new DateTime());
        DateTime x$4 = ipsDate;
        Option x$5 = IPS_Result$.MODULE$.apply$default$4();
        Option x$6 = IPS_Result$.MODULE$.apply$default$5();
        Option x$7 = IPS_Result$.MODULE$.apply$default$6();
        Option x$8 = IPS_Result$.MODULE$.apply$default$7();
        Option x$92 = IPS_Result$.MODULE$.apply$default$8();
        Option x$10 = IPS_Result$.MODULE$.apply$default$9();
        Option x$11 = IPS_Result$.MODULE$.apply$default$11();
        Option x$12 = IPS_Result$.MODULE$.apply$default$12();
        Option x$13 = IPS_Result$.MODULE$.apply$default$13();
        IPS_Result baseResult = new IPS_Result(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$92, x$10, (Option)x$3, x$11, x$12, x$13);
        boolean bl = false;
        Failure failure = null;
        int x$14 = (int)piezo.id();
        Some x$15 = new Some((Object)ipsDate);
        int x$16 = BoxesRunTime.unboxToInt((Object)params.nbYearsHistoRequired().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 10));
        int x$17 = typeId;
        Some x$18 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)params.validOnly()));
        int x$19 = BoxesRunTime.unboxToInt((Object)params.nbDaysWithoutMeasuresMax().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 30));
        Option x$20 = modelId.map((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> true);
        Option<Object> x$21 = modelId;
        Option x$22 = this.piezometerMeasureDao.getAllMonthAverages$default$6();
        Try try_ = this.piezometerMeasureDao.getAllMonthAverages(x$14, (Option)x$15, x$16, x$17, (Option)x$18, x$22, x$23 = this.piezometerMeasureDao.getAllMonthAverages$default$7(), x$19, x$20, x$21);
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e3 = failure.exception();
            if (e3.getMessage().startsWith("No measures")) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "No measures found for this station", piezo.code(), this.JobLogUtil.log$default$5());
                Some x$24 = new Some((Object)"ind_NoMeasures");
                int x$25 = baseResult.copy$default$1();
                DateTime x$26 = baseResult.copy$default$2();
                DateTime x$27 = baseResult.copy$default$3();
                Option x$28 = baseResult.copy$default$4();
                Option x$29 = baseResult.copy$default$5();
                Option x$30 = baseResult.copy$default$6();
                Option x$31 = baseResult.copy$default$7();
                Option x$32 = baseResult.copy$default$8();
                Option x$33 = baseResult.copy$default$9();
                Option x$34 = baseResult.copy$default$10();
                Option x$35 = baseResult.copy$default$11();
                Option x$36 = baseResult.copy$default$13();
                return baseResult.copy(x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, (Option)x$24, x$36);
            }
        }
        if (bl && (e2 = failure.exception()).getMessage().startsWith("Need ")) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(47).append("Need minimum of ").append(params.nbYearsHistoRequired().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 10)).append(" years of data to calculate IPS").toString(), piezo.code(), this.JobLogUtil.log$default$5());
            Some x$37 = new Some((Object)new StringBuilder(17).append("ind_NotEnoughData").append(params.nbYearsHistoRequired().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 10)).toString());
            int x$38 = baseResult.copy$default$1();
            DateTime x$39 = baseResult.copy$default$2();
            DateTime x$40 = baseResult.copy$default$3();
            Option x$41 = baseResult.copy$default$4();
            Option x$42 = baseResult.copy$default$5();
            Option x$43 = baseResult.copy$default$6();
            Option x$44 = baseResult.copy$default$7();
            Option x$45 = baseResult.copy$default$8();
            Option x$46 = baseResult.copy$default$9();
            Option x$47 = baseResult.copy$default$10();
            Option x$48 = baseResult.copy$default$11();
            Option x$49 = baseResult.copy$default$13();
            return baseResult.copy(x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, (Option)x$37, x$49);
        }
        if (bl && (e = failure.exception()).getMessage().startsWith("Last measure is too old")) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(38).append("Last measure is too old (before ").append(params.nbDaysWithoutMeasuresMax().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 30)).append(" days)").toString(), piezo.code(), this.JobLogUtil.log$default$5());
            Some x$50 = new Some((Object)new StringBuilder(21).append("ind_LastMeasureBefore").append(params.nbDaysWithoutMeasuresMax().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 30)).toString());
            int x$51 = baseResult.copy$default$1();
            DateTime x$52 = baseResult.copy$default$2();
            DateTime x$53 = baseResult.copy$default$3();
            Option x$54 = baseResult.copy$default$4();
            Option x$55 = baseResult.copy$default$5();
            Option x$56 = baseResult.copy$default$6();
            Option x$57 = baseResult.copy$default$7();
            Option x$58 = baseResult.copy$default$8();
            Option x$59 = baseResult.copy$default$9();
            Option x$60 = baseResult.copy$default$10();
            Option x$61 = baseResult.copy$default$11();
            Option x$62 = baseResult.copy$default$13();
            return baseResult.copy(x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, (Option)x$50, x$62);
        }
        if (bl) {
            Throwable e4 = failure.exception();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(53).append("Unexpected error during month averages calculation : ").append(e4.getMessage()).toString(), piezo.code(), this.JobLogUtil.log$default$5());
            this.logUtil.printError(e4);
            e4.printStackTrace();
            Some x$63 = new Some((Object)"ind_UnexpectedErrorDuringCalculation");
            int x$64 = baseResult.copy$default$1();
            DateTime x$65 = baseResult.copy$default$2();
            DateTime x$66 = baseResult.copy$default$3();
            Option x$67 = baseResult.copy$default$4();
            Option x$68 = baseResult.copy$default$5();
            Option x$69 = baseResult.copy$default$6();
            Option x$70 = baseResult.copy$default$7();
            Option x$71 = baseResult.copy$default$8();
            Option x$72 = baseResult.copy$default$9();
            Option x$73 = baseResult.copy$default$10();
            Option x$74 = baseResult.copy$default$11();
            Option x$75 = baseResult.copy$default$13();
            return baseResult.copy(x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, (Option)x$63, x$75);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq averages = (Seq)success.value();
            Seq result = (Seq)((IterableOps)averages.map((Function1 & Serializable)s -> s.getSPIMeasureString())).takeRight(288);
            String measuresStrList = result.toString().replace("List(", "[").replace(")", "]").replaceAll(" ", "");
            String url = "http://services.ades.eaufrance.fr/ServicesPublic/ServicesEsther/1/IPS.ashx";
            String body = new StringBuilder(85).append("identifier=").append(piezo.id()).append("&OutputFormat=APPLICATION/JSON&InputFormat=ARRAY&MonthlyAverages=").append(measuresStrList).append("&IPSDate=").append(((SPIMeasure)averages.last()).month()).toString();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(29).append("call IPS for ").append(ipsDate.toString("dd/MM/YYYY")).append(", last values : ").append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(measuresStrList), 50)).toString(), piezo.code(), this.JobLogUtil.log$default$5());
            return (IPS_Result)Await$.MODULE$.result((Awaitable)this.ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).minutes()).withHttpHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Content-Type"), (Object)"application/x-www-form-urlencoded")})).withHttpHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Content-Length"), (Object)Integer.toString(body.length()))})).withMethod("POST").withBody((Object)body, play.api.libs.ws.package$.MODULE$.writeableOf_String()).execute().map((Function1 & Serializable)response -> {
                Predef$.MODULE$.println((Object)"Body result");
                String bodyResp = response.body().trim().replace("\ufeff", "");
                Predef$.MODULE$.println((Object)bodyResp);
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(bodyResp));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JsValue json = (JsValue)success.value();
                    return (IPS_Result)json.validate(SPIResult$.MODULE$.memberReads()).fold((Function1 & Serializable)error -> {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(42).append("Error during IPS call result validation : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                        $this.logUtil.error(new StringBuilder(42).append("Error during IPS call result validation : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
                        $this.logUtil.error(new StringBuilder(6).append("url : ").append(url).toString(), $this.logUtil.error$default$2());
                        $this.logUtil.error(new StringBuilder(7).append("body : ").append(body).toString(), $this.logUtil.error$default$2());
                        $this.logUtil.error(new StringBuilder(18).append("returned output : ").append(response.json().toString()).toString(), $this.logUtil.error$default$2());
                        Some x$76 = new Some((Object)"ind_UnexpectedErrorDuringCalculation");
                        int x$77 = baseResult.copy$default$1();
                        DateTime x$78 = baseResult.copy$default$2();
                        DateTime x$79 = baseResult.copy$default$3();
                        Option x$80 = baseResult.copy$default$4();
                        Option x$81 = baseResult.copy$default$5();
                        Option x$82 = baseResult.copy$default$6();
                        Option x$83 = baseResult.copy$default$7();
                        Option x$84 = baseResult.copy$default$8();
                        Option x$85 = baseResult.copy$default$9();
                        Option x$86 = baseResult.copy$default$10();
                        Option x$87 = baseResult.copy$default$11();
                        Option x$88 = baseResult.copy$default$13();
                        return baseResult.copy(x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, (Option)x$76, x$88);
                    }, (Function1 & Serializable)spiResult -> {
                        Option<Seq<SPIMember>> option = spiResult.member();
                        if (None$.MODULE$.equals(option)) {
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(68).append("Error returned by IPS call. (CdError ").append(spiResult.CdError().getOrElse((Function0 & Serializable)() -> "(no code)")).append("). Please contact BRGM support.").toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(17).append("Error returned : ").append(spiResult.DescriptifError().getOrElse((Function0 & Serializable)() -> "(No message)")).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(22).append("Error with this url : ").append(url).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(16).append("And this body : ").append(body).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                            $this.logUtil.error(new StringBuilder(29).append("Error returned by IPS call : ").append(spiResult.DescriptifError().getOrElse((Function0 & Serializable)() -> "(No message)")).toString(), $this.logUtil.error$default$2());
                            $this.logUtil.error(new StringBuilder(6).append("url : ").append(url).toString(), $this.logUtil.error$default$2());
                            $this.logUtil.error(new StringBuilder(7).append("body : ").append(body).toString(), $this.logUtil.error$default$2());
                            $this.logUtil.error(new StringBuilder(18).append("returned output : ").append(bodyResp).toString(), $this.logUtil.error$default$2());
                            Some x$89 = new Some((Object)"ind_UnexpectedErrorDuringCalculation");
                            int x$90 = baseResult.copy$default$1();
                            DateTime x$91 = baseResult.copy$default$2();
                            DateTime x$92 = baseResult.copy$default$3();
                            Option x$93 = baseResult.copy$default$4();
                            Option x$94 = baseResult.copy$default$5();
                            Option x$95 = baseResult.copy$default$6();
                            Option x$96 = baseResult.copy$default$7();
                            Option x$97 = baseResult.copy$default$8();
                            Option x$98 = baseResult.copy$default$9();
                            Option x$99 = baseResult.copy$default$10();
                            Option x$100 = baseResult.copy$default$11();
                            Option x$101 = baseResult.copy$default$13();
                            return baseResult.copy(x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, (Option)x$89, x$101);
                        }
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Seq member = (Seq)some.value();
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(18).append("IPS calculated on ").append(ipsDate.toString("dd/MM/YYYY")).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                            Option<String> SPIClass = ((SPIMember)member.find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)IPS_PiezoController.$anonfun$getPiezoIPS$16(m))).get()).result().term();
                            Option cote = stationsLandmarks.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)IPS_PiezoController.$anonfun$getPiezoIPS$17(piezo, x$10))).flatMap((Function1 & Serializable)x$11 -> x$11.lastlandmark());
                            Option<Object> x$102 = ((SPIMember)member.find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)IPS_PiezoController.$anonfun$getPiezoIPS$19(m))).get()).result().value();
                            Option<String> x$103 = SPIClass;
                            Some x$104 = new Some((Object)BoxesRunTime.boxToInteger((int)this.getSPITrendValue((String)((SPIMember)member.find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)IPS_PiezoController.$anonfun$getPiezoIPS$20(m))).get()).result().term().get())));
                            Option x$105 = SPIClass.map((Function1 & Serializable)c -> (String)this.SPIClassLabel().apply(c));
                            Option x$106 = $this.piezometerMeasureDao.getLastMeasures((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{(int)piezo.id()})), -1, (Option)new Some((Object)ipsDate)).headOption().flatMap((Function1 & Serializable)x$12 -> x$12.value()).map((Function1)(JFunction1.mcDD.sp & Serializable)v -> {
                                if (cote.isDefined()) {
                                    return BoxesRunTime.unboxToDouble((Object)cote.get()) - v;
                                }
                                return v;
                            });
                            int x$107 = baseResult.copy$default$1();
                            DateTime x$108 = baseResult.copy$default$2();
                            DateTime x$109 = baseResult.copy$default$3();
                            Option x$110 = baseResult.copy$default$7();
                            Option x$111 = baseResult.copy$default$9();
                            Option x$112 = baseResult.copy$default$10();
                            Option x$113 = baseResult.copy$default$11();
                            Option x$114 = baseResult.copy$default$12();
                            return baseResult.copy(x$107, x$108, x$109, x$102, x$103, (Option)x$104, x$110, x$105, x$111, x$112, x$113, x$114, x$106);
                        }
                        throw new MatchError(option);
                    });
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(24).append("Error during IPS call : ").append(e.getMessage()).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Error with this url : ").append(url).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(16).append("And this body : ").append(body).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                    $this.logUtil.printError(e);
                    Some x$115 = new Some((Object)"ind_UnexpectedErrorDuringCalculation");
                    int x$116 = baseResult.copy$default$1();
                    DateTime x$117 = baseResult.copy$default$2();
                    DateTime x$118 = baseResult.copy$default$3();
                    Option x$119 = baseResult.copy$default$4();
                    Option x$120 = baseResult.copy$default$5();
                    Option x$121 = baseResult.copy$default$6();
                    Option x$122 = baseResult.copy$default$7();
                    Option x$123 = baseResult.copy$default$8();
                    Option x$124 = baseResult.copy$default$9();
                    Option x$125 = baseResult.copy$default$10();
                    Option x$126 = baseResult.copy$default$11();
                    Option x$127 = baseResult.copy$default$13();
                    return baseResult.copy(x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, (Option)x$115, x$127);
                }
                throw new MatchError((Object)try_);
            }, ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).minutes());
        }
        throw new MatchError((Object)try_);
    }

    private Map<String, Object> SPITrendMapping() {
        return this.SPITrendMapping;
    }

    private Map<String, String> SPIClassLabel() {
        return this.SPIClassLabel;
    }

    private int getSPITrendValue(String spiTrend) {
        Option option = this.SPITrendMapping().find((Function1 & Serializable)trend -> BoxesRunTime.boxToBoolean((boolean)spiTrend.equals(trend._1())));
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 x = (Tuple2)some.value();
            return x._2$mcI$sp();
        }
        return 3;
    }

    public static final /* synthetic */ int $anonfun$calculateIPSMap$7(PiezometerCode x$1) {
        return (int)x$1.id();
    }

    public static final /* synthetic */ void $anonfun$calculateIPSMap$9(IPS_PiezoController $this, MapSituation mapSituation$1, int idx$1, Seq codes$1, Connection c) {
        $this.MapSituationDao.setProgressWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), mapSituation$1.id(), (double)(100 * idx$1 / codes$1.length()), c);
        c.commit();
    }

    public static final /* synthetic */ long $anonfun$calculateIPSMap$10(IAEauModel x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2.updateDate().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$calculateIPSMap$21(IPS_Result x$8) {
        return x$8.comment().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$calculateIPSMap$20(IPS_PiezoController $this, Seq ipsCalculated$1, MapSituation mapSituation$1, long jobExecutionId$1, ObjectRef simulationDate$1, Connection c) {
        int withResults = ipsCalculated$1.count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)IPS_PiezoController.$anonfun$calculateIPSMap$21(x$8)));
        int results = $this.CalculatedMeasureDao.setIndicatorsWithTypeIdWC(IndicatorConstants$.MODULE$.IPS(), mapSituation$1.id(), StationTypeUtil$.MODULE$.PIEZOMETRY(), (Seq)ipsCalculated$1.map((Function1 & Serializable)i -> i.toIndicator(i.date(), mapSituation$1.id())), $this.CalculatedMeasureDao.setIndicatorsWithTypeIdWC$default$5(), c);
        if (results > 0) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(29).append(withResults).append(" IPS calculated with success.").toString(), "", $this.JobLogUtil.log$default$5());
        }
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)withResults));
        Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)100.0));
        Some x$4 = new Some((Object)((DateTime)simulationDate$1.elem));
        Some x$5 = new Some((Object)new DateTime());
        int x$6 = mapSituation$1.copy$default$1();
        Option x$7 = mapSituation$1.copy$default$2();
        Option x$82 = mapSituation$1.copy$default$4();
        Option x$9 = mapSituation$1.copy$default$8();
        Option x$10 = mapSituation$1.copy$default$10();
        Option x$11 = mapSituation$1.copy$default$11();
        Option x$12 = mapSituation$1.copy$default$12();
        Option x$13 = mapSituation$1.copy$default$13();
        Option x$14 = mapSituation$1.copy$default$14();
        Option x$15 = mapSituation$1.copy$default$15();
        Option x$16 = mapSituation$1.copy$default$16();
        Option x$17 = mapSituation$1.copy$default$17();
        Option x$18 = mapSituation$1.copy$default$18();
        Option x$19 = mapSituation$1.copy$default$19();
        Option x$20 = mapSituation$1.copy$default$20();
        Option x$21 = mapSituation$1.copy$default$21();
        return $this.MapSituationDao.updateWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), mapSituation$1.copy(x$6, x$7, (Option)x$4, x$82, (Option)x$5, (Option)x$2, (Option)x$1, x$9, (Option)x$3, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21), $this.MapSituationDao.updateWC$default$3(), c);
    }

    public static final /* synthetic */ int $anonfun$calculateIPSMap$4(IPS_PiezoController $this, long jobExecutionId$1, MapSituation mapSituation$1, IPS_Params params) {
        Seq codes;
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(9).append("Params : ").append(((JsObject)Json$.MODULE$.toJson((Object)params, IPS_Params$.MODULE$.format()).as((Reads)Reads$.MODULE$.JsObjectReads())).$plus$plus(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stationIds"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)JsNull$.MODULE$, Writes$.MODULE$.jsValueWrites()))}))).toString()).toString(), "", $this.JobLogUtil.log$default$5());
        DateTime now = new DateTime().withMillisOfSecond(0);
        ObjectRef simulationDate = ObjectRef.create((Object)now);
        int typeId = BoxesRunTime.unboxToInt((Object)mapSituation$1.typeId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
        Seq seq = codes = params.allStations().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.piezometerDaeau.getAllCodes($this.piezometerDaeau.getAllCodes$default$1()) : $this.piezometerDaeau.getAllCodes((Option)new Some(params.stationIds().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)));
        if (codes.isEmpty()) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), "No stations to calculate...", "", $this.JobLogUtil.log$default$5());
        }
        Seq stationsLandmarks = $this.StationLandmarkDao.getChartLandmarks((Seq)codes.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)IPS_PiezoController.$anonfun$calculateIPSMap$7(x$1))));
        Seq ipsCalculated = (Seq)((IterableOps)codes.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string;
                Seq piezoModels;
                PiezometerCode piezo = (PiezometerCode)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                $this.JobLogUtil.checkExecutionAbort(jobExecutionId$1);
                Object object = idx % 20 == 0 && idx > 0 ? $this.database.withTransaction((Function1 & Serializable)c -> {
                    IPS_PiezoController.$anonfun$calculateIPSMap$9($this, mapSituation$1, idx, codes, c);
                    return BoxedUnit.UNIT;
                }) : BoxedUnit.UNIT;
                None$ foundModel = mapSituation$1.usePredict().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? ((piezoModels = $this.IAEauModelDao.getModels((int)piezo.id(), StationTypeUtil$.MODULE$.PIEZOMETRY())).isEmpty() ? None$.MODULE$ : new Some(piezoModels.maxBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)IPS_PiezoController.$anonfun$calculateIPSMap$10(x$2)), (Ordering)Ordering.Long$.MODULE$))) : None$.MODULE$;
                Option modelId = foundModel.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.idModel()));
                Option maxPredictDate = modelId.flatMap((Function1 & Serializable)i -> $this.CalculatedMeasureDao.geMaxDateModelMeasure((int)piezo.id(), StationTypeUtil$.MODULE$.PIEZOMETRY(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Option)new Some((Object)now), $this.CalculatedMeasureDao.geMaxDateModelMeasure$default$5()));
                Some usedCalculType = foundModel.isDefined() ? new Some((Object)"period") : mapSituation$1.calculType();
                DateTime usedStart = mapSituation$1.calculType().contains((Object)"daily") || mapSituation$1.calculType().contains((Object)"now") ? now : (DateTime)mapSituation$1.startPeriod().getOrElse((Function0 & Serializable)() -> now);
                DateTime usedEnd = maxPredictDate.isDefined() ? (DateTime)maxPredictDate.get() : (DateTime)mapSituation$1.endPeriod().getOrElse((Function0 & Serializable)() -> now);
                boolean bl = false;
                Some some = null;
                Some some2 = usedCalculType;
                if (some2 instanceof Some) {
                    bl = true;
                    some = some2;
                    String string2 = (String)some.value();
                    if ("period".equals(string2) && mapSituation$1.startPeriod().isDefined() && mapSituation$1.endPeriod().isDefined() && mapSituation$1.recurrence().isDefined()) {
                        simulationDate$1.elem = (DateTime)new .colon.colon((Object)((DateTime)simulationDate$1.elem), (List)new .colon.colon((Object)usedEnd, (List)Nil$.MODULE$)).maxBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getMillis()), (Ordering)Ordering.Long$.MODULE$);
                        return $this.getIPSPeriod(piezo, (String)mapSituation$1.recurrence().get(), params, (Seq<IPS_Result>)((Seq)Nil$.MODULE$), usedStart.withMillisOfSecond(0), usedEnd.withMillisOfSecond(0), typeId, (Option<Object>)modelId, (Seq<StationChartLandmarks>)stationsLandmarks, jobExecutionId$1);
                    }
                }
                if (bl && "date".equals(string = (String)some.value()) && mapSituation$1.startPeriod().isDefined()) {
                    simulationDate$1.elem = (DateTime)new .colon.colon((Object)((DateTime)simulationDate$1.elem), (List)new .colon.colon((Object)((DateTime)mapSituation$1.startPeriod().get()), (List)Nil$.MODULE$)).maxBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getMillis()), (Ordering)Ordering.Long$.MODULE$);
                    return new .colon.colon((Object)$this.getPiezoIPS(piezo, (DateTime)mapSituation$1.startPeriod().get(), params, typeId, (Option<Object>)modelId, (Seq<StationChartLandmarks>)stationsLandmarks, jobExecutionId$1), (List)Nil$.MODULE$);
                }
                simulationDate$1.elem = (DateTime)new .colon.colon((Object)((DateTime)simulationDate$1.elem), (List)new .colon.colon((Object)now, (List)Nil$.MODULE$)).maxBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getMillis()), (Ordering)Ordering.Long$.MODULE$);
                return new .colon.colon((Object)$this.getPiezoIPS(piezo, now, params, typeId, (Option<Object>)modelId, (Seq<StationChartLandmarks>)stationsLandmarks, jobExecutionId$1), (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        });
        return BoxesRunTime.unboxToInt((Object)$this.database.withTransaction((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)IPS_PiezoController.$anonfun$calculateIPSMap$20($this, ipsCalculated, mapSituation$1, jobExecutionId$1, simulationDate, c))));
    }

    public static final /* synthetic */ boolean $anonfun$getPiezoIPS$16(SPIMember m) {
        return "ClasseIPS".equals(m.id());
    }

    public static final /* synthetic */ boolean $anonfun$getPiezoIPS$17(PiezometerCode piezo$2, StationChartLandmarks x$10) {
        return x$10.id() == (int)piezo$2.id();
    }

    public static final /* synthetic */ boolean $anonfun$getPiezoIPS$19(SPIMember m) {
        return "IPS".equals(m.id());
    }

    public static final /* synthetic */ boolean $anonfun$getPiezoIPS$20(SPIMember m) {
        return "TendanceIPS".equals(m.id());
    }

    @Inject
    public IPS_PiezoController(LogUtil logUtil, MapSituationDao MapSituationDao2, JobLogUtil JobLogUtil2, Database database, PiezometerDaeau piezometerDaeau, PiezometerMeasureDao piezometerMeasureDao, WSClient ws, CalculatedMeasureDao CalculatedMeasureDao2, IAEauModelDao IAEauModelDao2, StationLandmarkDao StationLandmarkDao2) {
        this.logUtil = logUtil;
        this.MapSituationDao = MapSituationDao2;
        this.JobLogUtil = JobLogUtil2;
        this.database = database;
        this.piezometerDaeau = piezometerDaeau;
        this.piezometerMeasureDao = piezometerMeasureDao;
        this.ws = ws;
        this.CalculatedMeasureDao = CalculatedMeasureDao2;
        this.IAEauModelDao = IAEauModelDao2;
        this.StationLandmarkDao = StationLandmarkDao2;
        this.SPITrendMapping = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hausse"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baisse"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stable"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"autre"), (Object)BoxesRunTime.boxToInteger((int)3))}));
        this.SPIClassLabel = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)"dry10y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)"dry5y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"3"), (Object)"dry25y5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"4"), (Object)"dry25yWet25y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"5"), (Object)"wet25y5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"6"), (Object)"wet5y10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"7"), (Object)"wet10y")}));
    }
}

