/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers.calcul.meteoNappes;

import Alerting.controllers.calcul.meteoNappes.MeteoNappesParams;
import Alerting.controllers.calcul.meteoNappes.MeteoNappesParams$;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.iaeau.IAEauCallUtil;
import fr.aquasys.daeau.iaeau.dao.PredMeasuresDao;
import fr.aquasys.daeau.iaeau.model.IAEauModel;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.iaeau.model.PredMeasure$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.constant.PiezometryRouting$;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsReadable;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.IAEauUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\b\u0010\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006Y\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0006g!AQ\b\u0001B\u0001B\u0003-a\b\u0003\u0005G\u0001\t\u0005\t\u0015a\u0003H\u0011!y\u0005A!A!\u0002\u0017\u0001\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u0011}\u0003!\u0011!Q\u0001\f\u0001DQa\u001a\u0001\u0005\u0002!Dq\u0001 \u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0011\u0002@\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0002\u0016\u001b\u0016$Xm\u001c(baB,7oQ8oiJ|G\u000e\\3s\u0015\t\u0001\u0012#A\u0006nKR,wNT1qa\u0016\u001c(B\u0001\n\u0014\u0003\u0019\u0019\u0017\r\\2vY*\u0011A#F\u0001\fG>tGO]8mY\u0016\u00148OC\u0001\u0017\u0003!\tE.\u001a:uS:<7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!S5\t\u0011E\u0003\u0002#G\u0005\u0019\u0011\r]5\u000b\u0005\u0011*\u0013\u0001\u0003:bE\nLG/\\9\u000b\u0005\u0019:\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002Q\u0005\u0011aM]\u0005\u0003U\u0005\u0012\u0001\u0002\u0015:pIV\u001cWM]\u0001\bY><W\u000b^5m!\ti\u0003'D\u0001/\u0015\ty3%\u0001\u0003vi&d\u0017BA\u0019/\u0005\u001daunZ+uS2\f!a^:\u0011\u0005QZT\"A\u001b\u000b\u0005I2$BA\u001c9\u0003\u0011a\u0017NY:\u000b\u0005\tJ$\"\u0001\u001e\u0002\tAd\u0017-_\u0005\u0003yU\u0012\u0001bV*DY&,g\u000e^\u0001\u000e\u0013\u0006+\u0015-^\"bY2,F/\u001b7\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015!B5bK\u0006,(BA\"&\u0003\u0015!\u0017-Z1v\u0013\t)\u0005IA\u0007J\u0003\u0016\u000bWoQ1mYV#\u0018\u000e\\\u0001\u0015!&,'p\\7fi\u0016\u0014X*Z1tkJ,G)Y8\u0011\u0005!kU\"A%\u000b\u0005)[\u0015aA5uM*\u0011AJQ\u0001\u000ba&,'p\\7fiJL\u0018B\u0001(J\u0005Q\u0001\u0016.\u001a>p[\u0016$XM]'fCN,(/\u001a#b_\u0006y\u0001O]3e\u001b\u0016\f7/\u001e:fg\u0012\u000bw\u000e\u0005\u0002R)6\t!K\u0003\u0002T\u0001\u0006\u0019A-Y8\n\u0005U\u0013&a\u0004)sK\u0012lU-Y:ve\u0016\u001cH)Y8\u0002\u001f!KHM]8DQJ|g.[2EC>\u0004\"\u0001W/\u000e\u0003eS!AW.\u0002\u000f\rD'o\u001c8jG*\u0011ALQ\u0001\u000bQf$'o\\7fiJL\u0018B\u00010Z\u0005=A\u0015\u0010\u001a:p\u0007\"\u0014xN\\5d\t\u0006|\u0017AE*jK\u0006,\b+\u0019:b[\u0016$XM]:EC>\u0004\"!Y3\u000e\u0003\tT!AS2\u000b\u0005\u0011\u0014\u0015AD1e[&t\u0017n\u001d;sCRLwN\\\u0005\u0003M\n\u0014!cU5fCV\u0004\u0016M]1nKR,'o\u001d#b_\u00061A(\u001b8jiz\"\u0012!\u001b\u000b\tU2lgn\u001c9reB\u00111\u000eA\u0007\u0002\u001f!)1\u0006\u0003a\u0002Y!)!\u0007\u0003a\u0002g!)Q\b\u0003a\u0002}!)a\t\u0003a\u0002\u000f\")q\n\u0003a\u0002!\")a\u000b\u0003a\u0002/\")q\f\u0003a\u0002A\"\u0012\u0001\u0002\u001e\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fa!\u001b8kK\u000e$(\"A=\u0002\u000b)\fg/\u0019=\n\u0005m4(AB%oU\u0016\u001cG/A\u0002ei\u001a,\u0012A \t\u0004\u007f\u0006EQBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\r\u0019|'/\\1u\u0015\u0011\t9!!\u0003\u0002\tQLW.\u001a\u0006\u0005\u0003\u0017\ti!\u0001\u0003k_\u0012\f'BAA\b\u0003\ry'oZ\u0005\u0005\u0003'\t\tAA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\fA\u0001\u001a;gA\u0005!2-\u00197dk2\fG/Z'fi\u0016|g*\u00199qKN$b!a\u0007\u0002.\u0005mB\u0003BA\u000f\u0003G\u00012AGA\u0010\u0013\r\t\tc\u0007\u0002\u0005+:LG\u000fC\u0004\u0002&-\u0001\u001d!a\n\u0002\u001d)|'-\u0012=fGV$\u0018n\u001c8JIB\u0019!$!\u000b\n\u0007\u0005-2D\u0001\u0003M_:<\u0007bBA\u0018\u0017\u0001\u0007\u0011\u0011G\u0001\u0006[>$W\r\u001c\t\u0005\u0003g\t9$\u0004\u0002\u00026)\u0019\u0011q\u0006!\n\t\u0005e\u0012Q\u0007\u0002\u000b\u0013\u0006+\u0015-^'pI\u0016d\u0007bBA\u001f\u0017\u0001\u0007\u0011qH\u0001\u0006a&,'p\u001c\t\u0005\u0003\u0003\n)%\u0004\u0002\u0002D)\u0019\u0011qF&\n\t\u0005\u001d\u00131\t\u0002\u000b!&,'p\\7fi\u0016\u0014\u0018A\u00044pe6\fG/T3bgV\u0014Xm\u001d\u000b\u000b\u0003\u001b\nY'! \u0002\u0012\u0006U\u0005CBA(\u0003?\n)G\u0004\u0003\u0002R\u0005mc\u0002BA*\u00033j!!!\u0016\u000b\u0007\u0005]s#\u0001\u0004=e>|GOP\u0005\u00029%\u0019\u0011QL\u000e\u0002\u000fA\f7m[1hK&!\u0011\u0011MA2\u0005\r\u0019V-\u001d\u0006\u0004\u0003;Z\u0002\u0003BA\u001a\u0003OJA!!\u001b\u00026\tY\u0001K]3e\u001b\u0016\f7/\u001e:f\u0011\u001d\ti\u0007\u0004a\u0001\u0003_\n\u0001\"\\3bgV\u0014Xm\u001d\t\u0007\u0003\u001f\ny&!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e7\u0003\u0011Q7o\u001c8\n\t\u0005m\u0014Q\u000f\u0002\b\u0015N4\u0016\r\\;f\u0011\u001d\ty\b\u0004a\u0001\u0003\u0003\u000b\u0011b]3sS\u0016t\u0015-\\3\u0011\t\u0005\r\u00151\u0012\b\u0005\u0003\u000b\u000b9\tE\u0002\u0002TmI1!!#\u001c\u0003\u0019\u0001&/\u001a3fM&!\u0011QRAH\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011R\u000e\t\u000f\u0005ME\u00021\u0001\u0002\u0002\u0006)1m\u001c7pe\"9\u0011q\u0006\u0007A\u0002\u0005E\u0012!F4fi6+G/Z8OCB\u0004Xm]'pI\u0016d\u0017\n\u001a\u000b\u0005\u00037\u000b9\u000bE\u0003\u001b\u0003;\u000b\t+C\u0002\u0002 n\u0011aa\u00149uS>t\u0007c\u0001\u000e\u0002$&\u0019\u0011QU\u000e\u0003\u0007%sG\u000fC\u0004\u0002*6\u0001\r!!)\u0002\u000f%$\u0007+[3{_\u0002")
public class MeteoNappesController
implements Producer {
    private final WSClient ws;
    private final PiezometerMeasureDao PiezometerMeasureDao;
    private final PredMeasuresDao predMeasuresDao;
    private final HydroChronicDao HydroChronicDao;
    private final SieauParametersDao SieauParametersDao;
    private final DateTimeFormatter dtf;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        MeteoNappesController meteoNappesController = this;
        synchronized (meteoNappesController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public DateTimeFormatter dtf() {
        return this.dtf;
    }

    public void calculateMeteoNappes(IAEauModel model, Piezometer piezo, long jobExecutionId) {
        String logCode = new StringBuilder(2).append(model.typeModel()).append("-").append(piezo.code()).append("-").append(model.idModel()).toString();
        Json$.MODULE$.parse((String)model.params().getOrElse((Function0 & Serializable)() -> "")).validate(MeteoNappesParams$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(45).append("cant validate MeteoNappes model parameters : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), logCode);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)params -> {
            MeteoNappesController.$anonfun$calculateMeteoNappes$3(this, piezo, jobExecutionId, logCode, model, params);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<PredMeasure> formatMeasures(Seq<JsValue> measures, String serieName, String color, IAEauModel model) {
        Seq formated = (Seq)measures.map((Function1 & Serializable)js -> {
            DateTime date = this.dtf().parseDateTime(((String)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(js), "date").get().as((Reads)Reads$.MODULE$.StringReads())).replace("T", ""));
            int x$1 = model.idStation();
            int x$2 = model.typeId();
            DateTime x$3 = date;
            Some x$4 = new Some(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(js), "value").get().as((Reads)Reads$.MODULE$.DoubleReads()));
            Some x$5 = new Some((Object)serieName);
            DateTime x$6 = (DateTime)model.simulationDate().getOrElse((Function0 & Serializable)() -> new DateTime());
            String x$7 = (String)model.updateLogin().getOrElse((Function0 & Serializable)() -> "MeteeauNappes model");
            String x$8 = (String)model.name().getOrElse((Function0 & Serializable)() -> "MeteeauNappes model");
            int x$9 = BoxesRunTime.unboxToInt((Object)model.horizon().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Model MeteeauNappes has no horizon...");
            }));
            String x$10 = (String)model.horizonMode().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Model MeteeauNappes has no horizon mode...");
            });
            int x$11 = Days.daysBetween((ReadablePartial)((DateTime)model.simulationDate().getOrElse((Function0 & Serializable)() -> new DateTime())).toLocalDate(), (ReadablePartial)date.toLocalDate()).getDays();
            Option x$12 = PredMeasure$.MODULE$.$lessinit$greater$default$7();
            Option x$13 = PredMeasure$.MODULE$.$lessinit$greater$default$8();
            Option x$14 = PredMeasure$.MODULE$.$lessinit$greater$default$9();
            Option x$15 = PredMeasure$.MODULE$.$lessinit$greater$default$10();
            DateTime x$16 = PredMeasure$.MODULE$.$lessinit$greater$default$11();
            DateTime x$17 = PredMeasure$.MODULE$.$lessinit$greater$default$12();
            Option x$18 = PredMeasure$.MODULE$.$lessinit$greater$default$14();
            return new PredMeasure(x$1, x$2, x$6, x$3, (Option)x$4, x$8, x$12, x$13, x$14, x$15, x$16, x$17, x$7, x$18, (Option)x$5, x$9, x$10, x$11);
        });
        return IAEauUtils$.MODULE$.applyHackOnCalculatedMeasures((Seq<PredMeasure>)formated, model, this.PiezometerMeasureDao, this.HydroChronicDao);
    }

    public Option<Object> getMeteoNappesModelId(int idPiezo) {
        return JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)Await$.MODULE$.result(this.sendRPC(PiezometryRouting$.MODULE$.PIEZOMETER_MODEL_METEO_NAPPES_ID_READ(), Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)idPiezo), (Writes)Writes$.MODULE$.IntWrites()))})).toString(), (Reads)Reads$.MODULE$.JsValueReads(), (ClassTag)ClassTag$.MODULE$.apply(JsValue.class)), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes())), "modelId").get().asOpt((Reads)Reads$.MODULE$.IntReads());
    }

    public static final /* synthetic */ void $anonfun$calculateMeteoNappes$3(MeteoNappesController $this, Piezometer piezo$1, long jobExecutionId$1, String logCode$1, IAEauModel model$1, MeteoNappesParams params) {
        block7: {
            DateTime endDate;
            DateTime startDate;
            Tuple2 authorization;
            int meteoNappesModelId;
            block10: {
                Option<Object> option;
                block8: {
                    Tuple2 tuple2;
                    block9: {
                        Tuple2 tuple22;
                        Tuple2 tuple23 = new Tuple2((Object)$this.SieauParametersDao.getString("MeteoNappesEmail", $this.SieauParametersDao.getString$default$2()), (Object)$this.SieauParametersDao.getString("MeteoNappesPassword", $this.SieauParametersDao.getString$default$2()));
                        if (tuple23 == null) break block7;
                        Option option2 = (Option)tuple23._1();
                        Option option3 = (Option)tuple23._2();
                        if (!(option2 instanceof Some)) break block7;
                        Some some = (Some)option2;
                        String email = (String)some.value();
                        if (!(option3 instanceof Some)) break block7;
                        Some some2 = (Some)option3;
                        String password = (String)some2.value();
                        option = $this.getMeteoNappesModelId(piezo$1.id());
                        if (None$.MODULE$.equals(option)) {
                            throw new Exception("No MeteoNappes model found");
                        }
                        if (!(option instanceof Some)) break block8;
                        Some some3 = (Some)option;
                        meteoNappesModelId = BoxesRunTime.unboxToInt((Object)some3.value());
                        JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.INFO(), "Authenticating to MeteoNappes...", logCode$1);
                        JsObject json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"email"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)password, (Writes)Writes$.MODULE$.StringWrites()))}));
                        String token = (String)((JsReadable)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(((WSResponse)Await$.MODULE$.result((Awaitable)$this.ws.url("https://api.meteeaunappes.brgm.fr/Authorize/authenticate").withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes()).post((Object)json, play.api.libs.ws.package$.MODULE$.writeableOf_JsValue()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes())).json()), "token").toOption().getOrElse((Function0 & Serializable)() -> {
                            throw new Exception("Error while getting auth token");
                        })).as((Reads)Reads$.MODULE$.StringReads());
                        authorization = new Tuple2((Object)"Authorization", (Object)new StringBuilder(7).append("Bearer ").append(token).toString());
                        String string = params.dateMode();
                        switch (string == null ? 0 : string.hashCode()) {
                            case 95356549: {
                                if (!"dates".equals(string)) break;
                                tuple22 = new Tuple2(params.startDateCalculation().get(), params.endDateCalculation().get());
                                break block9;
                            }
                        }
                        Option<Object> option4 = params.nbMonthCalculation();
                        if (option4 instanceof Some) {
                            Some some4 = (Some)option4;
                            int nbMonth = BoxesRunTime.unboxToInt((Object)some4.value());
                            tuple22 = new Tuple2((Object)new DateTime(), (Object)new DateTime().plusMonths(nbMonth));
                        } else {
                            tuple22 = tuple2 = new Tuple2((Object)new DateTime(), (Object)new DateTime().plusDays(BoxesRunTime.unboxToInt((Object)params.nbDaysCalculation().get())));
                        }
                    }
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    startDate = (DateTime)tuple2._1();
                    endDate = (DateTime)tuple2._2();
                    break block10;
                }
                throw new MatchError(option);
            }
            Tuple2 tuple2 = new Tuple2((Object)startDate, (Object)endDate);
            DateTime startDate2 = (DateTime)tuple2._1();
            DateTime endDate2 = (DateTime)tuple2._2();
            JsObject bodyCompute = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"save"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)false), (Writes)Writes$.MODULE$.BooleanWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateDebut"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(14).append(startDate2.toString("YYYY-MM-dd")).append("T00:00:00.000Z").toString(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFin"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(14).append(endDate2.toString("YYYY-MM-dd")).append("T00:00:00.000Z").toString(), (Writes)Writes$.MODULE$.StringWrites()))}));
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.INFO(), "Recalculate model and getting measures...", logCode$1);
            JsLookupResult allMeasures = JsLookup$.MODULE$.head$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(((WSResponse)Await$.MODULE$.result((Awaitable)$this.ws.url(new StringBuilder(48).append("https://api.meteeaunappes.brgm.fr/Model/compute/").append(meteoNappesModelId).toString()).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes()).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{authorization})).post((Object)bodyCompute, play.api.libs.ws.package$.MODULE$.writeableOf_JsValue()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes())).json()), "result").get().as((Reads)Reads$.MODULE$.JsArrayReads())));
            Seq allSeries = (Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)$this.formatMeasures((Seq<JsValue>)((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(allMeasures), "prev_NoRain").get().as((Reads)Reads$.MODULE$.JsArrayReads())).value().toSeq(), "meteeauNappes_prev_NoRain", "#c71585", model$1).$plus$plus($this.formatMeasures((Seq<JsValue>)((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(allMeasures), "prev_10").get().as((Reads)Reads$.MODULE$.JsArrayReads())).value().toSeq(), "meteeauNappes_prev_10", "#feac15", model$1))).$plus$plus($this.formatMeasures((Seq<JsValue>)((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(allMeasures), "prev_20").get().as((Reads)Reads$.MODULE$.JsArrayReads())).value().toSeq(), "meteeauNappes_prev_20", "#ffd700", model$1))).$plus$plus($this.formatMeasures((Seq<JsValue>)((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(allMeasures), "prev_50").get().as((Reads)Reads$.MODULE$.JsArrayReads())).value().toSeq(), "meteeauNappes_prev_50", "#90ee90", model$1))).$plus$plus($this.formatMeasures((Seq<JsValue>)((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(allMeasures), "prev_80").get().as((Reads)Reads$.MODULE$.JsArrayReads())).value().toSeq(), "meteeauNappes_prev_80", "#00bfff", model$1))).$plus$plus($this.formatMeasures((Seq<JsValue>)((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(allMeasures), "prev_90").get().as((Reads)Reads$.MODULE$.JsArrayReads())).value().toSeq(), "meteeauNappes_prev_90", "#0000cd", model$1));
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(40).append(allSeries.length()).append(" measures received. Begin integration...").toString(), logCode$1);
            int imported = $this.predMeasuresDao.setMeasures(model$1.idStation(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)model$1.idModel())), (Option)new Some(model$1.name().getOrElse((Function0 & Serializable)() -> "MeteeauNappes model")), StationTypeUtil$.MODULE$.PIEZOMETRY(), allSeries, $this.predMeasuresDao.setMeasures$default$6());
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(32).append(imported).append(" measures successfully imported.").toString(), logCode$1);
            return;
        }
        throw new Exception("No Meteau Nappes account. Please set the Meteau Nappes account on admin settings.");
    }

    @Inject
    public MeteoNappesController(LogUtil logUtil, WSClient ws, IAEauCallUtil IAEauCallUtil2, PiezometerMeasureDao PiezometerMeasureDao2, PredMeasuresDao predMeasuresDao, HydroChronicDao HydroChronicDao2, SieauParametersDao SieauParametersDao2) {
        this.ws = ws;
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
        this.predMeasuresDao = predMeasuresDao;
        this.HydroChronicDao = HydroChronicDao2;
        this.SieauParametersDao = SieauParametersDao2;
        Producer.$init$((Producer)this);
        this.dtf = DateTimeFormat.forPattern((String)"YYYY-MM-ddHH:mm:ss");
    }
}

