/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers.calcul.perceptron;

import Alerting.controllers.calcul.perceptron.PerceptronBinding;
import Alerting.controllers.calcul.perceptron.PerceptronBinding$;
import Alerting.controllers.calcul.perceptron.PerceptronParams$;
import Alerting.controllers.calcul.perceptron.SieauStationBinding;
import Alerting.controllers.calcul.perceptron.SieauStationBinding$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.iaeau.IAEauCallUtil;
import fr.aquasys.daeau.iaeau.dao.PredMeasuresDao;
import fr.aquasys.daeau.iaeau.model.AquasysData;
import fr.aquasys.daeau.iaeau.model.AquasysData$;
import fr.aquasys.daeau.iaeau.model.AquasysDataColumn;
import fr.aquasys.daeau.iaeau.model.IAEauBinding;
import fr.aquasys.daeau.iaeau.model.IAEauBindingOutputs;
import fr.aquasys.daeau.iaeau.model.IAEauModel;
import fr.aquasys.daeau.iaeau.model.IAVal;
import fr.aquasys.daeau.iaeau.model.IAVal$;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.iaeau.model.PredMeasure$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.pluviometry.itf.PluvioChronicDao;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.HydrometryUtils$;
import fr.aquasys.utils.PiezometryUtils$;
import fr.aquasys.utils.PluviometryUtils$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import util.IAEauUtils$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ya\b\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!Aa\u0007\u0001B\u0001B\u0003-q\u0007\u0003\u0005?\u0001\t\u0005\t\u0015a\u0003@\u0011!9\u0005A!A!\u0002\u0017A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b1\u0002)\t\u0011Y\u0003!\u0011!Q\u0001\f]C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006YA\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0006M\")\u0011\u000f\u0001C\u0001e\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBAA\u0001\u0011\u0005\u00111\u0011\u0002\u0010!\u0016\u00148-\u001a9ue>tWj\u001c3fY*\u0011q\u0002E\u0001\u000ba\u0016\u00148-\u001a9ue>t'BA\t\u0013\u0003\u0019\u0019\u0017\r\\2vY*\u00111\u0003F\u0001\fG>tGO]8mY\u0016\u00148OC\u0001\u0016\u0003!\tE.\u001a:uS:<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003A%j\u0011!\t\u0006\u0003E\r\nA!\u001e;jY*\u0011A%J\u0001\te\u0006\u0014'-\u001b;nc*\u0011aeJ\u0001\bCF,\u0018m]=t\u0015\u0005A\u0013A\u00014s\u0013\tQ\u0013EA\u0004M_\u001e,F/\u001b7\u0002)AKWM_8nKR,'/T3bgV\u0014X\rR1p!\tiC'D\u0001/\u0015\ty\u0003'A\u0002ji\u001aT!!\r\u001a\u0002\u0015ALWM_8nKR\u0014\u0018P\u0003\u00024K\u0005)A-Y3bk&\u0011QG\f\u0002\u0015!&,'p\\7fi\u0016\u0014X*Z1tkJ,G)Y8\u0002%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\u001c\t\u0003qqj\u0011!\u000f\u0006\u0003_iR!a\u000f\u001a\u0002\u001d\u0005$W.\u001b8jgR\u0014\u0018\r^5p]&\u0011Q(\u000f\u0002\u0013'&,\u0017-\u001e)be\u0006lW\r^3sg\u0012\u000bw.A\bis\u0012\u0014xn\u00115s_:L7\rR1p!\t\u0001U)D\u0001B\u0015\t\u00115)A\u0004dQJ|g.[2\u000b\u0005\u0011\u0013\u0014A\u00035zIJ|W.\u001a;ss&\u0011a)\u0011\u0002\u0010\u0011f$'o\\\"ie>t\u0017n\u0019#b_\u0006\u0001\u0002\u000f\\;wS>\u001c\u0005N]8oS\u000e$\u0015m\u001c\t\u0003\u00136k\u0011A\u0013\u0006\u0003_-S!\u0001\u0014\u001a\u0002\u0017AdWO^5p[\u0016$(/_\u0005\u0003\u001d*\u0013\u0001\u0003\u00157vm&|7\t\u001b:p]&\u001cG)Y8\u0002\u001b%\u000bU)Y;DC2dW\u000b^5m!\t\tF+D\u0001S\u0015\t\u0019&'A\u0003jC\u0016\fW/\u0003\u0002V%\ni\u0011*Q#bk\u000e\u000bG\u000e\\+uS2\fq\u0002\u001d:fI6+\u0017m];sKN$\u0015m\u001c\t\u00031nk\u0011!\u0017\u0006\u00035J\u000b1\u0001Z1p\u0013\ta\u0016LA\bQe\u0016$W*Z1tkJ,7\u000fR1p\u0003-!\u0015\r^1UsB,G)Y8\u0011\u0005}\u001bW\"\u00011\u000b\u0005=\n'B\u000123\u0003\u001d\u0019H/\u0019;j_:L!\u0001\u001a1\u0003\u0017\u0011\u000bG/\u0019+za\u0016$\u0015m\\\u0001\u0003oN\u0004\"aZ8\u000e\u0003!T!!Z5\u000b\u0005)\\\u0017\u0001\u00027jENT!\u0001\\7\u0002\u0007\u0005\u0004\u0018NC\u0001o\u0003\u0011\u0001H.Y=\n\u0005AD'\u0001C,T\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\u0005\u0019HC\u0003;wobL(p\u001f?~}B\u0011Q\u000fA\u0007\u0002\u001d!)aD\u0003a\u0002?!)1F\u0003a\u0002Y!)aG\u0003a\u0002o!)aH\u0003a\u0002\u007f!)qI\u0003a\u0002\u0011\")qJ\u0003a\u0002!\")aK\u0003a\u0002/\")QL\u0003a\u0002=\")QM\u0003a\u0002M\"\u001a!\"!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u00051\u0011N\u001c6fGRT!!a\u0003\u0002\u000b)\fg/\u0019=\n\t\u0005=\u0011Q\u0001\u0002\u0007\u0013:TWm\u0019;\u0002'\r\fGnY;mCR,\u0007+\u001a:dKB$(o\u001c8\u0015\u0019\u0005U\u0011\u0011HA!\u0003+\nI&!\u001b\u0011\r\u0005]\u0011qEA\u0017\u001d\u0011\tI\"a\t\u000f\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\u0017\u0003\u0019a$o\\8u}%\t1$C\u0002\u0002&i\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\u0005-\"aA*fc*\u0019\u0011Q\u0005\u000e\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rS\u0003\u0015iw\u000eZ3m\u0013\u0011\t9$!\r\u0003\u0017A\u0013X\rZ'fCN,(/\u001a\u0005\b\u0003gY\u0001\u0019AA\u001e!\u0011\ty#!\u0010\n\t\u0005}\u0012\u0011\u0007\u0002\u000b\u0013\u0006+\u0015-^'pI\u0016d\u0007bBA\"\u0017\u0001\u0007\u0011QI\u0001\bY><7i\u001c3f!\u0011\t9%a\u0014\u000f\t\u0005%\u00131\n\t\u0004\u00037Q\u0012bAA'5\u00051\u0001K]3eK\u001aLA!!\u0015\u0002T\t11\u000b\u001e:j]\u001eT1!!\u0014\u001b\u0011\u001d\t9f\u0003a\u0001\u0003\u000b\n1b\u001d;bi&|gnQ8eK\"9\u00111L\u0006A\u0002\u0005u\u0013A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u00063\u0005}\u00131M\u0005\u0004\u0003CR\"AB(qi&|g\u000eE\u0002\u001a\u0003KJ1!a\u001a\u001b\u0005\u0011auN\\4\t\u000f\u0005-4\u00021\u0001\u0002n\u0005q1/[7vY\u0006$\u0018n\u001c8ECR,\u0007\u0003BA8\u0003{j!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0005i&lWM\u0003\u0003\u0002x\u0005e\u0014\u0001\u00026pI\u0006T!!a\u001f\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0000\u0005E$\u0001\u0003#bi\u0016$\u0016.\\3\u0002\u001f\u001d,G\u000f\u0015:fI6+\u0017m];sKN$b\"!\"\u0002\u0010\u0006U\u0015\u0011TAO\u0003O\u000bY\u000b\u0005\u0004\u0002\u0018\u0005\u001d\u0012q\u0011\t\u0007\u0003/\t9#!#\u0011\t\u0005=\u00121R\u0005\u0005\u0003\u001b\u000b\tDA\u0003J\u0003Z\u000bG\u000eC\u0004\u0002\u00122\u0001\r!a%\u0002\u00171\f7\u000f^(cg\u0012\u000bG/\u001a\t\u00063\u0005}\u0013Q\u000e\u0005\b\u0003/c\u0001\u0019AA7\u0003\u001di\u0017\r\u001f#bi\u0016Dq!a'\r\u0001\u0004\ti'\u0001\bnCb$\u0015\r^3Ti\u0006$\u0018n\u001c8\t\u000f\u0005}E\u00021\u0001\u0002\"\u0006I\u0011\u000eZ*uCRLwN\u001c\t\u00043\u0005\r\u0016bAAS5\t\u0019\u0011J\u001c;\t\u000f\u0005%F\u00021\u0001\u0002\"\u00061A/\u001f9f\u0013\u0012Dq!!,\r\u0001\u0004\t)%A\u0006ti\u0006$\u0018n\u001c8UsB,\u0007f\u0001\u0001\u00022B!\u00111AAZ\u0013\u0011\t),!\u0002\u0003\u0013MKgn\u001a7fi>t\u0007")
public class PerceptronModel {
    private final LogUtil logUtil;
    private final PiezometerMeasureDao PiezometerMeasureDao;
    private final SieauParametersDao SieauParametersDao;
    private final HydroChronicDao hydroChronicDao;
    private final PluvioChronicDao pluvioChronicDao;
    private final IAEauCallUtil IAEauCallUtil;
    private final PredMeasuresDao predMeasuresDao;
    private final DataTypeDao DataTypeDao;

    public Seq<PredMeasure> calculatePerceptron(IAEauModel model, String logCode, String stationCode, Option<Object> jobExecutionId, DateTime simulationDate) {
        return (Seq)Json$.MODULE$.parse((String)model.params().getOrElse((Function0 & Serializable)() -> "")).validate(PerceptronParams$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            Option option = jobExecutionId;
            if (option instanceof Some) {
                Some some = (Some)option;
                long je = BoxesRunTime.unboxToLong((Object)some.value());
                JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.ERROR(), new StringBuilder(44).append("cant validate perceptron model parameters : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), logCode);
                return (Seq)Nil$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(44).append("cant validate perceptron model parameters : ").append(JsError$.MODULE$.toJson(error).toString()).toString());
            }
            throw new MatchError((Object)option);
        }, (Function1 & Serializable)params -> {
            int n;
            Option option;
            Seq bindings = (Seq)$this.IAEauCallUtil.callIAEauBindings((String)model.chainCode().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Can't find chain code");
            })).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Error while fetching bindings");
            });
            PerceptronBinding perceptronBinding = (PerceptronBinding)((IAEauBinding)bindings.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PerceptronModel.$anonfun$calculatePerceptron$6(x$1))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Can't find perceptron binding");
            })).binding().validate(PerceptronBinding$.MODULE$.format()).asOpt().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Can't parse perceptron binding");
            });
            Seq sieauStationBindings = (Seq)((IterableOps)bindings.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PerceptronModel.$anonfun$calculatePerceptron$9(x$2)))).map((Function1 & Serializable)b -> new Tuple2(b, b.binding().validate(SieauStationBinding$.MODULE$.format()).asOpt().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Can't parse SieauStation binding");
            })));
            SieauStationBinding thisModelStationBinding = (SieauStationBinding)((Tuple2)sieauStationBindings.find((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)PerceptronModel.$anonfun$calculatePerceptron$12(model, b))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Can't find SieauStation pi\u00e9zo binding");
            }))._2();
            int coeff = thisModelStationBinding.group().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("WEEK"))) ? 7 : 1;
            Map typesPiezo = ((IterableOnceOps)$this.DataTypeDao.getPiezoDataTypes().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((int)d.id()))), d.name().getOrElse((Function0 & Serializable)() -> "")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map typesHydro = ((IterableOnceOps)$this.DataTypeDao.getHydroDataTypes().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((int)d.id()))), d.name().getOrElse((Function0 & Serializable)() -> "")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map typesPluvio = ((IterableOnceOps)$this.DataTypeDao.getPluvioDataTypes().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((int)d.id()))), d.name().getOrElse((Function0 & Serializable)() -> "")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(perceptronBinding.minFrame(), perceptronBinding.maxFrame());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int minFrame = sp2._1$mcI$sp();
            int maxFrame = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(minFrame, maxFrame);
            int minFrame2 = sp3._1$mcI$sp();
            int maxFrame2 = sp3._2$mcI$sp();
            String string = StationTypeUtil$.MODULE$.StationType(model.stationType());
            String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                option = $this.PiezometerMeasureDao.getLastMeasures((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{model.idStation()})), model.typeId(), $this.PiezometerMeasureDao.getLastMeasures$default$3()).headOption().map((Function1 & Serializable)x$5 -> x$5.date());
            } else {
                String string4 = StationTypeUtil$.MODULE$.HYDROMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    option = $this.hydroChronicDao.getLastMeasureDate(model.idStation(), model.typeId());
                } else {
                    throw new MatchError((Object)string);
                }
            }
            DateTime lastStationMeasureDate = (DateTime)option.getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No station measures found...");
            });
            DateTime maxDateStation = (DateTime)new .colon.colon((Object)simulationDate, (List)new .colon.colon((Object)lastStationMeasureDate, (List)Nil$.MODULE$)).minBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getMillis()), (Ordering)Ordering.Long$.MODULE$);
            DateTime minDateTmp = maxDateStation.plusDays(minFrame2 * coeff - BoxesRunTime.unboxToInt((Object)model.horizon().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) + 1);
            DateTime minDate = coeff == 7 ? minDateTmp.withDayOfWeek(1) : minDateTmp;
            DateTime maxDateTmp = maxDateStation.plusDays(Math.abs(maxFrame2 * coeff));
            DateTime maxDate = coeff == 7 ? maxDateTmp.withDayOfWeek(7) : maxDateTmp;
            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), new StringBuilder(33).append("Frames are : ").append(minFrame2).append(" -> ").append(maxFrame2).append(", dates are ").append(DateUtil$.MODULE$.getDate(minDate)).append(" -> ").append(DateUtil$.MODULE$.getDate(maxDate)).toString(), logCode));
            Seq inputs = (Seq)sieauStationBindings.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq seq;
                    Tuple2 tuple22;
                    IAEauBinding binding = (IAEauBinding)tuple2._1();
                    SieauStationBinding stationBinding = (SieauStationBinding)tuple2._2();
                    String string = StationTypeUtil$.MODULE$.StationType(stationBinding.typeStation());
                    String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        int x$1 = stationBinding.idStation();
                        int x$2 = stationBinding.typeId();
                        Some x$3 = new Some((Object)minDate);
                        Some x$4 = new Some((Object)maxDate);
                        Some x$5 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)stationBinding.validOnly()));
                        Option<String> x$6 = stationBinding.group();
                        String x$72 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
                        Seq x$82 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                        Option x$92 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                        Option x$10 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                        Option x$11 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                        Option x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                        Option x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                        Option x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                        Option x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                        Option x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                        Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                        Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                        Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                        Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                        Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
                        Option x$22 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
                        Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
                        Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
                        Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
                        Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                        Seq obs = PiezometryUtils$.MODULE$.getPiezoMeasures(new MeasuresParams(x$72, x$1, x$82, x$2, x$92, (Option)x$3, (Option)x$4, (Option)x$5, x$10, x$11, x$6, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26), $this.PiezometerMeasureDao, $this.SieauParametersDao);
                        Seq<Seq<IAVal>> pred = this.getPredMeasures((Option<DateTime>)obs.lastOption().map((Function1 & Serializable)x$7 -> x$7.date()), maxDate, maxDateStation, stationBinding.idStation(), stationBinding.typeId(), stationBinding.typeStation());
                        tuple22 = new Tuple2(((IterableOps)obs.map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(stationBinding.typeId() == -1 ? m.NGF() : m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)))).$plus$plus(pred), typesPiezo.getOrElse((Object)BoxesRunTime.boxToInteger((int)stationBinding.typeId()), (Function0 & Serializable)() -> {
                            throw new Exception(new StringBuilder(26).append("Can't find piezo datatype ").append(stationBinding.typeId()).toString());
                        }));
                    } else {
                        String string4 = StationTypeUtil$.MODULE$.HYDROMETRY();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            int x$27 = stationBinding.idStation();
                            int x$28 = stationBinding.typeId();
                            Some x$29 = new Some((Object)minDate);
                            Some x$30 = new Some((Object)maxDate);
                            Some x$31 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)stationBinding.validOnly()));
                            Option<String> x$32 = stationBinding.group();
                            String x$33 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
                            Seq x$34 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                            Option x$35 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                            Option x$36 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                            Option x$37 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                            Option x$38 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                            Option x$39 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                            Option x$40 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                            Option x$41 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                            Option x$42 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                            Option x$43 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                            Option x$44 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                            Option x$45 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                            Option x$46 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                            Option x$47 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
                            Option x$48 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
                            Option x$49 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
                            Option x$50 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
                            Option x$51 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
                            Option x$52 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                            Seq obs = HydrometryUtils$.MODULE$.getHydroMeasures(new MeasuresParams(x$33, x$27, x$34, x$28, x$35, (Option)x$29, (Option)x$30, (Option)x$31, x$36, x$37, x$32, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52), $this.hydroChronicDao, $this.SieauParametersDao);
                            Seq<Seq<IAVal>> pred = this.getPredMeasures((Option<DateTime>)obs.lastOption().map((Function1 & Serializable)x$8 -> x$8.date()), maxDate, maxDateStation, stationBinding.idStation(), stationBinding.typeId(), stationBinding.typeStation());
                            tuple22 = new Tuple2(((IterableOps)obs.map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)))).$plus$plus(pred), typesHydro.getOrElse((Object)BoxesRunTime.boxToInteger((int)stationBinding.typeId()), (Function0 & Serializable)() -> {
                                throw new Exception(new StringBuilder(26).append("Can't find hydro datatype ").append(stationBinding.typeId()).toString());
                            }));
                        } else {
                            String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                            String string7 = string;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                int x$53 = stationBinding.idStation();
                                int x$54 = stationBinding.typeId();
                                Some x$55 = new Some((Object)minDate);
                                Some x$56 = new Some((Object)maxDate);
                                Some x$57 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)stationBinding.validOnly()));
                                Option<String> x$58 = stationBinding.group();
                                String x$59 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
                                Seq x$60 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                                Option x$61 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                                Option x$62 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                                Option x$63 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                                Option x$64 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                                Option x$65 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                                Option x$66 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                                Option x$67 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                                Option x$68 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                                Option x$69 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                                Option x$70 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                                Option x$71 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                                Option x$72 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                                Option x$73 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
                                Option x$74 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
                                Option x$75 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
                                Option x$76 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
                                Option x$77 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
                                Option x$78 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                                Seq obs = PluviometryUtils$.MODULE$.getPluvioMeasures(new MeasuresParams(x$59, x$53, x$60, x$54, x$61, (Option)x$55, (Option)x$56, (Option)x$57, x$62, x$63, x$58, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78), $this.pluvioChronicDao, $this.SieauParametersDao, $this.DataTypeDao);
                                Seq<Seq<IAVal>> pred = this.getPredMeasures((Option<DateTime>)obs.lastOption().map((Function1 & Serializable)x$9 -> x$9.date()), maxDate, maxDateStation, stationBinding.idStation(), stationBinding.typeId(), stationBinding.typeStation());
                                tuple22 = new Tuple2(((IterableOps)obs.map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)))).$plus$plus(pred), typesPluvio.getOrElse((Object)BoxesRunTime.boxToInteger((int)stationBinding.typeId()), (Function0 & Serializable)() -> {
                                    throw new Exception(new StringBuilder(26).append("Can't find hydro datatype ").append(stationBinding.typeId()).toString());
                                }));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                    Tuple2 tuple23 = tuple22;
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Seq measures = (Seq)tuple23._1();
                    String typeName = (String)tuple23._2();
                    Tuple2 tuple24 = new Tuple2((Object)measures, (Object)typeName);
                    Seq measures2 = (Seq)tuple24._1();
                    String typeName2 = (String)tuple24._2();
                    jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, measures2.isEmpty() ? JobState$.MODULE$.ERROR() : JobState$.MODULE$.INFO(), new StringBuilder(41).append("Sending ").append(measures2.length()).append(" measures for station ").append(stationBinding.typeStation()).append(" ").append(stationBinding.idStation()).append(" and type ").append(typeName2).toString(), logCode));
                    if ((long)BoxesRunTime.unboxToDouble((Object)((IAVal)((IterableOps)measures2.head()).head()).value().get()) < minDate.getMillis()) {
                        .colon.colon colon2 = new .colon.colon((Object)new IAVal((double)minDate.getMillis()), (List)new .colon.colon((Object)new IAVal(BoxesRunTime.unboxToDouble((Object)((IAVal)((SeqOps)measures2.head()).apply(1)).value().get())), (List)Nil$.MODULE$));
                        seq = (Seq)((SeqOps)measures2.tail()).$plus$colon((Object)colon2);
                    } else {
                        seq = measures2;
                    }
                    Seq correctedMeasuresStart = seq;
                    Seq correctedMeasures = (long)BoxesRunTime.unboxToDouble((Object)((IAVal)((IterableOps)correctedMeasuresStart.last()).head()).value().get()) > maxDate.getMillis() ? (Seq)((SeqOps)correctedMeasuresStart.dropRight(1)).$colon$plus((Object)new .colon.colon((Object)new IAVal((double)maxDate.getMillis()), (List)new .colon.colon((Object)new IAVal(BoxesRunTime.unboxToDouble((Object)((IAVal)((SeqOps)correctedMeasuresStart.last()).apply(1)).value().get())), (List)Nil$.MODULE$))) : correctedMeasuresStart;
                    int x$79 = ((IAEauBindingOutputs)binding.outputs().head()).idIO();
                    .colon.colon x$80 = new .colon.colon((Object)new AquasysDataColumn(1, "Date", "date"), (List)new .colon.colon((Object)new AquasysDataColumn(2, "Valeur", "number"), (List)Nil$.MODULE$));
                    Seq x$81 = correctedMeasures;
                    Some x$82 = new Some((Object)new StringBuilder(2).append(stationBinding.typeStation()).append(":").append(stationBinding.idStation()).append(":").append(stationBinding.typeId()).toString());
                    Option x$83 = AquasysData$.MODULE$.apply$default$2();
                    Option x$84 = AquasysData$.MODULE$.apply$default$5();
                    Option x$85 = AquasysData$.MODULE$.apply$default$7();
                    Option x$86 = AquasysData$.MODULE$.apply$default$8();
                    Option x$87 = AquasysData$.MODULE$.apply$default$9();
                    Option x$88 = AquasysData$.MODULE$.apply$default$10();
                    Option x$89 = AquasysData$.MODULE$.apply$default$11();
                    return new AquasysData(x$79, x$83, (Seq)x$80, (Option)x$82, x$84, x$81, x$85, x$86, x$87, x$88, x$89);
                }
                throw new MatchError((Object)tuple2);
            });
            $this.logUtil.info(((IterableOnceOps)inputs.map((Function1 & Serializable)i -> i.name())).mkString("\n"), $this.logUtil.info$default$2());
            Seq endingNodes = (Seq)bindings.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PerceptronModel.$anonfun$calculatePerceptron$38(x$11)));
            int n2 = ((IAEauBinding)endingNodes.head()).aquanodeId();
            switch (n2) {
                case 8: {
                    n = perceptronBinding.outputId();
                    break;
                }
                default: {
                    n = ((IAEauBindingOutputs)((IAEauBinding)endingNodes.head()).outputs().head()).idIO();
                    break;
                }
            }
            int outputId = n;
            JsObject input = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overrideInputNodes"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson(sieauStationBindings.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)PerceptronModel.$anonfun$calculatePerceptron$39(x$12))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputsToTake"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{outputId})), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputs"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)inputs, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)AquasysData$.MODULE$.formatAquasysData())), Writes$.MODULE$.jsValueWrites()))}));
            $this.logUtil.error(input.toString(), $this.logUtil.error$default$2());
            Seq results = $this.IAEauCallUtil.callIAEau((String)model.chainCode().get(), input, stationCode, logCode, jobExecutionId, $this.IAEauCallUtil.callIAEau$default$6(), $this.IAEauCallUtil.callIAEau$default$7(), $this.IAEauCallUtil.callIAEau$default$8());
            Seq measures = (Seq)((SeqOps)((AquasysData)IAEauUtils$.MODULE$.getAquasysDataOption((Seq<AquasysData>)results, "Results.csv").getOrElse((Function0 & Serializable)() -> IAEauUtils$.MODULE$.getAquasysData((Seq<AquasysData>)results, "compiledResults.csv"))).data().map((Function1 & Serializable)d -> {
                int x$90 = model.idStation();
                int x$91 = model.typeId();
                DateTime x$92 = new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get()));
                Option x$93 = ((IAVal)d.apply(1)).value();
                Option x$94 = ((IAVal)d.apply(2)).value();
                Option x$95 = ((IAVal)d.apply(3)).value();
                DateTime x$96 = simulationDate;
                String x$97 = (String)model.updateLogin().getOrElse((Function0 & Serializable)() -> "Preceptron model");
                String x$98 = (String)model.name().getOrElse((Function0 & Serializable)() -> "Preceptron model");
                int x$99 = BoxesRunTime.unboxToInt((Object)model.horizon().getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("Model Preceptron has no horizon...");
                }));
                String x$100 = (String)model.horizonMode().getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("Model Preceptron has no horizon mode...");
                });
                int x$101 = IAEauUtils$.MODULE$.getHorizon(model, simulationDate, new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get())));
                Option x$102 = PredMeasure$.MODULE$.$lessinit$greater$default$7();
                Option x$103 = PredMeasure$.MODULE$.$lessinit$greater$default$10();
                DateTime x$104 = PredMeasure$.MODULE$.$lessinit$greater$default$11();
                DateTime x$105 = PredMeasure$.MODULE$.$lessinit$greater$default$12();
                Option x$106 = PredMeasure$.MODULE$.$lessinit$greater$default$14();
                Option x$107 = PredMeasure$.MODULE$.$lessinit$greater$default$15();
                return new PredMeasure(x$90, x$91, x$96, x$92, x$93, x$98, x$102, x$94, x$95, x$103, x$104, x$105, x$97, x$106, x$107, x$99, x$100, x$101);
            })).sortBy((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)PerceptronModel.$anonfun$calculatePerceptron$46(x$13)), (Ordering)Ordering.Long$.MODULE$);
            Seq<PredMeasure> hackedMeasures = IAEauUtils$.MODULE$.applyHackOnCalculatedMeasures((Seq<PredMeasure>)measures, model, $this.PiezometerMeasureDao, $this.hydroChronicDao);
            Option option2 = jobExecutionId;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                long je2 = BoxesRunTime.unboxToLong((Object)some.value());
                JobLogUtil$.MODULE$.log(je2, JobState$.MODULE$.INFO(), new StringBuilder(51).append(hackedMeasures.length()).append(" calculated measures received. Begin integration...").toString(), logCode);
                int imported = $this.predMeasuresDao.setMeasures(model.idStation(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)model.idModel())), (Option)new Some(model.name().getOrElse((Function0 & Serializable)() -> "Preceptron model")), model.stationType(), hackedMeasures, $this.predMeasuresDao.setMeasures$default$6());
                JobLogUtil$.MODULE$.log(je2, JobState$.MODULE$.SUCCESS(), new StringBuilder(32).append(imported).append(" measures successfully imported.").toString(), logCode);
                return (Seq)Nil$.MODULE$;
            }
            if (None$.MODULE$.equals(option2)) {
                return hackedMeasures;
            }
            throw new MatchError((Object)option2);
        });
    }

    public Seq<Seq<IAVal>> getPredMeasures(Option<DateTime> lastObsDate, DateTime maxDate, DateTime maxDateStation, int idStation, int typeId, String stationType) {
        return (Seq)(lastObsDate.isEmpty() || DateUtil$.MODULE$.setMaxDay((DateTime)lastObsDate.get()).getMillis() > maxDate.withTimeAtStartOfDay().getMillis() ? Nil$.MODULE$ : this.predMeasuresDao.getMeasuresWithMinHorizon(idStation, typeId, stationType, (Option)new Some((Object)(lastObsDate.isEmpty() ? maxDateStation : ((DateTime)lastObsDate.get()).plusDays(1))), (Option)new Some((Object)maxDate), this.predMeasuresDao.getMeasuresWithMinHorizon$default$6(), this.predMeasuresDao.getMeasuresWithMinHorizon$default$7())).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptron$6(IAEauBinding x$1) {
        return x$1.aquanodeId() == 8;
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptron$9(IAEauBinding x$2) {
        return x$2.aquanodeId() == 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$calculatePerceptron$12(IAEauModel model$1, Tuple2 b) {
        if (((SieauStationBinding)b._2()).idStation() != model$1.idStation()) return false;
        String string = StationTypeUtil$.MODULE$.StationType(((SieauStationBinding)b._2()).typeStation());
        String string2 = StationTypeUtil$.MODULE$.StationType(model$1.stationType());
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (((SieauStationBinding)b._2()).typeId() != model$1.typeId()) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptron$38(IAEauBinding x$11) {
        return x$11.nextNodes().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$calculatePerceptron$39(Tuple2 x$12) {
        return ((IAEauBinding)x$12._1()).id();
    }

    public static final /* synthetic */ long $anonfun$calculatePerceptron$46(PredMeasure x$13) {
        return x$13.date().getMillis();
    }

    @Inject
    public PerceptronModel(LogUtil logUtil, PiezometerMeasureDao PiezometerMeasureDao2, SieauParametersDao SieauParametersDao2, HydroChronicDao hydroChronicDao, PluvioChronicDao pluvioChronicDao, IAEauCallUtil IAEauCallUtil2, PredMeasuresDao predMeasuresDao, DataTypeDao DataTypeDao2, WSClient ws) {
        this.logUtil = logUtil;
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
        this.SieauParametersDao = SieauParametersDao2;
        this.hydroChronicDao = hydroChronicDao;
        this.pluvioChronicDao = pluvioChronicDao;
        this.IAEauCallUtil = IAEauCallUtil2;
        this.predMeasuresDao = predMeasuresDao;
        this.DataTypeDao = DataTypeDao2;
    }
}

