/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers.calcul.perceptronGeneric;

import Alerting.controllers.calcul.perceptronGeneric.PerceptronGenericParams;
import Alerting.controllers.calcul.perceptronGeneric.PerceptronGenericParams$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.iaeau.IAEauCallUtil;
import fr.aquasys.daeau.iaeau.dao.PredMeasuresDao;
import fr.aquasys.daeau.iaeau.model.AquasysData;
import fr.aquasys.daeau.iaeau.model.AquasysData$;
import fr.aquasys.daeau.iaeau.model.AquasysDataColumn;
import fr.aquasys.daeau.iaeau.model.IAEauModel;
import fr.aquasys.daeau.iaeau.model.IAVal;
import fr.aquasys.daeau.iaeau.model.IAVal$;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.iaeau.model.PredMeasure$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.model.measure.PiezometerChronicRawMeasure;
import fr.aquasys.daeau.pluviometry.itf.PluvioChronicDao;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed;
import fr.aquasys.daeau.station.model.DataType;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.PiezometryUtils$;
import fr.aquasys.utils.PluviometryUtils$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.IAEauUtils$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ya\b\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!Aa\u0007\u0001B\u0001B\u0003-q\u0007\u0003\u0005?\u0001\t\u0005\t\u0015a\u0003@\u0011!9\u0005A!A!\u0002\u0017A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b1\u0002)\t\u0011Y\u0003!\u0011!Q\u0001\f]C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006YA\u0018\u0005\tQ\u0002\u0011\t\u0011)A\u0006S\"AA\u000f\u0001B\u0001B\u0003-Q\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002&\u0001!\t!a\n\u0003-A+'oY3qiJ|gnR3oKJL7-T8eK2T!a\u0004\t\u0002#A,'oY3qiJ|gnR3oKJL7M\u0003\u0002\u0012%\u000511-\u00197dk2T!a\u0005\u000b\u0002\u0017\r|g\u000e\u001e:pY2,'o\u001d\u0006\u0002+\u0005A\u0011\t\\3si&twm\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005\u0001JS\"A\u0011\u000b\u0005\t\u001a\u0013\u0001B;uS2T!\u0001J\u0013\u0002\u0011I\f'MY5u[FT!AJ\u0014\u0002\u000f\u0005\fX/Y:zg*\t\u0001&\u0001\u0002ge&\u0011!&\t\u0002\b\u0019><W\u000b^5m\u0003Q\u0001\u0016.\u001a>p[\u0016$XM]'fCN,(/\u001a#b_B\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0004SR4'BA\u00193\u0003)\u0001\u0018.\u001a>p[\u0016$(/\u001f\u0006\u0003g\u0015\nQ\u0001Z1fCVL!!\u000e\u0018\u0003)AKWM_8nKR,'/T3bgV\u0014X\rR1p\u0003I\u0019\u0016.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005abT\"A\u001d\u000b\u0005=R$BA\u001e3\u00039\tG-\\5oSN$(/\u0019;j_:L!!P\u001d\u0003%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\\\u0001\u0010Qf$'o\\\"ie>t\u0017n\u0019#b_B\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\bG\"\u0014xN\\5d\u0015\t!%'\u0001\u0006is\u0012\u0014x.\\3uefL!AR!\u0003\u001f!KHM]8DQJ|g.[2EC>\f\u0001\u0003\u001d7vm&|7\t\u001b:p]&\u001cG)Y8\u0011\u0005%kU\"\u0001&\u000b\u0005=Z%B\u0001'3\u0003-\u0001H.\u001e<j_6,GO]=\n\u00059S%\u0001\u0005)mkZLwn\u00115s_:L7\rR1p\u00035I\u0015)R1v\u0007\u0006dG.\u0016;jYB\u0011\u0011\u000bV\u0007\u0002%*\u00111KM\u0001\u0006S\u0006,\u0017-^\u0005\u0003+J\u0013Q\"S!FCV\u001c\u0015\r\u001c7Vi&d\u0017a\u00049sK\u0012lU-Y:ve\u0016\u001cH)Y8\u0011\u0005a[V\"A-\u000b\u0005i\u0013\u0016a\u00013b_&\u0011A,\u0017\u0002\u0010!J,G-T3bgV\u0014Xm\u001d#b_\u0006q1\u000b^1uS>tG*\u001b8l\t\u0006|\u0007CA0g\u001b\u0005\u0001'BA1c\u0003-\u0019H/\u0019;j_:d\u0017N\\6\u000b\u0005\r$\u0017!\u00027j].\u001c(BA33\u0003\u001d\u0019H/\u0019;j_:L!a\u001a1\u0003\u001dM#\u0018\r^5p]2Kgn\u001b#b_\u0006\u0011qo\u001d\t\u0003UJl\u0011a\u001b\u0006\u0003Q2T!!\u001c8\u0002\t1L'm\u001d\u0006\u0003_B\f1!\u00199j\u0015\u0005\t\u0018\u0001\u00029mCfL!a]6\u0003\u0011]\u001b6\t\\5f]R\f1\u0002R1uCRK\b/\u001a#b_B\u0011a\u000f_\u0007\u0002o*\u0011q\u0006Z\u0005\u0003s^\u00141\u0002R1uCRK\b/\u001a#b_\u00061A(\u001b8jiz\"\u0012\u0001 \u000b\u0015{~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0011\u0005y\u0004Q\"\u0001\b\t\u000byY\u00019A\u0010\t\u000b-Z\u00019\u0001\u0017\t\u000bYZ\u00019A\u001c\t\u000byZ\u00019A \t\u000b\u001d[\u00019\u0001%\t\u000b=[\u00019\u0001)\t\u000bY[\u00019A,\t\u000bu[\u00019\u00010\t\u000b!\\\u00019A5\t\u000bQ\\\u00019A;)\u0007-\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\r%t'.Z2u\u0015\t\ty\"A\u0003kCZ\f\u00070\u0003\u0003\u0002$\u0005e!AB%oU\u0016\u001cG/\u0001\u000edC2\u001cW\u000f\\1uKB+'oY3qiJ|gnR3oKJL7\r\u0006\u0006\u0002*\u00055\u0013QKA5\u0003s\u0002b!a\u000b\u0002<\u0005\u0005c\u0002BA\u0017\u0003oqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g1\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\r\tIDG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0007M+\u0017OC\u0002\u0002:i\u0001B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\u0012\u0016!B7pI\u0016d\u0017\u0002BA&\u0003\u000b\u00121\u0002\u0015:fI6+\u0017m];sK\"9\u0011q\t\u0007A\u0002\u0005=\u0003\u0003BA\"\u0003#JA!a\u0015\u0002F\tQ\u0011*Q#bk6{G-\u001a7\t\u000f\u0005]C\u00021\u0001\u0002Z\u00059An\\4D_\u0012,\u0007\u0003BA.\u0003GrA!!\u0018\u0002`A\u0019\u0011q\u0006\u000e\n\u0007\u0005\u0005$$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\n9G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003CR\u0002bBA6\u0019\u0001\u0007\u0011QN\u0001\u000fU>\u0014W\t_3dkRLwN\\%e!\u0015I\u0012qNA:\u0013\r\t\tH\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007e\t)(C\u0002\u0002xi\u0011A\u0001T8oO\"9\u00111\u0010\u0007A\u0002\u0005u\u0014AD:j[Vd\u0017\r^5p]\u0012\u000bG/\u001a\t\u0005\u0003\u007f\ni)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0011!\u0018.\\3\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0005U>$\u0017M\u0003\u0002\u0002\f\u0006\u0019qN]4\n\t\u0005=\u0015\u0011\u0011\u0002\t\t\u0006$X\rV5nK\u0002")
public class PerceptronGenericModel {
    private final PiezometerMeasureDao PiezometerMeasureDao;
    private final SieauParametersDao SieauParametersDao;
    private final HydroChronicDao hydroChronicDao;
    private final PluvioChronicDao pluvioChronicDao;
    private final IAEauCallUtil IAEauCallUtil;
    private final PredMeasuresDao predMeasuresDao;
    private final StationLinkDao StationLinkDao;
    private final DataTypeDao DataTypeDao;

    public Seq<PredMeasure> calculatePerceptronGeneric(IAEauModel model, String logCode, Option<Object> jobExecutionId, DateTime simulationDate) {
        return (Seq)Json$.MODULE$.parse((String)model.params().getOrElse((Function0 & Serializable)() -> "")).validate(PerceptronGenericParams$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            Option option = jobExecutionId;
            if (option instanceof Some) {
                Some some = (Some)option;
                long je = BoxesRunTime.unboxToLong((Object)some.value());
                JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.ERROR(), new StringBuilder(52).append("cant validate perceptron generic model parameters : ").append(JsError$.MODULE$.toJson(error).toString()).toString(), logCode);
                return (Seq)Nil$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(52).append("cant validate perceptron generic model parameters : ").append(JsError$.MODULE$.toJson(error).toString()).toString());
            }
            throw new MatchError((Object)option);
        }, (Function1 & Serializable)params -> {
            void hackedMeasures;
            void measures;
            void results;
            void input;
            void adList;
            void maxTemp;
            void minTemp;
            void temperature;
            void maxTemp2;
            void minTemp2;
            void tempValues;
            void x$208;
            void x$207;
            void x$206;
            void x$205;
            void x$204;
            void x$203;
            void x$202;
            void x$201;
            void x$200;
            void x$199;
            void x$198;
            void x$197;
            void x$196;
            void x$195;
            Option x$26;
            Option x$25;
            Option x$24;
            Option x$23;
            Option x$22;
            Option x$21;
            Option x$20;
            Option x$19;
            Option x$18;
            Option x$17;
            Option x$16;
            Option x$15;
            Option x$14;
            Option x$13;
            Option x$12;
            Option x$11;
            Option x$10;
            Option x$92;
            Option x$82;
            Option x$7;
            Option x$62;
            Seq x$5;
            DateTime minDateMeasures = simulationDate.minusDays(266).withDayOfWeek(1).withTimeAtStartOfDay();
            long minDateMeasuresMillis = minDateMeasures.getMillis();
            DateTime maxDateMeasures = DateUtil$.MODULE$.setMaxDay(simulationDate.plusDays(182));
            long maxDateMeasuresMillis = maxDateMeasures.getMillis();
            DataType dtTemperature = (DataType)$this.DataTypeDao.getPluvioDataTypes().find((Function1 & Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$4(dt))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No Temperature datatype found in Pluviometry module.");
            });
            StationLinkDetailed associatedPluvio = (StationLinkDetailed)$this.StationLinkDao.get(params.piezoCode(), 1L).find((Function1 & Serializable)ass -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$7(ass))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Can't find associated pluvio.");
            });
            int x$1 = params.piezoId();
            int x$27 = -1;
            Some x$3 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            String x$42 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            Seq allPiezoMeasures = PiezometryUtils$.MODULE$.getPiezoMeasures(new MeasuresParams(x$42, x$1, x$5 = MeasuresParams$.MODULE$.$lessinit$greater$default$3(), -1, x$62 = MeasuresParams$.MODULE$.$lessinit$greater$default$5(), x$7 = MeasuresParams$.MODULE$.$lessinit$greater$default$6(), x$82 = MeasuresParams$.MODULE$.$lessinit$greater$default$7(), x$92 = MeasuresParams$.MODULE$.$lessinit$greater$default$8(), x$10 = MeasuresParams$.MODULE$.$lessinit$greater$default$9(), x$11 = MeasuresParams$.MODULE$.$lessinit$greater$default$10(), x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$11(), x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$12(), x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$13(), x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$14(), x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$15(), x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$16(), x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$17(), x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$18(), x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$19(), x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$20(), x$22 = MeasuresParams$.MODULE$.$lessinit$greater$default$21(), x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$22(), (Option)x$3, x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24(), x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25(), x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26()), $this.PiezometerMeasureDao, $this.SieauParametersDao);
            Seq allPiezoValues = (Seq)allPiezoMeasures.map((Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$10(m)));
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)allPiezoValues.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)allPiezoValues.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double minPiezo = sp2._1$mcD$sp();
            double maxPiezo = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(minPiezo, maxPiezo);
            double minPiezo2 = sp3._1$mcD$sp();
            double maxPiezo2 = sp3._2$mcD$sp();
            int x$272 = -1;
            Some x$28 = new Some((Object)"WEEK_MAX");
            Some x$29 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            String x$30 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            int x$31 = MeasuresParams$.MODULE$.$lessinit$greater$default$2();
            Seq x$32 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$33 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$34 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$35 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$36 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$37 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$38 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$39 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$40 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$41 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$422 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$43 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$44 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$45 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option x$46 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option x$47 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$48 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
            Option x$49 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
            Option x$50 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$51 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$52 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq piezoWeek = (Seq)PiezometryUtils$.MODULE$.calculatePiezoMeasures(new MeasuresParams(x$30, x$31, x$32, -1, x$33, x$34, x$35, x$36, x$37, x$38, (Option)x$28, x$39, x$40, x$41, x$422, x$43, x$44, x$45, x$46, x$47, x$48, x$49, (Option)x$29, x$50, x$51, x$52), (Seq)allPiezoMeasures.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$11(minDateMeasuresMillis, maxDateMeasuresMillis, m))), PiezometryUtils$.MODULE$.calculatePiezoMeasures$default$3(), $this.SieauParametersDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.NGF(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            int x$53 = -1;
            Some x$54 = new Some((Object)"ENVELOPPE_MIN_SIMPLE");
            Some x$55 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Some x$56 = new Some((Object)minDateMeasures);
            Some x$57 = new Some((Object)maxDateMeasures);
            String x$58 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            int x$59 = MeasuresParams$.MODULE$.$lessinit$greater$default$2();
            Seq x$60 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$61 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$622 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$63 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$64 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$65 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$66 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$67 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$68 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$69 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$70 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$71 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$72 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$73 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option x$74 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option x$75 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$76 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$77 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$78 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq piezoMin = (Seq)PiezometryUtils$.MODULE$.calculatePiezoMeasures(new MeasuresParams(x$58, x$59, x$60, -1, x$61, x$622, x$63, x$64, x$65, x$66, (Option)x$54, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, (Option)x$56, (Option)x$57, (Option)x$55, x$76, x$77, x$78), allPiezoMeasures, PiezometryUtils$.MODULE$.calculatePiezoMeasures$default$3(), $this.SieauParametersDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.NGF(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            int x$79 = -1;
            Some x$80 = new Some((Object)"ENVELOPPE_MEDIAN_SIMPLE");
            Some x$81 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Some x$822 = new Some((Object)minDateMeasures);
            Some x$83 = new Some((Object)maxDateMeasures);
            String x$84 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            int x$85 = MeasuresParams$.MODULE$.$lessinit$greater$default$2();
            Seq x$86 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$87 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$88 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$89 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$90 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$91 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$922 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$93 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$94 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$95 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$96 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$97 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$98 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$99 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option x$100 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option x$101 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$102 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$103 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$104 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq piezoMed = (Seq)PiezometryUtils$.MODULE$.calculatePiezoMeasures(new MeasuresParams(x$84, x$85, x$86, -1, x$87, x$88, x$89, x$90, x$91, x$922, (Option)x$80, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, (Option)x$822, (Option)x$83, (Option)x$81, x$102, x$103, x$104), allPiezoMeasures, PiezometryUtils$.MODULE$.calculatePiezoMeasures$default$3(), $this.SieauParametersDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.NGF(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            int x$105 = -1;
            Some x$106 = new Some((Object)"ENVELOPPE_MAX_SIMPLE");
            Some x$107 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Some x$108 = new Some((Object)minDateMeasures);
            Some x$109 = new Some((Object)maxDateMeasures);
            String x$110 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            int x$111 = MeasuresParams$.MODULE$.$lessinit$greater$default$2();
            Seq x$112 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$113 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$114 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$115 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$116 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$117 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$118 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$119 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$120 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$121 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$122 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$123 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$124 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$125 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option x$126 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option x$127 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$128 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$129 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$130 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq piezoMax = (Seq)PiezometryUtils$.MODULE$.calculatePiezoMeasures(new MeasuresParams(x$110, x$111, x$112, -1, x$113, x$114, x$115, x$116, x$117, x$118, (Option)x$106, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, (Option)x$108, (Option)x$109, (Option)x$107, x$128, x$129, x$130), allPiezoMeasures, PiezometryUtils$.MODULE$.calculatePiezoMeasures$default$3(), $this.SieauParametersDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.NGF(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            int x$131 = (int)associatedPluvio.stationLinkedId();
            boolean x$132 = true;
            Some x$133 = new Some((Object)"SUM_WEEK");
            String x$134 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            Seq x$135 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$136 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$137 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$138 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$139 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$140 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$141 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$142 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$143 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$144 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$145 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$146 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$147 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$148 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option x$149 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option x$150 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$151 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
            Option x$152 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
            Option x$153 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
            Option x$154 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$155 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$156 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq rainTmp = (Seq)PluviometryUtils$.MODULE$.getPluvioMeasures(new MeasuresParams(x$134, x$131, x$135, 1, x$136, x$137, x$138, x$139, x$140, x$141, (Option)x$133, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156), $this.pluvioChronicDao, $this.SieauParametersDao, $this.DataTypeDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            Seq rainValues = (Seq)rainTmp.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$17(x$2)));
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)rainValues.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)rainValues.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
            if (sp4 == null) {
                throw new MatchError((Object)sp4);
            }
            double minRain = sp4._1$mcD$sp();
            double maxRain = sp4._2$mcD$sp();
            Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(minRain, maxRain);
            double minRain2 = sp5._1$mcD$sp();
            double maxRain2 = sp5._2$mcD$sp();
            Seq rain = (Seq)rainTmp.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$18(minDateMeasuresMillis, maxDateMeasuresMillis, m)));
            int x$157 = (int)associatedPluvio.stationLinkedId();
            int x$158 = 3;
            Some x$159 = new Some((Object)"SUM_WEEK");
            String x$160 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            Seq x$161 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$162 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$163 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$164 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$165 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$166 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$167 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$168 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$169 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$170 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option x$171 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option x$172 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$173 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$174 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option x$175 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option x$176 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$177 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
            Option x$178 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
            Option x$179 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
            Option x$180 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$181 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$182 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq etpTmp = (Seq)PluviometryUtils$.MODULE$.getPluvioMeasures(new MeasuresParams(x$160, x$157, x$161, 3, x$162, x$163, x$164, x$165, x$166, x$167, (Option)x$159, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182), $this.pluvioChronicDao, $this.SieauParametersDao, $this.DataTypeDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            Seq etpValues = (Seq)etpTmp.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$20(x$4)));
            Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)etpValues.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)rainValues.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
            if (sp6 == null) {
                throw new MatchError((Object)sp6);
            }
            double minETP = sp6._1$mcD$sp();
            double maxETP = sp6._2$mcD$sp();
            Tuple2.mcDD.sp sp7 = new Tuple2.mcDD.sp(minETP, maxETP);
            double minETP2 = sp7._1$mcD$sp();
            double maxETP2 = sp7._2$mcD$sp();
            Seq etp = (Seq)etpTmp.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$21(minDateMeasuresMillis, maxDateMeasuresMillis, m)));
            int x$183 = (int)associatedPluvio.stationLinkedId();
            int x$184 = (int)dtTemperature.id();
            Some x$185 = new Some((Object)"SUM_WEEK");
            String x$186 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            Seq x$187 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$188 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$189 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
            Option x$190 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
            Option x$191 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
            Option x$192 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
            Option x$193 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
            Option x$194 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option option = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option option2 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
            Option option3 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
            Option option4 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option option5 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option option6 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
            Option option7 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
            Option option8 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option option9 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
            Option option10 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
            Option option11 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
            Option option12 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option option13 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option option14 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq tempTmp = (Seq)PluviometryUtils$.MODULE$.getPluvioMeasures(new MeasuresParams(x$186, x$183, x$187, x$184, x$188, x$189, x$190, x$191, x$192, x$193, (Option)x$185, x$194, (Option)x$195, (Option)x$196, (Option)x$197, (Option)x$198, (Option)x$199, (Option)x$200, (Option)x$201, (Option)x$202, (Option)x$203, (Option)x$204, (Option)x$205, (Option)x$206, (Option)x$207, (Option)x$208), $this.pluvioChronicDao, $this.SieauParametersDao, $this.DataTypeDao).map((Function1 & Serializable)m -> new .colon.colon((Object)new IAVal((double)m.date().getMillis()), (List)new .colon.colon((Object)new IAVal(m.value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
            Seq seq = (Seq)tempTmp.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$23(x$6)));
            Tuple2.mcDD.sp sp8 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)tempValues.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)tempValues.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
            if (sp8 == null) {
                throw new MatchError((Object)sp8);
            }
            double d2 = sp8._1$mcD$sp();
            double d3 = sp8._2$mcD$sp();
            Tuple2.mcDD.sp sp9 = new Tuple2.mcDD.sp((double)minTemp2, (double)maxTemp2);
            double d4 = sp9._1$mcD$sp();
            double d5 = sp9._2$mcD$sp();
            Seq seq2 = (Seq)tempTmp.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$24(minDateMeasuresMillis, maxDateMeasuresMillis, m)));
            Seq seq3 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AquasysData[]{PerceptronGenericModel.toAquasysData$1((Seq)new .colon.colon((Object)new .colon.colon((Object)new IAVal((double)params.scenario()), (List)Nil$.MODULE$), (List)Nil$.MODULE$), 16, "Param_scenar.csv"), PerceptronGenericModel.toAquasysData$1(piezoWeek, 1, new StringBuilder(17).append("piezo:").append(params.piezoId()).append(":-1:weekmax").toString()), PerceptronGenericModel.toAquasysData$1(piezoMin, 2, new StringBuilder(13).append("piezo:").append(params.piezoId()).append(":-1:min").toString()), PerceptronGenericModel.toAquasysData$1(piezoMed, 3, new StringBuilder(13).append("piezo:").append(params.piezoId()).append(":-1:med").toString()), PerceptronGenericModel.toAquasysData$1(piezoMax, 4, new StringBuilder(13).append("piezo:").append(params.piezoId()).append(":-1:max").toString()), PerceptronGenericModel.toAquasysData$1(rain, 5, new StringBuilder(9).append("pluvio:").append(associatedPluvio.stationLinkedId()).append(":1").toString()), PerceptronGenericModel.toAquasysData$1(etp, 6, new StringBuilder(9).append("pluvio:").append(associatedPluvio.stationLinkedId()).append(":3").toString()), PerceptronGenericModel.toAquasysData$1((Seq)temperature, 7, new StringBuilder(8).append("pluvio:").append(associatedPluvio.stationLinkedId()).append(":").append((int)dtTemperature.id()).toString()), PerceptronGenericModel.toAquasysDataParams$1(51, "Piezo week norm params", minPiezo2, maxPiezo2), PerceptronGenericModel.toAquasysDataParams$1(55, "Piezo rain norm params", minRain2, maxRain2), PerceptronGenericModel.toAquasysDataParams$1(56, "Piezo etp norm params", minETP2, maxETP2), PerceptronGenericModel.toAquasysDataParams$1(57, "Piezo temperature norm params", (double)minTemp, (double)maxTemp)}));
            adList.foreach((Function1 & Serializable)ad -> {
                PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$25(ad);
                return BoxedUnit.UNIT;
            });
            JsObject jsObject = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overrideInputNodes"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 11})), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputsToTake"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{40})), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputs"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)adList, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)AquasysData$.MODULE$.formatAquasysData())), Writes$.MODULE$.jsValueWrites()))}));
            Seq seq4 = $this.IAEauCallUtil.callIAEau("PMC_GENERIQUE", (JsObject)input, params.piezoCode(), logCode, jobExecutionId, $this.IAEauCallUtil.callIAEau$default$6(), $this.IAEauCallUtil.callIAEau$default$7(), $this.IAEauCallUtil.callIAEau$default$8());
            Seq seq5 = (Seq)((IterableOps)((SeqOps)((AquasysData)results.headOption().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No results after IAEau call...");
            })).data().map((Function1 & Serializable)d -> {
                int x$209 = params.piezoId();
                int x$210 = model.typeId();
                DateTime x$211 = new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get()));
                Option x$212 = ((IAVal)d.apply(1)).value();
                Option x$213 = ((IAVal)d.apply(2)).value();
                Option x$214 = ((IAVal)d.apply(3)).value();
                DateTime x$215 = simulationDate;
                String x$216 = (String)model.updateLogin().getOrElse((Function0 & Serializable)() -> "Perceptron Generic model");
                String x$217 = (String)model.name().getOrElse((Function0 & Serializable)() -> "Perceptron Generic model");
                int x$218 = BoxesRunTime.unboxToInt((Object)model.horizon().getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("Model Perceptron Generic has no horizon...");
                }));
                String x$219 = (String)model.horizonMode().getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("Model Perceptron Generic has no horizon mode...");
                });
                int x$220 = Days.daysBetween((ReadablePartial)simulationDate.toLocalDate(), (ReadablePartial)new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get())).toLocalDate()).getDays();
                Option x$221 = PredMeasure$.MODULE$.$lessinit$greater$default$7();
                Option x$222 = PredMeasure$.MODULE$.$lessinit$greater$default$10();
                DateTime x$223 = PredMeasure$.MODULE$.$lessinit$greater$default$11();
                DateTime x$224 = PredMeasure$.MODULE$.$lessinit$greater$default$12();
                Option x$225 = PredMeasure$.MODULE$.$lessinit$greater$default$14();
                Option x$226 = PredMeasure$.MODULE$.$lessinit$greater$default$15();
                return new PredMeasure(x$209, x$210, x$215, x$211, x$212, x$217, x$221, x$213, x$214, x$222, x$223, x$224, x$216, x$225, x$226, x$218, x$219, x$220);
            })).sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$32(x$8)), (Ordering)Ordering.Long$.MODULE$)).takeWhile((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PerceptronGenericModel.$anonfun$calculatePerceptronGeneric$33(simulationDate, params, x$9)));
            Seq<PredMeasure> seq6 = IAEauUtils$.MODULE$.applyHackOnCalculatedMeasures((Seq<PredMeasure>)measures, model, $this.PiezometerMeasureDao, $this.hydroChronicDao);
            Option option15 = jobExecutionId;
            if (option15 instanceof Some) {
                void imported;
                void je;
                Some some = (Some)option15;
                long l = BoxesRunTime.unboxToLong((Object)some.value());
                JobLogUtil$.MODULE$.log((long)je, JobState$.MODULE$.INFO(), new StringBuilder(51).append(hackedMeasures.length()).append(" calculated measures received. Begin integration...").toString(), logCode);
                int n = $this.predMeasuresDao.setMeasures(model.idStation(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)model.idModel())), (Option)new Some(model.name().getOrElse((Function0 & Serializable)() -> "Perceptron Generic model")), StationTypeUtil$.MODULE$.PIEZOMETRY(), (Seq)hackedMeasures, $this.predMeasuresDao.setMeasures$default$6());
                JobLogUtil$.MODULE$.log((long)je, JobState$.MODULE$.SUCCESS(), new StringBuilder(32).append((int)imported).append(" measures successfully imported.").toString(), logCode);
                return (Seq)Nil$.MODULE$;
            }
            if (None$.MODULE$.equals(option15)) {
                return hackedMeasures;
            }
            throw new MatchError((Object)option15);
        });
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$4(DataType dt) {
        String string = ((String)dt.name().getOrElse((Function0 & Serializable)() -> "")).toLowerCase().replace("\u00e9", "e").trim();
        String string2 = "temperature";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$7(StationLinkDetailed ass) {
        return (int)ass.stationLinkedType() == 2 && ((String)ass.stationLinkedName().getOrElse((Function0 & Serializable)() -> "")).contains("ERA5");
    }

    public static final /* synthetic */ double $anonfun$calculatePerceptronGeneric$10(PiezometerChronicRawMeasure m) {
        return BoxesRunTime.unboxToDouble((Object)m.NGF().get());
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$11(long minDateMeasuresMillis$1, long maxDateMeasuresMillis$1, PiezometerChronicRawMeasure m) {
        return m.date().getMillis() >= minDateMeasuresMillis$1 && m.date().getMillis() <= maxDateMeasuresMillis$1;
    }

    public static final /* synthetic */ double $anonfun$calculatePerceptronGeneric$17(Seq x$2) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)x$2.apply(1)).value().get());
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$18(long minDateMeasuresMillis$1, long maxDateMeasuresMillis$1, Seq m) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)m.head()).value().get()) >= (double)minDateMeasuresMillis$1 && BoxesRunTime.unboxToDouble((Object)((IAVal)m.head()).value().get()) <= (double)maxDateMeasuresMillis$1;
    }

    public static final /* synthetic */ double $anonfun$calculatePerceptronGeneric$20(Seq x$4) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)x$4.apply(1)).value().get());
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$21(long minDateMeasuresMillis$1, long maxDateMeasuresMillis$1, Seq m) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)m.head()).value().get()) >= (double)minDateMeasuresMillis$1 && BoxesRunTime.unboxToDouble((Object)((IAVal)m.head()).value().get()) <= (double)maxDateMeasuresMillis$1;
    }

    public static final /* synthetic */ double $anonfun$calculatePerceptronGeneric$23(Seq x$6) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)x$6.apply(1)).value().get());
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$24(long minDateMeasuresMillis$1, long maxDateMeasuresMillis$1, Seq m) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)m.head()).value().get()) >= (double)minDateMeasuresMillis$1 && BoxesRunTime.unboxToDouble((Object)((IAVal)m.head()).value().get()) <= (double)maxDateMeasuresMillis$1;
    }

    private static final AquasysData toAquasysDataParams$1(int id, String name, double min, double max) {
        int x$1 = id;
        .colon.colon x$2 = new .colon.colon((Object)new AquasysDataColumn(1, "Min", "number"), (List)new .colon.colon((Object)new AquasysDataColumn(2, "Max", "number"), (List)Nil$.MODULE$));
        .colon.colon x$3 = new .colon.colon((Object)new .colon.colon((Object)new IAVal(min), (List)new .colon.colon((Object)new IAVal(max), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        Some x$4 = new Some((Object)name);
        Option x$5 = AquasysData$.MODULE$.apply$default$2();
        Option x$6 = AquasysData$.MODULE$.apply$default$5();
        Option x$7 = AquasysData$.MODULE$.apply$default$7();
        Option x$8 = AquasysData$.MODULE$.apply$default$8();
        Option x$9 = AquasysData$.MODULE$.apply$default$9();
        Option x$10 = AquasysData$.MODULE$.apply$default$10();
        Option x$11 = AquasysData$.MODULE$.apply$default$11();
        return new AquasysData(x$1, x$5, (Seq)x$2, (Option)x$4, x$6, (Seq)x$3, x$7, x$8, x$9, x$10, x$11);
    }

    private static final AquasysData toAquasysData$1(Seq measures, int id, String name) {
        int x$1 = id;
        .colon.colon x$2 = new .colon.colon((Object)new AquasysDataColumn(1, "Date", "date"), (List)new .colon.colon((Object)new AquasysDataColumn(2, "Valeur", "number"), (List)Nil$.MODULE$));
        Seq x$3 = measures;
        Some x$4 = new Some((Object)name);
        Option x$5 = AquasysData$.MODULE$.apply$default$2();
        Option x$6 = AquasysData$.MODULE$.apply$default$5();
        Option x$7 = AquasysData$.MODULE$.apply$default$7();
        Option x$8 = AquasysData$.MODULE$.apply$default$8();
        Option x$9 = AquasysData$.MODULE$.apply$default$9();
        Option x$10 = AquasysData$.MODULE$.apply$default$10();
        Option x$11 = AquasysData$.MODULE$.apply$default$11();
        return new AquasysData(x$1, x$5, (Seq)x$2, (Option)x$4, x$6, x$3, x$7, x$8, x$9, x$10, x$11);
    }

    public static final /* synthetic */ void $anonfun$calculatePerceptronGeneric$25(AquasysData ad) {
        DateTime minDate = new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)((IterableOps)ad.data().head()).head()).value().get()));
        DateTime maxDate = new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)((IterableOps)ad.data().last()).head()).value().get()));
        Predef$.MODULE$.println((Object)new StringBuilder(37).append("AquasyData named ").append(ad.name().get()).append(", with min ").append(DateUtil$.MODULE$.getDate(minDate)).append(" and max ").append(DateUtil$.MODULE$.getDate(maxDate)).toString());
    }

    public static final /* synthetic */ long $anonfun$calculatePerceptronGeneric$32(PredMeasure x$8) {
        return x$8.date().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$calculatePerceptronGeneric$33(DateTime simulationDate$1, PerceptronGenericParams params$1, PredMeasure x$9) {
        return x$9.date().withHourOfDay(12).getMillis() < simulationDate$1.plusDays(params$1.horizon()).withHourOfDay(23).getMillis();
    }

    @Inject
    public PerceptronGenericModel(LogUtil logUtil, PiezometerMeasureDao PiezometerMeasureDao2, SieauParametersDao SieauParametersDao2, HydroChronicDao hydroChronicDao, PluvioChronicDao pluvioChronicDao, IAEauCallUtil IAEauCallUtil2, PredMeasuresDao predMeasuresDao, StationLinkDao StationLinkDao2, WSClient ws, DataTypeDao DataTypeDao2) {
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
        this.SieauParametersDao = SieauParametersDao2;
        this.hydroChronicDao = hydroChronicDao;
        this.pluvioChronicDao = pluvioChronicDao;
        this.IAEauCallUtil = IAEauCallUtil2;
        this.predMeasuresDao = predMeasuresDao;
        this.StationLinkDao = StationLinkDao2;
        this.DataTypeDao = DataTypeDao2;
    }
}

