/*
 * Decompiled with CFR 0.152.
 */
package Alerting.controllers.calcul.rseau;

import Alerting.controllers.calcul.rseau.RSEauController;
import Alerting.controllers.calcul.rseau.dao.RSEauDao;
import Alerting.controllers.calcul.rseau.dao.SGDoseDao;
import Alerting.controllers.calcul.rseau.domain.RSEauDaily;
import Alerting.controllers.calcul.rseau.domain.RSEauDaily$;
import Alerting.controllers.calcul.rseau.domain.RSEauStrategy;
import Alerting.controllers.calcul.rseau.domain.RSEauStrategy$;
import Alerting.controllers.calcul.rseau.domain.optirrig.OptirrigDailyVar;
import Alerting.controllers.calcul.rseau.domain.optirrig.inputs.ChronoTension;
import Alerting.controllers.calcul.rseau.domain.optirrig.inputs.ChronoTension$;
import Alerting.controllers.calcul.rseau.domain.optirrig.inputs.OR_Parametres;
import Alerting.controllers.calcul.rseau.domain.optirrig.inputs.OR_Parametres$;
import Alerting.controllers.calcul.rseau.domain.optirrig.inputs.SGDose;
import Alerting.controllers.calcul.rseau.domain.optirrig.inputs.SGDose$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.agri_mobile.exploitation.ExploitationDao;
import fr.aquasys.daeau.agri_mobile.exploitation.domain.ExploitationSamplingPointWithLinks;
import fr.aquasys.daeau.agri_mobile.exploitation.domain.ExploitationWithLinks;
import fr.aquasys.daeau.agri_mobile.exploitation.domain.ExploitationWithStats;
import fr.aquasys.daeau.agri_mobile.links.exploitation.land.Land;
import fr.aquasys.daeau.agri_mobile.referencial.counterVolume.CounterVolumeDao;
import fr.aquasys.daeau.iaeau.IAEauCallUtil;
import fr.aquasys.daeau.iaeau.constants.GenericMeasuresConstants$;
import fr.aquasys.daeau.iaeau.dao.CalculatedMeasureDao;
import fr.aquasys.daeau.iaeau.dao.GenericMeasuresDao;
import fr.aquasys.daeau.iaeau.model.AquasysData;
import fr.aquasys.daeau.iaeau.model.AquasysData$;
import fr.aquasys.daeau.iaeau.model.AquasysDataColumn$;
import fr.aquasys.daeau.iaeau.model.CalculatedMeasure;
import fr.aquasys.daeau.iaeau.model.GenericMeasure;
import fr.aquasys.daeau.iaeau.model.IAVal;
import fr.aquasys.daeau.iaeau.model.IAVal$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.pluviometry.itf.PluvioChronicDao;
import fr.aquasys.daeau.pluviometry.model.chronic.PluvioChronicMeasure;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.SettingUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import util.IAEauUtils$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\r%e\u0001B\u0017/\u0001]B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ya\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0006\u0017\"Aq\u000b\u0001B\u0001B\u0003-\u0001\f\u0003\u0005_\u0001\t\u0005\t\u0015a\u0003`\u0011!I\u0007A!A!\u0002\u0017Q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b1\u0002:\t\u0011a\u0004!\u0011!Q\u0001\feD\u0011b \u0001\u0003\u0002\u0003\u0006Y!!\u0001\t\u0015\u0005\u001d\u0001A!A!\u0002\u0017\tI\u0001\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0006\u00033A!\"a\t\u0001\u0005\u0003\u0005\u000b1BA\u0013\u0011)\tY\u0003\u0001B\u0001B\u0003-\u0011Q\u0006\u0005\u000b\u0003w\u0001!\u0011!Q\u0001\f\u0005u\u0002BCA)\u0001\t\u0005\t\u0015a\u0003\u0002T!Q\u0011\u0011\f\u0001\u0003\u0002\u0003\u0006Y!a\u0017\t\u0015\u0005%\u0004A!A!\u0002\u0017\tY\u0007\u0003\u0006\u0002x\u0001\u0011\t\u0011)A\u0006\u0003sBq!!!\u0001\t\u0003\t\u0019\tC\u0005\u0002>\u0002\u0011\r\u0011\"\u0001\u0002@\"A\u0011q\u0019\u0001!\u0002\u0013\t\t\rC\u0005\u0002J\u0002\u0011\r\u0011\"\u0001\u0002@\"A\u00111\u001a\u0001!\u0002\u0013\t\t\rC\u0005\u0002N\u0002\u0011\r\u0011\"\u0001\u0002@\"A\u0011q\u001a\u0001!\u0002\u0013\t\t\rC\u0005\u0002R\u0002\u0011\r\u0011\"\u0001\u0002@\"A\u00111\u001b\u0001!\u0002\u0013\t\t\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005[\u0002A\u0011\u0001B8\u0011\u001d\u0011I\n\u0001C\u0001\u00057CqAa,\u0001\t\u0003\u0011\t\fC\u0004\u0003>\u0002!\tAa0\t\u000f\t\u001d\u0007\u0001\"\u0002\u0003J\"9!q\u001f\u0001\u0005\u0002\te\bbBB\u0002\u0001\u0011\u00051Q\u0001\u0005\b\u0007K\u0001A\u0011AB\u0014\u0011\u001d\u0019\u0019\u0004\u0001C\u0003\u0007kAqaa\u0012\u0001\t\u0003\u0019I\u0005C\u0004\u0004V\u0001!\taa\u0016\t\u000f\r\u0005\u0004\u0001\"\u0001\u0004d!911\u000e\u0001\u0005\u0002\r5\u0004bBB<\u0001\u0011\u00051\u0011\u0010\u0002\u000e\u001fB$\u0018N\u001d:jO6{G-\u001a7\u000b\u0005=\u0002\u0014!\u0002:tK\u0006,(BA\u00193\u0003\u0019\u0019\u0017\r\\2vY*\u00111\u0007N\u0001\fG>tGO]8mY\u0016\u00148OC\u00016\u0003!\tE.\u001a:uS:<7\u0001A\n\u0003\u0001a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0017AA<t!\t\u0001\u0005*D\u0001B\u0015\tq$I\u0003\u0002D\t\u0006!A.\u001b2t\u0015\t)e)A\u0002ba&T\u0011aR\u0001\u0005a2\f\u00170\u0003\u0002J\u0003\nAqkU\"mS\u0016tG/A\u0004m_\u001e,F/\u001b7\u0011\u00051+V\"A'\u000b\u00059{\u0015\u0001B;uS2T!\u0001U)\u0002\u0011I\f'MY5u[FT!AU*\u0002\u000f\u0005\fX/Y:zg*\tA+\u0001\u0002ge&\u0011a+\u0014\u0002\b\u0019><W\u000b^5m\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u00033rk\u0011A\u0017\u0006\u00037F\u000bQ!\u001e;jYNL!!\u0018.\u0003\u0015){'\rT8h+RLG.A\nTi\u0006$\u0018n\u001c8UQJ,7\u000f[8mI\u0012\u000bw\u000e\u0005\u0002aO6\t\u0011M\u0003\u0002cG\u0006\u0019\u0011\u000e\u001e4\u000b\u0005\u0011,\u0017aB:uCRLwN\u001c\u0006\u0003MF\u000bQ\u0001Z1fCVL!\u0001[1\u0003'M#\u0018\r^5p]RC'/Z:i_2$G)Y8\u0002)AKWM_8nKR,'/T3bgV\u0014X\rR1p!\tYw.D\u0001m\u0015\t\u0011WN\u0003\u0002oK\u0006Q\u0001/[3{_6,GO]=\n\u0005Ad'\u0001\u0006)jKj|W.\u001a;fe6+\u0017m];sK\u0012\u000bw.\u0001\u0005S'\u0016\u000bW\u000fR1p!\t\u0019h/D\u0001u\u0015\t)h&A\u0002eC>L!a\u001e;\u0003\u0011I\u001bV)Y;EC>\fQ\"S!FCV\u001c\u0015\r\u001c7Vi&d\u0007C\u0001>~\u001b\u0005Y(B\u0001?f\u0003\u0015I\u0017-Z1v\u0013\tq8PA\u0007J\u0003\u0016\u000bWoQ1mYV#\u0018\u000e\\\u0001\u0010a&,'p\\7fi\u0016\u0014H)Y3bkB\u00191.a\u0001\n\u0007\u0005\u0015ANA\bQS\u0016Tx.\\3uKJ$\u0015-Z1v\u0003A\u0001H.\u001e<j_\u000eC'o\u001c8jG\u0012\u000bw\u000e\u0005\u0003\u0002\f\u0005MQBAA\u0007\u0015\r\u0011\u0017q\u0002\u0006\u0004\u0003#)\u0017a\u00039mkZLw.\\3uefLA!!\u0006\u0002\u000e\t\u0001\u0002\u000b\\;wS>\u001c\u0005N]8oS\u000e$\u0015m\\\u0001\u0015G\u0006d7-\u001e7bi\u0016$W*Z1tkJ,G)Y8\u0011\t\u0005m\u0011qD\u0007\u0003\u0003;Q!!^>\n\t\u0005\u0005\u0012Q\u0004\u0002\u0015\u0007\u0006d7-\u001e7bi\u0016$W*Z1tkJ,G)Y8\u0002%\u001d,g.\u001a:jG6+\u0017m];sKN$\u0015m\u001c\t\u0005\u00037\t9#\u0003\u0003\u0002*\u0005u!AE$f]\u0016\u0014\u0018nY'fCN,(/Z:EC>\f!cU5fCV\u0004\u0016M]1nKR,'o\u001d#b_B!\u0011qFA\u001c\u001b\t\t\tDC\u0002c\u0003gQ1!!\u000ef\u00039\tG-\\5oSN$(/\u0019;j_:LA!!\u000f\u00022\t\u00112+[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p\u0003A\u0019u.\u001e8uKJ4v\u000e\\;nK\u0012\u000bw\u000e\u0005\u0003\u0002@\u00055SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u001b\r|WO\u001c;feZ{G.^7f\u0015\u0011\t9%!\u0013\u0002\u0017I,g-\u001a:f]\u000eL\u0017\r\u001c\u0006\u0004\u0003\u0017*\u0017aC1he&|Vn\u001c2jY\u0016LA!a\u0014\u0002B\t\u00012i\\;oi\u0016\u0014hk\u001c7v[\u0016$\u0015m\\\u0001\n'\u001e#un]3EC>\u00042a]A+\u0013\r\t9\u0006\u001e\u0002\n'\u001e#un]3EC>\fq!^:fe\u0012\u000bw\u000e\u0005\u0003\u0002^\u0005\u0015TBAA0\u0015\r\u0011\u0017\u0011\r\u0006\u0004\u0003G*\u0017\u0001B;tKJLA!a\u001a\u0002`\t9Qk]3s\t\u0006|\u0017aD3ya2|\u0017\u000e^1uS>tG)Y8\u0011\t\u00055\u00141O\u0007\u0003\u0003_RA!!\u001d\u0002J\u0005aQ\r\u001f9m_&$\u0018\r^5p]&!\u0011QOA8\u0005=)\u0005\u0010\u001d7pSR\fG/[8o\t\u0006|\u0017a\u0004*T\u000b\u0006,8i\u001c8ue>dG.\u001a:\u0011\t\u0005m\u0014QP\u0007\u0002]%\u0019\u0011q\u0010\u0018\u0003\u001fI\u001bV)Y;D_:$(o\u001c7mKJ\fa\u0001P5oSRtDCAAC)\u0011\n9)!#\u0002\f\u00065\u0015qRAI\u0003'\u000b)*a&\u0002\u001a\u0006m\u0015QTAP\u0003C\u000b\u0019+!*\u0002(\u0006%\u0006cAA>\u0001!)aH\u0005a\u0002\u007f!)!J\u0005a\u0002\u0017\")qK\u0005a\u00021\")aL\u0005a\u0002?\")\u0011N\u0005a\u0002U\")\u0011O\u0005a\u0002e\")\u0001P\u0005a\u0002s\"1qP\u0005a\u0002\u0003\u0003Aq!a\u0002\u0013\u0001\b\tI\u0001C\u0004\u0002\u0018I\u0001\u001d!!\u0007\t\u000f\u0005\r\"\u0003q\u0001\u0002&!9\u00111\u0006\nA\u0004\u00055\u0002bBA\u001e%\u0001\u000f\u0011Q\b\u0005\b\u0003#\u0012\u00029AA*\u0011\u001d\tIF\u0005a\u0002\u00037Bq!!\u001b\u0013\u0001\b\tY\u0007C\u0004\u0002xI\u0001\u001d!!\u001f)\u0007I\ti\u000b\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\r%t'.Z2u\u0015\t\t9,A\u0003kCZ\f\u00070\u0003\u0003\u0002<\u0006E&AB%oU\u0016\u001cG/\u0001\u0007sC&tG)\u0019;b)f\u0004X-\u0006\u0002\u0002BB\u0019\u0011(a1\n\u0007\u0005\u0015'HA\u0002J]R\fQB]1j]\u0012\u000bG/\u0019+za\u0016\u0004\u0013aC3ua\u0012\u000bG/\u0019+za\u0016\fA\"\u001a;q\t\u0006$\u0018\rV=qK\u0002\n\u0011C]1eS\u0006$\u0018n\u001c8ECR\fG+\u001f9f\u0003I\u0011\u0018\rZ5bi&|g\u000eR1uCRK\b/\u001a\u0011\u0002'Q,W\u000e]3sCR,(/\u001a#bi\u0006$\u0016\u0010]3\u0002)Q,W\u000e]3sCR,(/\u001a#bi\u0006$\u0016\u0010]3!\u0003E\u0019\u0017\r\\2vY\u0006$Xm\u00149uSJ\u0014\u0018n\u001a\u000b\u0003\u00033$B!a7\u0002bB\u0019\u0011(!8\n\u0007\u0005}'H\u0001\u0003V]&$\bbBAr7\u0001\u000f\u0011Q]\u0001\u000fU>\u0014W\t_3dkRLwN\\%e!\rI\u0014q]\u0005\u0004\u0003ST$\u0001\u0002'p]\u001e\f\u0001eY1mGVd\u0017\r^3PaRL'O]5h\r>\u0014X\t\u001f9m_&$\u0018\r^5p]R!\u0011q\u001eB\u000e)\u0019\tY.!=\u0002t\"9\u00111\u001d\u000fA\u0004\u0005\u0015\bbBA{9\u0001\u000f\u0011q_\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bCBA}\u0005\u0013\u0011yA\u0004\u0003\u0002|\n\u0015a\u0002BA\u007f\u0005\u0007i!!a@\u000b\u0007\t\u0005a'\u0001\u0004=e>|GOP\u0005\u0002w%\u0019!q\u0001\u001e\u0002\u000fA\f7m[1hK&!!1\u0002B\u0007\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u000fQ\u0004\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\t\tU\u00111G\u0001\u0006[>$W\r\\\u0005\u0005\u00053\u0011\u0019BA\bTS\u0016\fW\u000fU1sC6,G/\u001a:t\u0011\u001d\t\t\b\ba\u0001\u0005;\u0001BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0005\u0005G\ty'\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005O\u0011\tCA\u000bFqBdw.\u001b;bi&|gnV5uQ2Kgn[:\u0002\u001d\u001d,Go\u0015;sKN\u001cx+\u0019;feR!\u0011\u0011\u0019B\u0017\u0011\u001d\u0011y#\ba\u0001\u0005c\t1b\u001d;sKN\u001cxl\u001e7bSB\u0019\u0011Ha\r\n\u0007\tU\"H\u0001\u0004E_V\u0014G.Z\u0001\rO\u0016$8\u000b\u001e:fgN$\u0015-\u001f\u000b\u0007\u0005w\u0011)F!\u001b\u0011\u000be\u0012iD!\u0011\n\u0007\t}\"H\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u0007\u0012\t&\u0004\u0002\u0003F)!!q\tB%\u0003\u0011!\u0018.\\3\u000b\t\t-#QJ\u0001\u0005U>$\u0017M\u0003\u0002\u0003P\u0005\u0019qN]4\n\t\tM#Q\t\u0002\t\t\u0006$X\rV5nK\"9!q\u000b\u0010A\u0002\te\u0013!\u00033bS2Lh+\u0019:t!\u0019\tIP!\u0003\u0003\\A!!Q\fB3\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014\u0001C8qi&\u0014(/[4\u000b\u0007\t\rb&\u0003\u0003\u0003h\t}#\u0001E(qi&\u0014(/[4EC&d\u0017PV1s\u0011\u001d\u0011YG\ba\u0001\u0005\u0003\nQA[0eCf\f!b\u00195fG.4\u0015.\u001a7e)\u0019\u0011\tH!\u001e\u0003\nR!\u00111\u001cB:\u0011\u001d\t)p\ba\u0002\u0003oDqAa\u001e \u0001\u0004\u0011I(A\u0003gS\u0016dG\r\u0005\u0003\u0003|\t\re\u0002\u0002B?\u0005\u007f\u00022!!@;\u0013\r\u0011\tIO\u0001\u0007!J,G-\u001a4\n\t\t\u0015%q\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\u0005%\bC\u0004\u0003\f~\u0001\rA!$\u0002\u001d1\fg\u000e\u001a)be\u0006lW\r^3sgB1\u0011\u0011 B\u0005\u0005\u001f\u0003BA!%\u0003\u00166\u0011!1\u0013\u0006\u0004\u0005+Y\u0018\u0002\u0002BL\u0005'\u0013abR3oKJL7-T3bgV\u0014X-A\u0005hKRLe\u000e];ugR!!Q\u0014BW)\u0019\u0011yJa*\u0003*B1\u0011\u0011 B\u0005\u0005C\u0003BA!%\u0003$&!!Q\u0015BJ\u0005-\t\u0015/^1tsN$\u0015\r^1\t\u000f\u0005U\b\u0005q\u0001\u0002x\"9!1\u0016\u0011A\u0004\t\u0005\u0013AD:j[Vd\u0017\r^5p]\u0012\u000bG/\u001a\u0005\b\u0003c\u0002\u0003\u0019\u0001B\u000f\u0003YIg\u000e];u?Fz6\r\u001b:p]>|F/\u001a8tS>tG\u0003\u0002BZ\u0005s#bAa(\u00036\n]\u0006bBA{C\u0001\u000f\u0011q\u001f\u0005\b\u0005W\u000b\u00039\u0001B!\u0011\u001d\u0011Y,\ta\u0001\u0005\u001b\u000b!\u0002\\1oIB\u000b'/Y7t\u0003I9W\r\u001e*fgR\u0014H)\u0019;f/&$\b\u000e\u0012#\u0015\u0005\t\u0005GC\u0002B!\u0005\u0007\u0014)\rC\u0004\u0002v\n\u0002\u001d!a>\t\u000f\t-&\u0005q\u0001\u0003B\u0005\u0019b-\u001b7m?\u000eD'o\u001c8p?R,gn]5p]RA!1\u001aBo\u0005C\u0014)\u000f\u0005\u0004\u0002z\n5'\u0011[\u0005\u0005\u0005\u001f\u0014iA\u0001\u0003MSN$\b\u0003\u0002Bj\u00053l!A!6\u000b\t\t]'qL\u0001\u0007S:\u0004X\u000f^:\n\t\tm'Q\u001b\u0002\u000e\u0007\"\u0014xN\\8UK:\u001c\u0018n\u001c8\t\u000f\t}7\u00051\u0001\u0003B\u0005Q1-\u001e:sK:$H)Y=\t\u000f\t\r8\u00051\u0001\u0003L\u0006\t\"/Z7bS:Lgn\u001a+f]NLwN\\:\t\u000f\t\u001d8\u00051\u0001\u0003L\u0006q!/Z:vYR$VM\\:j_:\u001c\bfA\u0012\u0003lB!!Q\u001eBz\u001b\t\u0011yOC\u0002\u0003rj\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Pa<\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006q\u0011N\u001c9vi~\u0013tl\u00197j[\u0006$H\u0003\u0002B~\u0007\u0003!bAa(\u0003~\n}\bbBA{I\u0001\u000f\u0011q\u001f\u0005\b\u0005W#\u00039\u0001B!\u0011\u001d\u0011Y\f\na\u0001\u0005\u001b\u000bab\u00195s_:L7\rV8JCZ\u000bG\u000e\u0006\u0003\u0004\b\rE\u0001CBA}\u0005\u001b\u001cI\u0001\u0005\u0004\u0002z\n571\u0002\t\u0005\u0005#\u001bi!\u0003\u0003\u0004\u0010\tM%!B%B-\u0006d\u0007bBB\nK\u0001\u00071QC\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002z\n%1q\u0003\t\u0005\u00073\u0019\t#\u0004\u0002\u0004\u001c)!1QDB\u0010\u0003\u001d\u0019\u0007N]8oS\u000eTAA!\u0006\u0002\u0010%!11EB\u000e\u0005Q\u0001F.\u001e<j_\u000eC'o\u001c8jG6+\u0017m];sK\u0006\t2-\u00197dk2\fG/\u001a3U_&\u000bg+\u00197\u0015\t\r\u001d1\u0011\u0006\u0005\b\u0007'1\u0003\u0019AB\u0016!\u0019\tIP!\u0003\u0004.A!!\u0011SB\u0018\u0013\u0011\u0019\tDa%\u0003#\r\u000bGnY;mCR,G-T3bgV\u0014X-A\u0006gS2dwl\u00197j[\u0006$HCCB\u0004\u0007o\u0019Id!\u0010\u0004B!9!q\\\u0014A\u0002\t\u0005\u0003bBB\u001eO\u0001\u00071qA\u0001\u000ee\u0016l\u0017-\u001b8j]\u001e$\u0015\r^1\t\u000f\r}r\u00051\u0001\u0004\b\u0005Q!/Z:vYR$\u0015\r^1\t\u000f\r\rs\u00051\u0001\u00032\u0005AA.Y:u)\u0016l\u0007\u000fK\u0002(\u0005W\f!#\u001b8qkR|6gX5se&<wLZ5mKR111JB)\u0007'\"bAa(\u0004N\r=\u0003bBA{Q\u0001\u000f\u0011q\u001f\u0005\b\u0005WC\u00039\u0001B!\u0011\u001d\t\t\b\u000ba\u0001\u0005;AqAa/)\u0001\u0004\u0011i)\u0001\nj]B,Ho\u0018\u001b`a\u0006\u0014\u0018-\\3ue\u0016\u001cH\u0003BB-\u0007?\"bAa(\u0004\\\ru\u0003bBA{S\u0001\u000f\u0011q\u001f\u0005\b\u0005WK\u00039\u0001B!\u0011\u001d\u0011Y,\u000ba\u0001\u0005\u001b\u000b\u0001#\u001b8qkR|Vg\u00189be\u0006lw,R#\u0015\t\r\u00154\u0011\u000e\u000b\u0005\u0005?\u001b9\u0007C\u0004\u0002v*\u0002\u001d!a>\t\u000f\tm&\u00061\u0001\u0003\u000e\u0006\u0019\u0012N\u001c9vi~\u000b\u0004gX5se&<W.Y6feR!1qNB;)\u0019\u0011yj!\u001d\u0004t!9\u0011Q_\u0016A\u0004\u0005]\bb\u0002BVW\u0001\u000f!\u0011\t\u0005\b\u0005w[\u0003\u0019\u0001BG\u0003YIg\u000e];u?N:t\f]1sC6|V)R#`!N+ECAB>)\u0019\u0011yj! \u0004\u0000!9\u0011Q\u001f\u0017A\u0004\u0005]\bb\u0002BVY\u0001\u000f!\u0011\t\u0015\u0004\u0001\r\r\u0005\u0003BAX\u0007\u000bKAaa\"\u00022\nI1+\u001b8hY\u0016$xN\u001c")
public class OptirrigModel {
    private final LogUtil logUtil;
    private final JobLogUtil JobLogUtil;
    private final RSEauDao RSEauDao;
    private final IAEauCallUtil IAEauCallUtil;
    private final PluvioChronicDao pluvioChronicDao;
    private final CalculatedMeasureDao calculatedMeasureDao;
    private final GenericMeasuresDao genericMeasuresDao;
    private final SieauParametersDao SieauParametersDao;
    private final CounterVolumeDao CounterVolumeDao;
    private final ExploitationDao exploitationDao;
    private final RSEauController RSEauController;
    private final int rainDataType;
    private final int etpDataType;
    private final int radiationDataType;
    private final int temperatureDataType;

    public int rainDataType() {
        return this.rainDataType;
    }

    public int etpDataType() {
        return this.etpDataType;
    }

    public int radiationDataType() {
        return this.radiationDataType;
    }

    public int temperatureDataType() {
        return this.temperatureDataType;
    }

    public void calculateOptirrig(long jobExecutionId) {
        Seq parameters = this.SieauParametersDao.getAll((Option)new Some((Object)"RSEau"), this.SieauParametersDao.getAll$default$2());
        Seq exploitations = this.exploitationDao.getExploitationsWithStats();
        exploitations.foreach((Function1 & Serializable)expl -> {
            OptirrigModel.$anonfun$calculateOptirrig$1(this, jobExecutionId, parameters, expl);
            return BoxedUnit.UNIT;
        });
    }

    public void calculateOptirrigForExploitation(ExploitationWithLinks exploitation, long jobExecutionId, Seq<SieauParameters> parameters) {
        String logCode = new StringBuilder(11).append("RSEau_expl_").append(exploitation.idExploitation()).toString();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Land landFound = (Land)((IterableOps)exploitation.link_lands().getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(33).append("Can't find land for exploitation ").append(exploitation.idExploitation()).toString());
            })).headOption().getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(33).append("Can't find land for exploitation ").append(exploitation.idExploitation()).toString());
            });
            boolean useSimulation = SettingUtil$.MODULE$.getSIEauSettingBool(parameters, "RSEau_Use_Simulation_Date").contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
            DateTime simulationDate = useSimulation ? (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_Simulation").getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No simulation date on parameters");
            }) : new DateTime();
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Getting Optirrig inputs...", logCode, $this.JobLogUtil.log$default$5());
            JsObject input = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overrideInputNodes"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5, 6})), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputsToTake"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{19, 22, 23, 24, 25, 26, 29, 38})), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.IntWrites())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputs"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(this.getInputs(exploitation, parameters, simulationDate), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)AquasysData$.MODULE$.formatAquasysData())))}));
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Call OPTIRRIG", logCode, $this.JobLogUtil.log$default$5());
            Seq results = $this.IAEauCallUtil.callIAEau("OPTIRRIG_AQUASYS", input, "", logCode, (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), $this.IAEauCallUtil.callIAEau$default$6(), $this.IAEauCallUtil.callIAEau$default$7(), $this.IAEauCallUtil.callIAEau$default$8());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Reading daily vars Obs", logCode, $this.JobLogUtil.log$default$5());
            String simulationDateParam = simulationDate.toString("YYYY-MM-dd");
            double maxEE = BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_Max_EE").getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No Max EE on parameters");
            }));
            Seq gaugeSteps = (Seq)((StrictOptimizedIterableOps)Range.Partial$.MODULE$.by$extension(BigDecimal$.MODULE$.double2bigDecimal(0.0).until(BigDecimal$.MODULE$.double2bigDecimal(maxEE)), (Object)BigDecimal$.MODULE$.double2bigDecimal(maxEE / (double)7))).map((Function1 & Serializable)nb -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt2(nb.toDouble())));
            DateTime j_day = (DateTime)DateUtil$.MODULE$.formatDate((Option)new Some((Object)simulationDateParam)).get();
            String j_day_str = DateUtil$.MODULE$.getDate(j_day);
            DateTime j_1_day = j_day.minusDays(1);
            String j_1_day_str = DateUtil$.MODULE$.getDate(j_1_day);
            String j_m10_day_str = DateUtil$.MODULE$.getDate(j_day.minusDays(10));
            String j_p10_day_str = DateUtil$.MODULE$.getDate(j_day.plusDays(10));
            int standardStrategy = 5;
            Seq eeePseList = (Seq)IAEauUtils$.MODULE$.getAquasysData((Seq<AquasysData>)results, "Resultat_EEE_PSE.csv").data().map((Function1 & Serializable)d -> new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)((IAVal)d.apply(3)).value().get()), BoxesRunTime.unboxToDouble((Object)((IAVal)d.apply(4)).value().get())));
            Seq dailyVars = (Seq)((SeqOps)((IterableOps)IAEauUtils$.MODULE$.getAquasysData((Seq<AquasysData>)results, "outputs_dailyvar_Obs.csv").data().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq d = (Seq)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    DateTime date = new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get()));
                    Tuple2 eeePse = (Tuple2)eeePseList.apply(idx);
                    return new OptirrigDailyVar(date, DateUtil$.MODULE$.getDate(date), BoxesRunTime.unboxToDouble((Object)((IAVal)d.apply(1)).value().get()), BoxesRunTime.unboxToDouble((Object)((IAVal)d.apply(2)).value().get()), (Option<Object>)((IAVal)d.apply(3)).value(), (Option<Object>)((IAVal)d.apply(4)).value(), (Option<Object>)((IAVal)d.apply(5)).value(), (Option<Object>)((IAVal)d.apply(7)).value(), eeePse._1$mcD$sp(), eeePse._2$mcD$sp());
                }
                throw new MatchError((Object)tuple2);
            })).sortBy((Function1 & Serializable)d -> BoxesRunTime.boxToLong((long)OptirrigModel.$anonfun$calculateOptirrigForExploitation$9(d)), (Ordering)Ordering.Long$.MODULE$);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Reading strategies", logCode, $this.JobLogUtil.log$default$5());
            Seq strategies = (Seq)((IterableOps)new .colon.colon(IAEauUtils$.MODULE$.getAquasysDataOption((Seq<AquasysData>)results, "ISS1.csv"), (List)new .colon.colon(IAEauUtils$.MODULE$.getAquasysDataOption((Seq<AquasysData>)results, "ISS2.csv"), (List)new .colon.colon(IAEauUtils$.MODULE$.getAquasysDataOption((Seq<AquasysData>)results, "ISS3.csv"), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)iss -> {
                Option found = ((IterableOnceOps)iss.data().sortBy((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)OptirrigModel.$anonfun$calculateOptirrigForExploitation$11(d)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$12(j_day, d)));
                RSEauStrategy strat = new RSEauStrategy(landFound.id(), (Option<String>)iss.name().map((Function1 & Serializable)x$1 -> x$1.replace(".csv", "")), (Option<DateTime>)new Some(found.map((Function1 & Serializable)d -> new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get()))).getOrElse((Function0 & Serializable)() -> j_day)), (Option<Object>)found.flatMap((Function1 & Serializable)d -> ((IAVal)d.apply(1)).value()), RSEauStrategy$.MODULE$.apply$default$5(), RSEauStrategy$.MODULE$.apply$default$6());
                if (strat.date().isDefined()) {
                    long startDate = ((DateTime)strat.date().get()).withTimeAtStartOfDay().getMillis();
                    long endDate = DateUtil$.MODULE$.setMaxDay((DateTime)strat.date().get()).getMillis();
                    Option gain = IAEauUtils$.MODULE$.getAquasysDataOption((Seq<AquasysData>)results, new StringBuilder(21).append("outputs_dailyvar_").append(strat.name().get()).append(".csv").toString()).map((Function1 & Serializable)d -> {
                        Option gainValue = d.data().find((Function1 & Serializable)dd -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$18(startDate, endDate, dd))).map((Function1 & Serializable)dd -> BoxesRunTime.boxToDouble((double)OptirrigModel.$anonfun$calculateOptirrigForExploitation$19(dd)));
                        return new Tuple2((Object)gainValue, $this.RSEauController.getEcoNote((Seq<Object>)gaugeSteps, (Option<Object>)gainValue));
                    });
                    if (gain.isDefined()) {
                        Option x$12 = (Option)((Tuple2)gain.get())._1();
                        Option x$2 = (Option)((Tuple2)gain.get())._2();
                        int x$3 = strat.copy$default$1();
                        Option<String> x$4 = strat.copy$default$2();
                        Option<DateTime> x$5 = strat.copy$default$3();
                        Option<Object> x$6 = strat.copy$default$4();
                        return strat.copy(x$3, x$4, x$5, x$6, (Option<Object>)x$12, (Option<String>)x$2);
                    }
                    return strat;
                }
                return strat;
            });
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Building RSEau data", logCode, $this.JobLogUtil.log$default$5());
            Option today_daily_var = dailyVars.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$21(j_day_str, d)));
            Option m10_daily_var = dailyVars.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$22(j_m10_day_str, d)));
            Option p10_daily_var = dailyVars.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$23(j_p10_day_str, d)));
            Option nextDailyVar = p10_daily_var.isDefined() ? p10_daily_var : dailyVars.lastOption();
            RSEauDaily rseauDaily = new RSEauDaily(j_day, landFound.id(), (Option<Object>)dailyVars.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$24(j_1_day_str, d))).map((Function1 & Serializable)v -> BoxesRunTime.boxToDouble((double)v.irrCum())), (Option<Object>)today_daily_var.flatMap((Function1 & Serializable)d -> d.ratio_a()), (Option<Object>)today_daily_var.map((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(1, d.EEE()))), (Option<Object>)dailyVars.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculateOptirrigForExploitation$28(j_1_day_str, d))).flatMap((Function1 & Serializable)v -> v.stress_wlai().map((Function1)(JFunction1.mcID.sp & Serializable)stress -> this.getStressWater(stress))), this.getStressDay((Seq<OptirrigDailyVar>)dailyVars, j_day), (Option<Object>)m10_daily_var.map((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(1, d.EEE()))), (Option<Object>)nextDailyVar.map((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(1, d.EEE()))), (Option<Object>)today_daily_var.map((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(1, d.PSE()))), (Option<Object>)m10_daily_var.map((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(1, d.PSE()))), (Option<Object>)nextDailyVar.map((Function1 & Serializable)d -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(1, d.PSE()))), (Seq<RSEauStrategy>)strategies, RSEauDaily$.MODULE$.apply$default$14());
            $this.RSEauDao.setRSEauDaily((Seq<RSEauDaily>)new .colon.colon((Object)rseauDaily, (List)Nil$.MODULE$));
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "RSEau data saved with success", logCode, $this.JobLogUtil.log$default$5());
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), exception.getMessage(), logCode, this.JobLogUtil.log$default$5());
            this.logUtil.printError(exception);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public int getStressWater(double stress_wlai) {
        double d = stress_wlai;
        if (stress_wlai >= 0.8) {
            return 5;
        }
        if (stress_wlai >= 0.7) {
            return 4;
        }
        if (stress_wlai >= 0.5) {
            return 3;
        }
        if (stress_wlai >= 0.33) {
            return 2;
        }
        if (stress_wlai >= 0.1) {
            return 1;
        }
        return 0;
    }

    public Option<DateTime> getStressDay(Seq<OptirrigDailyVar> dailyVars, DateTime j_day) {
        DateTime today = j_day.withTimeAtStartOfDay();
        Seq futureVars = (Seq)dailyVars.filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$getStressDay$1(today, d)));
        if (futureVars.forall((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$getStressDay$2(v)))) {
            return None$.MODULE$;
        }
        return (Option)futureVars.foldLeft((Object)None$.MODULE$, (Function2 & Serializable)(acc, dailyVar) -> {
            if (acc.isDefined()) {
                return acc;
            }
            if (dailyVar.stress_wlai().isDefined() && BoxesRunTime.unboxToDouble((Object)dailyVar.stress_wlai().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) < 0.5) {
                return new Some((Object)dailyVar.date());
            }
            return None$.MODULE$;
        });
    }

    public void checkField(String field, Seq<GenericMeasure> landParameters, Seq<SieauParameters> parameters) {
        boolean found;
        boolean bl = found = landParameters.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$checkField$1(field, x$2))).flatMap((Function1 & Serializable)x$3 -> x$3.value().map((Function1 & Serializable)v -> OptirrigModel.$anonfun$checkField$3(BoxesRunTime.unboxToDouble((Object)v)))).isDefined() || SettingUtil$.MODULE$.getSIEauSettingDate(parameters, new StringBuilder(17).append("RSEau_parametres_").append(field).toString()).isDefined();
        if (!found) {
            throw new Exception(new StringBuilder(63).append(field).append(" parameter not defined in land parameters or default parameters").toString());
        }
    }

    public Seq<AquasysData> getInputs(ExploitationWithLinks exploitation, Seq<SieauParameters> parameters, DateTime simulationDate) {
        Seq landParameters = this.genericMeasuresDao.getMeasures(GenericMeasuresConstants$.MODULE$.OBJECT_LAND(), ((Land)((IterableOps)exploitation.link_lands().get()).head()).id(), GenericMeasuresConstants$.MODULE$.MEASURE_TYPE_RSEAU_LAND_PARAMETERS());
        new .colon.colon((Object)"jdir", (List)new .colon.colon((Object)"jfir", (List)new .colon.colon((Object)"jsem", (List)new .colon.colon((Object)"jrecol", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)field -> {
            this.checkField(field, (Seq<GenericMeasure>)landParameters, (Seq<SieauParameters>)parameters);
            return BoxedUnit.UNIT;
        });
        return (Seq)new .colon.colon(this.input_1_chrono_tension((Seq<GenericMeasure>)landParameters, parameters, simulationDate), (List)new .colon.colon(this.input_2_climat((Seq<GenericMeasure>)landParameters, parameters, simulationDate), (List)new .colon.colon(this.input_3_irrig_file(exploitation, (Seq<GenericMeasure>)landParameters, parameters, simulationDate), (List)new .colon.colon(this.input_4_parametres((Seq<GenericMeasure>)landParameters, parameters, simulationDate), (List)new .colon.colon(this.input_5_param_EE((Seq<GenericMeasure>)landParameters, parameters), (List)new .colon.colon(this.input_10_irrigmaker((Seq<GenericMeasure>)landParameters, parameters, simulationDate), (List)new .colon.colon(this.input_37_param_EEE_PSE(parameters, simulationDate), (List)Nil$.MODULE$))))))).flatten(Predef$.MODULE$.$conforms());
    }

    public Seq<AquasysData> input_1_chrono_tension(Seq<GenericMeasure> landParams, Seq<SieauParameters> parameters, DateTime simulationDate) {
        DateTime startCampaignDate = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_Deb_Camp").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No start campaign date on parameters");
        });
        DateTime firstDay = startCampaignDate.withDayOfYear(1).withTimeAtStartOfDay();
        DateTime jfir = OR_Parametres$.MODULE$.getParameterDate(parameters, landParams, "jfir", new DateTime());
        Seq tensions = (Seq)((SeqOps)this.genericMeasuresDao.getMeasures(GenericMeasuresConstants$.MODULE$.OBJECT_GLOBAL(), 0, GenericMeasuresConstants$.MODULE$.MEASURE_TYPE_RSEAU_CHRONO_TENSION()).map((Function1 & Serializable)m -> new ChronoTension((DateTime)m.date().get(), (int)BoxesRunTime.unboxToDouble((Object)m.value().get()), 1))).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)OptirrigModel.$anonfun$input_1_chrono_tension$3(x$4)), (Ordering)Ordering.Long$.MODULE$);
        DateTime fistDayFound = firstDay.getMillis() < ((ChronoTension)tensions.head()).date().withTimeAtStartOfDay().getMillis() ? firstDay : ((ChronoTension)tensions.head()).date().withTimeAtStartOfDay();
        .colon.colon jfirMeasure = tensions.nonEmpty() && ((ChronoTension)tensions.last()).date().withTimeAtStartOfDay().getMillis() >= jfir.withTimeAtStartOfDay().getMillis() ? Nil$.MODULE$ : new .colon.colon((Object)new ChronoTension(jfir, 1, 1), (List)Nil$.MODULE$);
        List<ChronoTension> filledTensions = this.fill_chrono_tension(fistDayFound, (List<ChronoTension>)((List)tensions.toList().$plus$plus((IterableOnce)jfirMeasure)), (List<ChronoTension>)Nil$.MODULE$);
        return new .colon.colon((Object)ChronoTension$.MODULE$.toAquasysData((Seq<ChronoTension>)filledTensions), (List)Nil$.MODULE$);
    }

    public DateTime getRestrDateWithDD(Seq<SieauParameters> parameters, DateTime simulationDate) {
        DateTime debutRestr = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_debut_restriction").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Pas de date de d\u00e9but de restriction de d\u00e9finie");
        });
        Option option = this.RSEauDao.getRSEauDaily((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), simulationDate).headOption();
        if (None$.MODULE$.equals(option)) {
            return debutRestr;
        }
        if (option instanceof Some) {
            boolean hasDD2;
            Some some = (Some)option;
            RSEauDaily results = (RSEauDaily)some.value();
            DateTime dd1Date = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_DD1").getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No DD1 date on parameters");
            });
            DateTime dd2Date = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_DD2").getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No DD2 date on parameters");
            });
            double maxEE = BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_Max_EE").getOrElse((Function0 & Serializable)() -> {
                throw new Exception("No Max EE on parameters");
            }));
            Option<Object> EEE = results.EEE();
            Seq gaugeSteps = (Seq)((StrictOptimizedIterableOps)Range.Partial$.MODULE$.by$extension(BigDecimal$.MODULE$.double2bigDecimal(0.0).until(BigDecimal$.MODULE$.double2bigDecimal(maxEE)), (Object)BigDecimal$.MODULE$.double2bigDecimal(maxEE / (double)7))).map((Function1 & Serializable)nb -> BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt2(nb.toDouble())));
            boolean hasDD1 = gaugeSteps.indexWhere((Function1)(JFunction1.mcZD.sp & Serializable)step -> step >= BoxesRunTime.unboxToDouble((Object)EEE.getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))) + 1 >= 4;
            boolean bl = hasDD2 = gaugeSteps.indexWhere((Function1)(JFunction1.mcZD.sp & Serializable)step -> step >= BoxesRunTime.unboxToDouble((Object)EEE.getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))) + 1 >= 6;
            if (hasDD1 && hasDD2) {
                return dd2Date;
            }
            if (hasDD1) {
                return dd1Date;
            }
            return debutRestr;
        }
        throw new MatchError((Object)option);
    }

    public final List<ChronoTension> fill_chrono_tension(DateTime currentDay, List<ChronoTension> remainingTensions, List<ChronoTension> resultTensions) {
        List list;
        while (true) {
            if (Nil$.MODULE$.equals(list = remainingTensions)) {
                return resultTensions;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            ChronoTension head = (ChronoTension)colon2.head();
            List tail = colon2.next$access$1();
            String string = currentDay.toString("dd/MM/YYYY");
            String string2 = head.date().toString("dd/MM/YYYY");
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                resultTensions = (List)resultTensions.$colon$plus((Object)head);
                remainingTensions = tail;
                currentDay = currentDay.plusDays(1);
                continue;
            }
            resultTensions = (List)resultTensions.$colon$plus((Object)new ChronoTension(currentDay, 1, 1));
            currentDay = currentDay.plusDays(1);
        }
        throw new MatchError(list);
    }

    public Seq<AquasysData> input_2_climat(Seq<GenericMeasure> landParams, Seq<SieauParameters> parameters, DateTime simulationDate) {
        DateTime startCampaignDate = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_Deb_Camp").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No start campaign date on parameters");
        });
        DateTime jfir = OR_Parametres$.MODULE$.getParameterDate(parameters, landParams, "jfir", new DateTime());
        int pluvioId = OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "pluvioId", 3);
        DateTime usedStart = (startCampaignDate.getMillis() > simulationDate.getMillis() ? simulationDate : startCampaignDate).withDayOfYear(1);
        int x$1 = pluvioId;
        Some x$2 = new Some((Object)usedStart);
        Some x$3 = new Some((Object)simulationDate);
        boolean x$4 = false;
        String x$52 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
        Seq x$6 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
        Option x$7 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
        Option x$8 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = MeasuresParams$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
        Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
        Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
        Option x$22 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
        Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
        Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
        Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
        Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
        List<List<IAVal>> obsMeasures = this.chronicToIaVal((Seq<PluvioChronicMeasure>)this.pluvioChronicDao.getAllTypes(new MeasuresParams(x$52, x$1, x$6, 0, x$7, (Option)x$2, (Option)x$3, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26)));
        int x$27 = pluvioId;
        String x$28 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
        Some x$29 = new Some((Object)simulationDate);
        Some x$30 = new Some((Object)jfir);
        Some x$31 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        Option x$32 = this.calculatedMeasureDao.getMeasures$default$5();
        List<List<IAVal>> prevMeasures = this.calculatedToIaVal((Seq<CalculatedMeasure>)this.calculatedMeasureDao.getMeasures(x$27, x$28, (Option)x$29, (Option)x$30, x$32, (Option)x$31));
        Nil$ jfirMeasure = prevMeasures.exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$input_2_climat$2(jfir, d))) ? Nil$.MODULE$ : new .colon.colon((Object)new .colon.colon((Object)new IAVal((double)jfir.getMillis()), (List)new .colon.colon((Object)new IAVal(0.0), (List)new .colon.colon((Object)new IAVal(0.0), (List)new .colon.colon((Object)new IAVal(0.0), (List)new .colon.colon((Object)new IAVal(((IAVal)((LinearSeqOps)prevMeasures.last()).apply(4)).value(), IAVal$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$);
        List<List<IAVal>> filledData = this.fill_climat(usedStart, (List<List<IAVal>>)((List)((SeqOps)((IterableOps)obsMeasures.$plus$plus(prevMeasures)).$plus$plus((IterableOnce)jfirMeasure)).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)OptirrigModel.$anonfun$input_2_climat$3(x$5)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), (List<List<IAVal>>)Nil$.MODULE$, 0.0);
        String climatJson = "[{\"column\":1,\"name\":\"Date\",\"columnNb\":1,\"dataFormat\":\"date\"},{\"column\":2,\"columnNb\":2,\"name\":\"P\",\"dataFormat\":\"number\"},{\"column\":3,\"columnNb\":3,\"name\":\"etp\",\"dataFormat\":\"number\"},{\"column\":4,\"columnNb\":4,\"name\":\"Rg\",\"dataFormat\":\"number\"},{\"column\":5,\"columnNb\":5,\"name\":\"T\",\"dataFormat\":\"number\"}]";
        int x$33 = 2;
        Some x$34 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Some x$35 = new Some((Object)"climat.csv");
        Seq x$36 = (Seq)Json$.MODULE$.parse(climatJson).validate(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)AquasysDataColumn$.MODULE$.format())).get();
        List<List<IAVal>> x$37 = filledData;
        Option x$38 = AquasysData$.MODULE$.$lessinit$greater$default$5();
        Option x$39 = AquasysData$.MODULE$.$lessinit$greater$default$7();
        Option x$40 = AquasysData$.MODULE$.$lessinit$greater$default$8();
        Option x$41 = AquasysData$.MODULE$.$lessinit$greater$default$9();
        Option x$42 = AquasysData$.MODULE$.$lessinit$greater$default$10();
        Option x$43 = AquasysData$.MODULE$.$lessinit$greater$default$11();
        AquasysData aq = new AquasysData(2, (Option)x$34, x$36, (Option)x$35, x$38, x$37, x$39, x$40, x$41, x$42, x$43);
        return new .colon.colon((Object)aq, (List)Nil$.MODULE$);
    }

    public List<List<IAVal>> chronicToIaVal(Seq<PluvioChronicMeasure> data) {
        Map grouped = data.groupBy((Function1 & Serializable)m -> DateUtil$.MODULE$.getDate(m.date()));
        return ((IterableOnceOps)grouped.keys().map((Function1 & Serializable)date -> {
            Seq dateMeasures = (Seq)grouped.apply(date);
            Seq etpMeasures = (Seq)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$chronicToIaVal$3(this, x$6)))).flatMap((Function1 & Serializable)x$7 -> x$7.value());
            Seq tempMeasures = (Seq)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$chronicToIaVal$5(this, x$8)))).flatMap((Function1 & Serializable)x$9 -> x$9.value());
            return new .colon.colon((Object)new IAVal((double)((PluvioChronicMeasure)dateMeasures.head()).date().getMillis()), (List)new .colon.colon((Object)new IAVal(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$chronicToIaVal$7(this, x$10)))).flatMap((Function1 & Serializable)x$11 -> x$11.value())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))), (List)new .colon.colon((Object)new IAVal(etpMeasures.nonEmpty() ? BoxesRunTime.unboxToDouble((Object)etpMeasures.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)etpMeasures.length() : 0.0), (List)new .colon.colon((Object)new IAVal(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$chronicToIaVal$9(this, x$12)))).flatMap((Function1 & Serializable)x$13 -> x$13.value())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))), (List)new .colon.colon((Object)new IAVal(tempMeasures.nonEmpty() ? BoxesRunTime.unboxToDouble((Object)tempMeasures.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)tempMeasures.length() : 0.0), (List)Nil$.MODULE$)))));
        })).toList();
    }

    public List<List<IAVal>> calculatedToIaVal(Seq<CalculatedMeasure> data) {
        Map grouped = data.groupBy((Function1 & Serializable)m -> DateUtil$.MODULE$.getDate(m.date()));
        return ((IterableOnceOps)grouped.keys().map((Function1 & Serializable)date -> {
            Seq dateMeasures = (Seq)grouped.apply(date);
            Seq radiationMeasures = (Seq)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculatedToIaVal$3(this, x$14)))).flatMap((Function1 & Serializable)x$15 -> x$15.value());
            Seq etpMeasures = (Seq)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculatedToIaVal$5(this, x$16)))).flatMap((Function1 & Serializable)x$17 -> x$17.value());
            Seq tempMeasures = (Seq)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculatedToIaVal$7(this, x$18)))).flatMap((Function1 & Serializable)x$19 -> x$19.value());
            return new .colon.colon((Object)new IAVal((double)((CalculatedMeasure)dateMeasures.head()).date().getMillis()), (List)new .colon.colon((Object)new IAVal(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)dateMeasures.filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)OptirrigModel.$anonfun$calculatedToIaVal$9(this, x$20)))).flatMap((Function1 & Serializable)x$21 -> x$21.value())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))), (List)new .colon.colon((Object)new IAVal(etpMeasures.nonEmpty() ? BoxesRunTime.unboxToDouble((Object)etpMeasures.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)etpMeasures.length() : 0.0), (List)new .colon.colon((Object)new IAVal(radiationMeasures.nonEmpty() ? BoxesRunTime.unboxToDouble((Object)radiationMeasures.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)radiationMeasures.length() : 0.0), (List)new .colon.colon((Object)new IAVal(tempMeasures.nonEmpty() ? BoxesRunTime.unboxToDouble((Object)tempMeasures.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)tempMeasures.length() : 0.0), (List)Nil$.MODULE$)))));
        })).toList();
    }

    public final List<List<IAVal>> fill_climat(DateTime currentDay, List<List<IAVal>> remainingData, List<List<IAVal>> resultData, double lastTemp) {
        List list;
        while (true) {
            if (Nil$.MODULE$.equals(list = remainingData)) {
                return resultData;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List head = (List)colon2.head();
            List tail = colon2.next$access$1();
            String string = currentDay.toString("dd/MM/YYYY");
            String string2 = new DateTime((long)BoxesRunTime.unboxToDouble((Object)((IAVal)head.head()).value().get())).toString("dd/MM/YYYY");
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                double newTemp;
                lastTemp = newTemp = BoxesRunTime.unboxToDouble((Object)((IAVal)head.apply(4)).value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
                resultData = (List)resultData.$colon$plus((Object)head);
                remainingData = tail;
                currentDay = currentDay.plusDays(1);
                continue;
            }
            .colon.colon colon3 = new .colon.colon((Object)new IAVal((double)currentDay.getMillis()), (List)new .colon.colon((Object)new IAVal(0.0), (List)new .colon.colon((Object)new IAVal(0.0), (List)new .colon.colon((Object)new IAVal(0.0), (List)new .colon.colon((Object)new IAVal(lastTemp), (List)Nil$.MODULE$)))));
            resultData = (List)resultData.$colon$plus((Object)colon3);
            currentDay = currentDay.plusDays(1);
        }
        throw new MatchError(list);
    }

    public Seq<AquasysData> input_3_irrig_file(ExploitationWithLinks exploitation, Seq<GenericMeasure> landParams, Seq<SieauParameters> parameters, DateTime simulationDate) {
        Tuple2 tuple2 = new Tuple2((Object)((IterableOps)exploitation.link_samplings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).headOption(), (Object)((IterableOps)exploitation.link_lands().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).headOption());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                ExploitationSamplingPointWithLinks samplingPoint = (ExploitationSamplingPointWithLinks)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Land parcel = (Land)some2.value();
                    if (parcel.area().isEmpty() || parcel.area().contains((Object)BoxesRunTime.boxToDouble((double)0.0))) {
                        throw new Exception("Land found without defined area");
                    }
                    if (samplingPoint.idInstallation().isEmpty()) {
                        throw new Exception("Sampling point found without installation id");
                    }
                    DateTime startCampaignDate = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_Deb_Camp").getOrElse((Function0 & Serializable)() -> {
                        throw new Exception("No simulation date on parameters");
                    });
                    Seq measures = this.CounterVolumeDao.getSamplesM3((int)BoxesRunTime.unboxToLong((Object)samplingPoint.idInstallation().get()), (Option)new Some((Object)(simulationDate.getMillis() < startCampaignDate.getMillis() ? simulationDate : startCampaignDate)), (Option)new Some((Object)simulationDate));
                    int ratio = OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "ratioPrel", 100) / 100;
                    Seq doses2 = (Seq)measures.map((Function1 & Serializable)c -> new SGDose(c.date(), BoxesRunTime.unboxToDouble((Object)c.value().get()) / (double)10 * (double)ratio / BoxesRunTime.unboxToDouble((Object)parcel.area().get())));
                    Seq groupedDoses = (Seq)doses2.groupBy((Function1 & Serializable)d -> DateUtil$.MODULE$.getDate(d.date())).mapValues((Function1 & Serializable)doses -> new SGDose(((SGDose)doses.head()).date(), BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)doses.map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22.dose()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)))).values().toSeq().sortBy((Function1 & Serializable)x$23 -> BoxesRunTime.boxToLong((long)OptirrigModel.$anonfun$input_3_irrig_file$8(x$23)), (Ordering)Ordering.Long$.MODULE$);
                    return new .colon.colon((Object)SGDose$.MODULE$.toAquasysData((Seq<SGDose>)groupedDoses), (List)Nil$.MODULE$);
                }
            }
        }
        if (tuple2 != null) {
            return new .colon.colon((Object)SGDose$.MODULE$.toAquasysData((Seq<SGDose>)((Seq)Nil$.MODULE$)), (List)Nil$.MODULE$);
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<AquasysData> input_4_parametres(Seq<GenericMeasure> landParams, Seq<SieauParameters> parameters, DateTime simulationDate) {
        DateTime startCampaignDate;
        DateTime jdsim = startCampaignDate = (DateTime)SettingUtil$.MODULE$.getSIEauSettingDate(parameters, "RSEau_Date_Deb_Camp").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No simulation date on parameters");
        });
        DateTime jfsim = simulationDate.plusDays(7);
        OR_Parametres obs = new OR_Parametres("Obs", "Climat.csv", simulationDate.year().get(), "irrig_file.csv", jdsim, jfsim, parameters, landParams, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        OR_Parametres iss1 = new OR_Parametres("ISS1", "Climat.csv", simulationDate.year().get(), "ISS1.csv", jdsim, jfsim, parameters, landParams, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        OR_Parametres iss2 = new OR_Parametres("ISS2", "Climat.csv", simulationDate.year().get(), "ISS2.csv", jdsim, jfsim, parameters, landParams, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        OR_Parametres iss3 = new OR_Parametres("ISS3", "Climat.csv", simulationDate.year().get(), "ISS3.csv", jdsim, jfsim, parameters, landParams, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        OR_Parametres rend = new OR_Parametres("Ref", "Climat.csv", simulationDate.year().get(), "", jdsim, jfsim, parameters, landParams, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)95.0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)30.0)));
        return new .colon.colon((Object)OR_Parametres$.MODULE$.toAquasysData((Seq<OR_Parametres>)new .colon.colon((Object)obs, (List)new .colon.colon((Object)iss1, (List)new .colon.colon((Object)iss2, (List)new .colon.colon((Object)iss3, (List)new .colon.colon((Object)rend, (List)Nil$.MODULE$)))))), (List)Nil$.MODULE$);
    }

    public Seq<AquasysData> input_5_param_EE(Seq<GenericMeasure> landParams, Seq<SieauParameters> parameters) {
        String climatJson = "[{\"column\":1,\"name\":\"Tension\",\"dataFormat\":\"text\",\"columnNb\":1},{\"column\":2,\"name\":\"PE\",\"dataFormat\":\"number\",\"columnNb\":2},{\"column\":3,\"name\":\"Pvente\",\"dataFormat\":\"number\",\"columnNb\":3},{\"column\":4,\"name\":\"Pnrj\",\"dataFormat\":\"number\",\"columnNb\":4},{\"column\":5,\"name\":\"Cfixe\",\"dataFormat\":\"number\",\"columnNb\":5},{\"column\":6,\"name\":\"MN\",\"dataFormat\":\"number\",\"columnNb\":6},{\"column\":7,\"name\":\"MA\",\"dataFormat\":\"number\",\"columnNb\":7},{\"column\":11,\"name\":\"MC\",\"dataFormat\":\"number\",\"columnNb\":8},{\"column\":12,\"name\":\"infDD1\",\"dataFormat\":\"number\",\"columnNb\":9},{\"column\":13,\"name\":\"infDD2\",\"dataFormat\":\"number\",\"columnNb\":10},{\"column\":14,\"name\":\"DD1\",\"dataFormat\":\"number\",\"columnNb\":11},{\"column\":15,\"name\":\"DD2\",\"dataFormat\":\"number\",\"columnNb\":12},{\"column\":13,\"name\":\"SeuilRU\",\"dataFormat\":\"number\"},{\"column\":14,\"name\":\"P0\",\"dataFormat\":\"number\"},{\"column\":15,\"name\":\"n0\",\"dataFormat\":\"number\"}]";
        .colon.colon data = new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("chrono_tension.csv"), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "PE", 0.08)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "Pvente", 170.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "Pnrj", 0.5)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "Cfixe", 100.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "MN", 1.5)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "MA", 2.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "MC", 3.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "infDD1", 1.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "infDD2", 1.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "DD1", 7.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "DD2", 15.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "SeuilRU", 60.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "P0", 20.0)), new IAVal(OR_Parametres$.MODULE$.getParameter(parameters, landParams, "n0", 4.0))}))), (List)Nil$.MODULE$);
        int x$1 = 5;
        Some x$2 = new Some((Object)"param_EE.csv");
        Seq x$3 = (Seq)Json$.MODULE$.parse(climatJson).validate(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)AquasysDataColumn$.MODULE$.format())).get();
        .colon.colon x$4 = data;
        Option x$5 = AquasysData$.MODULE$.$lessinit$greater$default$2();
        Option x$6 = AquasysData$.MODULE$.$lessinit$greater$default$5();
        Option x$7 = AquasysData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = AquasysData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = AquasysData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = AquasysData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = AquasysData$.MODULE$.$lessinit$greater$default$11();
        AquasysData aq = new AquasysData(5, x$5, x$3, (Option)x$2, x$6, (Seq)x$4, x$7, x$8, x$9, x$10, x$11);
        return new .colon.colon((Object)aq, (List)Nil$.MODULE$);
    }

    public Seq<AquasysData> input_10_irrigmaker(Seq<GenericMeasure> landParams, Seq<SieauParameters> parameters, DateTime simulationDate) {
        String climatJson = "[{\"column\":1,\"name\":\"file\",\"dataFormat\":\"text\"},{\"column\":2,\"name\":\"saf\",\"dataFormat\":\"integer\"},{\"column\":3,\"name\":\"year\",\"dataFormat\":\"integer\"},{\"column\":4,\"name\":\"jdir\",\"dataFormat\":\"date\"},{\"column\":5,\"name\":\"jfir\",\"dataFormat\":\"date\"},{\"column\":6,\"name\":\"ndays\",\"dataFormat\":\"integer\"},{\"column\":7,\"name\":\"dose\",\"dataFormat\":\"integer\"},{\"column\":8,\"name\":\"skipif\",\"dataFormat\":\"integer\"},{\"column\":9,\"name\":\"quota\",\"dataFormat\":\"integer\"},{\"column\":10,\"name\":\"tcr\",\"dataFormat\":\"integer\"},{\"column\":11,\"name\":\"vfod\",\"dataFormat\":\"integer\"},{\"column\":12,\"name\":\"horizon\",\"dataFormat\":\"integer\"},{\"column\":13,\"name\":\"enoughR\",\"dataFormat\":\"integer\"}]";
        .colon.colon data = new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("Climat.csv"), new IAVal(0.0), new IAVal((double)simulationDate.getYear()), new IAVal((double)OR_Parametres$.MODULE$.getParameterDate(parameters, landParams, "jdir", new DateTime()).getMillis()), new IAVal((double)OR_Parametres$.MODULE$.getParameterDate(parameters, landParams, "jfir", new DateTime()).getMillis()), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "ndays", 7)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "dose", 30)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "skipif", 20)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "quota", 300)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "tcr", 20)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "vfod", 5)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "horizon", 4)), new IAVal((double)OR_Parametres$.MODULE$.getParameterInt(parameters, landParams, "enoughR", 15))}))), (List)Nil$.MODULE$);
        int x$1 = 10;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Some x$3 = new Some((Object)"irrigmaker.txt");
        Seq x$4 = (Seq)Json$.MODULE$.parse(climatJson).validate(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)AquasysDataColumn$.MODULE$.format())).get();
        .colon.colon x$5 = data;
        Option x$6 = AquasysData$.MODULE$.$lessinit$greater$default$5();
        Option x$7 = AquasysData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = AquasysData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = AquasysData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = AquasysData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = AquasysData$.MODULE$.$lessinit$greater$default$11();
        AquasysData aq = new AquasysData(10, (Option)x$2, x$4, (Option)x$3, x$6, (Seq)x$5, x$7, x$8, x$9, x$10, x$11);
        return new .colon.colon((Object)aq, (List)Nil$.MODULE$);
    }

    public Seq<AquasysData> input_37_param_EEE_PSE(Seq<SieauParameters> parameters, DateTime simulationDate) {
        String columnJson = "[{\"column\":1,\"name\":\"Param\u00e8tre\",\"dataFormat\":\"text\"},{\"column\":2,\"name\":\"Valeur\",\"dataFormat\":\"number\"}]";
        .colon.colon data = new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("SRU"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_SRU").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("RUmin"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_RUmin").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("M\u00e9rite N1"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_Merite_n1").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("M\u00e9rite N2"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_Merite_n2").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("M\u00e9rite N3"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_Merite_n3").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("Seuil PSE"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_Seuil_PSE").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IAVal[]{new IAVal("PSE"), new IAVal(BoxesRunTime.unboxToDouble((Object)SettingUtil$.MODULE$.getSIEauSettingDouble(parameters, "RSEau_PSE").getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No SRU on parameters");
        })))}))), (List)Nil$.MODULE$)))))));
        int x$1 = 37;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        Some x$3 = new Some((Object)"param_EEE_PSE.csv");
        Seq x$4 = (Seq)Json$.MODULE$.parse(columnJson).validate(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)AquasysDataColumn$.MODULE$.format())).get();
        .colon.colon x$5 = data;
        Option x$6 = AquasysData$.MODULE$.$lessinit$greater$default$5();
        Option x$7 = AquasysData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = AquasysData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = AquasysData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = AquasysData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = AquasysData$.MODULE$.$lessinit$greater$default$11();
        AquasysData aq = new AquasysData(37, (Option)x$2, x$4, (Option)x$3, x$6, (Seq)x$5, x$7, x$8, x$9, x$10, x$11);
        return new .colon.colon((Object)aq, (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$calculateOptirrig$1(OptirrigModel $this, long jobExecutionId$1, Seq parameters$1, ExploitationWithStats expl) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.JobLogUtil.checkExecutionAbort(jobExecutionId$1);
            ExploitationWithLinks exploitation = (ExploitationWithLinks)$this.exploitationDao.getExploitation(expl.idExploitation()).getOrElse((Function0 & Serializable)() -> {
                throw new IOException(new StringBuilder(36).append("Can't find exploitation for expl id ").append(expl.idExploitation()).toString());
            });
            $this.calculateOptirrigForExploitation(exploitation, jobExecutionId$1, (Seq<SieauParameters>)parameters$1);
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof IOException) {
                return;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            $this.logUtil.printError(e);
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(29).append("Error during optirrig call : ").append(e.getMessage()).toString(), new StringBuilder(11).append("RSEau_expl_").append(expl.idExploitation()).toString(), $this.JobLogUtil.log$default$5());
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ long $anonfun$calculateOptirrigForExploitation$9(OptirrigDailyVar d) {
        return d.date().getMillis();
    }

    public static final /* synthetic */ double $anonfun$calculateOptirrigForExploitation$11(Seq d) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get());
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$12(DateTime j_day$1, Seq d) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get()) >= (double)j_day$1.withTimeAtStartOfDay().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$18(long startDate$1, long endDate$1, Seq dd) {
        return (long)BoxesRunTime.unboxToDouble((Object)((IAVal)dd.head()).value().get()) >= startDate$1 && (long)BoxesRunTime.unboxToDouble((Object)((IAVal)dd.head()).value().get()) <= endDate$1;
    }

    public static final /* synthetic */ double $anonfun$calculateOptirrigForExploitation$19(Seq dd) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)dd.apply(6)).value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$21(String j_day_str$1, OptirrigDailyVar d) {
        String string = d.dateString();
        String string2 = j_day_str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$22(String j_m10_day_str$1, OptirrigDailyVar d) {
        String string = d.dateString();
        String string2 = j_m10_day_str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$23(String j_p10_day_str$1, OptirrigDailyVar d) {
        String string = d.dateString();
        String string2 = j_p10_day_str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$24(String j_1_day_str$1, OptirrigDailyVar d) {
        String string = d.dateString();
        String string2 = j_1_day_str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$calculateOptirrigForExploitation$28(String j_1_day_str$1, OptirrigDailyVar d) {
        String string = d.dateString();
        String string2 = j_1_day_str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStressDay$1(DateTime today$1, OptirrigDailyVar d) {
        return d.date().getMillis() >= today$1.getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$getStressDay$2(OptirrigDailyVar v) {
        return v.stress_wlai().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$checkField$1(String field$1, GenericMeasure x$2) {
        return x$2.valueStr().contains((Object)field$1);
    }

    public static final /* synthetic */ DateTime $anonfun$checkField$3(double v) {
        return new DateTime((long)v);
    }

    public static final /* synthetic */ long $anonfun$input_1_chrono_tension$3(ChronoTension x$4) {
        return x$4.date().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$input_2_climat$2(DateTime jfir$1, List d) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)d.head()).value().get()) > (double)jfir$1.withTimeAtStartOfDay().getMillis();
    }

    public static final /* synthetic */ double $anonfun$input_2_climat$3(List x$5) {
        return BoxesRunTime.unboxToDouble((Object)((IAVal)x$5.head()).value().get());
    }

    public static final /* synthetic */ boolean $anonfun$chronicToIaVal$3(OptirrigModel $this, PluvioChronicMeasure x$6) {
        return x$6.dataType() == $this.etpDataType();
    }

    public static final /* synthetic */ boolean $anonfun$chronicToIaVal$5(OptirrigModel $this, PluvioChronicMeasure x$8) {
        return x$8.dataType() == $this.temperatureDataType();
    }

    public static final /* synthetic */ boolean $anonfun$chronicToIaVal$7(OptirrigModel $this, PluvioChronicMeasure x$10) {
        return x$10.dataType() == $this.rainDataType();
    }

    public static final /* synthetic */ boolean $anonfun$chronicToIaVal$9(OptirrigModel $this, PluvioChronicMeasure x$12) {
        return x$12.dataType() == $this.radiationDataType();
    }

    public static final /* synthetic */ boolean $anonfun$calculatedToIaVal$3(OptirrigModel $this, CalculatedMeasure x$14) {
        return x$14.typeId() == $this.radiationDataType();
    }

    public static final /* synthetic */ boolean $anonfun$calculatedToIaVal$5(OptirrigModel $this, CalculatedMeasure x$16) {
        return x$16.typeId() == $this.etpDataType();
    }

    public static final /* synthetic */ boolean $anonfun$calculatedToIaVal$7(OptirrigModel $this, CalculatedMeasure x$18) {
        return x$18.typeId() == $this.temperatureDataType();
    }

    public static final /* synthetic */ boolean $anonfun$calculatedToIaVal$9(OptirrigModel $this, CalculatedMeasure x$20) {
        return x$20.typeId() == $this.rainDataType();
    }

    public static final /* synthetic */ long $anonfun$input_3_irrig_file$8(SGDose x$23) {
        return x$23.date().getMillis();
    }

    @Inject
    public OptirrigModel(WSClient ws, LogUtil logUtil, JobLogUtil JobLogUtil2, StationThresholdDao StationThresholdDao2, PiezometerMeasureDao PiezometerMeasureDao2, RSEauDao RSEauDao2, IAEauCallUtil IAEauCallUtil2, PiezometerDaeau piezometerDaeau, PluvioChronicDao pluvioChronicDao, CalculatedMeasureDao calculatedMeasureDao, GenericMeasuresDao genericMeasuresDao, SieauParametersDao SieauParametersDao2, CounterVolumeDao CounterVolumeDao2, SGDoseDao SGDoseDao2, UserDao userDao, ExploitationDao exploitationDao, RSEauController RSEauController2) {
        this.logUtil = logUtil;
        this.JobLogUtil = JobLogUtil2;
        this.RSEauDao = RSEauDao2;
        this.IAEauCallUtil = IAEauCallUtil2;
        this.pluvioChronicDao = pluvioChronicDao;
        this.calculatedMeasureDao = calculatedMeasureDao;
        this.genericMeasuresDao = genericMeasuresDao;
        this.SieauParametersDao = SieauParametersDao2;
        this.CounterVolumeDao = CounterVolumeDao2;
        this.exploitationDao = exploitationDao;
        this.RSEauController = RSEauController2;
        this.rainDataType = 1;
        this.etpDataType = 3;
        this.radiationDataType = 4;
        this.temperatureDataType = 5;
    }
}

