/*
 * Decompiled with CFR 0.152.
 */
package Alerting.dao.rpc;

import Alerting.model.Measure;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.station.model.MeasureDate;
import fr.aquasys.daeau.station.model.StationLight;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.constant.MailRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.ThresholdUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005u4A!\u0002\u0004\u0001\u001b!)\u0001\u0005\u0001C\u0001C!)Q\u0006\u0001C\u0001]!)1\t\u0001C\u0001\t\")q\r\u0001C\u0001Q\n9Q*Y5m\t\u0006|'BA\u0004\t\u0003\r\u0011\bo\u0019\u0006\u0003\u0013)\t1\u0001Z1p\u0015\u0005Y\u0011\u0001C!mKJ$\u0018N\\4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b$D\u0001\u0017\u0015\t9\u0002$A\u0002ba&T!!\u0007\u000e\u0002\u0011I\f'MY5u[FT!a\u0007\u000f\u0002\u000f\u0005\fX/Y:zg*\tQ$\u0001\u0002ge&\u0011qD\u0006\u0002\t!J|G-^2fe\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0002\u0015\u0003\u0003\u0015\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\r%t'.Z2u\u0015\u0005Q\u0013!\u00026bm\u0006D\u0018B\u0001\u0017(\u0005\u0019IeN[3di\u0006A1/\u001a8e\u001b\u0006LG\u000e\u0006\u00030e}\n\u0005CA\b1\u0013\t\t\u0004C\u0001\u0003V]&$\b\"B\u001a\u0003\u0001\u0004!\u0014!B3nC&d\u0007CA\u001b=\u001d\t1$\b\u0005\u00028!5\t\u0001H\u0003\u0002:\u0019\u00051AH]8pizJ!a\u000f\t\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wAAQ\u0001\u0011\u0002A\u0002Q\nqa];cU\u0016\u001cG\u000fC\u0003C\u0005\u0001\u0007A'A\u0004nKN\u001c\u0018mZ3\u0002\u001d\u001d,G/T1jY\u000e{g\u000e^3oiR9A'R$S3\u0002,\u0007\"\u0002$\u0004\u0001\u0004!\u0014\u0001D7bS2$V-\u001c9mCR,\u0007\"\u0002%\u0004\u0001\u0004I\u0015aB:uCRLwN\u001c\t\u0003\u0015Bk\u0011a\u0013\u0006\u0003\u00196\u000bQ!\\8eK2T!\u0001\u0013(\u000b\u0005=S\u0012!\u00023bK\u0006,\u0018BA)L\u00051\u0019F/\u0019;j_:d\u0015n\u001a5u\u0011\u0015\u00196\u00011\u0001U\u0003\u001diW-Y:ve\u0016\u0004\"!V,\u000e\u0003YS!\u0001\u0014\u0006\n\u0005a3&aB'fCN,(/\u001a\u0005\u00065\u000e\u0001\raW\u0001\ni\"\u0014Xm\u001d5pY\u0012\u0004\"\u0001\u00180\u000e\u0003uS!AW'\n\u0005}k&\u0001E*uCRLwN\u001c+ie\u0016\u001c\bn\u001c7e\u0011\u0015\t7\u00011\u0001c\u0003\u0015QwNY%e!\ty1-\u0003\u0002e!\t!Aj\u001c8h\u0011\u001517\u00011\u0001c\u00039QwNY#yK\u000e,H/[8o\u0013\u0012\fqcZ3u\u001b\u0006LGNT8NK\u0006\u001cXO]3D_:$XM\u001c;\u0015\u0011QJ'n[:vobDQA\u0012\u0003A\u0002QBQ\u0001\u0013\u0003A\u0002%CQ\u0001\u001c\u0003A\u00025\f1\u0002\\1ti6+\u0017m];sKB\u0019qB\u001c9\n\u0005=\u0004\"AB(qi&|g\u000e\u0005\u0002Kc&\u0011!o\u0013\u0002\f\u001b\u0016\f7/\u001e:f\t\u0006$X\rC\u0003u\t\u0001\u0007A'\u0001\bbaBd\u0017nY1uS>tWK\u001d7\t\u000bY$\u0001\u0019\u0001\u001b\u0002\u0019\u0011\fG/\u0019+za\u0016t\u0015-\\3\t\u000b\u0005$\u0001\u0019\u00012\t\u000b\u0019$\u0001\u0019\u00012)\u0005\u0001Q\bC\u0001\u0014|\u0013\taxEA\u0005TS:<G.\u001a;p]\u0002")
public class MailDao
implements Producer {
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        MailDao mailDao = this;
        synchronized (mailDao) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public void sendMail(String email, String subject, String message) {
        JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)subject, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"contact@aquasys.fr", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
        this.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
    }

    public String getMailContent(String mailTemplate, StationLight station, Measure measure, StationThreshold threshold, long jobId, long jobExecutionId) {
        String applicationUrl = (String)package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> "");
        return mailTemplate.replace("{code}", (CharSequence)station.code().get()).replace("{name}", (CharSequence)station.name().get()).replace("{townCode}", (CharSequence)station.townCode().getOrElse((Function0 & Serializable)() -> "")).replace("{city}", (CharSequence)station.city().getOrElse((Function0 & Serializable)() -> "")).replace("{thresholdTitle}", (CharSequence)threshold.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).replace("{thresholdValue}", Double.toString(ThresholdUtil$.MODULE$.getThresholdValue(threshold, new DateTime()))).replace("{lastMeasure}", Double.toString(measure.value())).replace("{dateLastMeasure}", measure.date().toString("dd/MM/yyyy HH:mm:ss")).replace("{stationType}", station.stationType()).replace("{applicationUrl}", applicationUrl).replace("{link}", new StringBuilder(26).append(applicationUrl).append("/#/import/").append(Long.toString(jobId)).append("?jobExecutionId=").append(Long.toString(jobExecutionId)).toString());
    }

    public String getMailNoMeasureContent(String mailTemplate, StationLight station, Option<MeasureDate> lastMeasure, String applicationUrl, String dataTypeName, long jobId, long jobExecutionId) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Option<MeasureDate> option = lastMeasure;
        if (option instanceof Some) {
            Some some = (Some)option;
            MeasureDate measureDate = (MeasureDate)some.value();
            tuple22 = new Tuple2((Object)measureDate.date().toString("dd/MM/yyyy HH:mm:ss"), (Object)Double.toString(measureDate.value()));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)"", (Object)"");
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String date = (String)tuple2._1();
        String value = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)date, (Object)value);
        String date2 = (String)tuple23._1();
        String value2 = (String)tuple23._2();
        if (!applicationUrl.isEmpty()) {
            return mailTemplate.replace("{code}", (CharSequence)station.code().get()).replace("{name}", (CharSequence)station.name().get()).replace("{townCode}", (CharSequence)station.townCode().getOrElse((Function0 & Serializable)() -> "")).replace("{city}", (CharSequence)station.city().getOrElse((Function0 & Serializable)() -> "")).replace("{stationType}", station.stationType()).replace("{applicationUrl}", applicationUrl).replace("{dateLastMeasure}", date2).replace("{lastMeasure}", value2).replace("{dataTypeName}", dataTypeName).replace("{link}", new StringBuilder(26).append(applicationUrl).append("/#/import/").append(Long.toString(jobId)).append("?jobExecutionId=").append(Long.toString(jobExecutionId)).toString());
        }
        return mailTemplate.replace("{code}", (CharSequence)station.code().get()).replace("{name}", (CharSequence)station.name().get()).replace("{townCode}", (CharSequence)station.townCode().getOrElse((Function0 & Serializable)() -> "")).replace("{city}", (CharSequence)station.city().getOrElse((Function0 & Serializable)() -> "")).replace("{stationType}", station.stationType()).replace("{dateLastMeasure}", date2).replace("{lastMeasure}", value2).replace("{dataTypeName}", dataTypeName);
    }

    @Inject
    public MailDao() {
        Producer.$init$((Producer)this);
    }
}

