/*
 * Decompiled with CFR 0.152.
 */
package Alerting.utils;

import Alerting.constants.AlertTypeContants$;
import Alerting.dao.rpc.MailDao;
import Alerting.model.Measure;
import Alerting.model.Measure$;
import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.domain.MeasureThresholdState;
import fr.aquasys.daeau.station.model.MeasureDate;
import fr.aquasys.daeau.station.model.StationLight;
import fr.aquasys.daeau.station.model.StationLight$;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import fr.aquasys.utils.ThresholdUtil$;
import fr.aquasys.utils.communication.MailUtils;
import fr.aquasys.utils.communication.SmsUtils;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t=g\u0001\u0002\u0011\"\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006YA\f\u0005\tu\u0001\u0011\t\u0011)A\u0006w!A1\t\u0001B\u0001B\u0003-A\t\u0003\u0005L\u0001\t\u0005\t\u0015a\u0003M\u0011!y\u0005A!A!\u0002\u0017\u0001\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b1B.\t\u000b\u0015\u0004A\u0011\u00014\t\u000fe\u0004!\u0019!C\u0001u\"9\u0011Q\u0002\u0001!\u0002\u0013Y\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!a%\u0001\t\u0003\t)\nC\u0004\u0002>\u0002!\t!a0\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAm\u0001\u0011%\u00111\u001c\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003CqAa%\u0001\t\u0003\u0011)\nC\u0004\u0003\u001e\u0002!\tAa(\t\u000f\t%\u0006\u0001\"\u0001\u0003,\"9!1\u0017\u0001\u0005\u0002\tU\u0006b\u0002B_\u0001\u0011\u0005!q\u0018\u0002\u000b\u00032,'\u000f^+uS2\u001c(B\u0001\u0012$\u0003\u0015)H/\u001b7t\u0015\u0005!\u0013\u0001C!mKJ$\u0018N\\4\u0004\u0001M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0005kRLGN\u0003\u00024i\u0005A!/\u00192cSRl\u0017O\u0003\u00026m\u00059\u0011-];bgf\u001c(\"A\u001c\u0002\u0005\u0019\u0014\u0018BA\u001d1\u0005\u001daunZ+uS2\fq!\\1jY\u0012\u000bw\u000e\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005\u0019!\u000f]2\u000b\u0005\u0001\u001b\u0013a\u00013b_&\u0011!)\u0010\u0002\b\u001b\u0006LG\u000eR1p\u0003!\u0019Xn]+uS2\u001c\bCA#J\u001b\u00051%BA$I\u00035\u0019w.\\7v]&\u001c\u0017\r^5p]*\u0011!\u0005N\u0005\u0003\u0015\u001a\u0013\u0001bU7t+RLGn]\u0001\n[\u0006LG.\u0016;jYN\u0004\"!R'\n\u000593%!C'bS2,F/\u001b7t\u0003I\u0019\u0018.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005ECV\"\u0001*\u000b\u0005M#\u0016aA5uM*\u0011QKV\u0001\u000fC\u0012l\u0017N\\5tiJ\fG/[8o\u0015\t9F'A\u0003eC\u0016\fW/\u0003\u0002Z%\n\u00112+[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p\u0003!!\u0017\r^1cCN,\u0007C\u0001/d\u001b\u0005i&B\u00010`\u0003\t!'M\u0003\u0002aC\u0006\u0019\u0011\r]5\u000b\u0003\t\fA\u0001\u001d7bs&\u0011A-\u0018\u0002\t\t\u0006$\u0018MY1tK\u00061A(\u001b8jiz\"\u0012a\u001a\u000b\bQ*\\G.\u001c8p!\tI\u0007!D\u0001\"\u0011\u0015is\u0001q\u0001/\u0011\u0015Qt\u0001q\u0001<\u0011\u0015\u0019u\u0001q\u0001E\u0011\u0015Yu\u0001q\u0001M\u0011\u0015yu\u0001q\u0001Q\u0011\u0015Qv\u0001q\u0001\\Q\t9\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u00061\u0011N\u001c6fGRT\u0011A^\u0001\u0006U\u00064\u0018\r_\u0005\u0003qN\u0014a!\u00138kK\u000e$\u0018\u0001\u00043je\u0016\u001cGo\u001c:z\u000b:4X#A>\u0011\u0007q\f9AD\u0002~\u0003\u0007\u0001\"A`\u0015\u000e\u0003}T1!!\u0001&\u0003\u0019a$o\\8u}%\u0019\u0011QA\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\rM#(/\u001b8h\u0015\r\t)!K\u0001\u000eI&\u0014Xm\u0019;pef,eN\u001e\u0011\u0002\u0019\u001d,G/T8eK2l\u0015-\u001b7\u0015\u0013m\f\u0019\"a\u0006\u0002\u001c\u0005\u0015\u0002BBA\u000b\u0015\u0001\u000710\u0001\tnC&dG+Z7qY\u0006$XMR5mK\"1\u0011\u0011\u0004\u0006A\u0002m\f1\u0003Z3gCVdG\u000fV3na2\fG/\u001a$jY\u0016Dq!!\b\u000b\u0001\u0004\ty\"\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0007!\n\t#C\u0002\u0002$%\u0012A\u0001T8oO\"1\u0011q\u0005\u0006A\u0002m\fAaY8eK\u0006i1/\u001a8e\u001b\u0006LG.\u00117feR$b\"!\f\u00024\u0005\u0015\u00131KA1\u0003o\nI\bE\u0002)\u0003_I1!!\r*\u0005\u0011)f.\u001b;\t\u000f\u0005U2\u00021\u0001\u00028\u000591\u000f^1uS>t\u0007\u0003BA\u001d\u0003\u0003j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003k1\u0016\u0002BA\"\u0003w\u0011Ab\u0015;bi&|g\u000eT5hQRDq!a\u0012\f\u0001\u0004\tI%A\u0004nK\u0006\u001cXO]3\u0011\t\u0005-\u0013qJ\u0007\u0003\u0003\u001bR1!!\u0010$\u0013\u0011\t\t&!\u0014\u0003\u000f5+\u0017m];sK\"9\u0011QK\u0006A\u0002\u0005]\u0013!\u0003;ie\u0016\u001c\bn\u001c7e!\u0011\tI&!\u0018\u000e\u0005\u0005m#\u0002BA+\u0003\u007fIA!a\u0018\u0002\\\t\u00012\u000b^1uS>tG\u000b\u001b:fg\"|G\u000e\u001a\u0005\b\u0003GZ\u0001\u0019AA3\u0003\u0019)W.Y5mgB)\u0011qMA9w:!\u0011\u0011NA7\u001d\rq\u00181N\u0005\u0002U%\u0019\u0011qN\u0015\u0002\u000fA\f7m[1hK&!\u00111OA;\u0005\r\u0019V-\u001d\u0006\u0004\u0003_J\u0003bBA\u000f\u0017\u0001\u0007\u0011q\u0004\u0005\b\u0003wZ\u0001\u0019AA\u0010\u0003\u0015QwNY%e\u0003M\u0019XM\u001c3NC&d7\t[1oO\u0016\fE.\u001a:u)A\ti#!!\u0002\u0004\u0006\u0015\u0015\u0011RAG\u0003\u001f\u000b\t\nC\u0004\u000261\u0001\r!a\u000e\t\u000f\u0005\u001dC\u00021\u0001\u0002J!9\u0011q\u0011\u0007A\u0002\u0005]\u0013\u0001D8mIRC'/Z:i_2$\u0007bBAF\u0019\u0001\u0007\u0011qK\u0001\r]\u0016<H\u000b\u001b:fg\"|G\u000e\u001a\u0005\b\u0003Gb\u0001\u0019AA3\u0011\u001d\ti\u0002\u0004a\u0001\u0003?Aq!a\u001f\r\u0001\u0004\ty\"A\ttK:$W*Y5m\u001d>lU-Y:ve\u0016$\u0002#!\f\u0002\u0018\u0006e\u0015\u0011VAV\u0003k\u000bI,a/\t\u000f\u0005UR\u00021\u0001\u00028!9\u00111T\u0007A\u0002\u0005u\u0015a\u00037bgRlU-Y:ve\u0016\u0004R\u0001KAP\u0003GK1!!)*\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011HAS\u0013\u0011\t9+a\u000f\u0003\u00175+\u0017m];sK\u0012\u000bG/\u001a\u0005\b\u0003Gj\u0001\u0019AA3\u0011\u001d\ti+\u0004a\u0001\u0003_\u000bA\u0003^5nK2KW.\u001b;NSN\u001c\u0018N\\4ECR\f\u0007c\u0001\u0015\u00022&\u0019\u00111W\u0015\u0003\u0007%sG\u000f\u0003\u0004\u000286\u0001\ra_\u0001\rI\u0006$\u0018\rV=qK:\u000bW.\u001a\u0005\b\u0003;i\u0001\u0019AA\u0010\u0011\u001d\tY(\u0004a\u0001\u0003?\t\u0001c]3oI6\u000b\u0017\u000e\\#oI\u0006cWM\u001d;\u0015\u001d\u00055\u0012\u0011YAb\u0003\u000b\f9-!3\u0002L\"9\u0011Q\u0007\bA\u0002\u0005]\u0002bBA$\u001d\u0001\u0007\u0011\u0011\n\u0005\b\u0003+r\u0001\u0019AA,\u0011\u001d\t\u0019G\u0004a\u0001\u0003KBq!!\b\u000f\u0001\u0004\ty\u0002C\u0004\u0002|9\u0001\r!a\b\u00023Q,7\u000f^'bS2$\u0006N]3tQ>dGm\u0014<fe\u001adwn\u001e\u000b\u0005\u0003[\t\t\u000eC\u0004\u0002d=\u0001\r!!\u001a\u0002#Q,7\u000f^'bS2tu.T3bgV\u0014X\r\u0006\u0003\u0002.\u0005]\u0007bBA2!\u0001\u0007\u0011QM\u0001\u0010O\u0016$X*Y5m)\u0016l\u0007\u000f\\1uKR!\u0011Q\\Au!\u0011\ty.!:\u000e\u0005\u0005\u0005(bAArS\u0005\u0011\u0011n\\\u0005\u0005\u0003O\f\tO\u0001\bCk\u001a4WM]3e'>,(oY3\t\r\u0005-\u0018\u00031\u0001|\u0003\r)(/[\u0001#Y><\u0017\t\\3si^\u000b'O\\5oON\u0004\u0006n\u001c8f\u001dVl'-\u001a:t\u000b6\f\u0017\u000e\\:\u0015\u0019\u00055\u0012\u0011_A{\u0003s\fY0a@\t\u000f\u0005M(\u00031\u0001\u0002f\u0005Q\u0011\r\\3siRK\b/Z:\t\u000f\u0005](\u00031\u0001\u0002f\u0005a\u0001\u000f[8oK:+XNY3sg\"9\u00111\r\nA\u0002\u0005\u0015\u0004bBA\u007f%\u0001\u0007\u0011qD\u0001\rU>\u0014W\t_3dkRLwN\u001c\u0005\u0007\u0005\u0003\u0011\u0002\u0019A>\u0002\u0013M$\u0018\r^5p]&#\u0017AG4fi>3XM\u001d:v]RC'/Z:i_2$W*Z:tC\u001e,GcA>\u0003\b!9\u0011QK\nA\u0002\u0005]\u0013\u0001D2iK\u000e\\W*Z1tkJ,G#B>\u0003\u000e\t=\u0001bBA+)\u0001\u0007\u0011q\u000b\u0005\b\u0005#!\u0002\u0019\u0001B\n\u00035a\u0017m\u001d;3\u001b\u0016\f7/\u001e:fgB1\u0011qMA9\u0003\u0013\nAcZ3u\u001b\u0006DH\u000b\u001b:fg\"|G\u000eZ!mKJ$H\u0003\u0002B\r\u00057\u0001R\u0001KAP\u0003/BqA!\b\u0016\u0001\u0004\u0011y\"\u0001\u0006uQJ,7\u000f[8mIN\u0004b!a\u001a\u0002r\t\u0005\u0002c\u0002\u0015\u0003$\u0005]#qE\u0005\u0004\u0005KI#A\u0002+va2,'\u0007E\u0002)\u0005SI1Aa\u000b*\u0005\u001d\u0011un\u001c7fC:\f\u0001c]3oI\u0006cWM\u001d;Ge>l'j\u001c2\u0015)\u00055\"\u0011\u0007B\u001a\u0005k\u00119D!\u000f\u0003<\tu\"q\bB!\u0011\u001d\t)D\u0006a\u0001\u0003oAq!!\b\u0017\u0001\u0004\ty\u0002C\u0004\u0002|Y\u0001\r!a\b\t\u000f\u0005Uc\u00031\u0001\u0002X!9\u00111\r\fA\u0002\u0005\u0015\u0004bBA|-\u0001\u0007\u0011Q\r\u0005\b\u0003g4\u0002\u0019AA3\u0011\u001d\t9E\u0006a\u0001\u0003\u0013BqAa\u0011\u0017\u0001\u0004\u0011y\"\u0001\u0007bY2tUm^!mKJ$8/\u0001\ftK:$7\t[1oO\u0016\fE.\u001a:u\rJ|WNS8c)Y\tiC!\u0013\u0003L\t5#q\nB)\u0005'\u0012)Fa\u0016\u0003Z\tm\u0003bBA\u001b/\u0001\u0007\u0011q\u0007\u0005\b\u0003;9\u0002\u0019AA\u0010\u0011\u001d\tYh\u0006a\u0001\u0003?Aq!a\"\u0018\u0001\u0004\t9\u0006C\u0004\u0002\f^\u0001\r!a\u0016\t\u000f\u0005\rt\u00031\u0001\u0002f!9\u0011q_\fA\u0002\u0005\u0015\u0004bBAz/\u0001\u0007\u0011Q\r\u0005\b\u0003\u000f:\u0002\u0019AA%\u0011\u001d\u0011\u0019e\u0006a\u0001\u0005?\t\u0011d]3oI\u0006cWM\u001d;O_6+\u0017m];sK\u001a\u0013x.\u001c&pER!\u0012Q\u0006B1\u0005G\u0012)Ga\u001a\u0003j\t-$Q\u000eB8\u0005gBq!!\u000e\u0019\u0001\u0004\t9\u0004C\u0004\u0002\u001cb\u0001\r!!(\t\u000f\u0005u\u0001\u00041\u0001\u0002 !9\u00111\u0010\rA\u0002\u0005}\u0001bBA21\u0001\u0007\u0011Q\r\u0005\b\u0003oD\u0002\u0019AA3\u0011\u001d\t\u0019\u0010\u0007a\u0001\u0003KBq!!,\u0019\u0001\u0004\u0011\t\bE\u0003)\u0003?\u000by\u000b\u0003\u0004\u00028b\u0001\ra_\u0001\u001cG2|7/Z#wK:$hj\\'fCN,(/Z%g\u000bbL7\u000f^:\u0015\u0011\u00055\"\u0011\u0010B>\u0005{Bq!!\u000e\u001a\u0001\u0004\t9\u0004C\u0004\u0002|e\u0001\r!a\b\t\u000f\u00055\u0016\u00041\u0001\u0003r\u0005\u00192/\u001a8e\u000b:$\u0017\t\\3si\u001a\u0013x.\u001c&pER\u0011\u0012Q\u0006BB\u0005\u000b\u00139I!#\u0003\f\n5%q\u0012BI\u0011\u001d\t)D\u0007a\u0001\u0003oAq!!\b\u001b\u0001\u0004\ty\u0002C\u0004\u0002|i\u0001\r!a\b\t\u000f\u0005U#\u00041\u0001\u0002X!9\u00111\r\u000eA\u0002\u0005\u0015\u0004bBAz5\u0001\u0007\u0011Q\r\u0005\b\u0003oT\u0002\u0019AA3\u0011\u001d\t9E\u0007a\u0001\u0003\u0013\na#\u001e9eCR,WI^3oiN<\u0016\u000e\u001e5BY\u0016\u0014Ho\u001d\u000b\t\u0003[\u00119J!'\u0003\u001c\"9\u0011QG\u000eA\u0002\u0005]\u0002bBA>7\u0001\u0007\u0011q\u0004\u0005\b\u0005\u0007Z\u0002\u0019\u0001B\u0010\u0003Y\u0019'/Z1uK\u00163XM\u001c;JM:{G/\u0012=jgR\u001cH\u0003CAX\u0005C\u0013\u0019K!*\t\u000f\u0005UB\u00041\u0001\u00028!9\u00111\u0010\u000fA\u0002\u0005}\u0001B\u0002BT9\u0001\u000710\u0001\u0007fm\u0016tGoU;cU\u0016\u001cG/\u0001\ndY>\u001cX-\u0012<f]RLe-\u0012=jgR\u001cH\u0003CAX\u0005[\u0013yK!-\t\u000f\u0005UR\u00041\u0001\u00028!9\u00111P\u000fA\u0002\u0005}\u0001B\u0002BT;\u0001\u000710A\u0007iCN\fE.\u001a:u\u000bZ,g\u000e\u001e\u000b\t\u0005O\u00119L!/\u0003<\"9\u0011Q\u0007\u0010A\u0002\u0005]\u0002bBA>=\u0001\u0007\u0011q\u0004\u0005\u0007\u0005Os\u0002\u0019A>\u0002!\u001d,G\u000fT1tiJjU-Y:ve\u0016\u001cHC\u0002B\n\u0005\u0003\u0014\u0019\rC\u0004\u00026}\u0001\r!a\u000e\t\u000f\t\u0015w\u00041\u0001\u00020\u00061A/\u001f9f\u0013\u0012D3\u0001\u0001Be!\r\u0011(1Z\u0005\u0004\u0005\u001b\u001c(!C*j]\u001edW\r^8o\u0001")
public class AlertUtils {
    private final MailDao mailDao;
    private final SmsUtils smsUtils;
    private final MailUtils mailUtils;
    private final SieauParametersDao sieauParametersDao;
    private final Database database;
    private final String directoryEnv;

    public String directoryEnv() {
        return this.directoryEnv;
    }

    public String getModelMail(String mailTemplateFile, String defaultTemplateFile, long jobExecutionId, String code) {
        if (new File(mailTemplateFile).exists()) {
            return mailTemplateFile;
        }
        JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(142).append("No model file found : using default model. If you are using a specific model, please check that your model has the exact name ").append(defaultTemplateFile).append(" respecting case").toString(), code);
        return this.getClass().getResource(new StringBuilder(1).append("/").append(defaultTemplateFile).toString()).toURI().toString().replace("file:", "");
    }

    public void sendMailAlert(StationLight station, Measure measure, StationThreshold threshold, Seq<String> emails, long jobExecutionId, long jobId) {
        String mailTemplateFile = new StringBuilder(27).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
            throw new Exception("UPLOAD_DIRECTORY is not in .env");
        })).append("MODELES/MAIL/alertMail.html").toString();
        String file = this.getModelMail(mailTemplateFile, "alertMail.html", jobExecutionId, (String)station.code().get());
        BufferedSource buffer = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        String mailTemplate = buffer.getLines().mkString("");
        String subject = new String(new StringBuilder(23).append("[").append(station.code().get()).append("] D\u00e9passement seuil ").append(station.stationType()).append(": ").append(threshold.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).toString().getBytes("UTF-8"), "UTF-8");
        String message = this.mailDao.getMailContent(mailTemplate, station, measure, threshold, jobId, jobExecutionId);
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
        buffer.close();
    }

    public void sendMailChangeAlert(StationLight station, Measure measure, StationThreshold oldThreshold, StationThreshold newThreshold, Seq<String> emails, long jobExecutionId, long jobId) {
        String mailTemplateFile = new StringBuilder(33).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
            throw new Exception("UPLOAD_DIRECTORY is not in .env");
        })).append("MODELES/MAIL/changeAlertMail.html").toString();
        String file = this.getModelMail(mailTemplateFile, "changeAlertMail.html", jobExecutionId, (String)station.code().get());
        BufferedSource buffer = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        String mailTemplate = buffer.getLines().mkString("");
        String subject = new String(new StringBuilder(35).append("[").append(station.code().get()).append("] Changement de statut d'Alerte ").append(station.stationType()).append(": ").append(newThreshold.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).toString().getBytes("UTF-8"), "UTF-8");
        String applicationUrl = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> "");
        String message = mailTemplate.replace("{code}", (CharSequence)station.code().get()).replace("{name}", (CharSequence)station.name().get()).replace("{townCode}", (CharSequence)station.townCode().getOrElse((Function0 & Serializable)() -> "")).replace("{city}", (CharSequence)station.city().getOrElse((Function0 & Serializable)() -> "")).replace("{oldThresholdTitle}", (CharSequence)oldThreshold.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).replace("{newThresholdTitle}", (CharSequence)newThreshold.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).replace("{thresholdValue}", newThreshold.value().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0).toString()).replace("{lastMeasure}", Double.toString(measure.value())).replace("{dateLastMeasure}", measure.date().toString("dd/MM/yyyy HH:mm:ss")).replace("{stationType}", station.stationType()).replace("{applicationUrl}", applicationUrl).replace("{link}", new StringBuilder(26).append(applicationUrl).append("/#/import/").append(Long.toString(jobId)).append("?jobExecutionId=").append(Long.toString(jobExecutionId)).toString());
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
        buffer.close();
    }

    public void sendMailNoMeasure(StationLight station, Option<MeasureDate> lastMeasure, Seq<String> emails, int timeLimitMissingData, String dataTypeName, long jobExecutionId, long jobId) {
        String mailTemplateFile = new StringBuilder(36).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
            throw new Exception("UPLOAD_DIRECTORY is not in .env");
        })).append("MODELES/MAIL/dataMissingMailUrl.html").toString();
        String applicationUrl = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> "");
        String file = this.getModelMail(mailTemplateFile, "dataMissingMailUrl.html", jobExecutionId, (String)station.code().get());
        BufferedSource buffer = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        String mailTemplate = buffer.getLines().mkString("");
        String message = this.mailDao.getMailNoMeasureContent(mailTemplate, station, lastMeasure, applicationUrl, dataTypeName, jobId, jobExecutionId);
        String subject = new String(new StringBuilder(42).append("[").append(station.code().get()).append("] ").append(station.name().get()).append(" - Aucune mesure depuis au moins ").append(timeLimitMissingData).append(" heure").append((Object)(timeLimitMissingData > 1 ? "s" : "")).toString().getBytes("UTF-8"), "UTF-8");
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
        buffer.close();
    }

    public void sendMailEndAlert(StationLight station, Measure measure, StationThreshold threshold, Seq<String> emails, long jobExecutionId, long jobId) {
        String mailTemplateFile = new StringBuilder(30).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
            throw new Exception("UPLOAD_DIRECTORY is not in .env");
        })).append("MODELES/MAIL/endAlertMail.html").toString();
        String file = this.getModelMail(mailTemplateFile, "endAlertMail.html", jobExecutionId, (String)station.code().get());
        BufferedSource buffer = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        String mailTemplate = buffer.getLines().mkString("");
        String message = this.mailDao.getMailContent(mailTemplate, station, measure, threshold, jobId, jobExecutionId);
        String subject = new StringBuilder(22).append("[").append(station.code().get()).append("] Retour \u00e0 la normale").toString();
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
        buffer.close();
    }

    public void testMailThresholdOverflow(Seq<String> emails) {
        String mailTemplateFile = new StringBuilder(27).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
            throw new Exception("UPLOAD_DIRECTORY is not in .env");
        })).append("MODELES/MAIL/alertMail.HTML").toString();
        BufferedSource buffer = new File(mailTemplateFile).exists() ? Source$.MODULE$.fromFile(mailTemplateFile, Codec$.MODULE$.fallbackSystemCodec()) : Source$.MODULE$.fromFile(this.getClass().getResource("/alertMail.html").toURI(), Codec$.MODULE$.fallbackSystemCodec());
        String message = buffer.getLines().mkString("");
        String subject = new String("Test d'alerte : D\u00e9passement seuil".getBytes("UTF-8"), "UTF-8");
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
        buffer.close();
    }

    public void testMailNoMeasure(Seq<String> emails) {
        String string;
        String applicationUrl;
        BufferedSource buffer;
        block3: {
            Tuple2 tuple2;
            block2: {
                String mailTemplateFile = new StringBuilder(36).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
                    throw new Exception("UPLOAD_DIRECTORY is not in .env");
                })).append("MODELES/MAIL/dataMissingMailUrl.html").toString();
                buffer = this.getMailTemplate("/dataMissingMailUrl.html");
                Tuple2 tuple22 = tuple2 = new File(mailTemplateFile).exists() ? new Tuple2((Object)Source$.MODULE$.fromFile(mailTemplateFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString(""), (Object)"") : new Tuple2((Object)buffer.getLines().mkString(""), scala.sys.package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> ""));
                if (tuple2 == null) break block2;
                String mailTemplate = (String)tuple2._1();
                applicationUrl = (String)tuple2._2();
                if (mailTemplate == null) break block2;
                string = mailTemplate;
                if (applicationUrl != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string2 = applicationUrl;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)string2);
        String mailTemplate = (String)tuple2._1();
        String applicationUrl2 = (String)tuple2._2();
        boolean x$1 = false;
        Some x$2 = new Some((Object)"Test");
        Some x$3 = new Some((Object)"nom test");
        String x$4 = "Hydro";
        Option x$5 = StationLight$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = StationLight$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = StationLight$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = StationLight$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = StationLight$.MODULE$.$lessinit$greater$default$9();
        String message = this.mailDao.getMailNoMeasureContent(mailTemplate, new StationLight(0, "Hydro", (Option)x$2, (Option)x$3, x$5, x$6, x$7, x$8, x$9), (Option<MeasureDate>)None$.MODULE$, applicationUrl2, "", 1L, 10L);
        String subject = new String("Test d'alerte : Absence de donn\u00e9es".getBytes("UTF-8"), "UTF-8");
        this.mailUtils.sendMail(emails, subject, message, this.mailUtils.sendMail$default$4(), this.mailUtils.sendMail$default$5(), this.mailUtils.sendMail$default$6(), this.mailUtils.sendMail$default$7());
        buffer.close();
    }

    private BufferedSource getMailTemplate(String uri) {
        return Source$.MODULE$.fromFile(this.getClass().getResource(uri).toURI(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public void logAlertWarningsPhoneNumbersEmails(Seq<String> alertTypes, Seq<String> phoneNumbers, Seq<String> emails, long jobExecution, String stationId) {
        boolean shouldLogEmail;
        boolean hasEmailAlert = alertTypes.contains((Object)AlertTypeContants$.MODULE$.ALERT_EMAIL());
        boolean hasSmsAlert = alertTypes.contains((Object)AlertTypeContants$.MODULE$.ALERT_SMS());
        boolean isSmsActive = this.sieauParametersDao.getValue("smsSettings").isDefined();
        boolean shouldLogSms = isSmsActive && hasSmsAlert && phoneNumbers.isEmpty();
        boolean bl = shouldLogEmail = hasEmailAlert && emails.isEmpty();
        if (shouldLogSms && shouldLogEmail) {
            JobLogUtil$.MODULE$.log(jobExecution, JobLogUtil$.MODULE$.WARNING(), "Empty email alert and empty phone number alert ", stationId);
            return;
        }
        if (shouldLogSms) {
            JobLogUtil$.MODULE$.log(jobExecution, JobLogUtil$.MODULE$.WARNING(), "Empty phone number alert - please enter at least one phone number", stationId);
            return;
        }
        if (shouldLogEmail) {
            JobLogUtil$.MODULE$.log(jobExecution, JobLogUtil$.MODULE$.WARNING(), "Empty email alert - please enter at least one email address", stationId);
            return;
        }
    }

    public String getOverrunThresholdMessage(StationThreshold threshold) {
        if (threshold.isOverrunThreshold().contains((Object)"1")) {
            return "Above threshold";
        }
        return "Below threshold";
    }

    public String checkMeasure(StationThreshold threshold, Seq<Measure> last2Measures) {
        if (last2Measures.length() <= 1) {
            return AlertTypeContants$.MODULE$.NOTHING();
        }
        MeasureThresholdState state1 = ThresholdUtil$.MODULE$.getMeasureThresholdState(((Measure)last2Measures.head()).value(), ((Measure)last2Measures.head()).date(), (Seq)new .colon.colon((Object)threshold, (List)Nil$.MODULE$));
        MeasureThresholdState state2 = ThresholdUtil$.MODULE$.getMeasureThresholdState(((Measure)last2Measures.last()).value(), ((Measure)last2Measures.last()).date(), (Seq)new .colon.colon((Object)threshold, (List)Nil$.MODULE$));
        if (state1.overrunThresholds().nonEmpty() && state2.overrunThresholds().nonEmpty()) {
            return AlertTypeContants$.MODULE$.ALERT();
        }
        if (state1.overrunThresholds().isEmpty() && state2.overrunThresholds().isEmpty()) {
            return AlertTypeContants$.MODULE$.NO_ALERT();
        }
        return AlertTypeContants$.MODULE$.NOTHING();
    }

    public Option<StationThreshold> getMaxThresholdAlert(Seq<Tuple2<StationThreshold, Object>> thresholds) {
        if (thresholds.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._2$mcZ$sp()))) {
            Seq depassement = (Seq)thresholds.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)AlertUtils.$anonfun$getMaxThresholdAlert$2(t)));
            return new Some(depassement.nonEmpty() ? ((Tuple2)depassement.maxBy((Function1 & Serializable)t -> BoxesRunTime.boxToDouble((double)ThresholdUtil$.MODULE$.getThresholdValue((StationThreshold)t._1(), new DateTime())), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._1() : ((Tuple2)((IterableOnceOps)thresholds.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3._2$mcZ$sp()))).minBy((Function1 & Serializable)t -> BoxesRunTime.boxToDouble((double)ThresholdUtil$.MODULE$.getThresholdValue((StationThreshold)t._1(), new DateTime())), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._1());
        }
        return None$.MODULE$;
    }

    public void sendAlertFromJob(StationLight station, long jobExecutionId, long jobId, StationThreshold threshold, Seq<String> emails, Seq<String> phoneNumbers, Seq<String> alertTypes, Measure measure, Seq<Tuple2<StationThreshold, Object>> allNewAlerts) {
        alertTypes.foreach((Function1 & Serializable)x0$1 -> {
            AlertUtils.$anonfun$sendAlertFromJob$1(this, emails, station, measure, threshold, jobExecutionId, jobId, phoneNumbers, x0$1);
            return BoxedUnit.UNIT;
        });
        this.updateEventsWithAlerts(station, jobId, allNewAlerts);
    }

    public void sendChangeAlertFromJob(StationLight station, long jobExecutionId, long jobId, StationThreshold oldThreshold, StationThreshold newThreshold, Seq<String> emails, Seq<String> phoneNumbers, Seq<String> alertTypes, Measure measure, Seq<Tuple2<StationThreshold, Object>> allNewAlerts) {
        alertTypes.foreach((Function1 & Serializable)x0$1 -> {
            AlertUtils.$anonfun$sendChangeAlertFromJob$1(this, emails, station, measure, oldThreshold, newThreshold, jobExecutionId, jobId, phoneNumbers, x0$1);
            return BoxedUnit.UNIT;
        });
        this.updateEventsWithAlerts(station, jobId, allNewAlerts);
    }

    public void sendAlertNoMeasureFromJob(StationLight station, Option<MeasureDate> lastMeasure, long jobExecutionId, long jobId, Seq<String> emails, Seq<String> phoneNumbers, Seq<String> alertTypes, Option<Object> timeLimitMissingData, String dataTypeName) {
        if (timeLimitMissingData.isDefined()) {
            alertTypes.foreach((Function1 & Serializable)x0$1 -> {
                AlertUtils.$anonfun$sendAlertNoMeasureFromJob$1(this, emails, station, lastMeasure, timeLimitMissingData, dataTypeName, jobExecutionId, jobId, phoneNumbers, x0$1);
                return BoxedUnit.UNIT;
            });
            this.createEventIfNotExists(station, jobId, new StringBuilder(16).append("MISSING_MEASURE_").append(timeLimitMissingData).toString());
            return;
        }
    }

    public void closeEventNoMeasureIfExists(StationLight station, long jobId, Option<Object> timeLimitMissingData) {
        if (timeLimitMissingData.isDefined()) {
            this.closeEventIfExists(station, jobId, new StringBuilder(16).append("MISSING_MEASURE_").append(timeLimitMissingData).toString());
            return;
        }
    }

    public void sendEndAlertFromJob(StationLight station, long jobExecutionId, long jobId, StationThreshold threshold, Seq<String> emails, Seq<String> alertTypes, Seq<String> phoneNumbers, Measure measure) {
        alertTypes.foreach((Function1 & Serializable)x0$1 -> {
            AlertUtils.$anonfun$sendEndAlertFromJob$1(this, emails, station, measure, threshold, jobExecutionId, jobId, phoneNumbers, x0$1);
            return BoxedUnit.UNIT;
        });
        this.updateEventsWithAlerts(station, jobId, (Seq<Tuple2<StationThreshold, Object>>)new .colon.colon((Object)new Tuple2((Object)threshold, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
    }

    public void updateEventsWithAlerts(StationLight station, long jobId, Seq<Tuple2<StationThreshold, Object>> allNewAlerts) {
        allNewAlerts.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AlertUtils.$anonfun$updateEventsWithAlerts$1(this, station, jobId, x0$1)));
    }

    public int createEventIfNotExists(StationLight station, long jobId, String eventSubject) {
        return BoxesRunTime.unboxToInt((Object)this.database.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)AlertUtils.$anonfun$createEventIfNotExists$1(station, eventSubject, jobId, c))));
    }

    public int closeEventIfExists(StationLight station, long jobId, String eventSubject) {
        return BoxesRunTime.unboxToInt((Object)this.database.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)AlertUtils.$anonfun$closeEventIfExists$1(station, eventSubject, jobId, c))));
    }

    public boolean hasAlertEvent(StationLight station, long jobId, String eventSubject) {
        return BoxesRunTime.unboxToBoolean((Object)this.database.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AlertUtils.$anonfun$hasAlertEvent$1(station, jobId, eventSubject, c))));
    }

    public Seq<Measure> getLast2Measures(StationLight station, int typeId) {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> {
            Tuple3 tuple3;
            String string = StationTypeUtil$.MODULE$.StationType(station.stationType());
            String string2 = StationTypeUtil$.MODULE$.HYDROMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                tuple3 = new Tuple3((Object)"chroniques_hydro", (Object)"codestation", (Object)"coalesce(valeurmesurecorrigee, valeurmesure)");
            } else {
                String string4 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    tuple3 = new Tuple3((Object)"chroniques_brutes", (Object)"codepiezometre", (Object)"coalesce(valeurngfcorrigee, valeurngf)");
                } else {
                    String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        tuple3 = new Tuple3((Object)"chroniques_pluvio", (Object)"codepluviometre", (Object)"coalesce(valeurmesurecorrigee, valeurmesure)");
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            String table = (String)tuple32._1();
            String codecolumn = (String)tuple32._2();
            String valueColumn = (String)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)table, (Object)codecolumn, (Object)valueColumn);
            String table2 = (String)tuple33._1();
            String codecolumn2 = (String)tuple33._2();
            String valueColumn2 = (String)tuple33._3();
            ParameterValue[] parameterValueArray = new ParameterValue[6];
            ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)valueColumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
            ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)table2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
            ToStatementPriority0.stringToStatement$ x$11 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)codecolumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
            ToStatementPriority0.intToStatement$ x$15 = ToStatement$.MODULE$.intToStatement();
            Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
            ToStatementPriority0.intToStatement$ x$19 = ToStatement$.MODULE$.intToStatement();
            Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
            ToStatementPriority0.stringToStatement$ x$23 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)valueColumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$23));
            List resMeasures = (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select datemesure, #", " from #", " where #", " = ", " and typeid = ", " and #", " notnull and datemesure <= now() order by datemesure desc limit 2"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(Measure$.MODULE$.parser().$times(), c);
            if (resMeasures.length() < 2) {
                return (Seq)Nil$.MODULE$;
            }
            return resMeasures;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMaxThresholdAlert$2(Tuple2 t) {
        return ((StationThreshold)t._1()).isOverrunThreshold().contains((Object)"1") && t._2$mcZ$sp();
    }

    public static final /* synthetic */ void $anonfun$sendAlertFromJob$1(AlertUtils $this, Seq emails$1, StationLight station$1, Measure measure$1, StationThreshold threshold$1, long jobExecutionId$1, long jobId$1, Seq phoneNumbers$1, String x0$1) {
        String string = x0$1;
        String string2 = AlertTypeContants$.MODULE$.ALERT_EMAIL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (emails$1.nonEmpty()) {
                $this.sendMailAlert(station$1, measure$1, threshold$1, (Seq<String>)emails$1, jobExecutionId$1, jobId$1);
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(16).append("Email sent to : ").append(emails$1).toString(), (String)station$1.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.INFO(), "No emails to send", (String)station$1.code().get());
            return;
        }
        String string4 = AlertTypeContants$.MODULE$.ALERT_SMS();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            if (phoneNumbers$1.nonEmpty()) {
                String smsMessage = new StringBuilder(56).append("AcycliQ by Aquasys : [").append(station$1.code().get()).append("] ").append(station$1.name().get()).append(" - D\u00e9passement seuil ").append(station$1.stationType()).append(": ").append(threshold$1.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).append(" - Le ").append(measure$1.date().toString("dd/MM/yyyy HH:mm:ss")).append(" : ").append(measure$1.value()).toString();
                Seq x$1 = phoneNumbers$1;
                String x$2 = smsMessage;
                Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1));
                Option x$4 = $this.smsUtils.sendSms$default$3();
                Option x$5 = $this.smsUtils.sendSms$default$4();
                $this.smsUtils.sendSms(x$1, x$2, x$4, x$5, (Option)x$3);
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobLogUtil$.MODULE$.INFO(), new StringBuilder(27).append("SMS successfully sent to : ").append(phoneNumbers$1.mkString(", ")).toString(), (String)station$1.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.INFO(), "No sms to send", (String)station$1.code().get());
            return;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ void $anonfun$sendChangeAlertFromJob$1(AlertUtils $this, Seq emails$2, StationLight station$2, Measure measure$2, StationThreshold oldThreshold$1, StationThreshold newThreshold$1, long jobExecutionId$2, long jobId$2, Seq phoneNumbers$2, String x0$1) {
        String string = x0$1;
        String string2 = AlertTypeContants$.MODULE$.ALERT_EMAIL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (emails$2.nonEmpty()) {
                $this.sendMailChangeAlert(station$2, measure$2, oldThreshold$1, newThreshold$1, (Seq<String>)emails$2, jobExecutionId$2, jobId$2);
                JobLogUtil$.MODULE$.log(jobExecutionId$2, JobState$.MODULE$.INFO(), new StringBuilder(16).append("Email sent to : ").append(emails$2).toString(), (String)station$2.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$2, JobState$.MODULE$.INFO(), "No emails to send", (String)station$2.code().get());
            return;
        }
        String string4 = AlertTypeContants$.MODULE$.ALERT_SMS();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            if (phoneNumbers$2.nonEmpty()) {
                String smsMessage = new StringBuilder(68).append("AcycliQ by Aquasys : [").append(station$2.code().get()).append("] ").append(station$2.name().get()).append(" - Changement de statut d'alerte ").append(station$2.stationType()).append(": ").append(newThreshold$1.name().getOrElse((Function0 & Serializable)() -> "<Seuil sans nom>")).append(" - Le ").append(measure$2.date().toString("dd/MM/yyyy HH:mm:ss")).append(" : ").append(measure$2.value()).toString();
                Seq x$1 = phoneNumbers$2;
                String x$2 = smsMessage;
                Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$2));
                Option x$4 = $this.smsUtils.sendSms$default$3();
                Option x$5 = $this.smsUtils.sendSms$default$4();
                $this.smsUtils.sendSms(x$1, x$2, x$4, x$5, (Option)x$3);
                JobLogUtil$.MODULE$.log(jobExecutionId$2, JobLogUtil$.MODULE$.INFO(), new StringBuilder(27).append("SMS successfully sent to : ").append(phoneNumbers$2.mkString(", ")).toString(), (String)station$2.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$2, JobState$.MODULE$.INFO(), "No sms to send", (String)station$2.code().get());
            return;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ void $anonfun$sendAlertNoMeasureFromJob$1(AlertUtils $this, Seq emails$3, StationLight station$3, Option lastMeasure$1, Option timeLimitMissingData$1, String dataTypeName$1, long jobExecutionId$3, long jobId$3, Seq phoneNumbers$3, String x0$1) {
        String string = x0$1;
        String string2 = AlertTypeContants$.MODULE$.ALERT_EMAIL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (emails$3.nonEmpty()) {
                $this.sendMailNoMeasure(station$3, (Option<MeasureDate>)lastMeasure$1, (Seq<String>)emails$3, BoxesRunTime.unboxToInt((Object)timeLimitMissingData$1.get()), dataTypeName$1, jobExecutionId$3, jobId$3);
                JobLogUtil$.MODULE$.log(jobExecutionId$3, JobState$.MODULE$.INFO(), new StringBuilder(16).append("Email sent to : ").append(emails$3).toString(), (String)station$3.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$3, JobState$.MODULE$.INFO(), "No emails to send", (String)station$3.code().get());
            return;
        }
        String string4 = AlertTypeContants$.MODULE$.ALERT_SMS();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            if (phoneNumbers$3.nonEmpty()) {
                String smsMessage = new StringBuilder(63).append("acycliQ by Aquasys : [").append(station$3.code().get()).append("] ").append(station$3.name().get()).append(" - Aucune mesure depuis au moins ").append(timeLimitMissingData$1.get()).append(" heure").append((Object)(BoxesRunTime.unboxToInt((Object)timeLimitMissingData$1.get()) > 1 ? "s" : "")).toString();
                Seq x$1 = phoneNumbers$3;
                String x$2 = smsMessage;
                Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$3));
                Option x$4 = $this.smsUtils.sendSms$default$3();
                Option x$5 = $this.smsUtils.sendSms$default$4();
                $this.smsUtils.sendSms(x$1, x$2, x$4, x$5, (Option)x$3);
                JobLogUtil$.MODULE$.log(jobExecutionId$3, JobLogUtil$.MODULE$.INFO(), new StringBuilder(27).append("SMS successfully sent to : ").append(phoneNumbers$3.mkString(", ")).toString(), (String)station$3.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$3, JobState$.MODULE$.INFO(), "No sms to send", (String)station$3.code().get());
            return;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ void $anonfun$sendEndAlertFromJob$1(AlertUtils $this, Seq emails$4, StationLight station$4, Measure measure$3, StationThreshold threshold$2, long jobExecutionId$4, long jobId$4, Seq phoneNumbers$4, String x0$1) {
        String string = x0$1;
        String string2 = AlertTypeContants$.MODULE$.ALERT_EMAIL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (emails$4.nonEmpty()) {
                $this.sendMailEndAlert(station$4, measure$3, threshold$2, (Seq<String>)emails$4, jobExecutionId$4, jobId$4);
                JobLogUtil$.MODULE$.log(jobExecutionId$4, JobState$.MODULE$.INFO(), new StringBuilder(16).append("Email sent to : ").append(emails$4).toString(), (String)station$4.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$4, JobState$.MODULE$.INFO(), "No emails to send", (String)station$4.code().get());
            return;
        }
        String string4 = AlertTypeContants$.MODULE$.ALERT_SMS();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            if (phoneNumbers$4.nonEmpty()) {
                String smsMessage = new StringBuilder(46).append("acycliQ by Aquasys : [").append(station$4.code().get()).append("] ").append(station$4.name().get()).append(" - Retour \u00e0 la normale").toString();
                Seq x$1 = phoneNumbers$4;
                String x$2 = smsMessage;
                Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$4));
                Option x$4 = $this.smsUtils.sendSms$default$3();
                Option x$5 = $this.smsUtils.sendSms$default$4();
                $this.smsUtils.sendSms(x$1, x$2, x$4, x$5, (Option)x$3);
                JobLogUtil$.MODULE$.log(jobExecutionId$4, JobLogUtil$.MODULE$.INFO(), new StringBuilder(27).append("SMS successfully sent to : ").append(phoneNumbers$4.mkString(", ")).toString(), (String)station$4.code().get());
                return;
            }
            JobLogUtil$.MODULE$.log(jobExecutionId$4, JobState$.MODULE$.INFO(), "No sms to send", (String)station$4.code().get());
            return;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ int $anonfun$updateEventsWithAlerts$1(AlertUtils $this, StationLight station$5, long jobId$5, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StationThreshold threshold = (StationThreshold)tuple2._1();
            boolean isAlert = tuple2._2$mcZ$sp();
            if (isAlert) {
                return $this.createEventIfNotExists(station$5, jobId$5, new StringBuilder(10).append("THRESHOLD_").append((int)BoxesRunTime.unboxToDouble((Object)threshold.id().get())).toString());
            }
            return $this.closeEventIfExists(station$5, jobId$5, new StringBuilder(10).append("THRESHOLD_").append((int)BoxesRunTime.unboxToDouble((Object)threshold.id().get())).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$createEventIfNotExists$1(StationLight station$6, String eventSubject$1, long jobId$6, Connection c) {
        Tuple2 tuple2;
        String string = StationTypeUtil$.MODULE$.StationType(station$6.stationType());
        String string2 = StationTypeUtil$.MODULE$.HYDROMETRY();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = new Tuple2((Object)"evenements_hydro", (Object)"codestation");
        } else {
            String string4 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2 = new Tuple2((Object)"evenements", (Object)"codepiezometre");
            } else {
                String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2 = new Tuple2((Object)"evenements_pluvio", (Object)"codepluviometre");
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String table = (String)tuple22._1();
        String codecolumn = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)table, (Object)codecolumn);
        String table2 = (String)tuple23._1();
        String codecolumn2 = (String)tuple23._2();
        ParameterValue[] parameterValueArray = new ParameterValue[5];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)table2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)codecolumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station$6.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)eventSubject$1, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
        ToStatementPriority0.stringToStatement$ x$21 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$22 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)new StringBuilder(4).append("job_").append(jobId$6).toString(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$21));
        boolean eventExists = BoxesRunTime.unboxToBoolean((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select true from #", " where #", "=", " and probleme=", " and datecloture is null and loginmaj=", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToBoolean()).singleOpt(), c)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        if (!eventExists) {
            ParameterValue[] parameterValueArray2 = new ParameterValue[3];
            ToStatementPriority0.stringToStatement$ x$25 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$26 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray2[0] = ParameterValue$.MODULE$.from((Object)table2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$25));
            ToStatementPriority0.stringToStatement$ x$29 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$30 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray2[1] = ParameterValue$.MODULE$.from((Object)codecolumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$29));
            ToStatementPriority0.intToStatement$ x$33 = ToStatement$.MODULE$.intToStatement();
            Null$ x$34 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray2[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station$6.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$33));
            double number = BoxesRunTime.unboxToDouble((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select coalesce(max(numero),0) from #", " where #", "=", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray2)).as(SqlParser$.MODULE$.double("coalesce", Column$.MODULE$.columnToDouble()).single(), c)) + 1.0;
            Date date = DateTime.now().toDate();
            ParameterValue[] parameterValueArray3 = new ParameterValue[10];
            ToStatementPriority0.stringToStatement$ x$37 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$38 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[0] = ParameterValue$.MODULE$.from((Object)table2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$37));
            ToStatementPriority0.stringToStatement$ x$41 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$42 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[1] = ParameterValue$.MODULE$.from((Object)codecolumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$41));
            ToStatementPriority0.intToStatement$ x$45 = ToStatement$.MODULE$.intToStatement();
            Null$ x$46 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station$6.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$45));
            ToStatementPriority0.doubleToStatement$ x$49 = ToStatement$.MODULE$.doubleToStatement();
            Null$ x$50 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[3] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)number), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$49));
            ToStatementPriority0.dateToStatement$ x$53 = ToStatement$.MODULE$.dateToStatement();
            Null$ x$54 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[4] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$53));
            ToStatementPriority0.dateToStatement$ x$57 = ToStatement$.MODULE$.dateToStatement();
            Null$ x$58 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[5] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$57));
            ToStatementPriority0.stringToStatement$ x$61 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$62 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[6] = ParameterValue$.MODULE$.from((Object)"T", ToParameterValue$.MODULE$.apply(null, (ToStatement)x$61));
            ToStatementPriority0.stringToStatement$ x$65 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$66 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[7] = ParameterValue$.MODULE$.from((Object)eventSubject$1, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$65));
            ToStatementPriority0.dateToStatement$ x$69 = ToStatement$.MODULE$.dateToStatement();
            Null$ x$70 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[8] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$69));
            ToStatementPriority0.stringToStatement$ x$75 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$76 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray3[9] = ParameterValue$.MODULE$.from((Object)new StringBuilder(4).append("job_").append(jobId$6).toString(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$75));
            return package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO #", " (\n                #", ",\n                numero,\n                dateevenement,\n                heureevenement,\n                type,\n                probleme,\n                datemaj,\n                loginmaj) VALUES (\n                ", ",\n                ", ",\n                ", ",\n                ", ",\n                ", ",\n                ", ",\n                ", ",\n                ", ")"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray3)).executeUpdate(c);
        }
        return 0;
    }

    public static final /* synthetic */ int $anonfun$closeEventIfExists$1(StationLight station$7, String eventSubject$2, long jobId$7, Connection c) {
        Tuple2 tuple2;
        String string = StationTypeUtil$.MODULE$.StationType(station$7.stationType());
        String string2 = StationTypeUtil$.MODULE$.HYDROMETRY();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = new Tuple2((Object)"evenements_hydro", (Object)"codestation");
        } else {
            String string4 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2 = new Tuple2((Object)"evenements", (Object)"codepiezometre");
            } else {
                String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2 = new Tuple2((Object)"evenements_pluvio", (Object)"codepluviometre");
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String table = (String)tuple22._1();
        String codecolumn = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)table, (Object)codecolumn);
        String table2 = (String)tuple23._1();
        String codecolumn2 = (String)tuple23._2();
        ParameterValue[] parameterValueArray = new ParameterValue[7];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)table2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.dateToStatement$ x$7 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)DateTime.now().toDate(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.dateToStatement$ x$11 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)DateTime.now().toDate(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)codecolumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
        ToStatementPriority0.intToStatement$ x$19 = ToStatement$.MODULE$.intToStatement();
        Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station$7.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
        ToStatementPriority0.stringToStatement$ x$23 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)eventSubject$2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$23));
        ToStatementPriority0.stringToStatement$ x$29 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$30 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[6] = ParameterValue$.MODULE$.from((Object)new StringBuilder(4).append("job_").append(jobId$7).toString(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$29));
        return package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE #", " SET datecloture=", ", datemaj=", " WHERE #", "=", " and probleme=", " and datecloture is null and loginmaj=", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
    }

    public static final /* synthetic */ boolean $anonfun$hasAlertEvent$1(StationLight station$8, long jobId$8, String eventSubject$3, Connection c) {
        Tuple2 tuple2;
        String string = StationTypeUtil$.MODULE$.StationType(station$8.stationType());
        String string2 = StationTypeUtil$.MODULE$.HYDROMETRY();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = new Tuple2((Object)"evenements_hydro", (Object)"codestation");
        } else {
            String string4 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2 = new Tuple2((Object)"evenements", (Object)"codepiezometre");
            } else {
                String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2 = new Tuple2((Object)"evenements_pluvio", (Object)"codepluviometre");
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String table = (String)tuple22._1();
        String codecolumn = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)table, (Object)codecolumn);
        String table2 = (String)tuple23._1();
        String codecolumn2 = (String)tuple23._2();
        ParameterValue[] parameterValueArray = new ParameterValue[5];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)table2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)codecolumn2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)station$8.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToStatementPriority0.longToStatement$ x$15 = ToStatement$.MODULE$.longToStatement();
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToLong((long)jobId$8), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
        ToStatementPriority0.stringToStatement$ x$19 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)eventSubject$3, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
        return ((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select true from #", " where #", "=", " and loginmaj='job_#", "' and type='T'\n                   and probleme=", " and datecloture is null order by dateevenement desc, heureevenement desc limit 1\n             "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToBoolean()).singleOpt(), c)).contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Inject
    public AlertUtils(LogUtil logUtil, MailDao mailDao, SmsUtils smsUtils, MailUtils mailUtils, SieauParametersDao sieauParametersDao, Database database) {
        this.mailDao = mailDao;
        this.smsUtils = smsUtils;
        this.mailUtils = mailUtils;
        this.sieauParametersDao = sieauParametersDao;
        this.database = database;
        this.directoryEnv = "UPLOAD_DIRECTORY";
    }
}

